(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     95159,       3136]
NotebookOptionsPosition[     79940,       2598]
NotebookOutlinePosition[     81328,       2637]
CellTagsIndexPosition[     81242,       2632]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Relational and Logical Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RelationalAndLogicalOperators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Relational and Logical Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GreaterEqual" :> 
          Documentation`HelpLookup["paclet:ref/GreaterEqual"], "Less" :> 
          Documentation`HelpLookup["paclet:ref/Less"], "Positive" :> 
          Documentation`HelpLookup["paclet:ref/Positive"], "Element" :> 
          Documentation`HelpLookup["paclet:ref/Element"], "RegionPlot" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot"], "RegionPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot3D"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GreaterEqual\"\>", 
       2->"\<\"Less\"\>", 3->"\<\"Positive\"\>", 4->"\<\"Element\"\>", 
       5->"\<\"RegionPlot\"\>", 
       6->"\<\"RegionPlot3D\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inequalities" :> 
          Documentation`HelpLookup["paclet:guide/Inequalities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Inequalities\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Greater ",
 StyleBox["(>)", "OperatorCharacter"]
}], "ObjectName",
 CellID->4667],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ">", 
       StyleBox["y", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " is determined to be greater than ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ">", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ">", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["3", "TR"]]}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
     " form a strictly decreasing sequence. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->403]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Greater",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Greater"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " when its arguments are real numbers. "
}], "Notes",
 CellID->18367],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Greater",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Greater"]], "InlineFormula"],
 " does some simplification when its arguments are not numbers. "
}], "Notes",
 CellID->18899],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["Greater",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Greater"]], "InlineFormula"],
 " internally uses numerical approximations to establish numerical ordering. \
This process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21054]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->536006117],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->52823775],

Cell["Compare numbers:", "ExampleText",
 CellID->414328301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", ">", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107391370],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->408810099]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "/", "17"}], ">", 
  RowBox[{"1", "/", "5"}], ">", 
  RowBox[{"Pi", "/", "10"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->765975626],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5578176]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->179667355],

Cell["Represent an inequality:", "ExampleText",
 CellID->42591990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "3"}], "-", 
   RowBox[{"2", "x"}], "+", "1"}], ">", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->402385732],

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "-", 
   RowBox[{"2", " ", "x"}], "+", 
   SuperscriptBox["x", "3"]}], ">", "0"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->580946]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34392874],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox["5"]}], ")"}]}], "<", "x", "<", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["5"]}], ")"}]}]}], "||", 
  RowBox[{"x", ">", "1"}]}]], "Output",
 ImageSize->{246, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->165155323]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->249696463],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Numeric Inequalities",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->26431756],

Cell["Inequalities are defined only for real numbers:", "ExampleText",
 CellID->96088816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I", ">", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251460291],

Cell[BoxData[
 RowBox[{
  RowBox[{"Greater", "::", "\<\"nord\"\>"}], ":", 
  " ", "\<\"Invalid comparison with \\!\\(\[ImaginaryI]\\) attempted. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/nord\\\", \
ButtonNote -> \\\"Greater::nord\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->462430727],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", ">", "0"}]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->337595726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->661547383],

Cell["Compare rational numbers:", "ExampleText",
 CellID->234143528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"3", "/", "2"}], ">", 
  RowBox[{"4", "/", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241292235],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->733323689]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->425405628],

Cell["\<\
Approximate numbers that differ in at most their last eight binary digits are \
considered equal:\
\>", "ExampleText",
 CellID->580861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", ">", 
  RowBox[{"1.", "-", 
   RowBox[{
    RowBox[{"2", "^", "7"}], " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "16"}]}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37738947],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->185546314]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", ">", 
  RowBox[{"1.", "-", 
   RowBox[{
    RowBox[{"2", "^", "8"}], " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "16"}]}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->525645198],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->750402]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16182603],

Cell["\<\
Compare an exact numeric expression and an approximate number:\
\>", "ExampleText",
 CellID->314603207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "20"}], "]"}], ">", "Pi"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315310371],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125129083]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "20"}], "]"}], ">", 
  RowBox[{"Pi", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{
      RowBox[{"2", "^", "8"}], " ", 
      RowBox[{"10", "^", 
       RowBox[{"-", "20"}]}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331846797],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->190374951]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->691680788],

Cell["\<\
Compare two exact numeric expressions; a numeric test may suffice to prove \
inequality:\
\>", "ExampleText",
 CellID->128181167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"E", "^", "Pi"}], ">", 
  RowBox[{"Pi", "^", "E"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398884990],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161009841]
}, Open  ]],

Cell["Proving this inequality requires symbolic methods:", "ExampleText",
 CellID->207797078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], ">", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"5", "+", 
    RowBox[{"2", 
     RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142094998],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->506648366]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->239611855],

Cell[TextData[{
 "Symbolic and numeric methods used by ",
 Cell[BoxData[
  ButtonBox["Greater",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Greater"]], "InlineFormula"],
 " are insufficient to disprove this inequality:"
}], "ExampleText",
 CellID->135341977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], ">", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "4"}], "-", 
      RowBox[{"10", 
       RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180221533],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\@2 + \\@3 - \\(\\(Root[\\(\\(\\(\\(\\(\\(1 - \
\\(\\(10\\\\ \\(Slot[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\)\\) + #1\\^4\\)\\) &\\)\\), 4, \
0\\)\\)]\\)\\)\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\
\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->165470705],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], ">", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]], "Output",
 ImageSize->{238, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104099836]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " to decide the sign of algebraic numbers:"
}], "ExampleText",
 CellID->299920545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RootReduce", "[", 
   RowBox[{
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "-", 
    RowBox[{"%", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ">", "0"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->195979928],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->198076728]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->498468165],

Cell[TextData[{
 "Numeric methods used by ",
 Cell[BoxData[
  ButtonBox["Greater",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Greater"]], "InlineFormula"],
 " do not use sufficient precision to prove this inequality:"
}], "ExampleText",
 CellID->192423184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], ">", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "4"}], "-", 
       RowBox[{"10", 
        RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], "]"}], "-", 
   
   RowBox[{"10", "^", 
    RowBox[{"-", "100"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1546846],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(1\\/\\(10000000000000000000000 \\(\\(\
\[LeftSkeleton] 54 \[RightSkeleton]\\)\\) 000000000000000000000000\\) + \\@2 \
+ \\@3 - \\(\\(Root[\\(\\(\\(\\(\\(\\(1 - \\(\\(10\\\\ \\(Slot[\\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\^2\\)\\) + #1\\^4\\)\\) \
&\\)\\), 4, 0\\)\\)]\\)\\)\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->127616676],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], ">", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{
    "1", "/", 
     "100000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000"}]}], "+", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]}]], "Output",
 ImageSize->{564, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->375604723]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " proves the inequality using exact methods:"
}], "ExampleText",
 CellID->384720156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RootReduce", "[", 
   RowBox[{
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "-", 
    RowBox[{"%", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ">", "0"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->476886642],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20907343]
}, Open  ]],

Cell[TextData[{
 "Increasing ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " may also prove the inequality:"
}], "ExampleText",
 CellID->321641904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "100"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], ">", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"#", "^", "4"}], "-", 
         RowBox[{"10", 
          RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], "]"}], 
     "-", 
     RowBox[{"10", "^", 
      RowBox[{"-", "100"}]}]}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1018235179],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->177783357]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Symbolic Inequalities",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->500815976],

Cell[TextData[{
 "Symbolic inequalities remain unevaluated, since ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " may not be a real number:"
}], "ExampleText",
 CellID->152622296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", ">", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148403671],

Cell[BoxData[
 RowBox[{"x", ">", "x"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235669964]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " to re-evaluate the inequality assuming that ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is real:"
}], "ExampleText",
 CellID->198785255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Reals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->205622433],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->675905583]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60153346],

Cell["A symbolic inequality:", "ExampleText",
 CellID->26754974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ineq", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"y", "^", "2"}]}], ">", "1"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->486416913],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "2"], "-", 
   SuperscriptBox["y", "2"]}], ">", "1"}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->511023201]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to find an explicit description of the solution set:"
}], "ExampleText",
 CellID->58238363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"ineq", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145270882],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", ">", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{475, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->258608324]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find a solution instance:"
}], "ExampleText",
 CellID->220870228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{"ineq", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->159052583],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     SqrtBox["3"]}], ",", 
    RowBox[{"y", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{121, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->32338784]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " to optimize over the inequality-defined region:"
}], "ExampleText",
 CellID->279307693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", "ineq"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->34810484],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"wksol\"\>"}], ":", 
  " ", "\<\"Warning: There is no minimum in the region described by the \
constraints; returning a result on the boundary. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Minimize/wksol\\\", ButtonNote -> \
\\\"Minimize::wksol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->93558989],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->213223198]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " to simplify under the inequality defined assumptions:"
}], "ExampleText",
 CellID->266015669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}], "]"}], ",", "ineq"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->450815041],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->41874376]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->108974605],

Cell[TextData[{
 "The negation of two-argument ",
 Cell[BoxData[
  ButtonBox["Greater",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Greater"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["LessEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LessEqual"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14000026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"x", ">", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->785552779],

Cell[BoxData[
 RowBox[{"x", "\[LessEqual]", "y"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46898]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->646462098],

Cell[TextData[{
 "The negation of three-argument ",
 Cell[BoxData[
  ButtonBox["Greater",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Greater"]], "InlineFormula"],
 " does not simplify automatically:"
}], "ExampleText",
 CellID->179461278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"x", ">", "y", ">", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->900203775],

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"x", ">", "y", ">", "z"}]}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135920944]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to express the negation in terms of two-argument ",
 Cell[BoxData[
  ButtonBox["LessEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LessEqual"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->103307650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->602057068],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[LessEqual]", "y"}], "||", 
  RowBox[{"y", "\[LessEqual]", "z"}]}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->379461620]
}, Open  ]],

Cell[TextData[{
 "This is not equivalent to three-argument ",
 Cell[BoxData[
  ButtonBox["LessEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LessEqual"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22272967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"x", "\[LessEqual]", "y", "\[LessEqual]", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->41719149],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[LessEqual]", "y"}], "&&", 
  RowBox[{"y", "\[LessEqual]", "z"}]}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->184653005]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->66212984],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["Greater",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Greater"]], "InlineFormula"],
 " cannot decide inequality between numeric expressions it returns \
unchanged:"
}], "ExampleText",
 CellID->294478095],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"5", "+", 
      RowBox[{"2", 
       RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}], "/", "2"}]}], 
  ";"}], "\n", 
 RowBox[{"a", ">", "b"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->174240470],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\(\\(Log[\\(\\(\\@2 + \\@3\\)\\)]\\)\\) - \\(\
\\(1\\/2\\\\ \\(\\(Log[\\(\\(5 + \\(\\(2\\\\ \
\\@6\\)\\)\\)\\)]\\)\\)\\)\\)\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->217597421],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}], "]"}], ">", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", " ", 
      SqrtBox["6"]}]}], "]"}]}]}]], "Output",
 ImageSize->{216, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->544551866]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " uses exact symbolic transformations to disprove the inequality:"
}], "ExampleText",
 CellID->631563206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106030961],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->410889573]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141984053],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Positive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Positive"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "\[Element]", 
     TagBox["\[DoubleStruckCapitalR]",
      Function[{}, Reals]]}], "\[And]", 
    RowBox[{"x", ">", "0"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->265821182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Positive", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "I"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->875674151],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "False", ",", "True", ",", "False"}], "}"}]], "Output",\

 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7657560]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->263835271],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to solve inequalities:"
}], "ExampleText",
 CellID->107059385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"3", "x"}], "+", "2"}], ">", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->821314495],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", "#1", "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], "<", "x", "<", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", "#1", "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "||", 
  RowBox[{"x", ">", "1"}]}]], "Output",
 ImageSize->{504, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->334492512]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], ">", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23944515],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "\[Element]", "Reals"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", 
     RowBox[{"-", "1"}]}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "\[LessEqual]", "x", "\[LessEqual]", "1"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "<", 
         RowBox[{"-", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["x", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["x", "4"]}]}]]}]}], "||", 
        RowBox[{"y", ">", 
         SqrtBox[
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["x", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["x", "4"]}]}]]}]}], ")"}]}], ")"}], "||", 
    RowBox[{"x", ">", "1"}]}], ")"}]}]], "Output",
 ImageSize->{524, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->395960644]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->270751940],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find solution instances:"
}], "ExampleText",
 CellID->155950458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], ">", 
    RowBox[{"z", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->349268992],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", 
     SqrtBox["2"]}], ",", 
    RowBox[{"z", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{162, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93720115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->66039307],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFormula"],
 " to visualize solution sets of inequalities:"
}], "ExampleText",
 CellID->713960932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], ">", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->412249041],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->263599705]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], ">", 
    RowBox[{"z", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->467824785],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVfXd4HOW190TVBdPhckNu6k1uyV1IKAkECAkBkgBrMGBiwBTD2pK7JVuS
JUu2rN577127WmmL5I4r7gXb2Ma9d8uWrF525zzf99bZ2dlZaUXuP1ePNJqZ
nXnL7/Rz3pnVzlgSOHP+jCWzv5zx078Gz1gUOPvLxT99fWEwOuX9A0EQVqG/
g48JaP//oT3ytwoA0Acu20Vo640u8MJHeAfIj+CFdv9ArghSfOKNNz6OY0F4
/v/EdXimeFZ+7P8f3CDyAfvcW9augBFCfz/i52bOnIl3nyWfTXXp0V8xpkcZ
yqTRmeTH43sfZuPxkl1Jm/C0hQdY737kPB06HsEzbu73ZT0+KO9ZDWGpqZFa
kt95H2txPPsv+NAmaCtPO+Hvz/7fI8eOkWMcv99Xup/N6Sly0Vz2+b2jXDeb
fy5re5J0TrqHIeA4fpJcPouNjONLrmCtqN/xRxXeAiZtP1IZC25Z8EUH2rd1
FG8CmqLtJ8gNL7mg7+Ny5jE20kdV2/VVtKvxuN1HVcZO+vCT+oDqYNqNcvSe
98IlwUeB3kN44097UnTmMqf/8bg3jD0+8Tj676ugrrLVX3vcKpeAn/A5sDF7
yXpQG/evnfiH6zCJv2W4/1iGuxwNfp+81f8mt73HuOLn+Gi8dKcCSrTj5v4p
KqP4uXJ+eOMr8RpuTGU8/0UamMzG8x+KNrwljUHv5prOcf9/kvv/A9xr8MdV
xvorRmkv3gnrwgtt1Hv4lQtd1TQ+7ufXyjko+vBWmQWZt/BTPqpR+3oIXDXk
f6v16+eQdU4C9b5Hn98DbH5YE/tx3lH25+OYp0DQHKfo7VdueuMWyKFZHTPz
llPLR86t+Mofq/CdpJsZ33hx4Fl/Si785Qijkt/HpY9bI19OWyo5VKZ92AH5
+ZFydGpcR+dLhoovV1Lol048LreS8rFQAtCh4CF48aEoev8hQ9hHlV7y2SrH
8e9kHC+w+3m/3qpU8VX0jHcfY3f4OWsGxpn4ivGKHn9Benye3TeB/ccjd5Je
GQd68xHJ5vGIvF+XGXu57Zfzopqn/CP2mXxMEkeoooE/5TqCHxOqMxQc6FcH
416UYyLyRjy0kX1fbvHv4Z9IbOGtwiUyey3t+Cm4muMnSZaDw5mVQWaPK2gV
NOnIJzApVtpy1xlw33mSiuy4cLSS5gpe4PPFTT0oa49Lqw/nRSerp5RI5Yx+
5iEtuJ5Wen+4PV8VKVHKsbpsSRiw1u5nvUj8Lc3FiafQ7kTFPH7q4Ty47pdr
Za4L3SGvJp3upFYZMcip5GZWPo5ZUd76PvPivhmPe3xGxlvGc0rtz2fixVqV
tcLn4CfNgTEW1T1yPlPOg/iMEvrcB5wErjbyfplmkUm9Ct7yYy4FLlpB6YN5
O2zavS6zwx8Sf9mXzk0ii6Rf1ef1KzbmRxQU9xkFd5cRyq73ch2hvDVmdZxH
iD9VSgbxKojFwy3+i1JzSPpbIauyUfkI7qyBUr/eo9Bz0jV+gsxWOVusexTj
/Tcy3p8xznhMpUXl+EbSnGpyKpcNygkTWW+qV6p4nnJtxO93ncNPGOY/VNHW
al6Fiw4dQTqVFmGC0sK4m7OKj8T4R4UWxOcjs8EX8vjDnbfiVh9+D/l0mgMb
jb+SF9zwgdJfZhpG0k1KajlmiQH6VzUkR9WkXGOOJNGq9GFj8Bthbhy7kbxt
Plc1Kj5O5ncvuPcBfWX2hLK6i9xxSZBkhu4oedMzXeEpAhL3O7SdIPNrfKVj
BsIkxcyJ5DnssFvrqZ5tGot3pnZ+ZOsl5wildODOJZpIKPoIzp6/g+rcIsv1
qzoW4xiXK/04V0zIGT/pDD2JmuOev1vLMWoExbFUyoQ81uNc6aOCrRtd5qvE
wEsFhX/1kCO8gWdf6TH9waA/rKLN1TTRyNR3uUOBpKv/xiVLklc3vOQeIRd9
ITAPQ4bPY2PAx+kKQZAqBMAiFHd6z53+9EyOVK+Q0YNTzk8VQcFPnoOTcY+P
dIi2/xQqvvIzDto6sLnfWbLVUFLjBjUtq4KsmrfAc3EcF0mq1ONFfwVA7FCJ
CvElpeiJ+/Q+bjFQ1hVc/W/uL49Jy47gYahbIomnJNHmciXZKIaJt0t8xuVI
HYsfuZ27t+L6e7h2lUZG993bT3cxmprsq+cY5Tk9R7uqeI0QoXIE7lPMiNRM
qK8xXnC2GrSD0xGSfMrvU/Nc3UXjY9OpY5EStVhSVavKuMNHZnUc4uKtgs0j
Dmxk+oPoI+8zkdziK5EZr2JpPLWlnkiMJJejXaNV9+CkOFSeC6Co+ClRGQkT
lnfjrMIppLjeH9RjNI+iDI+kyR2OTtZlVA1D8gc+8tCcS4wyh3W/YoYPO7jE
2aq4QUTpMash4y4mGTF/JZMfNa/dWzYmN9ZEzgsu2kMuA0r/bDQMlPUOH5Dl
uzyQ/ZHiaVU/cwTOkjSsZEe4/fLHn6jkPLzdyIaSEx5yoOBiTSgHnovmWSwl
It4yRNRm5RKHjKBVXKI7OUf5yrme4KOir5S9SfKimofglUtnnnlAMUOSDaXx
jINHQJabwGfPcoBI1sCxVgMcud6RYhNPPA1V+VH12RVZRnCtubnHxkv237k6
oeQaBy6St+UyGmUVU87Tggc6YSRPxJ3nOZIlpz1LlRR3moj1oOa9+yj5R4Vj
HlDjGLnWOLlCoqqEEEdEUI9i/hkN6qVy3lnLj8RVRAP4UuQUlWFHFKNEhqMg
Q+X+EVChWuZSLPdNxilk25P85ffVq+r+rzw3osYvPoJML7nkitQzBN4qvOJA
xdUvoWtpLsfxcfg7yxjDwK2X8r29ELkP4yqnRDCUiAjMCrnmipx0q7dK7UaJ
CPHcSNbU3coU5eoCjgA2da4YjeRrfV+pUlZOuLfoYe5IoT9c4z51TCa4yI5y
rYnrChiZdCU42XCVaPCf82VHkju+q7bWQi7rXGONLbvkPkP7oAJHEkcTIeM5
ChU8HT4Q4zlvtRH6S9JAgb0WRzWVimR8z9hyVOQ5bd1GEWwKykqGO89d8He1
d04aTcWXfEiB8KSRONXFf+KVWLk8Cj4XE3VXExkynFYjVQxHiko9kXB3EacS
x3GcO+Ry4251h7MFkFtNhffJ6+ieoMhXe7lWEPgoHHnyq0lc3pX265+tbI8U
2YzmtarrFGmmTmelflkGxE9Fd/KKm5IP7xkBQSfb4caWKLMWgs/VZI6nc+wx
kkS5lcwxIO1O8uVSgYczkUmKMqvop6ItuR1WR43bXr5iTqWCpRwPbt/3VpJO
ftGY8shjRWrUdtgwFJwlqK2LUdhfjpebvLQSM1LfpZWeETGiFupKCh7DrWRO
tZFi5+/LLar+nGIk0ipjJ112r4yvBUG24tApz+I9qm7joyV1GXQj5Su+jlFN
euRRxmWKUQol00iVBrXMrSruI1U35Kh5hohMulziQcWxt1zymAfiRW6UeMUJ
H1fvwyVHcDmNjMRfGN2yjeQ1jBIna2UVYBdU+PovaQWT6pph57VMSv0jl9Lx
jE+8Je5QZOwdFXJ2VrLrrpGbT3uaQ1O781Y987jUPAK1HIPCqgk0W+LLr3Sz
gk01F6VATj5nP4YSQchfcNZLlJEEGSeNqI0kn8+nPZ1LhlotaKRMi2e2XS2P
78MQkjITLjpGLU5Sy2wTGjNcsJ/jRzlNqn5OdNI8Sn9TpWLrczvDGQ+l9+mp
N+QzEkpq2k9myx9QaEg3eUynmFFeH1LERT7AH4RDP36MM3l2z0UDufCNXAt7
vj5pLJbLXU7PR6Udpbf6oEdYqcaLjvwm2qF0dugd7msj5eQcVarI27+oam65
F8gx9ISbRkOU746GKNf+eAwPK1CSrldZ3eUU8yn1k48g0zuO/AMFktgkhf4e
70DIKf4bKaoTBEck87/BW24RddF17loSOIauGkNp+5ykUnGGcaLS/nk7NJeC
Au6wdOdHjSWuU/MARkOcg+ZO27lbS/EwyFZXjaLJvFxQkufKnKVSEl+n7cjY
KSJCVY02WiVbDQOPq+Ba994FPnxEQVc5ZnS+atZR0ucOVFV8dGd5VUq93xhw
U/WzfRirCVyCvw8+7rD1KLfgKZ4y3SevGwvO3pnDy3LiL7pqX8l1RCf7uRqJ
iSMgyPFQ80n/N3hsJIuKdzHF8VoaV6s5TjZ/5Ux9FHzjyy3sOOWVrhgo/TA+
Sx8X/hk9QnEXF44lc8CpwK3zo2pa1cU/9VfVTZyPABxyqup5eCu4Ruax0nhH
ekpQkljKNSrZP3DEYspx+7vBR2l7x7Jm1tUCct3/CNccrFUpF+krQQeyDIJS
f/m58g7X9mq5BXfenJzfFFlnV+w4wi6+mzsvX/Bur8Lz6yrXOVZIjckf5ruj
5STUrCnnUfLcFVkyiA7e0eimalibDvlBn/qr+h7yNbkEjXuUAqu2daqvkB/c
/YSxoexqdxXaTvC+XT0L/euudH1qUU2Wx+TrubPATtTDjICzG5iN/eQUAPV8
D9d8ftL8OGLeKnLu8HU4hP8sglxzUWTu1MzqqpnJkfLRjuDPeZTrGM3iulkt
4H1ldz7jsHvAkbPwd4enaxwr03gYWaW9UWKr5u+NGxOySqskjz5I777dtbN6
q5n/JbdbHmdGPLDOrnhiHpSyY2Ra6MS7Gt2HGt0MjS5Qo1uowdSJ0eicsrqg
zKWoWR3p3TITRxX//wWEldk7ZSRCdfithkD0r6c2oLdmlls/Z1QfYDS9oYb7
RME5kzSOjCdFo/Bn1TNVKk/ESM+Ru9UIvpznmOWnnja3/HyF+xjtk8/txjno
X29dYF9toDvpV+NRd5Hb6D6Akw7yuXhET+G6sj2Tc403yzsRTH1zCaaFGl2F
Rlenka9s5Lgq4hl2ZpIzooIbv0DFA6da9hH3SLrqMP87+rkYx/o5/XWz0c5A
5UyJicbkg/Ib3OVBlVE69YOv7C+9sj2LzZLYcq6jpkscSaWoXDqmn+sVxyNx
6npyrfQcLTtPgJ/gytHqiI6WiSCDwJtx7c0LOwzz6Nj66zGXDlYFMEzHwpGj
VnxUqOLA4+qxJoYP/gjjOpGAqX9CZ9bo2jQ6i4ZygB+9TS7s5D03KoiNkl0U
XHWnv4MjXWy6XFs5xn23aQHGrXEeOx6qCRwi8AmecuBYs6u8HZKZ8r1wuJ4O
Z7dhOYGHY/CBRvc59z+9kzU6JN6lGh2Lkdf/RrflSd3WJ3AHaMch667ZWd+v
n9R9/YRuG/kVBKf3mTlbfl8JWYmzPUNXvpKStDS+wxTcZVyI9gb0CwYb56Od
4do5w9WBwj/Bj2PRpHR+545bLh23kKkJ1H7SbGCCRpepcfCu74YndJt+q9v4
DD618VmGud/uZxinUDrOZO8WUTx7J/jufEq387e6nb/Rbaf4TlS3UC55DTXb
L0NYZtelLMb9jlkKwvnNyddXRXRYQ++aF2MWblo4YFg4pMfsPFw311YzRwVr
1zrDaFkhvjtaXEWOTxxfdep4G7v+7LcGGU78yTXB7yONbiZXpiHP6KKfopLg
v/tZ3d7f6fY+jz/a/ZJu70u6b150jr8cVsxr/3OsQrrrKd2OJyXcFSsMnPD2
cYv3w+4t2H1yxC99FYe2na1hXZYlmLeNiwabFmG4GzHottp5ks7wxFv1NKqS
bOPxE2vR9szJ1ZQ/Tx1tplNMTV5Ox04QmYCc1nSCb91LuvoXdG1/wPt7/4i3
B19iOvjbP+HDI6/qjryGd757jZ2XUqGHX9YdIrd4HWRE2P+8bt/v6UD4u3Nc
NIiKjzBeQtitRRsnx/ja+mi07Wpb2m0Jpfp+yBiE0dUvsjUs5HmR0apa7rwD
Nf0tTPiOAEt/TpxYe/w4fn9p8/5daLsgbAWV8tDnl6z4Myb2wpdmh/0ugN45
fuvvdftexcM+NVl3Wot3jv9Vd/LvOrRlnHv6TXz2jFZ35i2d5Dmc+KvMfh/5
sw6RAwGODr55QYdwRmKAlA++WoollEi7zQiOH42jJwhco13dmnJrw0q0070q
otcahnYGm9kaHZsh2K5fJDZgFW6vncdu8UQPeOJJuGRmj53agJumMz1+6itG
C38y0yptuGFqKNrLemtB+ivzyv441/jC7K9+H0g58OpHeDQX3ke8dP5d1NqZ
ybqzkx3oel94T0cLtALN7Jx+S3fqDfI5kRZ/hDtSMwf+oNv3HD6762nyGUFx
ghJg5y2zoVKcMc6BvHPcxvSB4H9zc6LEZ32tS9F2qGUxsyJ242K7IYh+JtYt
UH1iQb227okckDsxnEdPb2J8fmYz2h45s5U9LRy/5YR80PGv5JRrU5lfcHBB
qPXjJbWTg1rfWLTt9QWMThemzrr+6SyJbj43PtVd/0R35UPdxal0BRG3mD6X
pmIaIEqcm8JkAFHh5Bu6E3+jmXKkxZ/V0d4pik6ZC9VoxCVnNk6N7+V8+7CW
e343d2Te3oIp0btuRd+ayIG28EFL2JApxNYSgsFvDhGbsEEVG7C4i7UL3FDC
Ex3vJBEuGTHB++CZ7YwfnKpwPiXvllk/yd8TkHkxOIkidmRu+PoPQ/d8EMLQ
vvThnBszZrfr5tzWBVKNcFunk1YjXPsYE+Iq+v2IavaJ6OSlDxgA56fozr6j
Q5Jyiiino6/qvv0z9SwV6IPzmj1F4OJiTf0cNJB5L/KcmTC+fXs6E4D10f1r
otDOsHXpsDnUbgplMxON2LiKjUGIAJIUeJabUM++OdZZoZ1Dp7YwDjpwdvfe
s3vQXvS2s5SluIdS+I9m0xcNO+dVooM7K7OHk5Jp7Hp+RgT6d/mTkJtfzr8d
sKBj9gKB8Tn1em9+rruOhGA6lgN0fP2TmWjn2nQd0T74ikmIBBff1yFJQPif
eouATwzwwZd1+1/U7f69bjvVP9LqfTnPu1YinXKe7vSPFPv4dmzPoNj3r185
uHYFa9VmWWo3h4mmMDAtpbwm6oPFhiCoD5Lei+FJHKkWeUuUcazr339yK9ru
PrNn79l9UqxIeSPvk43GgDVfB2OX/WZyTV9qkZiaORSb0heZwHTONV3krVmL
JW3u271oYc+ieT2L5nbPn3137iyB8diXOkQK9Ivb+XzmzRmz0PbGZzP5AkFh
ArIXZ6cQc01swbd/0X3zsm4fogAxAuPcRUhO7+lR4/2H3Npdylmdu3PRv94t
SQMb4wY2xAyti6YjtlvDMc+blyIaQAs2xaJhCTQGQwOPeiXtpcL7Y6pSOt66
jH62n95HEJFmPE4/H7s9h1auu5xm7cxotGWX2VILBuJyfEhhomN+RNeisJ7F
eIT9ocH9oYv6Fi9AFECHd+dQPTShXYcbb9fNatcFoK1A/PZrn8y6On3mlY9m
Er3nd/R13aG/6A68rNv7om4XwdyR73SX11OLl0ZDncptD+f7oQ2xw+uwx2Nv
i6S4TsCYm8OhBVtjsSkE9Fj5INgx93sWq3qUzVdQgXLz9lN7tp0+wO+bwGng
Wx+MbfHhtP3nMrfezF5Di38+fXEl6Oyd0LTbQYnU+xyMWDq0LGRw6eL+EDzY
noXzu+bP65wzpyMwkPLrhDsBAXcCAgW+xuH6ZwHXPg248vGsS9NmXZg6c7xc
+tTr7k7Vv3EjoM19OmFS766cPgL40KaEYRIx2dessK+KEluXER4PB3MEmMIF
Vtk2YKMLjUugYTHUBUtQjuXNKMpjKjFbTu2XJOYePuYZrxXRM2vjLlFcve8W
brAXW4Zzm5hd6IrO71ue1RmW3BOe0L8slp6daI9eZlsePrSMcH7I4t7gIKR7
uubPvzsPM3/n3LkUL/+O2XNQq7e+nI2s87VPA69MD7z0YQBr+YQ24OjfZx1+
bdaBV2ai8Fbg+WhfBae7Q55bKLWn96QnenzlmoIgR1rr35k98HX60Jbk4U2J
TOesjRZXLxeRJCCqWCIQVXCLLeFgDOOZN30IJQwdqQqvj5b9d4m1fL46eXDD
6SN0dNIbVT/7S4Gk0/125t76Nv/CucJjt0r29pdtsZeupT5Ib3LFcFJhz4rM
3hVpAyuT0SlbTCz14v0GwkL7QkJ6gxf3LMKS0L1woVfXgoUEx/swOXRzbnwx
59pnc65Mn33xQ5x3PjVl9nfawG//FnjwtcB9fwrY8bxuC7W8vu50v0psS6ni
WpdRf96NZ0CIFsbJ0YE9+QM7s9HO8JYU2+Yk+8YETIm1MeLqFeKqKGbLwIKl
BskLNC/FlEH7hlBKGKlS7mkWgXuivkwiiE73DvqQywmh0L1dlQftNcwtHc5v
tGUgC1DUF5c9mICF2paQJCbFi4mxYtxKqq0GIyIGwpb2h+Cx9S5Go+oJWkxm
370omIjGIl5SF8Zf+QRn/89MnXvinblH35pz6G9z9v9l9s4XZ219VudYg0Es
lEYnge20roFzntIS+I6ZFqqZ9eG9RYO78xj2ti0p9s3J9o04VhDXxYpronE7
rZFgXcYlxBSBJaZ5Ka+RGMJAj2NVqFtMW/ckC6GMq72k+OD2LB4XkWdhWcWX
ysPcKd9QIq3O7t9eePdI2a3LNdeYfyOWm+x5Vfac8qF0rO9sadm2lHQxLRVS
EPUSyP3321euFPjPwFIs/H0hS/uWUDKGdActIcTDWfr2WUE3vlxEVzd/++a8
A6/P3f1y4LbnZkoU85Yo5rRCjrbNiTcmijmdUX1SdBI6tu8tHNqVa9uBKzq2
Lan2zSn4tq+YHOH9NiRHYI2k9RnzMmhB9CJ6zhjOfOrGUKhfQkfqad5C7kdR
qplPHGd69u483Z3ZTAHzuqekUyYkzr+Nr84c3JzffaDk9unKazfrL+DRGg+B
YRu1IGJ+BZ5adoE9M1fMyoKMDDEtjbVuj0uwxcTZomOHV1Dpu3dgKdYP/aHh
vUuwC9O1MBR1eGdOSHvAkhs6zIMXPg4+84/gE+8F+XMkqXzNdqaO61O+ntLL
ySq5r6iKewptu3J5tmNrqn0LJVYSrI/n0tS2HFqXgzWKSbhpGckNIlqxserD
oCGEkms0WinljsyIyGjvYnxwd66uY7aOyhevpUpe8KSoL66if03pw+tze3cX
dXxXfuNK7SV8V8M3vY3bCUzNUN7ALLWYVyTm5UNOLmRmU9kUk1LtCcm2uCRb
TLwtGvtAw1ErmcczGB7VH4aNbk8wcqbDMbnmLm0PDKN+xtmPQk9ODTk2ZcnB
N5dsf2Xxpj/gFFztU3OLn5xLoWWtaDULHASUbdWy3CNRzilSB1mW9lEJS4qe
uK9Y3FNg35mD97el4e2WVHzvxmTYkADr8CRh1QpoW4FoiPctUYyqLcsQBcEY
IcgkLoQOXi1WdJdBpFZ4IFzXH8rkC8tagM6HrUsjn9+/ZNr5jJAutNeW3f91
wd3DpbewDFSduF5zsKdxLx5X3WqoMkIFLqdDaTXNjkBuAZ5QRo6YliUmZ9gT
0+3xKYh86CQi3/AK5mf49CyO6gqKxCSbt4zGDxc+DT81Lfy795cefnvp168u
3fACnln100FZvw2KeyKIWlStZpHAf9wmFIlH4e/k5/nL6eGS1SJt3yfuLRJ3
54uMLOlOZPkqEcsW2l8dDauiqUxblyOKWAiBWlAMhMlC3vRmJG5GA7FdRMCY
zPDo3/16x8EIXX+Yrm+JjvnTAg66pUojuebB+LmYDKbMwU153WjnUMnFkxWn
r9cdv9twCHfYuAmqrVBlwvsVDVBWC6WVUFxOEL5XzCkUM/PF9FwxNceenIlo
g6kSi0QL6/nhFXFDUbFopz88hsquVMO4NCPqzPSo4/+I/PbdyB1/jVz7Iha6
imeWpj8VFvWbMObVaTWhWs1iOTHceXuUNsq3uEsR3wP43L5iTACyTEv8OgPR
Q9yKJQU2p8LGFKTr8P5aIimrY6hwWFcwKTFGUBpgmiyTcsuMa9RkQi3qZ/mb
+Jn2GEo9Ejn2BuEDJCrtX5Ir+Hd1CI989OKq2W8doH0Y0ofRdkt++77ia6er
rlypPXun4bsBPXYyoHYt1LThHSI5UF4HpTVQXEV58H4xo0BMyxNTsC9rT0xD
ooMpFJM4HI09p4HI+P7wuN6wuO6Q2LvBMXgdEBna0anRu94gXOlPGU0TwYgx
Qjwqy7f7Oejh7C1wXGBvMewp4LYFkyND3JrOW9+E6IGDCFgXD2ti+VWt0Ygi
YI3mNpGKRfMyaI6kJ9RXBbuslaCtpfLQ24vnwn2R8uojBqgDkeMLeiV/xlzw
/vKNXVFfnCBcgDf3bUJuQtndE1W3LtZcbq8/3as/SuRzC6HJaqi2QFULVBqQ
KYLSOt5rQQXklXOuQdRJyRaTsOtuj0+1xWLSDC1PHohM6otI7AlL7A5JoGO8
Pjv+ki7uzKdxtJXNr2PNUfcCy7z5LfldPGUTrWalVhOp1Sz1cZUTlpl0tj70
5TsPgJp3IKNVEex20CpTTqt7YBMSH06rtXGwlii1tpWITohgeL91pa8gWzsB
1cS+uLMuJO7xhaQAMX6WGIO1xdAy7oV3zqapW52Uk6F002qwIE//y67A98/E
zL9D7cE952tu3qi72NV4Cndq2I23dRswZWpaodoElU1IWhi/FVVDQRXkVUJu
GWSX0N4eFZOzCGGwShtemTa4InUgKrUvIqVnaQqlys35SVcCk85/kXTyk8Rj
H6fsfgfr9tZXM2v+kpHz54zYP6VzbyBJq4kl1AkTlLrMpVbiJ1FEsi4PCDJv
lggOpgfsxOlK+DoLtmXinS3psJnos40pBF9Yl4DIuz6BcgaiArPwrTFMXuSZ
7BpsW4ixoXYCsuZCxhxIn8Njp8RAMQ6nC4ejdEPhuoFQtorjxqc8n8G/p0Tw
nvbSDt3bp4Jm3GUcsyFf3FUyfKSyn+oSX6j/CurWQm0bFRGeayqth+JaKKyB
fJzah+xSyCqGjALCyQ/Z4jKHYzIHV2T0R2X0LkvvXppGSXBtburFWalnZqSe
+Czj248xvTZp861vFVS/WSDIPDIfrSaFEGAZh1wesY5BJhzr9pBM7CmE3flc
KrKQYNDWtqSjY0oKpMS8YH0i7W1DEvmcXt8aw3CbKFG6OpR9Vh4MpcFcMzEu
yZoHmYgkOJ8FqSyf5WtfMXN4mW4wDNOgez4dmESH+6Y+9/WMN7C+SlwygLbW
LNum/IG9Jb3fVd69XHvndsPVPv1ZIhr7QL+DtngfEQ8rY5lyPZQ2QHEdIgo+
zKuAnDLIKoHMQjKKPBbPDkRn90dl9y7D6N9enInGfGVO5rmZGae/yD7xRT7L
902tNL9fQdH0ZlKRoNUsZz2NWDtxSITL29K5VZ1IVRTswsYddmRTwSBSkUEE
I53z8YYk2EC01Vcp0BaDyIDPT5JoUBOGOqoOlWp1iBD44uIgKAqCgoWEMecT
YuB1U5A2H1LmQSKTEn9b1EwkHHROnYHYhFz9mOoqR/Si1SQL/Cdk+qWUoA4B
BzO2NTkDXxf0HCztPFXZfq32OrOEouFbMOxF9AH9VuSJMb+SWPomKG1ExMHD
oLorpxzrLnSYjukjJhfYE/Nt8flUG46/GZSD5nNxds7ZWXmnZhYdn1mGzu75
tI6yHLPTWk0OkhStJkZeWVTSaAR5kfleLG/K6JKH7tqRg463Z7P2vBFpKD2/
SnFsN6binqX3d0t0YFJQTgoAJYuhOBgKg1hWl9EifQGkLoBkLCFizGxGESob
d+dg7+radFzfo7cwm/4vVC+gn89fObjo/fMxAXcKogbRYWvW4Ob83r3Fd78r
v4MOOxqv9RvO416aDkHTXjDsBP02TA9s8NfQcTwI5QZEEnyqqBYKkB6rglzC
8pmYKmJasZhSZE8sGo4vGowt7F+JidQZXkBlXvKL6YoABz3ytZp0rSbeM6/L
10EJJ69LWskD+wiD7CbKcUcO7MhFW8r5iBqEepvTERHI7fiZEB+S1aqj+ZgJ
UB0GlaGMH0qXYEIUEfc8bxHkLGQ8k7EQ0hdBCo6Axdh59hVzhiMDefZ+ru72
TFyAZdVux1u6ZCv+/lWrqUL/Pvj9oYA3zi/7/FZGSK+Aw5Oh9bn9OwtxhHKu
uv1Ww61u/WXctfEYGA8ymhi24TONG6BhDd6pNVOEHoOSBihCaqwW8qvxBzmE
LBllYlqpmFJqSyodSigZiMXQdEeVdIQX31xSjEvy84svLKg4v7AWnT+9CK/n
kuXTsrEcEx5yu9qH6i3+jVtsOZvMkO8vRbacrS3YkUufO9xKTXkG3WJK4M/J
N4uwpyGYXNWEQ1WYhJkflIZAMRGOgmDIC4KcRZwaQZBGlkrELxBXzrNFzR2O
mM1k8+zbPH8pVdeRJ8X5EE9yLW39XxZPu5a44K6AwxDb6uyBbQU9aP9UVef1
+judjdfQvt14CpqPYkIY9+E2DdtAvwka1xP5aIUaM1Q2U+t/H+RUQValmFEh
plXYU8ptSeVDCdgh7okuvxtVfju8/MaSMjTVy8HVF4PraRbdgTqWBkHu2zJe
VPVtvSX8KbbOdoNgB/vLsI7CgSF2p7xgZx6i5448GREype0kRgVJe/hCbQRU
8/xXeRiPSwqXQP5iyCWckMWkdLyYsEiMXWBfMX94GU4WdS8IuBMw8/pnukvT
dMpZkrHRmEOrWY3+zXj1GKXED/MiqSnHOgqZ8uOV3Zfru9obcQA/3HxObDkJ
LUeg+SDuuWknNG0FA9FRjWugrhXvVLZAhRHKkO0wQHEjzVJCTg1kV4uZVWJ6
lT21ajgJi19fbFV3dFVnVFV7eNX1JZXYqIfqeU2MagPk1yooMFKk4TE1iIqi
xzupi4EIgiiAfvF4JzIqTJD8gUbuRdQtg5oI5g9ULIXypVBGHO7iUCgMgXwi
HtmLIWsJZC7hFea4IHv0Qnp/z8I5dwIDb3w+C5GELkDANPFncoHpMP2PR+dP
Obdcd4PS9Ifr84Z2FQ8gz/Z8Xe+Nxo67TTexpJnOgoms12o+CM17wbjDQQeq
l2qQ22uGihYob4bSJigxELltYNWB9Fpbai0bUWxtV3Ttnajam+G1N8IbZjq+
p5d7tWkS/My7H2H9vYwCDusgeT4I+/FwoBz2lRJhICKwM59uMf/jq8Yzi+B4
KkW/gkxrOauKVkVAZThUhEN5ONN5BSRplRsC2SGQRZZwJS+hvO3fs2hex+w5
N2YEXv5w1tl3dSfoyj9pndU9zroomWwxE//juSOBb54N//R60qJu/CCn8DCY
jkDLN9C8B4Nt3EqYYgPhiFVQ24rTV5UIbxOUNRN2MEChHvIbIK9ezGmgK/07
oxtuRzXcijTcjGqRVqxRaSRPpMjRday9GgvC6O795Rhg9Lu/1BuhKq3tQA04
vk29YTn3vZYROElBpDwCSsOhhFWy/CEvDHJCIZtgmxoqJoaIcYspqr43Zsy9
/NHss+8FnHhzphOeSJcEkgnNp9z7gFZj0Wp2oL2PXj0fMBWrkMxlQ2hrzbZv
KhjeWzZ0rHrgQkPfTQPO2A6ar9rNF6jleBSadzC+0yNbuw65QFC7CmraoMoK
FWZ8vqQZio1Q2AQFesjTizmYxW0ZeNuf3NSb2ES1m2KtN8U7TcJ71KqHA28v
PlVBVlf3JnBX0DsRLyPQCxg/8YrdI457G5dD4wqoX8Exro6EKhwnQ8UyKF8G
pRFQHM6tbe5SyMEVHUgLE5PDxHgWuXUHL74RQNaJci+OIz+XTG2RwHPOmEen
vIQ9yvkzuhNIfNacaV+XZ9tePHSwYuBUbd8Vfc+d5k5WkbGcFy0nwXwUzIfA
RFcFIa9G/xXxddZB3RqoWQ1VJAlYZoZSExS3QJERCoxinlHA9SrM+INpLX0p
LT2JLXfjWzpiTR3xWJh4pZx5NSrYC+pev4zXFRlXhA/HnW13FnC9hRuQ3kzl
SzCPhoZofFHtcl7Lr4yCiigoi4QSkuAriGB+bno4pISLiUwKfLsXh14NCD01
PeToe8EH31woyL2syRqyLprUYXDWkuprrYatyscTf/NKyCft8QuxK9OYLrbm
2DYVDu0pGzhS3XeuoeemETP9kPW6zXrJbj0rWo6D5VswHwTTfjDhdYnQ/DVp
8yFo2AB16/CZqlVEVK1QaoESExSZxAKcNBdzsUQMZZr708y9KZbuJEtnvEWN
m6WnfsepxF3Eo6T+vfSdoU76xRtj7Q3fVLD7fJiuJt+YQ3x/CnYjLixD3QqE
N9SsYLxeuRwjXopXfELhMihYBnmsij4B0iLE5AjaZk9I+NXA8OPTw/e/E77z
r6FbXl4sl7u3EX9TD4gmurjONrD1Tl/87VLwR7di53XnRWE1Y8qyrc8f2l4y
eLCy/1RdLx1Jv6V92HrVZr1gt54C6zEMuuUQ176mXdCyHZq3QdMWoofuhcpV
UN4GZa1QgnMWYoFVzLeKeXh/MLO1L621J6X1bmIbH6Ki6uZpjtRrBNTRqA5U
SKB7Mw7/Kf/0AdBHMzLWRxPQib2sIQxfSfZLo6AoEgojIZ8om6wo5t/2hEZe
nRN54pPIve9EbXo1au2LVAp8phFdQoANIbbrUa1mPT0z/bXL8/7RHhXYlRGG
FUpThn117vCWosF95f3o8EJjz61mosqtN4asl22Iq60nRet3ouUIy8CZ94Fp
N5h2YJSN28BAMtl1G8h4JkIZZm+xqE0sXCUW4P2hnFX9mat701d3pazmHOdS
2fQmTrtDp4/oociQHidHGu9/g2CuFBz14H93ULBhJdSvhDoCas1KqIlh8ylb
ASXLoSgKCghjZy+HzOWQtnw8IVXebyL5KMixVsMceWrjfqHVYDGf+srlWe/e
DPuiMym4rygG12Cs2baNBZh/D1f1n67vvdqEI9J+a/ug9doQZluEKk44i1a8
jgos34BlH5h3gxnxLjaaYNgKDZvJSNdD1TqoXEtX2fsM560dzFnbl4mfdlF+
Dw0+lr+/biT0+Pv05dcITvoZX+AtKK/EDeHvjSern8DI08aNMdAQA3VEadTG
IGyhOobr6eLlUEh4ODcaslZCOl0v62ePieuOSLgyL+HYpwk730lY80oC7W2O
JmaaJoZwbiTHPI4cFkk02Kl94jjZxZuf50TiOKcly4a2XxcPHqgYOF7bd1GP
8wE9lo5+zMdXbNaLovUsQfw4B/0ABt2yBykMfNi0HSdrGOgboGo9VBJ9XbYO
ytZD6XpHdcIZcbouZuRcMcVcifLI3+ZHwEBN/Ld0rjlRmvM4qI9lWNfGQg3Z
r4iBspXMBubFQE4MZMawNev2uMSh2NTuyIzLCzKOfpaxYwoOWqtewfI2V5P4
oSaR4Bst4ZtAjouZndZqtmufwFWrT/5+bf609qiALuJPP45UMPpnt55DvIw0
BB6D9RBYCS9T62fcCYbt0EjyLXWboBo/FQSVG6AC/X4F5eSwdKO9eONQwUbc
pL8CN9lasnQ5usrcr88Y8JUyaeysRjoHTQlgiIfGOF5rqIuF2jioIcXeylgo
j4HSlVAcwyxebhxkx1H+tyckD8dnDMTmdEXlX1qYf2RGPo3m5z5Z9TEPvjgX
U2tXQvt4EPl42idxAX3aa1cDp7Yv1eH8SdFKzMrmbNv6gmFk+b6pHDhZ13fZ
QBm6E2kRogsehtYjGHALKe+2oBByN47m9WRtS90WqCWxZNVGqNoEleh3M1QQ
5i7HClv5/fPSk7VYd3xvXH+jxFIfz/IaUBcHtaTmVxUPFXFQFgslhGsL4pkl
syelDSdmDcTn98WW3F1RfjGonHmJpIdpT5RQ9LSaRO6llTFgn9iq/c0B7dNn
0P6XU3CAErOgNycSK1/kLK/JG95aPLSvYuBYTf+5xj50stPchdSCgP22a/bW
y2LrebH1jC+leMt+HIs37QbDTjy4+m0ISMpxm72gaguOXbcSbtgmuH4HOcGF
PJvH08Wu2T5PEeXfp/UkR9QPKVsCKpZVaIiH+nimCaoToDIByhGmBN+iRChI
hLwkulZ3ILGwL76sJ666M7qex6JcyjPYOAndH9f+dr/26ZN03PM/7oia3Z1G
/AM98Xo3Fg7vKhs8VD14qn7gchN2FLosmFUHrDeHW6+KrRfF1nNiK6mhWkmB
23yQRZqg38nAqNsGtVtx9WQrwnMbz9K46EmKYMY/i6Cf7ArcEpZzmlMyJkIT
+iX1ncYEaEhArdUlMB+3KhEqsPqD0iQoSYLCZMhPYXpRTM+2p5HX9zjFbb6k
HJLBpTyf1ey1mi0C/5n29xsBH9wO03UlBvcVRGP/wJRlX5dv21YyvL9y6Fjt
4Dn9IGnr3m5LZx/yElqv2xBntp0X284QSIlyNR8G00FoOQDG/dC0l1n6WgTq
11CDfrfzdSFKnvTmci2NR2mffiAzP/SHZ4/4O1ckLTkew2ckVRh9EjQkQn0i
1BGerE0S2Eqs8mQoTYHiVCgk5c3sTMjMETMK7Rmltoyq4fR6xzphGk8W4JCS
56oKyCmDVtNGWrtH+4eL6N+M9+8EfdG1cmFfNhHspkxxVa59U5F9d7ntcI2N
3Ht/u7nvrqWrx3qn33pzqPWqve2i2HYOWk/jMVi+A8sRMBEEmwmChr1MUzXs
hHqSqMCIKr8Hz0uBn7rvT/FTPvP/a5AiNUMyNCK0kqCecF1tMtSkQHUKWxtR
lgal6VBMTFxONmTlQVaRmFVuz6qxZTUMZxqd0SKJT45WEWc7itbPtc/hbMHH
792Z+3nXsvl9qREYLRS4WnLEDYX27aXYsByvH77QhJmww9LTbeX81ob47YLY
Smq9lhNgOQZmAljLQTAegKb9hOJ7oHE3NOzygvqd6G+XfLZqyDENoFi7QNns
UXCWT4efY8qQZjge9MmgJ9zWkAL1qVCXCjVkbVxVOr+ihOTe83IhpwBySiCn
UsyptefoadfAK2SVZFvsw3BrZbg9/S1p5aGpUzpmftodMqcvPmQwn5jflixx
Tb4d7eytsB2ptZ3RY8RuIxazdvdaOwZabw21XUNCyvNAKBBF0b/5GEkyHsZJ
XeM30jMYe6FxDzTsxnm73Zjj9rBp02hRwmwUxPhbP9S8dbnsEiTvJ3ojl54B
IxFEA0GuMQ0a0qA+HeqoT5UJlZlQkcXmUZAPuYWQVwZ5VTjzmdfEtQHjvlJs
d7kFqdFqjBKtvLXPHtK+cJowPDneWGTfWW47WG1jz430WO/2t94ebEUW4xpH
7TTgjNV3YDpKShKHwSjF8Yb9ZM0Bxs4LGvfKZ0xw85fj5nAQ1TKuVD4nKXBz
tRlKZP+TS/8kaM6AJp5G16eDPgMaM6CesF5NFlRnQ2UOVOSyZ6HFAiOjsKxe
U6nVVEjI1Qo0T009Te1T32ifO6l9+Qo6+OQfnfO+6F62oD81fIh6ZEfrbOcM
hPssfaTOcC9YToH5BJi+g5aj0EyiGSNZhdn0DRgOYOQQbHpcY3tQncOcvDzK
OjzX4TMqStzy/SdI2Q1zNrRkgjEdjBlUa4M+CxrJ0oq6HKjJheo8qCTFgpIi
KCiBwkoorPMWnGq71QQaItMO+Xxyv/bZ49o/XkT7097vDPismyJ2fx6R0eYs
cXWeuLnYvrvCfrjGfqoRn7xlHuiw9HZZcBKj33qLZOcu+1Fd0Yx47FslVgay
evIhF6SUbyHz8pCLlGuyf8lx8gdLDpiyMC81E84xZoExm6+Qa8yF+lyoy4Oa
fKgmpfeyUigqg+JqKK6HYiyI0rPdWk0d2dbzFbDryeFe7TNHtS+e0752g1Zk
gwJ6o4MHMqMw8+gzRGsuMgLi9jL7gWr7dw1Yt103DbWb+zvMOL3Za7k9aL1B
gzrRcg7MZ8B8EkzHGU9D00EwkMdVpLeZcgQEQUVneYqWH5OxX0pXWnIRP6H7
W7LolS050JwDxlyaH4T6AqglS4uqSA2qtBIvZC1thNJmQfa2DcRDjVoNe+Ga
VrOOJtO1T32rfe4MRfzH06fdnftlT8SC/pTwoeI4DIcpW1xbIG4tse+ttB+p
s5/W45M3TDi90GHu6jZ39FtuDVmu2Sx4TYFoPiuaiXNhOg4tSBSPIWnEh82H
8UgflaGEu3PKl48ZpXGKK34BUnYcyZ6JLGUy5UALrk635NErmwpAX8jz3TU4
WoKKarzwt9wAFS0CQ4vxk4FuuX5ax9xX6pVq/4g107SpdwM+70E2Mi5kMDca
i5oRuWF54qZipOft31TbjzfYqTW9aeq/beq5a+7sMd8esNwYthCeMp8XzcSd
NSG2OgEtCLVjBC8qlIcJy+IR+TlQk3tcP0CnsSan2pyvgOaequs3Wv2ca7vx
YM4FUx6Y8qGFCJaxEAxFoC+GhhL+pGZVLVQ2QCXW29JbiB5h5o0xEAZE+wTW
HdoXL03+Wzva+fKT7qCAvhXBAxmRRMbSRWuOuL5A3FYq7q0UKXoPXTLarrUM
3mrp7TB1dZnv9JlvDVrIcggzfm4Iy5npFMOEcBLBBHMS/dYJj9D4GZOin0t8
Qm0/tYbmfMRAJjL15iJoKgFDCTQS6amv8pXP+CdaTYtsxptp5U/7NM62aV/H
devPP+5dMKs/ctFgasQwFZqWLFidD5tL8AgP1cLxRhHtXG0evtGCmaDThJmg
34yY4Arz2JDgEOVyWpo0kXLMC/TbohRS4zrbXyikAWfS6SrMVla6AwtbiTwR
TERZNBeDsQSaSsGAl5FAYw3e1jVCLX1mWFpPj3xDM0dgM21B+7tj2j+eoyc/
/ah3nm4wYsFw0lJb3ko8/aZM5oE9tL0M9lfD0Xo88EvNtuuI5qY+RHOkNwjN
r2OaWy6KlvNEdZwRMQKY8uT+x7n9EfiP67z/nVH5pyA94WotAEsh+uU5q5YS
aC6FJiLthiowYEcDGohcO76xSWPValYxr0z7zJHJL56Z/NrVydqORwh9bObL
IhvmOarkRPMp0URyAz/iHCnxIlVkVI/9SkGXHwOvV7cWIRmzooEWEZYvYbrL
SMbZVA1NdWBoJLfKRtmG11PwVSTbkXnDZ58/NfmVy5PfxA/hzfysLzhwYEXQ
IF2hgqzpqjzYWAQ7yuFANRxrwIS4TAjRburrNGOHoNfc3m+6jv3TH3NOU0Fb
EP5DNhP86b9x/hgHbUXQWgzWIrAW07mAqRRaypgX3lwDxnow6snN9znmsppz
s+BPawba35+Y/PLFt/+OhWrG9F762aOJYcN50ZitDBlgzYF1hbCtFPZWwbd1
eBgXm+1XW4aodkWHXabbvS34/mHzFbvlEuGtC7idn4w4N+63EQTIG5LolPCs
yJQspWAuA1M5NFf481nQLOwaLhrbuSf7zHeTXzr/9utsJeoP53zRHzp3IHbJ
UGYUNhAN6cg2wRqiHnZVwMEaPItzRvFyC6YK2r/d0tXZ0tHdgpXpoOmqzXLF
br2MJmK3XGB8LvgybpNsJp3FT8D9k/Q8GsLbH3HK3cOnSRSfpYzN0URqz+Za
MDWAicjJA1y6fqbVfK3V7KZznvw8Do3f0eKFnrM+x4y3PGgIKcHCWEwuYya0
5cFXRSBXAohcaHu9uf9Wc/ft5s7O5tvdzZhc2IXAJYnLpBOOruRQOeb4Yxeb
5q8y28e5nZsIrWVgLQNLOZjprGrAUgeWBrAYwEyK2nwFCbbxeG5azQH2nMrk
P16e8gYmwxef9C2YNRCxYDAhbJiaeRTsWAgvbi2FPZVwqI5pvIkXjcNXmgeu
G3tvGbvuGDvuGvH9/c3Xhq1ogtjmU3vkI81O4sHHYGzfNPu4NO+2IonKE8Ba
DpYKNllLDVjrwdoIrQawNivmup3MdT+19pOm/PXme+9idTBXNxA2bzBmyVBG
lK00HhuulmxszTYVYyXCKtLnjfZLxqGrxv4bTd23mjrvNGHd0224NmjGVpx4
99K8RqYYyDJKju+0a2NJHGir4NkEC3m4wVqLZ9TaCG0kCudv4MO5RTIZQXj7
6RN0fch7b3eibeCMgcVzBlcEI760FcQw69Say1bi7akipBOEs03i+abhS00D
V5t6bxi62g0dHYZ2fM2vRpmL/KlG508edViktkpoxb/cs2qth7ZGWIWnQCIH
8h4hIlXaJ7DPN+WFc++/dpWtko0KsiWH2/NWYlKgABtt1xRg5UEzCjcNnbf1
GH2iw34wykjlqCvlRhqvH6yqpEPGH7bWQGsd0yBkxPjyR7ieRMKi1WD/753n
zrz/ypV/aNunfYD18MKAYTK+cdvKsK4+TEE22M8bhi4Z+q8aenBPpBItWcqf
yJCU51kfBSnPuqYaVlfBqipoqyLMUQNtddDWAKv0hEuIpzyejAqj+PbvTr/7
p0sfvHHrw/cxY8+bOcSe1SiMxVgaiAivLWCK+BuiiE8bxHOG4YuGgSuG3mt6
fBvRuL7SquRnFCiSN1ORyi8eXDWsquaDq4VVdbCqAVaTiOsxB50Pa5/A+Ykp
L12c+tcb095lT/s8sGTO0PLg4eRwWy6xdshOIMHD1rsYtpfDvmo8vJN6OGuw
ndcPXtLjug2xwfxJYUF4liH1sDNieFB4RKvQiOodIyJ+5WNkRNjPfOeF8++/
hv2xj6fhqtqigKGIhcPxobas5fYSogaMRG7WE5W3G6m8WoKX3n5OP8RawyjR
bx//vQKlBySU1lYzyV5F3M3VdbC6HlY3sjH9kOvtBz94s/3jqXiFwPyZQ2Hz
hlcusaUtsxfE4IEg3WvOASQEVCUdIMic0ouMVzAehCrCcwwHx9OtBA4uhWsa
YE0jrMFh3uOc9++b+rebH71797OPcT0HUyQIu7WMImko/sYUQTbta8LWhHIP
sT4JhYU/KGZO8PBzmjnpF1/CfUHh3g/fvvPJhxj2oMChZQT2zCh7MYEdqStr
LrY0W0rxPO9nOBOvU6pBuPvmFy/BsY7eC9YidxLWsgQA4Wvq7y6dj/FNxfjS
aNUbBdDsqklsdsQmC//jolVcn7/n/d7HMfWFdXrUN+oZ1pGX52ILiMV0Imv7
lx63zSNb/twRfi7JCOubUMPkF+un3zKE/svjVh3vSwfJR3Kskv6qWeoDHT7B
xvyEx63z/IsUUfrABtakQDPTuL2nPG7PNap3ZEK+IqEqzx1hFH7nxCccP543
H++4Ew2pmfDNz9iIXiB3vqbgLIed+6oF30G5GF//Mrn+dXBob2+ZXvgL+fRv
itb4apFHWBvkc+FFFa7G8+LnvASH3X2Atf8WueYFVdoqfQ2nNsERF+Bd/gah
KR6253i7Jf2ctsTXe0/1sBVpZZGiToln9qGbNjgCEg1ZigD3++kI98j7JbyJ
rv/CCXcuD/PJ2VWy7d/Bfb1lBrniDRV8nMfw+f+J6/4OzhIzwwULuhV+8P8B
lo4/jA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->484957221]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->85704608],

Cell["Inequality assumptions:", "ExampleText",
 CellID->800449889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->610693880],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->932892896]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"a", "^", "n"}], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"a", ">", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->135321853],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->122260890]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6782493],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " to solve optimization problems constrained by inequalities:"
}], "ExampleText",
 CellID->529383770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"y", "^", "2"}]}], "+", 
       RowBox[{"4", 
        RowBox[{"x", "^", "2"}]}], "-", 
       RowBox[{"4", 
        RowBox[{"x", "^", "4"}]}]}], ">", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140887538],

Cell[BoxData[
 RowBox[{
  RowBox[{"Minimize", "::", "\<\"wksol\"\>"}], ":", 
  " ", "\<\"Warning: There is no minimum in the region described by the \
constraints; returning a result on the boundary. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Minimize/wksol\\\", ButtonNote -> \
\\\"Minimize::wksol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->61903575],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"27", "-", 
       RowBox[{"207", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"64", " ", 
        SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"27", "-", 
           RowBox[{"207", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"64", " ", 
            SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], "+", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"48", "-", 
           RowBox[{"111", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"64", " ", 
            SuperscriptBox["#1", "4"]}]}], "&"}], ",", "4"}], "]"}]}]}], ",", 
     
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"48", "-", 
          RowBox[{"111", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["#1", "4"]}]}], "&"}], ",", "4"}], "]"}]}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{441, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->913645260]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->203171297],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 " to numerically solve constrained optimization problems:"
}], "ExampleText",
 CellID->663004900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", " ", 
     RowBox[{"2", ">", 
      RowBox[{
       RowBox[{"Tan", "[", "x", "]"}], "+", 
       RowBox[{"Tan", "[", "y", "]"}]}], ">", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4920993],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.1401408407383853`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.5700700002562602`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "1.5700708404821253`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549486602]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90860629],

Cell["Integrate a function over the solution set of inequalities:", \
"ExampleText",
 CellID->53006069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], " ", 
    RowBox[{"Boole", "[", 
     RowBox[{"2", ">", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], ">", "1"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16786161],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", "\[Pi]"}], "4"]], "Output",
 ImageSize->{27, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->522634824]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->319542029],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Quartiles",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quartiles"]], "InlineFormula"],
 " to the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["n", "th"], TraditionalForm]], "InlineMath"],
 " greatest number(s): "
}], "ExampleText",
 CellID->798766],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->662995740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x3", ">", "x2", ">", "x1"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10873149],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->350660745]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"{", 
   RowBox[{"x2", ",", "x3", ",", "x1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->81695411],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->213894719]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->489635604],

Cell["\<\
Inequalities for machine-precision approximate numbers can be subtle: \
\>", "ExampleText",
 CellID->61699174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.00006", "-", "2.00005"}], ">", "0.00001"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107589248],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328924327]
}, Open  ]],

Cell["The strict inequality is based on extra digits:", "ExampleText",
 CellID->454896623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.00006", "-", "2.00005"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->385657575],

Cell["0.000010000000000065512", "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->550037500]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->704680416],

Cell["\<\
Arbitrary-precision approximate numbers do not have this problem:\
\>", "ExampleText",
 CellID->29032653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.00006`16", "-", "2.00005`16"}], ">", "0.00001`16"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108479341],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195527133]
}, Open  ]],

Cell[TextData[{
 "Thanks to automatic precision tracking, ",
 Cell[BoxData[
  ButtonBox["Greater",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Greater"]], "InlineFormula"],
 " knows to look only at the first ten digits:"
}], "ExampleText",
 CellID->446345418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", 
  RowBox[{"2.00006`16", "-", "2.00005`16"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->501825511],

Cell[BoxData["10.397928065738002`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->595809832]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81070612],

Cell["\<\
In this case, inequality between machine numbers gives the expected result:\
\>", "ExampleText",
 CellID->693243942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.6", "-", "2.5"}], ">", "0.1"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->544352754],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->749706286]
}, Open  ]],

Cell[TextData[{
 "The extra digits in this case are ignored by ",
 Cell[BoxData[
  ButtonBox["Greater",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Greater"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->153335021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.6", "-", "2.5"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->551042265],

Cell["0.10000000000000009", "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->68807710]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5793],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GreaterEqual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GreaterEqual"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Less",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Less"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Positive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Positive"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11977]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10167],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RelationalAndLogicalOperators"]], "Tutorials",
 CellID->19212]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->47462346],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "MoreAbout",
 CellID->745282834]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Greater (>) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 2.4277742}", "context" -> "System`", 
    "keywords" -> {
     "comparison", "greater", "inequality", "order", "order relation", 
      "strict inequality", "strong inequality"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "x > y yields True if x is determined to be greater than y. x_1 > x_2 > \
x_3 yields True if the x_i form a strictly decreasing sequence. ", 
    "synonyms" -> {">"}, "title" -> "Greater", "type" -> "Symbol", "uri" -> 
    "ref/Greater"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6100, 203, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->536006117]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 81099, 2625}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2273, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2896, 81, 99, 4, 70, "ObjectName",
 CellID->4667],
Cell[2998, 87, 1379, 47, 70, "Usage",
 CellID->403]
}, Open  ]],
Cell[CellGroupData[{
Cell[4414, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4892, 156, 448, 17, 70, "Notes",
 CellID->18367],
Cell[5343, 175, 227, 7, 70, "Notes",
 CellID->18899],
Cell[5573, 184, 490, 14, 70, "Notes",
 CellID->21054]
}, Closed]],
Cell[CellGroupData[{
Cell[6100, 203, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->536006117],
Cell[CellGroupData[{
Cell[6485, 217, 147, 5, 70, "ExampleSection",
 CellID->52823775],
Cell[6635, 224, 59, 1, 70, "ExampleText",
 CellID->414328301],
Cell[CellGroupData[{
Cell[6719, 229, 92, 3, 28, "Input",
 CellID->107391370],
Cell[6814, 234, 161, 5, 36, "Output",
 CellID->408810099]
}, Open  ]],
Cell[CellGroupData[{
Cell[7012, 244, 174, 6, 28, "Input",
 CellID->765975626],
Cell[7189, 252, 160, 5, 36, "Output",
 CellID->5578176]
}, Open  ]],
Cell[7364, 260, 125, 3, 70, "ExampleDelimiter",
 CellID->179667355],
Cell[7492, 265, 66, 1, 70, "ExampleText",
 CellID->42591990],
Cell[CellGroupData[{
Cell[7583, 270, 168, 6, 70, "Input",
 CellID->402385732],
Cell[7754, 278, 259, 9, 36, "Output",
 CellID->580946]
}, Open  ]],
Cell[CellGroupData[{
Cell[8050, 292, 124, 4, 70, "Input",
 CellID->34392874],
Cell[8177, 298, 510, 20, 51, "Output",
 CellID->165155323]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8736, 324, 220, 7, 70, "ExampleSection",
 CellID->249696463],
Cell[CellGroupData[{
Cell[8981, 335, 240, 7, 70, "ExampleSubsection",
 CellID->26431756],
Cell[9224, 344, 89, 1, 70, "ExampleText",
 CellID->96088816],
Cell[CellGroupData[{
Cell[9338, 349, 92, 3, 70, "Input",
 CellID->251460291],
Cell[9433, 354, 381, 7, 70, "Message",
 CellID->462430727],
Cell[9817, 363, 192, 6, 36, "Output",
 CellID->337595726]
}, Open  ]],
Cell[10024, 372, 125, 3, 70, "ExampleDelimiter",
 CellID->661547383],
Cell[10152, 377, 68, 1, 70, "ExampleText",
 CellID->234143528],
Cell[CellGroupData[{
Cell[10245, 382, 138, 5, 70, "Input",
 CellID->241292235],
Cell[10386, 389, 161, 5, 36, "Output",
 CellID->733323689]
}, Open  ]],
Cell[10562, 397, 125, 3, 70, "ExampleDelimiter",
 CellID->425405628],
Cell[10690, 402, 145, 4, 70, "ExampleText",
 CellID->580861],
Cell[CellGroupData[{
Cell[10860, 410, 213, 8, 70, "Input",
 CellID->37738947],
Cell[11076, 420, 162, 5, 36, "Output",
 CellID->185546314]
}, Open  ]],
Cell[CellGroupData[{
Cell[11275, 430, 214, 8, 70, "Input",
 CellID->525645198],
Cell[11492, 440, 158, 5, 36, "Output",
 CellID->750402]
}, Open  ]],
Cell[11665, 448, 124, 3, 70, "ExampleDelimiter",
 CellID->16182603],
Cell[11792, 453, 113, 3, 70, "ExampleText",
 CellID->314603207],
Cell[CellGroupData[{
Cell[11930, 460, 147, 5, 70, "Input",
 CellID->315310371],
Cell[12080, 467, 162, 5, 36, "Output",
 CellID->125129083]
}, Open  ]],
Cell[CellGroupData[{
Cell[12279, 477, 319, 12, 70, "Input",
 CellID->331846797],
Cell[12601, 491, 161, 5, 36, "Output",
 CellID->190374951]
}, Open  ]],
Cell[12777, 499, 125, 3, 70, "ExampleDelimiter",
 CellID->691680788],
Cell[12905, 504, 139, 4, 70, "ExampleText",
 CellID->128181167],
Cell[CellGroupData[{
Cell[13069, 512, 140, 5, 70, "Input",
 CellID->398884990],
Cell[13212, 519, 161, 5, 36, "Output",
 CellID->161009841]
}, Open  ]],
Cell[13388, 527, 93, 1, 70, "ExampleText",
 CellID->207797078],
Cell[CellGroupData[{
Cell[13506, 532, 288, 10, 70, "Input",
 CellID->142094998],
Cell[13797, 544, 162, 5, 36, "Output",
 CellID->506648366]
}, Open  ]],
Cell[13974, 552, 125, 3, 70, "ExampleDelimiter",
 CellID->239611855],
Cell[14102, 557, 263, 8, 70, "ExampleText",
 CellID->135341977],
Cell[CellGroupData[{
Cell[14390, 569, 372, 14, 70, "Input",
 CellID->180221533],
Cell[14765, 585, 591, 11, 70, "Message",
 CellID->165470705],
Cell[15359, 598, 428, 16, 41, "Output",
 CellID->104099836]
}, Open  ]],
Cell[15802, 617, 231, 8, 70, "ExampleText",
 CellID->299920545],
Cell[CellGroupData[{
Cell[16058, 629, 265, 9, 70, "Input",
 CellID->195979928],
Cell[16326, 640, 162, 5, 36, "Output",
 CellID->198076728]
}, Open  ]],
Cell[16503, 648, 125, 3, 70, "ExampleDelimiter",
 CellID->498468165],
Cell[16631, 653, 262, 8, 70, "ExampleText",
 CellID->192423184],
Cell[CellGroupData[{
Cell[16918, 665, 447, 17, 70, "Input",
 CellID->1546846],
Cell[17368, 684, 702, 12, 70, "Message",
 CellID->127616676],
Cell[18073, 698, 615, 22, 75, "Output",
 CellID->375604723]
}, Open  ]],
Cell[18703, 723, 224, 7, 70, "ExampleText",
 CellID->384720156],
Cell[CellGroupData[{
Cell[18952, 734, 265, 9, 70, "Input",
 CellID->476886642],
Cell[19220, 745, 160, 5, 36, "Output",
 CellID->20907343]
}, Open  ]],
Cell[19395, 753, 244, 8, 70, "ExampleText",
 CellID->321641904],
Cell[CellGroupData[{
Cell[19664, 765, 602, 21, 70, "Input",
 CellID->1018235179],
Cell[20269, 788, 161, 5, 36, "Output",
 CellID->177783357]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20479, 799, 242, 7, 70, "ExampleSubsection",
 CellID->500815976],
Cell[20724, 808, 194, 6, 70, "ExampleText",
 CellID->152622296],
Cell[CellGroupData[{
Cell[20943, 818, 92, 3, 70, "Input",
 CellID->148403671],
Cell[21038, 823, 180, 6, 36, "Output",
 CellID->235669964]
}, Open  ]],
Cell[21233, 832, 298, 11, 70, "ExampleText",
 CellID->198785255],
Cell[CellGroupData[{
Cell[21556, 847, 189, 6, 70, "Input",
 CellID->205622433],
Cell[21748, 855, 162, 5, 36, "Output",
 CellID->675905583]
}, Open  ]],
Cell[21925, 863, 124, 3, 70, "ExampleDelimiter",
 CellID->60153346],
Cell[22052, 868, 64, 1, 70, "ExampleText",
 CellID->26754974],
Cell[CellGroupData[{
Cell[22141, 873, 192, 7, 70, "Input",
 CellID->486416913],
Cell[22336, 882, 253, 9, 36, "Output",
 CellID->511023201]
}, Open  ]],
Cell[22604, 894, 234, 8, 70, "ExampleText",
 CellID->58238363],
Cell[CellGroupData[{
Cell[22863, 906, 177, 6, 70, "Input",
 CellID->145270882],
Cell[23043, 914, 845, 33, 52, "Output",
 CellID->258608324]
}, Open  ]],
Cell[23903, 950, 223, 8, 70, "ExampleText",
 CellID->220870228],
Cell[CellGroupData[{
Cell[24151, 962, 183, 6, 70, "Input",
 CellID->159052583],
Cell[24337, 970, 304, 11, 43, "Output",
 CellID->32338784]
}, Open  ]],
Cell[24656, 984, 234, 8, 70, "ExampleText",
 CellID->279307693],
Cell[CellGroupData[{
Cell[24915, 996, 253, 9, 70, "Input",
 CellID->34810484],
Cell[25171, 1007, 439, 8, 70, "Message",
 CellID->93558989],
Cell[25613, 1017, 339, 12, 36, "Output",
 CellID->213223198]
}, Open  ]],
Cell[25967, 1032, 236, 8, 70, "ExampleText",
 CellID->266015669],
Cell[CellGroupData[{
Cell[26228, 1044, 269, 10, 70, "Input",
 CellID->450815041],
Cell[26500, 1056, 221, 8, 36, "Output",
 CellID->41874376]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26782, 1071, 238, 7, 70, "ExampleSection",
 CellID->108974605],
Cell[27023, 1080, 339, 13, 70, "ExampleText",
 CellID->14000026],
Cell[CellGroupData[{
Cell[27387, 1097, 122, 4, 70, "Input",
 CellID->785552779],
Cell[27512, 1103, 187, 6, 36, "Output",
 CellID->46898]
}, Open  ]],
Cell[27714, 1112, 125, 3, 70, "ExampleDelimiter",
 CellID->646462098],
Cell[27842, 1117, 244, 8, 70, "ExampleText",
 CellID->179461278],
Cell[CellGroupData[{
Cell[28111, 1129, 132, 4, 70, "Input",
 CellID->900203775],
Cell[28246, 1135, 208, 7, 36, "Output",
 CellID->135920944]
}, Open  ]],
Cell[28469, 1145, 373, 13, 70, "ExampleText",
 CellID->103307650],
Cell[CellGroupData[{
Cell[28867, 1162, 109, 3, 70, "Input",
 CellID->602057068],
Cell[28979, 1167, 249, 8, 36, "Output",
 CellID->379461620]
}, Open  ]],
Cell[29243, 1178, 225, 8, 70, "ExampleText",
 CellID->22272967],
Cell[CellGroupData[{
Cell[29493, 1190, 163, 4, 70, "Input",
 CellID->41719149],
Cell[29659, 1196, 249, 8, 36, "Output",
 CellID->184653005]
}, Open  ]],
Cell[29923, 1207, 124, 3, 70, "ExampleDelimiter",
 CellID->66212984],
Cell[30050, 1212, 262, 9, 70, "ExampleText",
 CellID->294478095],
Cell[CellGroupData[{
Cell[30337, 1225, 463, 17, 70, "Input",
 CellID->174240470],
Cell[30803, 1244, 539, 10, 70, "Message",
 CellID->217597421],
Cell[31345, 1256, 406, 16, 51, "Output",
 CellID->544551866]
}, Open  ]],
Cell[31766, 1275, 249, 7, 70, "ExampleText",
 CellID->631563206],
Cell[CellGroupData[{
Cell[32040, 1286, 108, 3, 70, "Input",
 CellID->106030961],
Cell[32151, 1291, 162, 5, 36, "Output",
 CellID->410889573]
}, Open  ]],
Cell[32328, 1299, 125, 3, 70, "ExampleDelimiter",
 CellID->141984053],
Cell[32456, 1304, 467, 17, 70, "ExampleText",
 CellID->265821182],
Cell[CellGroupData[{
Cell[32948, 1325, 187, 6, 70, "Input",
 CellID->875674151],
Cell[33138, 1333, 239, 8, 36, "Output",
 CellID->7657560]
}, Open  ]],
Cell[33392, 1344, 125, 3, 70, "ExampleDelimiter",
 CellID->263835271],
Cell[33520, 1349, 205, 8, 70, "ExampleText",
 CellID->107059385],
Cell[CellGroupData[{
Cell[33750, 1361, 231, 8, 70, "Input",
 CellID->821314495],
Cell[33984, 1371, 736, 24, 39, "Output",
 CellID->334492512]
}, Open  ]],
Cell[CellGroupData[{
Cell[34757, 1400, 354, 13, 70, "Input",
 CellID->23944515],
Cell[35114, 1415, 991, 33, 52, "Output",
 CellID->395960644]
}, Open  ]],
Cell[36120, 1451, 125, 3, 70, "ExampleDelimiter",
 CellID->270751940],
Cell[36248, 1456, 222, 8, 70, "ExampleText",
 CellID->155950458],
Cell[CellGroupData[{
Cell[36495, 1468, 396, 14, 70, "Input",
 CellID->349268992],
Cell[36894, 1484, 345, 12, 43, "Output",
 CellID->93720115]
}, Open  ]],
Cell[37254, 1499, 124, 3, 70, "ExampleDelimiter",
 CellID->66039307],
Cell[37381, 1504, 371, 13, 70, "ExampleText",
 CellID->713960932],
Cell[CellGroupData[{
Cell[37777, 1521, 480, 17, 70, "Input",
 CellID->412249041],
Cell[38260, 1540, 5129, 88, 70, "Output",
 Evaluatable->False,
 CellID->263599705]
}, Open  ]],
Cell[CellGroupData[{
Cell[43426, 1633, 597, 21, 70, "Input",
 CellID->467824785],
Cell[44026, 1656, 21571, 358, 70, "Output",
 Evaluatable->False,
 CellID->484957221]
}, Open  ]],
Cell[65612, 2017, 124, 3, 70, "ExampleDelimiter",
 CellID->85704608],
Cell[65739, 2022, 66, 1, 70, "ExampleText",
 CellID->800449889],
Cell[CellGroupData[{
Cell[65830, 2027, 206, 7, 70, "Input",
 CellID->610693880],
Cell[66039, 2036, 158, 5, 36, "Output",
 CellID->932892896]
}, Open  ]],
Cell[CellGroupData[{
Cell[66234, 2046, 260, 8, 70, "Input",
 CellID->135321853],
Cell[66497, 2056, 168, 5, 36, "Output",
 CellID->122260890]
}, Open  ]],
Cell[66680, 2064, 123, 3, 70, "ExampleDelimiter",
 CellID->6782493],
Cell[66806, 2069, 375, 13, 70, "ExampleText",
 CellID->529383770],
Cell[CellGroupData[{
Cell[67206, 2086, 475, 17, 70, "Input",
 CellID->140887538],
Cell[67684, 2105, 439, 8, 70, "Message",
 CellID->61903575],
Cell[68126, 2115, 1391, 46, 77, "Output",
 CellID->913645260]
}, Open  ]],
Cell[69532, 2164, 125, 3, 70, "ExampleDelimiter",
 CellID->203171297],
Cell[69660, 2169, 375, 13, 70, "ExampleText",
 CellID->663004900],
Cell[CellGroupData[{
Cell[70060, 2186, 388, 13, 70, "Input",
 CellID->4920993],
Cell[70451, 2201, 415, 14, 36, "Output",
 CellID->549486602]
}, Open  ]],
Cell[70881, 2218, 124, 3, 70, "ExampleDelimiter",
 CellID->90860629],
Cell[71008, 2223, 103, 2, 70, "ExampleText",
 CellID->53006069],
Cell[CellGroupData[{
Cell[71136, 2229, 527, 17, 70, "Input",
 CellID->16786161],
Cell[71666, 2248, 205, 7, 51, "Output",
 CellID->522634824]
}, Open  ]],
Cell[71886, 2258, 125, 3, 70, "ExampleDelimiter",
 CellID->319542029],
Cell[72014, 2263, 561, 22, 70, "ExampleText",
 CellID->798766],
Cell[72578, 2287, 231, 8, 70, "Input",
 CellID->662995740],
Cell[CellGroupData[{
Cell[72834, 2299, 104, 3, 70, "Input",
 CellID->10873149],
Cell[72941, 2304, 161, 5, 36, "Output",
 CellID->350660745]
}, Open  ]],
Cell[CellGroupData[{
Cell[73139, 2314, 161, 5, 70, "Input",
 CellID->81695411],
Cell[73303, 2321, 158, 5, 36, "Output",
 CellID->213894719]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[73510, 2332, 230, 7, 70, "ExampleSection",
 CellID->489635604],
Cell[73743, 2341, 120, 3, 70, "ExampleText",
 CellID->61699174],
Cell[CellGroupData[{
Cell[73888, 2348, 133, 4, 70, "Input",
 CellID->107589248],
Cell[74024, 2354, 161, 5, 36, "Output",
 CellID->328924327]
}, Open  ]],
Cell[74200, 2362, 90, 1, 70, "ExampleText",
 CellID->454896623],
Cell[CellGroupData[{
Cell[74315, 2367, 136, 4, 70, "Input",
 CellID->385657575],
Cell[74454, 2373, 183, 5, 50, "Output",
 CellID->550037500]
}, Open  ]],
Cell[74652, 2381, 125, 3, 70, "ExampleDelimiter",
 CellID->704680416],
Cell[74780, 2386, 115, 3, 70, "ExampleText",
 CellID->29032653],
Cell[CellGroupData[{
Cell[74920, 2393, 142, 4, 70, "Input",
 CellID->108479341],
Cell[75065, 2399, 162, 5, 36, "Output",
 CellID->195527133]
}, Open  ]],
Cell[75242, 2407, 264, 8, 70, "ExampleText",
 CellID->446345418],
Cell[CellGroupData[{
Cell[75531, 2419, 146, 4, 70, "Input",
 CellID->501825511],
Cell[75680, 2425, 176, 5, 36, "Output",
 CellID->595809832]
}, Open  ]],
Cell[75871, 2433, 124, 3, 70, "ExampleDelimiter",
 CellID->81070612],
Cell[75998, 2438, 126, 3, 70, "ExampleText",
 CellID->693243942],
Cell[CellGroupData[{
Cell[76149, 2445, 121, 4, 70, "Input",
 CellID->544352754],
Cell[76273, 2451, 162, 5, 36, "Output",
 CellID->749706286]
}, Open  ]],
Cell[76450, 2459, 226, 8, 70, "ExampleText",
 CellID->153335021],
Cell[CellGroupData[{
Cell[76701, 2471, 128, 4, 70, "Input",
 CellID->551042265],
Cell[76832, 2477, 178, 5, 50, "Output",
 CellID->68807710]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[77071, 2489, 310, 9, 70, "SeeAlsoSection",
 CellID->5793],
Cell[77384, 2500, 1441, 53, 70, "SeeAlso",
 CellID->11977]
}, Open  ]],
Cell[CellGroupData[{
Cell[78862, 2558, 314, 9, 70, "TutorialsSection",
 CellID->10167],
Cell[79179, 2569, 172, 3, 70, "Tutorials",
 CellID->19212]
}, Open  ]],
Cell[CellGroupData[{
Cell[79388, 2577, 318, 9, 70, "MoreAboutSection",
 CellID->47462346],
Cell[79709, 2588, 136, 3, 70, "MoreAbout",
 CellID->745282834]
}, Open  ]],
Cell[79860, 2594, 50, 0, 70, "History"],
Cell[79913, 2596, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

