(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     97595,       3208]
NotebookOptionsPosition[     82316,       2670]
NotebookOutlinePosition[     83701,       2707]
CellTagsIndexPosition[     83615,       2702]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Relational and Logical Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RelationalAndLogicalOperators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Relational and Logical Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Greater" :> Documentation`HelpLookup["paclet:ref/Greater"], 
          "LessEqual" :> Documentation`HelpLookup["paclet:ref/LessEqual"], 
          "Element" :> Documentation`HelpLookup["paclet:ref/Element"], 
          "RegionPlot" :> Documentation`HelpLookup["paclet:ref/RegionPlot"], 
          "RegionPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot3D"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Greater\"\>", 
       2->"\<\"LessEqual\"\>", 3->"\<\"Element\"\>", 4->"\<\"RegionPlot\"\>", 
       5->"\<\"RegionPlot3D\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inequalities" :> 
          Documentation`HelpLookup["paclet:guide/Inequalities"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Inequalities\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "GreaterEqual ",
 StyleBox["(>=, \[GreaterEqual])", "OperatorCharacter"]
}], "ObjectName",
 CellID->30856],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], ">=", 
       StyleBox["y", "TI"]}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "\[GreaterEqual]", 
       StyleBox["y", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " is determined to be greater than or equal to ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], "\[GreaterEqual]", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], "\[GreaterEqual]", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["3", "TR"]]}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
     " form a non\[Hyphen]increasing sequence. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->30180]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[GreaterEqual]", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " can be entered as ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]>=\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["x", "TI"], "\[Backslash]", 
    RowBox[{"[", "GreaterEqual", "]"}]}], 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26429],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GreaterEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GreaterEqual"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " when its arguments are real numbers. "
}], "Notes",
 CellID->24537],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GreaterEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GreaterEqual"]], "InlineFormula"],
 " does some simplification when its arguments are not numbers. "
}], "Notes",
 CellID->13629],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["GreaterEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GreaterEqual"]], "InlineFormula"],
 " internally uses numerical approximations to establish numerical ordering. \
This process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18389],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GreaterEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GreaterEqual"]], "InlineFormula"],
 " is printed using ",
 Cell[BoxData["\[GreaterEqual]"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9843],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[GreaterSlantEqual]", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ", entered as ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]>/\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["x", "TI"], "\[Backslash]", 
    RowBox[{"[", 
     ButtonBox["GreaterSlantEqual",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GreaterSlantEqual"], "]"}]}], 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ", can be used on input as an alternative to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[GreaterEqual]", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7004]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->55372502],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->189892057],

Cell["Compare numbers:", "ExampleText",
 CellID->192662955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "\[GreaterEqual]", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107391370],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58359964]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "/", "17"}], "\[GreaterEqual]", 
  RowBox[{"1", "/", "5"}], "\[GreaterEqual]", 
  RowBox[{"Pi", "/", "10"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->765975626],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->505375536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->275922434],

Cell["Represent an inequality:", "ExampleText",
 CellID->27494034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "3"}], "-", 
   RowBox[{"2", "x"}], "+", "1"}], "\[GreaterEqual]", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->402385732],

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "-", 
   RowBox[{"2", " ", "x"}], "+", 
   SuperscriptBox["x", "3"]}], "\[GreaterEqual]", "0"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->401280635]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34392874],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox["5"]}], ")"}]}], "\[LessEqual]", "x", "\[LessEqual]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox["5"]}], ")"}]}]}], "||", 
  RowBox[{"x", "\[GreaterEqual]", "1"}]}]], "Output",
 ImageSize->{246, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->848590516]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->904235151],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Numeric Inequalities",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->26431756],

Cell["Inequalities are defined only for real numbers:", "ExampleText",
 CellID->95488339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I", "\[GreaterEqual]", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251460291],

Cell[BoxData[
 RowBox[{
  RowBox[{"GreaterEqual", "::", "\<\"nord\"\>"}], ":", 
  " ", "\<\"Invalid comparison with \\!\\(\[ImaginaryI]\\) attempted. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/nord\\\", \
ButtonNote -> \\\"GreaterEqual::nord\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->648543676],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", "\[GreaterEqual]", "0"}]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141497344]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->155816487],

Cell["Compare rational numbers:", "ExampleText",
 CellID->234143528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"3", "/", "2"}], "\[GreaterEqual]", 
  RowBox[{"4", "/", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241292235],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37804184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140624971],

Cell["\<\
Approximate numbers that differ in at most their last eight binary digits are \
considered equal:\
\>", "ExampleText",
 CellID->120866437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "\[GreaterEqual]", 
  RowBox[{"1.", "+", 
   RowBox[{
    RowBox[{"2", "^", "7"}], " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "16"}]}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37738947],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83576382]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "\[GreaterEqual]", 
  RowBox[{"1.", "+", 
   RowBox[{
    RowBox[{"2", "^", "8"}], " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "16"}]}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->525645198],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->266552318]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->411298638],

Cell["\<\
Compare an exact numeric expression and an approximate number:\
\>", "ExampleText",
 CellID->449273801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "20"}], "]"}], "\[GreaterEqual]", "Pi"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315310371],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128997276]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "20"}], "]"}], "\[GreaterEqual]", 
  RowBox[{"Pi", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"2", "^", "8"}], " ", 
      RowBox[{"10", "^", 
       RowBox[{"-", "20"}]}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331846797],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17936002]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->436796394],

Cell["\<\
Compare two exact numeric expressions; a numeric test may suffice to prove \
inequality:\
\>", "ExampleText",
 CellID->174582969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"E", "^", "Pi"}], "\[GreaterEqual]", 
  RowBox[{"Pi", "^", "E"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398884990],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20378373]
}, Open  ]],

Cell["Proving this inequality requires symbolic methods:", "ExampleText",
 CellID->207797078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "\[GreaterEqual]", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"5", "+", 
    RowBox[{"2", 
     RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142094998],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->396948086]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41262348],

Cell[TextData[{
 "Symbolic and numeric methods used by ",
 Cell[BoxData[
  ButtonBox["GreaterEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GreaterEqual"]], "InlineFormula"],
 " are insufficient to prove this inequality:"
}], "ExampleText",
 CellID->135341977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "\[GreaterEqual]", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "4"}], "-", 
      RowBox[{"10", 
       RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180221533],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\@2 + \\@3 - \\(\\(Root[\\(\\(\\(\\(\\(\\(1 - \
\\(\\(10\\\\ \\(Slot[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\)\\) + #1\\^4\\)\\) &\\)\\), 4, \
0\\)\\)]\\)\\)\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\
\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->211589091],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "\[GreaterEqual]", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]], "Output",
 ImageSize->{238, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->799286143]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " to decide the sign of algebraic numbers:"
}], "ExampleText",
 CellID->653568966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RootReduce", "[", 
   RowBox[{
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "-", 
    RowBox[{"%", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[GreaterEqual]", 
  "0"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->195979928],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->67532917]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101652918],

Cell[TextData[{
 "Numeric methods used by ",
 Cell[BoxData[
  ButtonBox["GreaterEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GreaterEqual"]], "InlineFormula"],
 " do not use sufficient precision to disprove this:"
}], "ExampleText",
 CellID->192423184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "\[GreaterEqual]", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "4"}], "-", 
       RowBox[{"10", 
        RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], "]"}], "+", 
   
   RowBox[{"10", "^", 
    RowBox[{"-", "100"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1546846],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\(\\(-\\(\\(1\\/\\(10000000000000000000000 \
\\(\\(\[LeftSkeleton] 54 \[RightSkeleton]\\)\\) \
000000000000000000000000\\)\\)\\)\\)\\) + \\@2 + \\@3 - \
\\(\\(Root[\\(\\(\\(\\(\\(\\(1 - \\(\\(10\\\\ \\(Slot[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^2\\)\\) + #1\\^4\\)\\) &\\)\\), 4, \
0\\)\\)]\\)\\)\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\
\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->88889774],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "\[GreaterEqual]", 
  RowBox[{
   RowBox[{
   "1", "/", 
    "1000000000000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000"}], "+", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]}]], "Output",
 ImageSize->{557, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88850957]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " disproves the inequality using exact methods:"
}], "ExampleText",
 CellID->384720156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RootReduce", "[", 
   RowBox[{
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}], "-", 
    RowBox[{"%", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "\[GreaterEqual]", 
  "0"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->476886642],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8004979]
}, Open  ]],

Cell[TextData[{
 "Increasing ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " may disprove the inequality:"
}], "ExampleText",
 CellID->321641904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "100"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "\[GreaterEqual]", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"#", "^", "4"}], "-", 
         RowBox[{"10", 
          RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], "]"}], 
     "+", 
     RowBox[{"10", "^", 
      RowBox[{"-", "100"}]}]}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1018235179],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14354858]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Symbolic Inequalities",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->500815976],

Cell[TextData[{
 "Symbolic inequalities remain unevaluated, since ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " may not be a real number:"
}], "ExampleText",
 CellID->152622296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "\[GreaterEqual]", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148403671],

Cell[BoxData[
 RowBox[{"x", "\[GreaterEqual]", "x"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159470896]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " to re-evaluate the inequality assuming that ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is real:"
}], "ExampleText",
 CellID->251683421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Reals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->205622433],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7912675]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6517873],

Cell["A symbolic inequality:", "ExampleText",
 CellID->277125212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ineq", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"y", "^", "2"}]}], "\[GreaterEqual]", "1"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->486416913],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "2"], "-", 
   SuperscriptBox["y", "2"]}], "\[GreaterEqual]", "1"}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140230605]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to find an explicit description of the solution set:"
}], "ExampleText",
 CellID->113363578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"ineq", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145270882],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["x", "2"]}]]}], "\[LessEqual]", "y", "\[LessEqual]", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", ">", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["x", "2"]}]]}], "\[LessEqual]", "y", "\[LessEqual]", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{374, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->248738059]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find a solution instance:"
}], "ExampleText",
 CellID->220870228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{"ineq", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->159052583],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     SqrtBox["2"]}], ",", 
    RowBox[{"y", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 ImageSize->{121, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->10709968]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " to optimize over the region defined by the inequality:"
}], "ExampleText",
 CellID->279307693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", "ineq"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->34810484],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->17586902]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " to simplify under assumptions defined by the inequality:"
}], "ExampleText",
 CellID->266015669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}], "]"}], ",", "ineq"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->450815041],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->147367621]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->641873845],

Cell[TextData[{
 "The negation of two-argument ",
 Cell[BoxData[
  ButtonBox["GreaterEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GreaterEqual"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Less",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Less"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14000026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"x", "\[GreaterEqual]", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->785552779],

Cell[BoxData[
 RowBox[{"x", "<", "y"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14798363]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->417573680],

Cell[TextData[{
 "The negation of three-argument ",
 Cell[BoxData[
  ButtonBox["GreaterEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GreaterEqual"]], "InlineFormula"],
 " does not simplify automatically:"
}], "ExampleText",
 CellID->179461278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"x", "\[GreaterEqual]", "y", "\[GreaterEqual]", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->900203775],

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"x", "\[GreaterEqual]", "y", "\[GreaterEqual]", "z"}]}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->891167807]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to express the negation in terms of two-argument ",
 Cell[BoxData[
  ButtonBox["Less",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Less"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->103307650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->602057068],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "<", "y"}], "||", 
  RowBox[{"y", "<", "z"}]}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->110721344]
}, Open  ]],

Cell[TextData[{
 "This is not equivalent to three-argument ",
 Cell[BoxData[
  ButtonBox["Less",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Less"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22272967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"x", "<", "y", "<", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->41719149],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "<", "y"}], "&&", 
  RowBox[{"y", "<", "z"}]}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->97488124]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->332044293],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["GreaterEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GreaterEqual"]], "InlineFormula"],
 " cannot decide an inequality it returns unchanged:"
}], "ExampleText",
 CellID->294478095],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"5", "+", 
      RowBox[{"2", 
       RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}], "/", "2"}]}], 
  ";"}], "\n", 
 RowBox[{"a", "\[GreaterEqual]", "b"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->174240470],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\(\\(Log[\\(\\(\\@2 + \\@3\\)\\)]\\)\\) - \\(\
\\(1\\/2\\\\ \\(\\(Log[\\(\\(5 + \\(\\(2\\\\ \
\\@6\\)\\)\\)\\)]\\)\\)\\)\\)\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->52185185],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}], "]"}], "\[GreaterEqual]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", " ", 
      SqrtBox["6"]}]}], "]"}]}]}]], "Output",
 ImageSize->{216, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86357913]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " uses exact symbolic transformations to prove the inequality:"
}], "ExampleText",
 CellID->631563206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106030961],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->58020271]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->154672456],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NonNegative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NonNegative"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "\[Element]", 
     TagBox["\[DoubleStruckCapitalR]",
      Function[{}, Reals]]}], "\[And]", 
    RowBox[{"x", "\[GreaterEqual]", "0"}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->265821182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonNegative", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "I"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->875674151],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "True", ",", "True", ",", "False"}], "}"}]], "Output",\

 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56371245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104709778],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to solve inequalities:"
}], "ExampleText",
 CellID->198169361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"3", "x"}], "+", "2"}], "\[GreaterEqual]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->821314495],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", "#1", "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], "\[LessEqual]", 
   "x", "\[LessEqual]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", "#1", "+", 
       SuperscriptBox["#1", "2"], "+", 
       SuperscriptBox["#1", "3"], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "||", 
  RowBox[{"x", "\[GreaterEqual]", "1"}]}]], "Output",
 ImageSize->{504, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62677011]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23944515],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "\[Element]", "Reals"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", 
     RowBox[{"-", "1"}]}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "\[LessEqual]", "x", "\[LessEqual]", "1"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[LessEqual]", 
         RowBox[{"-", 
          SqrtBox[
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["x", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["x", "4"]}]}]]}]}], "||", 
        RowBox[{"y", "\[GreaterEqual]", 
         SqrtBox[
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["x", "2"]}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["x", "4"]}]}]]}]}], ")"}]}], ")"}], "||", 
    RowBox[{"x", ">", "1"}]}], ")"}]}]], "Output",
 ImageSize->{524, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->973509883]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245128882],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find solution instances:"
}], "ExampleText",
 CellID->168284260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], "\[GreaterEqual]", 
    RowBox[{"z", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->349268992],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", "0"}], ",", 
    RowBox[{"z", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->187615127]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->299007588],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RegionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFormula"],
 " to visualize solution sets of inequalities:"
}], "ExampleText",
 CellID->45723834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], "\[GreaterEqual]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->412249041],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171664484]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"4", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "4"}]}]}], "\[GreaterEqual]", 
    RowBox[{"z", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->467824785],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->131995599]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->801133649],

Cell["Inequality assumptions:", "ExampleText",
 CellID->491856522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"x", "\[GreaterEqual]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->610693880],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99379999]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"a", "^", "n"}], ",", 
   RowBox[{"n", "\[Rule]", "Infinity"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"a", "\[GreaterEqual]", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->135321853],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->69520292]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->275826910],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " to solve optimization problems constrained by inequalities:"
}], "ExampleText",
 CellID->41301620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"y", "^", "2"}]}], "+", 
       RowBox[{"4", 
        RowBox[{"x", "^", "2"}]}], "-", 
       RowBox[{"4", 
        RowBox[{"x", "^", "4"}]}]}], "\[GreaterEqual]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140887538],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"27", "-", 
       RowBox[{"207", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"64", " ", 
        SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"27", "-", 
           RowBox[{"207", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"64", " ", 
            SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}], "+", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"48", "-", 
           RowBox[{"111", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"64", " ", 
            SuperscriptBox["#1", "4"]}]}], "&"}], ",", "4"}], "]"}]}]}], ",", 
     
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"48", "-", 
          RowBox[{"111", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          RowBox[{"64", " ", 
           SuperscriptBox["#1", "4"]}]}], "&"}], ",", "4"}], "]"}]}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{441, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143367529]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7164590],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 " to numerically solve constrained optimization problems:"
}], "ExampleText",
 CellID->6890151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", " ", 
     RowBox[{"2", "\[GreaterEqual]", 
      RowBox[{
       RowBox[{"Tan", "[", "x", "]"}], "+", 
       RowBox[{"Tan", "[", "y", "]"}]}], "\[GreaterEqual]", "1"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4920993],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.1401408407383853`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.5700700002562602`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "1.5700708404821253`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161518193]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->568359519],

Cell["Integrate a function over the solution set of inequalities:", \
"ExampleText",
 CellID->598038955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], " ", 
    RowBox[{"Boole", "[", 
     RowBox[{"2", "\[GreaterEqual]", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[GreaterEqual]", "1"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16786161],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", "\[Pi]"}], "4"]], "Output",
 ImageSize->{27, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22332277]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->788293728],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Quartiles",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quartiles"]], "InlineFormula"],
 " to the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["n", "th"], TraditionalForm]], "InlineMath"],
 " greatest number(s): "
}], "ExampleText",
 CellID->798766],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2", ",", "x3"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->662995740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x3", "\[GreaterEqual]", "x2", "\[GreaterEqual]", "x1"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10873149],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->107833571]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"{", 
   RowBox[{"x2", ",", "x3", ",", "x1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->81695411],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->842714739]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->178645415],

Cell["\<\
Inequalities for machine-precision approximate numbers can be subtle: \
\>", "ExampleText",
 CellID->41935142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0.00001", "\[GreaterEqual]", " ", 
  RowBox[{"2.00006", "-", "2.00005"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107589248],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->204382025]
}, Open  ]],

Cell["The result is determined based on extra digits:", "ExampleText",
 CellID->454896623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.00006", "-", "2.00005"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->385657575],

Cell["0.000010000000000065512", "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->26176701]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->236675103],

Cell["\<\
Arbitrary-precision approximate numbers do not have this problem:\
\>", "ExampleText",
 CellID->8503680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0.00001`16", "\[GreaterEqual]", 
  RowBox[{"2.00006`16", "-", "2.00005`16"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108479341],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->296433286]
}, Open  ]],

Cell[TextData[{
 "Thanks to automatic precision tracking, ",
 Cell[BoxData[
  ButtonBox["GreaterEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GreaterEqual"]], "InlineFormula"],
 " knows to look only at the first ten digits:"
}], "ExampleText",
 CellID->446345418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", 
  RowBox[{"2.00006`16", "-", "2.00005`16"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->501825511],

Cell[BoxData["10.397928065738002`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->158081114]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->289518584],

Cell["\<\
In this case, inequality between machine numbers gives the expected result:\
\>", "ExampleText",
 CellID->220036716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0.1", "\[GreaterEqual]", 
  RowBox[{"2.6", "-", "2.5"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->544352754],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69554072]
}, Open  ]],

Cell[TextData[{
 "The extra digits in this case are ignored by ",
 Cell[BoxData[
  ButtonBox["GreaterEqual",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GreaterEqual"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->148366025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.6", "-", "2.5"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->551042265],

Cell["0.10000000000000009", "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->293483794]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5136],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Greater",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Greater"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LessEqual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LessEqual"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29052]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20101],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RelationalAndLogicalOperators"]], "Tutorials",
 CellID->29384]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->356913208],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "MoreAbout",
 CellID->226216396]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GreaterEqual (>=, \[GreaterEqual]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 0.5214754}", "context" -> "System`", 
    "keywords" -> {"inequality", "order relation", "weak inequality"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "x >= y or x >= y yields True if x is determined to be greater than or \
equal to y. x_1 >= x_2 >= x_3 yields True if the x_i form a non-increasing \
sequence. ", "synonyms" -> {"greater equal", ">="}, "title" -> "GreaterEqual",
     "type" -> "Symbol", "uri" -> "ref/GreaterEqual"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8114, 283, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->55372502]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 83473, 2695}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2168, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2791, 79, 123, 4, 70, "ObjectName",
 CellID->30856],
Cell[2917, 85, 1569, 52, 70, "Usage",
 CellID->30180]
}, Open  ]],
Cell[CellGroupData[{
Cell[4523, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5001, 159, 607, 24, 70, "Notes",
 CellID->26429],
Cell[5611, 185, 458, 17, 70, "Notes",
 CellID->24537],
Cell[6072, 204, 237, 7, 70, "Notes",
 CellID->13629],
Cell[6312, 213, 500, 14, 70, "Notes",
 CellID->18389],
Cell[6815, 229, 393, 15, 70, "Notes",
 CellID->9843],
Cell[7211, 246, 866, 32, 70, "Notes",
 CellID->7004]
}, Closed]],
Cell[CellGroupData[{
Cell[8114, 283, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->55372502],
Cell[CellGroupData[{
Cell[8498, 297, 148, 5, 70, "ExampleSection",
 CellID->189892057],
Cell[8649, 304, 59, 1, 70, "ExampleText",
 CellID->192662955],
Cell[CellGroupData[{
Cell[8733, 309, 106, 3, 28, "Input",
 CellID->107391370],
Cell[8842, 314, 160, 5, 36, "Output",
 CellID->58359964]
}, Open  ]],
Cell[CellGroupData[{
Cell[9039, 324, 202, 6, 28, "Input",
 CellID->765975626],
Cell[9244, 332, 162, 5, 36, "Output",
 CellID->505375536]
}, Open  ]],
Cell[9421, 340, 125, 3, 70, "ExampleDelimiter",
 CellID->275922434],
Cell[9549, 345, 66, 1, 70, "ExampleText",
 CellID->27494034],
Cell[CellGroupData[{
Cell[9640, 350, 182, 6, 70, "Input",
 CellID->402385732],
Cell[9825, 358, 276, 9, 36, "Output",
 CellID->401280635]
}, Open  ]],
Cell[CellGroupData[{
Cell[10138, 372, 124, 4, 70, "Input",
 CellID->34392874],
Cell[10265, 378, 546, 20, 51, "Output",
 CellID->848590516]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10860, 404, 220, 7, 70, "ExampleSection",
 CellID->904235151],
Cell[CellGroupData[{
Cell[11105, 415, 240, 7, 70, "ExampleSubsection",
 CellID->26431756],
Cell[11348, 424, 89, 1, 70, "ExampleText",
 CellID->95488339],
Cell[CellGroupData[{
Cell[11462, 429, 106, 3, 70, "Input",
 CellID->251460291],
Cell[11571, 434, 391, 7, 70, "Message",
 CellID->648543676],
Cell[11965, 443, 206, 6, 36, "Output",
 CellID->141497344]
}, Open  ]],
Cell[12186, 452, 125, 3, 70, "ExampleDelimiter",
 CellID->155816487],
Cell[12314, 457, 68, 1, 70, "ExampleText",
 CellID->234143528],
Cell[CellGroupData[{
Cell[12407, 462, 152, 5, 70, "Input",
 CellID->241292235],
Cell[12562, 469, 160, 5, 36, "Output",
 CellID->37804184]
}, Open  ]],
Cell[12737, 477, 125, 3, 70, "ExampleDelimiter",
 CellID->140624971],
Cell[12865, 482, 148, 4, 70, "ExampleText",
 CellID->120866437],
Cell[CellGroupData[{
Cell[13038, 490, 227, 8, 70, "Input",
 CellID->37738947],
Cell[13268, 500, 160, 5, 36, "Output",
 CellID->83576382]
}, Open  ]],
Cell[CellGroupData[{
Cell[13465, 510, 228, 8, 70, "Input",
 CellID->525645198],
Cell[13696, 520, 162, 5, 36, "Output",
 CellID->266552318]
}, Open  ]],
Cell[13873, 528, 125, 3, 70, "ExampleDelimiter",
 CellID->411298638],
Cell[14001, 533, 113, 3, 70, "ExampleText",
 CellID->449273801],
Cell[CellGroupData[{
Cell[14139, 540, 161, 5, 70, "Input",
 CellID->315310371],
Cell[14303, 547, 161, 5, 36, "Output",
 CellID->128997276]
}, Open  ]],
Cell[CellGroupData[{
Cell[14501, 557, 333, 12, 70, "Input",
 CellID->331846797],
Cell[14837, 571, 161, 5, 36, "Output",
 CellID->17936002]
}, Open  ]],
Cell[15013, 579, 125, 3, 70, "ExampleDelimiter",
 CellID->436796394],
Cell[15141, 584, 139, 4, 70, "ExampleText",
 CellID->174582969],
Cell[CellGroupData[{
Cell[15305, 592, 154, 5, 70, "Input",
 CellID->398884990],
Cell[15462, 599, 160, 5, 36, "Output",
 CellID->20378373]
}, Open  ]],
Cell[15637, 607, 93, 1, 70, "ExampleText",
 CellID->207797078],
Cell[CellGroupData[{
Cell[15755, 612, 302, 10, 70, "Input",
 CellID->142094998],
Cell[16060, 624, 161, 5, 36, "Output",
 CellID->396948086]
}, Open  ]],
Cell[16236, 632, 124, 3, 70, "ExampleDelimiter",
 CellID->41262348],
Cell[16363, 637, 270, 8, 70, "ExampleText",
 CellID->135341977],
Cell[CellGroupData[{
Cell[16658, 649, 386, 14, 70, "Input",
 CellID->180221533],
Cell[17047, 665, 591, 11, 70, "Message",
 CellID->211589091],
Cell[17641, 678, 442, 16, 41, "Output",
 CellID->799286143]
}, Open  ]],
Cell[18098, 697, 231, 8, 70, "ExampleText",
 CellID->653568966],
Cell[CellGroupData[{
Cell[18354, 709, 282, 10, 70, "Input",
 CellID->195979928],
Cell[18639, 721, 160, 5, 36, "Output",
 CellID->67532917]
}, Open  ]],
Cell[18814, 729, 125, 3, 70, "ExampleDelimiter",
 CellID->101652918],
Cell[18942, 734, 264, 8, 70, "ExampleText",
 CellID->192423184],
Cell[CellGroupData[{
Cell[19231, 746, 461, 17, 70, "Input",
 CellID->1546846],
Cell[19695, 765, 728, 13, 70, "Message",
 CellID->88889774],
Cell[20426, 780, 606, 21, 75, "Output",
 CellID->88850957]
}, Open  ]],
Cell[21047, 804, 227, 7, 70, "ExampleText",
 CellID->384720156],
Cell[CellGroupData[{
Cell[21299, 815, 282, 10, 70, "Input",
 CellID->476886642],
Cell[21584, 827, 160, 5, 36, "Output",
 CellID->8004979]
}, Open  ]],
Cell[21759, 835, 242, 8, 70, "ExampleText",
 CellID->321641904],
Cell[CellGroupData[{
Cell[22026, 847, 616, 21, 70, "Input",
 CellID->1018235179],
Cell[22645, 870, 161, 5, 36, "Output",
 CellID->14354858]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22855, 881, 242, 7, 70, "ExampleSubsection",
 CellID->500815976],
Cell[23100, 890, 194, 6, 70, "ExampleText",
 CellID->152622296],
Cell[CellGroupData[{
Cell[23319, 900, 106, 3, 70, "Input",
 CellID->148403671],
Cell[23428, 905, 194, 6, 36, "Output",
 CellID->159470896]
}, Open  ]],
Cell[23637, 914, 298, 11, 70, "ExampleText",
 CellID->251683421],
Cell[CellGroupData[{
Cell[23960, 929, 189, 6, 70, "Input",
 CellID->205622433],
Cell[24152, 937, 159, 5, 36, "Output",
 CellID->7912675]
}, Open  ]],
Cell[24326, 945, 123, 3, 70, "ExampleDelimiter",
 CellID->6517873],
Cell[24452, 950, 65, 1, 70, "ExampleText",
 CellID->277125212],
Cell[CellGroupData[{
Cell[24542, 955, 206, 7, 70, "Input",
 CellID->486416913],
Cell[24751, 964, 267, 9, 36, "Output",
 CellID->140230605]
}, Open  ]],
Cell[25033, 976, 235, 8, 70, "ExampleText",
 CellID->113363578],
Cell[CellGroupData[{
Cell[25293, 988, 177, 6, 70, "Input",
 CellID->145270882],
Cell[25473, 996, 1156, 42, 84, "Output",
 CellID->248738059]
}, Open  ]],
Cell[26644, 1041, 223, 8, 70, "ExampleText",
 CellID->220870228],
Cell[CellGroupData[{
Cell[26892, 1053, 183, 6, 70, "Input",
 CellID->159052583],
Cell[27078, 1061, 304, 11, 43, "Output",
 CellID->10709968]
}, Open  ]],
Cell[27397, 1075, 241, 8, 70, "ExampleText",
 CellID->279307693],
Cell[CellGroupData[{
Cell[27663, 1087, 253, 9, 70, "Input",
 CellID->34810484],
Cell[27919, 1098, 338, 12, 36, "Output",
 CellID->17586902]
}, Open  ]],
Cell[28272, 1113, 239, 8, 70, "ExampleText",
 CellID->266015669],
Cell[CellGroupData[{
Cell[28536, 1125, 269, 10, 70, "Input",
 CellID->450815041],
Cell[28808, 1137, 222, 8, 36, "Output",
 CellID->147367621]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[29091, 1152, 238, 7, 70, "ExampleSection",
 CellID->641873845],
Cell[29332, 1161, 339, 13, 70, "ExampleText",
 CellID->14000026],
Cell[CellGroupData[{
Cell[29696, 1178, 136, 4, 70, "Input",
 CellID->785552779],
Cell[29835, 1184, 179, 6, 36, "Output",
 CellID->14798363]
}, Open  ]],
Cell[30029, 1193, 125, 3, 70, "ExampleDelimiter",
 CellID->417573680],
Cell[30157, 1198, 254, 8, 70, "ExampleText",
 CellID->179461278],
Cell[CellGroupData[{
Cell[30436, 1210, 163, 5, 70, "Input",
 CellID->900203775],
Cell[30602, 1217, 236, 7, 36, "Output",
 CellID->891167807]
}, Open  ]],
Cell[30853, 1227, 363, 13, 70, "ExampleText",
 CellID->103307650],
Cell[CellGroupData[{
Cell[31241, 1244, 109, 3, 70, "Input",
 CellID->602057068],
Cell[31353, 1249, 227, 8, 36, "Output",
 CellID->110721344]
}, Open  ]],
Cell[31595, 1260, 215, 8, 70, "ExampleText",
 CellID->22272967],
Cell[CellGroupData[{
Cell[31835, 1272, 141, 4, 70, "Input",
 CellID->41719149],
Cell[31979, 1278, 226, 8, 36, "Output",
 CellID->97488124]
}, Open  ]],
Cell[32220, 1289, 125, 3, 70, "ExampleDelimiter",
 CellID->332044293],
Cell[32348, 1294, 245, 8, 70, "ExampleText",
 CellID->294478095],
Cell[CellGroupData[{
Cell[32618, 1306, 477, 17, 70, "Input",
 CellID->174240470],
Cell[33098, 1325, 538, 10, 70, "Message",
 CellID->52185185],
Cell[33639, 1337, 419, 16, 51, "Output",
 CellID->86357913]
}, Open  ]],
Cell[34073, 1356, 246, 7, 70, "ExampleText",
 CellID->631563206],
Cell[CellGroupData[{
Cell[34344, 1367, 108, 3, 70, "Input",
 CellID->106030961],
Cell[34455, 1372, 160, 5, 36, "Output",
 CellID->58020271]
}, Open  ]],
Cell[34630, 1380, 125, 3, 70, "ExampleDelimiter",
 CellID->154672456],
Cell[34758, 1385, 490, 18, 70, "ExampleText",
 CellID->265821182],
Cell[CellGroupData[{
Cell[35273, 1407, 190, 6, 70, "Input",
 CellID->875674151],
Cell[35466, 1415, 239, 8, 36, "Output",
 CellID->56371245]
}, Open  ]],
Cell[35720, 1426, 125, 3, 70, "ExampleDelimiter",
 CellID->104709778],
Cell[35848, 1431, 205, 8, 70, "ExampleText",
 CellID->198169361],
Cell[CellGroupData[{
Cell[36078, 1443, 248, 9, 70, "Input",
 CellID->821314495],
Cell[36329, 1454, 775, 25, 39, "Output",
 CellID->62677011]
}, Open  ]],
Cell[CellGroupData[{
Cell[37141, 1484, 368, 13, 70, "Input",
 CellID->23944515],
Cell[37512, 1499, 1016, 33, 52, "Output",
 CellID->973509883]
}, Open  ]],
Cell[38543, 1535, 125, 3, 70, "ExampleDelimiter",
 CellID->245128882],
Cell[38671, 1540, 222, 8, 70, "ExampleText",
 CellID->168284260],
Cell[CellGroupData[{
Cell[38918, 1552, 410, 14, 70, "Input",
 CellID->349268992],
Cell[39331, 1568, 331, 11, 36, "Output",
 CellID->187615127]
}, Open  ]],
Cell[39677, 1582, 125, 3, 70, "ExampleDelimiter",
 CellID->299007588],
Cell[39805, 1587, 370, 13, 70, "ExampleText",
 CellID->45723834],
Cell[CellGroupData[{
Cell[40200, 1604, 494, 17, 70, "Input",
 CellID->412249041],
Cell[40697, 1623, 5129, 88, 70, "Output",
 Evaluatable->False,
 CellID->171664484]
}, Open  ]],
Cell[CellGroupData[{
Cell[45863, 1716, 611, 21, 70, "Input",
 CellID->467824785],
Cell[46477, 1739, 21990, 365, 70, "Output",
 Evaluatable->False,
 CellID->131995599]
}, Open  ]],
Cell[68482, 2107, 125, 3, 70, "ExampleDelimiter",
 CellID->801133649],
Cell[68610, 2112, 66, 1, 70, "ExampleText",
 CellID->491856522],
Cell[CellGroupData[{
Cell[68701, 2117, 220, 7, 70, "Input",
 CellID->610693880],
Cell[68924, 2126, 157, 5, 36, "Output",
 CellID->99379999]
}, Open  ]],
Cell[CellGroupData[{
Cell[69118, 2136, 274, 8, 70, "Input",
 CellID->135321853],
Cell[69395, 2146, 167, 5, 36, "Output",
 CellID->69520292]
}, Open  ]],
Cell[69577, 2154, 125, 3, 70, "ExampleDelimiter",
 CellID->275826910],
Cell[69705, 2159, 374, 13, 70, "ExampleText",
 CellID->41301620],
Cell[CellGroupData[{
Cell[70104, 2176, 489, 17, 70, "Input",
 CellID->140887538],
Cell[70596, 2195, 1391, 46, 77, "Output",
 CellID->143367529]
}, Open  ]],
Cell[72002, 2244, 123, 3, 70, "ExampleDelimiter",
 CellID->7164590],
Cell[72128, 2249, 373, 13, 70, "ExampleText",
 CellID->6890151],
Cell[CellGroupData[{
Cell[72526, 2266, 420, 14, 70, "Input",
 CellID->4920993],
Cell[72949, 2282, 415, 14, 36, "Output",
 CellID->161518193]
}, Open  ]],
Cell[73379, 2299, 125, 3, 70, "ExampleDelimiter",
 CellID->568359519],
Cell[73507, 2304, 104, 2, 70, "ExampleText",
 CellID->598038955],
Cell[CellGroupData[{
Cell[73636, 2310, 555, 17, 70, "Input",
 CellID->16786161],
Cell[74194, 2329, 204, 7, 51, "Output",
 CellID->22332277]
}, Open  ]],
Cell[74413, 2339, 125, 3, 70, "ExampleDelimiter",
 CellID->788293728],
Cell[74541, 2344, 561, 22, 70, "ExampleText",
 CellID->798766],
Cell[75105, 2368, 231, 8, 70, "Input",
 CellID->662995740],
Cell[CellGroupData[{
Cell[75361, 2380, 132, 3, 70, "Input",
 CellID->10873149],
Cell[75496, 2385, 161, 5, 36, "Output",
 CellID->107833571]
}, Open  ]],
Cell[CellGroupData[{
Cell[75694, 2395, 161, 5, 70, "Input",
 CellID->81695411],
Cell[75858, 2402, 158, 5, 36, "Output",
 CellID->842714739]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[76065, 2413, 230, 7, 70, "ExampleSection",
 CellID->178645415],
Cell[76298, 2422, 120, 3, 70, "ExampleText",
 CellID->41935142],
Cell[CellGroupData[{
Cell[76443, 2429, 152, 4, 70, "Input",
 CellID->107589248],
Cell[76598, 2435, 162, 5, 36, "Output",
 CellID->204382025]
}, Open  ]],
Cell[76775, 2443, 90, 1, 70, "ExampleText",
 CellID->454896623],
Cell[CellGroupData[{
Cell[76890, 2448, 136, 4, 70, "Input",
 CellID->385657575],
Cell[77029, 2454, 182, 5, 50, "Output",
 CellID->26176701]
}, Open  ]],
Cell[77226, 2462, 125, 3, 70, "ExampleDelimiter",
 CellID->236675103],
Cell[77354, 2467, 114, 3, 70, "ExampleText",
 CellID->8503680],
Cell[CellGroupData[{
Cell[77493, 2474, 156, 4, 70, "Input",
 CellID->108479341],
Cell[77652, 2480, 161, 5, 36, "Output",
 CellID->296433286]
}, Open  ]],
Cell[77828, 2488, 274, 8, 70, "ExampleText",
 CellID->446345418],
Cell[CellGroupData[{
Cell[78127, 2500, 146, 4, 70, "Input",
 CellID->501825511],
Cell[78276, 2506, 176, 5, 36, "Output",
 CellID->158081114]
}, Open  ]],
Cell[78467, 2514, 125, 3, 70, "ExampleDelimiter",
 CellID->289518584],
Cell[78595, 2519, 126, 3, 70, "ExampleText",
 CellID->220036716],
Cell[CellGroupData[{
Cell[78746, 2526, 135, 4, 70, "Input",
 CellID->544352754],
Cell[78884, 2532, 160, 5, 36, "Output",
 CellID->69554072]
}, Open  ]],
Cell[79059, 2540, 236, 8, 70, "ExampleText",
 CellID->148366025],
Cell[CellGroupData[{
Cell[79320, 2552, 128, 4, 70, "Input",
 CellID->551042265],
Cell[79451, 2558, 179, 5, 50, "Output",
 CellID->293483794]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[79691, 2570, 310, 9, 70, "SeeAlsoSection",
 CellID->5136],
Cell[80004, 2581, 1196, 44, 70, "SeeAlso",
 CellID->29052]
}, Open  ]],
Cell[CellGroupData[{
Cell[81237, 2630, 314, 9, 70, "TutorialsSection",
 CellID->20101],
Cell[81554, 2641, 172, 3, 70, "Tutorials",
 CellID->29384]
}, Open  ]],
Cell[CellGroupData[{
Cell[81763, 2649, 319, 9, 70, "MoreAboutSection",
 CellID->356913208],
Cell[82085, 2660, 136, 3, 70, "MoreAbout",
 CellID->226216396]
}, Open  ]],
Cell[82236, 2666, 50, 0, 70, "History"],
Cell[82289, 2668, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

