(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    191056,       6625]
NotebookOptionsPosition[    161268,       5586]
NotebookOutlinePosition[    162634,       5625]
CellTagsIndexPosition[    162547,       5620]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"], 
          "Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Tables and Matrices\"\>", 
       2->"\<\"Grids, Rows, and Columns in Mathematica\"\>", 
       3->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphicsGrid" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsGrid"], "Row" :> 
          Documentation`HelpLookup["paclet:ref/Row"], "Column" :> 
          Documentation`HelpLookup["paclet:ref/Column"], "TableForm" :> 
          Documentation`HelpLookup["paclet:ref/TableForm"], "MatrixForm" :> 
          Documentation`HelpLookup["paclet:ref/MatrixForm"], "ArrayPlot" :> 
          Documentation`HelpLookup["paclet:ref/ArrayPlot"], "MatrixPlot" :> 
          Documentation`HelpLookup["paclet:ref/MatrixPlot"], "Labeled" :> 
          Documentation`HelpLookup["paclet:ref/Labeled"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GraphicsGrid\"\>", 2->"\<\"Row\"\>", 
       3->"\<\"Column\"\>", 4->"\<\"TableForm\"\>", 5->"\<\"MatrixForm\"\>", 
       6->"\<\"ArrayPlot\"\>", 7->"\<\"MatrixPlot\"\>", 
       8->"\<\"Labeled\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], "Palettes" :> 
          Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Document Generation\"\>", 
       2->"\<\"Grids & Tables\"\>", 3->"\<\"Handling Arrays of Data\"\>", 
       4->"\<\"Layout & Tables\"\>", 5->"\<\"Mathematical Typesetting\"\>", 
       6->"\<\"Notebook Formatting & Styling\"\>", 7->"\<\"Palettes\"\>", 
       8->"\<\"Stand-Alone Interfaces\"\>", 
       9->"\<\"User Interface Structuring & Layout\"\>", 
       10->"\<\"New in 6.0: Formatting & Styling\"\>", 
       11->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Grid", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Grid",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Grid"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["expr", "TI"], 
            StyleBox["11", "TR"]], ",", 
           SubscriptBox[
            StyleBox["expr", "TI"], 
            StyleBox["12", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["expr", "TI"], 
            StyleBox["21", "TR"]], ",", 
           SubscriptBox[
            StyleBox["expr", "TI"], 
            StyleBox["22", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is an object that formats with the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["ij", "TI"]]], "InlineFormula"],
     " arranged in a two\[Hyphen]dimensional grid. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21649]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In a notebook, you can enter expressions in a two\[Hyphen]dimensional \
layout by using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[",", "KeyEvent"],
 " to add columns and ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Return", "KeyEvent"],
 " to add rows. By default, this layout evaluates to a nested list. You can \
make a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " that preserves the layout by using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"], "[", 
   StyleBox["layout", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10485],

Cell[TextData[{
 "You can use ",
 StyleBox["Tab", "KeyEvent"],
 " to move to the next placeholder in a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ". ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " moves out of the whole ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7055],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " formats as a grid in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12572],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " formats literally as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12889],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["First",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/First"], "[", 
   StyleBox["grid", "TI"], "]"}]], "InlineFormula"],
 " extracts the list of lists that make up a grid. "
}], "Notes",
 CellID->2858],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " can be expressions of any kind, including graphics and controls. "
}], "Notes",
 CellID->17552],

Cell[TextData[{
 "You can enter text in an element of a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " by giving it as a string. You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Text",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Text"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " to specify a particular style. "
}], "Notes",
 CellID->129],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " do not all need to be the same length; there will be empty space in the \
grid at the ends of shorter rows. "
}], "Notes",
 CellID->14640],

Cell[TextData[{
 "You can specify that an element ",
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 " should span multiple positions in a grid using for example ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["e", "TI"], ",", 
       ButtonBox["SpanFromLeft",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SpanFromLeft"], ",", 
       ButtonBox["SpanFromLeft",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SpanFromLeft"]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6860],

Cell["\<\
The following specify that a particular position should be spanned: \
\>", "Notes",
 CellID->8046],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SpanFromLeft",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanFromLeft"], Cell[
    "span from left ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SpanFromAbove",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanFromAbove"], Cell[
    "span from above ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SpanFromBoth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanFromBoth"], Cell[
    "span from both left and above ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->28627],

Cell[TextData[{
 "A particular element can span both multiple rows and multiple columns, by \
having a rectangular section of the array with the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["e", "TI"], ",", 
      ButtonBox["SpanFromLeft",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpanFromLeft"], ",", 
      ButtonBox["SpanFromLeft",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpanFromLeft"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ","}]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      ButtonBox["SpanFromAbove",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpanFromAbove"], ",", 
      ButtonBox["SpanFromBoth",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpanFromBoth"], ",", 
      ButtonBox["SpanFromBoth",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpanFromBoth"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5044],

Cell[TextData[{
 "In a notebook, you can combine selected elements in a grid to make a single \
spanning element using the ",
 StyleBox["Make Spanning", "MenuName"],
 " menu item. "
}], "Notes",
 CellID->6422],

Cell["The following options can be given: ", "Notes",
 CellID->19154],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"], ",", 
      ButtonBox["Baseline",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Baseline"]}], "}"}], Cell[
    "horizontal and vertical alignment of items", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what background colors to use ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what to align with a surrounding text baseline", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the grid", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DefaultElement",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DefaultElement"], "\"\<\[Placeholder]\>\"", Cell[
    "what element to insert in an empty item", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Dividers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dividers"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to draw divider lines in the grid", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to draw frames in the grid ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style to use for frames ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ItemSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ItemSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "width and height of each item ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ItemStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ItemStyle"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "styles for columns and rows ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Spacings",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Spacings"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "horizontal and vertical spacings ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->333],

Cell[TextData[{
 "Common settings for ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " include: "
}], "Notes",
 CellID->13269],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "frame around the whole grid ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "frame around every item in the grid ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell[
    "draw interior frames only", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"], ",", 
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]}], "}"}], Cell[
    "put a frame at every horizontal position (column lines) ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"], ",", 
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"]}], "}"}], Cell[
    "put a frame at every vertical position (row lines)", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->5388],

Cell[TextData[{
 "Settings for the options ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ItemSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ItemStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemStyle"]], "InlineFormula"],
 " can be given as follows to apply separately to different items: "
}], "Notes",
 CellID->8756],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["spec", "TI"], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " to all items "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["spec", "TI"], 
      StyleBox["x", "TI"]], "}"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]]], "InlineFormula"],
     " at successive horizontal positions"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " at successive horizontal and vertical positions"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    FormBox[
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["spec", "TI"], 
        StyleBox["x", "TI"]], ",", 
       SubscriptBox[
        StyleBox["spec", "TI"], 
        StyleBox["y", "TI"]], ",", 
       StyleBox["rules", "TI"]}], "}"}],
     TraditionalForm], Cell[TextData[{
     "also allow explicit rules for individual ",
     Cell[BoxData[
      FormBox[
       RowBox[{"i", ",", "j"}], TraditionalForm]], "InlineMath"],
     " elements"
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->194396524],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " can have the following forms:"
}], "Notes",
 CellID->25391],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "1"], TraditionalForm]], "InlineMath"],
     " through ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "n"], TraditionalForm]], "InlineMath"],
     "; then use defaults "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      StyleBox["c", "TI"], "}"}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     " in all cases "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]]}], "}"}], "}"}], Cell[TextData[{
     "alternate between ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", "1"], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", "2"], TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}], Cell[TextData[{
     "cycle through all ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     ", then repeatedly use ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "1"], TraditionalForm]], "InlineMath"],
     ", then repeatedly use ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     ", but use ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "n"], TraditionalForm]], "InlineMath"],
     " at the end "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        RowBox[{"{", 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["1", "TR"]]}]}]}], Cell[", ", "TableText"], 
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]], Cell[", \[Ellipsis] }, ", "TableText"], 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], Cell[", \[Ellipsis] , ", "TableText"], 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]], Cell["}", "TableText"], 
      StyleBox[" ", "TR"]}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
     " at the beginning, then cyclically use the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
     ", then use the last sequence of ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
     " at the end "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{"{", "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
     " at the beginning and the last sequence at the end"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "specify what to use at positions ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["i", "k"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["spec", "TI"], ",", 
      StyleBox["rules", "TI"]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["rules", "TI"]], "InlineFormula"],
     " to override specifications in ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->277342543],

Cell[TextData[{
 "With settings of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["s", "1"], ",", 
     SubscriptBox["s", "2"], ",", "\[Ellipsis]", ",", 
     RowBox[{"{", "\[Ellipsis]", "}"}], ",", 
     SubscriptBox["s", "m"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["s", "n"]}], "}"}], TraditionalForm]], "InlineMath"],
 ", if there are more ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
 " specified than items across the grid, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
 " from the beginning are used for the first items, and ones from the end are \
used for the last items. "
}], "Notes",
 CellID->26373273],

Cell[TextData[{
 "Settings such as ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " can effectively be specified for individual items in the grid using ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4827],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ItemSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ItemSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " will break elements across multiple lines if necessary. "
}], "Notes",
 CellID->8202],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " will not change the size of graphics or other objects that have explicit \
",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " settings. "
}], "Notes",
 CellID->11176],

Cell[TextData[{
 "For a grid with ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " items in a particular direction, ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " can specify settings for the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "+", "1"}], TraditionalForm]], "InlineMath"],
 " gaps between elements, starting before the first element, and ending after \
the last element."
}], "Notes",
 CellID->49335815],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " can have the following forms:"
}], "Notes",
 CellID->103124118],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["spec", "TI"], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " to all gaps between items "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to successive horizontal and vertical gaps"
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->934654743],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can have the same forms as for ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " and other item-oriented options."
}], "Notes",
 CellID->405888177],

Cell[TextData[{
 "The following settings can be used for ",
 Cell[BoxData[
  ButtonBox["BaselinePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaselinePosition"]], "InlineFormula"],
 ":"
}], "Notes",
 CellID->3429],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axis",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axis"], Cell[
    "axis of the middle row in the grid (default) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Baseline",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Baseline"], Cell[
    "baseline of the middle row in the grid ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bottom",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Bottom"], Cell[
    "bottom of the whole grid ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell[
    "halfway from top to bottom ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "top of the whole grid ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], "}"}], ",", 
      StyleBox["pos", "TI"]}], "}"}], Cell[TextData[{
     "position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     " in element ",
     Cell[BoxData[
      FormBox[
       RowBox[{"i", ",", "j"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->46602970],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<Grid\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2592399],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->110018803],

Cell["Display elements in a grid:", "ExampleText",
 CellID->255138841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->209490826],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "b", "c"},
    {"x", "y", "z"}
   }],
  "Grid"]], "Output",
 ImageSize->{41, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154677502]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->344040015],

Cell["Put a frame around every element:", "ExampleText",
 CellID->20121397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"y", "^", "2"}], ",", 
       RowBox[{"z", "^", "3"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->236225215],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "b", "c"},
    {"x", 
     SuperscriptBox["y", "2"], 
     SuperscriptBox["z", "3"]}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{65, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5194239]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->554058385],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 " to format grid elements as text:"
}], "ExampleText",
 CellID->967757468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "[", 
  RowBox[{"Grid", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<first\>\"", ",", "\"\<second\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<third\>\"", ",", "\"\<fourth\>\""}], "}"}]}], "}"}], "]"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->625080644],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   TagBox[GridBox[{
      {"\<\"first\"\>", "\<\"second\"\>"},
      {"\<\"third\"\>", "\<\"fourth\"\>"}
     }],
    "Grid"]], "Text", "TR"],
  Text[
   Grid[{{"first", "second"}, {"third", "fourth"}}]]]], "Output",
 ImageSize->{68, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->370201120]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(20)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->371246094],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Elements in Grids",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->428441244],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " can contain elements of any size:"
}], "ExampleText",
 CellID->943132222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"j", "!"}], "/", 
     RowBox[{"(", 
      RowBox[{"i", "+", "11"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "12"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198433603],

Cell[BoxData[
 TagBox[GridBox[{
    {
     FractionBox["1", "12"], 
     FractionBox["1", "6"], 
     FractionBox["1", "2"], "2", "10", "60", "420", "3360", "30240", "302400",
      "3326400", "39916800"},
    {
     FractionBox["1", "13"], 
     FractionBox["2", "13"], 
     FractionBox["6", "13"], 
     FractionBox["24", "13"], 
     FractionBox["120", "13"], 
     FractionBox["720", "13"], 
     FractionBox["5040", "13"], 
     FractionBox["40320", "13"], 
     FractionBox["362880", "13"], 
     FractionBox["3628800", "13"], 
     FractionBox["39916800", "13"], 
     FractionBox["479001600", "13"]},
    {
     FractionBox["1", "14"], 
     FractionBox["1", "7"], 
     FractionBox["3", "7"], 
     FractionBox["12", "7"], 
     FractionBox["60", "7"], 
     FractionBox["360", "7"], "360", "2880", "25920", "259200", "2851200", 
     "34214400"}
   }],
  "Grid"]], "Output",
 ImageSize->{446, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43601449]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->335319585],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " can contain graphics or any other expressions:"
}], "ExampleText",
 CellID->34391300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "25"}]}], "]"}], ",", 
    RowBox[{"{", "2", "}"}], ",", 
    RowBox[{"{", "10", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320176929],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmj9s2kAUxu8ClKakqQVt5UodPDIy0g01UstSKSMjKKpEhqoozcDGyMjI
yMjIyMjIyMjIyMjISL/3zo49WQpUkZN+kbDu7ve9SHy+/7wfnfvuz1+d+9ub
TvD9rtPr3t78Cb79vkNTzhpjvxpjvvgG5QNK+pG/K3yMOZdnbr1ej0ajwWBg
zuSRGw6Hq9VK0CfyVP5aXSzKMw9JEATVarXX6+VEV+j3+7Vazfd91Ha7nflA
3ZPoXulbKagaLwpqSDebjXtP2+0WOsTP5/MyNSdr1GeT15Eym83q9TpkpqR1
6JrN5mQyMR55Klf/TE5bYSpa9/u9udR6u92GRIpvyVP5mbqozxxcxqwg88E7
rUN/fX2NWHNBnsqTLjYajcViIUUv6rGYC8T7Enkqt+qiDmkMe1hrKqrAPIol
TIrn0ZwAKMUy+cECW/CEexjr0isrUa+Fv3G0g/F//7+5BbbgkXvoh57nSW98
r2ogKKRYjMY8+QNX52RxhnMY1BjaInKR8RrjIsmT3AJb2cbAuel02mq14kjs
znFgiiPJk9wCW3Bxbjwed7vdiMhZU8+XL7Bdvm087zuf4nXB+USe5NG6KM4t
l0ucIuJIdCd0qjiSPMktsAUPdxO+72OPFkZi8scGWIqupzooxQr5wQJbOSA4
5zCGMZLDyNhjtw9xUIpl8oMFtuDhPkwO96vVCg3Yarh4DG0M8Dj+ARty+Ads
wZ1/7iQaz49eFIHzqxRL5Kk86SIcRut6vQ5P/Rju4Y3UBXkqd7ci7obO3Z3A
4fBGCnXshqV+SZ7K1T9325lHK7xFp4Xpb1SHZTqM86h4pMLdIOttfAEY00G1
WoVU+q5rRV/GGQ1y7IhkWS9Tmxmt+xWlGL1lRARBACwXjCaPl46tGQ7ZeNEf
qTlZoz4bHUEFVBfRH7Zt5vOLaNXvpj/1Xz2qxIyA0zgzArKoY0YAMwKeG2dG
wL/gzAhgRkBWODMCmBHAjIDnxJkRcCxnRsCxnBkB2fjFPeucGQHHcmYEHMuZ
EXAsZ0YAMwKyw5kRwIyArHBmBDAjgFpmBDAj4GkzAoz9C8Bfr4E=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{322, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91162096]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141895743],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " can contain active controls:"
}], "ExampleText",
 CellID->26815302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Checkbox", "[", "]"}], ",", 
    RowBox[{"{", "2", "}"}], ",", 
    RowBox[{"{", "8", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7447461],

Cell[BoxData[
 TagBox[GridBox[{
    {
     CheckboxBox[False], 
     CheckboxBox[False], 
     CheckboxBox[False], 
     CheckboxBox[False], 
     CheckboxBox[False], 
     CheckboxBox[False], 
     CheckboxBox[False], 
     CheckboxBox[False]},
    {
     CheckboxBox[False], 
     CheckboxBox[False], 
     CheckboxBox[False], 
     CheckboxBox[False], 
     CheckboxBox[False], 
     CheckboxBox[False], 
     CheckboxBox[False], 
     CheckboxBox[False]}
   }],
  "Grid"]], "Output",
 ImageSize->{164, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41773250]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->964429372],

Cell["Create a grid with a single row:", "ExampleText",
 CellID->980610876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "!"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18272998],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "6", ",", "24", ",", "120", ",", "720", ",", "5040", 
   ",", "40320", ",", "362880", ",", "3628800"}], "}"}]], "Output",
 ImageSize->{359, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->468702275]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", "u", "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1400391],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "6", "24", "120", "720", "5040", "40320", "362880", "3628800"}
   }],
  "Grid"]], "Output",
 ImageSize->{318, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->749542512]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Frames and Grid Lines",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->511949576],

Cell["Put a frame around the whole grid:", "ExampleText",
 CellID->61301763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62846654],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
  "Grid"]], "Output",
 ImageSize->{111, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191453533]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->545138637],

Cell["Put a frame around every element:", "ExampleText",
 CellID->861064787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->393168623],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{117, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->642299167]
}, Open  ]],

Cell["Draw all the frames in red:", "ExampleText",
 CellID->1058702674],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1713826523],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   FrameStyle->RGBColor[1, 0, 0],
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{117, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->58932655]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88007557],

Cell["Put a frame around the first row and column:", "ExampleText",
 CellID->205713954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", "True", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->123321595],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{"Columns" -> {True}, "Rows" -> {True}}],
  "Grid"]], "Output",
 ImageSize->{112, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->665646497]
}, Open  ]],

Cell["Draw different frames with different styles:", "ExampleText",
 CellID->1196540285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "Red", "}"}], ",", 
      RowBox[{"{", "Green", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1215699487],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{"Columns" -> {
       RGBColor[1, 0, 0]}, "Rows" -> {
       RGBColor[0, 1, 0]}}],
  "Grid"]], "Output",
 ImageSize->{112, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->142600956]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->144232786],

Cell["Put dividers at all horizontal positions:", "ExampleText",
 CellID->324771918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", "False"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->750408934],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxDividers->{"Columns" -> {{True}}, "Rows" -> {{False}}}],
  "Grid"]], "Output",
 ImageSize->{117, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->455591042]
}, Open  ]],

Cell["Put dividers at all vertical positions:", "ExampleText",
 CellID->430163479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "All"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8273050],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxsQQDkP0fyALj
xP//gTSUZAABFBEkkgkoxwRkgWhOKE0rPiPYRgZWCPUfDEBu4wbRLMhCtBNh
gvga6iJeEmlmKugeFP6ne6zjSn/4U+doGh1No6NpdDSNjqZRUtIoAyMABRyM
/A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80658439]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1182797647],

Cell["\<\
Put dividers at the third horizontal and second vertical positions:\
\>", "ExampleText",
 CellID->23932850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"False", ",", "False", ",", "True"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->659967961],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxDividers->{
    "Columns" -> {False, False, True}, "Rows" -> {False, True}}],
  "Grid"]], "Output",
 ImageSize->{102, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->525614991]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Spanning Elements",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->240043264],

Cell["Make the element 4 span the column to its right:", "ExampleText",
 CellID->578952123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "SpanFromLeft", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348140959],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "\[SpanFromLeft]", "6"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->333566648]
}, Open  ]],

Cell["Make it span three columns:", "ExampleText",
 CellID->581884849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "SpanFromLeft", ",", "SpanFromLeft"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74187149],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "\[SpanFromLeft]", "\[SpanFromLeft]"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->366092963]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->73873043],

Cell["Make the element 2 span the row below it:", "ExampleText",
 CellID->547117279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "SpanFromAbove", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75970249],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "\[SpanFromAbove]", "6"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->647156921]
}, Open  ]],

Cell["Make it span three rows:", "ExampleText",
 CellID->122949571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "SpanFromAbove", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "SpanFromAbove", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->603613667],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "\[SpanFromAbove]", "6"},
    {"7", "\[SpanFromAbove]", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->266782177]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47616072],

Cell["Span throughout a 2\[Times]2 block:", "ExampleText",
 CellID->210615047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "SpanFromLeft", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"SpanFromAbove", ",", "SpanFromBoth", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->839795991],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "\[SpanFromLeft]", "3"},
    {"\[SpanFromAbove]", "\[SpanFromBoth]", "6"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16519960]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->391029099],

Cell["Align contents to the left:", "ExampleText",
 CellID->1202194683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "bbbb"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ccc", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Left"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->799770335],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "bbbb"},
    {"ccc", "d"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{72, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14144210]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268320393],

Cell["Align contents to the right:", "ExampleText",
 CellID->105324452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "bbbb"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ccc", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Right"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->173862713],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "bbbb"},
    {"ccc", "d"}
   },
   GridBoxAlignment->{"Columns" -> {{Right}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{72, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->497208083]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->173615003],

Cell["Draw the grid with a pink background:", "ExampleText",
 CellID->701515873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->692055481],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gXTi/4YGGMkEFGYCskA0J5SmFZ8RbCMDK4QCkhAGAzeIZkEWop0IE8TX
UBfxkkgzU0H3oPA/3WM9kSxyNHWOps7R1DmaOkdT52jqHE2dQyF1gtqXDIwA
63cmMg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8451376]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->928090012],

Cell["\<\
A pink background for the column at the first horizontal position:\
\>", "ExampleText",
 CellID->501317172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "Pink", "}"}], ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83112486],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gTTP/4aGUDQWE1CaCcgD0WxAmhkoChGD0JxU5jOCbWVgBVoFclhDA4TB
wA6kWUByLCBhMAAyuGkmwgTxPdTnHECaFepCXiJpZiqZMGjCYkBSArY0SR3W
aMoeTdmjKXs0ZY+m7NGUPZqyR1M2uSkb0nZmYAQAeO7oXA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->572740993]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->306149779],

Cell["\<\
Alternating pink and yellow at successive horizontal positions:\
\>", "ExampleText",
 CellID->851891726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Pink", ",", "Yellow"}], "}"}], "}"}], ",", "None"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->207244729],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl0sKwjAQhievWkTo1mWv4QV05SFCEdqFKLUH6M3jnwcibgQlMIRA02+Y
fwh5TH/o2S7j5WqXabD9abb3cRoe/fE2I6UEEVmMw54QO0RhWOfAnVvXDkH3
wS34TZWYRiLybEAFJeYiG1AlPVedCCshE4F3DGgDar9B7dPOPyHrSPsK/V6c
q1bGU0orbUGTdtKC5se8yjgr63Nk023/fDPlqXzuhXX3VheoLlCwyudeWHdv
dYHqAgWrfO6FdfdWF6gu8FLjfziJJx5gt9E=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135241940]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->212518288],

Cell["\<\
Alternating pink and yellow at successive vertical positions:\
\>", "ExampleText",
 CellID->222607990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Pink", ",", "Yellow"}], "}"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34782048],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gXQiiICSTCAMZIFoTihNKz4j2EYGVggFJCEMBm4QzYIsRDsRJoivoS7i
JZFmpoLuQeF/usd6Ik6yoQE3CTGnoQFiLoSmFZ8RbCMwdsAUkIQwgGEIpFmQ
hWgnwgTxNdRFvCTSzFTQPSj8T/dYx50K8aXd0bJztOwcLTtHy87RshOpvAQl
TEYAdx8lcw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40994613]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2023262693],

Cell["Make the grid contents red:", "ExampleText",
 CellID->1759886205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1316391855],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gTQyyQTG//+DaE4oTSs+I9hGBtb/YPo/BAAFuEEUC7IQ7USY4CTIRbwk
0sxU0D04/E/vWMdMecSQo6lzNHWOps7R1DmaOkdT52jqHCqpk4ERAEZnuTo=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->396604398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1720014653],

Cell["Embed styling options with a particular grid item:", "ExampleText",
 CellID->1115177304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Item", "[", 
       RowBox[{"1", ",", 
        RowBox[{"Background", "\[Rule]", "Red"}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", "2"}], "}"}], ",",
     
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->639873772],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ItemBox["1",
      Background->RGBColor[1, 0, 0],
      Frame->True,
      StripOnInput->False], "2"},
    {"3", "4"}
   }],
  "Grid"]], "Output",
 ImageSize->{32, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97243990]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Spacing",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->267316272],

Cell["\<\
Make each row and column just big enough to fit the items they contain:\
\>", "ExampleText",
 CellID->354141537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"Power", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Right"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->158819658],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "1", "1", "1", "1"},
    {"2", "4", "8", "16", "32"},
    {"3", "9", "27", "81", "243"},
    {"4", "16", "64", "256", "1024"},
    {"5", "25", "125", "625", "3125"}
   },
   GridBoxAlignment->{"Columns" -> {{Right}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{141, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174977972]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->851546081],

Cell["Leave the same amount of space for all items:", "ExampleText",
 CellID->14693373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"Power", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Right"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4578563],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "1", "1", "1", "1"},
    {"2", "4", "8", "16", "32"},
    {"3", "9", "27", "81", "243"},
    {"4", "16", "64", "256", "1024"},
    {"5", "25", "125", "625", "3125"}
   },
   ColumnsEqual->True,
   GridBoxAlignment->{"Columns" -> {{Right}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{},
   RowsEqual->True],
  "Grid"]], "Output",
 ImageSize->{190, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->469812]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1235103523],

Cell["Set the horizontal spacing between items:", "ExampleText",
 CellID->2609790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57263510],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x"},
    {"x", "x", "x"},
    {"x", "x", "x"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxSpacings->{"Columns" -> {{2}}}],
  "Grid"]], "Output",
 ImageSize->{99, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227571943]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78340660],

Cell["Set the horizontal and vertical spacings:", "ExampleText",
 CellID->1695160959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->427974663],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x"},
    {"x", "x", "x"},
    {"x", "x", "x"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{0}}}],
  "Grid"]], "Output",
 ImageSize->{99, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46716673]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Nested Grids",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->359856620],

Cell["Grids can be nested:", "ExampleText",
 CellID->32743373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"Grid", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}], ",", 
       "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d", ",", "e"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102307895],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", 
     TagBox[GridBox[{
        {"1", "2", "3"},
        {"4", "5", "6"},
        {"7", "8", "9"}
       }],
      "Grid"], "b"},
    {"c", "d", "e"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{83, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147064326]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->188564242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"Column", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], ",", "b"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d", ",", "e"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->125387553],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", 
     TagBox[GridBox[{
        {"1"},
        {"2"},
        {"3"}
       },
       GridBoxAlignment->{"Columns" -> {{Left}}}],
      "Column"], "b"},
    {"c", "d", "e"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33775811]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(26)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->59466161],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->565833074],

Cell["Align elements around the center of the grid:", "ExampleText",
 CellID->78137354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Rectangle", "[", "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Rectangle", "[", "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Rectangle", "[", "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "40"}]}], "]"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Rectangle", "[", "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}]}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Right", ",", "Left"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Bottom", ",", "Top"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42645857],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAFxuAQDkP0fyALj
pP//gTQyaQgk9YFSTAPCY2CGUCCgAsRco7KjsqOyo7I0lMUsA3GRokBSCKpf
hgHCHxUdGFHDQcRDTiMMjAAyRrru\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{98, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->373275523]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1308533125],

Cell["Align numbers on the decimal point:", "ExampleText",
 CellID->1142000361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.234", ",", "12.34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"123.4", ",", "1234."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1234", ",", "1.234"}], "}"}]}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "\"\<.\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1803708221],

Cell[BoxData[
 TagBox[GridBox[{
    {"1.234`", "12.34`"},
    {"123.4`", "1234.`"},
    {"1234", "1.234`"}
   },
   GridBoxAlignment->{"Columns" -> {{"."}}, "Rows" -> {{"."}}}],
  "Grid"]], "Output",
 ImageSize->{124, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->655031610]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->221411408],

Cell["Draw the grid with a pink background:", "ExampleText",
 CellID->13842222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->717991278],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gXTi/4YGGMkEFGYCskA0J5SmFZ8RbCMDK4QCkhAGAzeIZkEWop0IE8TX
UBfxkkgzU0H3oPA/3WM9kSxyNHWOps7R1DmaOkdT52jqHE2dQyF1gtqXDIwA
63cmMg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->297901019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1166625332],

Cell["\<\
Pink and gray backgrounds for the first and second horizontal positions:\
\>", "ExampleText",
 CellID->946257814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pink", ",", "Gray"}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1855750711],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl00KwkAMhTN/taLi1mWv4QXqykMMRWgXotQeIDcf3/wsRRdWFMnA8L2E
tJmGeYse/dSfzn4aOt8cRn/th+7WtJcRKaOIyGPvdwQdoNL2IYDrwLxl5vZB
pFGmkYmsQMNZ68IKNKjMdZnLN2OVOpNDu3hI5ixoAVr0I4uA04pZwMYnYjak
BbGaKaPzFMoEatCVL69BV068eUEz41t+ai5fux3P7uznI3GFuEJcIa4QV4gr
xBXiin9zRf4vIHUHUjjzbA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306473265]
}, Open  ]],

Cell["An equivalent syntax:", "ExampleText",
 CellID->1638673863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "Pink"}], ",", 
        RowBox[{"2", "\[Rule]", "Gray"}]}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1538714088],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl00KwkAMhTN/taLi1mWv4QXqykMMRWgXotQeIDcf3/wsRRdWFMnA8L2E
tJmGeYse/dSfzn4aOt8cRn/th+7WtJcRKaOIyGPvdwQdoNL2IYDrwLxl5vZB
pFGmkYmsQMNZ68IKNKjMdZnLN2OVOpNDu3hI5ixoAVr0I4uA04pZwMYnYjak
BbGaKaPzFMoEatCVL69BV068eUEz41t+ai5fux3P7uznI3GFuEJcIa4QV4gr
xBXiin9zRf4vIHUHUjjzbA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->620453852]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1861326313],

Cell["\<\
Pink and gray backgrounds for the first and second vertical positions:\
\>", "ExampleText",
 CellID->482528275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"Pink", ",", "Gray"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554886156],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxBackground->{"Columns" -> {{None}}, "Rows" -> {
       RGBColor[1, 0.5, 0.5], 
       GrayLevel[0.5]}}],
  "Grid"]], "Output",
 ImageSize->{101, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6132843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21555281],

Cell["Alternating pink and gray backgrounds:", "ExampleText",
 CellID->954466853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Pink", ",", "Gray"}], "}"}], "}"}], ",", "None"}], "}"}]}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1930194792],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 0.5, 0.5], 
        GrayLevel[0.5]}}, "Rows" -> {{None}}}],
  "Grid"]], "Output",
 ImageSize->{101, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26809827]
}, Open  ]],

Cell["\<\
Alternating backgrounds with yellow superimposed in the first and last \
positions:\
\>", "ExampleText",
 CellID->1502355071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"Pink", ",", "Gray"}], "}"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "Yellow"}], ",", 
          RowBox[{
           RowBox[{"-", "1"}], "\[Rule]", "Yellow"}]}], "}"}]}], "}"}], ",", 
      "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->448480217],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl0sKwjAQhidNWosI3brsNbyArjxEKEK7EKX2ALn5+OeB1JVCFYaSwuSb
zh/ynA70bKf+crXT0Nn2NNp7P3SP9ngbEdKKiCzssCf4DC+YZQZ3aBrnXMOw
Gbde/KAW3uB5VqCGEmKJFag5xRIrcFk/fptXhZVQGYE2OrQBDfqTwYsLj48C
hlMU5BgFftEXM5v5Iop4SmmlNVimndRgmXZag9/F4zj6j6OKPkcx2bbkm1mf
KudeRGdvrgK5CqxYlXMvorM3V4FcBVasyrkX0dmbq0CuAi81/oeTegIs7R71
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->680952554]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->697401140],

Cell["Blending of colors:", "ExampleText",
 CellID->636484464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Yellow", ",", "None"}], "}"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Purple", ",", "None"}], "}"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->527153300],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 0], None}}, "Rows" -> {{
        RGBColor[0.5, 0, 0.5], None}}}],
  "Grid"]], "Output",
 ImageSize->{101, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196042075]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96657118],

Cell["Set the background for specific items:", "ExampleText",
 CellID->1018545094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "Pink"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "Red"}]}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1415183459],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxBackground->{
    "Columns" -> {{None}}, "Rows" -> {{None}}, 
     "ItemsIndexed" -> {{1, 1} -> RGBColor[1, 0.5, 0.5], {3, 3} -> 
       RGBColor[1, 0, 0]}}],
  "Grid"]], "Output",
 ImageSize->{101, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89347199]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174397539],

Cell["Set the background for a subregion of the grid:", "ExampleText",
 CellID->1095244621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "\[Rule]", "Pink"}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->452610656],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gTQyyQQUZgKyQDQnlKYVnxFsIwMrhPoPBkAGAzeIZkEWop0IE8TXUBfx
kkgzU0H3oPA/3WMdM+VBSK3/DQ3mJLEgZjc0QOyC0Lj4bECamVqptqEBFJAN
DRAGMGyBNAuyEKYIO5BioXLKhfiMF43mANKsRKZeSk0YNGExICmB9BQ7mrJH
U/Zoyh5N2aMpezClbEj7g4ERAAKhkuQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39162271]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->692489402],

Cell["\<\
Align the center of the grid with the baseline of surrounding text:\
\>", "ExampleText",
 CellID->30132536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", "z"}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30922498],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   TagBox[GridBox[{
      {"a", "b"},
      {"c", "d"}
     },
     GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
    "Grid"], ",", "z"}], "}"}]], "Output",
 ImageSize->{111, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->158680494]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->749255240],

Cell["Align the bottom of the grid with the baseline:", "ExampleText",
 CellID->1694006710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Bottom"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", "z"}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->881279972],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   TagBox[GridBox[{
      {"a", "b"},
      {"c", "d"}
     },
     BaselinePosition->Bottom,
     GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
    "Grid"], ",", "z"}], "}"}]], "Output",
 ImageSize->{111, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->736387581]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1574281725],

Cell["Align a specific grid element with the baseline:", "ExampleText",
 CellID->1980066691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"b", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", "e"}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", "Bottom"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", "z"}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157255358],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   TagBox[GridBox[{
      {"b", "c"},
      {"d", "e"}
     },
     BaselinePosition->{{1, 2}, Bottom},
     GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
    "Grid"], ",", "z"}], "}"}]], "Output",
 ImageSize->{111, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196752513]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"b", "^", "2"}], ",", "g"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", 
         RowBox[{"e", "^", "2"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", "Bottom"}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", "z"}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->760715332],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   TagBox[GridBox[{
      {
       SuperscriptBox["b", "2"], "g"},
      {"d", 
       SuperscriptBox["e", "2"]}
     },
     BaselinePosition->{{1, 2}, Bottom},
     GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
    "Grid"], ",", "z"}], "}"}]], "Output",
 ImageSize->{123, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19261901]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Dividers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->151600544],

Cell["Draw all interior dividers:", "ExampleText",
 CellID->1954421035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", "Center"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1940480886],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxDividers->{
    "Columns" -> {False, {True}, False}, "Rows" -> {False, {True}, False}}],
  "Grid"]], "Output",
 ImageSize->{107, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8413455]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1113467454],

Cell["Draw a divider at every other horizontal position:", "ExampleText",
 CellID->1237013789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "11", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"True", ",", "False"}], "}"}], "}"}], ",", "False"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1897885587],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmkEOgjAQRUtLFGPcu9CEa3gBXXmIhpjAwmiQO3HM2lI0ChsTF5b6SNrO
dAY++Wlm/qJH3ZSns26qQueHWl/Lqrjl+0ttt1QihGjt2K2FtY21utEa41bl
7O4RWze9+Jsv/ewHCNJO0rqPdTHwZy4pfeZHkp2MeFDv+dZYjnbmAzZl9O/I
EU9pz+CqX7PBN1QgcRXRn3M2Pzub1DLPQwx9CQQQpoNA5fE80KlQUWHEUVGo
KFQUCCBMB4HK43mgU6GiwoijolBRqCgQQJgOApXH80CnQkWFEUdFoaL+U0X1
d2aSO9yX8pU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{167, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403778029]
}, Open  ]],

Cell["Include the final position:", "ExampleText",
 CellID->1519682582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "11", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"True", ",", "False"}], "}"}], "}"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "\[Rule]", "True"}]}], "}"}], ",", "False"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->564304379],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWkEOgjAQLC2CRr17kIRv+AE9+YiGmMDBaJBn8ce6JdVq5WDiQbsOSdvd
0jKbyWZ3Dux1Vx+OumsqXe5afa6b6lJuTy1tqUQI0dPYrATZhqxh9MbYVVl7
eERhpwd//aG/oMmCfwNF0iTJva2zwM/sofR+nsnpySgX6vkOGfOXnTxgVbK/
k41ylToml26dBt9RP/I+Zxg98vT9PEV981xw6ltAAQoPFFQozwU6GxRYDNEj
T6HAoMCAAhQOKKhQngt0NiiwGKJHnkKBQYEBBSgcUFChPBfobFBgMUSPPIUC
+0cF5v4HSq5ykfO3\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{172, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->76584041]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2092862981],

Cell["Draw dividers with specified styles:", "ExampleText",
 CellID->1282141903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", "\[Rule]", "Red"}], ",", 
        RowBox[{
         RowBox[{"-", "2"}], "\[Rule]", "Blue"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", "\[Rule]", "Red"}], ",", 
        RowBox[{
         RowBox[{"-", "2"}], "\[Rule]", "Blue"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1832153568],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM0OwiAM7kDdjHr3uPfwrvHgzYNXQky2g9HMvT+WAv7gQY2LdgkkrD+U
Utr1y7KNaqv9QbW1VuWqUaeq1udyeWxQJTMA0DgXc0DeIEdTG4N0ap8SGUMD
1iQH0UDxgZVAtwI5S0dWM7ju8NqwOv5Sdt7vnD+sZhQNDB3xIeLIo1sI7+Vm
MulIk0f5eT5JuIz5iIsoMun1sxe0iM4J++QPvPciv6zeyC57rVMriwiSSmhN
YUuUbbRvWfGqfC96xSQsSlgUbsG7u7la8apxL7rCJNRJqBNu8a++3dmEkZY+
fVBrq8k12oRFCYsSFnHCIvcvBbILvaD1ZQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{99, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->666577806]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Frame",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->484677263],

Cell["Frame the entire grid:", "ExampleText",
 CellID->1647424742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406535651],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}}],
  "Grid"]], "Output",
 ImageSize->{111, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->190553824]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->322065365],

Cell["Frame all elements in the grid:", "ExampleText",
 CellID->760978023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->717006499],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{117, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->737279966]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1031681727],

Cell["Frame specific elements:", "ExampleText",
 CellID->1356547037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "True"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "True"}]}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1108049723],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{
    "Columns" -> None, "Rows" -> None, 
     "ItemsIndexed" -> {{1, 1} -> True, {3, 3} -> True}}],
  "Grid"]], "Output",
 ImageSize->{109, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->856677941]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60550712],

Cell["Frame a region:", "ExampleText",
 CellID->1799654307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "\[Rule]", "True"}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1630253401],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{
    "Columns" -> None, "Rows" -> None, 
     "ItemsIndexed" -> {{{1, 3}, {1, 3}} -> True}}],
  "Grid"]], "Output",
 ImageSize->{107, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->548146625]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1487836305],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " supports a variety of graphics directives:"
}], "ExampleText",
 CellID->1784441749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "\[Rule]", "True"}], ",", "False"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "True", "}"}], ",", "False"}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Dashing", "[", "2", "]"}], ",", 
      RowBox[{"Thickness", "[", "2", "]"}], ",", "Blue"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2010859911],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwZAKxpQQDkP0fyALj
zP//gTQyyQQUZQGygDQDE5Rmg9D/mdHEOanMZ4S7gBXEYgG5EAyADHaoG1gw
ZLhpJsIEpjigruOH0rxE0sxU0D3YwmLgUwd6WhWA2h6KQ4Q89WxodnPTxW+D
MbZhIQFNx2D30TsXsGO4j3dAwmLgy0VqpG3i1Q9MLhgssU2dlE89kwZDuAxc
uUibch6f+oHN7YMhtilvu1AvDw2menFgcgGutAoRZ2AEAHesQoM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{105, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31820466]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->596672098],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " is applied to all sources of grid lines, including ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1503345088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Item", "[", 
        RowBox[{"x", ",", 
         RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", "x", ",", "x", 
       ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"False", ",", 
      RowBox[{"2", "\[Rule]", "True"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "True"}], ",", "False"}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Dashing", "[", "2", "]"}], ",", 
      RowBox[{"Thickness", "[", "2", "]"}], ",", "Blue"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306806790],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwpAKxqwQDkP0fyALj
1P//QTQzkAkBDExAJhOQgUxHkKAqFQcJVMEAVcnADaVx8Tkp5DNC3MsKoaBO
BgJeEM2CLIQpwk0lESaIr6Eu4kejeQnQzFTQPSj8T/dYx5X+8JOjqXM0dQ5k
6uQBkQTKVxgNDUCwOle4bmQZEMKmGxgE/92w2g1SAY0/qArsooMnt7BD3cWC
Ebe4ZWiTezig9rHi4I/E3MQGDQNmtNjEJU6dVIIvzeJL68TmvKFCD0cfjdbf
uEug0fp7oOtv6vegGBgBcmM/eA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{101, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->458283516]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147237284],

Cell[TextData[{
 "Directives given with ",
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " are combined with those specified elsewhere:"
}], "ExampleText",
 CellID->1575787061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Item", "[", 
        RowBox[{"x", ",", 
         RowBox[{"Frame", "\[Rule]", "Green"}]}], "]"}], ",", "x", ",", "x", 
       ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "\[Rule]", "Red"}], ",", 
      RowBox[{"2", "\[Rule]", "Red"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "True"}], ",", "False"}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Dashing", "[", "2", "]"}], ",", 
      RowBox[{"Thickness", "[", "2", "]"}], ",", "Blue"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1991996265],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlV1ELgkAMnnqlEVH01GPRb9GeeoyeJYJCoqj+/7XzptRdpubVSQW23W6b
2/jG5jK+7raH+LrfxNPFOT7t9pvLNDqeUeQ5AJDgE04AeY5c+iScC+ohK3/g
IusiU0TvdVcGrMXNSGggvy6QJHf/4pZJj0CeoUvaniLvK+dew7OTR9ARHIMs
GWR8ioFpNwNN0jckSSsKAUU3VOighHoGrNtWC/voULFaF9vV9LslufwH8kU8
WSUCiqLzFo6bdYFfIfPfR/672MaZwLNsXGSlV53KYqeqEKYexhWtGdIotxBS
pbseJDOSSIv5w0m3f1pz1LA5i3Ss+RSV3qOfnUUBvTfrynrdqFobm01PK2Gj
Q1VUFKHHDFrKsFzWC3KD43lmLslUisUV6ZPay55mskSkWeDv2/SvMjWyo9id
PG2Yv833aDObTNt2NDubat192uYXMEXg3ACtDjQ3\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{107, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->480350421]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ItemSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->460739316],

Cell["Make each item a fixed number of character-widths wide:", "ExampleText",
 CellID->85240919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"30", "!"}], ",", 
      RowBox[{"35", "!"}]}], "}"}], "}"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", "10"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1345672932],

Cell[BoxData[
 TagBox[GridBox[{
    {"265252859812191058636308480000000", 
     "10333147966386144929666651337523200000000"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}},
   GridBoxItemSize->{"Columns" -> {{10}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{274, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->608768335]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->284313921],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ItemSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ItemSize"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " makes all items the same size:"
}], "ExampleText",
 CellID->312955672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "!"}], ",", 
      RowBox[{"20", "!"}]}], "}"}], "}"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", "All"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1937970707],

Cell[BoxData[
 TagBox[GridBox[{
    {"3628800", "2432902008176640000"}
   },
   ColumnsEqual->True,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{},
   RowsEqual->True],
  "Grid"]], "Output",
 ImageSize->{315, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77452591]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96817517],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ItemSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ItemSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " line-wraps textual items at the page width:"
}], "ExampleText",
 CellID->1566887440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"100", "!"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", "!"}], "}"}]}], "}"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->571442514],

Cell[BoxData[
 TagBox[GridBox[{
    {"933262154439441526816992388562667004907159682643816214685929638952175999\
932299156089414639761565182862536979208272237582511852109168640000000000000000\
00000000"},
    {"30414093201713378043612608166064768844377641568960512000000000000"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{579, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->416904943]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6591469],

Cell["Prevent line-wrapping:", "ExampleText",
 CellID->1016039772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"100", "!"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"50", "!"}], "}"}]}], "}"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", "Full"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1124518717],

Cell[BoxData[
 TagBox[GridBox[{
    {"933262154439441526816992388562667004907159682643816214685929638952175999\
932299156089414639761565182862536979208272237582511852109168640000000000000000\
00000000"},
    {"30414093201713378043612608166064768844377641568960512000000000000"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{All}}, "Rows" -> {{All}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{1231, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97199350]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ItemStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->714928751],

Cell["Set one overall style for grid items:", "ExampleText",
 CellID->253498692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", "Blue"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->646483028],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gTQyyQQUZQKyQDQnlKYVnxFsIwMrmPoPASCHcYNoFmQh2okwQXwNdREv
iTQzFXQPCv/TPdYxUx4x5GjqHE2do6lzNHWOps7R1DmaOodK6mRgBAAYebk6
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86435093]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->658603261],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 " to wrap multiple style directives:"
}], "ExampleText",
 CellID->1492514676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"FontSize", "\[Rule]", "16"}], ",", "Red"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1590541561],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwlAGxpQQDkP0fyALj
sv//gTQyycDyH0xDEBOQzQykuaA0rfiMYDtBPAYQ9z8YYPC5hqA8I9R3EB8y
g0gWuAogg4+OImDbwRHMBKQFSKRZBo0Phn86GchciFkm4CdHS4zREmO0xBjo
dDJaYoyWGKMlxmiJMVpijJYYoyXGaIkxnEsMBkYAJ4W6OA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{118, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28340463]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1373950644],

Cell["Use a style from the current stylesheet:", "ExampleText",
 CellID->8827871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", "\"\<Section\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->498451071],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw1AKxrQQDkP0fyALj
2v//gTQyycAMpJZY8gMRAyuQyQRkcEFpWvEZwTYzQXnMUJqHxnymAbQVxkMO
bb4BEmMGu4gFSDIDuQIk0iyD1D8jKTUNXJ7FLD9wkaPlymi5MlquDK3UNFqu
jJYro+XKaLkyWq6Mliuj5cpouTLYU9NAlysMjAAjEWLX\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{125, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->251152654]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24144160],

Cell["Style specific elements:", "ExampleText",
 CellID->2085162572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "Red"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "Underlined"}]}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->666653385],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxtQQDkP0fyALj
xP//gTQmyQSUZAKyQDQnlKYVnxFsIwMrhPoPBkAGAzeIZkEWop0IE8TXUBfx
kkgzU0H3oPA/3WMdV/pDJuWAJDtQh81oWh1Nq4M8rY6mztHUOaRSJyy0/9M1
df6HBRht4wJv6vxPUeokW/fg8D+9Yx0z5TEwAgDFGLX0\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->471950401]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53263470],

Cell["Style a region:", "ExampleText",
 CellID->541712211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "\[Rule]", "Green"}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2099088016],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwJAKxpQQDkP0fyALj
xP//gTQyyQQUZgKyQDQnlKYVnxFsIwMrhPoPBkAGAzeIZkEWop0IE8TXUBfx
kkgzU0H3oPA/3WMdM+URQzIBky3EnP9QcwnxqZM6/8MC7D88DJGEcIpQNXX+
h6YbdJq41Emu7kHhf7rH+mjqHE2do6lzNHWOpk5qpE4GRgCY9vvp\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241425763]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Spacings",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->827811325],

Cell["Insert no additional space between columns:", "ExampleText",
 CellID->1284553133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Spacings", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1403149669],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwGAKxpQQDkP0fyAJj
w///gTQyyQQUZgKyQDQDM1gIDOgpxggRYoVQ/8EArpQFWYh2IkyQ0IC6iJVE
mpkKugeF/wdNasBMqcSQg8f9gyI2R1PzIEkNo6l5NDWPpubB4v5BEZujqXmQ
pAbMlMrACABlY5dj\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{49, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->343649016]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->142253632],

Cell["Insert no additional space between rows or columns:", "ExampleText",
 CellID->831403040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1079027757],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwGAKxtgQDkP0fyAJj
w///gTQmyQSUZAKyQDQDM1gIDOgpxggRYoVQ/8EArpQFWYh2IkyQ0IC6iJVE
mpkKugeF/wdNahhNr0TF12h6HSSpYTS9EhVfo+l1kKSG0fRKVHyNptdBkhow
UyoDIwBiCmrR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{49, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15762172]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->360347385],

Cell["Use different spacings at the first vertical divider:", "ExampleText",
 CellID->522826630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "4"}], "}"}], ",", "0"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109283512],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxSpacings->{"Columns" -> {1, 4}, "Rows" -> {{0}}}],
  "Grid"]], "Output",
 ImageSize->{158, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8983135]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", "0"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->460970803],

Cell[BoxData[
 TagBox[GridBox[{
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"},
    {"x", "x", "x", "x", "x", "x", "x"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxSpacings->{"Columns" -> {1, 2}, "Rows" -> {{0}}}],
  "Grid"]], "Output",
 ImageSize->{134, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->527005051]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->107368884],

Cell["A simple user interface layout:", "ExampleText",
 CellID->284132205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Text", "[", "\"\<greeks\>\"", "]"}], ",", "SpanFromLeft"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PasteButton", "[", "\[Alpha]", "]"}], ",", 
       RowBox[{"PasteButton", "[", "\[Beta]", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PasteButton", "[", "\[Gamma]", "]"}], ",", 
       RowBox[{"PasteButton", "[", "\[Delta]", "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->379251825],

Cell[BoxData[
 TagBox[GridBox[{
    {
     InterpretationBox[Cell[BoxData["\<\"greeks\"\>"], "Text", "TR"],
      Text["greeks"]], "\[SpanFromLeft]"},
    {
     ButtonBox["\[Alpha]",
      BaseStyle->"Paste"], 
     ButtonBox["\[Beta]",
      BaseStyle->"Paste"]},
    {
     ButtonBox["\[Gamma]",
      BaseStyle->"Paste"], 
     ButtonBox["\[Delta]",
      BaseStyle->"Paste"]}
   },
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}},
   GridBoxSpacings->{"Columns" -> {{0}}, "Rows" -> {{0}}}],
  "Grid"]], "Output",
 ImageSize->{36, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->644894823]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->885696333],

Cell["Presenting tabular data:", "ExampleText",
 CellID->1536283714],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<first\>\"", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<second\>\"", ",", "11", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<third\>\"", ",", "111", ",", "8", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<fourth\>\"", ",", "1111", ",", "10", ",", "11"}], "}"}]}], 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->409364949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "@", 
  RowBox[{"Grid", "[", 
   RowBox[{
    RowBox[{"Prepend", "[", 
     RowBox[{"data", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<name\>\"", ",", "\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\""}],
        "}"}]}], "]"}], ",", 
    RowBox[{"Background", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"None", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Lighter", "[", 
          RowBox[{"Yellow", ",", ".9"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"White", ",", 
           RowBox[{"Lighter", "[", 
            RowBox[{
             RowBox[{"Blend", "[", 
              RowBox[{"{", 
               RowBox[{"Blue", ",", "Green"}], "}"}], "]"}], ",", ".8"}], 
            "]"}]}], "}"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Dividers", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"Lighter", "[", 
           RowBox[{"Gray", ",", ".5"}], "]"}], "}"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}], ",", 
         RowBox[{"{", "False", "}"}], ",", 
         RowBox[{"Darker", "[", 
          RowBox[{"Gray", ",", ".6"}], "]"}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Alignment", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Right", ",", 
        RowBox[{"{", "Left", "}"}]}], "}"}], "}"}]}], ",", 
    RowBox[{"ItemSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"10", ",", "3", ",", "5", ",", "5"}], "}"}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", 
     RowBox[{"Darker", "[", 
      RowBox[{"Gray", ",", ".6"}], "]"}]}], ",", 
    RowBox[{"ItemStyle", "\[Rule]", "14"}], ",", 
    RowBox[{"Spacings", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", ".8"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1897771943],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW8tu00AUnXrspFURiBYJyoYiFqBuQ6UmaYXaBazYARKIqoTyaBcIVCok
VpX4sf5AviO/EWbGc+Pxmes4ruM2TW0lY9+H75wzr9h3lNe906OvP3qnx4e9
9VcnvV9Hx4e/11/+PFEquSDEQlsI8feBUNdDdWW++uiob3xpr1qtVkd9lV2q
U38wUB9xpgt5fn5u5Q2Q90DeVcVCHeXGRpGqkFplz6E6B8Iq1Mn4WNHoo1gf
H2T9AHUtO9G4cxP8Jdg3c+zPWS7aKqIYllURkXCkVReBjZLi6Nw7KmOtTO59
D7hugT0sKDcgHtoDltHznLtQbpVqLV8z5s66req2qtuqmraSyboU+F79eH0O
5ri1NOPQWb8DhzNy17WSL7WSMMfHOWoR9LrH1nUwb4xTc2MVa2cYL9sREmWc
F8Gfnnb4+YlMJETbZJFHdtTeB7z7l9w79CyFz1gX649ZepadiSjmXW0oznSh
vay8AfIeyLuqqKPUUcpFkaqI39K0RIe+XtKrGVllbNXlIcRdUYW0vu65CX7S
6rdBH9g6djLxmfU0AUBwQmHzHFoVGOdEg7K+ROSr4BPmyA0GOWEbARFd8MIo
nVyeSawJeXr3fbkSphFEac8tU41Wg72OfSkdu8iYjz6KMUxD1zcgXsmctReS
2sBlXAE/tGPfFeGnfSUxCl1G0MfWROzz1syZ60PPdwUQfJ4yg8nmWWEeMLbu
2r7AMbZi9RGcFytH2cxpp6WK2z3rV5j0XRb1GXhf/+eeklFm6f2hjnLDouDe
Bsqj3QrzQk4H5bzcPYy3UN9af/yuC0XeAT0h6Gbi9fdTRFOksyQW7CR53+wd
GmT0sD8+R4G5jwjsHaYF/PxOh+Xd8FBidD5bxNfBa9+V5NsAe7sEX9oJxPw7
yvPFmmMbwTyL5o9x2fkMexMBGzOYAvNJZjS3D7LFcsc1l1uL07sH3P542VUq
ax329y74FfkZxH8zBTyunft9cO08qqcZPb7Wz8+9u9G3wY7o+VE97Tahvacu
Mx6DzLk1S88ZMxFllp766yg3LAq9FVMux6znVqR8lp7L3yHa+pDPgetMgf6R
5TIIoch6+zbv9F5+gc0eZuYX9R3foNbHEIHNMqUiIu4GRNgqgT/yajsqiDcv
8zdNtNTzmHUq2saYM+9UiJnjMCPYIW8XK+nIz5wXRY7I2mCnfS9+PlL2Pw6T
TgFTBlh6LHCNKItxst0WbN07FbdcgT5P9ejtHFzrw8vK0Op21dD+FGyZOrNa
Nso/XWpLyxxiA+Q9Tqa6B+qj6x7Y2EbeAHkPZFV3+lmzjnKjoqh1Ic6URlqi
Q18vslq7F2ju+QQ1qBXK5H0i0Evrv52h77LItNVkVGI5BmLhGFs4spEmAm+D
1NceAI5HrFcDvPhY3Ym8OtUylIlfr2puTl3b2axYnGFmj/hsD5mxFV4J8qhA
T0TM6HoCdYcVMqCZ6XqP2teR7TPagM4MP6eu/QuPqUD4I7Q9Ef8xMyZMeIjR
GuJbqP5wmL1a2TdUH08qUrF1K29dxvbYAXuB1T4cyZbri4vHqgbhtf5tvOoo
yb8V9WMi/pdRLPwHBEA1KQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{313, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->888565341]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->497586619],

Cell["\<\
Styles given in a list will be interpreted as corresponding to successive \
columns or rows:\
\>", "ExampleText",
 CellID->58931023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6", ",", "7", ",", "8"}], "}"}]}], "}"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", "18", ",", "Italic"}], "}"}], ",", "None"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325575155],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3", "4"},
    {"5", "6", "7", "8"}
   },
   GridBoxItemStyle->{"Columns" -> {
       RGBColor[1, 0, 0], 18, Italic}, "Rows" -> {{None}}}],
  "Grid"]], "Output",
 ImageSize->{60, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238842678]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 " groups styles into a single collective unit:"
}], "ExampleText",
 CellID->463742294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6", ",", "7", ",", "8"}], "}"}]}], "}"}], ",", 
   RowBox[{"ItemStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{"Red", ",", "18", ",", "Italic"}], "]"}], ",", "None"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->898580295],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3", "4"},
    {"5", "6", "7", "8"}
   },
   GridBoxItemStyle->{"Columns" -> {{
        Directive[
         RGBColor[1, 0, 0], 18, Italic]}}, "Rows" -> {{None}}}],
  "Grid"]], "Output",
 ImageSize->{72, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->396582264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->453750008],

Cell[TextData[{
 "To span across both rows and columns requires appropriate use of ",
 Cell[BoxData[
  ButtonBox["SpanFromBoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromBoth"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1862285898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "SpanFromLeft", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"SpanFromAbove", ",", "SpanFromAbove", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2012416308],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "\[SpanFromLeft]", "2"},
    {"\[SpanFromAbove]", "\[SpanFromAbove]", "3"},
    {"4", "5", "6"}
   }],
  "Grid"]], "Output",
 ImageSize->{41, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->529147552]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "SpanFromLeft", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"SpanFromAbove", ",", "SpanFromBoth", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2099287209],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "\[SpanFromLeft]", "2"},
    {"\[SpanFromAbove]", "\[SpanFromBoth]", "3"},
    {"4", "5", "6"}
   }],
  "Grid"]], "Output",
 ImageSize->{41, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->295666041]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19097116],

Cell["A visual design:", "ExampleText",
 CellID->1176950388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Grid", "[", 
   RowBox[{
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<\>\"", ",", 
        RowBox[{"Item", "[", " ", 
         RowBox[{"\"\<\>\"", ",", 
          RowBox[{"Background", "\[Rule]", "Red"}]}], "]"}], ",", " ", 
        "\[SpanFromLeft]"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\>\"", ",", " ", "\[SpanFromAbove]", ",", " ", 
        "\[SpanFromBoth]"}], "}"}], ",", "    ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Item", "[", 
         RowBox[{"\"\<\>\"", ",", 
          RowBox[{"Background", "\[Rule]", "Blue"}]}], "]"}], ",", " ", 
        "\"\<\>\"", ",", "\"\<\>\""}], "}"}], ",", "  ", 
      RowBox[{"{", 
       RowBox[{"\[SpanFromAbove]", ",", " ", "\[SpanFromAbove]", ",", " ", 
        RowBox[{"Item", "[", " ", 
         RowBox[{"\"\<\>\"", ",", 
          RowBox[{"Background", "\[Rule]", "Yellow"}]}], "]"}]}], "}"}]}], 
     "   ", "}"}], ",", 
    RowBox[{"Dividers", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", " ", "->", " ", 
          RowBox[{"Thickness", "[", "3", "]"}]}], ",", " ", 
         RowBox[{"3", " ", "->", " ", 
          RowBox[{"Thickness", "[", "3", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", " ", "->", 
          RowBox[{"Thickness", "[", "5", "]"}]}], ",", " ", 
         RowBox[{"3", " ", "->", " ", 
          RowBox[{"Thickness", "[", "3", "]"}]}], ",", "  ", 
         RowBox[{"4", " ", "->", " ", 
          RowBox[{"Thickness", "[", "3", "]"}]}]}], "}"}]}], "}"}]}], ",", 
    RowBox[{"ItemSize", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "->", " ", "4"}], ",", " ", 
         RowBox[{"2", " ", "->", " ", "9"}], ",", " ", 
         RowBox[{"3", " ", "->", " ", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", " ", "->", " ", "6"}], ",", " ", 
         RowBox[{"2", " ", "->", " ", "6"}], ",", " ", 
         RowBox[{"3", " ", "->", " ", "2"}], ",", " ", 
         RowBox[{"4", " ", "->", " ", "2"}]}], "}"}]}], "}"}]}]}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->695667300],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwnADivRIMQPZ/IAuM
T/z/D6QhpAWQzwwUrALyQLQASHBUdNiKCjMwkCECNQt7ehkVHcGiJ8BpBZm0
gMr3/h/ljfJGeQPLsyaZNZhcP8ob5Q1/HqQlzsAIAAHj7GQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{200, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->688271048]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->764730928],

Cell["A Sudoku grid:", "ExampleText",
 CellID->1936596363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Grid", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{"\[Placeholder]", ",", " ", 
      RowBox[{"{", "9", "}"}], ",", " ", 
      RowBox[{"{", "9", "}"}]}], "]"}], ",", "\n", 
    RowBox[{"ItemSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], ",", 
    RowBox[{"Dividers", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "2", "]"}], ",", "True", ",", "True"}], 
         "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "2", "]"}], ",", "True", ",", "True"}], 
         "}"}], "}"}]}], "}"}]}], ",", "\n", 
    RowBox[{"Background", " ", "->", " ", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", "Automatic", ",", "\n", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"i", ",", " ", "j"}], "}"}], " ", "->", " ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"EvenQ", "[", 
              RowBox[{"Plus", " ", "@@", " ", 
               RowBox[{"Floor", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"i", " ", "-", " ", "1"}], ",", " ", 
                   RowBox[{"j", " ", "-", " ", "1"}]}], "}"}], "/", "3"}], 
                "]"}]}], "]"}], ",", " ", "\n", 
             RowBox[{"Darker", "[", "White", "]"}], ",", " ", "White"}], 
            "]"}]}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"i", ",", " ", "9"}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"j", ",", " ", "9"}], "}"}]}], "]"}], "]"}]}], "}"}]}]}], 
   "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134882431],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztncFOwkAQQKeQeAHq1RuN/ohc9ORHNMQEDkaDfHPvfkHd1pJtSo2NYnZ3
5pE07pZhH+07zMwmxafyuHt+KY/7bVk8Hsq33X77Xjy8HtypeSaS3YvIx424
ce1G7dG8Nu74GnYj98ZGRPqjmTvuqqqSuRtU7UuKkXkTd9usMj+tXksxMm/j
flhv3a0HHXooeu5mV+7v9SBqMeF88/mVo7bzwbdZTDjffv6X/PzsKvpRs8F8
NbLKpeNPd6N/tbPBfPj+4h/iT3c15P1YYgc72MGOATvpZ0/L9Q906NCha6ez
0wEdeji6jkqRbsTHx9mNYAc72MGOPjvpZ0/L9Q906NCha6ezzwIdeji6jkqR
bsTHx9mNYAc72MGOPjvpZ0/L9Q906NCha6d/+wzPhUhTv/m6Ww86dJv0vA5T
8/215szPrqIfZbUfiKU/WmIHO9jBjgE76WdPy/UPdOjQoWuns88CHXo4uo5K
kW7Ex8fZjWAHO9jBjj476WdPy/UPdOjQoWuns88CHXo4uo5KkW7Ex8fZjWAH
O9jBjj476WdPy/UPdOjQoWun81+AoEOPga7jqXN+2cDHx9Af8bsT2MEOdizY
ST97Wq5/oEOHDl07nX0W6NDD0XVUinQjPj7ObgQ72MEOdvTZST97Wq5/oEOH
Dl07nX0W6NDD0XVUinQjPj7ObgQ72MEOdvTZST97Wq5/oEOHDl07fewJomap
TbOcSPYJXF98pg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{320, 241},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120437624]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6013013],

Cell["Create a random arrangement of spanning rows and columns:", \
"ExampleText",
 CellID->368695436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RandomChoice", "[", 
      RowBox[{"{", 
       RowBox[{"SpanFromLeft", ",", "SpanFromAbove", ",", 
        RowBox[{"Item", "[", 
         RowBox[{
          RowBox[{"RandomInteger", "[", "1000", "]"}], ",", 
          RowBox[{"Background", "\[Rule]", 
           RowBox[{"Hue", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", "]"}], ",", ".2", ",", ".9"}], 
            "]"}]}]}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", "20", "}"}], ",", 
     RowBox[{"{", "12", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->330630511],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{368, 317},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34280393]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5760],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsGrid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsGrid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Row",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Row"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Column",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Column"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TableForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TableForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Labeled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Labeled"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->99]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22002],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->22605],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->542584750],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Grid",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Grid"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->195765519],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->103126181],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->462567555],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->16601858],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->394536297],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->7474533],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->35880941],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->1448324],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->3088493],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->17280838],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->258972108],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->83660851]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Grid - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 16.7718914}", "context" -> "System`", 
    "keywords" -> {
     "2D layout", "array", "spread-sheet", "spreadsheet", "table", 
      "tabular layout", "tabulation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Grid[{{expr_11, expr_12, ...}, {expr_21, expr_22, ...}, ...}] is an \
object that formats with the expr_ij arranged in a two-dimensional grid. ", 
    "synonyms" -> {}, "title" -> "Grid", "type" -> "Symbol", "uri" -> 
    "ref/Grid"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[38529, 1238, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->2592399]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 162404, 5613}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4400, 90, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5023, 117, 1569, 37, 70, "ObjectNameGrid"],
Cell[6595, 156, 1312, 40, 70, "Usage",
 CellID->21649]
}, Open  ]],
Cell[CellGroupData[{
Cell[7944, 201, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8422, 218, 772, 25, 70, "Notes",
 CellID->10485],
Cell[9197, 245, 497, 19, 70, "Notes",
 CellID->7055],
Cell[9697, 266, 519, 19, 70, "Notes",
 CellID->12572],
Cell[10219, 287, 557, 22, 70, "Notes",
 CellID->12889],
Cell[10779, 311, 263, 9, 70, "Notes",
 CellID->2858],
Cell[11045, 322, 227, 8, 70, "Notes",
 CellID->17552],
Cell[11275, 332, 726, 24, 70, "Notes",
 CellID->129],
Cell[12004, 358, 659, 24, 70, "Notes",
 CellID->14640],
Cell[12666, 384, 726, 24, 70, "Notes",
 CellID->6860],
Cell[13395, 410, 108, 3, 70, "Notes",
 CellID->8046],
Cell[13506, 415, 957, 25, 70, "2ColumnTableMod",
 CellID->28627],
Cell[14466, 442, 1116, 35, 70, "Notes",
 CellID->5044],
Cell[15585, 479, 209, 6, 70, "Notes",
 CellID->6422],
Cell[15797, 487, 69, 1, 70, "Notes",
 CellID->19154],
Cell[15869, 490, 3670, 103, 70, "3ColumnTableMod",
 CellID->333],
Cell[19542, 595, 196, 8, 70, "Notes",
 CellID->13269],
Cell[19741, 605, 1819, 50, 70, "2ColumnTableMod",
 CellID->5388],
Cell[21563, 657, 770, 28, 70, "Notes",
 CellID->8756],
Cell[22336, 687, 1989, 63, 70, "2ColumnTableMod",
 CellID->194396524],
Cell[24328, 752, 190, 8, 70, "Notes",
 CellID->25391],
Cell[24521, 762, 6759, 220, 70, "2ColumnTableMod",
 CellID->277342543],
Cell[31283, 984, 747, 22, 70, "Notes",
 CellID->26373273],
Cell[32033, 1008, 630, 23, 70, "Notes",
 CellID->4827],
Cell[32666, 1033, 484, 17, 70, "Notes",
 CellID->8202],
Cell[33153, 1052, 372, 13, 70, "Notes",
 CellID->11176],
Cell[33528, 1067, 641, 21, 70, "Notes",
 CellID->49335815],
Cell[34172, 1090, 348, 13, 70, "Notes",
 CellID->103124118],
Cell[34523, 1105, 1083, 33, 70, "2ColumnTableMod",
 CellID->934654743],
Cell[35609, 1140, 485, 18, 70, "Notes",
 CellID->405888177],
Cell[36097, 1160, 227, 8, 70, "Notes",
 CellID->3429],
Cell[36327, 1170, 1821, 51, 70, "2ColumnTableMod",
 CellID->46602970],
Cell[38151, 1223, 341, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[38529, 1238, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2592399],
Cell[CellGroupData[{
Cell[38912, 1252, 148, 5, 70, "ExampleSection",
 CellID->110018803],
Cell[39063, 1259, 70, 1, 70, "ExampleText",
 CellID->255138841],
Cell[CellGroupData[{
Cell[39158, 1264, 269, 9, 28, "Input",
 CellID->209490826],
Cell[39430, 1275, 231, 10, 48, "Output",
 CellID->154677502]
}, Open  ]],
Cell[39676, 1288, 125, 3, 70, "ExampleDelimiter",
 CellID->344040015],
Cell[39804, 1293, 75, 1, 70, "ExampleText",
 CellID->20121397],
Cell[CellGroupData[{
Cell[39904, 1298, 390, 13, 70, "Input",
 CellID->236225215],
Cell[40297, 1313, 345, 13, 58, "Output",
 CellID->5194239]
}, Open  ]],
Cell[40657, 1329, 125, 3, 70, "ExampleDelimiter",
 CellID->554058385],
Cell[40785, 1334, 211, 8, 70, "ExampleText",
 CellID->967757468],
Cell[CellGroupData[{
Cell[41021, 1346, 339, 11, 70, "Input",
 CellID->625080644],
Cell[41363, 1359, 393, 13, 54, "Output",
 CellID->370201120]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41805, 1378, 221, 7, 70, "ExampleSection",
 CellID->371246094],
Cell[CellGroupData[{
Cell[42051, 1389, 238, 7, 70, "ExampleSubsection",
 CellID->428441244],
Cell[42292, 1398, 203, 7, 70, "ExampleText",
 CellID->943132222],
Cell[CellGroupData[{
Cell[42520, 1409, 369, 13, 70, "Input",
 CellID->198433603],
Cell[42892, 1424, 1015, 34, 90, "Output",
 CellID->43601449]
}, Open  ]],
Cell[43922, 1461, 125, 3, 70, "ExampleDelimiter",
 CellID->335319585],
Cell[44050, 1466, 215, 7, 70, "ExampleText",
 CellID->34391300],
Cell[CellGroupData[{
Cell[44290, 1477, 354, 11, 70, "Input",
 CellID->320176929],
Cell[44647, 1490, 1300, 25, 70, "Output",
 Evaluatable->False,
 CellID->91162096]
}, Open  ]],
Cell[45962, 1518, 125, 3, 70, "ExampleDelimiter",
 CellID->141895743],
Cell[46090, 1523, 197, 7, 70, "ExampleText",
 CellID->26815302],
Cell[CellGroupData[{
Cell[46312, 1534, 246, 8, 70, "Input",
 CellID->7447461],
Cell[46561, 1544, 617, 26, 70, "Output",
 CellID->41773250]
}, Open  ]],
Cell[47193, 1573, 125, 3, 70, "ExampleDelimiter",
 CellID->964429372],
Cell[47321, 1578, 75, 1, 70, "ExampleText",
 CellID->980610876],
Cell[CellGroupData[{
Cell[47421, 1583, 219, 8, 70, "Input",
 CellID->18272998],
Cell[47643, 1593, 314, 9, 36, "Output",
 CellID->468702275]
}, Open  ]],
Cell[CellGroupData[{
Cell[47994, 1607, 121, 4, 70, "Input",
 CellID->1400391],
Cell[48118, 1613, 269, 9, 36, "Output",
 CellID->749542512]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48436, 1628, 242, 7, 70, "ExampleSubsection",
 CellID->511949576],
Cell[48681, 1637, 76, 1, 70, "ExampleText",
 CellID->61301763],
Cell[CellGroupData[{
Cell[48782, 1642, 279, 9, 70, "Input",
 CellID->62846654],
Cell[49064, 1653, 382, 12, 70, "Output",
 CellID->191453533]
}, Open  ]],
Cell[49461, 1668, 125, 3, 70, "ExampleDelimiter",
 CellID->545138637],
Cell[49589, 1673, 76, 1, 70, "ExampleText",
 CellID->861064787],
Cell[CellGroupData[{
Cell[49690, 1678, 279, 9, 70, "Input",
 CellID->393168623],
Cell[49972, 1689, 375, 12, 72, "Output",
 CellID->642299167]
}, Open  ]],
Cell[50362, 1704, 71, 1, 70, "ExampleText",
 CellID->1058702674],
Cell[CellGroupData[{
Cell[50458, 1709, 331, 10, 70, "Input",
 CellID->1713826523],
Cell[50792, 1721, 408, 13, 72, "Output",
 CellID->58932655]
}, Open  ]],
Cell[51215, 1737, 124, 3, 70, "ExampleDelimiter",
 CellID->88007557],
Cell[51342, 1742, 87, 1, 70, "ExampleText",
 CellID->205713954],
Cell[CellGroupData[{
Cell[51454, 1747, 388, 13, 70, "Input",
 CellID->123321595],
Cell[51845, 1762, 371, 12, 70, "Output",
 CellID->665646497]
}, Open  ]],
Cell[52231, 1777, 88, 1, 70, "ExampleText",
 CellID->1196540285],
Cell[CellGroupData[{
Cell[52344, 1782, 389, 13, 70, "Input",
 CellID->1215699487],
Cell[52736, 1797, 413, 14, 70, "Output",
 CellID->142600956]
}, Open  ]],
Cell[53164, 1814, 125, 3, 70, "ExampleDelimiter",
 CellID->144232786],
Cell[53292, 1819, 84, 1, 70, "ExampleText",
 CellID->324771918],
Cell[CellGroupData[{
Cell[53401, 1824, 337, 11, 70, "Input",
 CellID->750408934],
Cell[53741, 1837, 379, 12, 64, "Output",
 CellID->455591042]
}, Open  ]],
Cell[54135, 1852, 82, 1, 70, "ExampleText",
 CellID->430163479],
Cell[CellGroupData[{
Cell[54242, 1857, 335, 11, 70, "Input",
 CellID->8273050],
Cell[54580, 1870, 397, 11, 70, "Output",
 Evaluatable->False,
 CellID->80658439]
}, Open  ]],
Cell[54992, 1884, 126, 3, 70, "ExampleDelimiter",
 CellID->1182797647],
Cell[55121, 1889, 117, 3, 70, "ExampleText",
 CellID->23932850],
Cell[CellGroupData[{
Cell[55263, 1896, 469, 15, 70, "Input",
 CellID->659967961],
Cell[55735, 1913, 400, 13, 64, "Output",
 CellID->525614991]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[56184, 1932, 238, 7, 70, "ExampleSubsection",
 CellID->240043264],
Cell[56425, 1941, 91, 1, 70, "ExampleText",
 CellID->578952123],
Cell[CellGroupData[{
Cell[56541, 1946, 418, 13, 70, "Input",
 CellID->348140959],
Cell[56962, 1961, 328, 12, 70, "Output",
 CellID->333566648]
}, Open  ]],
Cell[57305, 1976, 70, 1, 70, "ExampleText",
 CellID->581884849],
Cell[CellGroupData[{
Cell[57400, 1981, 428, 13, 70, "Input",
 CellID->74187149],
Cell[57831, 1996, 342, 12, 70, "Output",
 CellID->366092963]
}, Open  ]],
Cell[58188, 2011, 124, 3, 70, "ExampleDelimiter",
 CellID->73873043],
Cell[58315, 2016, 84, 1, 70, "ExampleText",
 CellID->547117279],
Cell[CellGroupData[{
Cell[58424, 2021, 418, 13, 70, "Input",
 CellID->75970249],
Cell[58845, 2036, 329, 12, 72, "Output",
 CellID->647156921]
}, Open  ]],
Cell[59189, 2051, 67, 1, 70, "ExampleText",
 CellID->122949571],
Cell[CellGroupData[{
Cell[59281, 2056, 431, 13, 70, "Input",
 CellID->603613667],
Cell[59715, 2071, 344, 12, 72, "Output",
 CellID->266782177]
}, Open  ]],
Cell[60074, 2086, 124, 3, 70, "ExampleDelimiter",
 CellID->47616072],
Cell[60201, 2091, 78, 1, 70, "ExampleText",
 CellID->210615047],
Cell[CellGroupData[{
Cell[60304, 2096, 441, 13, 70, "Input",
 CellID->839795991],
Cell[60748, 2111, 356, 12, 72, "Output",
 CellID->16519960]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[61153, 2129, 230, 7, 70, "ExampleSubsection",
 CellID->391029099],
Cell[61386, 2138, 71, 1, 70, "ExampleText",
 CellID->1202194683],
Cell[CellGroupData[{
Cell[61482, 2143, 370, 12, 70, "Input",
 CellID->799770335],
Cell[61855, 2157, 333, 12, 56, "Output",
 CellID->14144210]
}, Open  ]],
Cell[62203, 2172, 125, 3, 70, "ExampleDelimiter",
 CellID->268320393],
Cell[62331, 2177, 71, 1, 70, "ExampleText",
 CellID->105324452],
Cell[CellGroupData[{
Cell[62427, 2182, 371, 12, 70, "Input",
 CellID->173862713],
Cell[62801, 2196, 335, 12, 56, "Output",
 CellID->497208083]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63185, 2214, 228, 7, 70, "ExampleSubsection",
 CellID->173615003],
Cell[63416, 2223, 80, 1, 70, "ExampleText",
 CellID->701515873],
Cell[CellGroupData[{
Cell[63521, 2228, 285, 9, 70, "Input",
 CellID->692055481],
Cell[63809, 2239, 400, 11, 70, "Output",
 Evaluatable->False,
 CellID->8451376]
}, Open  ]],
Cell[64224, 2253, 125, 3, 70, "ExampleDelimiter",
 CellID->928090012],
Cell[64352, 2258, 117, 3, 70, "ExampleText",
 CellID->501317172],
Cell[CellGroupData[{
Cell[64494, 2265, 365, 12, 70, "Input",
 CellID->83112486],
Cell[64862, 2279, 442, 11, 70, "Output",
 Evaluatable->False,
 CellID->572740993]
}, Open  ]],
Cell[65319, 2293, 125, 3, 70, "ExampleDelimiter",
 CellID->306149779],
Cell[65447, 2298, 114, 3, 70, "ExampleText",
 CellID->851891726],
Cell[CellGroupData[{
Cell[65586, 2305, 434, 15, 70, "Input",
 CellID->207244729],
Cell[66023, 2322, 491, 12, 70, "Output",
 Evaluatable->False,
 CellID->135241940]
}, Open  ]],
Cell[66529, 2337, 125, 3, 70, "ExampleDelimiter",
 CellID->212518288],
Cell[66657, 2342, 112, 3, 70, "ExampleText",
 CellID->222607990],
Cell[CellGroupData[{
Cell[66794, 2349, 430, 15, 70, "Input",
 CellID->34782048],
Cell[67227, 2366, 466, 12, 70, "Output",
 Evaluatable->False,
 CellID->40994613]
}, Open  ]],
Cell[67708, 2381, 126, 3, 70, "ExampleDelimiter",
 CellID->2023262693],
Cell[67837, 2386, 71, 1, 70, "ExampleText",
 CellID->1759886205],
Cell[CellGroupData[{
Cell[67933, 2391, 284, 9, 70, "Input",
 CellID->1316391855],
Cell[68220, 2402, 394, 11, 70, "Output",
 Evaluatable->False,
 CellID->396604398]
}, Open  ]],
Cell[68629, 2416, 126, 3, 70, "ExampleDelimiter",
 CellID->1720014653],
Cell[68758, 2421, 94, 1, 70, "ExampleText",
 CellID->1115177304],
Cell[CellGroupData[{
Cell[68877, 2426, 415, 14, 70, "Input",
 CellID->639873772],
Cell[69295, 2442, 318, 14, 52, "Output",
 CellID->97243990]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[69662, 2462, 228, 7, 70, "ExampleSubsection",
 CellID->267316272],
Cell[69893, 2471, 122, 3, 70, "ExampleText",
 CellID->354141537],
Cell[CellGroupData[{
Cell[70040, 2478, 326, 10, 70, "Input",
 CellID->158819658],
Cell[70369, 2490, 475, 15, 104, "Output",
 CellID->174977972]
}, Open  ]],
Cell[70859, 2508, 125, 3, 70, "ExampleDelimiter",
 CellID->851546081],
Cell[70987, 2513, 87, 1, 70, "ExampleText",
 CellID->14693373],
Cell[CellGroupData[{
Cell[71099, 2518, 373, 11, 70, "Input",
 CellID->4578563],
Cell[71475, 2531, 539, 18, 104, "Output",
 CellID->469812]
}, Open  ]],
Cell[72029, 2552, 126, 3, 70, "ExampleDelimiter",
 CellID->1235103523],
Cell[72158, 2557, 82, 1, 70, "ExampleText",
 CellID->2609790],
Cell[CellGroupData[{
Cell[72265, 2562, 325, 10, 70, "Input",
 CellID->57263510],
Cell[72593, 2574, 356, 13, 72, "Output",
 CellID->227571943]
}, Open  ]],
Cell[72964, 2590, 124, 3, 70, "ExampleDelimiter",
 CellID->78340660],
Cell[73091, 2595, 85, 1, 70, "ExampleText",
 CellID->1695160959],
Cell[CellGroupData[{
Cell[73201, 2600, 377, 12, 70, "Input",
 CellID->427974663],
Cell[73581, 2614, 372, 13, 56, "Output",
 CellID->46716673]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[74002, 2633, 233, 7, 70, "ExampleSubsection",
 CellID->359856620],
Cell[74238, 2642, 62, 1, 70, "ExampleText",
 CellID->32743373],
Cell[CellGroupData[{
Cell[74325, 2647, 666, 21, 70, "Input",
 CellID->102307895],
Cell[74994, 2670, 411, 17, 86, "Output",
 CellID->147064326]
}, Open  ]],
Cell[75420, 2690, 125, 3, 70, "ExampleDelimiter",
 CellID->188564242],
Cell[CellGroupData[{
Cell[75570, 2697, 447, 15, 70, "Input",
 CellID->125387553],
Cell[76020, 2714, 432, 18, 86, "Output",
 CellID->33775811]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[76513, 2739, 222, 7, 70, "ExampleSection",
 CellID->59466161],
Cell[CellGroupData[{
Cell[76760, 2750, 230, 7, 70, "ExampleSubsection",
 CellID->565833074],
Cell[76993, 2759, 87, 1, 70, "ExampleText",
 CellID->78137354],
Cell[CellGroupData[{
Cell[77105, 2764, 1102, 34, 70, "Input",
 CellID->42645857],
Cell[78210, 2800, 361, 10, 70, "Output",
 Evaluatable->False,
 CellID->373275523]
}, Open  ]],
Cell[78586, 2813, 126, 3, 70, "ExampleDelimiter",
 CellID->1308533125],
Cell[78715, 2818, 79, 1, 70, "ExampleText",
 CellID->1142000361],
Cell[CellGroupData[{
Cell[78819, 2823, 411, 13, 70, "Input",
 CellID->1803708221],
Cell[79233, 2838, 330, 12, 64, "Output",
 CellID->655031610]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[79612, 2856, 231, 7, 70, "ExampleSubsection",
 CellID->221411408],
Cell[79846, 2865, 79, 1, 70, "ExampleText",
 CellID->13842222],
Cell[CellGroupData[{
Cell[79950, 2870, 285, 9, 70, "Input",
 CellID->717991278],
Cell[80238, 2881, 402, 11, 70, "Output",
 Evaluatable->False,
 CellID->297901019]
}, Open  ]],
Cell[80655, 2895, 126, 3, 70, "ExampleDelimiter",
 CellID->1166625332],
Cell[80784, 2900, 123, 3, 70, "ExampleText",
 CellID->946257814],
Cell[CellGroupData[{
Cell[80932, 2907, 401, 14, 70, "Input",
 CellID->1855750711],
Cell[81336, 2923, 479, 12, 70, "Output",
 Evaluatable->False,
 CellID->306473265]
}, Open  ]],
Cell[81830, 2938, 65, 1, 70, "ExampleText",
 CellID->1638673863],
Cell[CellGroupData[{
Cell[81920, 2943, 471, 16, 70, "Input",
 CellID->1538714088],
Cell[82394, 2961, 479, 12, 70, "Output",
 Evaluatable->False,
 CellID->620453852]
}, Open  ]],
Cell[82888, 2976, 126, 3, 70, "ExampleDelimiter",
 CellID->1861326313],
Cell[83017, 2981, 121, 3, 70, "ExampleText",
 CellID->482528275],
Cell[CellGroupData[{
Cell[83163, 2988, 397, 13, 70, "Input",
 CellID->554886156],
Cell[83563, 3003, 466, 15, 78, "Output",
 CellID->6132843]
}, Open  ]],
Cell[84044, 3021, 124, 3, 70, "ExampleDelimiter",
 CellID->21555281],
Cell[84171, 3026, 81, 1, 70, "ExampleText",
 CellID->954466853],
Cell[CellGroupData[{
Cell[84277, 3031, 430, 15, 70, "Input",
 CellID->1930194792],
Cell[84710, 3048, 471, 15, 78, "Output",
 CellID->26809827]
}, Open  ]],
Cell[85196, 3066, 135, 4, 70, "ExampleText",
 CellID->1502355071],
Cell[CellGroupData[{
Cell[85356, 3074, 664, 22, 70, "Input",
 CellID->448480217],
Cell[86023, 3098, 516, 13, 70, "Output",
 Evaluatable->False,
 CellID->680952554]
}, Open  ]],
Cell[86554, 3114, 125, 3, 70, "ExampleDelimiter",
 CellID->697401140],
Cell[86682, 3119, 62, 1, 70, "ExampleText",
 CellID->636484464],
Cell[CellGroupData[{
Cell[86769, 3124, 520, 18, 70, "Input",
 CellID->527153300],
Cell[87292, 3144, 481, 15, 78, "Output",
 CellID->196042075]
}, Open  ]],
Cell[87788, 3162, 124, 3, 70, "ExampleDelimiter",
 CellID->96657118],
Cell[87915, 3167, 82, 1, 70, "ExampleText",
 CellID->1018545094],
Cell[CellGroupData[{
Cell[88022, 3172, 608, 20, 70, "Input",
 CellID->1415183459],
Cell[88633, 3194, 521, 16, 78, "Output",
 CellID->89347199]
}, Open  ]],
Cell[89169, 3213, 125, 3, 70, "ExampleDelimiter",
 CellID->174397539],
Cell[89297, 3218, 91, 1, 70, "ExampleText",
 CellID->1095244621],
Cell[CellGroupData[{
Cell[89413, 3223, 606, 20, 70, "Input",
 CellID->452610656],
Cell[90022, 3245, 486, 12, 70, "Output",
 Evaluatable->False,
 CellID->39162271]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[90557, 3263, 237, 7, 70, "ExampleSubsection",
 CellID->692489402],
Cell[90797, 3272, 117, 3, 70, "ExampleText",
 CellID->30132536],
Cell[CellGroupData[{
Cell[90939, 3279, 400, 14, 70, "Input",
 CellID->30922498],
Cell[91342, 3295, 368, 13, 54, "Output",
 CellID->158680494]
}, Open  ]],
Cell[91725, 3311, 125, 3, 70, "ExampleDelimiter",
 CellID->749255240],
Cell[91853, 3316, 91, 1, 70, "ExampleText",
 CellID->1694006710],
Cell[CellGroupData[{
Cell[91969, 3321, 463, 15, 70, "Input",
 CellID->881279972],
Cell[92435, 3338, 399, 14, 61, "Output",
 CellID->736387581]
}, Open  ]],
Cell[92849, 3355, 126, 3, 70, "ExampleDelimiter",
 CellID->1574281725],
Cell[92978, 3360, 92, 1, 70, "ExampleText",
 CellID->1980066691],
Cell[CellGroupData[{
Cell[93095, 3365, 577, 19, 70, "Input",
 CellID->157255358],
Cell[93675, 3386, 409, 14, 56, "Output",
 CellID->196752513]
}, Open  ]],
Cell[CellGroupData[{
Cell[94121, 3405, 637, 21, 70, "Input",
 CellID->760715332],
Cell[94761, 3428, 466, 16, 60, "Output",
 CellID->19261901]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[95276, 3450, 229, 7, 70, "ExampleSubsection",
 CellID->151600544],
Cell[95508, 3459, 71, 1, 70, "ExampleText",
 CellID->1954421035],
Cell[CellGroupData[{
Cell[95604, 3464, 286, 9, 70, "Input",
 CellID->1940480886],
Cell[95893, 3475, 450, 14, 82, "Output",
 CellID->8413455]
}, Open  ]],
Cell[96358, 3492, 126, 3, 70, "ExampleDelimiter",
 CellID->1113467454],
Cell[96487, 3497, 94, 1, 70, "ExampleText",
 CellID->1237013789],
Cell[CellGroupData[{
Cell[96606, 3502, 434, 15, 70, "Input",
 CellID->1897885587],
Cell[97043, 3519, 529, 13, 70, "Output",
 Evaluatable->False,
 CellID->403778029]
}, Open  ]],
Cell[97587, 3535, 71, 1, 70, "ExampleText",
 CellID->1519682582],
Cell[CellGroupData[{
Cell[97683, 3540, 557, 19, 70, "Input",
 CellID->564304379],
Cell[98243, 3561, 532, 13, 70, "Output",
 Evaluatable->False,
 CellID->76584041]
}, Open  ]],
Cell[98790, 3577, 126, 3, 70, "ExampleDelimiter",
 CellID->2092862981],
Cell[98919, 3582, 80, 1, 70, "ExampleText",
 CellID->1282141903],
Cell[CellGroupData[{
Cell[99024, 3587, 645, 22, 70, "Input",
 CellID->1832153568],
Cell[99672, 3611, 552, 13, 70, "Output",
 Evaluatable->False,
 CellID->666577806]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[100273, 3630, 226, 7, 70, "ExampleSubsection",
 CellID->484677263],
Cell[100502, 3639, 66, 1, 70, "ExampleText",
 CellID->1647424742],
Cell[CellGroupData[{
Cell[100593, 3644, 280, 9, 70, "Input",
 CellID->406535651],
Cell[100876, 3655, 423, 13, 84, "Output",
 CellID->190553824]
}, Open  ]],
Cell[101314, 3671, 125, 3, 70, "ExampleDelimiter",
 CellID->322065365],
Cell[101442, 3676, 74, 1, 70, "ExampleText",
 CellID->760978023],
Cell[CellGroupData[{
Cell[101541, 3681, 279, 9, 70, "Input",
 CellID->717006499],
Cell[101823, 3692, 416, 13, 88, "Output",
 CellID->737279966]
}, Open  ]],
Cell[102254, 3708, 126, 3, 70, "ExampleDelimiter",
 CellID->1031681727],
Cell[102383, 3713, 68, 1, 70, "ExampleText",
 CellID->1356547037],
Cell[CellGroupData[{
Cell[102476, 3718, 604, 20, 70, "Input",
 CellID->1108049723],
Cell[103083, 3740, 471, 15, 84, "Output",
 CellID->856677941]
}, Open  ]],
Cell[103569, 3758, 124, 3, 70, "ExampleDelimiter",
 CellID->60550712],
Cell[103696, 3763, 59, 1, 70, "ExampleText",
 CellID->1799654307],
Cell[CellGroupData[{
Cell[103780, 3768, 602, 20, 70, "Input",
 CellID->1630253401],
Cell[104385, 3790, 465, 15, 82, "Output",
 CellID->548146625]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[104899, 3811, 232, 7, 70, "ExampleSubsection",
 CellID->1487836305],
Cell[105134, 3820, 225, 7, 70, "ExampleText",
 CellID->1784441749],
Cell[CellGroupData[{
Cell[105384, 3831, 1125, 36, 70, "Input",
 CellID->2010859911],
Cell[106512, 3869, 507, 12, 70, "Output",
 Evaluatable->False,
 CellID->31820466]
}, Open  ]],
Cell[107034, 3884, 125, 3, 70, "ExampleDelimiter",
 CellID->596672098],
Cell[107162, 3889, 480, 17, 70, "ExampleText",
 CellID->1503345088],
Cell[CellGroupData[{
Cell[107667, 3910, 1232, 38, 70, "Input",
 CellID->306806790],
Cell[108902, 3950, 545, 13, 70, "Output",
 Evaluatable->False,
 CellID->458283516]
}, Open  ]],
Cell[109462, 3966, 125, 3, 70, "ExampleDelimiter",
 CellID->147237284],
Cell[109590, 3971, 254, 8, 70, "ExampleText",
 CellID->1575787061],
Cell[CellGroupData[{
Cell[109869, 3983, 1264, 39, 70, "Input",
 CellID->1991996265],
Cell[111136, 4024, 679, 15, 70, "Output",
 Evaluatable->False,
 CellID->480350421]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[111864, 4045, 229, 7, 70, "ExampleSubsection",
 CellID->460739316],
Cell[112096, 4054, 97, 1, 70, "ExampleText",
 CellID->85240919],
Cell[CellGroupData[{
Cell[112218, 4059, 330, 11, 70, "Input",
 CellID->1345672932],
Cell[112551, 4072, 441, 14, 96, "Output",
 CellID->608768335]
}, Open  ]],
Cell[113007, 4089, 125, 3, 70, "ExampleDelimiter",
 CellID->284313921],
Cell[113135, 4094, 309, 11, 70, "ExampleText",
 CellID->312955672],
Cell[CellGroupData[{
Cell[113469, 4109, 330, 11, 70, "Input",
 CellID->1937970707],
Cell[113802, 4122, 358, 13, 40, "Output",
 CellID->77452591]
}, Open  ]],
Cell[114175, 4138, 124, 3, 70, "ExampleDelimiter",
 CellID->96817517],
Cell[114302, 4143, 335, 11, 70, "ExampleText",
 CellID->1566887440],
Cell[CellGroupData[{
Cell[114662, 4158, 362, 12, 70, "Input",
 CellID->571442514],
Cell[115027, 4172, 619, 16, 94, "Output",
 CellID->416904943]
}, Open  ]],
Cell[115661, 4191, 123, 3, 70, "ExampleDelimiter",
 CellID->6591469],
Cell[115787, 4196, 66, 1, 70, "ExampleText",
 CellID->1016039772],
Cell[CellGroupData[{
Cell[115878, 4201, 358, 12, 70, "Input",
 CellID->1124518717],
Cell[116239, 4215, 607, 16, 56, "Output",
 CellID->97199350]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[116895, 4237, 230, 7, 70, "ExampleSubsection",
 CellID->714928751],
Cell[117128, 4246, 80, 1, 70, "ExampleText",
 CellID->253498692],
Cell[CellGroupData[{
Cell[117233, 4251, 284, 9, 70, "Input",
 CellID->646483028],
Cell[117520, 4262, 393, 11, 70, "Output",
 Evaluatable->False,
 CellID->86435093]
}, Open  ]],
Cell[117928, 4276, 125, 3, 70, "ExampleDelimiter",
 CellID->658603261],
Cell[118056, 4281, 224, 8, 70, "ExampleText",
 CellID->1492514676],
Cell[CellGroupData[{
Cell[118305, 4293, 392, 13, 70, "Input",
 CellID->1590541561],
Cell[118700, 4308, 442, 11, 70, "Output",
 Evaluatable->False,
 CellID->28340463]
}, Open  ]],
Cell[119157, 4322, 126, 3, 70, "ExampleDelimiter",
 CellID->1373950644],
Cell[119286, 4327, 81, 1, 70, "ExampleText",
 CellID->8827871],
Cell[CellGroupData[{
Cell[119392, 4332, 295, 9, 70, "Input",
 CellID->498451071],
Cell[119690, 4343, 439, 11, 70, "Output",
 Evaluatable->False,
 CellID->251152654]
}, Open  ]],
Cell[120144, 4357, 124, 3, 70, "ExampleDelimiter",
 CellID->24144160],
Cell[120271, 4362, 68, 1, 70, "ExampleText",
 CellID->2085162572],
Cell[CellGroupData[{
Cell[120364, 4367, 624, 20, 70, "Input",
 CellID->666653385],
Cell[120991, 4389, 438, 11, 70, "Output",
 Evaluatable->False,
 CellID->471950401]
}, Open  ]],
Cell[121444, 4403, 124, 3, 70, "ExampleDelimiter",
 CellID->53263470],
Cell[121571, 4408, 58, 1, 70, "ExampleText",
 CellID->541712211],
Cell[CellGroupData[{
Cell[121654, 4413, 617, 20, 70, "Input",
 CellID->2099088016],
Cell[122274, 4435, 446, 11, 70, "Output",
 Evaluatable->False,
 CellID->241425763]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[122769, 4452, 229, 7, 70, "ExampleSubsection",
 CellID->827811325],
Cell[123001, 4461, 87, 1, 70, "ExampleText",
 CellID->1284553133],
Cell[CellGroupData[{
Cell[123113, 4466, 281, 9, 70, "Input",
 CellID->1403149669],
Cell[123397, 4477, 410, 11, 70, "Output",
 Evaluatable->False,
 CellID->343649016]
}, Open  ]],
Cell[123822, 4491, 125, 3, 70, "ExampleDelimiter",
 CellID->142253632],
Cell[123950, 4496, 94, 1, 70, "ExampleText",
 CellID->831403040],
Cell[CellGroupData[{
Cell[124069, 4501, 332, 11, 70, "Input",
 CellID->1079027757],
Cell[124404, 4514, 405, 11, 70, "Output",
 Evaluatable->False,
 CellID->15762172]
}, Open  ]],
Cell[124824, 4528, 125, 3, 70, "ExampleDelimiter",
 CellID->360347385],
Cell[124952, 4533, 96, 1, 70, "ExampleText",
 CellID->522826630],
Cell[CellGroupData[{
Cell[125073, 4538, 432, 14, 70, "Input",
 CellID->109283512],
Cell[125508, 4554, 433, 13, 56, "Output",
 CellID->8983135]
}, Open  ]],
Cell[CellGroupData[{
Cell[125978, 4572, 432, 14, 70, "Input",
 CellID->460970803],
Cell[126413, 4588, 435, 13, 56, "Output",
 CellID->527005051]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[126909, 4608, 227, 7, 70, "ExampleSection",
 CellID->107368884],
Cell[127139, 4617, 74, 1, 70, "ExampleText",
 CellID->284132205],
Cell[CellGroupData[{
Cell[127238, 4622, 742, 22, 70, "Input",
 CellID->379251825],
Cell[127983, 4646, 667, 23, 70, "Output",
 CellID->644894823]
}, Open  ]],
Cell[128665, 4672, 125, 3, 70, "ExampleDelimiter",
 CellID->885696333],
Cell[128793, 4677, 68, 1, 70, "ExampleText",
 CellID->1536283714],
Cell[128864, 4680, 537, 15, 70, "Input",
 CellID->409364949],
Cell[CellGroupData[{
Cell[129426, 4699, 2212, 63, 70, "Input",
 CellID->1897771943],
Cell[131641, 4764, 1823, 34, 70, "Output",
 Evaluatable->False,
 CellID->888565341]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[133513, 4804, 230, 7, 70, "ExampleSection",
 CellID->497586619],
Cell[133746, 4813, 142, 4, 70, "ExampleText",
 CellID->58931023],
Cell[CellGroupData[{
Cell[133913, 4821, 489, 16, 70, "Input",
 CellID->325575155],
Cell[134405, 4839, 338, 12, 54, "Output",
 CellID->238842678]
}, Open  ]],
Cell[134758, 4854, 224, 7, 70, "ExampleText",
 CellID->463742294],
Cell[CellGroupData[{
Cell[135007, 4865, 502, 16, 70, "Input",
 CellID->898580295],
Cell[135512, 4883, 362, 13, 54, "Output",
 CellID->396582264]
}, Open  ]],
Cell[135889, 4899, 125, 3, 70, "ExampleDelimiter",
 CellID->453750008],
Cell[136017, 4904, 257, 8, 70, "ExampleText",
 CellID->1862285898],
Cell[CellGroupData[{
Cell[136299, 4916, 376, 11, 70, "Input",
 CellID->2012416308],
Cell[136678, 4929, 296, 11, 62, "Output",
 CellID->529147552]
}, Open  ]],
Cell[CellGroupData[{
Cell[137011, 4945, 375, 11, 70, "Input",
 CellID->2099287209],
Cell[137389, 4958, 295, 11, 64, "Output",
 CellID->295666041]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[137733, 4975, 227, 7, 70, "ExampleSection",
 CellID->19097116],
Cell[137963, 4984, 60, 1, 70, "ExampleText",
 CellID->1176950388],
Cell[CellGroupData[{
Cell[138048, 4989, 2277, 61, 70, "Input",
 CellID->695667300],
Cell[140328, 5052, 383, 10, 70, "Output",
 Evaluatable->False,
 CellID->688271048]
}, Open  ]],
Cell[140726, 5065, 125, 3, 70, "ExampleDelimiter",
 CellID->764730928],
Cell[140854, 5070, 58, 1, 70, "ExampleText",
 CellID->1936596363],
Cell[CellGroupData[{
Cell[140937, 5075, 1866, 52, 70, "Input",
 CellID->134882431],
Cell[142806, 5129, 961, 20, 70, "Output",
 Evaluatable->False,
 CellID->120437624]
}, Open  ]],
Cell[143782, 5152, 123, 3, 70, "ExampleDelimiter",
 CellID->6013013],
Cell[143908, 5157, 102, 2, 70, "ExampleText",
 CellID->368695436],
Cell[CellGroupData[{
Cell[144035, 5163, 715, 20, 70, "Input",
 CellID->330630511],
Cell[144753, 5185, 10399, 175, 70, "Output",
 Evaluatable->False,
 CellID->34280393]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[155213, 5367, 310, 9, 70, "SeeAlsoSection",
 CellID->5760],
Cell[155526, 5378, 1922, 71, 70, "SeeAlso",
 CellID->99]
}, Open  ]],
Cell[CellGroupData[{
Cell[157485, 5454, 314, 9, 70, "TutorialsSection",
 CellID->22002],
Cell[157802, 5465, 147, 3, 70, "Tutorials",
 CellID->22605],
Cell[157952, 5470, 303, 9, 70, "Tutorials",
 CellID->542584750],
Cell[158258, 5481, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[158441, 5489, 305, 8, 70, "RelatedLinksSection"],
Cell[158749, 5499, 348, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159134, 5515, 319, 9, 70, "MoreAboutSection",
 CellID->195765519],
Cell[159456, 5526, 149, 3, 70, "MoreAbout",
 CellID->103126181],
Cell[159608, 5531, 140, 3, 70, "MoreAbout",
 CellID->462567555],
Cell[159751, 5536, 154, 3, 70, "MoreAbout",
 CellID->16601858],
Cell[159908, 5541, 142, 3, 70, "MoreAbout",
 CellID->394536297],
Cell[160053, 5546, 157, 3, 70, "MoreAbout",
 CellID->7474533],
Cell[160213, 5551, 168, 3, 70, "MoreAbout",
 CellID->35880941],
Cell[160384, 5556, 126, 3, 70, "MoreAbout",
 CellID->1448324],
Cell[160513, 5561, 152, 3, 70, "MoreAbout",
 CellID->3088493],
Cell[160668, 5566, 179, 3, 70, "MoreAbout",
 CellID->17280838],
Cell[160850, 5571, 171, 3, 70, "MoreAbout",
 CellID->258972108],
Cell[161024, 5576, 172, 3, 70, "MoreAbout",
 CellID->83660851]
}, Open  ]],
Cell[161211, 5582, 27, 0, 70, "History"],
Cell[161241, 5584, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

