(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    131342,       4643]
NotebookOptionsPosition[    111723,       3963]
NotebookOutlinePosition[    113833,       4012]
CellTagsIndexPosition[    113746,       4007]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicOperationsOnPolynomials"], 
          "Polynomials Modulo Primes" :> 
          Documentation`HelpLookup["paclet:tutorial/PolynomialsModuloPrimes"],
           "Complex Polynomial Systems" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ComplexPolynomialSystems"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Algebraic Operations on Polynomials\"\>", 
       2->"\<\"Polynomials Modulo Primes\"\>", 
       3->"\<\"Complex Polynomial Systems\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolynomialReduce" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialReduce"], 
          "PolynomialGCD" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialGCD"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], "Solve" :> 
          Documentation`HelpLookup["paclet:ref/Solve"], "RowReduce" :> 
          Documentation`HelpLookup["paclet:ref/RowReduce"], "Eliminate" :> 
          Documentation`HelpLookup["paclet:ref/Eliminate"], "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], 
          "CylindricalDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/CylindricalDecomposition"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"PolynomialReduce\"\>", 
       2->"\<\"PolynomialGCD\"\>", 3->"\<\"Reduce\"\>", 4->"\<\"Solve\"\>", 
       5->"\<\"RowReduce\"\>", 6->"\<\"Eliminate\"\>", 
       7->"\<\"FindInstance\"\>", 
       8->"\<\"CylindricalDecomposition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Division" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialDivision"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Computational Geometry\"\>", 
       2->"\<\"Polynomial Algebra\"\>", 3->"\<\"Polynomial Division\"\>", 
       4->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GroebnerBasis", "ObjectName",
 CellID->23486],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GroebnerBasis",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GroebnerBasis"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["poly", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["poly", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of polynomials that form a \
Gr\[ODoubleDot]bner basis for the set of polynomials ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GroebnerBasis",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GroebnerBasis"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["poly", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["poly", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds a Gr\[ODoubleDot]bner basis in which the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " have been eliminated. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->6602]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The set of polynomials in a Gr\[ODoubleDot]bner basis have the same \
collection of roots as the original polynomials. \
\>", "Notes",
 CellID->7737],

Cell[TextData[{
 "For polynomials in one variable, ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " reduces to ",
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28901],

Cell[TextData[{
 "For linear functions in any number of variables, ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " is equivalent to Gaussian elimination. "
}], "Notes",
 CellID->17901],

Cell[TextData[{
 "The Gr\[ODoubleDot]bner basis in general depends on the ordering assigned \
to monomials. This ordering is affected by the ordering of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22749],

Cell["The following options can be given: ", "Notes",
 CellID->15967],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "MonomialOrder", "Lexicographic", Cell[
    "the criterion used for ordering monomials ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "CoefficientDomain", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the type of objects assumed to be coefficients ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Modulus",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Modulus"], "0", Cell[
    "the modulus for numerical coefficients ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->30102],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData["MonomialOrder"], "InlineFormula"],
 " are ",
 Cell[BoxData["Lexicographic"], "InlineFormula"],
 ", ",
 Cell[BoxData["DegreeLexicograpic"], "InlineFormula"],
 ", ",
 Cell[BoxData["DegreeReverseLexicographic"], "InlineFormula"],
 " or an explicit weight matrix. Monomials are specified for the purpose of \
",
 Cell[BoxData["MonomialOrder"], "InlineFormula"],
 " by lists of the exponents with which the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " appear in them. "
}], "Notes",
 CellID->4265],

Cell[TextData[{
 "The ordering of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " and the setting for ",
 Cell[BoxData["MonomialOrder"], "InlineFormula"],
 " can substantially affect the efficiency of ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21881],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData["CoefficientDomain"], "InlineFormula"],
 " are ",
 Cell[BoxData["InexactNumbers"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Rationals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationals"]], "InlineFormula"],
 ", ",
 Cell[BoxData["RationalFunctions"], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"Polynomials", "[", "x", "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31843]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->216578803],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->12985428],

Cell["Compute a Gr\[ODoubleDot]bner basis:", "ExampleText",
 CellID->56458547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"2", 
       RowBox[{"y", "^", "2"}]}]}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->606806550],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "9"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["y", "4"]}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["y", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{132, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122712727]
}, Open  ]],

Cell["Prove that polynomials have no common roots:", "ExampleText",
 CellID->591388311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "^", "2"}], "-", 
      RowBox[{"2", "x"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->414238400],

Cell[BoxData[
 RowBox[{"{", "1", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36547538]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24972],

Cell["Polynomials with a finite number of common roots:", "ExampleText",
 CellID->262454330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "-", "z", "+", "2"}], ",", 
     RowBox[{
      RowBox[{"z", "^", "2"}], "-", 
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237488057],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1024", "-", 
    RowBox[{"832", " ", "z"}], "-", 
    RowBox[{"215", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"156", " ", 
     SuperscriptBox["z", "3"]}], "-", 
    RowBox[{"25", " ", 
     SuperscriptBox["z", "4"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["z", "5"]}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["z", "6"]}], "+", 
    SuperscriptBox["z", "8"]}], ",", 
   RowBox[{
    RowBox[{"-", "11552"}], "+", 
    RowBox[{"2560", " ", "y"}], "+", 
    RowBox[{"2197", " ", "z"}], "+", 
    RowBox[{"2764", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"443", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    RowBox[{"728", " ", 
     SuperscriptBox["z", "4"]}], "+", 
    RowBox[{"169", " ", 
     SuperscriptBox["z", "5"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["z", "6"]}], "+", 
    RowBox[{"13", " ", 
     SuperscriptBox["z", "7"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "34656"}], "+", 
    RowBox[{"5120", " ", "x"}], "+", 
    RowBox[{"6591", " ", "z"}], "+", 
    RowBox[{"5732", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"1329", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    RowBox[{"2184", " ", 
     SuperscriptBox["z", "4"]}], "+", 
    RowBox[{"507", " ", 
     SuperscriptBox["z", "5"]}], "+", 
    RowBox[{"96", " ", 
     SuperscriptBox["z", "6"]}], "+", 
    RowBox[{"39", " ", 
     SuperscriptBox["z", "7"]}]}]}], "}"}]], "Output",
 ImageSize->{466, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40331394]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172111596],

Cell["Polynomials with an infinite number of common roots:", "ExampleText",
 CellID->124207719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "-", "z", "+", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176467047],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4", "-", 
    SuperscriptBox["y", "2"], "+", 
    SuperscriptBox["y", "4"], "-", 
    RowBox[{"4", " ", "z"}], "+", 
    SuperscriptBox["z", "2"], "+", 
    RowBox[{
     SuperscriptBox["y", "2"], " ", 
     SuperscriptBox["z", "2"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "x"}], "-", "y", "+", 
    SuperscriptBox["y", "3"], "+", 
    RowBox[{"x", " ", "z"}], "+", 
    RowBox[{"y", " ", 
     SuperscriptBox["z", "2"]}]}], ",", 
   RowBox[{"2", "+", 
    RowBox[{"x", " ", "y"}], "-", "z"}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"], "+", 
    SuperscriptBox["z", "2"]}]}], "}"}]], "Output",
 ImageSize->{485, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156497398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->265229691],

Cell["Polynomials with no common roots:", "ExampleText",
 CellID->170843201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "-", "z", "+", "2"}], ",", 
     RowBox[{
      RowBox[{"z", "^", "2"}], "-", "3", "+", "x"}], ",", 
     RowBox[{"x", "-", 
      RowBox[{"y", "^", "2"}], "+", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->769898039],

Cell[BoxData[
 RowBox[{"{", "1", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->330359718]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->507975113],

Cell["Eliminate a variable:", "ExampleText",
 CellID->701267881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "-", "z", "+", "2"}], ",", 
     RowBox[{
      RowBox[{"z", "^", "2"}], "-", 
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", "z", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62997475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"28", "+", 
    RowBox[{"8", " ", "y"}], "+", 
    RowBox[{"41", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"26", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"55", " ", 
     SuperscriptBox["y", "4"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["y", "5"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["y", "6"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["y", "7"]}], "+", 
    SuperscriptBox["y", "8"]}], ",", 
   RowBox[{"16", "+", 
    RowBox[{"20", " ", "x"}], "-", 
    RowBox[{"10", " ", "y"}], "+", 
    RowBox[{"28", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"57", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["y", "4"]}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["y", "5"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["y", "6"]}], "-", 
    SuperscriptBox["y", "7"]}]}], "}"}]], "Output",
 ImageSize->{320, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83999410]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16644745],

Cell["A lexicographic Gr\[ODoubleDot]bner basis:", "ExampleText",
 CellID->78842765],

Cell[BoxData[
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}], "-", "1"}], ",", 
     RowBox[{"x", "-", "z", "+", "2"}], ",", 
     RowBox[{
      RowBox[{"z", "^", "2"}], "-", 
      RowBox[{"x", " ", "y"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->256542059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->428210104],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"12", "-", 
    RowBox[{"28", " ", "z"}], "+", 
    RowBox[{"27", " ", 
     SuperscriptBox["z", "2"]}], "-", 
    RowBox[{"12", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["z", "4"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "6"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"11", " ", "z"}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["z", "3"]}]}], ",", 
   RowBox[{"2", "+", "x", "-", "z"}]}], "}"}]], "Output",
 ImageSize->{408, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75516963]
}, Open  ]],

Cell["\<\
A degree reverse lexicographic Gr\[ODoubleDot]bner basis:\
\>", "ExampleText",
 CellID->188532408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"MonomialOrder", "\[Rule]", "DegreeReverseLexicographic"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->834785145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", "x", "-", "z"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "y"}], "+", 
    RowBox[{"y", " ", "z"}], "-", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{"3", "+", 
    SuperscriptBox["y", "2"], "-", 
    RowBox[{"4", " ", "z"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "2"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "6"}], "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"11", " ", "z"}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["z", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{426, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->4312358]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10518],

Cell["Polynomial equations can be given instead of polynomials:", \
"ExampleText",
 CellID->55897220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"2", 
        RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "==", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459511598],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "9"}], "+", 
    SuperscriptBox["y", "2"], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["y", "4"]}]}], ",", 
   RowBox[{
    RowBox[{"3", " ", "x"}], "-", "y", "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["y", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{176, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227229332]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2073],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "CoefficientDomain",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->32353],

Cell["\<\
By default, Gr\[ODoubleDot]bner bases are computed over the field of rational \
numbers:\
\>", "ExampleText",
 CellID->140771690],

Cell[BoxData[
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"5", "x"}], "-", "1"}], ",", " ", 
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", " ", "x", " ", "y"}], "+", 
      RowBox[{"y", "^", "2"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->781521911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->504844187],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "4"}], "-", 
    RowBox[{"12", " ", "y"}], "-", 
    RowBox[{"19", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"15", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["y", "4"]}]}], ",", 
   RowBox[{"18", "+", 
    RowBox[{"4", " ", "a", " ", "x"}], "+", 
    RowBox[{"27", " ", "y"}], "+", 
    RowBox[{"45", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["y", "3"]}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", " ", "x", " ", "y"}], "+", 
    SuperscriptBox["y", "2"]}]}], "}"}]], "Output",
 ImageSize->{516, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->118606756]
}, Open  ]],

Cell["\<\
This computes the strong Gr\[ODoubleDot]bner basis over the ring of integers:\
\
\>", "ExampleText",
 CellID->212195333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"CoefficientDomain", "\[Rule]", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->321174485],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "4"}], "-", 
    RowBox[{"12", " ", "y"}], "-", 
    RowBox[{"19", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"15", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["y", "4"]}]}], ",", 
   RowBox[{"18", "+", 
    RowBox[{"4", " ", "a", " ", "x"}], "+", 
    RowBox[{"27", " ", "y"}], "+", 
    RowBox[{"45", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"2", " ", "a", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["y", "3"]}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", " ", "x", " ", "y"}], "+", 
    SuperscriptBox["y", "2"]}], ",", 
   RowBox[{"6", "+", 
    RowBox[{"2", " ", "a", " ", "x"}], "+", 
    RowBox[{"9", " ", "y"}], "+", 
    RowBox[{"a", " ", "x", " ", "y"}], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"a", " ", 
     SuperscriptBox["y", "3"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["x", "2"]}]}]}], "}"}]], "Output",
 ImageSize->{430, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->510572875]
}, Open  ]],

Cell[TextData[{
 "This computes the ",
 "Gr\[ODoubleDot]bner",
 " basis over the field of rational functions \[DoubleStruckCapitalQ](",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 "):"
}], "ExampleText",
 CellID->323323715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"CoefficientDomain", "\[Rule]", "RationalFunctions"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->122481891],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "4"}], "-", 
    RowBox[{"12", " ", "y"}], "-", 
    RowBox[{"19", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"15", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"a", " ", 
     SuperscriptBox["y", "4"]}]}], ",", 
   RowBox[{"18", "+", 
    RowBox[{"4", " ", "a", " ", "x"}], "+", 
    RowBox[{"27", " ", "y"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"45", "+", 
       RowBox[{"2", " ", "a"}]}], ")"}], " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"3", " ", "a", " ", 
     SuperscriptBox["y", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{421, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->7148844]
}, Open  ]],

Cell["This uses approximate arithmetic:", "ExampleText",
 CellID->12585303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"CoefficientDomain", "\[Rule]", 
    RowBox[{"InexactNumbers", "[", "20", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->643851330],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "4.00000000000000000000000000004`17.978810700930065"}], "-", 
    
    RowBox[{"12.00000000000000000000000000004`18.026872146400304", " ", "y"}],
     "-", 
    RowBox[{"19.00000000000000000000000000009`18.017015053600293", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"15.00000000000000000000000000004`18.065501548756433", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"1.`18.07572071393812", " ", "a", " ", 
     SuperscriptBox["y", "4"]}]}], ",", 
   RowBox[{"4.5`18.42021640338319", "+", 
    RowBox[{"1.`18.356547323513816", " ", "a", " ", "x"}], "+", 
    RowBox[{"6.75`18.42021640338319", " ", "y"}], "+", 
    RowBox[{"11.25000000000000000000000000003`18.387216143280266", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"0.5`18.366531544420415", " ", "a", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"0.75`18.4089353929735", " ", "a", " ", 
     SuperscriptBox["y", "3"]}]}], ",", 
   RowBox[{
    RowBox[{"0.66666666666666666666666666667`19.096910013008056", " ", "x"}], 
    "+", 
    RowBox[{"1.`19.096910013008056", " ", "x", " ", "y"}], "+", 
    RowBox[{
    "0.33333333333333333333333333333333333333`19.154901959985743", " ", 
     SuperscriptBox["y", "2"]}]}]}], "}"}]], "Output",
 ImageSize->{537, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->7378832]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1281],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " method setting uses a Gr\[ODoubleDot]bner walk for lexicographic bases \
over the rationals:"
}], "ExampleText",
 CellID->47717632],

Cell[BoxData[
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", " ", 
       RowBox[{"y", "^", "4"}]}], "+", 
      RowBox[{"y", " ", 
       RowBox[{"z", "^", "4"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"x", "^", "2"}], "y"}], "-", "3"}], ",", 
     RowBox[{
      RowBox[{"y", "^", "4"}], "+", 
      RowBox[{"x", " ", 
       RowBox[{"y", "^", "2"}], "z"}], "+", 
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"2", "x", " ", "y"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"x", "^", "3"}]}], 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"x", " ", "y", " ", 
       RowBox[{"z", "^", "3"}]}], "+", 
      RowBox[{"y", "^", "4"}], "+", 
      RowBox[{"x", " ", 
       RowBox[{"y", "^", "2"}], "z"}], "-", 
      RowBox[{"2", "x", " ", "y"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184997293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GroebnerBasis", "[", 
    RowBox[{"polys", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], ";"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->121728834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.406`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20540199]
}, Open  ]],

Cell[TextData[{
 "In this case the ",
 Cell[BoxData["\"\<Buchberger\>\""], "InlineFormula"],
 " method is much slower than ",
 Cell[BoxData["\"\<GroebnerWalk\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->190823980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TimeConstrained", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"GroebnerBasis", "[", 
     RowBox[{"polys", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"Method", "\[Rule]", "\"\<Buchberger\>\""}]}], "]"}], ";"}], 
   ",", "60"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->445478091],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->312233367]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->670242391],

Cell["\<\
These polynomials are \"close\" to the lexicographic Gr\[ODoubleDot]bner \
basis:\
\>", "ExampleText",
 CellID->650508321],

Cell[BoxData[
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"z", "^", "19"}], "-", 
      RowBox[{"53", 
       RowBox[{"z", "^", "7"}]}], "+", 
      RowBox[{"11", 
       RowBox[{"z", "^", "5"}]}], "-", 
      RowBox[{"21", "z"}], "+", "17"}], ",", 
     RowBox[{"x", "-", 
      RowBox[{"z", "^", "50"}]}], ",", 
     RowBox[{"y", "-", 
      RowBox[{"2", 
       RowBox[{"z", "^", "47"}]}], "-", 
      RowBox[{"3", 
       RowBox[{"z", "^", "21"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14194304],

Cell["\<\
A Gr\[ODoubleDot]bner walk computes the degree reverse lexicographic basis \
first:\
\>", "ExampleText",
 CellID->18095096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"polys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
    RowBox[{"Method", "\[Rule]", "\"\<GroebnerWalk\>\""}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->259439312],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.8899999999999998`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"17", "-", 
      RowBox[{"21", " ", "z"}], "+", 
      RowBox[{"11", " ", 
       SuperscriptBox["z", "5"]}], "-", 
      RowBox[{"53", " ", 
       SuperscriptBox["z", "7"]}], "+", 
      SuperscriptBox["z", "19"]}], ",", 
     RowBox[{"4114", "+", "y", "-", 
      RowBox[{"5082", " ", "z"}], "-", 
      RowBox[{"39593", " ", 
       SuperscriptBox["z", "2"]}], "+", 
      RowBox[{"48909", " ", 
       SuperscriptBox["z", "3"]}], "+", 
      RowBox[{"95506", " ", 
       SuperscriptBox["z", "4"]}], "-", 
      RowBox[{"115316", " ", 
       SuperscriptBox["z", "5"]}], "-", 
      RowBox[{"38445", " ", 
       SuperscriptBox["z", "7"]}], "+", 
      RowBox[{"184657", " ", 
       SuperscriptBox["z", "9"]}], "+", 
      RowBox[{"1428", " ", 
       SuperscriptBox["z", "10"]}], "-", 
      RowBox[{"298636", " ", 
       SuperscriptBox["z", "11"]}], "-", 
      RowBox[{"748", " ", 
       SuperscriptBox["z", "14"]}], "+", 
      RowBox[{"924", " ", 
       SuperscriptBox["z", "15"]}], "+", 
      RowBox[{"3604", " ", 
       SuperscriptBox["z", "16"]}], "-", 
      RowBox[{"4452", " ", 
       SuperscriptBox["z", "17"]}]}], ",", 
     RowBox[{
      RowBox[{"-", "30634"}], "+", "x", "+", 
      RowBox[{"75684", " ", "z"}], "-", 
      RowBox[{"46746", " ", 
       SuperscriptBox["z", "2"]}], "+", 
      RowBox[{"2057", " ", 
       SuperscriptBox["z", "3"]}], "-", 
      RowBox[{"2541", " ", 
       SuperscriptBox["z", "4"]}], "-", 
      RowBox[{"39644", " ", 
       SuperscriptBox["z", "5"]}], "+", 
      RowBox[{"48972", " ", 
       SuperscriptBox["z", "6"]}], "+", 
      RowBox[{"143259", " ", 
       SuperscriptBox["z", "7"]}], "-", 
      RowBox[{"175636", " ", 
       SuperscriptBox["z", "8"]}], "-", 
      RowBox[{"19239", " ", 
       SuperscriptBox["z", "10"]}], "+", 
      RowBox[{"92408", " ", 
       SuperscriptBox["z", "12"]}], "+", 
      RowBox[{"714", " ", 
       SuperscriptBox["z", "13"]}], "-", 
      RowBox[{"149318", " ", 
       SuperscriptBox["z", "14"]}], "-", 
      RowBox[{"374", " ", 
       SuperscriptBox["z", "17"]}], "+", 
      RowBox[{"462", " ", 
       SuperscriptBox["z", "18"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{571, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->157811860]
}, Open  ]],

Cell[TextData[{
 "Computing the lexicographic basis directly with the ",
 Cell[BoxData["\"\<Buchberger\>\""], "InlineFormula"],
 " method is faster here:"
}], "ExampleText",
 CellID->293946071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"polys", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
    RowBox[{"Method", "\[Rule]", "\"\<Buchberger\>\""}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->129489894],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.015999999999999764`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"17", "-", 
      RowBox[{"21", " ", "z"}], "+", 
      RowBox[{"11", " ", 
       SuperscriptBox["z", "5"]}], "-", 
      RowBox[{"53", " ", 
       SuperscriptBox["z", "7"]}], "+", 
      SuperscriptBox["z", "19"]}], ",", 
     RowBox[{"4114", "+", "y", "-", 
      RowBox[{"5082", " ", "z"}], "-", 
      RowBox[{"39593", " ", 
       SuperscriptBox["z", "2"]}], "+", 
      RowBox[{"48909", " ", 
       SuperscriptBox["z", "3"]}], "+", 
      RowBox[{"95506", " ", 
       SuperscriptBox["z", "4"]}], "-", 
      RowBox[{"115316", " ", 
       SuperscriptBox["z", "5"]}], "-", 
      RowBox[{"38445", " ", 
       SuperscriptBox["z", "7"]}], "+", 
      RowBox[{"184657", " ", 
       SuperscriptBox["z", "9"]}], "+", 
      RowBox[{"1428", " ", 
       SuperscriptBox["z", "10"]}], "-", 
      RowBox[{"298636", " ", 
       SuperscriptBox["z", "11"]}], "-", 
      RowBox[{"748", " ", 
       SuperscriptBox["z", "14"]}], "+", 
      RowBox[{"924", " ", 
       SuperscriptBox["z", "15"]}], "+", 
      RowBox[{"3604", " ", 
       SuperscriptBox["z", "16"]}], "-", 
      RowBox[{"4452", " ", 
       SuperscriptBox["z", "17"]}]}], ",", 
     RowBox[{
      RowBox[{"-", "30634"}], "+", "x", "+", 
      RowBox[{"75684", " ", "z"}], "-", 
      RowBox[{"46746", " ", 
       SuperscriptBox["z", "2"]}], "+", 
      RowBox[{"2057", " ", 
       SuperscriptBox["z", "3"]}], "-", 
      RowBox[{"2541", " ", 
       SuperscriptBox["z", "4"]}], "-", 
      RowBox[{"39644", " ", 
       SuperscriptBox["z", "5"]}], "+", 
      RowBox[{"48972", " ", 
       SuperscriptBox["z", "6"]}], "+", 
      RowBox[{"143259", " ", 
       SuperscriptBox["z", "7"]}], "-", 
      RowBox[{"175636", " ", 
       SuperscriptBox["z", "8"]}], "-", 
      RowBox[{"19239", " ", 
       SuperscriptBox["z", "10"]}], "+", 
      RowBox[{"92408", " ", 
       SuperscriptBox["z", "12"]}], "+", 
      RowBox[{"714", " ", 
       SuperscriptBox["z", "13"]}], "-", 
      RowBox[{"149318", " ", 
       SuperscriptBox["z", "14"]}], "-", 
      RowBox[{"374", " ", 
       SuperscriptBox["z", "17"]}], "+", 
      RowBox[{"462", " ", 
       SuperscriptBox["z", "18"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{571, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->520319028]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->2662],

Cell["\<\
This computes the Gr\[ODoubleDot]bner basis over the field of integers modulo \
7:\
\>", "ExampleText",
 CellID->524491605],

Cell[BoxData[
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"y", " ", "z"}], "-", 
      RowBox[{"5", "x"}], "-", "1"}], ",", " ", 
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", " ", "x", " ", "y"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"x", "-", 
      RowBox[{"3", "y"}], "+", 
      RowBox[{"x", " ", "z"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"z", "^", "2"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1611282390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "7"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50891778],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"6", "+", 
    RowBox[{"6", " ", "z"}], "+", 
    SuperscriptBox["z", "2"], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["z", "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["z", "5"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["z", "6"]}], "+", 
    SuperscriptBox["z", "7"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"4", " ", "y"}], "+", 
    RowBox[{"4", " ", "z"}], "+", 
    RowBox[{"y", " ", "z"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    SuperscriptBox["z", "4"], "+", 
    SuperscriptBox["z", "6"]}], ",", 
   RowBox[{"1", "+", 
    RowBox[{"3", " ", "y"}], "+", 
    SuperscriptBox["y", "2"], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["z", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["z", "5"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["z", "6"]}]}], ",", 
   RowBox[{"1", "+", "x", "+", "y", "+", 
    RowBox[{"3", " ", "z"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["z", "4"]}], "+", 
    SuperscriptBox["z", "5"]}]}], "}"}]], "Output",
 ImageSize->{473, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30060183]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MonomialOrder",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->27996],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["Lexicographic"], "InlineFormula"],
 " monomial order:"
}], "ExampleText",
 CellID->230562455],

Cell[BoxData[
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"y", " ", "z"}], "-", "x", "-", "1"}], ",", " ", 
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", " ", "x", " ", "y"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"x", "-", 
      RowBox[{"3", "y"}], "+", 
      RowBox[{"x", " ", "z"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"z", "^", "2"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1396156391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12450228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1540", "+", 
    RowBox[{"82", " ", "z"}], "-", 
    RowBox[{"3491", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"676", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    RowBox[{"1807", " ", 
     SuperscriptBox["z", "4"]}], "-", 
    RowBox[{"1768", " ", 
     SuperscriptBox["z", "5"]}], "+", 
    RowBox[{"310", " ", 
     SuperscriptBox["z", "6"]}], "+", 
    RowBox[{"1296", " ", 
     SuperscriptBox["z", "7"]}], "+", 
    RowBox[{"520", " ", 
     SuperscriptBox["z", "8"]}]}], ",", 
   RowBox[{"16801600618344", "+", 
    RowBox[{"60608534091110", " ", "y"}], "+", 
    RowBox[{"19757744527703", " ", "z"}], "+", 
    RowBox[{"21523317746112", " ", 
     SuperscriptBox["z", "2"]}], "-", 
    RowBox[{"16946787439081", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    RowBox[{"4872263781864", " ", 
     SuperscriptBox["z", "4"]}], "-", 
    RowBox[{"16795641902050", " ", 
     SuperscriptBox["z", "5"]}], "-", 
    RowBox[{"17077664603568", " ", 
     SuperscriptBox["z", "6"]}], "-", 
    RowBox[{"5202247795160", " ", 
     SuperscriptBox["z", "7"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "12397969782796"}], "+", 
    RowBox[{"121217068182220", " ", "x"}], "+", 
    RowBox[{"124916501217576", " ", "z"}], "+", 
    RowBox[{"18417605948925", " ", 
     SuperscriptBox["z", "2"]}], "-", 
    RowBox[{"169792044662095", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    RowBox[{"66190507027566", " ", 
     SuperscriptBox["z", "4"]}], "-", 
    RowBox[{"36996183157154", " ", 
     SuperscriptBox["z", "5"]}], "-", 
    RowBox[{"88258341985544", " ", 
     SuperscriptBox["z", "6"]}], "-", 
    RowBox[{"38225933906680", " ", 
     SuperscriptBox["z", "7"]}]}]}], "}"}]], "Output",
 ImageSize->{455, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->47594140]
}, Open  ]],

Cell[TextData[{
 "This gives the Gr\[ODoubleDot]bner basis in the ",
 Cell[BoxData["DegreeReverseLexicographic"], "InlineFormula"],
 " monomial order:"
}], "ExampleText",
 CellID->16229979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"MonomialOrder", "\[Rule]", "DegreeReverseLexicographic"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->99183662],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "-", 
    RowBox[{"3", " ", "y"}], "+", 
    RowBox[{"x", " ", "z"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "2"]}]}], ",", 
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", " ", "x", " ", "y"}], "+", 
    SuperscriptBox["y", "2"]}], ",", 
   RowBox[{"1", "+", "x", "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"y", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"27", " ", "y"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["y", "2"]}], "-", "z", "-", 
    RowBox[{"29", " ", "y", " ", "z"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"y", " ", 
     SuperscriptBox["z", "2"]}], "-", 
    RowBox[{"20", " ", 
     SuperscriptBox["z", "3"]}]}], ",", 
   RowBox[{"6", "-", 
    RowBox[{"156", " ", "y"}], "-", 
    RowBox[{"20", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"6", " ", "z"}], "+", 
    RowBox[{"174", " ", "y", " ", "z"}], "+", 
    RowBox[{
     SuperscriptBox["y", "2"], " ", "z"}], "-", 
    RowBox[{"104", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"120", " ", 
     SuperscriptBox["z", "3"]}]}], ",", 
   RowBox[{"180", "-", 
    RowBox[{"20", " ", "x"}], "-", 
    RowBox[{"4185", " ", "y"}], "-", 
    RowBox[{"559", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"15", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"162", " ", "z"}], "+", 
    RowBox[{"4680", " ", "y", " ", "z"}], "-", 
    RowBox[{"2808", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"3240", " ", 
     SuperscriptBox["z", "3"]}]}], ",", 
   RowBox[{"4026", "-", 
    RowBox[{"20", " ", "x"}], "-", 
    RowBox[{"106386", " ", "y"}], "-", 
    RowBox[{"17140", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"4086", " ", "z"}], "+", 
    RowBox[{"114129", " ", "y", " ", "z"}], "-", 
    RowBox[{"70866", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"78768", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    RowBox[{"1560", " ", 
     SuperscriptBox["z", "4"]}]}]}], "}"}]], "Output",
 ImageSize->{529, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->518292244]
}, Open  ]],

Cell["\<\
A monomial order may be specified by giving a full rank square rational \
weight matrix:\
\>", "ExampleText",
 CellID->118288737],

Cell[BoxData[
 RowBox[{
  RowBox[{"wmat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"-", "3"}], ",", "2"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->26342085],

Cell["\<\
For the order to be well-founded the first nonzero entry in each column must \
be positive:\
\>", "ExampleText",
 CellID->79259332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"MonomialOrder", "\[Rule]", "wmat"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->7734005],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "21"}], " ", "x"}], "-", 
    RowBox[{"13", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"15", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"6", " ", "z"}], "+", 
    RowBox[{"6", " ", "x", " ", "z"}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["x", "2"], " ", "z"}], "+", 
    RowBox[{"20", " ", "x", " ", 
     SuperscriptBox["z", "2"]}]}], ",", 
   RowBox[{"60", "+", 
    RowBox[{"39", " ", "x"}], "+", 
    RowBox[{"287", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"15", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"6", " ", "z"}], "-", 
    RowBox[{"14", " ", "x", " ", "z"}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["x", "2"], " ", "z"}], "+", 
    RowBox[{"40", " ", 
     SuperscriptBox["z", "3"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "x"}], "+", 
    RowBox[{"3", " ", "y"}], "-", 
    RowBox[{"x", " ", "z"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["z", "2"]}]}], ",", 
   RowBox[{"10", "-", 
    RowBox[{"38", " ", "x"}], "+", 
    RowBox[{"141", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"305", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"325", " ", 
     SuperscriptBox["x", "4"]}], "-", 
    RowBox[{"12", " ", "z"}], "-", 
    RowBox[{"82", " ", "x", " ", "z"}], "-", 
    RowBox[{"50", " ", 
     SuperscriptBox["x", "2"], " ", "z"}], "+", 
    RowBox[{"20", " ", 
     SuperscriptBox["z", "2"]}]}], ",", 
   RowBox[{"30", "+", 
    RowBox[{"913", " ", "x"}], "+", 
    RowBox[{"189", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"4545", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"42", " ", "z"}], "+", 
    RowBox[{"1132", " ", "x", " ", "z"}], "+", 
    RowBox[{"630", " ", 
     SuperscriptBox["x", "2"], " ", "z"}], "+", 
    RowBox[{"1950", " ", 
     SuperscriptBox["x", "3"], " ", "z"}], "-", 
    RowBox[{"200", " ", 
     SuperscriptBox["z", "2"]}]}]}], "}"}]], "Output",
 ImageSize->{453, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->539216826]
}, Open  ]],

Cell[TextData[{
 "Eliminate ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " and return a degree reverse lexicographic basis with respect to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", " ", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->76367951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "z", ",", 
   RowBox[{"MonomialOrder", "\[Rule]", "EliminationOrder"}]}], "]"}]], "Input",\

 CellLabel->"In[6]:=",
 CellID->20405248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", " ", "x", " ", "y"}], "+", 
    SuperscriptBox["y", "2"]}], ",", 
   RowBox[{"486", "+", 
    RowBox[{"1142", " ", "x"}], "+", 
    RowBox[{"5688", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"5670", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"12150", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"85", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"723", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"45", " ", 
     SuperscriptBox["y", "4"]}]}], ",", 
   RowBox[{"2916", "-", 
    RowBox[{"14944", " ", "x"}], "-", 
    RowBox[{"14760", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"16200", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"4374", " ", "y"}], "-", 
    RowBox[{"10388", " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"16311", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"2187", " ", 
     SuperscriptBox["y", "4"]}], "+", 
    RowBox[{"1755", " ", 
     SuperscriptBox["y", "5"]}]}]}], "}"}]], "Output",
 ImageSize->{530, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->304244821]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ParameterVariables",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28213],

Cell["\<\
Parameters are ordered lexicographically after all other variables:\
\>", "ExampleText",
 CellID->134444536],

Cell[BoxData[
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"y", " ", "z"}], "-", "x", "-", "1"}], ",", " ", 
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", " ", "x", " ", "y"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{"x", "-", 
      RowBox[{"3", "y"}], "+", 
      RowBox[{"x", " ", "z"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"z", "^", "2"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2052334303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"ParameterVariables", "\[Rule]", "x"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->265528710],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"8", " ", "x"}], "+", 
    RowBox[{"113", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"212", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"938", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"364", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    RowBox[{"1980", " ", 
     SuperscriptBox["x", "6"]}], "-", 
    RowBox[{"1000", " ", 
     SuperscriptBox["x", "7"]}], "+", 
    RowBox[{"1625", " ", 
     SuperscriptBox["x", "8"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "289274"}], "-", 
    RowBox[{"1958323", " ", "x"}], "-", 
    RowBox[{"7458871", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"14140053", " ", 
     SuperscriptBox["x", "3"]}], "-", 
    RowBox[{"20245223", " ", 
     SuperscriptBox["x", "4"]}], "-", 
    RowBox[{"19904560", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    RowBox[{"4016500", " ", 
     SuperscriptBox["x", "6"]}], "-", 
    RowBox[{"24451375", " ", 
     SuperscriptBox["x", "7"]}], "+", 
    RowBox[{"202126", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"-", "46518"}], "+", 
    RowBox[{"1236672", " ", "x"}], "+", 
    RowBox[{"1655875", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"15987939", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"2473650", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"39330525", " ", 
     SuperscriptBox["x", "5"]}], "-", 
    RowBox[{"23125875", " ", 
     SuperscriptBox["x", "6"]}], "+", 
    RowBox[{"31086250", " ", 
     SuperscriptBox["x", "7"]}], "+", 
    RowBox[{"202126", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{514, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52874315]
}, Open  ]],

Cell["This is an equivalent input:", "ExampleText",
 CellID->200020751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->329209222],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"8", " ", "x"}], "+", 
    RowBox[{"113", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"212", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"938", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"364", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    RowBox[{"1980", " ", 
     SuperscriptBox["x", "6"]}], "-", 
    RowBox[{"1000", " ", 
     SuperscriptBox["x", "7"]}], "+", 
    RowBox[{"1625", " ", 
     SuperscriptBox["x", "8"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "289274"}], "-", 
    RowBox[{"1958323", " ", "x"}], "-", 
    RowBox[{"7458871", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"14140053", " ", 
     SuperscriptBox["x", "3"]}], "-", 
    RowBox[{"20245223", " ", 
     SuperscriptBox["x", "4"]}], "-", 
    RowBox[{"19904560", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    RowBox[{"4016500", " ", 
     SuperscriptBox["x", "6"]}], "-", 
    RowBox[{"24451375", " ", 
     SuperscriptBox["x", "7"]}], "+", 
    RowBox[{"202126", " ", "z"}]}], ",", 
   RowBox[{
    RowBox[{"-", "46518"}], "+", 
    RowBox[{"1236672", " ", "x"}], "+", 
    RowBox[{"1655875", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"15987939", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"2473650", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"39330525", " ", 
     SuperscriptBox["x", "5"]}], "-", 
    RowBox[{"23125875", " ", 
     SuperscriptBox["x", "6"]}], "+", 
    RowBox[{"31086250", " ", 
     SuperscriptBox["x", "7"]}], "+", 
    RowBox[{"202126", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{514, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3120626]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sort",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29115],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " is not allowed to reorder the variables:"
}], "ExampleText",
 CellID->47486127],

Cell[BoxData[
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       RowBox[{"x", "^", "7"}]}], "+", 
      RowBox[{"5", "x", " ", "y", " ", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"10", 
       RowBox[{"y", "^", "2"}], "z"}], "-", 
      RowBox[{"6", "x", " ", "z"}], "+", 
      RowBox[{"y", "^", "3"}], "+", "w"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], 
       RowBox[{"x", "^", "2"}], " ", "z"}], "+", 
      RowBox[{"3", " ", 
       RowBox[{"x", "^", "3"}], " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"y", "^", "4"}], "-", 
      RowBox[{"12", "x", " ", "z"}], "-", 
      RowBox[{"8", "x", " ", 
       RowBox[{"z", "^", "2"}]}], "+", 
      RowBox[{"3", " ", 
       RowBox[{"y", "^", "2"}], " ", "z"}], "-", 
      RowBox[{"11", "w", " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}]}], ",", 
     RowBox[{
      RowBox[{"10", " ", 
       RowBox[{"x", "^", "2"}], "w"}], "-", 
      RowBox[{"7", "y", " ", "z", " ", 
       RowBox[{"w", "^", "2"}]}], "-", 
      RowBox[{"2", " ", "x", " ", 
       RowBox[{"z", "^", "4"}], " ", "w"}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"x", "^", "2"}], " ", "y"}], "+", 
      RowBox[{"3", " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "-", 
      RowBox[{"6", "y", " ", 
       RowBox[{"z", "^", "3"}]}], "-", "w", "+", "2"}], ",", 
     RowBox[{
      RowBox[{"w", "^", "3"}], "-", 
      RowBox[{"w", " ", 
       RowBox[{"x", "^", "2"}], " ", "y"}], "+", 
      RowBox[{"x", " ", "y", " ", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"2", " ", "w", " ", "x", " ", 
       RowBox[{"z", "^", "2"}]}], "-", 
      RowBox[{"3", "w"}], "-", 
      RowBox[{"2", " ", "x", " ", 
       RowBox[{"y", "^", "2"}]}], "-", "3"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96418146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"GroebnerBasis", "[", 
    RowBox[{"polys", ",", 
     RowBox[{"{", 
      RowBox[{"w", ",", "x", ",", "y", ",", "z"}], "}"}], ",", 
     RowBox[{"MonomialOrder", "\[Rule]", "DegreeReverseLexicographic"}]}], 
    "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->126358343],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"38.032`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->117638257]
}, Open  ]],

Cell["\<\
Reordering the variables may make computations faster; the \
Gr\[ODoubleDot]bner basis may be different: \
\>", "ExampleText",
 CellID->424764341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"GroebnerBasis", "[", 
    RowBox[{"polys", ",", 
     RowBox[{"{", 
      RowBox[{"w", ",", "x", ",", "y", ",", "z"}], "}"}], ",", 
     RowBox[{"Sort", "\[Rule]", "True"}], ",", 
     RowBox[{"MonomialOrder", "\[Rule]", "DegreeReverseLexicographic"}]}], 
    "]"}], ";"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->77053288],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20.718999999999998`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->342507262]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Tolerance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->8804],

Cell["Find an approximate GCD of a pair of univariate polynomials:", \
"ExampleText",
 CellID->57885771],

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{
    RowBox[{"x", "^", "14"}], "+", 
    RowBox[{"3.00001", 
     RowBox[{"x", "^", "10"}]}], "-", 
    RowBox[{"7.99998", 
     RowBox[{"x", "^", "7"}]}], "-", 
    RowBox[{"25.00002", 
     RowBox[{"x", "^", "6"}]}], "+", 
    RowBox[{"3.00001", 
     RowBox[{"x", "^", "13"}]}], "+", 
    RowBox[{"9.00006", 
     RowBox[{"x", "^", "9"}]}], "-", 
    RowBox[{"3.00001", 
     RowBox[{"x", "^", "5"}]}], "-", 
    RowBox[{"2.00001", 
     RowBox[{"x", "^", "8"}]}], "-", 
    RowBox[{"6.00005", 
     RowBox[{"x", "^", "4"}]}], "+", 
    RowBox[{"16.00004", "x"}], "+", "2.00001"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{
    RowBox[{"x", "^", "13"}], "-", 
    RowBox[{"3.00003", 
     RowBox[{"x", "^", "9"}]}], "-", 
    RowBox[{"2.99999", 
     RowBox[{"x", "^", "6"}]}], "+", 
    RowBox[{"2.99999", 
     RowBox[{"x", "^", "12"}]}], "-", 
    RowBox[{"9.00006", 
     RowBox[{"x", "^", "8"}]}], "-", 
    RowBox[{"8.99997", 
     RowBox[{"x", "^", "5"}]}], "-", 
    RowBox[{"1.99998", 
     RowBox[{"x", "^", "7"}]}], "+", 
    RowBox[{"5.99999", 
     RowBox[{"x", "^", "3"}]}], "+", "5.99994"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->66117012],

Cell["\<\
The polynomials are close to polynomials with integer coefficients:\
\>", "ExampleText",
 CellID->22614882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"r1", ",", "r2"}], "}"}], "=", 
  RowBox[{"Rationalize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1", ",", "p2"}], "}"}], ",", 
    RowBox[{"10", "^", 
     RowBox[{"-", "4"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->75671728],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"16", " ", "x"}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["x", "4"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "5"]}], "-", 
    RowBox[{"25", " ", 
     SuperscriptBox["x", "6"]}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "7"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "8"]}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["x", "9"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "10"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "13"]}], "+", 
    SuperscriptBox["x", "14"]}], ",", 
   RowBox[{"6", "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["x", "3"]}], "-", 
    RowBox[{"9", " ", 
     SuperscriptBox["x", "5"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "6"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "7"]}], "-", 
    RowBox[{"9", " ", 
     SuperscriptBox["x", "8"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "9"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "12"]}], "+", 
    SuperscriptBox["x", "13"]}]}], "}"}]], "Output",
 ImageSize->{390, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->291428799]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{"r1", ",", "r2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->347139695],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  SuperscriptBox["x", "6"]}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->248427012]
}, Open  ]],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tolerance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tolerance"], "->", "0"}]], "InlineFormula"],
 ", the approximate GCD has a too low degree:"
}], "ExampleText",
 CellID->166177367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], ",", "x", ",", 
   RowBox[{"CoefficientDomain", "\[Rule]", "InexactNumbers"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->398089136],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.6648618759149794`"}], "+", 
   RowBox[{"0.2210262129043201`", " ", "x"}], "-", 
   RowBox[{"0.07347709926728069`", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"0.024430608194963576`", " ", 
    SuperscriptBox["x", "3"]}], "-", 
   RowBox[{"0.00811507606219543`", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"1.`", " ", 
    SuperscriptBox["x", "5"]}]}], "}"}]], "Output",
 ImageSize->{483, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->41119146]
}, Open  ]],

Cell[TextData[{
 "With a higher setting of ",
 Cell[BoxData[
  ButtonBox["Tolerance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tolerance"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " gives a \"better\" approximate GCD:"
}], "ExampleText",
 CellID->478847683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], ",", "x", ",", 
   RowBox[{"CoefficientDomain", "\[Rule]", "InexactNumbers"}], ",", 
   RowBox[{"Tolerance", "\[Rule]", 
    RowBox[{"10", "^", 
     RowBox[{"(", 
      RowBox[{"-", "2"}], ")"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->300498882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.0001465223696937`"}], "+", 
   RowBox[{"3.0002401628321618`", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{"1.`", " ", 
    SuperscriptBox["x", "6"]}]}], "}"}]], "Output",
 ImageSize->{194, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->20717341]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19785],

Cell["Solve a system of polynomial equations:", "ExampleText",
 CellID->128193290],

Cell[BoxData[
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "^", "3"}], "-", 
      RowBox[{"2", "x", " ", "y"}], "-", "3"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79115273],

Cell["\<\
A Gr\[ODoubleDot]bner basis has the same set of roots as the input \
polynomials:\
\>", "ExampleText",
 CellID->485912894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gb", "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{"polys", ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "x"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->44511096],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"8", "+", 
    RowBox[{"4", " ", "x"}], "-", 
    SuperscriptBox["x", "2"], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    SuperscriptBox["x", "4"], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    SuperscriptBox["x", "6"]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], "-", 
    SuperscriptBox["x", "4"], "+", 
    RowBox[{"3", " ", "y"}]}]}], "}"}]], "Output",
 ImageSize->{381, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102539788]
}, Open  ]],

Cell[TextData[{
 "Solve the first polynomial of the Gr\[ODoubleDot]bner basis for its only \
variable ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->169623477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"solx", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"gb", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->90157517],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnF1uEzEQx51kkzZN27RVQf0AVJBQOQASNwD1gQvQp6hCah8QUHoQLsoZ
zDprJ87sOP7I7qbZ/CslG3vHM7Mzs4790zZfJ0/3339Mnh7uJldfHie/7h/u
/lx9/vmYd/U6QnS+CSF+n4n8s8w/TV/q7zZ/CTHK37t51yd9VGc6+nOmj33r
KMSeeu8ZLXI60m4bDXZf5ml316z5H2kf1WZFxfE4XXs269W6uvpIbSsdqtkj
/T2d157Op2kvyOj+HdK/a8vPPdFW+vlx7DzzQo8dOCX2ibV+sKTfrzjdKp5F
4KYCpRjuWPFbvUq6JV+ot1M9fTvzQmc+tLfn7qWelKQGRGrIjBowVXTo6D9l
rWQOaS4WIXKhXobqH0maJTMr7jivJ742qNdmBlY5GJqKK9VtVBXQu8Cbf+VD
X9ueRaYUCaq3z3pLJfdsyZLlyPHBkmFXEa57ZHk/excHzmguywE9P/2+K80Z
KpNdY4OMzhqpCjorpGaw/I1BJfj5wq/ZP+cHjViL5UPWctqc4v++GQVdd/T3
zZKacq0wyquDKirIvfaoPnMpV1BNvWSMXBUryxPpyrC9ljTrJ9ZCabS9vl73
PHHqlXgZ7a1f54GO7iHpp/Nq2j1+zsaC7jvCZnqaK9cKybXeU1pVc8xqd2kz
1Td2nDf1F+odnZEOPHYvPLFKy8uZLO4Sqt1czYm0dtoL9WNWgsfOM9SDI+ma
9exVJY1JmOSR10/bGyG4naFL8kLyu9Jq9uA3pH1N2q9kMZN+IP2XxMu3jXjn
8+Jax/CNPr5L8ooyoBvGit021mjsXpP2lVzGkf56MvGGtN/Loi6M9Y9TLerU
LfkUwrT2g/JhRi6L4bBhTbGsqkSAgq2EsCqzE8nmWsGoGEkwKl8vGNVzZFTd
WZmBTdmWN5tN0Vm964n+ruRmBVCodlOoEy4H0esX8KY6c7Qe3jSWYasLqyLA
l5wSdfKlMemPyJjVC57UNE/i8wB+5JdUtZox15O2226KF6V5UzUfKrxoigcV
DAYcCBwIHKguDjR0xBYcKGSt0TYORHdevh0dCFBbCZBZr/qiDvKzjeQn7fkj
8J+iZzv4T3k3FlgbIEFOiTpJEEc24u9mkKBVSRDdo6flASTIL3npuB6QIJAg
kCDSBglizrSJBOGJIDpqm0kQngiy9YIH4YmgxXHgQtwIPBEEIsSPWNjHhVUE
OJBTok4OVM09DA60KgfiIwgaVOdzQSH7H9Ag0CDQINCg8pk20aCB5FdPoEEh
Kw7QINMGDWojDaK/SsFFic5eoEHbRoNifyURNKjoaT8NoqtC39PHoEKgQr7c
gArFZgNUyC8JKjS3ut1UyNgxeyI/HfJ9q6UznuejuRqalGI1ni6xVkCbGMnN
ok2+6gF9EmKT6RNHjnztOXcK/R82cKiA8c+MQ9Ffr6C55TmUb74AlwKXil8Z
gVPVmbP1PbVUUaWAWzklmvqvthUzaLXBsVblWJdyeYTT8gKi5Zc8d9ishgc0
S7hW9a4e4uUiRZtAvkTnP54dGos=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{346, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->75710231]
}, Open  ]],

Cell[TextData[{
 "Solve the second polynomial of the Gr\[ODoubleDot]bner basis for the other \
variable ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->374556321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"soly", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"gb", "[", 
      RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], ",", "y"}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->790920370],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "x"}], "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "3"]}], "+", 
       SuperscriptBox["x", "4"]}], ")"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{216, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->40296769]
}, Open  ]],

Cell[TextData[{
 "This method finds all common roots of ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->334922773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"polys", "/.", "soly"}], ")"}], "/.", "solx"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->355070416],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWFEOgjAMLSARNYL65aen0S8PQYiJfBiNcgY9Nq5DDcGZbpUEWEbCWMv6
3pq9jbF9WhwPp7TIs3Szu6aXY57dNtvzVbgCD8C7A0CyBlEvRU3eeD3EDTDC
Mnj7StKeNOzEMH46cPzZwPtvir8wxA+wqErDXvnCXGqgYzsqi67xKJV03T9d
vJXhOPolZ/SxPZphwz/+4afwIsv5mnPUtvy4fBGTj6daGRV+bIlRfU9x5ox/
vqU4MJoaYVu5qXXJ1rz/447Y3N+zwDeMCpTcc6WXmpdzS7liS/PiccUsrqbt
ybh21mx19hQWtfMeKhe14x9qXjwutVp5a6tTa/tcTq11VKfWfnM5tdZRnVr7
zeXUWkdtU62cKDST15NqT50Ddo1HnSt23T9dvIUmnvLPSBoPjRp4T2CfJ4k=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{390, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->618030436]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " use Gr\[ODoubleDot]bner bases to solve systems of equations:"
}], "ExampleText",
 CellID->716303327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Thread", "[", 
    RowBox[{"polys", "\[Equal]", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->26895803],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{551, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->506946894]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->281658236],

Cell["\<\
Get a fuzzy solution to a system of overdetermined equations:\
\>", "ExampleText",
 CellID->307604815],

Cell[BoxData[
 RowBox[{
  RowBox[{"positiveSolve", "[", 
   RowBox[{"polys_", ",", "vars_", ",", "tol_"}], "]"}], ":=", 
  RowBox[{"Catch", "[", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gb", ",", "sols"}], "}"}], ",", 
     RowBox[{
      RowBox[{"gb", "=", 
       RowBox[{"GroebnerBasis", "[", 
        RowBox[{"polys", ",", "vars", ",", 
         RowBox[{"CoefficientDomain", "\[Rule]", "InexactNumbers"}], ",", 
         RowBox[{"Tolerance", "\[Rule]", "tol"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"!", 
          RowBox[{"ListQ", "[", "gb", "]"}]}], "||", 
         RowBox[{"gb", "===", 
          RowBox[{"{", "}"}]}], "||", 
         RowBox[{
          RowBox[{"First", "[", "gb", "]"}], "\[Equal]", "1"}]}], ",", 
        RowBox[{"Throw", "[", "$Failed", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sols", "=", 
       RowBox[{"NSolve", "[", 
        RowBox[{"gb", ",", "vars"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"!", 
          RowBox[{"ListQ", "[", "sols", "]"}]}], "||", 
         RowBox[{"sols", "===", 
          RowBox[{"{", "}"}]}]}], ",", 
        RowBox[{"Throw", "[", "$Failed", "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sols", "=", 
       RowBox[{"vars", "/.", "sols"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sols", "=", 
       RowBox[{"Select", "[", 
        RowBox[{"sols", ",", 
         RowBox[{
          RowBox[{"Apply", "[", 
           RowBox[{"And", ",", 
            RowBox[{"Map", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Re", "[", "#", "]"}], "\[GreaterEqual]", "0"}], 
               "&"}], ",", "#"}], "]"}]}], "]"}], "&"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Re", "[", 
       RowBox[{
        RowBox[{"Apply", "[", 
         RowBox[{"Plus", ",", "sols"}], "]"}], "/", 
        RowBox[{"Length", "[", "sols", "]"}]}], "]"}]}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27305899],

Cell[BoxData[
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], "+", 
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"1.49071", "x", " ", "y"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{"-", "8"}], "+", 
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"0.4", "x", " ", "z"}], "+", 
      RowBox[{"z", "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], "+", 
      RowBox[{"t", "^", "2"}], "-", 
      RowBox[{"0.894427", "t", " ", "x"}], "+", 
      RowBox[{"x", "^", "2"}]}], ",", " ", 
     RowBox[{
      RowBox[{"-", "4"}], "+", 
      RowBox[{"y", "^", "2"}], "-", 
      RowBox[{"1.49071", "y", " ", "z"}], "+", 
      RowBox[{"z", "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{"-", "8"}], "+", 
      RowBox[{"t", "^", "2"}], "-", 
      RowBox[{"0.666667", "t", " ", "y"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], "+", 
      RowBox[{"t", "^", "2"}], "-", 
      RowBox[{"0.894427", "t", " ", "z"}], "+", 
      RowBox[{"z", "^", "2"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375696039],

Cell["\<\
This gives a low-precision approximate solution to this overdetermined set of \
polynomials:\
\>", "ExampleText",
 CellID->545091333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"positiveSolve", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", 
   RowBox[{"10", "^", 
    RowBox[{"(", 
     RowBox[{"-", "3"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->281923855],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.2361289413922334`", ",", "3.0001393281755595`", ",", 
   "2.236170705591806`", ",", "1.0000223834361617`"}], "}"}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->31382386]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20333],

Cell["\<\
A Gr\[ODoubleDot]bner basis generates the same ideal as the input \
polynomials:\
\>", "ExampleText",
 CellID->146060],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p1", ",", "p2"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}], "-", "1"}], ",", 
     RowBox[{"x", "-", 
      RowBox[{"2", 
       RowBox[{"y", "^", "3"}]}], "-", "3"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48081135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"g1", ",", "g2"}], "}"}], "=", 
  RowBox[{"GroebnerBasis", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p1", ",", "p2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4932523],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"8", "+", 
    SuperscriptBox["y", "2"], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["y", "6"]}], "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "x", "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["y", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{234, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->576767736]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PolynomialReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialReduce"]], "InlineFormula"],
 " to show that ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["p", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " is in the ideal ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    SubscriptBox[
     StyleBox["g", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["g", "TI"], 
     StyleBox["2", "TR"]]}], ")"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->622341402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"q1", ",", "q2"}], "}"}], ",", "r"}], "}"}], "=", 
  RowBox[{"PolynomialReduce", "[", 
   RowBox[{"p1", ",", 
    RowBox[{"{", 
     RowBox[{"g1", ",", "g2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->478861604],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"3", "+", "x", "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["y", "3"]}]}]}], "}"}], ",", "0"}], "}"}]], "Output",
 ImageSize->{131, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->507393891]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"q1", " ", "g1"}], "+", 
    RowBox[{"q2", " ", "g2"}]}], "\[Equal]", "p1"}], "//", 
  "Expand"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->88795323],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->62776423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->384387821],

Cell[TextData[{
 "By Hilbert's Nullstellensatz, if the ideal is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftAngleBracket]", "1", "\[RightAngleBracket]"}], 
   TraditionalForm]], "InlineMath"],
 " then the polynomials have no common zero:"
}], "ExampleText",
 CellID->28082313],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "-", "x", "+", "1"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "^", "3"}], "-", "y"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->508925381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"eqs", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149114049],

Cell[BoxData[
 RowBox[{"{", "1", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->119649615]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " proves that there is no common solution:"
}], "ExampleText",
 CellID->625541678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"eqs", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->540526702],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->203443811]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"eqs", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->7474667],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->173782339]
}, Open  ]],

Cell["\<\
Conversely if the ideal is not \[LeftAngleBracket]1\[RightAngleBracket] then \
there is at least one common zero:\
\>", "ExampleText",
 CellID->141233763],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "-", "x", "+", "1"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->23009994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"eqs", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->52206150],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", "y", "+", 
    SuperscriptBox["y", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x", "-", "y"}]}], "}"}]], "Output",
 ImageSize->{135, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->75701253]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find a solution instance:"
}], "ExampleText",
 CellID->65951403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{"eqs", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->172804622],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{282, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->233109178]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->623442068],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " of univariate polynomials is equivalent to computing ",
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3189569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"x", "-", "3"}], ")"}]}]}], "}"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->375663260],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], "+", "x"}], "}"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344380496]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "3"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73497019],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "+", "x"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->130908849]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4802811],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " of linear polynomials is equivalent to a Gaussian elimination process:"
}], "ExampleText",
 CellID->129050080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", "y"}], "+", 
      RowBox[{"3", "z"}]}], ",", 
     RowBox[{
      RowBox[{"4", "x"}], "+", 
      RowBox[{"5", "y"}], "+", 
      RowBox[{"6", "z"}]}], ",", 
     RowBox[{
      RowBox[{"7", "x"}], "+", 
      RowBox[{"8", "y"}], "+", 
      RowBox[{"9", "z"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35482968],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"y", "+", 
    RowBox[{"2", " ", "z"}]}], ",", 
   RowBox[{"x", "-", "z"}]}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->228757622]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RowReduce", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->116319018],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->57789237]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", ".", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->278823277],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "-", "z"}], ",", 
   RowBox[{"y", "+", 
    RowBox[{"2", " ", "z"}]}], ",", "0"}], "}"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->137718655]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->203652400],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " is used to solve systems of polynomial equations: "
}], "ExampleText",
 CellID->182303990],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "-", 
       RowBox[{"2", 
        RowBox[{"y", "^", "3"}]}]}], "==", "3"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->334409247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"eqs", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->267073],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"8", "+", 
    SuperscriptBox["y", "2"], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["y", "6"]}], "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "x", "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["y", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{234, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->540572746]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to directly solve the system:"
}], "ExampleText",
 CellID->294045124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"eqs", ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "y", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->556480601],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXMtu1TAQTe+LvqClhZY+QAUE7YYWWNA/gEXpCtgiVRUSSCAQdM038Bv8
A2x4SMBPhTjXbpyT42s7cVPo9ZVucsfxjMcz49ectPsHRy9fvDk4enV4sPHo
/cG7l68OP2w8fPs+K+pOJElnO0mSvStJ9jvNfuVf9bmbfZPkcXbtZMVf5L0n
SrvH9fLb+nFN/ckXoLuEc60h51J27WUP7kONz0DPWyQ+lnL+5FKvwNN7RLqw
xUUoR9vsA/2bSl/ILoJEnbrS2uLel3dsoSvLz0G5qN/PyFlSnvQKetiqqHme
9EWUd+TdnXNS15VyzEr7DbucV6j0/pzW81E2HhBZnRFl6n5Jyp80WA4tWvhO
cA8k91Ad9cl5+voYSmSLrqVdc6mmC+cdMF9XamFEiA4MSGShV1E618FV2hSR
xvhmUoyhvvQAtzXyI82juNpCuUTFYtnbA6oBG4m8Vud4vlnWeBIZm0RLnxhC
DZw81ydRNJOaxj/KnTFIQH0GzpJE+XFUWDlUnwo7njf21BojFVkdWqqicYX0
mdlCj46k7P9K//j80mslGkbpLX7a1xVsxzaf2EeqTSIfaXY52JcLVI4tamz9
UeuUWh3Lnp22eAntXx1Dw/Vpieq+SEu916UR+o3ah5T1pF5rFDl0h+Av0bIG
uERNj9TzjZNqy8KnKnJwn1WRVPHcMC4upyzqFiiH8qXae6q5DDXlkXJB1q6u
YWiZJYtlDCuzVgPXTbdY6kgtfbyi1ms13/fS8m5yGerjyaBD7f8rJ7apHVGC
27yt/Cz6x/ZTSg+mn/tuTvV6Eexvq79q6RPy3aFazdFSdab4mdOCs09aVLGN
sZfLLEWO8jDqNJ8WkSCKq3OH4sSYuqhx2ttKpPamU59O72he7SoLac+/5fLw
lH3VQm8DvQnaXbdo9RTo77W02AH6trTVDUvrz4w2ENx6Kwmht4HeAmkbxGPY
Z8H3I7+/9rT0lpT+kVowlZ+7hMJszb68f02LU68937IH9FegFwJKqZvBwZ0G
25+5yMWZ0LYS5DNl7QyRTWts3SR3IYjWMfOkeqJLmTJYxdd3Iaxryk65W5fV
rGddlQVpZl3lI1z73SM45t/MOrSXf5th+niOFpXHq3qS59ba8qRbDs/Vk1gP
pTfzJM4Q/p6cNLbvPz5jJtPcZtNM5oBYxDbKdOmn5Q+14tT3x3TKMZn6/iiN
rhr+wP0Xzn4eoyXmfRtKbDfv6zTiSu3yvYoobcenqHFzn9pWtOY+5blMf80W
ga43TmNW/bSy6jwv5xN7PJLa8x07wTX1nW38NfedQQcvrebTJie9iFgUnhG7
9Hng9B0HykYnb8+5Fu2pS6hvz5SMGbcoHR/sZo3U94m/9YCWWmrVUvpe39dS
rE9ukXU2EKw1gw62aFmz9B7x1jZ6r3O643c9ooNbBJw0Xof4zDVP+bdBPiJy
HCUKhff5ao9yb0m5N41ah8QJFQ53zVPeJsi7nuo4Xl1c8ZMn36bk281bTeUn
4o+2c0fEH0drHfFH1RO0JdttR/wx4o+aLmOOP7q9/x9RSFUeUUicMSIKOZqj
inrhW7O2t9QjGhnRyCa+Gmc0Es8bEYeMOGTEIU8Lh8RztO97OBGFPC0UspSz
9h5xEYUsPMPyPr5vfUYUsmzPMOvC+KCQK8ZWfKJwfLDIVSd7jRMiuZLy/N/4
IJKs9xGRNNMRkdTp/w2RxEh/kJYRSlGYo1yVmN8FGvFFcdkJwVmM3PRksEhx
yf1cOS9gzVA4onuLEQNUPcH5uA4GONruEbky69AecoUSwvlYp5Mk4h6hcA/8
fwqBPRZz7g0l/is5d3Hhfua2jplbB4kB/gohoE9Le7XqOB3fzODJjR2ewziL
2S18c7y+DfGJeG/pbORumKT6dsGTWuiMhri4nRFDZSGKFk0n31AZBEEMT87P
Pa22pUl4Mmxl4i9pETJg\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{558, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->644921874]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " gives solutions in terms of replacement rules:"
}], "ExampleText",
 CellID->78620642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"eqs", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->167119354],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztndGO1DYUhrPJzCzLsuyyBQqsqLZIFIkLaKXeohFc0KoSd7zACpDgAlEB
T9C34R14tzTO2LOeP8dxHDIzjucfiZm1Yx8f/8d2HH+KeHXx9f27jxdfP7y5
OP/r88W/7z+8+XL+8tPnKqvYy7L8WZZlX+5k1d9l9Vf9z3zm1b8sO6y+8yr7
tf79rn//gfRE/06t3yy7qr6LpdXaip3+Dum/PdcnnnQecavfIH0C6QNI71df
kyr5R6Cd4bxVcbwheKnysf7vHesHeDexR6OylTvanlVfKrkP+WoMTvXYVNkF
XC+sa1P9i/4UOv+Kw/Y1Id/yXLfqKjnVvZqaGdOp5hXbV2cNpdSiy3WBRu/3
rZ7b+agu9vzQoRDV7aJuv9mZN3xBr2s7U3vGKAdnkn6NUnJuHpBbuHOxF41S
0qxtlpL6OxNGFJZD67IPXa3hGp076tVzZCVe5r6472wf56AqbVbbI7gu682I
bS9i3eY1emN2TWqeHmTN62b1wnk8a3gbMiIwyrhGybXMioq+HJauFVa6s0yF
8YP+NHvnsqTyl9FsrXFo9Wn5vZhX3tjetNKZFS35DsEorCcKvjvpXl0P75yq
V9IKijsOtCatcZONRBhbxrR/T4Tt+FZYUekgiy37iiA710U74nxs3Q0p5Rmt
OKI11I4XnzuULrkQAXFm//heqWVktD3FrPYBV6EfHw3iqhhk0bHOB4+EiVDu
J1FPjCQjtL0IDXEecxvq4ImU+1mjyFZPZ8xpjX/dPdalm/cC7CF6hzunIshC
t5XySCtz3dP2qe77otPmc4N6Odrudy+5Kyoi373keyOeYnbbG9zWkVItSc+c
ub6O1sOeeM0sPAXVfeXvefr0mErodL9Rd0/36aS8PAmcCq2Zef0z5B+XOGvM
aQG2f1JeMheV3bxf2OcMrpr+tjLtfdGi5cOkezkMW/kF0vch/QTSv4F3v3q8
eL7h9tajwlNIP9SxegD5uPd7saZ2uvUaeandutLyPqSfQPoRWD0v5TH9fGD7
Mr/9z6MdjpxHujaOoLc97fxZ11dZ6Lf6urW8qj5zUX8fr673yWsnxgcRtbIt
Dt3gg5293QSHNueEk0uvyJ8dNcmfx6su+TOWIs0kfx5/xKR0vlwiyJ3jIp7i
OYeVJnHerv5opd4fkC0L+o6HVp5CWpxzpMq9LW4qTt2eesmPZXXjpJPHpfy0
Qn4ce4RaZiN5sW67O/88hnwsR14cple3ewX5sFSefLgvH5ZHWZo8WM2dSYt2
afBgVy/7EZjU+O8wvY6d9y56OXa+u+Cd5LqLNLkuuS65rrkyDHk8cKhCrrtO
dcl1sdRuUUKcPXhqSqI7nliR5a5qhuM4LpZ4pOujB2S429Gd7NaymggT5HvB
6UWLHHfI6MdDCZsnqnYJEt3xxIpsd0hWeQI1sW9ku2F6ke32J5pnHm13h+36
lNhltnvm8CEttuvqJdnucL0m28UYku2qz1zUnWyXbJdsN0b6yHd2+c5u2fKs
RF7Id3YZMb6zmyJv5Du7cetP7mtZTYQk8p3dNOJE1jtk3OPghysnrVY+CW/s
ESLXHZJT+tY+ct0wvch1+9NMWZXdpbvd9Nhlxnu3lM8c02K8rl6S8Q7XazJe
jCEZr/rMRd3JeMl4yXhjpJCzUn7mIONdp7pkvFiKxJCMd/wRI+NdVQ5Hc1yM
Ef//MaxFxrtd/cl4LauJsEPf8wkZ7zjiRMY7ZNzjIIj4dI6KkfWOJVJkvmS+
8epF5kvmS+a7bRpK5nuZS+bbxQsyX4whma/6zOuU8d+cmIaxX98Odj2Udhyt
xsWK+3i/eXYsekmW7KhJljxedbuxZN+sJVtOhVRKlBFnI6lymw/xxKqdJ/vO
VciXSzOeW3u3Lr6J/1+ZyLqsvTr58mb1l/my705J3pwSxyRvHkec+j1Jkz/L
asdJNX1jgPx5LJEKmK3k0brt7nzVpz55dJhe/e4t5NNS+bOyXbXdIdM+JfqN
unQZtWQpPUYtWRqGEqXJrIdWYRwM28VSybL72Aln2dne/w4jngs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{573, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->11658510]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145867078],

Cell["Eliminate a variable from a system of polynomial equations:", \
"ExampleText",
 CellID->8425824],

Cell[BoxData[
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y", " ", "z"}], "-", "3"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->516185442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{"polys", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", "z", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->966288673],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", "-", 
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "2"]}], "+", 
   RowBox[{
    SuperscriptBox["x", "4"], " ", 
    SuperscriptBox["y", "2"]}], "+", 
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "4"]}]}], "}"}]], "Output",
 ImageSize->{147, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->435682390]
}, Open  ]],

Cell[TextData[{
 "Eliminate a variable using ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->57877033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"z", ",", 
    RowBox[{"And", "@@", 
     RowBox[{"Thread", "[", 
      RowBox[{"polys", "\[Equal]", "0"}], "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->373105681],

Cell[BoxData[
 RowBox[{
  RowBox[{"9", "-", 
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "2"]}], "+", 
   RowBox[{
    SuperscriptBox["x", "4"], " ", 
    SuperscriptBox["y", "2"]}], "+", 
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "4"]}]}], "\[Equal]", "0"}]], "Output",
 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->468756802]
}, Open  ]],

Cell[TextData[{
 "Eliminate a variable using ",
 Cell[BoxData[
  ButtonBox["Eliminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eliminate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->85204977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eliminate", "[", 
  RowBox[{
   RowBox[{"Thread", "[", 
    RowBox[{"polys", "\[Equal]", "0"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->916346443],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "4"], " ", 
    SuperscriptBox["y", "2"]}], "+", 
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["y", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["y", "2"]}], ")"}]}]}], "\[Equal]", 
  RowBox[{"-", "9"}]}]], "Output",
 ImageSize->{162, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->49856187]
}, Open  ]],

Cell[TextData[{
 "Eliminate a variable using ",
 Cell[BoxData[
  ButtonBox["Resultant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resultant"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7322133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{"polys", "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", 
   RowBox[{"polys", "[", 
    RowBox[{"[", "2", "]"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->47948731],

Cell[BoxData[
 RowBox[{"9", "-", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "4"]}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->43787055]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10184],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialGCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eliminate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eliminate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CylindricalDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CylindricalDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18121]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16710],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "Tutorials",\

 CellID->14508],

Cell[TextData[ButtonBox["Polynomials Modulo Primes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PolynomialsModuloPrimes"]], "Tutorials",
 CellID->180770870],

Cell[TextData[ButtonBox["Complex Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexPolynomialSystems"]], "Tutorials",
 CellID->212396704]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->26489],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#24488"], None}]], "RelatedLinks",
 CellID->9858],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
GroebnerBasis"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->231609387],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "MoreAbout",
 CellID->316561881],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->968207415],

Cell[TextData[ButtonBox["Polynomial Division",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialDivision"]], "MoreAbout",
 CellID->59577767],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->680371620]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GroebnerBasis - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 18.1625520}", "context" -> "System`", 
    "keywords" -> {
     "algebraic algorithms", "algebraic geometry", "algebraic varieties", 
      "Buchberger algorithm", "catastrophe theory", "coefficient domain", 
      "commutative algebra", "degree lexicographic", 
      "degree reverse lexicographic", "elimination basis", "Grobner basis", 
      "Groebner basis", "Groebner walk algorithm", "ideal basis", 
      "ideal operations", "ideals", "inexact numbers", "lexicographic", 
      "lexicographic ordering", "monomial order", "normal form", 
      "primary decomposition", "projection of algebraic set", 
      "rational functions", "singularities", "standard basis", "syzygies", 
      "varieties", "Zariski closure"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "GroebnerBasis[{poly_1, poly_2, ...}, {x_1, x_2, ...}] gives a list of \
polynomials that form a Gro\"bner basis for the set of polynomials poly_i. \
GroebnerBasis[{poly_1, poly_2, ...}, {x_1, x_2, ...}, {y_1, y_2, ...}] finds \
a Gro\"bner basis in which the y_i have been eliminated. ", 
    "synonyms" -> {"groebner basis"}, "title" -> "GroebnerBasis", "type" -> 
    "Symbol", "uri" -> "ref/GroebnerBasis"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10834, 333, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->216578803]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 113602, 4000}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3387, 72, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4010, 99, 51, 1, 70, "ObjectName",
 CellID->23486],
Cell[4064, 102, 2559, 80, 70, "Usage",
 CellID->6602]
}, Open  ]],
Cell[CellGroupData[{
Cell[6660, 187, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7138, 204, 159, 4, 70, "Notes",
 CellID->7737],
Cell[7300, 210, 363, 13, 70, "Notes",
 CellID->28901],
Cell[7666, 225, 271, 8, 70, "Notes",
 CellID->17901],
Cell[7940, 235, 294, 9, 70, "Notes",
 CellID->22749],
Cell[8237, 246, 69, 1, 70, "Notes",
 CellID->15967],
Cell[8309, 249, 972, 22, 70, "3ColumnTableMod",
 CellID->30102],
Cell[9284, 273, 611, 19, 70, "Notes",
 CellID->4265],
Cell[9898, 294, 429, 15, 70, "Notes",
 CellID->21881],
Cell[10330, 311, 467, 17, 70, "Notes",
 CellID->31843]
}, Closed]],
Cell[CellGroupData[{
Cell[10834, 333, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->216578803],
Cell[CellGroupData[{
Cell[11219, 347, 147, 5, 70, "ExampleSection",
 CellID->12985428],
Cell[11369, 354, 78, 1, 70, "ExampleText",
 CellID->56458547],
Cell[CellGroupData[{
Cell[11472, 359, 386, 14, 28, "Input",
 CellID->606806550],
Cell[11861, 375, 401, 15, 39, "Output",
 CellID->122712727]
}, Open  ]],
Cell[12277, 393, 87, 1, 70, "ExampleText",
 CellID->591388311],
Cell[CellGroupData[{
Cell[12389, 398, 394, 14, 28, "Input",
 CellID->414238400],
Cell[12786, 414, 179, 6, 36, "Output",
 CellID->36547538]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13014, 426, 216, 7, 70, "ExampleSection",
 CellID->24972],
Cell[13233, 435, 92, 1, 70, "ExampleText",
 CellID->262454330],
Cell[CellGroupData[{
Cell[13350, 440, 547, 18, 70, "Input",
 CellID->237488057],
Cell[13900, 460, 1616, 52, 75, "Output",
 CellID->40331394]
}, Open  ]],
Cell[15531, 515, 125, 3, 70, "ExampleDelimiter",
 CellID->172111596],
Cell[15659, 520, 95, 1, 70, "ExampleText",
 CellID->124207719],
Cell[CellGroupData[{
Cell[15779, 525, 430, 14, 70, "Input",
 CellID->176467047],
Cell[16212, 541, 874, 29, 39, "Output",
 CellID->156497398]
}, Open  ]],
Cell[17101, 573, 125, 3, 70, "ExampleDelimiter",
 CellID->265229691],
Cell[17229, 578, 76, 1, 70, "ExampleText",
 CellID->170843201],
Cell[CellGroupData[{
Cell[17330, 583, 576, 18, 70, "Input",
 CellID->769898039],
Cell[17909, 603, 180, 6, 36, "Output",
 CellID->330359718]
}, Open  ]],
Cell[18104, 612, 125, 3, 70, "ExampleDelimiter",
 CellID->507975113],
Cell[18232, 617, 64, 1, 70, "ExampleText",
 CellID->701267881],
Cell[CellGroupData[{
Cell[18321, 622, 570, 19, 70, "Input",
 CellID->62997475],
Cell[18894, 643, 1099, 36, 58, "Output",
 CellID->83999410]
}, Open  ]],
Cell[20008, 682, 124, 3, 70, "ExampleDelimiter",
 CellID->16644745],
Cell[20135, 687, 84, 1, 70, "ExampleText",
 CellID->78842765],
Cell[20222, 690, 416, 14, 70, "Input",
 CellID->256542059],
Cell[CellGroupData[{
Cell[20663, 708, 195, 6, 70, "Input",
 CellID->428210104],
Cell[20861, 716, 715, 24, 39, "Output",
 CellID->75516963]
}, Open  ]],
Cell[21591, 743, 108, 3, 70, "ExampleText",
 CellID->188532408],
Cell[CellGroupData[{
Cell[21724, 750, 275, 8, 70, "Input",
 CellID->834785145],
Cell[22002, 760, 763, 26, 39, "Output",
 CellID->4312358]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22814, 792, 239, 7, 70, "ExampleSection",
 CellID->10518],
Cell[23056, 801, 101, 2, 70, "ExampleText",
 CellID->55897220],
Cell[CellGroupData[{
Cell[23182, 807, 424, 15, 70, "Input",
 CellID->459511598],
Cell[23609, 824, 447, 16, 39, "Output",
 CellID->227229332]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24105, 846, 217, 7, 70, "ExampleSection",
 CellID->2073],
Cell[CellGroupData[{
Cell[24347, 857, 234, 7, 70, "ExampleSubsection",
 CellID->32353],
Cell[24584, 866, 139, 4, 70, "ExampleText",
 CellID->140771690],
Cell[24726, 872, 403, 14, 70, "Input",
 CellID->781521911],
Cell[CellGroupData[{
Cell[25154, 890, 185, 6, 70, "Input",
 CellID->504844187],
Cell[25342, 898, 895, 29, 39, "Output",
 CellID->118606756]
}, Open  ]],
Cell[26252, 930, 130, 4, 70, "ExampleText",
 CellID->212195333],
Cell[CellGroupData[{
Cell[26407, 938, 248, 7, 70, "Input",
 CellID->321174485],
Cell[26658, 947, 1372, 44, 58, "Output",
 CellID->510572875]
}, Open  ]],
Cell[28045, 994, 237, 8, 70, "ExampleText",
 CellID->323323715],
Cell[CellGroupData[{
Cell[28307, 1006, 260, 8, 70, "Input",
 CellID->122481891],
Cell[28570, 1016, 772, 26, 39, "Output",
 CellID->7148844]
}, Open  ]],
Cell[29357, 1045, 75, 1, 70, "ExampleText",
 CellID->12585303],
Cell[CellGroupData[{
Cell[29457, 1050, 285, 8, 70, "Input",
 CellID->643851330],
Cell[29745, 1060, 1440, 34, 109, "Output",
 CellID->7378832]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31234, 1100, 222, 7, 70, "ExampleSubsection",
 CellID->1281],
Cell[31459, 1109, 280, 9, 70, "ExampleText",
 CellID->47717632],
Cell[31742, 1120, 997, 32, 70, "Input",
 CellID->184997293],
Cell[CellGroupData[{
Cell[32764, 1156, 252, 9, 70, "Input",
 CellID->121728834],
Cell[33019, 1167, 210, 7, 36, "Output",
 CellID->20540199]
}, Open  ]],
Cell[33244, 1177, 226, 7, 70, "ExampleText",
 CellID->190823980],
Cell[CellGroupData[{
Cell[33495, 1188, 360, 11, 70, "Input",
 CellID->445478091],
Cell[33858, 1201, 165, 5, 36, "Output",
 CellID->312233367]
}, Open  ]],
Cell[34038, 1209, 125, 3, 70, "ExampleDelimiter",
 CellID->670242391],
Cell[34166, 1214, 132, 4, 70, "ExampleText",
 CellID->650508321],
Cell[34301, 1220, 574, 20, 70, "Input",
 CellID->14194304],
Cell[34878, 1242, 133, 4, 70, "ExampleText",
 CellID->18095096],
Cell[CellGroupData[{
Cell[35036, 1250, 295, 9, 70, "Input",
 CellID->259439312],
Cell[35334, 1261, 2424, 71, 111, "Output",
 CellID->157811860]
}, Open  ]],
Cell[37773, 1335, 193, 5, 70, "ExampleText",
 CellID->293946071],
Cell[CellGroupData[{
Cell[37991, 1344, 293, 9, 70, "Input",
 CellID->129489894],
Cell[38287, 1355, 2426, 71, 111, "Output",
 CellID->520319028]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40762, 1432, 223, 7, 70, "ExampleSubsection",
 CellID->2662],
Cell[40988, 1441, 133, 4, 70, "ExampleText",
 CellID->524491605],
Cell[41124, 1447, 601, 20, 70, "Input",
 CellID->1611282390],
Cell[CellGroupData[{
Cell[41750, 1471, 240, 7, 70, "Input",
 CellID->50891778],
Cell[41993, 1480, 1531, 49, 58, "Output",
 CellID->30060183]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43573, 1535, 230, 7, 70, "ExampleSubsection",
 CellID->27996],
Cell[43806, 1544, 285, 10, 70, "ExampleText",
 CellID->230562455],
Cell[44094, 1556, 602, 20, 70, "Input",
 CellID->1396156391],
Cell[CellGroupData[{
Cell[44721, 1580, 194, 6, 70, "Input",
 CellID->12450228],
Cell[44918, 1588, 1886, 54, 143, "Output",
 CellID->47594140]
}, Open  ]],
Cell[46819, 1645, 189, 5, 70, "ExampleText",
 CellID->16229979],
Cell[CellGroupData[{
Cell[47033, 1654, 274, 8, 70, "Input",
 CellID->99183662],
Cell[47310, 1664, 2279, 70, 109, "Output",
 CellID->518292244]
}, Open  ]],
Cell[49604, 1737, 139, 4, 70, "ExampleText",
 CellID->118288737],
Cell[49746, 1743, 406, 14, 70, "Input",
 CellID->26342085],
Cell[50155, 1759, 141, 4, 70, "ExampleText",
 CellID->79259332],
Cell[CellGroupData[{
Cell[50321, 1767, 248, 7, 70, "Input",
 CellID->7734005],
Cell[50572, 1776, 2147, 66, 92, "Output",
 CellID->539216826]
}, Open  ]],
Cell[52734, 1845, 332, 12, 70, "ExampleText",
 CellID->76367951],
Cell[CellGroupData[{
Cell[53091, 1861, 263, 8, 70, "Input",
 CellID->20405248],
Cell[53357, 1871, 1262, 40, 58, "Output",
 CellID->304244821]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54668, 1917, 235, 7, 70, "ExampleSubsection",
 CellID->28213],
Cell[54906, 1926, 118, 3, 70, "ExampleText",
 CellID->134444536],
Cell[55027, 1931, 602, 20, 70, "Input",
 CellID->2052334303],
Cell[CellGroupData[{
Cell[55654, 1955, 183, 5, 70, "Input",
 CellID->265528710],
Cell[55840, 1962, 1776, 55, 92, "Output",
 CellID->52874315]
}, Open  ]],
Cell[57631, 2020, 71, 1, 70, "ExampleText",
 CellID->200020751],
Cell[CellGroupData[{
Cell[57727, 2025, 185, 6, 70, "Input",
 CellID->329209222],
Cell[57915, 2033, 1775, 55, 92, "Output",
 CellID->3120626]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[59739, 2094, 221, 7, 70, "ExampleSubsection",
 CellID->29115],
Cell[59963, 2103, 244, 8, 70, "ExampleText",
 CellID->47486127],
Cell[60210, 2113, 1873, 54, 70, "Input",
 CellID->96418146],
Cell[CellGroupData[{
Cell[62108, 2171, 347, 10, 70, "Input",
 CellID->126358343],
Cell[62458, 2183, 213, 7, 36, "Output",
 CellID->117638257]
}, Open  ]],
Cell[62686, 2193, 156, 4, 70, "ExampleText",
 CellID->424764341],
Cell[CellGroupData[{
Cell[62867, 2201, 394, 11, 70, "Input",
 CellID->77053288],
Cell[63264, 2214, 225, 7, 36, "Output",
 CellID->342507262]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63538, 2227, 225, 7, 70, "ExampleSubsection",
 CellID->8804],
Cell[63766, 2236, 104, 2, 70, "ExampleText",
 CellID->57885771],
Cell[63873, 2240, 1247, 41, 70, "Input",
 CellID->66117012],
Cell[65123, 2283, 117, 3, 70, "ExampleText",
 CellID->22614882],
Cell[CellGroupData[{
Cell[65265, 2290, 302, 11, 70, "Input",
 CellID->75671728],
Cell[65570, 2303, 1276, 42, 58, "Output",
 CellID->291428799]
}, Open  ]],
Cell[CellGroupData[{
Cell[66883, 2350, 134, 4, 70, "Input",
 CellID->347139695],
Cell[67020, 2356, 280, 10, 36, "Output",
 CellID->248427012]
}, Open  ]],
Cell[67315, 2369, 279, 9, 70, "ExampleText",
 CellID->166177367],
Cell[CellGroupData[{
Cell[67619, 2382, 255, 8, 70, "Input",
 CellID->398089136],
Cell[67877, 2392, 582, 17, 39, "Output",
 CellID->41119146]
}, Open  ]],
Cell[68474, 2412, 381, 13, 70, "ExampleText",
 CellID->478847683],
Cell[CellGroupData[{
Cell[68880, 2429, 374, 11, 70, "Input",
 CellID->300498882],
Cell[69257, 2442, 370, 12, 39, "Output",
 CellID->20717341]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[69688, 2461, 223, 7, 70, "ExampleSection",
 CellID->19785],
Cell[69914, 2470, 82, 1, 70, "ExampleText",
 CellID->128193290],
Cell[69999, 2473, 347, 12, 70, "Input",
 CellID->79115273],
Cell[70349, 2487, 132, 4, 70, "ExampleText",
 CellID->485912894],
Cell[CellGroupData[{
Cell[70506, 2495, 211, 7, 70, "Input",
 CellID->44511096],
Cell[70720, 2504, 749, 25, 39, "Output",
 CellID->102539788]
}, Open  ]],
Cell[71484, 2532, 205, 7, 70, "ExampleText",
 CellID->169623477],
Cell[CellGroupData[{
Cell[71714, 2543, 245, 9, 70, "Input",
 CellID->90157517],
Cell[71962, 2554, 1765, 33, 70, "Output",
 Evaluatable->False,
 CellID->75710231]
}, Open  ]],
Cell[73742, 2590, 207, 7, 70, "ExampleText",
 CellID->374556321],
Cell[CellGroupData[{
Cell[73974, 2601, 246, 9, 70, "Input",
 CellID->790920370],
Cell[74223, 2612, 538, 18, 51, "Output",
 CellID->40296769]
}, Open  ]],
Cell[74776, 2633, 163, 6, 70, "ExampleText",
 CellID->334922773],
Cell[CellGroupData[{
Cell[74964, 2643, 190, 6, 70, "Input",
 CellID->355070416],
Cell[75157, 2651, 639, 15, 70, "Output",
 Evaluatable->False,
 CellID->618030436]
}, Open  ]],
Cell[75811, 2669, 357, 12, 70, "ExampleText",
 CellID->716303327],
Cell[CellGroupData[{
Cell[76193, 2685, 243, 8, 70, "Input",
 CellID->26895803],
Cell[76439, 2695, 2331, 42, 70, "Output",
 Evaluatable->False,
 CellID->506946894]
}, Open  ]],
Cell[78785, 2740, 125, 3, 70, "ExampleDelimiter",
 CellID->281658236],
Cell[78913, 2745, 112, 3, 70, "ExampleText",
 CellID->307604815],
Cell[79028, 2750, 2180, 61, 70, "Input",
 CellID->27305899],
Cell[81211, 2813, 1167, 36, 70, "Input",
 CellID->375696039],
Cell[82381, 2851, 143, 4, 70, "ExampleText",
 CellID->545091333],
Cell[CellGroupData[{
Cell[82549, 2859, 286, 9, 70, "Input",
 CellID->281923855],
Cell[82838, 2870, 301, 9, 36, "Output",
 CellID->31382386]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[83188, 2885, 233, 7, 70, "ExampleSection",
 CellID->20333],
Cell[83424, 2894, 128, 4, 70, "ExampleText",
 CellID->146060],
Cell[83555, 2900, 422, 15, 70, "Input",
 CellID->48081135],
Cell[CellGroupData[{
Cell[84002, 2919, 317, 11, 70, "Input",
 CellID->4932523],
Cell[84322, 2932, 521, 18, 39, "Output",
 CellID->576767736]
}, Open  ]],
Cell[84858, 2953, 565, 23, 70, "ExampleText",
 CellID->622341402],
Cell[CellGroupData[{
Cell[85448, 2980, 384, 13, 70, "Input",
 CellID->478861604],
Cell[85835, 2995, 345, 12, 39, "Output",
 CellID->507393891]
}, Open  ]],
Cell[CellGroupData[{
Cell[86217, 3012, 209, 8, 70, "Input",
 CellID->88795323],
Cell[86429, 3022, 160, 5, 36, "Output",
 CellID->62776423]
}, Open  ]],
Cell[86604, 3030, 125, 3, 70, "ExampleDelimiter",
 CellID->384387821],
Cell[86732, 3035, 279, 8, 70, "ExampleText",
 CellID->28082313],
Cell[87014, 3045, 420, 15, 70, "Input",
 CellID->508925381],
Cell[CellGroupData[{
Cell[87459, 3064, 183, 6, 70, "Input",
 CellID->149114049],
Cell[87645, 3072, 180, 6, 36, "Output",
 CellID->119649615]
}, Open  ]],
Cell[87840, 3081, 336, 12, 70, "ExampleText",
 CellID->625541678],
Cell[CellGroupData[{
Cell[88201, 3097, 176, 6, 70, "Input",
 CellID->540526702],
Cell[88380, 3105, 162, 5, 36, "Output",
 CellID->203443811]
}, Open  ]],
Cell[CellGroupData[{
Cell[88579, 3115, 173, 6, 70, "Input",
 CellID->7474667],
Cell[88755, 3123, 175, 6, 36, "Output",
 CellID->173782339]
}, Open  ]],
Cell[88945, 3132, 164, 4, 70, "ExampleText",
 CellID->141233763],
Cell[89112, 3138, 321, 12, 70, "Input",
 CellID->23009994],
Cell[CellGroupData[{
Cell[89458, 3154, 182, 6, 70, "Input",
 CellID->52206150],
Cell[89643, 3162, 317, 11, 39, "Output",
 CellID->75701253]
}, Open  ]],
Cell[89975, 3176, 222, 8, 70, "ExampleText",
 CellID->65951403],
Cell[CellGroupData[{
Cell[90222, 3188, 182, 6, 70, "Input",
 CellID->172804622],
Cell[90407, 3196, 676, 24, 51, "Output",
 CellID->233109178]
}, Open  ]],
Cell[91098, 3223, 125, 3, 70, "ExampleDelimiter",
 CellID->623442068],
Cell[91226, 3228, 374, 12, 70, "ExampleText",
 CellID->3189569],
Cell[CellGroupData[{
Cell[91625, 3244, 445, 17, 70, "Input",
 CellID->375663260],
Cell[92073, 3263, 222, 8, 36, "Output",
 CellID->344380496]
}, Open  ]],
Cell[CellGroupData[{
Cell[92332, 3276, 373, 14, 70, "Input",
 CellID->73497019],
Cell[92708, 3292, 198, 7, 36, "Output",
 CellID->130908849]
}, Open  ]],
Cell[92921, 3302, 123, 3, 70, "ExampleDelimiter",
 CellID->4802811],
Cell[93047, 3307, 258, 7, 70, "ExampleText",
 CellID->129050080],
Cell[CellGroupData[{
Cell[93330, 3318, 533, 19, 70, "Input",
 CellID->35482968],
Cell[93866, 3339, 276, 10, 36, "Output",
 CellID->228757622]
}, Open  ]],
Cell[CellGroupData[{
Cell[94179, 3354, 345, 11, 70, "Input",
 CellID->116319018],
Cell[94527, 3367, 411, 14, 36, "Output",
 CellID->57789237]
}, Open  ]],
Cell[CellGroupData[{
Cell[94975, 3386, 149, 5, 70, "Input",
 CellID->278823277],
Cell[95127, 3393, 287, 10, 36, "Output",
 CellID->137718655]
}, Open  ]],
Cell[95429, 3406, 125, 3, 70, "ExampleDelimiter",
 CellID->203652400],
Cell[95557, 3411, 238, 7, 70, "ExampleText",
 CellID->182303990],
Cell[95798, 3420, 415, 15, 70, "Input",
 CellID->334409247],
Cell[CellGroupData[{
Cell[96238, 3439, 190, 6, 70, "Input",
 CellID->267073],
Cell[96431, 3447, 521, 18, 39, "Output",
 CellID->540572746]
}, Open  ]],
Cell[96967, 3468, 212, 8, 70, "ExampleText",
 CellID->294045124],
Cell[CellGroupData[{
Cell[97204, 3480, 186, 6, 70, "Input",
 CellID->556480601],
Cell[97393, 3488, 2184, 40, 70, "Output",
 Evaluatable->False,
 CellID->644921874]
}, Open  ]],
Cell[99592, 3531, 217, 7, 70, "ExampleText",
 CellID->78620642],
Cell[CellGroupData[{
Cell[99834, 3542, 175, 6, 70, "Input",
 CellID->167119354],
Cell[100012, 3550, 2277, 41, 70, "Output",
 Evaluatable->False,
 CellID->11658510]
}, Open  ]],
Cell[102304, 3594, 125, 3, 70, "ExampleDelimiter",
 CellID->145867078],
Cell[102432, 3599, 102, 2, 70, "ExampleText",
 CellID->8425824],
Cell[102537, 3603, 356, 13, 70, "Input",
 CellID->516185442],
Cell[CellGroupData[{
Cell[102918, 3620, 219, 7, 70, "Input",
 CellID->966288673],
Cell[103140, 3629, 452, 16, 39, "Output",
 CellID->435682390]
}, Open  ]],
Cell[103607, 3648, 207, 8, 70, "ExampleText",
 CellID->57877033],
Cell[CellGroupData[{
Cell[103839, 3660, 262, 8, 70, "Input",
 CellID->373105681],
Cell[104104, 3670, 459, 16, 36, "Output",
 CellID->468756802]
}, Open  ]],
Cell[104578, 3689, 211, 8, 70, "ExampleText",
 CellID->85204977],
Cell[CellGroupData[{
Cell[104814, 3701, 198, 6, 70, "Input",
 CellID->916346443],
Cell[105015, 3709, 491, 18, 39, "Output",
 CellID->49856187]
}, Open  ]],
Cell[105521, 3730, 210, 8, 70, "ExampleText",
 CellID->7322133],
Cell[CellGroupData[{
Cell[105756, 3742, 253, 8, 70, "Input",
 CellID->47948731],
Cell[106012, 3752, 419, 15, 36, "Output",
 CellID->43787055]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[106492, 3774, 311, 9, 70, "SeeAlsoSection",
 CellID->10184],
Cell[106806, 3785, 1981, 71, 70, "SeeAlso",
 CellID->18121]
}, Open  ]],
Cell[CellGroupData[{
Cell[108824, 3861, 314, 9, 70, "TutorialsSection",
 CellID->16710],
Cell[109141, 3872, 180, 4, 70, "Tutorials",
 CellID->14508],
Cell[109324, 3878, 163, 3, 70, "Tutorials",
 CellID->180770870],
Cell[109490, 3883, 165, 3, 70, "Tutorials",
 CellID->212396704]
}, Open  ]],
Cell[CellGroupData[{
Cell[109692, 3891, 321, 9, 70, "RelatedLinksSection",
 CellID->26489],
Cell[110016, 3902, 253, 5, 70, "RelatedLinks",
 CellID->9858],
Cell[110272, 3909, 391, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110700, 3927, 319, 9, 70, "MoreAboutSection",
 CellID->231609387],
Cell[111022, 3938, 155, 3, 70, "MoreAbout",
 CellID->316561881],
Cell[111180, 3943, 147, 3, 70, "MoreAbout",
 CellID->968207415],
Cell[111330, 3948, 148, 3, 70, "MoreAbout",
 CellID->59577767],
Cell[111481, 3953, 147, 3, 70, "MoreAbout",
 CellID->680371620]
}, Open  ]],
Cell[111643, 3959, 50, 0, 70, "History"],
Cell[111696, 3961, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

