(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27320,        996]
NotebookOptionsPosition[     21233,        783]
NotebookOutlinePosition[     22506,        820]
CellTagsIndexPosition[     22421,        815]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning Data into Clusters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EditDistance" :> 
          Documentation`HelpLookup["paclet:ref/EditDistance"], 
          "JaccardDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/JaccardDissimilarity"], 
          "BitXor" :> Documentation`HelpLookup["paclet:ref/BitXor"], 
          "DigitCount" :> 
          Documentation`HelpLookup["paclet:ref/DigitCount"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EditDistance\"\>", 
       2->"\<\"JaccardDissimilarity\"\>", 3->"\<\"BitXor\"\>", 
       4->"\<\"DigitCount\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "Distance and Dissimilarity Measures" :> 
          Documentation`HelpLookup[
           "paclet:guide/DistanceAndDissimilarityMeasures"], 
          "Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Discrete & Integer Data\"\>",
        2->"\<\"Distance and Dissimilarity Measures\"\>", 
       3->"\<\"Logic & Boolean Algebra\"\>", 
       4->"\<\"String Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["HammingDistance", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HammingDistance",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HammingDistance"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the Hamming distance between strings or vectors \
",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["HammingDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HammingDistance"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 " gives the number of elements whose values disagree in ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22929],

Cell[TextData[{
 "For strings, setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["HammingDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HammingDistance"]], "InlineFormula"],
 " treat lower\[Hyphen] and upper\[Hyphen]case letters as equivalent. "
}], "Notes",
 CellID->16541]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->610759791],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->24840554],

Cell["Hamming distance between two strings:", "ExampleText",
 CellID->235641551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HammingDistance", "[", 
  RowBox[{"\"\<abc\>\"", ",", "\"\<cba\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40087832],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->445210033]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113385095],

Cell["Hamming distance between two vectors:", "ExampleText",
 CellID->184380276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HammingDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->151527321],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49987024]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Compute distance between any strings of equal length:", "ExampleText",
 CellID->86273121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HammingDistance", "[", 
  RowBox[{"\"\<abcdefghijklmn\>\"", ",", "\"\<akmdjbglhfecni\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488208944],

Cell[BoxData["11"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->289305895]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204991544],

Cell["Compute distance between any vectors of equal length:", "ExampleText",
 CellID->14044010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HammingDistance", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}], ",", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323525768],

Cell[BoxData["41"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->754126379]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2061341341],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IgnoreCase",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->523133761],

Cell["Obtain Hamming distance ignoring case of letters:", "ExampleText",
 CellID->1408879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HammingDistance", "[", 
  RowBox[{"\"\<abc\>\"", ",", "\"\<AbC\>\"", ",", 
   RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->583201827],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->411020049]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Cluster string data using Hamming distance:", "ExampleText",
 CellID->245478961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<abc\>\"", ",", "\"\<xyz\>\"", ",", "\"\<bca\>\"", ",", 
     "\"\<xyw\>\""}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "HammingDistance"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108189764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "\<\"abc\"\>", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"xyz\"\>", ",", "\<\"xyw\"\>"}], "}"}], ",", 
   RowBox[{"{", "\<\"bca\"\>", "}"}]}], "}"}]], "Output",
 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152979093]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->478877783],

Cell["Cluster numeric data using Hamming distance:", "ExampleText",
 CellID->68571327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "HammingDistance"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174963025],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139098390]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HammingDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HammingDistance"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["ManhattanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ManhattanDistance"]], "InlineFormula"],
 " for 0, 1 data:"
}], "ExampleText",
 CellID->53887873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HammingDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0"}],
     "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114362850],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57524200]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ManhattanDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0"}],
     "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26921304],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->209796068]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46919099],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HammingDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HammingDistance"]], "InlineFormula"],
 " is greater than or equal to ",
 Cell[BoxData[
  ButtonBox["EditDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EditDistance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->506287235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HammingDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0"}],
     "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->536399638],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104567324]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EditDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0"}],
     "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->101558368],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->208213147]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HammingDistance", "[", 
  RowBox[{"\"\<bccbbcb\>\"", ",", "\"\<ccbcccb\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2593590],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14853410]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EditDistance", "[", 
  RowBox[{"\"\<bccbbcb\>\"", ",", "\"\<ccbcccb\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->57611571],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->680133817]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EditDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EditDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JaccardDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JaccardDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitXor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitXor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DigitCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DigitCount"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with HammingDistance",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
HammingDistance"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->417675263],

Cell[TextData[ButtonBox["Distance and Dissimilarity Measures",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], "MoreAbout",
 CellID->435026022],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->106534511],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->156464461]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HammingDistance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 21.7563940}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "HammingDistance[u, v] gives the Hamming distance between strings or \
vectors u and v.", "synonyms" -> {"hamming distance", "Hamming distance"}, 
    "title" -> "HammingDistance", "type" -> "Symbol", "uri" -> 
    "ref/HammingDistance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7141, 215, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->610759791]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22278, 808}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2668, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3291, 89, 1580, 37, 70, "ObjectNameGrid"],
Cell[4874, 128, 725, 24, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5636, 157, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6114, 174, 463, 17, 70, "Notes",
 CellID->22929],
Cell[6580, 193, 524, 17, 70, "Notes",
 CellID->16541]
}, Closed]],
Cell[CellGroupData[{
Cell[7141, 215, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->610759791],
Cell[CellGroupData[{
Cell[7526, 229, 147, 5, 70, "ExampleSection",
 CellID->24840554],
Cell[7676, 236, 80, 1, 70, "ExampleText",
 CellID->235641551],
Cell[CellGroupData[{
Cell[7781, 241, 153, 4, 28, "Input",
 CellID->40087832],
Cell[7937, 247, 158, 5, 36, "Output",
 CellID->445210033]
}, Open  ]],
Cell[8110, 255, 125, 3, 70, "ExampleDelimiter",
 CellID->113385095],
Cell[8238, 260, 80, 1, 70, "ExampleText",
 CellID->184380276],
Cell[CellGroupData[{
Cell[8343, 265, 295, 9, 70, "Input",
 CellID->151527321],
Cell[8641, 276, 157, 5, 36, "Output",
 CellID->49987024]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8847, 287, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[9071, 296, 95, 1, 70, "ExampleText",
 CellID->86273121],
Cell[CellGroupData[{
Cell[9191, 301, 179, 5, 70, "Input",
 CellID->488208944],
Cell[9373, 308, 159, 5, 36, "Output",
 CellID->289305895]
}, Open  ]],
Cell[9547, 316, 125, 3, 70, "ExampleDelimiter",
 CellID->204991544],
Cell[9675, 321, 95, 1, 70, "ExampleText",
 CellID->14044010],
Cell[CellGroupData[{
Cell[9795, 326, 270, 8, 70, "Input",
 CellID->323525768],
Cell[10068, 336, 159, 5, 36, "Output",
 CellID->754126379]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10276, 347, 223, 7, 70, "ExampleSection",
 CellID->2061341341],
Cell[CellGroupData[{
Cell[10524, 358, 231, 7, 70, "ExampleSubsection",
 CellID->523133761],
Cell[10758, 367, 90, 1, 70, "ExampleText",
 CellID->1408879],
Cell[CellGroupData[{
Cell[10873, 372, 206, 5, 70, "Input",
 CellID->583201827],
Cell[11082, 379, 158, 5, 36, "Output",
 CellID->411020049]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[11301, 391, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[11531, 400, 86, 1, 70, "ExampleText",
 CellID->245478961],
Cell[CellGroupData[{
Cell[11642, 405, 313, 10, 70, "Input",
 CellID->108189764],
Cell[11958, 417, 351, 11, 36, "Output",
 CellID->152979093]
}, Open  ]],
Cell[12324, 431, 125, 3, 70, "ExampleDelimiter",
 CellID->478877783],
Cell[12452, 436, 86, 1, 70, "ExampleText",
 CellID->68571327],
Cell[CellGroupData[{
Cell[12563, 441, 474, 16, 70, "Input",
 CellID->174963025],
Cell[13040, 459, 514, 19, 36, "Output",
 CellID->139098390]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13603, 484, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[13844, 493, 365, 12, 70, "ExampleText",
 CellID->53887873],
Cell[CellGroupData[{
Cell[14234, 509, 342, 10, 70, "Input",
 CellID->114362850],
Cell[14579, 521, 157, 5, 36, "Output",
 CellID->57524200]
}, Open  ]],
Cell[CellGroupData[{
Cell[14773, 531, 343, 10, 70, "Input",
 CellID->26921304],
Cell[15119, 543, 158, 5, 36, "Output",
 CellID->209796068]
}, Open  ]],
Cell[15292, 551, 124, 3, 70, "ExampleDelimiter",
 CellID->46919099],
Cell[15419, 556, 353, 12, 70, "ExampleText",
 CellID->506287235],
Cell[CellGroupData[{
Cell[15797, 572, 342, 10, 70, "Input",
 CellID->536399638],
Cell[16142, 584, 158, 5, 36, "Output",
 CellID->104567324]
}, Open  ]],
Cell[CellGroupData[{
Cell[16337, 594, 339, 10, 70, "Input",
 CellID->101558368],
Cell[16679, 606, 158, 5, 36, "Output",
 CellID->208213147]
}, Open  ]],
Cell[CellGroupData[{
Cell[16874, 616, 160, 4, 70, "Input",
 CellID->2593590],
Cell[17037, 622, 157, 5, 36, "Output",
 CellID->14853410]
}, Open  ]],
Cell[CellGroupData[{
Cell[17231, 632, 158, 4, 70, "Input",
 CellID->57611571],
Cell[17392, 638, 158, 5, 36, "Output",
 CellID->680133817]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17611, 650, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[17930, 661, 977, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[18944, 701, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[19265, 712, 170, 3, 70, "Tutorials",
 CellID->22256]
}, Open  ]],
Cell[CellGroupData[{
Cell[19472, 720, 305, 8, 70, "RelatedLinksSection"],
Cell[19780, 730, 372, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20189, 747, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[20510, 758, 157, 3, 70, "MoreAbout",
 CellID->417675263],
Cell[20670, 763, 179, 3, 70, "MoreAbout",
 CellID->435026022],
Cell[20852, 768, 157, 3, 70, "MoreAbout",
 CellID->106534511],
Cell[21012, 773, 149, 3, 70, "MoreAbout",
 CellID->156464461]
}, Open  ]],
Cell[21176, 779, 27, 0, 70, "History"],
Cell[21206, 781, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

