(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54671,       1770]
NotebookOptionsPosition[     46740,       1496]
NotebookOutlinePosition[     48336,       1538]
CellTagsIndexPosition[     48250,       1533]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToeplitzMatrix" :> 
          Documentation`HelpLookup["paclet:ref/ToeplitzMatrix"], 
          "HilbertMatrix" :> 
          Documentation`HelpLookup["paclet:ref/HilbertMatrix"], "Table" :> 
          Documentation`HelpLookup["paclet:ref/Table"], "PadRight" :> 
          Documentation`HelpLookup["paclet:ref/PadRight"], "Band" :> 
          Documentation`HelpLookup["paclet:ref/Band"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ToeplitzMatrix\"\>", 2->"\<\"HilbertMatrix\"\>", 
       3->"\<\"Table\"\>", 4->"\<\"PadRight\"\>", 
       5->"\<\"Band\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "New in 6.0: Matrix & Linear Algebra Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructing Matrices\"\>", 
       2->"\<\"New in 6.0: Matrix & Linear Algebra Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HankelMatrix", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HankelMatrix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HankelMatrix"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " Hankel matrix with first row and first column being successive \
integers."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HankelMatrix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HankelMatrix"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"], ",", 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["n", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Hankel matrix whose first column consists of \
elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HankelMatrix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HankelMatrix"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["c", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["c", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["c", "TI"], 
           StyleBox["m", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", " ", 
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["n", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Hankel matrix with elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " down the first column, and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " across the last row."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The element ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["m", "TI"]]], "InlineFormula"],
 " must be the same as ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->752609156]
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->36093151],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->329695914],

Cell["4\[Times]4 Hankel matrix:", "ExampleText",
 CellID->186515667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HankelMatrix", "[", "4", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->771626980],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3", "4"},
     {"2", "3", "4", "0"},
     {"3", "4", "0", "0"},
     {"4", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$298]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->83432830]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->190130345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HankelMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->644590182],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "b", "c", "d"},
     {"b", "c", "d", "0"},
     {"c", "d", "0", "0"},
     {"d", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$314]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->6938325]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133129065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HankelMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}], "//",
   "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21007815],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"x", "y", "z", "a", "b"},
     {"y", "z", "a", "b", "c"},
     {"z", "a", "b", "c", "d"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$185913]]]], "Output",
 ImageSize->{91, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->939518761]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Make a Hankel matrix of machine numbers:", "ExampleText",
 CellID->253118307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"HankelMatrix", "[", "3", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511714076],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "2.`", ",", "3.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "3.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "0.`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68547435]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HankelMatrix", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.", ",", "2.", ",", "3."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.", ",", "2.", ",", "1."}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43756196],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "2.`", ",", "3.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "3.`", ",", "2.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "2.`", ",", "1.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->205728365]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11550567],

Cell["Make a Hankel matrix with 24-digit precision:", "ExampleText",
 CellID->114867183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"HankelMatrix", "[", "3", "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->600242088],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`20.", ",", "2.`20.", ",", "3.`20."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`20.", ",", "3.`20.", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`20.", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{564, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23820607]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HankelMatrix", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1`20", ",", "2`20", ",", "3`20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3`20", ",", "2`20", ",", "1`20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->130535279],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`20.", ",", "2.`20.", ",", "3.`20."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`20.", ",", "3.`20.", ",", "2.`20."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`20.", ",", "2.`20.", ",", "1.`20."}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{496, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->309625038]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235476933],

Cell["Complex entries:", "ExampleText",
 CellID->464618776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HankelMatrix", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "I"}]}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"4", " ", "I"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45420817],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"4", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"4", " ", "\[ImaginaryI]"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", 
      RowBox[{"4", " ", "\[ImaginaryI]"}]}], ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{366, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273508997]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HankelMatrix", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "I"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"4", " ", "I"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", 
      RowBox[{"4", "I"}]}], ",", 
     RowBox[{"5", "+", 
      RowBox[{"6", " ", "I"}]}], ",", 
     RowBox[{"7", "+", 
      RowBox[{"8", " ", "I"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->319257755],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"4", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"4", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"5", "+", 
      RowBox[{"6", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", 
      RowBox[{"4", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"5", "+", 
      RowBox[{"6", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"7", "+", 
      RowBox[{"8", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{458, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->452218117]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13569945],

Cell["Non-square Hankel matrices:", "ExampleText",
 CellID->385242668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HankelMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6", ",", "0", ",", "0", ",", "0"}], "}"}]}],
    "]"}], " ", "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->830605010],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3", "4", "5", "6"},
     {"2", "3", "4", "5", "6", "0"},
     {"3", "4", "5", "6", "0", "0"},
     {"4", "5", "6", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{106, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->157527058]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HankelMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"6", ",", "0", ",", "0", ",", "0"}], "}"}]}], "]"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->355020002],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3", "4"},
     {"2", "3", "4", "5"},
     {"3", "4", "5", "6"},
     {"4", "5", "6", "0"},
     {"5", "6", "0", "0"},
     {"6", "0", "0", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{76, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->208165229]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["Size-20 Hankel matrix:", "ExampleText",
 CellID->462478930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"HankelMatrix", "[", "20", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->439346617],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWz2IE0EUnmSTzJwiQmyM3mnOSmzsrMRG1Oo6OwsJh3AnqOfdFYoIaqGg
iGghcpVga3mCla2NCCKIhXqKnn+NlY3N+mb2bTJ5M5PZJJuwnrOQmX3Z977v
ZefNzJvZ7Exree7Umdby/GyreWyxtTA3P7vUPHpuEb6KSoyxVfg83c7gPIYz
9VmNY6jNsg5lBAoNrJtYl6EuQ70LZVZR6nhMgVDRtOrq4jZZSuVYHWwnkSUW
q3TkxF7XmCRyZEOsJnK7NFC2jsmbSS/CuDyZ0uTsd6SBrTedjb+jgXbNgVl1
uZmNvaqzM4xMVtPterVBHX2exHo31lHcifMyhnkZI1y/nkS4qxdtgXKFJTWW
mgcVIu8g8h6PPO3B21wg1vtWLX2sqBINHp9ldyiXph8lzVrT29je0lRuI0+Q
2NFLZSUHzZKs1Xfl1IW2QWYmqmOgdDPp/djWg6QsRYl/G8+rFpv+UX3e2zC6
WbL0PSeT8+46uDAImNYjnXFkjFNRrEcSjVjbr7fHNv+zxARo3wjag2r/vsAE
WMh7fiVY5G3x6zITYMXR6mKwKrbVz6slAZYcLWU/Oh8sx2yZTCTpkaoYs8v6
9ZIATI6Yac88LS92zTjmaimZd+hcSHN4Y67sxdjDTuJa8pnCMqv8xsE4h9dp
7ulgMmb+vlrRnbvFev6grhmrkdowTAYaho+W9aTrEnonsselvrpRrGafWbtV
EoDHEU8f0WaJrqPXBYSNhPDuHheAwhGFjqcnAspGQfmw0hCAxBHJNqIcD0gb
Henjo30C0DiiuUaPmYAW0AZA686KnfuBnx8fFMDDkafX6HZEGhjZd/fO4QC7
ef164M4c2eD7iyov7sOTw7GWK+fiQfHuyf/tUaZd0KF6T4bd0vUnMwI4OHL4
Zp5DxN4xrgTUgPrt2UkByByRffOMjOADATkgFxX5x/MFAegc0X2jctpb9gf0
gD4a9O8vLglg4MjgG8P1jH5vYAgMI2WQmWxky2i/vrwmgI0jm2+0plluk+DJ
U6EYBbli5PN5MxO5WnAv1Ap0SPb0/4O0VRNW+dTEuorJ4zcbKxvR5tS5jCcq
eXAbT3QmVM1jx1OcnNs43QHh9r6bM5tjhPjy6qYAJo5MvnnNtnKg/xUMTIGp
YEyfXt8VwMaRzTcnunZM64EtsP2bbGtvHghg5Mjom1l67UhuCoyBMTD2xSjz
2ciWU75/+1AAO0d233zo28VV6wbjWVuSYXLCTdcYI/Glx5qp5vRK+ZyzN93P
NWk7uH0p5h0KXtm9cq5VR97POmvXYrzjMz7WzjtVrjevwluMw3oT3mIclFWX
yY6Ti72gbzGy0l/gvFPA\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62232944]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->469931605],

Cell[TextData[{
 "The determinant of the Hankel matrix of size ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"\[LeftFloor]", 
      FractionBox["n", "2"], "\[RightFloor]"}]], " ", 
    SuperscriptBox["n", "n"]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->120885024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"Det", "[", 
       RowBox[{"HankelMatrix", "[", "n", "]"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "^", 
        RowBox[{"Floor", "[", 
         RowBox[{"n", "/", "2"}], "]"}]}], " ", 
       RowBox[{"n", "^", "n"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->106921072],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "1", "1"},
    {"2", 
     RowBox[{"-", "4"}], 
     RowBox[{"-", "4"}]},
    {"3", 
     RowBox[{"-", "27"}], 
     RowBox[{"-", "27"}]},
    {"4", "256", "256"},
    {"5", "3125", "3125"},
    {"6", 
     RowBox[{"-", "46656"}], 
     RowBox[{"-", "46656"}]},
    {"7", 
     RowBox[{"-", "823543"}], 
     RowBox[{"-", "823543"}]},
    {"8", "16777216", "16777216"},
    {"9", "387420489", "387420489"},
    {"10", 
     RowBox[{"-", "10000000000"}], 
     RowBox[{"-", "10000000000"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{218, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->111316164]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119183907],

Cell["A square Hankel matrix with real entries is symmetric:", "ExampleText",
 CellID->533964292],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"cr", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "9"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"Take", "[", 
    RowBox[{"cr", ",", "5"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"Take", "[", 
    RowBox[{"cr", ",", 
     RowBox[{"-", "5"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"h", "=", 
  RowBox[{"HankelMatrix", "[", 
   RowBox[{"c", ",", "r"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->314287824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.22051134774204928`", ",", "0.9857036712422267`", ",", 
     "0.9686227802465519`", ",", "0.4168247603446116`", ",", 
     "0.41208242901332715`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9857036712422267`", ",", "0.9686227802465519`", ",", 
     "0.4168247603446116`", ",", "0.41208242901332715`", ",", 
     "0.7143305224694516`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.9686227802465519`", ",", "0.4168247603446116`", ",", 
     "0.41208242901332715`", ",", "0.7143305224694516`", ",", 
     "0.24855100195072755`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.4168247603446116`", ",", "0.41208242901332715`", ",", 
     "0.7143305224694516`", ",", "0.24855100195072755`", ",", 
     "0.037872264369726016`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.41208242901332715`", ",", "0.7143305224694516`", ",", 
     "0.24855100195072755`", ",", "0.037872264369726016`", ",", 
     "0.834362218003825`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{364, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102994589]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermitianMatrixQ", "[", "h", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->137304951],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->139462838]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101783247],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["HankelMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HankelMatrix"], "[", 
   RowBox[{
    StyleBox["c", "TI"], ",", 
    RowBox[{
     ButtonBox["RotateRight",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RotateRight"], "[", 
     StyleBox["c", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " is a square anticirculant matrix:"
}], "ExampleText",
 CellID->502200555],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "4"}], "]"}]}], ";"}], "\n", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"h", "=", 
   RowBox[{"HankelMatrix", "[", 
    RowBox[{"c", ",", 
     RowBox[{"RotateRight", "[", "c", "]"}]}], "]"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->191097070],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.6394517084759064`", "0.24972388967593662`", "0.629975768000816`", 
      "0.7232329222170073`"},
     {"0.24972388967593662`", "0.629975768000816`", "0.7232329222170073`", 
      "0.6394517084759064`"},
     {"0.629975768000816`", "0.7232329222170073`", "0.6394517084759064`", 
      "0.24972388967593662`"},
     {"0.7232329222170073`", "0.6394517084759064`", "0.24972388967593662`", 
      "0.629975768000816`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{272, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->311778864]
}, Open  ]],

Cell[TextData[{
 "Square anticirculant matrices have eigenvector ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " with eigenvalue",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{
    SubscriptBox[
     StyleBox["c", "TI"], 
     StyleBox["1", "TR"]], "+", 
    SubscriptBox[
     StyleBox["c", "TI"], 
     StyleBox["2", "TR"]], "+", 
    StyleBox["\[Ellipsis]", "TR"]}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->386255529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"h", ".", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"1", ",", "4"}], "]"}]}], "/", 
  RowBox[{"Total", "[", "c", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->569017930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "1.`", ",", "1.`", ",", "1.`"}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->512570536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->581219043],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HankelMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HankelMatrix"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ToeplitzMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToeplitzMatrix"]], "InlineFormula"],
 " are related by a reversed identity matrix: "
}], "ExampleText",
 CellID->222524165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"h", "=", 
    RowBox[{"HankelMatrix", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["a", "2"], ",", 
        SubscriptBox["a", "1"], ",", 
        SubscriptBox["a", "0"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["a", "0"], ",", 
        SubscriptBox["a", 
         RowBox[{"-", "1"}]], ",", 
        SubscriptBox["a", 
         RowBox[{"-", "2"}]]}], "}"}]}], "]"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360176644],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdVjtPAzEMTu9BgfLog5eY2PkfMCBGfkCFkGBAIGDo1rFjx479CR07duzY
sWPHjh07HnbscDnjwqETCKjUJPbZzpf4EV82X25v7psvd9fNk/On5uPt3fXz
ydnDE7DCkjHmCv6nRwbWCazs/ypJYKaxjmOIXPsz+zDEQB7AjOxtKxVbqX6/
z1IbnhaM1koEcyCs1ZhvQhLEcd3KtNttlqFPkV1Op9PhcIjLiHHQB7fRFnPL
Yp/KCv6awz2ZTORevV7PRxC/afGZ/LMgXVGl1sWOm7mkCNdyuWy1Wimu0HEJ
GuH8VlxlYYu0Op0OgMBl8IYrGI/Ha+zNULn9iK0FHDORgoF2AweDm7PWrTfm
8/nqU1dV7r7KpZhOY8nfJ407jOmQpXE+5LnhvEDhvkL7wqFmuvSBVEr/RymM
rNi8ryTHzJf5rlvZEto1jzbsHa3C5LMeMxap7epGtsrUEr2a5NtLj1+ZM3o+
ytzWo17m1d/Ghb5xnvWrh0RWTbJVZrPAqb9STRq5T6FVk71c2r81t39eqsL3
5nLwMMlGge1Hwm63+6kVX6sh6AOPRh/vWDrtb3yrUOMXi0WSo4pIfjXRqgud
YDabDQYDXPrvCzxY3KkUyVYptatKyZwmXKPRSHmd4QIYbZGepAgu8HimJ5E9
HNIf9SauutRXyNH7k0ZQuksAHileRTCeA7hDCoVYoEc0WvWoK3JOm9olXJ4L
mqT8Lt+UXgHpP8ZJ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{85, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->499074947]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToeplitzMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["a", "0"], ",", 
      SubscriptBox["a", "1"], ",", 
      SubscriptBox["a", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["a", "0"], ",", 
      SubscriptBox["a", 
       RowBox[{"-", "1"}]], ",", 
      SubscriptBox["a", 
       RowBox[{"-", "2"}]]}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16341238],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdVj1TAjEQDfchyMHIh6JjRe//kMKx5AfcMMxA4eggBR0lJSUlP4GSkpKS
kpKSkpIybpINyYXceYo6DszcJXnsbV6ym5d9Dvud9kvY77bCeqMXvnW6rff6
42sPIDdDCGnC83BHoE+hx58mpdCKdxneLhGtD+0tQxlA+Y/jhPgcnU6niF4a
VlVjXNPG8CYFPh4Oh/i/y3GPd9fr9Xw+Z10POTiGtyAGLyEuHMnJCpLrarUy
55pMJjoD/+ALebrGDPlUVldWK52t2oP9fj8YDBQvV6KCmuD5qa/gB3kV+Xg0
GgEJ1nUOvJzlcnkBrWfxHSDOrB1oKzF2YtUQYAhz1DuPxna7jV91yYreWNEK
jeaSPo/KO5bHLlq7mO2srcooiBSP+fpJssZxJsFKjc/Rip0L/7DrKtr3iOdS
eSkYX5e1McHoeOT43Kfz7tNkNYmqhtS/7LfmsudvOjUxz6M963NnxYvFRleP
IrWrRwnxLNrlT1j1V9SkmnoVNjW5TvX1fz3bf29l6gCLCQtJDfdTVBvj8TjR
S6B5kTeCTT3KiOMFzM1FXqn6Rp8B9H6321FNUY7rDZtyBDG4GG82m9lsxrr6
XQOXF1Ytp9QB5pm0n2/TSvBaLBaWmxo2ANn+Pq+s4Ssnox+pT8x6zqPJdYpU
EKk09tWrbFKzOBCR0xWFZZ0DeyhSxzfYM9Y2JalY7OTXonRi3YYxFlZ6lU8y
H9Umxkk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{85, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->105582444]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Reverse", "[", 
    RowBox[{"IdentityMatrix", "[", "3", "]"}], "]"}], ".", "h"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->44023477],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdVj1TAjEQDfchyMHIh6JjRe//kMKx5AfcMMxA4eggBR0lJSUlP4GSkpKS
kpKSkpIybpINyYXceYo6DszcJXnsbV6ym5d9Dvud9kvY77bCeqMXvnW6rff6
42sPIDdDCGnC83BHoE+hx58mpdCKdxneLhGtD+0tQxlA+Y/jhPgcnU6niF4a
VlVjXNPG8CYFPh4Oh/i/y3GPd9fr9Xw+Z10POTiGtyAGLyEuHMnJCpLrarUy
55pMJjoD/+ALebrGDPlUVldWK52t2oP9fj8YDBQvV6KCmuD5qa/gB3kV+Xg0
GgEJ1nUOvJzlcnkBrWfxHSDOrB1oKzF2YtUQYAhz1DuPxna7jV91yYreWNEK
jeaSPo/KO5bHLlq7mO2srcooiBSP+fpJssZxJsFKjc/Rip0L/7DrKtr3iOdS
eSkYX5e1McHoeOT43Kfz7tNkNYmqhtS/7LfmsudvOjUxz6M963NnxYvFRleP
IrWrRwnxLNrlT1j1V9SkmnoVNjW5TvX1fz3bf29l6gCLCQtJDfdTVBvj8TjR
S6B5kTeCTT3KiOMFzM1FXqn6Rp8B9H6321FNUY7rDZtyBDG4GG82m9lsxrr6
XQOXF1Ytp9QB5pm0n2/TSvBaLBaWmxo2ANn+Pq+s4Ssnox+pT8x6zqPJdYpU
EKk09tWrbFKzOBCR0xWFZZ0DeyhSxzfYM9Y2JalY7OTXonRi3YYxFlZ6lU8y
H9Umxkk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{85, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->248242279]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 "If element ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["m", "TI"]]], "InlineFormula"],
 " is not the same as ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["m", "TI"]]], "InlineFormula"],
 " is used and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " is ignored:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->752609156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HankelMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}], " ", "//", 
  " ", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43032898],

Cell[BoxData[
 RowBox[{
  RowBox[{"HankelMatrix", "::", "\<\"crs\"\>"}], ":", 
  " ", "\<\"Warning: The column element \\!\\(4\\) and row element \\!\\(a\\) \
at positions \\!\\(4\\) and \\!\\(1\\) are not the same. Using column \
element.\"\>"}]], "Message", "MSG",
 CellID->40175806],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3", "4"},
     {"2", "3", "4", "b"},
     {"3", "4", "b", "c"},
     {"4", "b", "c", "d"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->133844429]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"HankelMatrix", "[", "15", "]"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176375359],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{248, 201},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160417728]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToeplitzMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToeplitzMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HilbertMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HilbertMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadRight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Band",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Band"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15690418]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->902260942],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "MoreAbout",
 CellID->266228952]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HankelMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 23.8970738}", "context" -> "System`", 
    "keywords" -> {
     "anti banded matrix", "structured matrix", "matrix constructor", 
      "constructing matrices"}, "index" -> True, "label" -> 
    "Mathematica Symbol", "language" -> "en", "paclet" -> "", "status" -> 
    "None", "summary" -> 
    "HankelMatrix[n] gives the n*n Hankel matrix with first row and first \
column being successive integers. HankelMatrix[{c_1, c_2, ..., c_n}] gives \
the Hankel matrix whose first column consists of elements c_1, c_2, .... \
HankelMatrix[{c_1, c_2, ..., c_m}, {r_1, r_2, ..., r_n}] gives the Hankel \
matrix with elements c_i down the first column, and r_i across the last row.",
     "synonyms" -> {}, "title" -> "HankelMatrix", "type" -> "Symbol", "uri" -> 
    "ref/HankelMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6483, 213, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->36093151]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 48108, 1526}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1800, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2423, 68, 55, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2481, 71, 3065, 99, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5583, 175, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6061, 192, 385, 16, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[6483, 213, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->36093151],
Cell[CellGroupData[{
Cell[6867, 227, 148, 5, 70, "ExampleSection",
 CellID->329695914],
Cell[7018, 234, 68, 1, 70, "ExampleText",
 CellID->186515667],
Cell[CellGroupData[{
Cell[7111, 239, 141, 4, 28, "Input",
 CellID->771626980],
Cell[7255, 245, 816, 24, 92, "Output",
 CellID->83432830]
}, Open  ]],
Cell[8086, 272, 125, 3, 70, "ExampleDelimiter",
 CellID->190130345],
Cell[CellGroupData[{
Cell[8236, 279, 213, 7, 70, "Input",
 CellID->644590182],
Cell[8452, 288, 815, 24, 92, "Output",
 CellID->6938325]
}, Open  ]],
Cell[9282, 315, 125, 3, 70, "ExampleDelimiter",
 CellID->133129065],
Cell[CellGroupData[{
Cell[9432, 322, 309, 10, 70, "Input",
 CellID->21007815],
Cell[9744, 334, 808, 23, 78, "Output",
 CellID->939518761]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10601, 363, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[10825, 372, 83, 1, 70, "ExampleText",
 CellID->253118307],
Cell[CellGroupData[{
Cell[10933, 377, 136, 4, 70, "Input",
 CellID->511714076],
Cell[11072, 383, 408, 13, 36, "Output",
 CellID->68547435]
}, Open  ]],
Cell[CellGroupData[{
Cell[11517, 401, 254, 8, 70, "Input",
 CellID->43756196],
Cell[11774, 411, 409, 13, 36, "Output",
 CellID->205728365]
}, Open  ]],
Cell[12198, 427, 124, 3, 70, "ExampleDelimiter",
 CellID->11550567],
Cell[12325, 432, 88, 1, 70, "ExampleText",
 CellID->114867183],
Cell[CellGroupData[{
Cell[12438, 437, 161, 5, 70, "Input",
 CellID->600242088],
Cell[12602, 444, 420, 13, 54, "Output",
 CellID->23820607]
}, Open  ]],
Cell[CellGroupData[{
Cell[13059, 462, 267, 8, 70, "Input",
 CellID->130535279],
Cell[13329, 472, 439, 14, 71, "Output",
 CellID->309625038]
}, Open  ]],
Cell[13783, 489, 125, 3, 70, "ExampleDelimiter",
 CellID->235476933],
Cell[13911, 494, 59, 1, 70, "ExampleText",
 CellID->464618776],
Cell[CellGroupData[{
Cell[13995, 499, 266, 9, 70, "Input",
 CellID->45420817],
Cell[14264, 510, 719, 24, 36, "Output",
 CellID->273508997]
}, Open  ]],
Cell[CellGroupData[{
Cell[15020, 539, 509, 18, 70, "Input",
 CellID->319257755],
Cell[15532, 559, 911, 29, 36, "Output",
 CellID->452218117]
}, Open  ]],
Cell[16458, 591, 124, 3, 70, "ExampleDelimiter",
 CellID->13569945],
Cell[16585, 596, 70, 1, 70, "ExampleText",
 CellID->385242668],
Cell[CellGroupData[{
Cell[16680, 601, 336, 10, 70, "Input",
 CellID->830605010],
Cell[17019, 613, 840, 24, 92, "Output",
 CellID->157527058]
}, Open  ]],
Cell[CellGroupData[{
Cell[17896, 642, 340, 11, 70, "Input",
 CellID->355020002],
Cell[18239, 655, 853, 26, 122, "Output",
 CellID->208165229]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19141, 687, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[19382, 696, 65, 1, 70, "ExampleText",
 CellID->462478930],
Cell[CellGroupData[{
Cell[19472, 701, 146, 4, 70, "Input",
 CellID->439346617],
Cell[19621, 707, 1574, 30, 70, "Output",
 Evaluatable->False,
 CellID->62232944]
}, Open  ]],
Cell[21210, 740, 125, 3, 70, "ExampleDelimiter",
 CellID->469931605],
Cell[21338, 745, 444, 16, 70, "ExampleText",
 CellID->120885024],
Cell[CellGroupData[{
Cell[21807, 765, 557, 18, 70, "Input",
 CellID->106921072],
Cell[22367, 785, 1131, 39, 182, "Output",
 CellID->111316164]
}, Open  ]],
Cell[23513, 827, 125, 3, 70, "ExampleDelimiter",
 CellID->119183907],
Cell[23641, 832, 97, 1, 70, "ExampleText",
 CellID->533964292],
Cell[CellGroupData[{
Cell[23763, 837, 511, 18, 70, "Input",
 CellID->314287824],
Cell[24277, 857, 1176, 32, 105, "Output",
 CellID->102994589]
}, Open  ]],
Cell[CellGroupData[{
Cell[25490, 894, 112, 3, 70, "Input",
 CellID->137304951],
Cell[25605, 899, 161, 5, 36, "Output",
 CellID->139462838]
}, Open  ]],
Cell[25781, 907, 125, 3, 70, "ExampleDelimiter",
 CellID->101783247],
Cell[25909, 912, 443, 15, 70, "ExampleText",
 CellID->502200555],
Cell[CellGroupData[{
Cell[26377, 931, 351, 11, 70, "Input",
 CellID->191097070],
Cell[26731, 944, 1116, 28, 92, "Output",
 CellID->311778864]
}, Open  ]],
Cell[27862, 975, 505, 19, 70, "ExampleText",
 CellID->386255529],
Cell[CellGroupData[{
Cell[28392, 998, 213, 7, 70, "Input",
 CellID->569017930],
Cell[28608, 1007, 232, 7, 36, "Output",
 CellID->512570536]
}, Open  ]],
Cell[28855, 1017, 125, 3, 70, "ExampleDelimiter",
 CellID->581219043],
Cell[28983, 1022, 370, 12, 70, "ExampleText",
 CellID->222524165],
Cell[CellGroupData[{
Cell[29378, 1038, 567, 20, 70, "Input",
 CellID->360176644],
Cell[29948, 1060, 971, 20, 70, "Output",
 Evaluatable->False,
 CellID->499074947]
}, Open  ]],
Cell[CellGroupData[{
Cell[30956, 1085, 490, 17, 70, "Input",
 CellID->16341238],
Cell[31449, 1104, 963, 20, 70, "Output",
 Evaluatable->False,
 CellID->105582444]
}, Open  ]],
Cell[CellGroupData[{
Cell[32449, 1129, 205, 7, 70, "Input",
 CellID->44023477],
Cell[32657, 1138, 963, 20, 70, "Output",
 Evaluatable->False,
 CellID->248242279]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33669, 1164, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[33903, 1173, 584, 24, 70, "ExampleText",
 CellID->752609156],
Cell[CellGroupData[{
Cell[34512, 1201, 319, 10, 70, "Input",
 CellID->43032898],
Cell[34834, 1213, 285, 6, 70, "Message",
 CellID->40175806],
Cell[35122, 1221, 799, 24, 92, "Output",
 CellID->133844429]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35970, 1251, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[CellGroupData[{
Cell[36223, 1262, 263, 7, 70, "Input",
 CellID->176375359],
Cell[36489, 1271, 7939, 134, 70, "Output",
 Evaluatable->False,
 CellID->160417728]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44489, 1412, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[44808, 1423, 1197, 44, 70, "SeeAlso",
 CellID->15690418]
}, Open  ]],
Cell[CellGroupData[{
Cell[46042, 1472, 299, 8, 70, "MoreAboutSection"],
Cell[46344, 1482, 153, 3, 70, "MoreAbout",
 CellID->902260942],
Cell[46500, 1487, 198, 4, 70, "MoreAbout",
 CellID->266228952]
}, Open  ]],
Cell[46713, 1494, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

