(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19889,        789]
NotebookOptionsPosition[     14772,        600]
NotebookOutlinePosition[     15947,        635]
CellTagsIndexPosition[     15862,        630]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Everything Is an Expression" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EverythingIsAnExpression"], 
          "Specifying Types of Expression in Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecifyingTypesOfExpressionInPatterns"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Everything Is an Expression\"\>", 
       2->"\<\"Specifying Types of Expression in Patterns\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Level" :> Documentation`HelpLookup["paclet:ref/Level"], "Part" :> 
          Documentation`HelpLookup["paclet:ref/Part"], "Heads" :> 
          Documentation`HelpLookup["paclet:ref/Heads"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Level\"\>", 2->"\<\"Part\"\>", 
       3->"\<\"Heads\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Expression Structure" :> 
          Documentation`HelpLookup["paclet:guide/ExpressionStructure"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Atomic Elements of Expressions\"\>", 2->"\<\"Expressions\"\>", 
       3->"\<\"Expression Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Head", "ObjectName",
 CellID->10832],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Head",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Head"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the head of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26781]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->27604734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28841],

Cell[BoxData["f"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4404]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"a", "+", "b", "+", "c"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15729],

Cell[BoxData["Plus"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19215]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30565],

Cell[BoxData["List"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3650]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "45", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3083],

Cell[BoxData["Integer"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29719]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18296],

Cell[BoxData["Symbol"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24439]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5241],

Cell["Heads need not be symbols:", "ExampleText",
 CellID->20803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "[", "y", "]"}], "[", "z", "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6006],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x", "]"}], "[", "y", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22620]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7849],

Cell[TextData[{
 "Find cases with heads that are ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "x", ",", "3", ",", "y"}], "}"}], ",", 
   "_Integer"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4524],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25078]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11787],

Cell["Define a function that only applies to individual symbols:", \
"ExampleText",
 CellID->21984],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "u_Symbol", "]"}], ":=", 
  RowBox[{"u", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12629]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->139],

Cell[TextData[{
 "The head is the part with index ",
 Cell[BoxData["0"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "+", "b", "+", "c"}], ")"}], "[", 
  RowBox[{"[", "0", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19973],

Cell[BoxData["Plus"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22638]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3815],

Cell[TextData[{
 "The head is based on ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"a", "/", "b"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24041],

Cell[BoxData["Times"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24485]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"a", "/", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15063],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{"a", ",", 
     RowBox[{"Power", "[", 
      RowBox[{"b", ",", 
       RowBox[{"-", "1"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->22211]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18827],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Head",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Head"]], "InlineFormula"],
 " always eventually burrows to a symbol:"
}], "ExampleText",
 CellID->9583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{"Head", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "[", "y", "]"}], "[", "z", "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3930],

Cell[BoxData["Symbol"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26565]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{"Head", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12082],

Cell[BoxData["Symbol"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27982]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8324],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Level",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Level"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15006]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30837],

Cell[TextData[ButtonBox["Everything Is an Expression",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EverythingIsAnExpression"]], "Tutorials",
 CellID->27427],

Cell[TextData[ButtonBox["Specifying Types of Expression in Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecifyingTypesOfExpressionInPatterns"]], "Tutorials",
 CellID->83007426]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Head",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Head"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->200900672],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->363339721],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->675306402],

Cell[TextData[ButtonBox["Expression Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExpressionStructure"]], "MoreAbout",
 CellID->454177390]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Head - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 26.8190236}", "context" -> "System`", 
    "keywords" -> {"function name", "names of operators"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Head[expr] gives the head of expr. ", "synonyms" -> {}, "title" -> 
    "Head", "type" -> "Symbol", "uri" -> "ref/Head"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3683, 110, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15727, 623}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2444, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3067, 84, 42, 1, 70, "ObjectName",
 CellID->10832],
Cell[3112, 87, 534, 18, 70, "Usage",
 CellID->26781]
}, Open  ]],
Cell[CellGroupData[{
Cell[3683, 110, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4060, 124, 147, 5, 70, "ExampleSection",
 CellID->27604734],
Cell[CellGroupData[{
Cell[4232, 133, 148, 5, 28, "Input",
 CellID->28841],
Cell[4383, 140, 153, 5, 36, "Output",
 CellID->4404]
}, Open  ]],
Cell[CellGroupData[{
Cell[4573, 150, 129, 4, 28, "Input",
 CellID->15729],
Cell[4705, 156, 157, 5, 36, "Output",
 CellID->19215]
}, Open  ]],
Cell[CellGroupData[{
Cell[4899, 166, 153, 5, 28, "Input",
 CellID->30565],
Cell[5055, 173, 156, 5, 36, "Output",
 CellID->3650]
}, Open  ]],
Cell[5226, 181, 121, 3, 70, "ExampleDelimiter",
 CellID->25532],
Cell[CellGroupData[{
Cell[5372, 188, 96, 3, 28, "Input",
 CellID->3083],
Cell[5471, 193, 160, 5, 36, "Output",
 CellID->29719]
}, Open  ]],
Cell[CellGroupData[{
Cell[5668, 203, 96, 3, 70, "Input",
 CellID->18296],
Cell[5767, 208, 159, 5, 36, "Output",
 CellID->24439]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5975, 219, 238, 7, 70, "ExampleSection",
 CellID->5241],
Cell[6216, 228, 65, 1, 70, "ExampleText",
 CellID->20803],
Cell[CellGroupData[{
Cell[6306, 233, 185, 7, 70, "Input",
 CellID->6006],
Cell[6494, 242, 209, 7, 36, "Output",
 CellID->22620]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[6752, 255, 222, 7, 70, "ExampleSection",
 CellID->7849],
Cell[6977, 264, 208, 8, 70, "ExampleText",
 CellID->19205],
Cell[CellGroupData[{
Cell[7210, 276, 209, 7, 70, "Input",
 CellID->4524],
Cell[7422, 285, 209, 7, 36, "Output",
 CellID->25078]
}, Open  ]],
Cell[7646, 295, 121, 3, 70, "ExampleDelimiter",
 CellID->11787],
Cell[7770, 300, 99, 2, 70, "ExampleText",
 CellID->21984],
Cell[7872, 304, 147, 5, 70, "Input",
 CellID->12629]
}, Closed]],
Cell[CellGroupData[{
Cell[8056, 314, 231, 7, 70, "ExampleSection",
 CellID->139],
Cell[8290, 323, 129, 5, 70, "ExampleText",
 CellID->7898],
Cell[CellGroupData[{
Cell[8444, 332, 173, 6, 70, "Input",
 CellID->19973],
Cell[8620, 340, 157, 5, 36, "Output",
 CellID->22638]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8826, 351, 225, 7, 70, "ExampleSection",
 CellID->3815],
Cell[9054, 360, 200, 8, 70, "ExampleText",
 CellID->21002],
Cell[CellGroupData[{
Cell[9279, 372, 119, 4, 70, "Input",
 CellID->24041],
Cell[9401, 378, 158, 5, 36, "Output",
 CellID->24485]
}, Open  ]],
Cell[CellGroupData[{
Cell[9596, 388, 123, 4, 70, "Input",
 CellID->15063],
Cell[9722, 394, 429, 16, 50, "Output",
 CellID->22211]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10200, 416, 224, 7, 70, "ExampleSection",
 CellID->18827],
Cell[10427, 425, 203, 7, 70, "ExampleText",
 CellID->9583],
Cell[CellGroupData[{
Cell[10655, 436, 220, 8, 70, "Input",
 CellID->3930],
Cell[10878, 446, 159, 5, 36, "Output",
 CellID->26565]
}, Open  ]],
Cell[CellGroupData[{
Cell[11074, 456, 187, 6, 70, "Input",
 CellID->12082],
Cell[11264, 464, 159, 5, 36, "Output",
 CellID->27982]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11484, 476, 310, 9, 70, "SeeAlsoSection",
 CellID->8324],
Cell[11797, 487, 676, 26, 70, "SeeAlso",
 CellID->15006]
}, Open  ]],
Cell[CellGroupData[{
Cell[12510, 518, 314, 9, 70, "TutorialsSection",
 CellID->30837],
Cell[12827, 529, 162, 3, 70, "Tutorials",
 CellID->27427],
Cell[12992, 534, 196, 4, 70, "Tutorials",
 CellID->83007426]
}, Open  ]],
Cell[CellGroupData[{
Cell[13225, 543, 305, 8, 70, "RelatedLinksSection"],
Cell[13533, 553, 348, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13918, 569, 319, 9, 70, "MoreAboutSection",
 CellID->200900672],
Cell[14240, 580, 169, 3, 70, "MoreAbout",
 CellID->363339721],
Cell[14412, 585, 134, 3, 70, "MoreAbout",
 CellID->675306402],
Cell[14549, 590, 151, 3, 70, "MoreAbout",
 CellID->454177390]
}, Open  ]],
Cell[14715, 596, 27, 0, 70, "History"],
Cell[14745, 598, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

