(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15286,        568]
NotebookOptionsPosition[     11796,        446]
NotebookOutlinePosition[     13111,        484]
CellTagsIndexPosition[     13026,        479]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Levels in Expressions" :> 
          Documentation`HelpLookup["paclet:tutorial/LevelsInExpressions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Levels in Expressions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Level" :> Documentation`HelpLookup["paclet:ref/Level"], "Head" :> 
          Documentation`HelpLookup["paclet:ref/Head"], "Apply" :> 
          Documentation`HelpLookup["paclet:ref/Apply"], "MapAll" :> 
          Documentation`HelpLookup["paclet:ref/MapAll"], "Position" :> 
          Documentation`HelpLookup["paclet:ref/Position"], "Replace" :> 
          Documentation`HelpLookup["paclet:ref/Replace"], "FreeQ" :> 
          Documentation`HelpLookup["paclet:ref/FreeQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Level\"\>", 2->"\<\"Head\"\>", 
       3->"\<\"Apply\"\>", 4->"\<\"MapAll\"\>", 5->"\<\"Position\"\>", 
       6->"\<\"Replace\"\>", 7->"\<\"FreeQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Parts of Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Heads", "ObjectName",
 CellID->30883],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Heads",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Heads"]], "InlineFormula"],
     "\[LineSeparator]is an option for functions which use level \
specifications that specifies whether heads of expressions should be \
included. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15905]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Heads", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " treats heads just like other elements of expressions for the purpose of \
levels. "
}], "Notes",
 CellID->15847],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Heads", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " never includes heads as part of any level of an expression. "
}], "Notes",
 CellID->29313],

Cell[TextData[{
 "Most functions which use level specifications have the default setting ",
 Cell[BoxData[
  RowBox[{"Heads", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ". One exception is ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 ", for which the default is ",
 Cell[BoxData[
  RowBox[{"Heads", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2786]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->281952217],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->115569354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "1", ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4485],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"List", ",", "a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23592]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31022],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4733]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11383],

Cell[TextData[{
 "Map ",
 Cell[BoxData["f"], "InlineFormula"],
 " also onto the head:"
}], "ExampleText",
 CellID->9827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"h", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24499],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "h", "]"}], "[", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}]}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22090],

Cell["\<\
Parts inside heads are included if appropriate level specifications are \
given:\
\>", "ExampleText",
 CellID->17135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", "x", "]"}], "[", "y", "]"}], ",", "1", ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12100],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", "x", "]"}], ",", "y"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21479]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Level", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", "x", "]"}], "[", "y", "]"}], ",", "2", ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26573],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p", ",", "x", ",", 
   RowBox[{"p", "[", "x", "]"}], ",", "y"}], "}"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10906]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1970],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Level",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Level"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Head",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Head"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apply"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Position",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Position"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Replace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Replace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FreeQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->839]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26984],

Cell[TextData[ButtonBox["Levels in Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LevelsInExpressions"]], "Tutorials",
 CellID->14409]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->355787431]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Heads - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 27.0377792}", "context" -> "System`", 
    "keywords" -> {
     "include function names in levels", "include tags in levels"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Heads is an option for functions which use level specifications that \
specifies whether heads of expressions should be included. ", 
    "synonyms" -> {}, "title" -> "Heads", "type" -> "Symbol", "uri" -> 
    "ref/Heads"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5110, 165, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->281952217]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12883, 472}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2268, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2891, 79, 43, 1, 70, "ObjectName",
 CellID->30883],
Cell[2937, 82, 503, 15, 70, "Usage",
 CellID->15905]
}, Open  ]],
Cell[CellGroupData[{
Cell[3477, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3955, 119, 273, 9, 70, "Notes",
 CellID->15847],
Cell[4231, 130, 253, 8, 70, "Notes",
 CellID->29313],
Cell[4487, 140, 586, 20, 70, "Notes",
 CellID->2786]
}, Closed]],
Cell[CellGroupData[{
Cell[5110, 165, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->281952217],
Cell[CellGroupData[{
Cell[5495, 179, 148, 5, 70, "ExampleSection",
 CellID->115569354],
Cell[CellGroupData[{
Cell[5668, 188, 220, 7, 28, "Input",
 CellID->4485],
Cell[5891, 197, 223, 7, 36, "Output",
 CellID->23592]
}, Open  ]],
Cell[CellGroupData[{
Cell[6151, 209, 179, 6, 28, "Input",
 CellID->31022],
Cell[6333, 217, 208, 7, 36, "Output",
 CellID->4733]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6590, 230, 216, 7, 70, "ExampleSection",
 CellID->11383],
Cell[6809, 239, 120, 5, 70, "ExampleText",
 CellID->9827],
Cell[CellGroupData[{
Cell[6954, 248, 214, 7, 70, "Input",
 CellID->24499],
Cell[7171, 257, 290, 10, 36, "Output",
 CellID->3061]
}, Open  ]],
Cell[7476, 270, 121, 3, 70, "ExampleDelimiter",
 CellID->22090],
Cell[7600, 275, 127, 4, 70, "ExampleText",
 CellID->17135],
Cell[CellGroupData[{
Cell[7752, 283, 221, 7, 70, "Input",
 CellID->12100],
Cell[7976, 292, 228, 8, 36, "Output",
 CellID->21479]
}, Open  ]],
Cell[CellGroupData[{
Cell[8241, 305, 221, 7, 70, "Input",
 CellID->26573],
Cell[8465, 314, 249, 8, 36, "Output",
 CellID->10906]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8775, 329, 310, 9, 70, "SeeAlsoSection",
 CellID->1970],
Cell[9088, 340, 1642, 62, 70, "SeeAlso",
 CellID->839]
}, Open  ]],
Cell[CellGroupData[{
Cell[10767, 407, 314, 9, 70, "TutorialsSection",
 CellID->26984],
Cell[11084, 418, 151, 3, 70, "Tutorials",
 CellID->14409]
}, Open  ]],
Cell[CellGroupData[{
Cell[11272, 426, 299, 8, 70, "MoreAboutSection"],
Cell[11574, 436, 150, 3, 70, "MoreAbout",
 CellID->355787431]
}, Open  ]],
Cell[11739, 442, 27, 0, 70, "History"],
Cell[11769, 444, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

