(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    213607,       4750]
NotebookOptionsPosition[    202110,       4336]
NotebookOutlinePosition[    203335,       4372]
CellTagsIndexPosition[    203248,       4367]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Orthogonal Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OrthogonalPolynomials"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Orthogonal Polynomials\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LaguerreL" :> Documentation`HelpLookup["paclet:ref/LaguerreL"],
           "HypergeometricU" :> 
          Documentation`HelpLookup["paclet:ref/HypergeometricU"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LaguerreL\"\>", 
       2->"\<\"HypergeometricU\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Functions Used in Quantum Mechanics\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HermiteH", "ObjectName",
 CellID->18981],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HermiteH",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HermiteH"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Hermite polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["H", "n"], "(", "x", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13156]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "Explicit polynomials are given for non\[Hyphen]negative integers ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30149],

Cell[TextData[{
 "The Hermite polynomials satisfy the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]\[Prime]"], "-", 
     RowBox[{"2", "x", 
      SuperscriptBox["y", "\[Prime]"]}], "+", 
     RowBox[{"2", "n", "y"}]}], "=", "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->32145],

Cell[TextData[{
 "They are orthogonal polynomials with weight function ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["e", 
    RowBox[{"-", 
     SuperscriptBox["x", "2"]}]], TraditionalForm]], "InlineMath"],
 " in the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"-", "\[Infinity]", ",", "\[Infinity]"}], ")"}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->30497],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["HermiteH",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HermiteH"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->147852723],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HermiteH",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HermiteH"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HermiteH",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HermiteH"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["HermiteH",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HermiteH"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is an entire function of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " with no branch cut discontinuities. "
}], "Notes",
 CellID->19466]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13297153],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->44531114],

Cell["Compute the 10th Hermite polynomial:", "ExampleText",
 CellID->1951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermiteH", "[", 
  RowBox[{"10", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32581],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "30240"}], "+", 
  RowBox[{"302400", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"403200", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"161280", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  RowBox[{"23040", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"1024", " ", 
   SuperscriptBox["x", "10"]}]}]], "Output",
 ImageSize->{392, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36065881]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21845],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"HermiteH", "[", 
    RowBox[{"10", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13675],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{247, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{247., Automatic}},
 CellLabel->"Out[1]=",
 CellID->694216821]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21433],

Cell["Evaluate for complex argument and complex orders:", "ExampleText",
 CellID->6100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermiteH", "[", 
  RowBox[{"5", ",", 
   RowBox[{"2", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14399],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1296"}], "-", 
  RowBox[{"328", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217213288]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermiteH", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"3", "/", "2"}], "+", "I"}], ",", "1.2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129701274],

Cell[BoxData[
 RowBox[{"3.557510479301133`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.29844210700914`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28639972]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10974],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->24387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"HermiteH", "[", 
    RowBox[{
     RowBox[{"10", "/", "3"}], ",", "2"}], "]"}], ",", "50"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->759],

Cell[BoxData["52.\
8797734551348455944283142094321939232755993193215572744416538337462`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->527010143]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55250928],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->16145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermiteH", "[", 
  RowBox[{
   RowBox[{"10", "/", "3"}], ",", "2.00000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15729],

Cell[BoxData["52.87977345513484559442831420943221119540911260896`30.\
97825867274917"], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26293570]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9324],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HermiteH",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HermiteH"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermiteH", "[", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.5760000000000005`"}], ",", "9.`", ",", 
   "25.056000000000004`"}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->625081426]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermiteH", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15927],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "x"}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "2"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "12"}], " ", "x"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "3"]}]}]}], "}"}]], "Output",
 ImageSize->{174, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->342231762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10849],

Cell["\<\
Simple cases give exact symbolic results even for symbolic order:\
\>", "ExampleText",
 CellID->31796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermiteH", "[", 
  RowBox[{"n", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29542],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["2", "n"], " ", 
   SqrtBox["\[Pi]"]}], 
  RowBox[{"Gamma", "[", 
   FractionBox[
    RowBox[{"1", "-", "n"}], "2"], "]"}]]], "Output",
 ImageSize->{77, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->348362929]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->190964882],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->902787406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HermiteH", "[", 
   RowBox[{"n", ",", "x"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17244462],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox["H", "n"], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->368710839]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27396],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HermiteH",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HermiteH"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->5417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermiteH", "[", 
  RowBox[{"3", ",", 
   RowBox[{"1", "+", "x", "+", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"], "+", 
    FractionBox[
     SuperscriptBox["x", "3"], "3"], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15411],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", "4"}], "+", 
   RowBox[{"12", " ", "x"}], "+", 
   RowBox[{"30", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"36", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {-4, 12, 30, 36}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45035955]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12048],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HermiteH",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HermiteH"]], "InlineFormula"],
 " can deal with real-valued intervals:"
}], "ExampleText",
 CellID->15781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermiteH", "[", 
  RowBox[{"8", ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23833],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "15344"}], ",", "15376"}], "}"}], "]"}]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->890665523]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21884],

Cell["Solve the Hermite differential equation:", "ExampleText",
 CellID->7668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["w", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}], "-", 
      RowBox[{"2", " ", "z", " ", 
       RowBox[{
        SuperscriptBox["w", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", "n", " ", 
       RowBox[{"w", "[", "z", "]"}]}]}], "\[Equal]", "0"}], "}"}], ",", 
   RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10468],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"HermiteH", "[", 
       RowBox[{"n", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Hypergeometric1F1", "[", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["n", "2"]}], ",", 
        FractionBox["1", "2"], ",", 
        SuperscriptBox["z", "2"]}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{444, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50292772]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6204],

Cell["Quantum harmonic oscillator wave functions:", "ExampleText",
 CellID->31844],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"n_", ",", "x_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{
    RowBox[{"HermiteH", "[", 
     RowBox[{"n", ",", "x"}], "]"}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["x", "2"], "2"]}]]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["2", "n"], " ", 
     RowBox[{"n", "!"}], " ", 
     SqrtBox["\[Pi]"]}]]]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"\[Psi]", "[", 
    RowBox[{"50", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14960],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->763488]
}, Open  ]],

Cell["Normalization:", "ExampleText",
 CellID->23922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], " ", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Abs", "[", 
     RowBox[{"\[Psi]", "[", 
      RowBox[{"10", ",", "x"}], "]"}], "]"}], "2"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19951],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->43622720]
}, Open  ]],

Cell[TextData[{
 "Compute the expectation value of ",
 Cell[BoxData[
  SuperscriptBox["x", "2"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->10342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{"\[Psi]", "[", 
       RowBox[{"10", ",", "x"}], "]"}], "]"}], "2"]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->630],

Cell[BoxData[
 FractionBox["21", "2"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->33606261]
}, Open  ]],

Cell["\<\
Momentum and position wave functions for a harmonic oscillator have the same \
form:\
\>", "ExampleText",
 CellID->10430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"FourierTransform", "[", 
     RowBox[{
      RowBox[{"\[Psi]", "[", 
       RowBox[{"2", ",", "x"}], "]"}], ",", "x", ",", "\[Omega]"}], "]"}], 
    ",", 
    RowBox[{
     SuperscriptBox["\[ImaginaryI]", "2"], 
     RowBox[{"\[Psi]", "[", 
      RowBox[{"2", ",", "x"}], "]"}]}]}], "}"}], "//", "Simplify"}]], "Input",\

 CellLabel->"In[5]:=",
 CellID->19451],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["\[Omega]", "2"], "2"]}]], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
    RowBox[{
     SqrtBox["2"], " ", 
     SuperscriptBox["\[Pi]", 
      RowBox[{"1", "/", "4"}]]}]], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["x", "2"], "2"]}]], " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}], 
    RowBox[{
     SqrtBox["2"], " ", 
     SuperscriptBox["\[Pi]", 
      RowBox[{"1", "/", "4"}]]}]]}], "}"}]], "Output",
 ImageSize->{208, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->127576027]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10198],

Cell["Solve a recursion relation:", "ExampleText",
 CellID->28527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "c"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"n", "+", "1"}], "]"}], "+", " ", 
       RowBox[{"2", "n", " ", 
        RowBox[{"f", "[", 
         RowBox[{"n", "-", "1"}], "]"}]}]}], "==", 
      RowBox[{"c", " ", 
       RowBox[{"f", "[", "n", "]"}]}]}]}], "}"}], ",", 
   RowBox[{"f", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31480],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "n", "]"}], "\[Rule]", 
    RowBox[{"HermiteH", "[", 
     RowBox[{"n", ",", 
      FractionBox["c", "2"]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{176, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->598964905]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21382],

Cell["\<\
Set up generalized Fourier series based on normalized Hermite functions:\
\>", "ExampleText",
 CellID->12425],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"n_", ",", "x_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{
    RowBox[{"HermiteH", "[", 
     RowBox[{"n", ",", "x"}], "]"}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["x", "2"], "2"]}]]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["2", "n"], " ", 
     RowBox[{"n", "!"}], " ", 
     SqrtBox["\[Pi]"]}]]]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21614],

Cell[TextData[{
 "Find series coefficients for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->16612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"coeffs", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], " ", 
       RowBox[{"\[Psi]", "[", 
        RowBox[{"n", ",", "x"}], "]"}]}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3192],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["\[Pi]", 
      RowBox[{"1", "/", "4"}]]}], 
    SqrtBox["\[ExponentialE]"]], ",", "0", ",", 
   RowBox[{
    SqrtBox[
     FractionBox["2", 
      RowBox[{"3", " ", "\[ExponentialE]"}]]], " ", 
    SuperscriptBox["\[Pi]", 
     RowBox[{"1", "/", "4"}]]}], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["\[Pi]", 
      RowBox[{"1", "/", "4"}]], 
     SqrtBox[
      RowBox[{"30", " ", "\[ExponentialE]"}]]]}], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"29", " ", 
      SuperscriptBox["\[Pi]", 
       RowBox[{"1", "/", "4"}]]}], 
     RowBox[{"6", " ", 
      SqrtBox[
       RowBox[{"35", " ", "\[ExponentialE]"}]]}]]}], ",", "0", ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["67", "36"]}], " ", 
    SqrtBox[
     FractionBox["5", 
      RowBox[{"14", " ", "\[ExponentialE]"}]]], " ", 
    SuperscriptBox["\[Pi]", 
     RowBox[{"1", "/", "4"}]]}], ",", "0"}], "}"}]], "Output",
 ImageSize->{496, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->366474025]
}, Open  ]],

Cell["Compare approximation and exact function:", "ExampleText",
 CellID->14938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"\[Psi]", "[", 
         RowBox[{"n", ",", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}], ".", 
      "coeffs"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25005],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{234, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{234., Automatic}},
 CellLabel->"Out[3]=",
 CellID->121884741]
}, Open  ]],

Cell["\<\
Gibbs-like phenomenon for approximation of discontinuous function:\
\>", "ExampleText",
 CellID->16666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"UnitStep", "[", "x", "]"}], ",", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"\[Psi]", "[", 
          RowBox[{"n", ",", "x"}], "]"}], 
         RowBox[{
          SubsuperscriptBox["\[Integral]", 
           RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
          RowBox[{
           RowBox[{"UnitStep", "[", "x", "]"}], " ", 
           RowBox[{"\[Psi]", "[", 
            RowBox[{"n", ",", "x"}], "]"}], 
           RowBox[{"\[DifferentialD]", "x"}]}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "0", ",", "50"}], "}"}]}], "]"}]}], "}"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->32171],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{234, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{234., Automatic}},
 CellLabel->"Out[4]=",
 CellID->84897246]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6964],

Cell[TextData[{
 "Find an integral for symbolic ",
 Cell[BoxData["n"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"HermiteH", "[", 
      RowBox[{"n", ",", "x"}], "]"}]}], ",", "x"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15026],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"12", " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "n"}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"-", "n"}], "]"}]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"-", 
       FractionBox["n", "2"]}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"Hypergeometric1F1", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          FractionBox["n", "2"]}], ",", 
         RowBox[{"-", 
          FractionBox["1", "2"]}], ",", 
         SuperscriptBox["x", "2"]}], "]"}]}], ")"}]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "n"}], ")"}], " ", 
     SuperscriptBox["x", "3"], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox[
       RowBox[{"1", "-", "n"}], "2"], "]"}], " ", 
     RowBox[{"Hypergeometric1F1", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], "-", 
        FractionBox["n", "2"]}], ",", 
       FractionBox["5", "2"], ",", 
       SuperscriptBox["x", "2"]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{500, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->446118654]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1935],

Cell["Get the list of coefficients in a Hermite polynomial:", "ExampleText",
 CellID->12733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{"HermiteH", "[", 
    RowBox[{"10", ",", "x"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23251],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "30240"}], ",", "0", ",", "302400", ",", "0", ",", 
   RowBox[{"-", "403200"}], ",", "0", ",", "161280", ",", "0", ",", 
   RowBox[{"-", "23040"}], ",", "0", ",", "1024"}], "}"}]], "Output",
 ImageSize->{423, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352535214]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23076],

Cell["\<\
Cancellations in the polynomial form may lead to inaccurate numerical \
results:\
\>", "ExampleText",
 CellID->108685218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HermiteH", "[", 
   RowBox[{"100", ",", "x"}], "]"}], "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"N", "[", 
    RowBox[{"5", ",", "16"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->380814599],

Cell[BoxData["0``-104.85730030967738"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->391519657]
}, Open  ]],

Cell["Evaluate the function directly:", "ExampleText",
 CellID->753914464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermiteH", "[", 
  RowBox[{"100", ",", 
   RowBox[{"N", "[", 
    RowBox[{"5", ",", "16"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->83976469],

Cell[BoxData["8.193193713059150513315029886355`15.194614502652255*^98"], \
"Output",
 ImageSize->{152, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->116776482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10805],

Cell["Plot the 100th Hermite polynomial:", "ExampleText",
 CellID->11127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"HermiteH", "[", 
     RowBox[{"100", ",", "x"}], "]"}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"x", "^", "2"}]}], "/", "2"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "200"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24837],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->236128530]
}, Open  ]],

Cell["\<\
There are too many cancellations in the explicit polynomial to get a correct \
result:\
\>", "ExampleText",
 CellID->16583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"poly", "=", 
   RowBox[{"HermiteH", "[", 
    RowBox[{"100", ",", "x"}], "]"}]}], ";", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"poly", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"x", "^", "2"}]}], "/", "2"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
    RowBox[{"PlotPoints", "->", "200"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9803],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->26330728]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22278],

Cell["\<\
Distribution of the zeros of the first 20 Hermite polynomials:\
\>", "ExampleText",
 CellID->30080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Thread", "[", 
       RowBox[{"{", 
        RowBox[{"n", ",", 
         RowBox[{"x", "/.", 
          RowBox[{"Solve", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"HermiteH", "[", 
              RowBox[{"n", ",", "x"}], "]"}], "==", "0"}], ",", "x"}], 
           "]"}]}]}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "20"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16434],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd1gtQVFUYwPFVkF3er0VQCHkNICUERBCP7lGYyGkIMWCCDAiUVSIMixEr
QDRADDcCLRkaQOklSS1DYGF5jsYrxgEFQqxkQA0QCXBxQx4L1XTPN8N3Znbu
/OZ/d8+3d+/urGPy/p171kokkt5/H/8d/18zgmT1IleD8lKrakYpsniejKw+
XUY8HfXlytOzFFk834wkqn/+0GvfAkWGvqVoqefeL8MUWexytJ+cjCXr1sZs
ljBkwh1b8cLmmvNTFFl8PRtSPa9d0O9ey5AJ99Wc6PDaRA1FhueHBaiCGsZ/
p8hit0Pz2pGvxkze9/dfx5AJd8fJSouhdn59wPB6LWsdWqWbJiiy2B2IKtvV
PmHPIEWG7nNs5MSto2qKDD08z/7Cre9WKDL01CPOMnWmlCGL8zuh9+tEtmt3
HIx2G6PIArdq9OZF77w5igy9/nCyROPIPx8w7HcuvDLTrUifIYvdhews+2Cv
jfpXiixwl63pCtacmqHI0N3KD+xIsl2iyNADl9S9slBdhgz761gtaEmOIUMW
uyu6Xq4k5bxn3indPymywD09eft++TMaigzd4kFLkIsf/z6AYb+Vn5QVW8L0
GDL0gPRtz0rjjBmy2N3JiHV73VG7fooscCs0S1HPR09RZOj7R5rqbEvnKTL0
jete9MsI5p83GPZfHqy+FOohY8jQH4uIXe9ub8qQxe6BrrcHubk3bCot+Q5F
FrgDaq0zXi6YpcjQzxw75Bf9hZYiQ7+RdtfzdXd+f4BhnlTLTgeTeX2GDN2p
TWPQpjBjyGJ/ghxcbNul+bqXIgvcrz1KSUq3n6TI0LfbRljk1sxRZOg0tvHN
6Sv8fgLD/maVngFDS+sYMnSrC9nvFDQaMmTo7stNr172N2fIYvckklXLk+zL
z+82srpNkQVuy0iv4qItaooM/U5V8PT6gkWKDD3mbuDZDZX8/gPDPH2653Su
/ChlyNBPfK+dMdllzJCh53YllWpXzBmy2J8k5ZGRnzcfvk6RBW55kyy8KmaC
IkP/yCVhodjqb4oMvS7xFcPCwBWKDN2r/svg6gR+v4JhPuVSUnFumj5Dhp5T
odh45qEJQ4ae7tvTEXbZgiGL3Vs88uVNcprDn3bWGaHIAneW+nj/eqsHFBn6
snHnD8Xd8xQZek2iz1sxKWsYMswzpxyXjJrqMWToyX/ElhjLDBky9OpJw9kM
wYwhQ5/N2DCx9T1Lhix2H2LeV5CVVXSNIgvcwypf549/G6fI0I+8eyOl7NpD
igz9geCdEpugpcjQd5daLjhb6zBkmC9CfVw1qpIyZOj9A63B8k+MGDL0Qbuz
n1osmzFk6PH1DTGF3nKGLHZf8ciXLzkpjYsasOP/H8ECd+zBFoNsjxmKDL3b
NuSiJOURRYauGA453beb/x6CYR7XPr/4z1p0GTJ0h02tIc+F6jNk6PdGVN9o
bEwYMvRd+QMR15vNGTL0+MTJUeWInCGL/Smi0xsqfUnRQ5EF7szEgPzkijGK
DD0qsqqx/dIsRYYe/XbhfaPrixQZ+l9vbOvxMuC/r2CYz/Lb5ZJDkXoMGXpD
atO8otOAIUO3HtIcGFaaMmToCRrFxcfTLBgy9KSGuK6OEiuGTP4BITRkiA==

     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  PlotRange->{{0., 20.}, {-5.387480890011233, 5.387480890011233}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{304, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->356838210]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22229],

Cell["Interpolation between Hermite polynomials:", "ExampleText",
 CellID->8853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Abs", "[", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["x", "2"], "2"]}]], " ", 
       RowBox[{"HermiteH", "[", 
        RowBox[{"n", ",", "x"}], "]"}]}], 
      SqrtBox[
       RowBox[{
        RowBox[{"n", "!"}], " ", 
        SuperscriptBox["2", "n"]}]]], "]"}], "2"], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21930],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{227, 229},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{227., Automatic}},
 CellLabel->"Out[1]=",
 CellID->307671382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14730],

Cell["\<\
Comparison of quantum and classical probability distributions for a harmonic \
oscillator:\
\>", "ExampleText",
 CellID->7448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "20"}], "}"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", 
           SuperscriptBox["x", "2"]}]], " ", 
         SuperscriptBox[
          RowBox[{"HermiteH", "[", 
           RowBox[{"n", ",", "x"}], "]"}], "2"]}], 
        RowBox[{
         SuperscriptBox["2", "n"], " ", 
         RowBox[{"n", "!"}], " ", 
         SqrtBox["\[Pi]"]}]], ",", 
       RowBox[{"Piecewise", "[", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           FractionBox["1", 
            RowBox[{
             SqrtBox[
              RowBox[{
               RowBox[{"2", " ", "n"}], "+", "1", "-", 
               SuperscriptBox["x", "2"]}]], " ", "\[Pi]"}]], ",", " ", 
           RowBox[{
            SuperscriptBox["x", "2"], "<", 
            RowBox[{
             RowBox[{"2", " ", "n"}], "+", "1"}]}]}], "}"}], "}"}], "]"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"3", "n"}]]}], ",", 
       SqrtBox[
        RowBox[{"3", "n"}]]}], "}"}], ",", 
     RowBox[{"PlotPoints", "->", "200"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21632],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->618107525]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3063],

Cell["Generalized Lissajous figures:", "ExampleText",
 CellID->1818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "=", "11"}], ",", 
     RowBox[{"m", "=", "13"}]}], "}"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"x", "^", "2"}]}], "/", "2"}], "]"}], 
        RowBox[{
         RowBox[{"HermiteH", "[", 
          RowBox[{"n", ",", "x"}], "]"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"2", "^", "n"}], " ", 
           RowBox[{"n", "!"}]}], "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"x", "^", "2"}]}], "/", "2"}], "]"}], 
        RowBox[{
         RowBox[{"HermiteH", "[", 
          RowBox[{"m", ",", "x"}], "]"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"2", "^", "m"}], " ", 
           RowBox[{"m", "!"}]}], "]"}]}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "8"}], ",", "8"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18815],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{216, 213},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{216., Automatic}},
 CellLabel->"Out[1]=",
 CellID->222538182]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10204],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LaguerreL",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LaguerreL"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HypergeometricU",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HypergeometricU"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19695]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27443],

Cell[TextData[ButtonBox["Orthogonal Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OrthogonalPolynomials"]], "Tutorials",
 CellID->19448]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->26392],

Cell[TextData[{
 ButtonBox["Demonstrations with HermiteH",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=HermiteH"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/HermitePolynomial.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Polynomials/HermiteH/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
HermiteH"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->54254723],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->74072609],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->15322663],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->457640370]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HermiteH - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 32.9754312}", "context" -> "System`", 
    "keywords" -> {"Hermite functions", "Hermite H"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "HermiteH[n, x] gives the Hermite polynomial H_n (x). ", 
    "synonyms" -> {"Hermite H"}, "title" -> "HermiteH", "type" -> "Symbol", 
    "uri" -> "ref/HermiteH"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6277, 222, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->13297153]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 203106, 4360}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2230, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2853, 82, 46, 1, 70, "ObjectName",
 CellID->18981],
Cell[2902, 85, 676, 23, 70, "Usage",
 CellID->13156]
}, Open  ]],
Cell[CellGroupData[{
Cell[3615, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4093, 130, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4216, 136, 177, 6, 70, "Notes",
 CellID->30149],
Cell[4396, 144, 365, 12, 70, "Notes",
 CellID->32145],
Cell[4764, 158, 408, 15, 70, "Notes",
 CellID->30497],
Cell[5175, 175, 248, 8, 70, "Notes",
 CellID->147852723],
Cell[5426, 185, 218, 7, 70, "Notes",
 CellID->31226],
Cell[5647, 194, 201, 7, 70, "Notes",
 CellID->28162],
Cell[5851, 203, 389, 14, 70, "Notes",
 CellID->19466]
}, Closed]],
Cell[CellGroupData[{
Cell[6277, 222, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13297153],
Cell[CellGroupData[{
Cell[6661, 236, 147, 5, 70, "ExampleSection",
 CellID->44531114],
Cell[6811, 243, 74, 1, 70, "ExampleText",
 CellID->1951],
Cell[CellGroupData[{
Cell[6910, 248, 124, 4, 28, "Input",
 CellID->32581],
Cell[7037, 254, 505, 17, 36, "Output",
 CellID->36065881]
}, Open  ]],
Cell[7557, 274, 121, 3, 70, "ExampleDelimiter",
 CellID->21845],
Cell[CellGroupData[{
Cell[7703, 281, 261, 9, 28, "Input",
 CellID->13675],
Cell[7967, 292, 4287, 74, 176, "Output",
 Evaluatable->False,
 CellID->694216821]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12303, 372, 216, 7, 70, "ExampleSection",
 CellID->21433],
Cell[12522, 381, 87, 1, 70, "ExampleText",
 CellID->6100],
Cell[CellGroupData[{
Cell[12634, 386, 147, 5, 70, "Input",
 CellID->14399],
Cell[12784, 393, 238, 8, 36, "Output",
 CellID->217213288]
}, Open  ]],
Cell[CellGroupData[{
Cell[13059, 406, 178, 6, 70, "Input",
 CellID->129701274],
Cell[13240, 414, 269, 7, 36, "Output",
 CellID->28639972]
}, Open  ]],
Cell[13524, 424, 121, 3, 70, "ExampleDelimiter",
 CellID->10974],
Cell[13648, 429, 66, 1, 70, "ExampleText",
 CellID->24387],
Cell[CellGroupData[{
Cell[13739, 434, 205, 8, 70, "Input",
 CellID->759],
Cell[13947, 444, 236, 7, 36, "Output",
 CellID->527010143]
}, Open  ]],
Cell[14198, 454, 124, 3, 70, "ExampleDelimiter",
 CellID->55250928],
Cell[14325, 459, 109, 3, 70, "ExampleText",
 CellID->16145],
Cell[CellGroupData[{
Cell[14459, 466, 184, 6, 70, "Input",
 CellID->15729],
Cell[14646, 474, 227, 6, 36, "Output",
 CellID->26293570]
}, Open  ]],
Cell[14888, 483, 120, 3, 70, "ExampleDelimiter",
 CellID->9324],
Cell[15011, 488, 204, 7, 70, "ExampleText",
 CellID->767],
Cell[CellGroupData[{
Cell[15240, 499, 187, 6, 70, "Input",
 CellID->4966],
Cell[15430, 507, 275, 9, 36, "Output",
 CellID->625081426]
}, Open  ]],
Cell[CellGroupData[{
Cell[15742, 521, 182, 6, 70, "Input",
 CellID->15927],
Cell[15927, 529, 457, 17, 39, "Output",
 CellID->342231762]
}, Open  ]],
Cell[16399, 549, 121, 3, 70, "ExampleDelimiter",
 CellID->10849],
Cell[16523, 554, 112, 3, 70, "ExampleText",
 CellID->31796],
Cell[CellGroupData[{
Cell[16660, 561, 123, 4, 70, "Input",
 CellID->29542],
Cell[16786, 567, 322, 12, 65, "Output",
 CellID->348362929]
}, Open  ]],
Cell[17123, 582, 125, 3, 70, "ExampleDelimiter",
 CellID->190964882],
Cell[17251, 587, 203, 7, 70, "ExampleText",
 CellID->902787406],
Cell[CellGroupData[{
Cell[17479, 598, 165, 5, 70, "Input",
 CellID->17244462],
Cell[17647, 605, 254, 8, 50, "Output",
 CellID->368710839]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17950, 619, 239, 7, 70, "ExampleSection",
 CellID->27396],
Cell[18192, 628, 204, 7, 70, "ExampleText",
 CellID->5417],
Cell[CellGroupData[{
Cell[18421, 639, 334, 11, 70, "Input",
 CellID->15411],
Cell[18758, 652, 606, 20, 36, "Output",
 CellID->45035955]
}, Open  ]],
Cell[19379, 675, 121, 3, 70, "ExampleDelimiter",
 CellID->12048],
Cell[19503, 680, 210, 7, 70, "ExampleText",
 CellID->15781],
Cell[CellGroupData[{
Cell[19738, 691, 232, 8, 70, "Input",
 CellID->23833],
Cell[19973, 701, 268, 9, 36, "Output",
 CellID->890665523]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20290, 716, 223, 7, 70, "ExampleSection",
 CellID->21884],
Cell[20516, 725, 78, 1, 70, "ExampleText",
 CellID->7668],
Cell[CellGroupData[{
Cell[20619, 730, 572, 17, 70, "Input",
 CellID->10468],
Cell[21194, 749, 666, 22, 51, "Output",
 CellID->50292772]
}, Open  ]],
Cell[21875, 774, 120, 3, 70, "ExampleDelimiter",
 CellID->6204],
Cell[21998, 779, 82, 1, 70, "ExampleText",
 CellID->31844],
Cell[22083, 782, 486, 18, 70, "Input",
 CellID->30921],
Cell[CellGroupData[{
Cell[22594, 804, 261, 9, 70, "Input",
 CellID->14960],
Cell[22858, 815, 16349, 272, 70, "Output",
 Evaluatable->False,
 CellID->763488]
}, Open  ]],
Cell[39222, 1090, 53, 1, 70, "ExampleText",
 CellID->23922],
Cell[CellGroupData[{
Cell[39300, 1095, 342, 11, 70, "Input",
 CellID->19951],
Cell[39645, 1108, 157, 5, 36, "Output",
 CellID->43622720]
}, Open  ]],
Cell[39817, 1116, 155, 6, 70, "ExampleText",
 CellID->10342],
Cell[CellGroupData[{
Cell[39997, 1126, 389, 13, 70, "Input",
 CellID->630],
Cell[40389, 1141, 178, 6, 51, "Output",
 CellID->33606261]
}, Open  ]],
Cell[40582, 1150, 131, 4, 70, "ExampleText",
 CellID->10430],
Cell[CellGroupData[{
Cell[40738, 1158, 425, 15, 70, "Input",
 CellID->19451],
Cell[41166, 1175, 968, 35, 70, "Output",
 CellID->127576027]
}, Open  ]],
Cell[42149, 1213, 121, 3, 70, "ExampleDelimiter",
 CellID->10198],
Cell[42273, 1218, 66, 1, 70, "ExampleText",
 CellID->28527],
Cell[CellGroupData[{
Cell[42364, 1223, 615, 20, 70, "Input",
 CellID->31480],
Cell[42982, 1245, 352, 12, 49, "Output",
 CellID->598964905]
}, Open  ]],
Cell[43349, 1260, 121, 3, 70, "ExampleDelimiter",
 CellID->21382],
Cell[43473, 1265, 119, 3, 70, "ExampleText",
 CellID->12425],
Cell[43595, 1270, 486, 18, 70, "Input",
 CellID->21614],
Cell[44084, 1290, 199, 8, 70, "ExampleText",
 CellID->16612],
Cell[CellGroupData[{
Cell[44308, 1302, 504, 16, 70, "Input",
 CellID->3192],
Cell[44815, 1320, 1173, 40, 61, "Output",
 CellID->366474025]
}, Open  ]],
Cell[46003, 1363, 80, 1, 70, "ExampleText",
 CellID->14938],
Cell[CellGroupData[{
Cell[46108, 1368, 567, 20, 70, "Input",
 CellID->25005],
Cell[46678, 1390, 7366, 125, 70, "Output",
 Evaluatable->False,
 CellID->121884741]
}, Open  ]],
Cell[54059, 1518, 113, 3, 70, "ExampleText",
 CellID->16666],
Cell[CellGroupData[{
Cell[54197, 1525, 875, 27, 70, "Input",
 CellID->32171],
Cell[55075, 1554, 3729, 65, 70, "Output",
 Evaluatable->False,
 CellID->84897246]
}, Open  ]],
Cell[58819, 1622, 120, 3, 70, "ExampleDelimiter",
 CellID->6964],
Cell[58942, 1627, 128, 5, 70, "ExampleText",
 CellID->27541],
Cell[CellGroupData[{
Cell[59095, 1636, 253, 9, 70, "Input",
 CellID->15026],
Cell[59351, 1647, 1281, 43, 83, "Output",
 CellID->446118654]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60681, 1696, 232, 7, 70, "ExampleSection",
 CellID->1935],
Cell[60916, 1705, 92, 1, 70, "ExampleText",
 CellID->12733],
Cell[CellGroupData[{
Cell[61033, 1710, 192, 6, 70, "Input",
 CellID->23251],
Cell[61228, 1718, 377, 10, 36, "Output",
 CellID->352535214]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[61654, 1734, 226, 7, 70, "ExampleSection",
 CellID->23076],
Cell[61883, 1743, 131, 4, 70, "ExampleText",
 CellID->108685218],
Cell[CellGroupData[{
Cell[62039, 1751, 238, 8, 70, "Input",
 CellID->380814599],
Cell[62280, 1761, 179, 5, 36, "Output",
 CellID->391519657]
}, Open  ]],
Cell[62474, 1769, 74, 1, 70, "ExampleText",
 CellID->753914464],
Cell[CellGroupData[{
Cell[62573, 1774, 183, 6, 70, "Input",
 CellID->83976469],
Cell[62759, 1782, 215, 6, 36, "Output",
 CellID->116776482]
}, Open  ]],
Cell[62989, 1791, 121, 3, 70, "ExampleDelimiter",
 CellID->10805],
Cell[63113, 1796, 73, 1, 70, "ExampleText",
 CellID->11127],
Cell[CellGroupData[{
Cell[63211, 1801, 444, 15, 70, "Input",
 CellID->24837],
Cell[63658, 1818, 17601, 293, 70, "Output",
 Evaluatable->False,
 CellID->236128530]
}, Open  ]],
Cell[81274, 2114, 133, 4, 70, "ExampleText",
 CellID->16583],
Cell[CellGroupData[{
Cell[81432, 2122, 503, 17, 70, "Input",
 CellID->9803],
Cell[81938, 2141, 4147, 72, 70, "Output",
 Evaluatable->False,
 CellID->26330728]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86134, 2219, 224, 7, 70, "ExampleSection",
 CellID->22278],
Cell[86361, 2228, 109, 3, 70, "ExampleText",
 CellID->30080],
Cell[CellGroupData[{
Cell[86495, 2235, 601, 20, 70, "Input",
 CellID->16434],
Cell[87099, 2257, 2194, 45, 201, "Output",
 CellID->356838210]
}, Open  ]],
Cell[89308, 2305, 121, 3, 70, "ExampleDelimiter",
 CellID->22229],
Cell[89432, 2310, 80, 1, 70, "ExampleText",
 CellID->8853],
Cell[CellGroupData[{
Cell[89537, 2315, 677, 23, 70, "Input",
 CellID->21930],
Cell[90217, 2340, 75039, 1234, 70, "Output",
 Evaluatable->False,
 CellID->307671382]
}, Open  ]],
Cell[165271, 3577, 121, 3, 70, "ExampleDelimiter",
 CellID->14730],
Cell[165395, 3582, 136, 4, 70, "ExampleText",
 CellID->7448],
Cell[CellGroupData[{
Cell[165556, 3590, 1365, 45, 70, "Input",
 CellID->21632],
Cell[166924, 3637, 16409, 273, 70, "Output",
 Evaluatable->False,
 CellID->618107525]
}, Open  ]],
Cell[183348, 3913, 120, 3, 70, "ExampleDelimiter",
 CellID->3063],
Cell[183471, 3918, 68, 1, 70, "ExampleText",
 CellID->1818],
Cell[CellGroupData[{
Cell[183564, 3923, 1188, 39, 70, "Input",
 CellID->18815],
Cell[184755, 3964, 13596, 227, 70, "Output",
 Evaluatable->False,
 CellID->222538182]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[198412, 4198, 311, 9, 70, "SeeAlsoSection",
 CellID->10204],
Cell[198726, 4209, 467, 17, 70, "SeeAlso",
 CellID->19695]
}, Open  ]],
Cell[CellGroupData[{
Cell[199230, 4231, 314, 9, 70, "TutorialsSection",
 CellID->27443],
Cell[199547, 4242, 154, 3, 70, "Tutorials",
 CellID->19448]
}, Open  ]],
Cell[CellGroupData[{
Cell[199738, 4250, 321, 9, 70, "RelatedLinksSection",
 CellID->26392],
Cell[200062, 4261, 361, 12, 70, "RelatedLinks"],
Cell[200426, 4275, 188, 4, 70, "RelatedLinks"],
Cell[200617, 4281, 192, 4, 70, "RelatedLinks"],
Cell[200812, 4287, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[201235, 4305, 318, 9, 70, "MoreAboutSection",
 CellID->54254723],
Cell[201556, 4316, 177, 3, 70, "MoreAbout",
 CellID->74072609],
Cell[201736, 4321, 154, 3, 70, "MoreAbout",
 CellID->15322663],
Cell[201893, 4326, 145, 3, 70, "MoreAbout",
 CellID->457640370]
}, Open  ]],
Cell[202053, 4332, 27, 0, 70, "History"],
Cell[202083, 4334, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

