(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43982,       1500]
NotebookOptionsPosition[     37331,       1266]
NotebookOutlinePosition[     38708,       1305]
CellTagsIndexPosition[     38622,       1300]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Advanced Matrix Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedMatrixOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Advanced Matrix Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SchurDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/SchurDecomposition"], 
          "QRDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/QRDecomposition"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SchurDecomposition\"\>", 
       2->"\<\"QRDecomposition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrix Decompositions" :> 
          Documentation`HelpLookup["paclet:guide/MatrixDecompositions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Matrix Decompositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HessenbergDecomposition", "ObjectName",
 CellID->398],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HessenbergDecomposition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HessenbergDecomposition"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Hessenberg decomposition of a matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4951]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The result is given in the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["p", "TI"], ",", 
    StyleBox["h", "TI"]}], "}"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " is a unitary matrix such that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["p", "TI"], ".", 
    StyleBox["h", "TI"], ".", 
    RowBox[{
     ButtonBox["Conjugate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Conjugate"], "[", 
     RowBox[{
      ButtonBox["Transpose",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Transpose"], "[", 
      StyleBox["p", "TI"], "]"}], "]"}]}], "==", 
   StyleBox["m", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12018],

Cell[TextData[{
 "The matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " must be square."
}], "Notes",
 CellID->111590495]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2866987],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->139984112],

Cell["\<\
Find the Hessenberg decomposition of a 4\[Times]4 matrix:\
\>", "ExampleText",
 CellID->857906094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"p", ",", "h"}], "}"}], "=", 
  RowBox[{"HessenbergDecomposition", "[", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1.", "2.", "3.", "4."},
      {"5.", "6.", "7.", "8."},
      {"9.", "10.", "11.", "12."},
      {"13.", "14.", "15.", "16."}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->428833876],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "0.30151134457776374`"}], ",", "0.86164043685533`", ",", 
       "0.4082482904638608`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "0.5427204202399746`"}], ",", "0.19694638556693067`", ",",
        
       RowBox[{"-", "0.8164965809277264`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "0.7839294959021855`"}], ",", 
       RowBox[{"-", "0.46774766572146326`"}], ",", "0.4082482904638642`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", 
       RowBox[{"-", "5.366901933484193`"}], ",", "0.44312936752559856`", ",", 
       
       RowBox[{"-", "8.151302983289144`*^-16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16.583123951776997`"}], ",", "33.08727272727274`", ",", 
       RowBox[{"-", "9.557463614568553`"}], ",", "2.196593601455632`*^-14"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "2.2089943862190182`"}], ",", 
       RowBox[{"-", "0.08727272727272498`"}], ",", 
       "6.496543324018933`*^-16"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.`", ",", "0.`", ",", "2.5216712940846764`*^-15", ",", 
       "5.917292875685589`*^-16"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{577, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48738734]
}, Open  ]],

Cell[TextData[{
 "The matrix ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " is an upper Hessenberg matrix:"
}], "ExampleText",
 CellID->17895849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "h", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->85255229],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.`", 
      RowBox[{"-", "5.366901933484193`"}], "0.44312936752559856`", 
      RowBox[{"-", "8.151302983289144`*^-16"}]},
     {
      RowBox[{"-", "16.583123951776997`"}], "33.08727272727274`", 
      RowBox[{"-", "9.557463614568553`"}], "2.196593601455632`*^-14"},
     {"0.`", 
      RowBox[{"-", "2.2089943862190182`"}], 
      RowBox[{"-", "0.08727272727272498`"}], "6.496543324018933`*^-16"},
     {"0.`", "0.`", "2.5216712940846764`*^-15", "5.917292875685589`*^-16"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{343, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->70100533]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27596],

Cell["Hessenberg decomposition works for complex matrices:", "ExampleText",
 CellID->538898342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HessenbergDecomposition", "[", 
  RowBox[{"RandomComplex", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"1", "+", "I"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->535646641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.8647149923995998`"}], "-", 
        RowBox[{"0.37932738105442415`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.32676800226153374`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.04001740371086098`", " ", "\[ImaginaryI]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.04762207160697568`"}], "-", 
        RowBox[{"0.32574661655589277`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.39937708629741636`"}], "-", 
        RowBox[{"0.8556396572382761`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.180744662521227`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.0028801445033819206`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.023317298838046622`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.2799545652168963`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.6429884658905797`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.6772375558413634`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.7480854660638159`"}], "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.6862009746045252`", "\[InvisibleSpace]", "+", 
        RowBox[{"1.003407311082485`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.02336490651141277`"}], "+", 
        RowBox[{"0.8481700802720418`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"1.2375991174936245`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.41690644851326386`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.19377074128779703`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{490, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6419336]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"%", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->222300810],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"0.180744662521227`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.0028801445033819206`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"0.023317298838046622`", "\[InvisibleSpace]", "-", 
       RowBox[{"0.2799545652168963`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"0.6429884658905797`", "\[InvisibleSpace]", "-", 
       RowBox[{"0.6772375558413634`", " ", "\[ImaginaryI]"}]}]},
     {
      RowBox[{
       RowBox[{"-", "0.7480854660638159`"}], "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"0.6862009746045252`", "\[InvisibleSpace]", "+", 
       RowBox[{"1.003407311082485`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{
       RowBox[{"-", "0.02336490651141277`"}], "+", 
       RowBox[{"0.8481700802720418`", " ", "\[ImaginaryI]"}]}]},
     {
      RowBox[{"0.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"1.2375991174936245`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"0.41690644851326386`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.19377074128779703`", " ", "\[ImaginaryI]"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{477, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->64824876]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->332213070],

Cell["\<\
A matrix with entries having 24\[Hyphen]digit precision:\
\>", "ExampleText",
 CellID->407933956],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "2", "3", "4"},
        {"5", "6", "7", "8"},
        {"9", "10", "11", "12"},
        {"13", "14", "15", "16"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], ",", 
     "24"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53752998],

Cell["\<\
The Hessenberg decomposition is computed using 24 digit precision:\
\>", "ExampleText",
 CellID->85583924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HessenbergDecomposition", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->451581065],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`24.", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "0.30151134457776362264681206697006242581`24."}], ",", 
       "0.86164043685532912913968462087703152508`24.", ",", 
       "0.408248290463863016366214012449310663`24."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "0.54272042023997452076426172054611236645`24."}], ",", 
       "0.19694638556693237237478505619920515584`24.", ",", 
       RowBox[{"-", "0.81649658092772603273242802490216716653`24."}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "0.78392949590218541888171137412216230709`24."}], ",", 
       RowBox[{"-", "0.46774766572146438439011450847523107912`24."}], ",", 
       "0.40824829046386301636621401245176547566`24."}], "}"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`24.", ",", 
       RowBox[{"-", "5.36690193348419248311325479206960434018`24."}], ",", 
       "0.44312936752559783784326637645240475018`24.", ",", 
       RowBox[{
       "-", "3.62350277258556772894828627395050939`24.000000000000007*^-32"}]}\
], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
       "-", "16.58312395177699924557466368335343341963`23.999999999999996"}], 
       ",", "33.08727272727272727272727272726275846304`24.", ",", 
       RowBox[{"-", "9.55746361456854581587522113511780526682`24."}], ",", 
       "1.68332752702724223374516370357758897547`24.*^-29"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
       "-", "2.20899438621901152128336891099478731247`23.999999999999996"}], 
       ",", 
       RowBox[{
       "-", "0.08727272727272727272727272727983424388`23.999999999999996"}], 
       ",", 
       RowBox[{
       "-", "1.0313790089828242118191301574671371086`24.000000000000007*^-30"}\
]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "2.9700911044703646556366812890265620105`24.*^-30", 
       ",", "2.3719743162779096938354388383259129045`24.*^-30"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{526, 219},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->645457040]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9159],

Cell["A 4\[Times]4 random symmetric matrix:", "ExampleText",
 CellID->132283670],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"m", "=", 
  RowBox[{"r", ".", 
   RowBox[{"Transpose", "[", "r", "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->802427930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.5053163092983752`", ",", "1.0729476980736128`", ",", 
     "1.5019640880350038`", ",", "0.876479531976836`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.0729476980736128`", ",", "0.8724631571713302`", ",", 
     "0.9249121470394837`", ",", "0.5326305063764064`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.5019640880350038`", ",", "0.9249121470394837`", ",", 
     "2.0525556511438063`", ",", "1.2208121916192174`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.876479531976836`", ",", "0.5326305063764064`", ",", 
     "1.2208121916192174`", ",", "0.7584533634339594`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{538, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91851105]
}, Open  ]],

Cell["Compute its Hessenberg decomposition:", "ExampleText",
 CellID->48003965],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", ",", "h"}], "}"}], "=", 
   RowBox[{"HessenbergDecomposition", "[", "m", "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81098916],

Cell["Do 100 iterations of the unshifted QR algorithm:", "ExampleText",
 CellID->76998411],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", "h"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"q", ",", "r"}], "}"}], "=", 
      RowBox[{"QRDecomposition", "[", "a", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"a", " ", "=", " ", 
      RowBox[{"r", ".", 
       RowBox[{"Transpose", "[", "q", "]"}]}]}]}], ",", "\[IndentingNewLine]",
     
    RowBox[{"{", "100", "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{"MatrixForm", "[", "a", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->81103392],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"4.597478301994108`", "5.816397102855185`*^-16", 
      RowBox[{"-", "9.28117889740663`*^-16"}], 
      RowBox[{"-", "9.91498643312873`*^-17"}]},
     {
      RowBox[{"-", "1.3235175778781424`*^-93"}], "0.535447254112542`", 
      RowBox[{"-", "6.3716208373929595`*^-16"}], "1.3704519984412624`*^-16"},
     {"0.`", "1.6311969120610998`*^-120", "0.03398622746834092`", 
      RowBox[{"-", "2.4755977493619113`*^-16"}]},
     {"0.`", "0.`", "2.7351349341810684`*^-22", "0.02187669747247913`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{430, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->962619985]
}, Open  ]],

Cell["The eigenvalues lie along the diagonal:", "ExampleText",
 CellID->207325301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "m", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->9092337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.5974783019941095`", ",", "0.5354472541125418`", ",", 
   "0.03398622746834119`", ",", "0.021876697472479497`"}], "}"}]], "Output",
 ImageSize->{283, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->741813699]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21518],

Cell["A random 4\[Times]4 matrix:", "ExampleText",
 CellID->92972324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4201139],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.0701381692275842`", ",", "0.3451787391104275`", ",", 
     "0.4969068166691113`", ",", "0.5502439682895846`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.3158980328137573`", ",", "0.9426757131648826`", ",", 
     "0.22589019481188033`", ",", "0.24149649880756785`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.8939336978256525`", ",", "0.15496288316968942`", ",", 
     "0.6370011073470987`", ",", "0.9425513605578066`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.000014303856259001435`", ",", "0.43541736940157794`", ",", 
     "0.7570753580250587`", ",", "0.39420432785080783`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{566, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94553075]
}, Open  ]],

Cell["Compute its Hessenberg decomposition:", "ExampleText",
 CellID->290433069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"p", ",", "h"}], "}"}], "=", 
  RowBox[{"HessenbergDecomposition", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->323202113],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "0.33318776972446695`"}], ",", "0.2918907439878226`", ",",
        
       RowBox[{"-", "0.896540965979955`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "0.9428604933278443`"}], ",", 
       RowBox[{"-", "0.10316348201156067`"}], ",", "0.31681443480502014`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "0.000015086735181430649`"}], ",", "0.9508717524216846`", 
       ",", "0.3095850613626322`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.0701381692275842`", ",", 
       RowBox[{"-", "0.5835314419281487`"}], ",", "0.5727032879118347`", ",", 
       "0.018307684763330074`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9481081285636396`"}], ",", "0.7906077111397424`", ",", 
       
       RowBox[{"-", "0.9861537479665248`"}], ",", 
       RowBox[{"-", "0.10157595324174902`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "0.9032618806308874`"}], ",", "0.45320239282331376`", ",",
        
       RowBox[{"-", "0.26764698516286733`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", 
       RowBox[{"-", "0.023007251765170253`"}], ",", "0.7300710443997331`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{547, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->185069618]
}, Open  ]],

Cell[TextData[{
 "The matrix ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " is unitary:"
}], "ExampleText",
 CellID->677706825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"p", ".", 
   RowBox[{"ConjugateTranspose", "[", "p", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->407646194],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0.9999999999999999`", ",", "0", ",", "0"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0.9999999999999999`", ",", "0"}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0.9999999999999999`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->844646114]
}, Open  ]],

Cell[TextData[{
 "The matrix ",
 Cell[BoxData[
  FormBox["h", TraditionalForm]], "InlineMath"],
 " is upper Hessenberg:"
}], "ExampleText",
 CellID->2434662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayRules", "[", "h", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->72300198],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "0.0701381692275842`"}], ",", 
   
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", 
    RowBox[{"-", "0.5835314419281487`"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", "0.5727032879118347`"}], ",", 
   
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "0.018307684763330074`"}], 
   ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], "\[Rule]", 
    RowBox[{"-", "0.9481081285636396`"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "0.7906077111397424`"}], ",", 
   
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", 
    RowBox[{"-", "0.9861537479665248`"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], "\[Rule]", 
    RowBox[{"-", "0.10157595324174902`"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}], "\[Rule]", 
    RowBox[{"-", "0.9032618806308874`"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "0.45320239282331376`"}], ",",
    
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], "\[Rule]", 
    RowBox[{"-", "0.26764698516286733`"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}], "\[Rule]", 
    RowBox[{"-", "0.023007251765170253`"}]}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}], "\[Rule]", "0.7300710443997331`"}], ",", 
   
   RowBox[{
    RowBox[{"{", 
     RowBox[{"_", ",", "_"}], "}"}], "\[Rule]", "0"}]}], "}"}]], "Output",
 ImageSize->{519, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->45307864]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"%", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"i", "-", "j"}], ">", "1"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->668832648],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->333870615]
}, Open  ]],

Cell[TextData[{
 "The original matrix ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], ".", 
   StyleBox["h", "TI"], ".", 
   RowBox[{
    ButtonBox["ConjugateTranspose",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ConjugateTranspose"], "[", 
    StyleBox["p", "TI"], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4557685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"p", ".", "h", ".", 
    RowBox[{"ConjugateTranspose", "[", "p", "]"}]}], "-", "m"}], "//", 
  "Chop"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->717858557],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->195041991]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23061],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HessenbergDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HessenbergDecomposition"]], "InlineFormula"],
 " only works with matrices of approximate numerical values:"
}], "ExampleText",
 CellID->392763126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HessenbergDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39918277],

Cell[BoxData[
 RowBox[{
  RowBox[{"HessenbergDecomposition", "::", "\<\"schurf\"\>"}], ":", 
  " ", "\<\"\\!\\(HessenbergDecomposition\\) has received a matrix with \
infinite precision. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/HessenbergDecomposition/schurf\\\", \
ButtonNote -> \\\"HessenbergDecomposition::schurf\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->18714911],

Cell[BoxData[
 RowBox[{"HessenbergDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{388, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->372754958]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["JordanDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JordanDecomposition"]], "InlineFormula"],
 " for exact matrices:"
}], "ExampleText",
 CellID->520699055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JordanDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->600714495],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{
        FractionBox["1", "22"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "11"}], "-", 
          RowBox[{"3", " ", 
           SqrtBox["33"]}]}], ")"}]}], ",", 
       RowBox[{
        FractionBox["1", "22"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "11"}], "+", 
          RowBox[{"3", " ", 
           SqrtBox["33"]}]}], ")"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{
        FractionBox["1", "44"], " ", 
        RowBox[{"(", 
         RowBox[{"11", "-", 
          RowBox[{"3", " ", 
           SqrtBox["33"]}]}], ")"}]}], ",", 
       RowBox[{
        FractionBox["1", "44"], " ", 
        RowBox[{"(", 
         RowBox[{"11", "+", 
          RowBox[{"3", " ", 
           SqrtBox["33"]}]}], ")"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"15", "-", 
          RowBox[{"3", " ", 
           SqrtBox["33"]}]}], ")"}]}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"15", "+", 
          RowBox[{"3", " ", 
           SqrtBox["33"]}]}], ")"}]}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{557, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->180084267]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6915],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SchurDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SchurDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["QRDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/QRDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3068]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19373],

Cell[TextData[ButtonBox["Advanced Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedMatrixOperations"]], "Tutorials",
 CellID->16257]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->273344919],

Cell[TextData[ButtonBox["Matrix Decompositions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixDecompositions"]], "MoreAbout",
 CellID->164732843]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HessenbergDecomposition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 35.1317364}", "context" -> "System`", 
    "keywords" -> {
     "Hessenberg decomposition", "upper Hessenberg decomposition", 
      "upper Hessenberg matrix"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "HessenbergDecomposition[m] gives the Hessenberg decomposition of a \
matrix m. ", "synonyms" -> {"hessenberg decomposition"}, "title" -> 
    "HessenbergDecomposition", "type" -> "Symbol", "uri" -> 
    "ref/HessenbergDecomposition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4649, 160, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->2866987]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38481, 1293}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1926, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2549, 76, 59, 1, 70, "ObjectName",
 CellID->398],
Cell[2611, 79, 594, 18, 70, "Usage",
 CellID->4951]
}, Open  ]],
Cell[CellGroupData[{
Cell[3242, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3720, 119, 748, 28, 70, "Notes",
 CellID->12018],
Cell[4471, 149, 141, 6, 70, "Notes",
 CellID->111590495]
}, Closed]],
Cell[CellGroupData[{
Cell[4649, 160, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->2866987],
Cell[CellGroupData[{
Cell[5032, 174, 148, 5, 70, "ExampleSection",
 CellID->139984112],
Cell[5183, 181, 108, 3, 70, "ExampleText",
 CellID->857906094],
Cell[CellGroupData[{
Cell[5316, 188, 799, 23, 69, "Input",
 CellID->428833876],
Cell[6118, 213, 1660, 46, 113, "Output",
 CellID->48738734]
}, Open  ]],
Cell[7793, 262, 161, 6, 70, "ExampleText",
 CellID->17895849],
Cell[CellGroupData[{
Cell[7979, 272, 105, 3, 70, "Input",
 CellID->85255229],
Cell[8087, 277, 1175, 30, 104, "Output",
 CellID->70100533]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9311, 313, 216, 7, 70, "ExampleSection",
 CellID->27596],
Cell[9530, 322, 95, 1, 70, "ExampleText",
 CellID->538898342],
Cell[CellGroupData[{
Cell[9650, 327, 312, 10, 70, "Input",
 CellID->535646641],
Cell[9965, 339, 2798, 69, 122, "Output",
 CellID->6419336]
}, Open  ]],
Cell[CellGroupData[{
Cell[12800, 413, 158, 5, 70, "Input",
 CellID->222300810],
Cell[12961, 420, 1819, 43, 78, "Output",
 CellID->64824876]
}, Open  ]],
Cell[14795, 466, 125, 3, 70, "ExampleDelimiter",
 CellID->332213070],
Cell[14923, 471, 107, 3, 70, "ExampleText",
 CellID->407933956],
Cell[15033, 476, 792, 23, 70, "Input",
 CellID->53752998],
Cell[15828, 501, 116, 3, 70, "ExampleText",
 CellID->85583924],
Cell[CellGroupData[{
Cell[15969, 508, 119, 3, 70, "Input",
 CellID->451581065],
Cell[16091, 513, 2356, 60, 240, "Output",
 CellID->645457040]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18496, 579, 222, 7, 70, "ExampleSection",
 CellID->9159],
Cell[18721, 588, 80, 1, 70, "ExampleText",
 CellID->132283670],
Cell[CellGroupData[{
Cell[18826, 593, 374, 13, 70, "Input",
 CellID->802427930],
Cell[19203, 608, 832, 24, 54, "Output",
 CellID->91851105]
}, Open  ]],
Cell[20050, 635, 79, 1, 70, "ExampleText",
 CellID->48003965],
Cell[20132, 638, 209, 7, 70, "Input",
 CellID->81098916],
Cell[20344, 647, 90, 1, 70, "ExampleText",
 CellID->76998411],
Cell[CellGroupData[{
Cell[20459, 652, 602, 19, 70, "Input",
 CellID->81103392],
Cell[21064, 673, 1191, 29, 104, "Output",
 CellID->962619985]
}, Open  ]],
Cell[22270, 705, 82, 1, 70, "ExampleText",
 CellID->207325301],
Cell[CellGroupData[{
Cell[22377, 710, 105, 3, 70, "Input",
 CellID->9092337],
Cell[22485, 715, 306, 9, 36, "Output",
 CellID->741813699]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22840, 730, 233, 7, 70, "ExampleSection",
 CellID->21518],
Cell[23076, 739, 69, 1, 70, "ExampleText",
 CellID->92972324],
Cell[CellGroupData[{
Cell[23170, 744, 253, 9, 70, "Input",
 CellID->4201139],
Cell[23426, 755, 844, 24, 71, "Output",
 CellID->94553075]
}, Open  ]],
Cell[24285, 782, 80, 1, 70, "ExampleText",
 CellID->290433069],
Cell[CellGroupData[{
Cell[24390, 787, 189, 6, 70, "Input",
 CellID->323202113],
Cell[24582, 795, 1686, 46, 105, "Output",
 CellID->185069618]
}, Open  ]],
Cell[26283, 844, 150, 6, 70, "ExampleText",
 CellID->677706825],
Cell[CellGroupData[{
Cell[26458, 854, 169, 5, 70, "Input",
 CellID->407646194],
Cell[26630, 861, 567, 18, 36, "Output",
 CellID->844646114]
}, Open  ]],
Cell[27212, 882, 157, 6, 70, "ExampleText",
 CellID->2434662],
Cell[CellGroupData[{
Cell[27394, 892, 105, 3, 70, "Input",
 CellID->72300198],
Cell[27502, 897, 1862, 62, 88, "Output",
 CellID->45307864]
}, Open  ]],
Cell[CellGroupData[{
Cell[29401, 964, 362, 13, 70, "Input",
 CellID->668832648],
Cell[29766, 979, 175, 6, 36, "Output",
 CellID->333870615]
}, Open  ]],
Cell[29956, 988, 432, 16, 70, "ExampleText",
 CellID->4557685],
Cell[CellGroupData[{
Cell[30413, 1008, 203, 7, 70, "Input",
 CellID->717858557],
Cell[30619, 1017, 500, 15, 36, "Output",
 CellID->195041991]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31168, 1038, 226, 7, 70, "ExampleSection",
 CellID->23061],
Cell[31397, 1047, 265, 7, 70, "ExampleText",
 CellID->392763126],
Cell[CellGroupData[{
Cell[31687, 1058, 358, 11, 70, "Input",
 CellID->39918277],
Cell[32048, 1071, 460, 9, 70, "Message",
 CellID->18714911],
Cell[32511, 1082, 448, 14, 36, "Output",
 CellID->372754958]
}, Open  ]],
Cell[32974, 1099, 228, 8, 70, "ExampleText",
 CellID->520699055],
Cell[CellGroupData[{
Cell[33227, 1111, 355, 11, 70, "Input",
 CellID->600714495],
Cell[33585, 1124, 1787, 62, 81, "Output",
 CellID->180084267]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35433, 1193, 310, 9, 70, "SeeAlsoSection",
 CellID->6915],
Cell[35746, 1204, 484, 17, 70, "SeeAlso",
 CellID->3068]
}, Open  ]],
Cell[CellGroupData[{
Cell[36267, 1226, 314, 9, 70, "TutorialsSection",
 CellID->19373],
Cell[36584, 1237, 161, 3, 70, "Tutorials",
 CellID->16257]
}, Open  ]],
Cell[CellGroupData[{
Cell[36782, 1245, 319, 9, 70, "MoreAboutSection",
 CellID->273344919],
Cell[37104, 1256, 153, 3, 70, "MoreAbout",
 CellID->164732843]
}, Open  ]],
Cell[37272, 1262, 29, 0, 70, "History"],
Cell[37304, 1264, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

