(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     64040,       2143]
NotebookOptionsPosition[     52148,       1725]
NotebookOutlinePosition[     53550,       1763]
CellTagsIndexPosition[     53464,       1758]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Non\[Hyphen]Standard Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NonStandardEvaluation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Non\[Hyphen]Standard Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Unevaluated" :> 
          Documentation`HelpLookup["paclet:ref/Unevaluated"], "Hold" :> 
          Documentation`HelpLookup["paclet:ref/Hold"], "HoldFirst" :> 
          Documentation`HelpLookup["paclet:ref/HoldFirst"], "HoldRest" :> 
          Documentation`HelpLookup["paclet:ref/HoldRest"], "NHoldAll" :> 
          Documentation`HelpLookup["paclet:ref/NHoldAll"], "HoldAllComplete" :> 
          Documentation`HelpLookup["paclet:ref/HoldAllComplete"], 
          "SequenceHold" :> 
          Documentation`HelpLookup["paclet:ref/SequenceHold"], "Extract" :> 
          Documentation`HelpLookup["paclet:ref/Extract"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Unevaluated\"\>", 2->"\<\"Hold\"\>", 
       3->"\<\"HoldFirst\"\>", 4->"\<\"HoldRest\"\>", 5->"\<\"NHoldAll\"\>", 
       6->"\<\"HoldAllComplete\"\>", 7->"\<\"SequenceHold\"\>", 
       8->"\<\"Extract\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], 
          "Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Evaluation Control\"\>", 
       3->"\<\"Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HoldAll", "ObjectName",
 CellID->13716],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["HoldAll",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
     "\[LineSeparator]is an attribute which specifies that all arguments to a \
function are to be maintained in an unevaluated form. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5797]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to evaluate the arguments of a ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 " function in a controlled way. "
}], "Notes",
 CellID->6118],

Cell[TextData[{
 "Even when a function has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " objects that appear in its arguments are still by default flattened, ",
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " wrappers are stripped, and upvalues associated with the arguments are \
used. "
}], "Notes",
 CellID->17718]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->405683340],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->94219589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Hold", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->214973860],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldAll", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214083629]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"2", "+", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->241939639],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"2", "+", "2"}]}], "]"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->156254310]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->194648803],

Cell[TextData[{
 "Many functions with scoping behavior have the ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 " attribute: "
}], "ExampleText",
 CellID->18789979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Plot", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50175288],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldAll", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22034833]
}, Open  ]],

Cell["\<\
Plotting lists of functions will use separate styling for the different \
functions: \
\>", "ExampleText",
 CellID->93148511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111103089],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9583560]
}, Open  ]],

Cell["\<\
If the list structure is not manifest, no separate styling is provided: \
\>", "ExampleText",
 CellID->62969459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Through", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Sin", ",", "Cos"}], "}"}], "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", " ", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->413376666],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->597944767]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to make the list structure manifest: "
}], "ExampleText",
 CellID->229825121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Through", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Sin", ",", "Cos"}], "}"}], "[", "x", "]"}], "]"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", " ", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->267357216],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->108416997]
}, Open  ]],

Cell["\<\
Different vector-valued functions in a list will still get separate styling: \
\
\>", "ExampleText",
 CellID->28813546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Through", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Sin", ",", "Cos"}], "}"}], "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Through", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Tan", ",", "Cot"}], "}"}], "[", "x", "]"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->569429116],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->426968082]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56597008],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " to suppress evaluation of symbols wherever it would occur:"
}], "ExampleText",
 CellID->647493465],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"symbolLength", ",", "HoldAll"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"symbolLength", "[", "s_Symbol", "]"}], ":=", 
  RowBox[{"StringLength", "[", 
   RowBox[{"SymbolName", "[", 
    RowBox[{"Unevaluated", "[", "s", "]"}], "]"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->102661486],

Cell["Find the length of a symbol's name even if it has a value:", \
"ExampleText",
 CellID->484084944],

Cell[BoxData[
 RowBox[{
  RowBox[{"xyzzy", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->392605825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"symbolLength", "[", "xyzzy", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->393731316],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->194896695]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->416129878],

Cell["Implement your own control structure:", "ExampleText",
 CellID->36967352],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"until", "::", "usage"}], "=", 
   "\"\<until[cond,cmd] repeats evaluating cmd until cond is True.\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166716070],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"until", ",", "HoldAll"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52661152],

Cell[BoxData[
 RowBox[{
  RowBox[{"until", "[", 
   RowBox[{"cond_", ",", "cmd_"}], "]"}], ":=", 
  RowBox[{"While", "[", 
   RowBox[{"True", ",", 
    RowBox[{"cmd", ";", 
     RowBox[{"If", "[", 
      RowBox[{"cond", ",", 
       RowBox[{"Return", "[", "]"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->347530131],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"i", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"until", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Prime", "[", "i", "]"}], ">", 
     RowBox[{"10", "^", "6"}]}], ",", 
    RowBox[{"i", "++"}]}], "]"}], ";", "i"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->587780414],

Cell[BoxData["78499"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->767781665]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(14)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->107276950],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " is a container with the attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->605051125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Hold", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33902385],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldAll", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75259850]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->521836159],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92336356]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->885699882],

Cell[TextData[{
 "Functions that operate on symbols often need the ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->17214704],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"i", "=", "5"}], ";"}], "\n", 
 RowBox[{"Protect", "[", "i", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->330097557],

Cell[BoxData[
 RowBox[{"{", "\<\"i\"\>", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182846208]
}, Open  ]],

Cell["\<\
Without the attribute, they would operate on the symbol's value:\
\>", "ExampleText",
 CellID->48717380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Protect", "[", 
  RowBox[{"Evaluate", "[", "i", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->607371029],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "::", "\<\"pssl\"\>"}], ":", 
  " ", "\<\"\\!\\(5\\) is not a string, symbol, or list of strings and \
symbols.\"\>"}]], "Message", "MSG",
 CellID->62934152],

Cell[BoxData[
 RowBox[{"Protect", "[", "5", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->100521786]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->378339699],

Cell[TextData[{
 "Control structures such as ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " protect their arguments from evaluation:"
}], "ExampleText",
 CellID->436782669],

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->354187944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"i", ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "i"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->91586148],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->377575031]
}, Open  ]],

Cell["\<\
Otherwise, global values might interfere with their operation:\
\>", "ExampleText",
 CellID->374721545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "i"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->265001445],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "5", ",", "5", ",", "5", ",", "5"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->330753757]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165054271],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to force evaluation of an argument of a ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->27416402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Unprotect", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57342049],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldAll", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->843850504]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"syms", "=", 
   RowBox[{"{", 
    RowBox[{"Plus", ",", "Times"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->101592130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unprotect", "[", 
  RowBox[{"Evaluate", "[", "syms", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->548315630],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Plus\"\>", ",", "\<\"Times\"\>"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->306498580]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->189303037],

Cell["\<\
Force evaluation of the right-hand side of a delayed definition:\
\>", "ExampleText",
 CellID->71912026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "^", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->693797959],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"3", " ", "x"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->750270120]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"Evaluate", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->514862557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->81399932],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVc1OAkEMLjP7I4oSMUHQCxfjkygnHmJDTOBgNMhNX8mfg/p62M5Ocbbb
yS6BTXa77df5pl87LLNivXh4LNbLeTGZrornxXL+Mrl/WmHIdgDMHQD0R4Dv
G3xzN19TvAGO8WkwPPCW0dstCnYbhi4+MnStiPOqG7eqhMuLkhJyk3Bv2sl4
eyK4Mh/vo03RZgpObip48pZ5PZGXCJyC306AEZmp8E1Vl8LNWhKv5UjBazuk
YafAK6juI3narjvV1lUyyPy0Um+9Nsk5VvpLpXUjfc8b8N7m/xzwfH73qpAZ
m6YRq0jGY3lnCv9uCtqfsPMGLbnPy2qMsgvxzF1Oz2G+AVLVQOlPyHPRgJO1
fjIyzpP5ajUZWYk89W72tV/kWI3KmY6ET493l2t9/XzC+Kt9FfSL8OtAZ8g0
VJg/HPObQC6jNbwGCFU/FD5lfqqc8d25G+V/EnT+AHx2jIU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->635646]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->684979358],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " to temporarily treat a function as if it were ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->682373314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{"1", "+", "2", "+", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186589571],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236377383]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"1", "+", "2", "+", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->197078158],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->715294377]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->793270204],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " inside a held expression is not removed:"
}], "ExampleText",
 CellID->34412881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{"1", "+", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64023909],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{"1", "+", "1"}], "]"}], "]"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178327458]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->334705855],

Cell["This is the full form of the evaluation result:", "ExampleText",
 CellID->349528814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"1", "-", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95543354],

Cell[BoxData[
 TagBox[
  StyleBox["0",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->110274350]
}, Open  ]],

Cell["This is the full form of the input, before evaluation:", "ExampleText",
 CellID->198605909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"HoldForm", "[", 
   RowBox[{"1", "-", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23603201],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"HoldForm", "[", 
    RowBox[{"Plus", "[", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->553023102]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "HoldForm", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->510565445],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldAll", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->177037512]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->300688162],

Cell["Suppress the evaluation of the arguments of a pure function:", \
"ExampleText",
 CellID->11317377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{"e", ",", 
    RowBox[{"Hold", "[", "e", "]"}], ",", 
    RowBox[{"{", "HoldAll", "}"}]}], "]"}], "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164068536],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24245167]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{"e", ",", 
    RowBox[{"Hold", "[", "e", "]"}]}], "]"}], "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->138213463],

Cell[BoxData[
 RowBox[{"Hold", "[", "3", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->285095803]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19904824],

Cell[TextData[{
 "Sequence splicing still happens for ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellID->850619505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Sequence", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180207843],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147181078]
}, Open  ]],

Cell[TextData[{
 "Use the container ",
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 " to suppress even such transformations:"
}], "ExampleText",
 CellID->87966944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"Sequence", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->392403838],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"Sequence", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->262131265]
}, Open  ]],

Cell[TextData[{
 "The attribute that causes this behavior is ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->550900495],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "HoldComplete", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->482928990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldAllComplete", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->120388900]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->681709298],

Cell["Substitution works inside a held expression:", "ExampleText",
 CellID->868335451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hold", "[", 
   RowBox[{"f", "[", 
    RowBox[{"1", "+", "2"}], "]"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "\[RuleDelayed]", 
   RowBox[{"g", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->518668429],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"g", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154652230]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83696512],

Cell["Insert into a held expression:", "ExampleText",
 CellID->9266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Insert", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{"x", "+", "x"}], "]"}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23627],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"x", "+", "y", "+", "x"}], "]"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9425]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->129068699],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NHoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldAll"]], "InlineFormula"],
 " protects arguments from ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ", but evaluates them normally otherwise:"
}], "ExampleText",
 CellID->86996294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Derivative", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->767358920],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"NHoldAll", ",", "ReadProtected"}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->760495825]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Derivative", "[", 
   RowBox[{"1", "+", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->512953285],

Cell[BoxData[
 RowBox[{"Derivative", "[", "2", "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->538556349]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"f", "[", 
   RowBox[{"1", "+", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->483840498],

Cell[BoxData[
 RowBox[{"f", "[", "2.`", "]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->539474852]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67441542],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
 " protects patterns from evaluation, but does not interfere with pattern \
matching:"
}], "ExampleText",
 CellID->29434436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"_", "+", "_"}], "]"}], ",", 
   RowBox[{"_", "+", "_"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63970598],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"_", "+", "_"}], "]"}], ",", 
   RowBox[{"2", " ", "_"}]}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->937817745]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4371],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unevaluated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unevaluated"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hold"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldFirst",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldFirst"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldRest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldRest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NHoldAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NHoldAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldAllComplete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldAllComplete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SequenceHold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SequenceHold"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Extract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extract"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26176]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3777],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->20381],

Cell[TextData[ButtonBox["Non\[Hyphen]Standard Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonStandardEvaluation"]], "Tutorials",
 CellID->16065]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->381028165],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->372008710],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->189417828],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->127645646]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HoldAll - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 40.2099914}", "context" -> "System`", 
    "keywords" -> {
     "attribute", "container", "custom evaluation", "evaluation control", 
      "macro expansion", "suppressing evaluation", "taylor made evaluation"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "HoldAll is an attribute which specifies that all arguments to a function \
are to be maintained in an unevaluated form. ", "synonyms" -> {"hold all"}, 
    "title" -> "HoldAll", "type" -> "Symbol", "uri" -> "ref/HoldAll"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5558, 169, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->405683340]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 53321, 1751}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2862, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3485, 91, 45, 1, 70, "ObjectName",
 CellID->13716],
Cell[3533, 94, 492, 14, 70, "Usage",
 CellID->5797]
}, Open  ]],
Cell[CellGroupData[{
Cell[4062, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4540, 130, 368, 13, 70, "Notes",
 CellID->6118],
Cell[4911, 145, 610, 19, 70, "Notes",
 CellID->17718]
}, Closed]],
Cell[CellGroupData[{
Cell[5558, 169, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->405683340],
Cell[CellGroupData[{
Cell[5943, 183, 147, 5, 70, "ExampleSection",
 CellID->94219589],
Cell[CellGroupData[{
Cell[6115, 192, 109, 3, 28, "Input",
 CellID->214973860],
Cell[6227, 197, 218, 7, 36, "Output",
 CellID->214083629]
}, Open  ]],
Cell[CellGroupData[{
Cell[6482, 209, 171, 6, 28, "Input",
 CellID->241939639],
Cell[6656, 217, 260, 9, 36, "Output",
 CellID->156254310]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6965, 232, 227, 7, 70, "ExampleSection",
 CellID->194648803],
Cell[7195, 241, 237, 8, 70, "ExampleText",
 CellID->18789979],
Cell[CellGroupData[{
Cell[7457, 253, 108, 3, 70, "Input",
 CellID->50175288],
Cell[7568, 258, 217, 7, 36, "Output",
 CellID->22034833]
}, Open  ]],
Cell[7800, 268, 135, 4, 70, "ExampleText",
 CellID->93148511],
Cell[CellGroupData[{
Cell[7960, 276, 322, 11, 70, "Input",
 CellID->111103089],
Cell[8285, 289, 3797, 66, 70, "Output",
 Evaluatable->False,
 CellID->9583560]
}, Open  ]],
Cell[12097, 358, 122, 3, 70, "ExampleText",
 CellID->62969459],
Cell[CellGroupData[{
Cell[12244, 365, 334, 11, 70, "Input",
 CellID->413376666],
Cell[12581, 378, 3409, 60, 70, "Output",
 Evaluatable->False,
 CellID->597944767]
}, Open  ]],
Cell[16005, 441, 224, 8, 70, "ExampleText",
 CellID->229825121],
Cell[CellGroupData[{
Cell[16254, 453, 378, 13, 70, "Input",
 CellID->267357216],
Cell[16635, 468, 3799, 66, 70, "Output",
 Evaluatable->False,
 CellID->108416997]
}, Open  ]],
Cell[20449, 537, 129, 4, 70, "ExampleText",
 CellID->28813546],
Cell[CellGroupData[{
Cell[20603, 545, 520, 18, 70, "Input",
 CellID->569429116],
Cell[21126, 565, 5747, 98, 70, "Output",
 Evaluatable->False,
 CellID->426968082]
}, Open  ]],
Cell[26888, 666, 124, 3, 70, "ExampleDelimiter",
 CellID->56597008],
Cell[27015, 671, 378, 13, 70, "ExampleText",
 CellID->647493465],
Cell[27396, 686, 367, 10, 70, "Input",
 CellID->102661486],
Cell[27766, 698, 103, 2, 70, "ExampleText",
 CellID->484084944],
Cell[27872, 702, 114, 4, 70, "Input",
 CellID->392605825],
Cell[CellGroupData[{
Cell[28011, 710, 112, 3, 70, "Input",
 CellID->393731316],
Cell[28126, 715, 158, 5, 36, "Output",
 CellID->194896695]
}, Open  ]],
Cell[28299, 723, 125, 3, 70, "ExampleDelimiter",
 CellID->416129878],
Cell[28427, 728, 79, 1, 70, "ExampleText",
 CellID->36967352],
Cell[28509, 731, 215, 7, 70, "Input",
 CellID->166716070],
Cell[28727, 740, 141, 4, 70, "Input",
 CellID->52661152],
Cell[28871, 746, 337, 11, 70, "Input",
 CellID->347530131],
Cell[CellGroupData[{
Cell[29233, 761, 309, 11, 70, "Input",
 CellID->587780414],
Cell[29545, 774, 162, 5, 36, "Output",
 CellID->767781665]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29756, 785, 238, 7, 70, "ExampleSection",
 CellID->107276950],
Cell[29997, 794, 327, 12, 70, "ExampleText",
 CellID->605051125],
Cell[CellGroupData[{
Cell[30349, 810, 108, 3, 70, "Input",
 CellID->33902385],
Cell[30460, 815, 217, 7, 36, "Output",
 CellID->75259850]
}, Open  ]],
Cell[CellGroupData[{
Cell[30714, 827, 123, 4, 70, "Input",
 CellID->521836159],
Cell[30840, 833, 210, 7, 36, "Output",
 CellID->92336356]
}, Open  ]],
Cell[31065, 843, 125, 3, 70, "ExampleDelimiter",
 CellID->885699882],
Cell[31193, 848, 239, 8, 70, "ExampleText",
 CellID->17214704],
Cell[CellGroupData[{
Cell[31457, 860, 156, 5, 70, "Input",
 CellID->330097557],
Cell[31616, 867, 188, 6, 36, "Output",
 CellID->182846208]
}, Open  ]],
Cell[31819, 876, 114, 3, 70, "ExampleText",
 CellID->48717380],
Cell[CellGroupData[{
Cell[31958, 883, 138, 4, 70, "Input",
 CellID->607371029],
Cell[32099, 889, 202, 5, 70, "Message",
 CellID->62934152],
Cell[32304, 896, 191, 6, 36, "Output",
 CellID->100521786]
}, Open  ]],
Cell[32510, 905, 125, 3, 70, "ExampleDelimiter",
 CellID->378339699],
Cell[32638, 910, 244, 8, 70, "ExampleText",
 CellID->436782669],
Cell[32885, 920, 110, 4, 70, "Input",
 CellID->354187944],
Cell[CellGroupData[{
Cell[33020, 928, 182, 6, 70, "Input",
 CellID->91586148],
Cell[33205, 936, 233, 7, 36, "Output",
 CellID->377575031]
}, Open  ]],
Cell[33453, 946, 113, 3, 70, "ExampleText",
 CellID->374721545],
Cell[CellGroupData[{
Cell[33591, 953, 219, 7, 70, "Input",
 CellID->265001445],
Cell[33813, 962, 233, 7, 36, "Output",
 CellID->330753757]
}, Open  ]],
Cell[34061, 972, 125, 3, 70, "ExampleDelimiter",
 CellID->165054271],
Cell[34189, 977, 358, 13, 70, "ExampleText",
 CellID->27416402],
Cell[CellGroupData[{
Cell[34572, 994, 113, 3, 70, "Input",
 CellID->57342049],
Cell[34688, 999, 218, 7, 36, "Output",
 CellID->843850504]
}, Open  ]],
Cell[34921, 1009, 169, 6, 70, "Input",
 CellID->101592130],
Cell[CellGroupData[{
Cell[35115, 1019, 143, 4, 70, "Input",
 CellID->548315630],
Cell[35261, 1025, 226, 7, 36, "Output",
 CellID->306498580]
}, Open  ]],
Cell[35502, 1035, 125, 3, 70, "ExampleDelimiter",
 CellID->189303037],
Cell[35630, 1040, 114, 3, 70, "ExampleText",
 CellID->71912026],
Cell[CellGroupData[{
Cell[35769, 1047, 174, 6, 70, "Input",
 CellID->693797959],
Cell[35946, 1055, 296, 10, 36, "Output",
 CellID->750270120]
}, Open  ]],
Cell[36257, 1068, 157, 5, 70, "Input",
 CellID->514862557],
Cell[CellGroupData[{
Cell[36439, 1077, 105, 3, 70, "Input",
 CellID->81399932],
Cell[36547, 1082, 684, 15, 70, "Output",
 Evaluatable->False,
 CellID->635646]
}, Open  ]],
Cell[37246, 1100, 125, 3, 70, "ExampleDelimiter",
 CellID->684979358],
Cell[37374, 1105, 362, 13, 70, "ExampleText",
 CellID->682373314],
Cell[CellGroupData[{
Cell[37761, 1122, 174, 5, 70, "Input",
 CellID->186589571],
Cell[37938, 1129, 158, 5, 36, "Output",
 CellID->236377383]
}, Open  ]],
Cell[CellGroupData[{
Cell[38133, 1139, 135, 4, 70, "Input",
 CellID->197078158],
Cell[38271, 1145, 158, 5, 36, "Output",
 CellID->715294377]
}, Open  ]],
Cell[38444, 1153, 125, 3, 70, "ExampleDelimiter",
 CellID->793270204],
Cell[38572, 1158, 223, 7, 70, "ExampleText",
 CellID->34412881],
Cell[CellGroupData[{
Cell[38820, 1169, 161, 5, 70, "Input",
 CellID->64023909],
Cell[38984, 1176, 251, 8, 36, "Output",
 CellID->178327458]
}, Open  ]],
Cell[39250, 1187, 125, 3, 70, "ExampleDelimiter",
 CellID->334705855],
Cell[39378, 1192, 90, 1, 70, "ExampleText",
 CellID->349528814],
Cell[CellGroupData[{
Cell[39493, 1197, 126, 4, 70, "Input",
 CellID->95543354],
Cell[39622, 1203, 289, 11, 50, "Output",
 CellID->110274350]
}, Open  ]],
Cell[39926, 1217, 97, 1, 70, "ExampleText",
 CellID->198605909],
Cell[CellGroupData[{
Cell[40048, 1222, 162, 5, 70, "Input",
 CellID->23603201],
Cell[40213, 1229, 407, 15, 50, "Output",
 CellID->553023102]
}, Open  ]],
Cell[CellGroupData[{
Cell[40657, 1249, 113, 3, 70, "Input",
 CellID->510565445],
Cell[40773, 1254, 218, 7, 36, "Output",
 CellID->177037512]
}, Open  ]],
Cell[41006, 1264, 125, 3, 70, "ExampleDelimiter",
 CellID->300688162],
Cell[41134, 1269, 104, 2, 70, "ExampleText",
 CellID->11317377],
Cell[CellGroupData[{
Cell[41263, 1275, 253, 8, 70, "Input",
 CellID->164068536],
Cell[41519, 1285, 210, 7, 36, "Output",
 CellID->24245167]
}, Open  ]],
Cell[CellGroupData[{
Cell[41766, 1297, 212, 7, 70, "Input",
 CellID->138213463],
Cell[41981, 1306, 188, 6, 36, "Output",
 CellID->285095803]
}, Open  ]],
Cell[42184, 1315, 124, 3, 70, "ExampleDelimiter",
 CellID->19904824],
Cell[42311, 1320, 227, 8, 70, "ExampleText",
 CellID->850619505],
Cell[CellGroupData[{
Cell[42563, 1332, 169, 5, 70, "Input",
 CellID->180207843],
Cell[42735, 1339, 221, 7, 36, "Output",
 CellID->147181078]
}, Open  ]],
Cell[42971, 1349, 246, 8, 70, "ExampleText",
 CellID->87966944],
Cell[CellGroupData[{
Cell[43242, 1361, 177, 5, 70, "Input",
 CellID->392403838],
Cell[43422, 1368, 266, 8, 36, "Output",
 CellID->262131265]
}, Open  ]],
Cell[43703, 1379, 240, 8, 70, "ExampleText",
 CellID->550900495],
Cell[CellGroupData[{
Cell[43968, 1391, 117, 3, 70, "Input",
 CellID->482928990],
Cell[44088, 1396, 226, 7, 36, "Output",
 CellID->120388900]
}, Open  ]],
Cell[44329, 1406, 125, 3, 70, "ExampleDelimiter",
 CellID->681709298],
Cell[44457, 1411, 87, 1, 70, "ExampleText",
 CellID->868335451],
Cell[CellGroupData[{
Cell[44569, 1416, 273, 9, 70, "Input",
 CellID->518668429],
Cell[44845, 1427, 240, 8, 36, "Output",
 CellID->154652230]
}, Open  ]],
Cell[45100, 1438, 124, 3, 70, "ExampleDelimiter",
 CellID->83696512],
Cell[45227, 1443, 68, 1, 70, "ExampleText",
 CellID->9266],
Cell[CellGroupData[{
Cell[45320, 1448, 237, 8, 70, "Input",
 CellID->23627],
Cell[45560, 1458, 216, 7, 36, "Output",
 CellID->9425]
}, Open  ]],
Cell[45791, 1468, 125, 3, 70, "ExampleDelimiter",
 CellID->129068699],
Cell[45919, 1473, 351, 12, 70, "ExampleText",
 CellID->86996294],
Cell[CellGroupData[{
Cell[46295, 1489, 115, 3, 70, "Input",
 CellID->767358920],
Cell[46413, 1494, 223, 7, 36, "Output",
 CellID->760495825]
}, Open  ]],
Cell[CellGroupData[{
Cell[46673, 1506, 158, 5, 70, "Input",
 CellID->512953285],
Cell[46834, 1513, 194, 6, 36, "Output",
 CellID->538556349]
}, Open  ]],
Cell[CellGroupData[{
Cell[47065, 1524, 149, 5, 70, "Input",
 CellID->483840498],
Cell[47217, 1531, 187, 6, 36, "Output",
 CellID->539474852]
}, Open  ]],
Cell[47419, 1540, 124, 3, 70, "ExampleDelimiter",
 CellID->67441542],
Cell[47546, 1545, 265, 8, 70, "ExampleText",
 CellID->29434436],
Cell[CellGroupData[{
Cell[47836, 1557, 202, 7, 70, "Input",
 CellID->63970598],
Cell[48041, 1566, 292, 10, 36, "Output",
 CellID->937817745]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[48394, 1583, 310, 9, 70, "SeeAlsoSection",
 CellID->4371],
Cell[48707, 1594, 1941, 71, 70, "SeeAlso",
 CellID->26176]
}, Open  ]],
Cell[CellGroupData[{
Cell[50685, 1670, 313, 9, 70, "TutorialsSection",
 CellID->3777],
Cell[51001, 1681, 131, 3, 70, "Tutorials",
 CellID->20381],
Cell[51135, 1686, 163, 3, 70, "Tutorials",
 CellID->16065]
}, Open  ]],
Cell[CellGroupData[{
Cell[51335, 1694, 319, 9, 70, "MoreAboutSection",
 CellID->381028165],
Cell[51657, 1705, 132, 3, 70, "MoreAbout",
 CellID->372008710],
Cell[51792, 1710, 147, 3, 70, "MoreAbout",
 CellID->189417828],
Cell[51942, 1715, 134, 3, 70, "MoreAbout",
 CellID->127645646]
}, Open  ]],
Cell[52091, 1721, 27, 0, 70, "History"],
Cell[52121, 1723, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

