(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21634,        825]
NotebookOptionsPosition[     15911,        626]
NotebookOutlinePosition[     17257,        665]
CellTagsIndexPosition[     17172,        660]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Non\[Hyphen]Standard Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NonStandardEvaluation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Non\[Hyphen]Standard Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HoldRest" :> Documentation`HelpLookup["paclet:ref/HoldRest"], 
          "HoldAll" :> Documentation`HelpLookup["paclet:ref/HoldAll"], 
          "Unevaluated" :> 
          Documentation`HelpLookup["paclet:ref/Unevaluated"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"HoldRest\"\>", 2->"\<\"HoldAll\"\>",
        3->"\<\"Unevaluated\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], 
          "Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Defining Variables and Functions" :> 
          Documentation`HelpLookup["paclet:guide/VariablesAndFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Evaluation Control\"\>", 3->"\<\"Expressions\"\>", 
       4->"\<\"Defining Variables and Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HoldFirst", "ObjectName",
 CellID->19232],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["HoldFirst",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
     "\[LineSeparator]is an attribute which specifies that the first argument \
to a function is to be maintained in an unevaluated form. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21119]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->101772250],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"h", ",", "HoldFirst"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14854230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"2", "+", "2"}], ",", 
   RowBox[{"3", "+", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->183845511],

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", "4", ",", "6"}], "]"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->827024578]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3834],

Cell["\<\
Definitions for unevaluated expressions can implement call-by-name semantics:\
\
\>", "ExampleText",
 CellID->168206393],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "HoldFirst"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->502240157],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"sym_", ",", "val_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{"sym", "=", 
    RowBox[{"val", "^", "2"}]}], ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->895056328],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "17"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2015326747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1226042871],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->206819475]
}, Open  ]],

Cell["The global variable has been modified:", "ExampleText",
 CellID->378977781],

Cell[CellGroupData[{

Cell[BoxData["x"], "Input",
 CellLabel->"In[5]:=",
 CellID->1638890171],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->29966374]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3547],

Cell[TextData[{
 "Functions that operate on symbols often need the ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->136756711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "SetAttributes", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310559383],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldFirst", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118351433]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"i", "=", "5"}], ";"}], "\n", 
 RowBox[{"SetAttributes", "[", 
  RowBox[{"i", ",", "Constant"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->86854362],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->362939665],

Cell["Assignments do not evaluate their left-hand sides:", "ExampleText",
 CellID->41390641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Set", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->836878851],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldFirst", ",", "Protected", ",", "SequenceHold"}], 
  "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->774239479]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->407430311],

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", "6"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->224855426],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165054271],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to force evaluation of an argument of a ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->27416402],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"h", ",", "HoldFirst"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->588124331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"1", "+", "1"}], "]"}], ",", 
   RowBox[{"2", "+", "2"}], ",", 
   RowBox[{"3", "+", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->729169503],

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{"2", ",", "4", ",", "6"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41602241]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->300688162],

Cell["\<\
Suppress the evaluation of the first argument of a pure function:\
\>", "ExampleText",
 CellID->11317377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}], ",", 
    RowBox[{"Hold", "[", 
     RowBox[{"e", ",", "f"}], "]"}], ",", 
    RowBox[{"{", "HoldFirst", "}"}]}], "]"}], "[", 
  RowBox[{
   RowBox[{"1", "+", "2"}], ",", 
   RowBox[{"2", "+", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164068536],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{
   RowBox[{"1", "+", "2"}], ",", "5"}], "]"}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90736930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29094805],

Cell[TextData[{
 "Sequence splitting still happens for ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellID->112207468],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "HoldFirst"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->673642059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"Sequence", "[", 
    RowBox[{
     RowBox[{"1", "+", "1"}], ",", 
     RowBox[{"2", "+", "2"}]}], "]"}], ",", 
   RowBox[{"3", "+", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99039703],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", "4", ",", "6"}], "]"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44788762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->129068699],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NHoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldFirst"]], "InlineFormula"],
 " protects arguments from ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ", but evaluates them normally otherwise:"
}], "ExampleText",
 CellID->86996294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "EllipticTheta", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->767358920],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Listable", ",", "NHoldFirst", ",", "Protected"}], "}"}]], "Output",\

 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->408984738]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"EllipticTheta", "[", 
   RowBox[{"1", ",", "a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->512953285],

Cell[BoxData[
 RowBox[{"EllipticTheta", "[", 
  RowBox[{"1", ",", "a", ",", "b"}], "]"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->301836863]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EllipticTheta", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", "a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->483840498],

Cell[BoxData[
 RowBox[{"EllipticTheta", "[", 
  RowBox[{"2", ",", "a", ",", "b"}], "]"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->187808166]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29831],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldRest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldRest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unevaluated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unevaluated"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31101]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30337],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->23566],

Cell[TextData[ButtonBox["Non\[Hyphen]Standard Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonStandardEvaluation"]], "Tutorials",
 CellID->30432]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->174125144],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->435378748],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->227875524],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->474019581],

Cell[TextData[ButtonBox["Defining Variables and Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariablesAndFunctions"]], "MoreAbout",
 CellID->479453619]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HoldFirst - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 41.4600234}", "context" -> "System`", 
    "keywords" -> {
     "evaluation control", "container", "suppressing evaluation", 
      "attribute"}, "index" -> True, "label" -> "Built-in Mathematica Symbol",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "HoldFirst is an attribute which specifies that the first argument to a \
function is to be maintained in an unevaluated form. ", 
    "synonyms" -> {"hold first"}, "title" -> "HoldFirst", "type" -> "Symbol", 
    "uri" -> "ref/HoldFirst"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3709, 107, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17037, 653}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2498, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3121, 85, 47, 1, 70, "ObjectName",
 CellID->19232],
Cell[3171, 88, 501, 14, 70, "Usage",
 CellID->21119]
}, Open  ]],
Cell[CellGroupData[{
Cell[3709, 107, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4086, 121, 148, 5, 70, "ExampleSection",
 CellID->101772250],
Cell[4237, 128, 139, 4, 70, "Input",
 CellID->14854230],
Cell[CellGroupData[{
Cell[4401, 136, 202, 7, 28, "Input",
 CellID->183845511],
Cell[4606, 145, 242, 8, 36, "Output",
 CellID->827024578]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4897, 159, 222, 7, 70, "ExampleSection",
 CellID->3834],
Cell[5122, 168, 130, 4, 70, "ExampleText",
 CellID->168206393],
Cell[5255, 174, 140, 4, 70, "Input",
 CellID->502240157],
Cell[5398, 180, 227, 8, 70, "Input",
 CellID->895056328],
Cell[5628, 190, 112, 4, 70, "Input",
 CellID->2015326747],
Cell[CellGroupData[{
Cell[5765, 198, 121, 4, 70, "Input",
 CellID->1226042871],
Cell[5889, 204, 159, 5, 36, "Output",
 CellID->206819475]
}, Open  ]],
Cell[6063, 212, 81, 1, 70, "ExampleText",
 CellID->378977781],
Cell[CellGroupData[{
Cell[6169, 217, 71, 2, 70, "Input",
 CellID->1638890171],
Cell[6243, 221, 158, 5, 36, "Output",
 CellID->29966374]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[6450, 232, 232, 7, 70, "ExampleSection",
 CellID->3547],
Cell[6685, 241, 244, 8, 70, "ExampleText",
 CellID->136756711],
Cell[CellGroupData[{
Cell[6954, 253, 118, 3, 70, "Input",
 CellID->310559383],
Cell[7075, 258, 220, 7, 36, "Output",
 CellID->118351433]
}, Open  ]],
Cell[7310, 268, 191, 6, 70, "Input",
 CellID->86854362],
Cell[7504, 276, 125, 3, 70, "ExampleDelimiter",
 CellID->362939665],
Cell[7632, 281, 92, 1, 70, "ExampleText",
 CellID->41390641],
Cell[CellGroupData[{
Cell[7749, 286, 108, 3, 70, "Input",
 CellID->836878851],
Cell[7860, 291, 244, 8, 36, "Output",
 CellID->774239479]
}, Open  ]],
Cell[8119, 302, 110, 4, 70, "Input",
 CellID->407430311],
Cell[8232, 308, 110, 4, 70, "Input",
 CellID->224855426],
Cell[8345, 314, 125, 3, 70, "ExampleDelimiter",
 CellID->165054271],
Cell[8473, 319, 362, 13, 70, "ExampleText",
 CellID->27416402],
Cell[8838, 334, 140, 4, 70, "Input",
 CellID->588124331],
Cell[CellGroupData[{
Cell[9003, 342, 239, 8, 70, "Input",
 CellID->729169503],
Cell[9245, 352, 217, 7, 36, "Output",
 CellID->41602241]
}, Open  ]],
Cell[9477, 362, 125, 3, 70, "ExampleDelimiter",
 CellID->300688162],
Cell[9605, 367, 115, 3, 70, "ExampleText",
 CellID->11317377],
Cell[CellGroupData[{
Cell[9745, 374, 380, 13, 70, "Input",
 CellID->164068536],
Cell[10128, 389, 234, 8, 36, "Output",
 CellID->90736930]
}, Open  ]],
Cell[10377, 400, 124, 3, 70, "ExampleDelimiter",
 CellID->29094805],
Cell[10504, 405, 232, 8, 70, "ExampleText",
 CellID->112207468],
Cell[10739, 415, 140, 4, 70, "Input",
 CellID->673642059],
Cell[CellGroupData[{
Cell[10904, 423, 256, 9, 70, "Input",
 CellID->99039703],
Cell[11163, 434, 241, 8, 36, "Output",
 CellID->44788762]
}, Open  ]],
Cell[11419, 445, 125, 3, 70, "ExampleDelimiter",
 CellID->129068699],
Cell[11547, 450, 355, 12, 70, "ExampleText",
 CellID->86996294],
Cell[CellGroupData[{
Cell[11927, 466, 118, 3, 70, "Input",
 CellID->767358920],
Cell[12048, 471, 240, 8, 36, "Output",
 CellID->408984738]
}, Open  ]],
Cell[CellGroupData[{
Cell[12325, 484, 171, 5, 70, "Input",
 CellID->512953285],
Cell[12499, 491, 231, 7, 36, "Output",
 CellID->301836863]
}, Open  ]],
Cell[CellGroupData[{
Cell[12767, 503, 166, 5, 70, "Input",
 CellID->483840498],
Cell[12936, 510, 231, 7, 36, "Output",
 CellID->187808166]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13228, 524, 311, 9, 70, "SeeAlsoSection",
 CellID->29831],
Cell[13542, 535, 700, 26, 70, "SeeAlso",
 CellID->31101]
}, Open  ]],
Cell[CellGroupData[{
Cell[14279, 566, 314, 9, 70, "TutorialsSection",
 CellID->30337],
Cell[14596, 577, 131, 3, 70, "Tutorials",
 CellID->23566],
Cell[14730, 582, 163, 3, 70, "Tutorials",
 CellID->30432]
}, Open  ]],
Cell[CellGroupData[{
Cell[14930, 590, 319, 9, 70, "MoreAboutSection",
 CellID->174125144],
Cell[15252, 601, 132, 3, 70, "MoreAbout",
 CellID->435378748],
Cell[15387, 606, 147, 3, 70, "MoreAbout",
 CellID->227875524],
Cell[15537, 611, 134, 3, 70, "MoreAbout",
 CellID->474019581],
Cell[15674, 616, 165, 3, 70, "MoreAbout",
 CellID->479453619]
}, Open  ]],
Cell[15854, 622, 27, 0, 70, "History"],
Cell[15884, 624, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

