(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19702,        757]
NotebookOptionsPosition[     14662,        580]
NotebookOutlinePosition[     16012,        619]
CellTagsIndexPosition[     15927,        614]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Non\[Hyphen]Standard Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NonStandardEvaluation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Non\[Hyphen]Standard Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HoldFirst" :> Documentation`HelpLookup["paclet:ref/HoldFirst"],
           "HoldAll" :> Documentation`HelpLookup["paclet:ref/HoldAll"], 
          "Unevaluated" :> 
          Documentation`HelpLookup["paclet:ref/Unevaluated"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"HoldFirst\"\>", 
       2->"\<\"HoldAll\"\>", 3->"\<\"Unevaluated\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], 
          "Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Evaluation Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HoldRest", "ObjectName",
 CellID->4756],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["HoldRest",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HoldRest"]], "InlineFormula"],
     "\[LineSeparator]is an attribute which specifies that all but the first \
argument to a function are to be maintained in an unevaluated form. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->609394690],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"h", ",", "HoldRest"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14854230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"2", "+", "2"}], ",", 
   RowBox[{"3", "+", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->183845511],

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{"2", ",", 
   RowBox[{"2", "+", "2"}], ",", 
   RowBox[{"3", "+", "3"}]}], "]"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->556273972]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->383276083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "If", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87689983],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldRest", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44317248]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"a", "||", "b", "||", "False"}], ",", 
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"2", "+", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->234332948],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"a", "||", "b"}], ",", 
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"2", "+", "2"}]}], "]"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->406433901]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17431],

Cell["Implement your own conditional:", "ExampleText",
 CellID->133018716],

Cell[BoxData[{
 RowBox[{"SetAttributes", "[", 
  RowBox[{"if", ",", "HoldRest"}], "]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"if", "[", 
    RowBox[{"True", ",", "then_", ",", "else_"}], "]"}], ":=", "then"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"if", "[", 
    RowBox[{"False", ",", "then_", ",", "else_"}], "]"}], ":=", "else"}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1400637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"if", "[", 
  RowBox[{
   RowBox[{"1", "<", "2"}], ",", "a", ",", 
   RowBox[{"1", "/", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5334764],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9972069]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"if", "[", 
  RowBox[{
   RowBox[{"a", "\[Equal]", "b"}], ",", 
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"2", "+", "2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30631989],

Cell[BoxData[
 RowBox[{"if", "[", 
  RowBox[{
   RowBox[{"a", "\[Equal]", "b"}], ",", 
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"2", "+", "2"}]}], "]"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->12801929]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1286],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to force evaluation of an argument of a ",
 Cell[BoxData[
  ButtonBox["HoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldRest"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->27416402],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"h", ",", "HoldRest"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->588124331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"2", "+", "2"}], "]"}], ",", 
   RowBox[{"3", "+", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->729169503],

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{"2", ",", "4", ",", 
   RowBox[{"3", "+", "3"}]}], "]"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->140903485]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->300688162],

Cell["\<\
Suppress the evaluation of all but the first argument of a pure function:\
\>", "ExampleText",
 CellID->11317377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"e", ",", "f", ",", "g"}], "}"}], ",", 
    RowBox[{"Hold", "[", 
     RowBox[{"e", ",", "f", ",", "g"}], "]"}], ",", 
    RowBox[{"{", "HoldRest", "}"}]}], "]"}], "[", 
  RowBox[{
   RowBox[{"1", "+", "2"}], ",", 
   RowBox[{"2", "+", "3"}], ",", 
   RowBox[{"3", "+", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164068536],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"3", ",", 
   RowBox[{"2", "+", "3"}], ",", 
   RowBox[{"3", "+", "4"}]}], "]"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1074400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29094805],

Cell[TextData[{
 "Sequence splitting still happens for ",
 Cell[BoxData[
  ButtonBox["HoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldRest"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellID->112207468],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "HoldRest"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->673642059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{
     RowBox[{"1", "+", "1"}], ",", 
     RowBox[{"2", "+", "2"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99039703],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"2", ",", 
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"2", "+", "2"}]}], "]"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->432537322]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->129068699],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NHoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldRest"]], "InlineFormula"],
 " protects arguments from ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ", but evaluates them normally otherwise:"
}], "ExampleText",
 CellID->86996294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Subscript", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->767358920],

Cell[BoxData[
 RowBox[{"{", "NHoldRest", "}"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104760682]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Subscript", "[", 
   RowBox[{"a", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->512953285],

Cell[BoxData[
 SubscriptBox["a", "1"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->258467440]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subscript", "[", 
  RowBox[{"a", ",", 
   RowBox[{"1", "+", "2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->483840498],

Cell[BoxData[
 SubscriptBox["a", "3"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->428892484]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27928],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldFirst",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldFirst"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unevaluated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unevaluated"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24393]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2466],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->23668],

Cell[TextData[ButtonBox["Non\[Hyphen]Standard Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonStandardEvaluation"]], "Tutorials",
 CellID->9359]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->679787210],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->152368887],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->164530158]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HoldRest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 42.5694268}", "context" -> "System`", 
    "keywords" -> {
     "evaluation control", "container", "suppressing evaluation", 
      "attribute"}, "index" -> True, "label" -> "Built-in Mathematica Symbol",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "HoldRest is an attribute which specifies that all but the first argument \
to a function are to be maintained in an unevaluated form. ", 
    "synonyms" -> {"hold rest"}, "title" -> "HoldRest", "type" -> "Symbol", 
    "uri" -> "ref/HoldRest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3419, 102, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15792, 607}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2203, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2826, 80, 45, 1, 70, "ObjectName",
 CellID->4756],
Cell[2874, 83, 508, 14, 70, "Usage",
 CellID->20609]
}, Open  ]],
Cell[CellGroupData[{
Cell[3419, 102, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3796, 116, 148, 5, 70, "ExampleSection",
 CellID->609394690],
Cell[3947, 123, 138, 4, 70, "Input",
 CellID->14854230],
Cell[CellGroupData[{
Cell[4110, 131, 202, 7, 28, "Input",
 CellID->183845511],
Cell[4315, 140, 267, 9, 36, "Output",
 CellID->556273972]
}, Open  ]],
Cell[4597, 152, 125, 3, 70, "ExampleDelimiter",
 CellID->383276083],
Cell[CellGroupData[{
Cell[4747, 159, 106, 3, 28, "Input",
 CellID->87689983],
Cell[4856, 164, 218, 7, 36, "Output",
 CellID->44317248]
}, Open  ]],
Cell[CellGroupData[{
Cell[5111, 176, 219, 7, 28, "Input",
 CellID->234332948],
Cell[5333, 185, 293, 10, 36, "Output",
 CellID->406433901]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5675, 201, 223, 7, 70, "ExampleSection",
 CellID->17431],
Cell[5901, 210, 74, 1, 70, "ExampleText",
 CellID->133018716],
Cell[5978, 213, 409, 14, 70, "Input",
 CellID->1400637],
Cell[CellGroupData[{
Cell[6412, 231, 177, 6, 70, "Input",
 CellID->5334764],
Cell[6592, 239, 156, 5, 36, "Output",
 CellID->9972069]
}, Open  ]],
Cell[CellGroupData[{
Cell[6785, 249, 209, 7, 70, "Input",
 CellID->30631989],
Cell[6997, 258, 298, 10, 36, "Output",
 CellID->12801929]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7344, 274, 232, 7, 70, "ExampleSection",
 CellID->1286],
Cell[7579, 283, 360, 13, 70, "ExampleText",
 CellID->27416402],
Cell[7942, 298, 139, 4, 70, "Input",
 CellID->588124331],
Cell[CellGroupData[{
Cell[8106, 306, 239, 8, 70, "Input",
 CellID->729169503],
Cell[8348, 316, 242, 8, 36, "Output",
 CellID->140903485]
}, Open  ]],
Cell[8605, 327, 125, 3, 70, "ExampleDelimiter",
 CellID->300688162],
Cell[8733, 332, 123, 3, 70, "ExampleText",
 CellID->11317377],
Cell[CellGroupData[{
Cell[8881, 339, 433, 14, 70, "Input",
 CellID->164068536],
Cell[9317, 355, 268, 9, 36, "Output",
 CellID->1074400]
}, Open  ]],
Cell[9600, 367, 124, 3, 70, "ExampleDelimiter",
 CellID->29094805],
Cell[9727, 372, 230, 8, 70, "ExampleText",
 CellID->112207468],
Cell[9960, 382, 139, 4, 70, "Input",
 CellID->673642059],
Cell[CellGroupData[{
Cell[10124, 390, 256, 9, 70, "Input",
 CellID->99039703],
Cell[10383, 401, 267, 9, 36, "Output",
 CellID->432537322]
}, Open  ]],
Cell[10665, 413, 125, 3, 70, "ExampleDelimiter",
 CellID->129068699],
Cell[10793, 418, 353, 12, 70, "ExampleText",
 CellID->86996294],
Cell[CellGroupData[{
Cell[11171, 434, 114, 3, 70, "Input",
 CellID->767358920],
Cell[11288, 439, 188, 6, 36, "Output",
 CellID->104760682]
}, Open  ]],
Cell[CellGroupData[{
Cell[11513, 450, 157, 5, 70, "Input",
 CellID->512953285],
Cell[11673, 457, 179, 6, 36, "Output",
 CellID->258467440]
}, Open  ]],
Cell[CellGroupData[{
Cell[11889, 468, 152, 5, 70, "Input",
 CellID->483840498],
Cell[12044, 475, 179, 6, 36, "Output",
 CellID->428892484]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12284, 488, 311, 9, 70, "SeeAlsoSection",
 CellID->27928],
Cell[12598, 499, 702, 26, 70, "SeeAlso",
 CellID->24393]
}, Open  ]],
Cell[CellGroupData[{
Cell[13337, 530, 313, 9, 70, "TutorialsSection",
 CellID->2466],
Cell[13653, 541, 131, 3, 70, "Tutorials",
 CellID->23668],
Cell[13787, 546, 162, 3, 70, "Tutorials",
 CellID->9359]
}, Open  ]],
Cell[CellGroupData[{
Cell[13986, 554, 319, 9, 70, "MoreAboutSection",
 CellID->679787210],
Cell[14308, 565, 132, 3, 70, "MoreAbout",
 CellID->152368887],
Cell[14443, 570, 147, 3, 70, "MoreAbout",
 CellID->164530158]
}, Open  ]],
Cell[14605, 576, 27, 0, 70, "History"],
Cell[14635, 578, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

