(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     95358,       2309]
NotebookOptionsPosition[     87665,       2047]
NotebookOutlinePosition[     89635,       2102]
CellTagsIndexPosition[     89457,       2095]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pochhammer" :> 
          Documentation`HelpLookup["paclet:ref/Pochhammer"], 
          "Hypergeometric1F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric1F1"], 
          "Hypergeometric2F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric2F1"], 
          "HypergeometricPFQ" :> 
          Documentation`HelpLookup["paclet:ref/HypergeometricPFQ"], 
          "Hypergeometric0F1Regularized" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric0F1Regularized"],
           "HypergeometricU" :> 
          Documentation`HelpLookup["paclet:ref/HypergeometricU"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Pochhammer\"\>", 
       2->"\<\"Hypergeometric1F1\"\>", 3->"\<\"Hypergeometric2F1\"\>", 
       4->"\<\"HypergeometricPFQ\"\>", 
       5->"\<\"Hypergeometric0F1Regularized\"\>", 
       6->"\<\"HypergeometricU\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypergeometric Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/HypergeometricFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Hypergeometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Hypergeometric0F1", "ObjectName",
 CellID->31168],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hypergeometric0F1",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Hypergeometric0F1"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the confluent hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[Null]", "0"], "\[InvisibleSpace]", 
        SubscriptBox["F", "1"], "(", 
        RowBox[{";", "a", ";", "z"}], ")"}], TraditionalForm]], "InlineMath"],
     
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3719]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "0"], 
    SubscriptBox["F", "1"]}], TraditionalForm]], "InlineMath"],
 " function has the series expansion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Null]", "0"], "\[InvisibleSpace]", 
     SubscriptBox["F", "1"], "(", 
     RowBox[{";", "a", ";", "z"}], ")"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      RowBox[{"1", "/", 
       SubscriptBox[
        RowBox[{"(", "a", ")"}], "k"]}], " ", 
      RowBox[{
       SuperscriptBox["z", "k"], "/", 
       RowBox[{"k", "!"}]}]}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->9982],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Hypergeometric0F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric0F1"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->245273241],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric0F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric0F1"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric0F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric0F1"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19004540],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->492714153],

Cell["Evaluate numerically:", "ExampleText",
 CellID->318993004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric0F1", "[", 
  RowBox[{"1", ",", "1.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32227528],

Cell[BoxData["3.165589067599779`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235175359]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->122278948],

Cell["Series expansion at the origin:", "ExampleText",
 CellID->325766619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Hypergeometric0F1", "[", 
    RowBox[{"a", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->332211415],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWM1u00AQ9m9wFIFQQ9KKH6kSl6iqiihceACKhFTOXBA1VaX2gEClAloO
4cqBQk8IiQeAh0DpW+RRcjS769nG/Tz2bhyrSYlkr2d25tv52Zl1vBkf7O68
jg/2tuPlJ/vx29297XfLG2/2Bct3HccdOI5zd8kRz4l4Upf8nYorfUyfNuTd
17OJcwvoVcN8yzD/YEp9nL8J9EPlxWPg3gF6xTDfNMzfn1If529zUXIWxT0U
zAUaG5kxK+0R/wrwtbwP/La4+SRfBx7KTaqv/QvJrnBO7EI5PxM3G/11lcWu
vIdnXMVzVA7y3JDl4nqBwU4eBbUWZm4Blx/z2tN4hzvK/0+8tcNG7+2wy3bx
DZBtVIqnrveL37eTrcz1A64P2KG1GbSGlrtUnnD9kOu7k+w3efYFgtlhsIMK
Nar17PtEnavUhYP1Vlzn82i9aZ+gfBFOWUfqcpgXeKIGus/O6FQJDTG2Q8Wq
U/ssGNOzfU+ox0fOVo/xYdKuJZlLDLYkI0N8rifjN+Bcl8rQ0ZR4pkq8VqCH
1eVlaN15ZmGXSe9qgV6atbWEyzDGHM/IRaCxN3Pne5l+k7UCtbAy+f8R2XhX
8aWaLXZaGKf0v+69JM2Qmg2yGB5TT12SbltJt3JSchJ97hC/QSh1YvNSWE3p
twv5+JtWa9HYPDeTQ8ZKoKCnP+1TWeaeAv0e6D9A6zoP2Rh5NLIdl33XrNM2
u35dcKIZrZU4428Tg8GAohyoUAua5PwCuUdKrtfrjUajMrkdJdfv9w14P5Rc
FEXD4TBrn10UfMoU5mCeMnUZbKy6m+TtZ/EKU1aWAb2kiyCSq/T06pL1Kxl3
gGynwpNHRUZp/BWXKzgSK8XrgFcrQL8A+ivQhzSmza6by8FqjvMyx/mW4xxx
uVUdXa61RmNM4wmNnygedtKfa7W4bxVNjyx8zvDl+AVo/bXzo0LfhKi8Avo7
0B+U1jPgbgEtfQnO1kDpGOjjDO1Q/s9bJrlbQOuYH1pZdML6IR9PUzz3HxGK
fZY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{447, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->848989729]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30906],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->118523973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric0F1", "[", 
  RowBox[{
   RowBox[{"1", "+", "I"}], ",", 
   RowBox[{"1.5", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81938993],

Cell[BoxData[
 RowBox[{"0.7613492523034301`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.5588670050692595`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10910795]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->579116933],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->51663803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Hypergeometric0F1", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->635284545],

Cell[BoxData[
 RowBox[{"-", 
  "0.1965480952704682000407933720879322313258897873108930771957672139765`50."}\
]], "Output",
 ImageSize->{376, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27069349]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->427122095],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->139867510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric0F1", "[", 
  RowBox[{"1", ",", 
   RowBox[{"-", "2.00000000000000000000000000000"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->232385553],

Cell[BoxData[
 RowBox[{"-", 
  "0.19654809527046820004079337208512659244`28.08230144187244"}]], "Output",
 ImageSize->{222, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262495566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->611053237],

Cell["Evaluate symbolically for half-integer parameters:", "ExampleText",
 CellID->91755628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric0F1", "[", 
  RowBox[{
   RowBox[{"3", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->252304268],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sinh", "[", 
   RowBox[{"2", " ", 
    SqrtBox["x"]}], "]"}], 
  RowBox[{"2", " ", 
   SqrtBox["x"]}]]], "Output",
 ImageSize->{84, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44886916]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->981387013],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric0F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric0F1"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->116181103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric0F1", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "1.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->336267988],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.165589067599779`", ",", "1.9627864279361777`", ",", 
   "1.6037368528848017`"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89646640]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->760443585],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->653625731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hypergeometric0F1", "[", 
   RowBox[{"a", ",", "z"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35954786],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVkUsOgjAQhvsE1IUro+44A4fQlYdoiAksjAa5f+3QIuO0JJUE5tHpfP8w
NzN294cZ+9bU18G8ur5915fn4FKSM8Ya9+5PzPnWedPbWAtWegPP1rnSWQ0p
cMLRDsXgliQWvk4tGd8L10wY/Y0zO3Nfp3HnuaRIqVCYIMJ4YPGcAp2pYOEn
AY0nZhGEpFNkFBdIiSdWv9oymJL0VH8wfYdNYgO5RNCcRYw2SqkipqJNqLCB
eSOUWUZTVURlPNXKnUgp6JeJ7cqQX+mMKums5+hGmkz7HEm80AoyMbiH1F5Y
E30Z/wCBJPqp\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{50, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->577395187]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19463],

Cell["Series expansion at infinity:", "ExampleText",
 CellID->67073751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Hypergeometric0F1", "[", 
    RowBox[{"1", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21915062429678464875,1",
 CellLabel->"In[1]:=",
 CellID->320879286],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox["\[Pi]", "4"], "-", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      SqrtBox["x"]}]}], "]"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{"3", "/", "4"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox["1", "x"], ")"}], 
          RowBox[{"1", "/", "4"}]]}], 
        SqrtBox["\[Pi]"]]}], "-", 
      FractionBox[
       RowBox[{"9", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"3", "/", "4"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"5", "/", "4"}]]}], 
       RowBox[{"512", " ", 
        SqrtBox["\[Pi]"]}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], 
        RowBox[{"9", "/", "4"}]],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {}, 1, 9, 4],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[
      1], {(-(-1)^Rational[3, 4]) Pi^Rational[-1, 2], 0, 0, 
       0, (Rational[-9, 512] (-1)^Rational[3, 4]) Pi^Rational[-1, 2]}, 1, 9, 
      4],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "/", "4"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"3", "/", "4"}]]}], 
       RowBox[{"16", " ", 
        SqrtBox["\[Pi]"]}]], "+", 
      FractionBox[
       RowBox[{"75", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "/", "4"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"7", "/", "4"}]]}], 
       RowBox[{"8192", " ", 
        SqrtBox["\[Pi]"]}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], 
        RowBox[{"9", "/", "4"}]],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {}, 3, 9, 4],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[
      1], {(Rational[1, 16] (-1)^Rational[1, 4]) Pi^Rational[-1, 2], 0, 0, 
       0, (Rational[75, 8192] (-1)^Rational[1, 4]) Pi^Rational[-1, 2]}, 3, 9, 
      4],
     Editable->False], ")"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["\[Pi]", "4"], "-", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      SqrtBox["x"]}]}], "]"}]}]}]], "Output",
 ImageSize->{408, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21915062429678464875,1",
 CellLabel->"Out[1]=",
 CellID->213167135]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11620],

Cell["Solve the 1+1-dimensional Dirac equation:", "ExampleText",
 CellID->335329853],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]", "[", 
    RowBox[{"x_", ",", "t_"}], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"I", " ", 
      RowBox[{"m", "/", "2"}], 
      RowBox[{"(", 
       RowBox[{"t", "+", "x"}], ")"}], "  ", 
      RowBox[{"Hypergeometric0F1", "[", 
       RowBox[{"2", ",", 
        RowBox[{
         RowBox[{"m", "^", "2"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"x", "^", "2"}], "-", 
            RowBox[{"t", "^", "2"}]}], ")"}], "/", "4"}]}]}], "]"}]}], ",", 
     RowBox[{"Hypergeometric0F1", "[", 
      RowBox[{"1", ",", 
       RowBox[{
        RowBox[{"m", "^", "2"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"x", "^", "2"}], "-", 
           RowBox[{"t", "^", "2"}]}], ")"}], "/", "4"}]}]}], "]"}]}], "  ", 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->363924806],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[Sigma]", "3"], "=", 
   FormBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"0", 
        RowBox[{"-", "1"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    TraditionalForm]}], ";", " ", 
  RowBox[{
   SubscriptBox["\[Sigma]", "1"], "=", 
   FormBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1"},
       {"1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.28], {
           Offset[0.7]}, 
          Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    TraditionalForm]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->232971776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"I", " ", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"\[Chi]", "[", 
        RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}]}], "==", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "I"}], " ", 
      RowBox[{
       SubscriptBox["\[Sigma]", "3"], ".", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"\[Chi]", "[", 
          RowBox[{"x", ",", "t"}], "]"}], ",", "x"}], "]"}]}]}], "-", 
     RowBox[{"m", " ", 
      RowBox[{
       SubscriptBox["\[Sigma]", "1"], ".", 
       RowBox[{"\[Chi]", "[", 
        RowBox[{"x", ",", "t"}], "]"}]}]}]}]}], ")"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->122809672],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->13453149]
}, Open  ]],

Cell["Plot the solution:", "ExampleText",
 CellID->1561348554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{"\[Chi]", "[", 
       RowBox[{"x", ",", "t"}], "]"}], "]"}], "/.", 
     RowBox[{"m", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->477838301],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFfXV4VcfzPu5aCsWDF2nR4jItRVMkBNfilOIUQtASWihQ3KF4gaJtCE4S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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVElPlEEQ7Vn6m2EW41E8KeoPIPwFD1wZDg7LCZTEsHgBHVQyxJsbxMTl
pBcEo2EdJGqiuJyUu4DL3zBBhcT35j0TDv11dX3V1a+qXtXJgUuVsXQIYQYr
g/UUnzmsz5CLUecvkHeC9Lu2GcxK/wI2tbzsr2OfyuvfVezVJIQ/qRA2IY9B
PoWHxrHfxnkCNnXs01hDWd05b5/nEt3n3ZGUdvofz+reFuTnsLnGu/B5IiMf
OcgLGdnR5ib+38rrPA/9ZezfoL+SlUybZejrkFsgNyCvY7VCrkbFy7g7IZej
/BPjb+dkw/bHg/aXvluIeo+5Ip552+9llDvGcjYXQgox/ILP6awwHAvaeZ5i
7DnZ0aaDdtDtw6YUtBexXkNfT0nHuGpYBzh3R50pEwcxMPZK1L8D+6JP4u+H
rg+rKyonhaBYenHuwSpF5Ydv0r5+CEsf4niCPLcAy2nsf6NiZc6YO9aQdfpf
T+aeOIhnKq1734NqwLjzzgNl6kbgfxbKtrRwVoz/DHT7UfWoGHuzvhm9x3px
73TtGvCzhjWaVqz99tPl2ImBsfYac7vtaEM9OUE+fIKPj1i1tGLsdX5KztWO
+dNjPzOwHY7KG7lKLNuuRb9xs1asS5OjqPk7yGuwPQp5A/Ibcg/7vbxqRm7y
DXLpJ2zeR/GR/48ksmH/3XEPjibqQ/bgvmvIWq5DPxjFPeaF/5n3x7CdTJQD
nqlnXYjjFeOGXMb/+by4UHWsxLPo/iLnPsBmIlGvMV/0x3yyJqwN71yMwkEM
xD5r/EvQDyO2r9BP5sWtPfcTe4w9VXbet913ReuJd8SY2XNF9/OzjGpA+5zr
t22elx3DEt58EMUj9l4jLQyMm/1GztN3m/3PGc+uZ0hzBnh+FvwuedRung9B
vpsoh5uQf+Q0O9h3Kxnlods8Zx5X/K/Vc6bhmUPeL3i2FDzLWjxzFg/NvEXP
Os6GmvNPHe22zEnmhXGuGQPfIsYLUThZ4w5z50ZOvCQX7kfViflpcsUxPozi
EHVvmRvYr3p+NDxf2NMDUXlkvy87ds6SR1FzgVhWrSfXSomw/APHEtTn
         "],
         VertexColors->None], 
        PolygonBox[{{1646, 1547, 620, 547}, {1469, 2007, 943, 945}, {1381, 
         1922, 697, 13}, {1461, 1807, 695, 697}, {1429, 1705, 614, 887}, {
         2188, 1654, 1144, 1143}, {2173, 1625, 1124, 1123}, {2171, 1623, 506, 
         614}, {1460, 1549, 383, 696}, {1899, 1900, 757, 213}, {2186, 1652, 
         1141, 1140}, {1471, 2010, 947, 949}, {1387, 2012, 949, 26}, {2001, 
         2185, 1140, 934}, {1532, 2001, 934, 1017}, {1901, 2175, 1126, 800}, {
         1531, 2000, 932, 1016}, {2176, 1964, 519, 1126}, {1547, 1644, 546, 
         620}, {2011, 1386, 25, 948}, {1653, 2188, 1143, 202}, {1625, 2085, 
         1017, 1124}, {2168, 2169, 1016, 200}, {1379, 2192, 1152, 24}, {1713, 
         1645, 547, 621}, {1654, 1730, 632, 1144}, {1386, 2009, 945, 25}, {
         2008, 1385, 24, 944}, {1729, 1430, 561, 632}, {1548, 1434, 563, 
         383}, {1626, 1627, 521, 637}, {1434, 1380, 384, 563}, {1802, 1901, 
         800, 690}, {1647, 1714, 621, 381}, {2000, 2172, 1123, 932}, {2187, 
         1728, 202, 1141}, {2192, 1647, 381, 1152}, {1537, 1802, 690, 757}, {
         2010, 1470, 948, 947}, {2007, 1468, 944, 943}, {1679, 1678, 26, 
         384}, {1807, 1460, 696, 695}, {1657, 1626, 637, 561}, {1676, 1450, 
         200, 506}, {1964, 1965, 887, 519}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.40676589279574643`, 0.25448925173276615`, 0.6887389866020984], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGuwllUVx5/3fZ/neZ8hjaYLmuA0TVwFusrFPigcowJLNCFHsEQ4NMVV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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUtsVlUUhc9//3tPbwgoQQhgbYyxgFKqRsBEB4ZXAqJgIhg1PCKFErGl
CC0tjypFgvZBW+WpA3Ci9C9aEiAkPovogKgRiTEEU8LAMHBCkBGaQuK3sjrY
yV5n7/O456y17kM1m15qSEIIrURKfJeF8GdZCF2FEIrERfLfiCqaVoDPUh8L
3k1+l/5j4K/BHcUQ5oMXkNcTD4Iz5pyjfhW8j/6UmB5DmJOHsJlaP7iPWolo
oP82uJ7+veBnwBWsN47+mfRvor+D+iHqA9SbqV+g/hP5z8Sj1OcVfLZ3iaeK
PuMJ8s+JJnBKz8fMPwNuA09gfh35AGPPJz7zq+y3g/1e5zJqiLfJW4l1rDVM
1NLbTc8LifdQvp6xPYnHdtO7krFR5Hepr2f9ueA29pqkfuot4J2svYPoIt/M
2GvkzzFnK3kj8S97rWRsrc5Ljx6pMvHZXgGvSX3GQfBG8ETWf5beg+By8Bjm
d1I/Bl4BzplbAh8FH6bvF/qPg7+h1qggb6RnX/Qd6NsXg7+gf1703Q4xVsfc
HvCSxG9aol4JXsh6f1DvB88Avwy+DP5Qd8eccvAecCV4O7Ga/D/m95LX099K
/g5jneTLiZvgRezxEfUt4Kl6+9R300KsSn1HA+QvRnPzGmN94AfAT7Pf77oj
7v9J8Fju/l7iEPWHwRPo76beLv5Gf7s41AMeBDcn5vx++t/IzJW99K9hvVZw
TfCah6k3Z+Z+L/Vy8FLmnwTfLJpbB4muxByriD6jzqY32gr+nmihVk100/up
7j/xHRyhtwpcQb5f9w/eQPwDXgY+zXnOMKe/aE6fpfctor1gzXxG75horV6k
/xz5Nt136m+cSj2J5uow0Ut+D5EV/MaTqN/K/C03iK/Y7xL4fNGarwXPieb2
ROJL8ZkoFazxA8y/Hzwa3M6ex8H3gas4zyVpLDMH9PYsFf6WFzA2K3iPA+Ql
+msTa3g2vbOIWLBHDNE/mNlb5Fn6NmlM2tI3FqI9SV5Upx5qTYzNSHznw5k5
KS5K4x+A+6ivS+xJd8BT8hHtE1dY69vM3tipOx7RnLSmb+ok78jdqz2ac2tc
2hZn63NzXNxeDr7K/Ntl9kJxvI36rtxnlcc9Rl6d2wuL2oN8lDyq4Dc/RX46
2hvkAefJf4jmkjR+gfX/KrN36g22Mf9EZm1Lg9L+e/LjdMQDMmtE2pCG9Jbi
uLitN23JzElxUZqfrPfNzY1PwFOiPUFeII1NI38kN7d+pb6TvD/au+Vh4vLG
3HchTks70rS0LA1JC2vBi1NrQm/zZm7u643EjabcXimOVEd7kLxHmpH3ysPk
XfLgx8mfyH2X18EN0R4q75QHiXvirLgqDkpL8gBpX5qSNuRp8jJp5Ehmj5W3
DtHfTv5+7rvQnY6O1qC0Jw/cHu3B8l55srx9Q2YuyeN7qP0YR+4qtdfIA+V9
8pzx0RqSdqSBLbn/ofp36h/yP6mP8co=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5532396135962532, 0.5091674947791305, 0.8946255205540529], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmQVcUVxu97991FTVyRJC4I4oIaUAGFAEkAFXBDJRHXKgcBNbJvinEh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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmdsl1UUxt//eEdAcTBUELBURthSUARjGAo2rFKhASUyBDSWAhZZIkhD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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6637332728551458, 0.6880968710634952, 0.9117764364302601], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFWHuQl1UZ/r7f77sFiCAaS1x3BXaBgd3FYATissHmcmfZVRCWi06CYQr/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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmwTnUYx8+5533PObJkX7JVZJ2KqyT3uuYO19K9djGyxYRQrmbSVKMU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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7705289236080086, 0.8496317470756439, 0.9104927373011992], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH+Ql1UVxt/3/X7ve3cRKqzQUUt2SEsz2wD5IQLlQArMOuWPUUmooWZY
c0aLYaDUZAbGmbaxSS2mLAcdgaYRJ6OaKaEEWnfXFFBmdhFBfrmJFKm1+Mea
gj2fnrPTH3fu/Z577r3nnvOc557327bkjmtvr4qiuLMsiob6PzeL4mkE+j2j
LooFLUWxTeO9mjws+SG1qako7lc/RfI/qV2qdpuWfCoXxXc1d7PGz7Ne7V6N
v6h9lmpul35P1Px9WnuJxndLdpvmxlfW3R36n5V8lM59VfJu2fOg5O2S3ygb
fizZTzR+SP3P1NZrvKz0HmcWnn8wdDiDs7Bnbmk5+3eUXovOI+rXqf1W4yUN
/2Z8hs4/LlvHSbao4fM467js/XvtPW4ovRb52ZKdlW3rYMwh36a1u6SzU22e
9nxJej/U+I+S96nvVVuodpnu2a01t0hnkdoc/R6Q/GPqr9E+X6sse006P9U5
C7TPAY2v1z7HKvvuWq2bJXlPaX/Pre1z7toR9rRI/zzts1G/Z0l/dot/P6q7
zmmxrx5Svzo5hr0N29Gvdp3kr2jPBzRerfFijUeHv/Ev/nxF/VXYqPGPZMN8
6W3V7/c0vkz6W0rfn7h0SudqzU8J+XkNx3yPxg/Xxh/Y+4bWzox7Pab+B7Kt
S2v3afxy7Th/W2vv0tr2yn6cpLayMB4fDUxuL41ZsLpe/XTpLtC4s/S6FzV+
Qfu9WBvXX9W5v9B4UeHfN1XGOjZ9Psa/UZupcZv6zaVtGcH/wsA1PllU2S+r
8J3a+WCC+NT+/Zz659VIvcXJvxkvkQ3rat+ls/J68P6sZGvku7v1+9Zsv+CT
6zX+g+RJ/vhA5fmqcrzPKY2lsQ3nM7m8RmdtTM4LsHJl2Ly8tI3YAB9s444a
PyXdj2b/hiOeDvmpwDJj/DGvYX/gb7gCn4MbxncWjuUDMf5eNheQw//WPYZq
509r6T3JfTAxs/QdV4X/loW9u4NrVsm29clnEZ/twU2s7Qr/E+snNN6BPdLd
lBz3/+jMd9UWa/592XI02U8jeAWrS/V7Y6yl3xBj1mwI3gBHd4XPb9Y+N2Xn
HDx6eeD51+ovbjFf7dI5f5PO2MBLd9wFWw9EHp0KvsAXw2qnNV4R3IOfOLdN
e54DXvW7p+l+dmG7sA87OzT/IendCydk8whnrJXOvtI5fKIy38EV+2vn8Nbw
M1yzO3h6bnD1xGwMMf6H9H+ezX/t4QN8e1LydZKfiDzYE/d7szLnYv9QZf9i
5/dr24dt8O9RtcHAYEvTGLtc/puhdlbTWIen4KiX1f6q8YTStlwR9pxSf1qt
X3Pvqj+SzBHw09Tad8T3zCPvCB7HD6V0Kri7YUzRg+vlle9Dfg9pz5Nqz2mu
bJj34fzWhmX7K78D45qOy1qdeWH9fx7iHo/hV53zFd4/rbkuO67E8kvZbwzv
C+/GB5vOi01wuOS9krdFzuP30ZKPabHviNW+4GfekdcCV3uIV21e65I/1oJX
6R+v/Nai3xXxIu/Azoez8fN4i8/m3PHJmINf+rLnkMPZvEnkelPyRnbuXa3+
qmwsP9v0PDxQM6+9nqzMK9Qi5Mi05JqDPXlzeuLdeSc5b8H3BRr3NR13cn57
8PyA5vtr32MwzuOs96WfsvngomQ5/LKj6fuBsc9o/n6wUhm7iyPXqFmejLqF
uPbFG32JdL+eXSedmWx/EfncHe8RsSbOvDv4gvPJkSvkp08GHuDs0RFH8vtE
nDtfe38k2zdghzXov6fxBsnfLt1fGWPsfTtyn/dpfZxLLs6OfMTXvJ3k6zO1
ORF7yKWewOpRyX+VzBPUKeQI9zk3uT6Du8B6d2ASntoReTouedwaGOwIHLIX
WEPWF/UIPuyW/qFs/R71vdm51isb+mpzK3j9XcT5ccnukc5Syf6ptdOy8UvO
jA0OhK+ORY1CLcQ8NpyW/heyuQcuhfvI9zckG0jG86aGcUocyTlyuz1iNxT8
D8e+GfzP2/tSMicdlG2Tsusj3gAwOiHuy5g7/w/jyXw+rH5W9l5DGs/Itmk4
8IQNvBU7k+8GF56KN5f3ZF52vozEg7uXwUPYvDM4CPknpHtBNl+OCw5F/oL2
PjdbrzV4i7jgb3Sx/8ua/32L98ZH/aGzT2vPz64XJ1PvZfudeP4lOabEjL2o
qcg5cq8neH4w6gH4hjqQfKQh7wpMDsRZKfgem2+ULW8lcxtvI3US/nwjuV4H
c5M0nhxvOlwCp3AWuBkftQTfJujx1m+N39Rzk0OObFrtGpF6kNqvLXJqeuwJ
R/UTh2zsUOdOjD2pWairlgXPkCf4hJpoatizLXyEf9gL+ZR407kv/n5K9z2Q
HB/OnB7fKStibzDAnkei7iIvyVXejhu09pfJ7zn1H28dtv1Ld3qr9vcPsd2d
HF/4ozM4BJvJZ/jxsHQP1f7eAs/7AxvgeUXY8I7mh2vXSq+rP1b7O4q4D0Z8
4Z/24MHNOveZZEyvke6c2nX0XvUXZftyV/DpyrgXmAbv6PLdgv6tleO6PPzG
+wQfDCZzOn7Zm5zn+PNkct0J1y7M9i++BacTRmJR+d0ljway62DqkR71Z2fP
rVT/HfaXzqLa30ijw8dbws/UxpsDN+T0cGAVPoAj4AS+k/gu2hK4nRjY+5zk
t2j/M6Q3U/Orar8nVbwX8Har5K8n+3ZMwznLPeDMMXGnC7O/bbgXdQb7jXy/
jIoxNVRL1FHEu4g3cVLkEHdZXTsfyIVpgUEwDM7ANb66p/J7Rl1yTXaMie/t
Gn8ru2Z5pPZ/BMQWX3RGPj5MzJPrlTuy/Xskvl/ALjbQ896CB96GCQ37g/PY
G31kbSHfpHOeqH3GqPhG4XvtYu39abWDEa9DsSf3B9v46tXkN/5wxBBd+IFv
nYMh43sd7MBRl2b/lwGXUcvCT9Rd4HJp3PE+zS9PrgmWVcYHvEJdyfcwXDhf
9n5Teh9vuI6hp35uz/72gxv/C/EnPA0=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtln1olmUUxp/3eX3u+zWV0EpLTV1WZkVkmjVrrsJhGkam4qy2agVagVYE
QR8ampRhsFaDzI+otYhcGQRRZi3KbVmuDOamLnM6/ChLQ4MmfvW7uvbH9T7n
3Oec++tc59xvUdWiuxemSZJUgz7gnSxJngHT8klSgmFsIUnWhyRZgHyGsc3Y
9sQk+Rz5NGOH0Pvjsxd9MHgP/QXwTS5JbsE+kdhp2F9F3sjYXmwJeju+A8Ft
zHWWsQXY/gEbsT3MWBPyWMbvQ97Jtwi9H/6TgtfQ3I2MbUf+jJhRfIeib0I+
Gz33BJ0F/0q+OuNIfqZgLwPnYJ/H2AJ8rwH7sA1n7IvgO9DZnwQ34bsS+7vM
PYQLWoptLT73YPuRsUpsl2qP6AOIfx/7i2C2zpb6LnLM0ZH3newkdhf4Evlq
8BLyy6ATear2r/VBBbFPgQbkB8GS1DkYz1rXgeXsvUY5QT4JxhPbxhqX4Dsb
PVM+2O8A1h6H3p06RxXoa9D34z8Feyn+XzFWzD6bc/a9FqxIHNOC/X4wmthn
0W/FVgfmox9Dbw2+Y93tUjA1mjPiSg/6cfQxYBfyD4xdiHwR/ueydgtjXax7
KpobOkMx8l+MzUDeAS5DHw225H3HddiWEr8J22PssRlbS/TeJ4Kt2D9l/WF8
B6KXYjuBXIl8GDyEXgWeJnYP8+WRz2Q+SwO4Gf04+hx8u8GN6G+Auax/CPtk
1p7F/K+l5qhyPQH7gdQ5l+8efF5PHXMv+rhg7opzw6JzpNy04nNDMGfFVXFi
JvLp6Fxej89VyDuCubJb9SjuMdYX+8XYH0deBLo4TxFjPzHPfvRG5FzetVNL
TF3ONSTbz5nXlk8HtnawMnWNrkZeE1xbFcx5nmpdNYu+HNQjLwvmvjgo7vQr
uPbFocX4Pw9GMdd8sATfSQXXTrHqCdsqUIH/YfRO7N3EdSFXgy3o34PnkBen
5v7WYG6pBo6qJxTM3QdS5/ou5qvJOedDkL/j2zfnsQvUC4gv4N+I//no26Pl
r8G3+H6i/ffGjMV2RXRv0J2cJPZUcG8Sh44hHw/mkjhShjyn4FpvRR9KbGsv
91aDteh/4/M29irOPAj99ujaWC9OENsXlOTcg7rw3QtqkcsYW6fY4LnF2RHE
tvf2uvqce+m+zFxWT52GfXr02QYlrr3Lo3OpGlTvbspce+rhY5i7pODciCM1
6gPBtf4E9m3Iv4Dy1DWn2j+BXp+6B+hu74x+C3THH6F/GJz7R8AG5I+D9yJO
jIzmsLi7PXVvWRjNXfWYo+hHwLrUd3YH8tyCc60eeQB9P3gTfRU4ovrIPFcz
8R8grwDled+huHYw2Feca0OeDkYgr2CsI/McilXPXMZaFdj7p+aguN8WnSvV
wO/Y/gjuDepRj0b3cPVuzaneNjO69tTjypEnM+dw5IJqOjrHyq16Rm10z1Ov
05471Yuie6VqfD16n+jetC1xL5wXPZd6YjXyksy9UDU0OZpz4toR9JS1m6J7
o96gX4NrTrX2fw9D3hw8t86st3RWNHf1pvZg+1dvbuqcZ9gC2JD6zS4tmJPi
os74inIRfLd6Q1RbM6J7x+De/xZXRvcy/cdQLv/M3FuVU+X+WObeIA78hr47
+K1TT23IzFFxU3t4K/gN1tsrjuptVg9V79Qbrb33ZL4LnUFvq958vfV6Yw9m
/s+h/xqqwf8Aixsv0A==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8672437184864011, 0.8818835541106181, 0.8671645958649625], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2uwllMUx5/3fd7n2W/GrbtzDCrMcHKZMSnMUYYRXZlMuRflUn2QhFE+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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1ol2UUxp89z/+577/Si7qmbRG1oV/UEkSdirpImhFOY6L2YhYu1L5o
Zan0JQ01+5JJCbUgNUWFxDfQRWWlaYqb+DItJ2IsB2pMYy0FLVq/i2sfLp5z
7uvc577Puc85T+W8xfWL0iRJ3gEF8E9IkrtgG4vbwV/IXWAT8mZQQP6ymCQn
MO7Cvn9MkqY8SXqQV5UkyXX4a6AR289BOXwzfD+4RrATObC2C+4MexqwXYL+
AHopOAC/Bf/NBfs8Bv9zsO298C3wHdh/n7EAvkDuDr5bA/p5+BusHUUugCrk
R8Fx5F8VE/xqMAt9Mno1e5/hvOGcdz7z3l/gW1P70Fkn0ZtTn3kZ/Sf0o+hN
6FvR/w3O1ULdB3me4kF+kbVN+N6D/U2u28QZzfAnwAq4leBT5Jewvwf72anv
Ngb9auo7bkD+gLUN7L/O2k7svwL9lfvUvubCj0zt82vOm82ereR6MOtt8BfA
h3DrwGNwV1gfDX+wxG99B/3P1G8+Av5xsBb/7ei74Tbic3/BMQyH+521Uew9
AoagDwZz4C5g/zFyKz7XIs/MXAs3ct9dNaFcr8Nmauac94OvUw7hInol+ozo
tytDr8F+EqhL/Cabkffmrr1v4E9i3xKcC+VgGHuHghcSxzwaeRRYg/4J+nrk
s9i/jzyNMyYh1+OzGl/jwED4Q/gvEtt6cBr+FFiN/RowAP4cOIj8HXhYOvbl
Jc754dw1otpQTBPZ+yp6GfpY/E9E/lv1h20HeAL9LvrLyJ1gQXDNqFbUE+Ph
b8JPg2sDk9ETbF5DvgXa1XvRtas3US1VRte6akq9VIveUnBPzWfvUvQK+IHg
Yu6aUa1UsX8K3NPRsanGnkN+Pvpt9QYLg99AuZePK+gdwXerBYOwfRD9voJ7
pDT6jfW2ylkRvQ/IUseQI/dwdnfqmdCoXg/OtWqqIromVAvqwVZs93P+I705
l1wfPVu0VsT2W/Uz8hLWGqJrVrWqnqyJnhmaFar5CdoL5qJ3qp/Yt4/9Fb0z
S7WhN9TbqUZUC2PBgMw18RZ7f1B95o5pB9/24FpTzwbFDt7A1230j6J7UL1X
h48no2eIZodyIF9vR7+NfL6OvCh69lVl7p2Lwb2sHlKsb0bPTsX8I9jNWllv
DS+DWxy9d6jmVdE5Um5UE08hL4Avh5uAvjx6j2yHgVr4jcGzrCJzbqZH94Zy
dBX0Ye23rLfGsX0P1KTO0RTkVcGz9iH0ccifBc+6UvSu6BpU7WlG6+5To/8l
imELeDd3ruRTb/VH8L9Fb1ateRRce5qZOfIr4H7kO+R7G3tnFh2bZoBiVUyK
RTF3aj4F96J6TP+67ty1oH+eZpli0N010/5D7gnuPfXsLeTbwb2rnta/UXfQ
2fpHatYoZsWqmdO36Bmr2aqcXdK8K3r2aCZr1qpmVCuaueqlZ6P/deqp/wHC
JvsV
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.9411759999999999, 0.906538, 0.8340430000000001], EdgeForm[
      None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVTtoVFEQvdl737vPwh+IINmoEb9gkk5RCAiCNgEhjYiIouKnMJH1Uxkr
xcpCBD8QUbOKH0g2GzSKi99YJFpoErGw0xgLcUUlUTBgPIczxfBm582bOXPm
s/W721vbcs65sxAPeZo5dzQ6txI/VkNmJc6Nwd4bnJsNfRVs3UH25dAbvOxV
+Eynzv2D3EHAcfh8gRyucW4G4mWQMux19o72gleeEXxbCsrHXFXE+Aa5At/f
eE5CijnlYT5i6AvSmbfJK1cjnh/g8xO5IvRd+C6BtNcIL+MTcxWxduJ5E99e
xvt1kCfwmYb9MeyDeB70qmMAPsug/4E+x6l2xljqlY+1/CI/iH8N3NXCLyJe
mqrGDM8bmWKQQ2JfAfkM+xjkIvwPBb1n/BHYzkXhYU2sjXGaLB9UV8E3Kd4t
gn4cvvtSxT0CfU8qfKeB5xbkDHx2wH4J9u3Qu4L60AspBvHP36zvkdVITBco
0N/iOQxpceJxIfRJp350Qe5B3+v1mzp5Zd/I7TZvsaB/B5b1wPHV+s85IG9l
2K+Dn3xOfN82zr1X7mbo7+BTF4VjAnpzVA9f0BfSCJ9R1Hce9jfAuCaqftbO
fMRBDFP2DXkj9qrhfADfuVG8Poc+Pyou+aiYP+fpvfFAjD+s3s6ccjA+52bI
MHOWBg3ba8RcEPWOcWcG2VnjS6uT/N/1ylkgFpuZrdAfZspPzmqNt8WwL4nC
1Ba0S5yrVtjuZ4p9LGqf2WPO+IjNeQvspUx8cD+6MvV2XtB3xN8H26tEdWyC
fzETRvY/bzNwwus76pz3q5lmlXH7vbhmnmeJbMQ1migH4/Unisn+H0gVl1iC
7eyWKBzEUBvEAfnnnu1PxQXzDFhfubtDxjuxlBLhIa8V6ye55I1grM2p5oYz
Q765q+S8PmpnuC/sD+eOPfqE92ujdoP3qicIA/d03O4PZ7/T5or3ijvPG8Xa
ykFcNdj9ytssTNuc8H2f+Q9bzayXNbE37MtfxNwQNX8U7h7n0AHbRtgnchLe
L+5Rh1efPlq/OqxnveZHH94y3iDuPm8CbwRvMm8KZ4tzRVvRbgcxlg0/Z6to
/qdScUo+T1ou5iVHPXYneYNLxhvjFuz+855N2a7Rlz78L+Dd7jb9PyiP5Mg=

         "],
         VertexColors->None], 
        PolygonBox[{{1637, 1909, 808, 882}, {1951, 1782, 675, 868}, {1914, 
         1910, 809, 813}, {1373, 1915, 815, 1}, {1942, 1764, 663, 857}, {1947,
          1773, 669, 863}, {1957, 1791, 681, 873}, {1969, 1968, 893, 894}, {
         1913, 1907, 806, 812}, {1908, 1801, 689, 808}, {1638, 2181, 1134, 
         809}, {1635, 1905, 804, 806}, {1640, 1914, 813, 540}, {1540, 1642, 
         542, 367}, {2028, 1492, 721, 964}, {1847, 1846, 135, 662}, {1491, 
         2028, 964, 771}, {1781, 1780, 674, 675}, {1482, 2019, 957, 767}, {
         1472, 2013, 950, 763}, {1826, 1825, 91, 726}, {1772, 1771, 668, 
         669}, {1462, 2003, 938, 759}, {1814, 1559, 1037, 707}, {1800, 1799, 
         688, 689}, {1634, 1906, 805, 1133}, {1639, 1913, 812, 539}, {1568, 
         1874, 771, 1044}, {2212, 1862, 759, 805}, {1688, 1689, 446, 91}, {
         1576, 1879, 775, 1051}, {1790, 1789, 680, 681}, {2181, 1637, 882, 
         1134}, {1447, 1668, 463, 135}, {1809, 1551, 1030, 699}, {1455, 1641, 
         541, 368}, {1915, 1543, 368, 815}, {1789, 1530, 752, 680}, {1780, 
         1524, 749, 674}, {1799, 1536, 756, 688}, {2013, 1473, 707, 950}, {
         2019, 1483, 713, 957}, {1771, 1518, 746, 668}, {1551, 1868, 763, 
         1030}, {2003, 1463, 699, 938}, {1763, 1762, 662, 663}, {1856, 1951, 
         868, 752}, {1859, 1957, 873, 756}, {1850, 1942, 857, 746}, {1821, 
         1576, 1051, 721}, {1817, 1568, 1044, 713}, {2033, 1824, 726, 775}, {
         1853, 1947, 863, 749}, {1641, 1456, 539, 541}, {1905, 1634, 1133, 
         804}, {1642, 1457, 540, 542}, {1968, 1632, 367, 893}, {1559, 1871, 
         767, 1037}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1373, 1915, 1543, 1542, 2207, 1455, 1641, 1456, 2208, 1639, 
         1913, 1907, 1635, 1905, 1634, 1906, 2235, 1544, 2212, 1862, 2211, 
         1462, 2003, 1463, 1809, 1551, 1868, 2223, 1472, 2013, 1473, 1814, 
         1559, 1871, 2226, 1482, 2019, 1483, 1817, 1568, 1874, 2229, 1491, 
         2028, 1492, 1821, 1576, 1879, 2232, 1498, 2033, 1824, 1826, 1825, 
         1885, 1688, 1689, 1593, 1746, 1937}],
        "1.4`"],
       Annotation[#, 1.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1939, 1747, 1607, 1668, 1447, 1413, 1846, 1847, 1762, 1763, 
         1764, 1942, 1850, 1518, 1771, 1772, 1773, 1947, 1853, 1524, 1780, 
         1781, 1782, 1951, 1856, 1530, 1789, 1790, 1791, 1957, 1859, 1536, 
         1799, 1800, 1801, 1908, 2239, 1909, 1637, 2181, 1638, 1910, 1914, 
         1640, 2209, 1457, 1642, 1540, 2210, 1541, 1632, 1968, 1969}],
        "1.4`"],
       Annotation[#, 1.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1721, 1441, 1402, 1834, 1835, 1752, 1753, 1754, 1935, 2122, 
         1591, 2236, 2047, 1505, 2048, 1506, 1836, 1891, 1890, 1694, 1695, 
         1606, 1895, 1605, 2133, 1446, 1412, 1844, 1845, 1760, 1761, 1448, 
         1417, 1941, 1849, 1517, 1768, 1769, 1770, 1946, 1852, 1523, 1777, 
         1778, 1779, 1950, 1855, 1529, 1786, 1787, 1788, 1956, 1858, 1535, 
         1797, 1798, 1452, 1426, 1734, 1735, 1631, 1902, 1904, 1903, 1911, 
         1912}],
        "1.3`"],
       Annotation[#, 1.3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1724, 1697, 1896, 1838, 1839, 2058, 2057, 1511, 2234, 1892, 
         1597, 2130, 1598, 2131, 1756, 1755, 1507, 1837, 1936, 1407, 1443, 
         1666, 1592, 1743, 1744, 1745, 1690, 1886, 1828, 1829, 1827, 1881, 
         1880, 2110, 2111, 1822, 1494, 2029, 1493, 2230, 1875, 1569, 1818, 
         1485, 2020, 1484, 2227, 1872, 1560, 1815, 1475, 2014, 1474, 2224, 
         1869, 1552, 1811, 1464, 2004, 1810, 1864, 1863, 2089, 1707, 1708, 
         1633, 1740, 1741, 1658, 1374, 1738, 1739}],
        "1.3`"],
       Annotation[#, 1.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1396, 1932, 2107, 2106, 1663, 2109, 1575, 2108, 1574, 1685, 
         1497, 1884, 1585, 1883, 2117, 2116, 1440, 1401, 1832, 1833, 1750, 
         1751, 2121, 1590, 2120, 1589, 2044, 1504, 2043, 2046, 2045, 2129, 
         1693, 1410, 2201, 1604, 1667, 1445, 1411, 1842, 1843, 1757, 1758, 
         1759, 1940, 1848, 1516, 1765, 1766, 1767, 1945, 1851, 1522, 1774, 
         1775, 1776, 1949, 1854, 1528, 1783, 1784, 1785, 1955, 1857, 1534, 
         1795, 1796, 1451, 1425, 1732, 1733, 1630, 2178, 1629, 2179, 1736, 
         1737}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1420, 1948, 2141, 2140, 1519, 2135, 1611, 1943, 1944, 1672, 
         1671, 1898, 1610, 1748, 1749, 1418, 1698, 1897, 1840, 1841, 2061, 
         2060, 1512, 2059, 2237, 1599, 2219, 2218, 1991, 1990, 1989, 2050, 
         2049, 1408, 1444, 1594, 2123, 1595, 1692, 1691, 1887, 1830, 1831, 
         2035, 2034, 1499, 2233, 1882, 1577, 1823, 1496, 2030, 1495, 2231, 
         1876, 1570, 1819, 1487, 2021, 1486, 2228, 1873, 1561, 1816, 1477, 
         2015, 1476, 2225, 1870, 1553, 1813, 1465, 2005, 1812, 1866, 1865, 
         2090, 1710, 1711, 1643, 1916, 1917, 1918, 1706, 1709}],
        "1.2`"],
       Annotation[#, 1.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1375, 1919, 1920, 1805, 2002, 1458, 1806, 1545, 1867, 2222, 
         1466, 2006, 1467, 2097, 2098, 1923, 1383, 2016, 1478, 1972, 1973, 
         1974, 1389, 2022, 2023, 1975, 1976, 1437, 1393, 2031, 2032, 1979, 
         1980, 1439, 1397, 2036, 2037, 1981, 1982, 1983, 1403, 2040, 1503, 
         1984, 1985, 2125, 2126, 2124, 1596, 2052, 1508, 2051, 2054, 2053, 
         2132, 1696, 1414, 2202, 1608, 1669, 1670, 1415, 2203, 1609, 1515, 
         2137, 1613, 2136, 1612, 1449, 1419, 2071, 1520, 1995, 1996, 2145, 
         2146, 2142, 2144, 2143, 1699, 1954, 1953, 1952, 1617, 2149, 1673, 
         2152, 1619, 2150, 1618, 2151, 1701, 1702, 1622, 1958, 1423}],
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1432, 1454, 1804, 1803, 1539, 1861, 1961, 1794, 1793, 1792, 
         1533, 2159, 2160, 2158, 1621, 2083, 1527, 2081, 1526, 2082, 1616, 
         2148, 2079, 2080, 2076, 2078, 2077, 2139, 2069, 2070, 2066, 2068, 
         2067, 2134, 2064, 2065, 2062, 1514, 2063, 1603, 2056, 1510, 2055, 
         1509, 2127, 2128, 1938, 1409, 1988, 1987, 1986, 2042, 2041, 1406, 
         1442, 1587, 2118, 1588, 2119, 1502, 1687, 1583, 2114, 1584, 2115, 
         1665, 2113, 1582, 1933, 1934, 1400, 1684, 1877, 1878, 1820, 1490, 
         2027, 1489, 2025, 2026, 1930, 1931, 1392, 1436, 2104, 1566, 2103, 
         1567, 2105, 1481, 2102, 1558, 1927, 1928, 1929, 1435, 1660, 1557, 
         1742, 1926}],
        "1.1`"],
       Annotation[#, 1.1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1376, 1921, 1546, 2091, 1459, 1970, 1971, 1433, 1377, 1712, 
         1384, 2194, 1648, 1717, 1716, 2099, 1554, 2018, 1479, 2017, 1480, 
         1562, 2195, 1390, 2024, 1488, 1977, 1978, 1438, 1394, 1718, 1398, 
         2198, 1649, 1720, 1719, 2112, 1578, 2039, 1500, 2038, 1501, 1650, 
         2200, 1404, 1889, 1586, 1888, 113, 305, 99, 295, 1176, 1405, 1686, 
         1580, 2217, 1581, 1664, 1579, 2199, 1399, 1683, 1572, 2216, 1573, 
         1662, 1571, 2197, 1395, 1682, 1564, 2215, 1565, 1661, 1563, 2196, 
         1391, 1681, 1555, 2214, 1556, 1659, 2100, 2101, 1924, 1925, 1388, 
         1680, 2093, 2094, 2092, 2096, 2095, 2180, 1636, 1250, 239, 15}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{211, 240, 230, 1962, 1963, 1427, 1704, 2164, 2165, 2163, 
         2167, 2166, 1675, 2161, 2162, 1959, 1960, 1424, 1703, 2154, 2155, 
         2153, 2157, 2156, 1674, 1620, 2204, 1421, 1700, 2147, 1097, 337, 155,
          330, 141, 321, 127, 312, 113, 1893, 1600, 1894, 1601, 2220, 1602, 
         1513, 1992, 1993, 1994, 1416, 1722, 1723, 1651, 2182, 2184, 2183, 
         1725, 2138, 2073, 2074, 2072, 1521, 2075, 1614, 2221, 1615, 1525, 
         1997, 1998, 1999, 1422, 1726, 1727, 1656, 2189, 1655, 2190, 1731, 
         2174, 2087, 2088, 2086, 1538, 2177, 1628, 1966, 1967}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1378, 2191, 1644, 1547, 1646, 2238, 1645, 1713, 1714, 1647, 
         2192, 1379, 1715, 1385, 2008, 1468, 2007, 1469, 2009, 1386, 2011, 
         1470, 2010, 1471, 2012, 1387, 1678, 1679, 1550, 2193, 1380, 1434, 
         1548, 2213, 1549, 1460, 1807, 1461, 1808, 1922, 1381, 1677, 1382}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1428, 1453, 1899, 1900, 1860, 1537, 1802, 1901, 2175, 2176, 
         1964, 1965, 1429, 1705, 2171, 1623, 2170, 1624, 1676, 1450, 2168, 
         2169, 2084, 1531, 2000, 2172, 2173, 1625, 2085, 1532, 2001, 2185, 
         2186, 1652, 2187, 1728, 1653, 2188, 1654, 1730, 1729, 1430, 2205, 
         1657, 1626, 1627, 2206, 1431}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->834979825]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8056],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand in terms of Bessel functions:"
}], "ExampleText",
 CellID->415425077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Hypergeometric0F1", "[", 
   RowBox[{"a", ",", 
    RowBox[{"x", "^", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->684169864],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", 
   RowBox[{"1", "-", "a"}]], " ", 
  RowBox[{"BesselI", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "+", "a"}], ",", 
    RowBox[{"2", " ", "x"}]}], "]"}], " ", 
  RowBox[{"Gamma", "[", "a", "]"}]}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122616703]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Hypergeometric0F1", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", 
     RowBox[{"x", "^", "2"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->293738485],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", 
   RowBox[{"1", "-", "a"}]], " ", 
  RowBox[{"BesselJ", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "+", "a"}], ",", 
    RowBox[{"2", " ", "x"}]}], "]"}], " ", 
  RowBox[{"Gamma", "[", "a", "]"}]}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->199736788]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15955],

Cell["Continued fraction with arithmetic progression terms:", "ExampleText",
 CellID->436735394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{
     RowBox[{"Hypergeometric0F1", "[", 
      RowBox[{
       RowBox[{"2", "/", "3"}], ",", 
       RowBox[{"1", "/", "9"}]}], "]"}], "/", 
     RowBox[{"Hypergeometric0F1", "[", 
      RowBox[{
       RowBox[{"5", "/", "3"}], ",", 
       RowBox[{"1", "/", "9"}]}], "]"}]}]}], ",", "20"}], "]"}]], "Input",
 CellTags->"Ex--21904916965354520515,1",
 CellLabel->"In[1]:=",
 CellID->211823898],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "5", ",", "8", ",", "11", ",", "14", ",", "17", ",", "20", ",", 
   "23", ",", "26", ",", "29", ",", "32", ",", "35", ",", "38", ",", "41", 
   ",", "44", ",", "47", ",", "50", ",", "53", ",", "56", ",", "59"}], 
  "}"}]], "Output",
 ImageSize->{490, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21904916965354520515,1",
 CellLabel->"Out[1]=",
 CellID->603184025]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7633],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pochhammer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pochhammer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypergeometric1F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric1F1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypergeometric2F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric2F1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HypergeometricPFQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HypergeometricPFQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypergeometric0F1Regularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric0F1Regularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HypergeometricU",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HypergeometricU"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30290]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8113],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->3287]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->32340],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/ConfluentHypergeometricLimitFunction.\
html"], None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/HypergeometricFunctions/\
Hypergeometric0F1/"], None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->411860475],

Cell[TextData[ButtonBox["Hypergeometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HypergeometricFunctions"]], "MoreAbout",
 CellID->18875868]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hypergeometric0F1 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 53.5697084}", "context" -> "System`", 
    "keywords" -> {
     "0F1", "generalized hypergeometric function", "hypergeometric 0F1", 
      "hypergeometric function 0F1"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Hypergeometric0F1[a, z] is the confluent hypergeometric function \
\\[Null]_0F_1 (; a; z). ", "synonyms" -> {"hypergeometric 0f1"}, "title" -> 
    "Hypergeometric0F1", "type" -> "Symbol", "uri" -> 
    "ref/Hypergeometric0F1"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6149, 204, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19004540]},
 "Ex--21915062429678464875,1"->{
  Cell[14153, 509, 302, 9, 70, "Input",
   CellTags->"Ex--21915062429678464875,1",
   CellID->320879286],
  Cell[14458, 520, 3083, 101, 114, "Output",
   CellTags->"Ex--21915062429678464875,1",
   CellID->213167135]},
 "Ex--21904916965354520515,1"->{
  Cell[82942, 1876, 482, 15, 70, "Input",
   CellTags->"Ex--21904916965354520515,1",
   CellID->211823898],
  Cell[83427, 1893, 456, 12, 36, "Output",
   CellTags->"Ex--21904916965354520515,1",
   CellID->603184025]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 88813, 2074},
 {"Ex--21915062429678464875,1", 88965, 2078},
 {"Ex--21904916965354520515,1", 89216, 2085}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2482, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3105, 87, 55, 1, 70, "ObjectName",
 CellID->31168],
Cell[3163, 90, 798, 25, 70, "Usage",
 CellID->3719]
}, Open  ]],
Cell[CellGroupData[{
Cell[3998, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4476, 137, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4599, 143, 783, 28, 70, "Notes",
 CellID->9982],
Cell[5385, 173, 266, 8, 70, "Notes",
 CellID->245273241],
Cell[5654, 183, 236, 7, 70, "Notes",
 CellID->31226],
Cell[5893, 192, 219, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6149, 204, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19004540],
Cell[CellGroupData[{
Cell[6533, 218, 148, 5, 70, "ExampleSection",
 CellID->492714153],
Cell[6684, 225, 64, 1, 70, "ExampleText",
 CellID->318993004],
Cell[CellGroupData[{
Cell[6773, 230, 137, 4, 28, "Input",
 CellID->32227528],
Cell[6913, 236, 175, 5, 36, "Output",
 CellID->235175359]
}, Open  ]],
Cell[7103, 244, 125, 3, 70, "ExampleDelimiter",
 CellID->122278948],
Cell[7231, 249, 74, 1, 70, "ExampleText",
 CellID->325766619],
Cell[CellGroupData[{
Cell[7330, 254, 254, 8, 28, "Input",
 CellID->332211415],
Cell[7587, 264, 1253, 25, 56, "Output",
 Evaluatable->False,
 CellID->848989729]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8889, 295, 216, 7, 70, "ExampleSection",
 CellID->30906],
Cell[9108, 304, 89, 1, 70, "ExampleText",
 CellID->118523973],
Cell[CellGroupData[{
Cell[9222, 309, 185, 6, 70, "Input",
 CellID->81938993],
Cell[9410, 317, 272, 7, 36, "Output",
 CellID->10910795]
}, Open  ]],
Cell[9697, 327, 125, 3, 70, "ExampleDelimiter",
 CellID->579116933],
Cell[9825, 332, 69, 1, 70, "ExampleText",
 CellID->51663803],
Cell[CellGroupData[{
Cell[9919, 337, 212, 7, 70, "Input",
 CellID->635284545],
Cell[10134, 346, 252, 8, 36, "Output",
 CellID->27069349]
}, Open  ]],
Cell[10401, 357, 125, 3, 70, "ExampleDelimiter",
 CellID->427122095],
Cell[10529, 362, 113, 3, 70, "ExampleText",
 CellID->139867510],
Cell[CellGroupData[{
Cell[10667, 369, 185, 5, 70, "Input",
 CellID->232385553],
Cell[10855, 376, 236, 7, 36, "Output",
 CellID->262495566]
}, Open  ]],
Cell[11106, 386, 125, 3, 70, "ExampleDelimiter",
 CellID->611053237],
Cell[11234, 391, 92, 1, 70, "ExampleText",
 CellID->91755628],
Cell[CellGroupData[{
Cell[11351, 396, 160, 5, 70, "Input",
 CellID->252304268],
Cell[11514, 403, 282, 11, 64, "Output",
 CellID->44886916]
}, Open  ]],
Cell[11811, 417, 125, 3, 70, "ExampleDelimiter",
 CellID->981387013],
Cell[11939, 422, 236, 7, 70, "ExampleText",
 CellID->116181103],
Cell[CellGroupData[{
Cell[12200, 433, 197, 6, 70, "Input",
 CellID->336267988],
Cell[12400, 441, 273, 9, 36, "Output",
 CellID->89646640]
}, Open  ]],
Cell[12688, 453, 125, 3, 70, "ExampleDelimiter",
 CellID->760443585],
Cell[12816, 458, 203, 7, 70, "ExampleText",
 CellID->653625731],
Cell[CellGroupData[{
Cell[13044, 469, 174, 5, 70, "Input",
 CellID->35954786],
Cell[13221, 476, 545, 13, 70, "Output",
 Evaluatable->False,
 CellID->577395187]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13815, 495, 239, 7, 70, "ExampleSection",
 CellID->19463],
Cell[14057, 504, 71, 1, 70, "ExampleText",
 CellID->67073751],
Cell[CellGroupData[{
Cell[14153, 509, 302, 9, 70, "Input",
 CellTags->"Ex--21915062429678464875,1",
 CellID->320879286],
Cell[14458, 520, 3083, 101, 114, "Output",
 CellTags->"Ex--21915062429678464875,1",
 CellID->213167135]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17590, 627, 223, 7, 70, "ExampleSection",
 CellID->11620],
Cell[17816, 636, 84, 1, 70, "ExampleText",
 CellID->335329853],
Cell[17903, 639, 924, 31, 70, "Input",
 CellID->363924806],
Cell[18830, 672, 1278, 40, 70, "Input",
 CellID->232971776],
Cell[CellGroupData[{
Cell[20133, 716, 726, 25, 70, "Input",
 CellID->122809672],
Cell[20862, 743, 160, 5, 36, "Output",
 CellID->13453149]
}, Open  ]],
Cell[21037, 751, 62, 1, 70, "ExampleText",
 CellID->1561348554],
Cell[CellGroupData[{
Cell[21124, 756, 488, 16, 70, "Input",
 CellID->477838301],
Cell[21615, 774, 59113, 1005, 70, "Output",
 CellID->834979825]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[80777, 1785, 232, 7, 70, "ExampleSection",
 CellID->8056],
Cell[81012, 1794, 238, 8, 70, "ExampleText",
 CellID->415425077],
Cell[CellGroupData[{
Cell[81275, 1806, 203, 6, 70, "Input",
 CellID->684169864],
Cell[81481, 1814, 400, 14, 36, "Output",
 CellID->122616703]
}, Open  ]],
Cell[CellGroupData[{
Cell[81918, 1833, 224, 7, 70, "Input",
 CellID->293738485],
Cell[82145, 1842, 400, 14, 36, "Output",
 CellID->199736788]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[82594, 1862, 224, 7, 70, "ExampleSection",
 CellID->15955],
Cell[82821, 1871, 96, 1, 70, "ExampleText",
 CellID->436735394],
Cell[CellGroupData[{
Cell[82942, 1876, 482, 15, 70, "Input",
 CellTags->"Ex--21904916965354520515,1",
 CellID->211823898],
Cell[83427, 1893, 456, 12, 36, "Output",
 CellTags->"Ex--21904916965354520515,1",
 CellID->603184025]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[83944, 1912, 310, 9, 70, "SeeAlsoSection",
 CellID->7633],
Cell[84257, 1923, 1543, 53, 70, "SeeAlso",
 CellID->30290]
}, Open  ]],
Cell[CellGroupData[{
Cell[85837, 1981, 313, 9, 70, "TutorialsSection",
 CellID->8113],
Cell[86153, 1992, 143, 3, 70, "Tutorials",
 CellID->3287]
}, Open  ]],
Cell[CellGroupData[{
Cell[86333, 2000, 321, 9, 70, "RelatedLinksSection",
 CellID->32340],
Cell[86657, 2011, 205, 4, 70, "RelatedLinks"],
Cell[86865, 2017, 211, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87113, 2026, 319, 9, 70, "MoreAboutSection",
 CellID->411860475],
Cell[87435, 2037, 158, 3, 70, "MoreAbout",
 CellID->18875868]
}, Open  ]],
Cell[87608, 2043, 27, 0, 70, "History"],
Cell[87638, 2045, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

