(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34343,       1174]
NotebookOptionsPosition[     27845,        952]
NotebookOutlinePosition[     29589,       1000]
CellTagsIndexPosition[     29459,        994]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypergeometric0F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric0F1"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypergeometric0F1\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypergeometric Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/HypergeometricFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Hypergeometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Hypergeometric0F1Regularized", "ObjectName",
 CellID->24682],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hypergeometric0F1Regularized",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Hypergeometric0F1Regularized"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the regularized confluent hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         SubscriptBox["\[Null]", "0"], "\[InvisibleSpace]", 
         SubscriptBox["F", "1"], "(", 
         RowBox[{"a", ";", "z"}], ")"}], "/", 
        RowBox[{"\[CapitalGamma]", "(", "a", ")"}]}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26617]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hypergeometric0F1Regularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric0F1Regularized"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " is finite for all finite values of ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32706],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Hypergeometric0F1Regularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric0F1Regularized"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->518185493],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric0F1Regularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric0F1Regularized"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric0F1Regularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric0F1Regularized"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->120982074],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->28261490],

Cell["Evaluate numerically:", "ExampleText",
 CellID->140637669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric0F1Regularized", "[", 
  RowBox[{"0", ",", "1.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8680528],

Cell[BoxData["2.9441796419042667`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->443904273]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->89404606],

Cell["Series expansion at the origin:", "ExampleText",
 CellID->96997072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Hypergeometric0F1Regularized", "[", 
    RowBox[{"a", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29287998],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"Gamma", "[", "a", "]"}]], "+", 
   FractionBox["x", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "a"}], "]"}]], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"2", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"2", "+", "a"}], "]"}]}]], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], 
    RowBox[{"6", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"3", "+", "a"}], "]"}]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   Gamma[$CellContext`a]^(-1), Gamma[1 + $CellContext`a]^(-1), Rational[1, 2]/
    Gamma[2 + $CellContext`a], Rational[1, 6]/Gamma[3 + $CellContext`a]}, 0, 
   4, 1],
  Editable->False]], "Output",
 ImageSize->{408, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293947601]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12306],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->114185134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric0F1Regularized", "[", 
  RowBox[{"0", ",", 
   RowBox[{"2.5", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->753755510],

Cell[BoxData[
 RowBox[{"5.80072611724349`", "\[InvisibleSpace]", "+", 
  RowBox[{"5.393682326454145`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->272565137]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53312816],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->51663803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Hypergeometric0F1Regularized", "[", 
    RowBox[{"0", ",", "2"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198081954],

Cell[BoxData["4.\
7896661985468094330452652728727463039372740141827248889947820152977`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8278906]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->288544536],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->25172087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric0F1Regularized", "[", 
  RowBox[{"0", ",", "2.0000000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177343890],

Cell[BoxData["4.78966619854680943304526527286918628109`25.000000000000004"], \
"Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82524388]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->611053237],

Cell["Evaluate symbolically for half-integer parameters:", "ExampleText",
 CellID->91755628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric0F1Regularized", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18630270],

Cell[BoxData[
 FractionBox[
  RowBox[{"Cosh", "[", 
   RowBox[{"2", " ", 
    SqrtBox["x"]}], "]"}], 
  SqrtBox["\[Pi]"]]], "Output",
 ImageSize->{84, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->342489565]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->981387013],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric0F1Regularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric0F1Regularized"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->116181103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric0F1Regularized", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", "1.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->336267988],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.804203959495402`", ",", "0.807861543865596`", ",", 
   "0.28272130764631453`"}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->521535708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->760443585],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->653625731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hypergeometric0F1Regularized", "[", 
   RowBox[{"a", ",", "z"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35954786],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVVM0OgjAMHttAkJMHo9446QPwDnryIRZiAgejQd4fV5isdCVBktH/fu1a
uJuufjxN11SmuLXmXTfVp7i+WqtSkRCitGd3FJbvLTecsu+BqpHAk1tWWRqD
ChhnypEM7IbIcvTTXhPGDDDxJK/MHI1+Mc78c2Gr0BhBuvaA4j4lsmlH4ZIA
LWJ6kQQp4ZCpXfv7EyKd17YCU5Gc8R+YY4aMmcBaREG2YBExmChFlSEqmoRG
E5BODvZhVmVKqgy7CmMytlKoXzHTVU6/kBl5bol8CiJSFjklcQcie7SEudE9
NxdRerzZ5l0mPf4K4H1Gce5fEH0BkeMQGw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{51, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->10680436]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32624],

Cell["Series expansion at infinity:", "ExampleText",
 CellID->67073751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Hypergeometric0F1Regularized", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21915062429678464875,1",
 CellLabel->"In[1]:=",
 CellID->320879286],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox["\[Pi]", "4"], "+", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      SqrtBox["x"]}]}], "]"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"1", "/", "4"}]], 
       RowBox[{
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"1", "/", "4"}]]}]], "-", 
      FractionBox[
       RowBox[{"15", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "/", "4"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"3", "/", "4"}]]}], 
       RowBox[{"512", " ", 
        SqrtBox["\[Pi]"]}]], "-", 
      FractionBox[
       RowBox[{"4725", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "/", "4"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"7", "/", "4"}]]}], 
       RowBox[{"262144", " ", 
        SqrtBox["\[Pi]"]}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], 
        RowBox[{"9", "/", "4"}]],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {}, -1, 9, 4],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[
      1], {(-1)^Rational[1, 4] Pi^Rational[-1, 2], 0, 0, 0, 
       Rational[-15, 512] (-1)^Rational[1, 4] Pi^Rational[-1, 2], 0, 0, 0, 
       Rational[-4725, 262144] (-1)^Rational[1, 4] Pi^Rational[-1, 2]}, -1, 9,
       4],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"3", "/", "4"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"1", "/", "4"}]]}], 
       RowBox[{"16", " ", 
        SqrtBox["\[Pi]"]}]], "+", 
      FractionBox[
       RowBox[{"105", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"3", "/", "4"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"5", "/", "4"}]]}], 
       RowBox[{"8192", " ", 
        SqrtBox["\[Pi]"]}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], 
        RowBox[{"9", "/", "4"}]],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {}, 1, 9, 4],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[1], {
      Rational[3, 16] (-1)^Rational[3, 4] Pi^Rational[-1, 2], 0, 0, 0, 
       Rational[105, 8192] (-1)^Rational[3, 4] Pi^Rational[-1, 2]}, 1, 9, 4],
     Editable->False], ")"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["\[Pi]", "4"], "+", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      SqrtBox["x"]}]}], "]"}]}]}]], "Output",
 ImageSize->{523, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21915062429678464875,1",
 CellLabel->"Out[1]=",
 CellID->320905832]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12473],

Cell[TextData[{
 "Probability that in a voting game with 2 candidates, and the number of \
votes being two independent Poisson random variables with means ",
 Cell[BoxData["p"], "InlineFormula"],
 " and ",
 Cell[BoxData["q"], "InlineFormula"],
 ", candidate 1 gets ",
 Cell[BoxData["k"], "InlineFormula"],
 " more votes than candidate 2 out of ",
 Cell[BoxData["n"], "InlineFormula"],
 " is:"
}], "ExampleText",
 CellID->673646201],

Cell[BoxData[
 RowBox[{
  RowBox[{"pr", "[", 
   RowBox[{"k_", ",", "n_", ",", "p_", ",", "q_"}], "]"}], ":=", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "n"}], " ", "p"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"n", " ", "p"}], ")"}], "k"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "n"}], " ", "q"}]], 
   RowBox[{"Hypergeometric0F1Regularized", "[", 
    RowBox[{
     RowBox[{"k", "+", "1"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"n", " ", "p"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"n", " ", "q"}], ")"}]}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->434286091],

Cell["Plot distribution for almost even odds:", "ExampleText",
 CellID->306288592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"pr", "[", 
       RowBox[{"n", ",", "100", ",", 
        RowBox[{"53", "/", "100"}], ",", 
        RowBox[{"47", "/", "100"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"-", "60"}], ",", "60"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->388511302],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWktvHEUQHnufsZFBMQlrrx0cK+Ihgkh4CPK2ZYydyAQFy8GKvAqLFWGD
HYMTxAnxB+AGEiQICSkgIQ4ckIjEFQnBiSsHLskfWbq7erpqvqnZnWXXCCvu
3a6q7+uvuntqesZ5tXlz49p28+bmenNqYbf53sbm+o2pV3Z2jakwEEXRPfP7
RS0y31vmm/u912qZT9lWTDtoXAX/OWmtRRsb/1hr3Xxa46Dvn4K+jpoE7oIb
sWzbcoilL54rKrB9PMmpRIzZphQIqE1FncgVlXO0DN12ugfsJ5kKfhDrtU0l
xLfVMOpnNYUvAT464CMLHVWf7BhRi0dNjVLPnXHeNa2JfpiBhLpJLUIwnOrg
7zxCd1kVMjkG90T/WCZzPVONs9AmK8lrsDv+8Zxr+FLOuOyRJjKVJue/Khiy
q8xEK1llTrfyVLRDwE2XnKyMu5DPVhurVRpVv73z57kzX5p/m2//KNtB8xGV
wBj9b6wF6n/6ya/RUcjurG0qlFfP41TA2pWyoptn2/7t94if9RnTfevNHxpr
33/+2W87138KrTEaV9pIkdIFcHKpnMbVr4EuLn1jXDNnbmGmeB2VoF/ust8r
vhOfu3KOhz1iHOcXvjbfTWq2PXervxObc87v/vyX3zNV0HsY+gdtM/zH7/eJ
ZH7uqyB+bua2XxTzMw24Kejbu3c0FGoAMbw8ezsoNJIKHTioCi3adl9QRJsl
IQdzeF7UHz/78bybUY851iWHIVa7+WjfGTbPcQg4nxXXPnFSMnZmn3OMF21b
NIw0Z6bFfBxH6Y2V7xLoFxz6NecjPR9/9IvPLK7Lx52XRv/wg7se+aJDXnKj
EKsZNKX8GPhPMCo13gRgn3E50bivX7pjBiX0MnCqOOE/yajUmOOAfVrNlRhW
gFfFCv9pgaJxLZeOYj+hLjsr6bA64zv4UbCfFdE88hiM8RT4JYpH1lHsJ9Qq
KHgEUE+Cf0agWIGOYr9EsQIdxX5C7fq52na9K6DnAHA8Af5ZgWI9Oor9EsV6
dBT7Z4Pe9DlmDXSNQtRj4J8TKNalo9gvUaxr1M/g42Cfa6NXtzZA5X6IOgL+
+YByT1tFo9FHJs+HlgLvfkcgt3nOzZ45KY2ITi7JUzDeC4oqM88DMAeefMy2
u9UTQ8Zu6R9T4pmClib97NCJbxrWdiG5tmKl5FsJ+4nnnGlYWWK6CqvykIpi
P6Gydy/XDD2mCfmMQNRh8C8KFGvXUeyXKNauo9i/2GNu66D9AYh6FPwXBIq1
6yj2SxRr11Hsv9Aht3+X8TXIaAiiJsG/JFCckY5iv0RxRjqK/Us95tZthQ5P
3cJL1yifubWKW4c5cqfQrFq0jyxmbswXqutRePeiM/M8tmX27y/M/PmnDXxu
w8pUh/luy562wFNCd/VcY8hdz3O869H54lUut9pXWn2njMM6u+eFaAOsFRXF
ayhRbI3feuOayGi24hjd7/derDXI2D3HRO+AteQzGoNMZTRbcefXIGOJYiui
+pkxV5ctyAz31kHwLwtU8u6eRrFfojhDHcX+5T3JWI/ZhjzxmnsY/CsCxXnq
KPYTql09tgzW5IpBmAqdl2eKePe8NvW5Tsanfb1C/bcn507zMgrrfzmxknHN
jVeP/lLE0ZF/TuSdQPgdF8fWOI5XVsaxNYqut/LubN36fpyPcfBTGyteFVHh
fu6jWK+M4nvzfshhtUetaH0QtF7hKLumwTECaiEuOEZAL8QFx7vd5eHPLKxz
GHSvpWJZ6zBoT8ey3mHQv9ZJWSVYE/qqoK+RyHcQFFWh38jgZ11V0NlQdRZA
RRH6VxNXnlZD8VrWr21WXoQ+jdCP+uP8Q/BGEl49th2tJC1xCJ4MXL9M+sPr
Y5NIsx1zNX3OpDb+OyyxhvfN4YVyW9Zc9b0M+2C9Z0b9BIyrccNFpf9XRjTw
D/jQSe8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10467650]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24719],

Cell[TextData[{
 "Visualize confluence relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    TagBox[
     TagBox[
      RowBox[{
       RowBox[{
        SubscriptBox["\[InvisiblePrefixScriptBase]", "0"], 
        SubscriptBox[
         OverscriptBox["F", "~"], "1"]}], "\[InvisibleApplication]", 
       RowBox[{"(", 
        RowBox[{
         TagBox[
          TagBox["\[Null]",
           InterpretTemplate[{
             SlotSequence[1]}& ]],
          Hypergeometric0F1Regularized,
          Editable->False,
          Selectable->False], ";", 
         TagBox[
          TagBox[
           TagBox["a",
            Hypergeometric0F1Regularized,
            Editable->True,
            Selectable->True],
           InterpretTemplate[{
             SlotSequence[1]}& ]],
          Hypergeometric0F1Regularized,
          Editable->False,
          Selectable->False], ";", 
         TagBox["z",
          Hypergeometric0F1Regularized,
          Editable->True,
          Selectable->True]}], ")"}]}],
      InterpretTemplate[HypergeometricPFQRegularized[#, #2, #3]& ],
      Editable->False,
      Selectable->False],
     Hypergeometric0F1Regularized], "\[LongEqual]", 
    RowBox[{
     UnderscriptBox["lim", 
      RowBox[{"p", "\[Rule]", "\[Infinity]"}]], "\[ThinSpace]", 
     TagBox[
      TagBox[
       RowBox[{
        RowBox[{
         SubscriptBox["\[InvisiblePrefixScriptBase]", "1"], 
         SubscriptBox[
          OverscriptBox["F", "~"], "1"]}], "\[InvisibleApplication]", 
        RowBox[{"(", 
         RowBox[{
          TagBox[
           TagBox[
            TagBox["p",
             Hypergeometric1F1Regularized,
             Editable->True,
             Selectable->True],
            InterpretTemplate[{
              SlotSequence[1]}& ]],
           Hypergeometric1F1Regularized,
           Editable->False,
           Selectable->False], ";", 
          TagBox[
           TagBox[
            TagBox["a",
             Hypergeometric1F1Regularized,
             Editable->True,
             Selectable->True],
            InterpretTemplate[{
              SlotSequence[1]}& ]],
           Hypergeometric1F1Regularized,
           Editable->False,
           Selectable->False], ";", 
          TagBox[
           FractionBox["z", "p"],
           Hypergeometric1F1Regularized,
           Editable->True,
           Selectable->True]}], ")"}]}],
       InterpretTemplate[HypergeometricPFQRegularized[#, #2, #3]& ],
       Editable->False,
       Selectable->False],
      Hypergeometric1F1Regularized]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->38083785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"Plot", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"Hypergeometric1F1Regularized", "[", 
      RowBox[{
       SuperscriptBox["10", "k"], ",", "0", ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "k"}]]}], "]"}], 
     RowBox[{"Hypergeometric0F1Regularized", "[", 
      RowBox[{"0", ",", "1"}], "]"}]], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "4"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0.9", ",", "1.1"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->324531108],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEtIVFEYPt7HjEpOFr1oEbZp18ZNq2gRFRIRLapFtJhEGBelmEXoogf0
ICwqo5wyJbKgx8JIjMAgEiIhEiIhKgiDsEUSJC2E4Pad18ydc86dO3dmCgWH
O+ee//7///2P85/HvTuS7ammg8n25sZk3ba2ZGuqufFw3daWNjyyKwghQ/gf
W0XQ99Bj/yHPw11vF6O1IWBRinY89iMWMfMIpQXPCdBLGHhSLyEw7QA9lSf1
ltC+m5GXHNwtqUFqFUz21MnS3Gu/REyhaxTLjoaQUCTiCkJCoS0NQfXSDUHQ
o7DKFG24pagI0aNd5PFa0TNdrihVfnE+0ipzNc2E4FQaNPxVomsWG50jLC6N
HJUtNIu3WRuYh1Ki0eopR0OvixrtiTpeqh+F5UatmXyRSn5M3CUdV+ggPo3B
9vHlyif5qn9yBPg6F7SW05rokzkjy01ZmMO0tiMs0JFoVqslj7q6n61Q6JUh
8v86yjD/zFnoDXlK59atojQXrJhlxFLFfv59IPvENqzcQjdnxVX387B1woTh
CnvqflOIrr4DmVAoWZi2PLMWEnvAqSjPDqpnX+4xju8+/+ppblopDk9s0OJn
eoOSZzVzjRh3zpi/SjxjrZirvRQ0Sjaw558+/hh/+w0XcWhjj73+2t/3Bhep
oY199syLlkNPcJF62tgQEjhOWWPawCAnJ39yb56PfLaZ/Qtdo8K+xexv2dy7
aWMaF7FZ03jgkeA7jH+kfTjH/6fDH0R89WjiZfV5PaO5z3CYWLDIvHT27r7H
vdy/7z574p48McL9wvV4cEJke3b2j8DaU1bP1tGmemZmFlYePniX7hmDE9wp
eIQ+3GHeMi+mpn4JvSYvaBUKquy1bNyAMPryCwABbW1v6CcuOt1XXt0dGIcF
cEmr5597ayhVhcwhFZ0dz3btvAPn0AEC5OE3OZqR91tbTZs4TKEsoIFY0AE5
Pf2bdBo12DkjjjxjgBA0ygdmYJX6dNyosYzlfOL9d5Q+QoESVAFwyijNvm/E
wEahwZ3m1CA6IE/nxMveC1w8xmDAbyAjdnLOiMjfpbggUojQzhvl2Luqg/ma
kesyylUzObAxNXAh8ItGuSpGY8SAB1RyKSeCSh8KygmhXDai8F0fQ4JkUJRu
oxSvIow2BoOO9lWjFD8xwBSfPOSaUYrXPlCQezoLr+f4neGiILHWkZ4sRnZe
Zdhpr7B1Xq6hLA7xdQsgWIyojRte4FwOPY8wiYw/N0tBojRGi07xPDtGhBNS
uH7+M1Jh+vP7lDQ/z0NFvivknSd25HoI+GoT+ST0f3GC50e4/u2S9PLt0wOM
pX9rIhV/AUAuBtw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49778270]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29197],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Hypergeometric0F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric0F1"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->3548]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25820],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->5312]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->3183808],

Cell[TextData[ButtonBox["Hypergeometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HypergeometricFunctions"]], "MoreAbout",
 CellID->184512162]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hypergeometric0F1Regularized - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 54.5853594}", "context" -> "System`", 
    "keywords" -> {
     "0F1 regularized", "hypergeometric0 f1 regularized", 
      "hypergeometric function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Hypergeometric0F1Regularized[a, z] is the regularized confluent \
hypergeometric function \\[Null]_0F_1 (a; z)/\\[CapitalGamma](a). ", 
    "synonyms" -> {"hypergeometric 0f1 regularized"}, "title" -> 
    "Hypergeometric0F1Regularized", "type" -> "Symbol", "uri" -> 
    "ref/Hypergeometric0F1Regularized"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5320, 182, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->120982074]},
 "Ex--21915062429678464875,1"->{
  Cell[13147, 491, 313, 9, 70, "Input",
   CellTags->"Ex--21915062429678464875,1",
   CellID->320879286],
  Cell[13463, 502, 3494, 112, 117, "Output",
   CellTags->"Ex--21915062429678464875,1",
   CellID->320905832]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29065, 980},
 {"Ex--21915062429678464875,1", 29218, 984}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1777, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2400, 74, 66, 1, 70, "ObjectName",
 CellID->24682],
Cell[2469, 77, 909, 27, 70, "Usage",
 CellID->26617]
}, Open  ]],
Cell[CellGroupData[{
Cell[3415, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3893, 126, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4016, 132, 471, 17, 70, "Notes",
 CellID->32706],
Cell[4490, 151, 288, 8, 70, "Notes",
 CellID->518185493],
Cell[4781, 161, 258, 7, 70, "Notes",
 CellID->31226],
Cell[5042, 170, 241, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5320, 182, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->120982074],
Cell[CellGroupData[{
Cell[5705, 196, 147, 5, 70, "ExampleSection",
 CellID->28261490],
Cell[5855, 203, 64, 1, 70, "ExampleText",
 CellID->140637669],
Cell[CellGroupData[{
Cell[5944, 208, 147, 4, 28, "Input",
 CellID->8680528],
Cell[6094, 214, 176, 5, 36, "Output",
 CellID->443904273]
}, Open  ]],
Cell[6285, 222, 124, 3, 70, "ExampleDelimiter",
 CellID->89404606],
Cell[6412, 227, 73, 1, 70, "ExampleText",
 CellID->96997072],
Cell[CellGroupData[{
Cell[6510, 232, 264, 8, 70, "Input",
 CellID->29287998],
Cell[6777, 242, 1010, 32, 56, "Output",
 CellID->293947601]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7836, 280, 216, 7, 70, "ExampleSection",
 CellID->12306],
Cell[8055, 289, 89, 1, 70, "ExampleText",
 CellID->114185134],
Cell[CellGroupData[{
Cell[8169, 294, 173, 5, 70, "Input",
 CellID->753755510],
Cell[8345, 301, 270, 7, 36, "Output",
 CellID->272565137]
}, Open  ]],
Cell[8630, 311, 124, 3, 70, "ExampleDelimiter",
 CellID->53312816],
Cell[8757, 316, 69, 1, 70, "ExampleText",
 CellID->51663803],
Cell[CellGroupData[{
Cell[8851, 321, 202, 6, 70, "Input",
 CellID->198081954],
Cell[9056, 329, 233, 7, 36, "Output",
 CellID->8278906]
}, Open  ]],
Cell[9304, 339, 125, 3, 70, "ExampleDelimiter",
 CellID->288544536],
Cell[9432, 344, 112, 3, 70, "ExampleText",
 CellID->25172087],
Cell[CellGroupData[{
Cell[9569, 351, 173, 4, 70, "Input",
 CellID->177343890],
Cell[9745, 357, 218, 6, 36, "Output",
 CellID->82524388]
}, Open  ]],
Cell[9978, 366, 125, 3, 70, "ExampleDelimiter",
 CellID->611053237],
Cell[10106, 371, 92, 1, 70, "ExampleText",
 CellID->91755628],
Cell[CellGroupData[{
Cell[10223, 376, 170, 5, 70, "Input",
 CellID->18630270],
Cell[10396, 383, 263, 10, 64, "Output",
 CellID->342489565]
}, Open  ]],
Cell[10674, 396, 125, 3, 70, "ExampleDelimiter",
 CellID->981387013],
Cell[10802, 401, 258, 7, 70, "ExampleText",
 CellID->116181103],
Cell[CellGroupData[{
Cell[11085, 412, 271, 9, 70, "Input",
 CellID->336267988],
Cell[11359, 423, 274, 9, 36, "Output",
 CellID->521535708]
}, Open  ]],
Cell[11648, 435, 125, 3, 70, "ExampleDelimiter",
 CellID->760443585],
Cell[11776, 440, 203, 7, 70, "ExampleText",
 CellID->653625731],
Cell[CellGroupData[{
Cell[12004, 451, 185, 5, 70, "Input",
 CellID->35954786],
Cell[12192, 458, 568, 13, 70, "Output",
 Evaluatable->False,
 CellID->10680436]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12809, 477, 239, 7, 70, "ExampleSection",
 CellID->32624],
Cell[13051, 486, 71, 1, 70, "ExampleText",
 CellID->67073751],
Cell[CellGroupData[{
Cell[13147, 491, 313, 9, 70, "Input",
 CellTags->"Ex--21915062429678464875,1",
 CellID->320879286],
Cell[13463, 502, 3494, 112, 117, "Output",
 CellTags->"Ex--21915062429678464875,1",
 CellID->320905832]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17006, 620, 223, 7, 70, "ExampleSection",
 CellID->12473],
Cell[17232, 629, 431, 12, 70, "ExampleText",
 CellID->673646201],
Cell[17666, 643, 692, 23, 70, "Input",
 CellID->434286091],
Cell[18361, 668, 82, 1, 70, "ExampleText",
 CellID->306288592],
Cell[CellGroupData[{
Cell[18468, 673, 448, 14, 70, "Input",
 CellID->388511302],
Cell[18919, 689, 2172, 40, 70, "Output",
 Evaluatable->False,
 CellID->10467650]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21140, 735, 224, 7, 70, "ExampleSection",
 CellID->24719],
Cell[21367, 744, 2611, 85, 70, "ExampleText",
 CellID->38083785],
Cell[CellGroupData[{
Cell[24003, 833, 596, 18, 70, "Input",
 CellID->324531108],
Cell[24602, 853, 1570, 30, 70, "Output",
 Evaluatable->False,
 CellID->49778270]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26233, 890, 311, 9, 70, "SeeAlsoSection",
 CellID->29197],
Cell[26547, 901, 213, 6, 70, "SeeAlso",
 CellID->3548]
}, Open  ]],
Cell[CellGroupData[{
Cell[26797, 912, 314, 9, 70, "TutorialsSection",
 CellID->25820],
Cell[27114, 923, 143, 3, 70, "Tutorials",
 CellID->5312]
}, Open  ]],
Cell[CellGroupData[{
Cell[27294, 931, 317, 9, 70, "MoreAboutSection",
 CellID->3183808],
Cell[27614, 942, 159, 3, 70, "MoreAbout",
 CellID->184512162]
}, Open  ]],
Cell[27788, 948, 27, 0, 70, "History"],
Cell[27818, 950, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

