(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51997,       1818]
NotebookOptionsPosition[     42700,       1505]
NotebookOutlinePosition[     44795,       1561]
CellTagsIndexPosition[     44663,       1555]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HypergeometricU" :> 
          Documentation`HelpLookup["paclet:ref/HypergeometricU"], 
          "Hypergeometric2F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric2F1"], 
          "HypergeometricPFQ" :> 
          Documentation`HelpLookup["paclet:ref/HypergeometricPFQ"], 
          "Hypergeometric1F1Regularized" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric1F1Regularized"],
           "WhittakerM" :> Documentation`HelpLookup["paclet:ref/WhittakerM"], 
          "Pochhammer" :> Documentation`HelpLookup["paclet:ref/Pochhammer"], 
          "Gamma" :> Documentation`HelpLookup["paclet:ref/Gamma"], 
          "GammaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/GammaRegularized"], 
          "ExpIntegralE" :> 
          Documentation`HelpLookup["paclet:ref/ExpIntegralE"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"HypergeometricU\"\>", 
       2->"\<\"Hypergeometric2F1\"\>", 3->"\<\"HypergeometricPFQ\"\>", 
       4->"\<\"Hypergeometric1F1Regularized\"\>", 5->"\<\"WhittakerM\"\>", 
       6->"\<\"Pochhammer\"\>", 7->"\<\"Gamma\"\>", 
       8->"\<\"GammaRegularized\"\>", 
       9->"\<\"ExpIntegralE\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"], 
          "Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Hypergeometric Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/HypergeometricFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Functions Used in Quantum Mechanics\"\>", 
       2->"\<\"Functions Used in Statistics\"\>", 
       3->"\<\"Hypergeometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Hypergeometric1F1", "ObjectName",
 CellID->1864],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hypergeometric1F1",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Hypergeometric1F1"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the Kummer confluent hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[Null]", "1"], "\[InvisibleSpace]", 
        SubscriptBox["F", "1"], "(", 
        RowBox[{"a", ";", "b", ";", "z"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20566]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "1"], 
    SubscriptBox["F", "1"]}], TraditionalForm]], "InlineMath"],
 " function has the series expansion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Null]", "1"], "\[InvisibleSpace]", 
     SubscriptBox["F", "1"], "(", 
     RowBox[{"a", ";", "b", ";", "z"}], ")"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      RowBox[{
       SubscriptBox[
        RowBox[{"(", "a", ")"}], "k"], "/", 
       SubscriptBox[
        RowBox[{"(", "b", ")"}], "k"]}], " ", 
      RowBox[{
       RowBox[{
        SuperscriptBox["z", "k"], "/", "k"}], "!"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->27931],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Hypergeometric1F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric1F1"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->399162356],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric1F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric1F1"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric1F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric1F1"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->22254638],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->1204557],

Cell["Evaluate numerically:", "ExampleText",
 CellID->157333599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1", "[", 
  RowBox[{"1", ",", "2", ",", "3.0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23863280],

Cell[BoxData["6.361845641062556`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->457470148]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->74192982],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  FormBox[
   TagBox[
    TagBox[
     RowBox[{
      RowBox[{
       SubscriptBox["\[InvisiblePrefixScriptBase]", "1"], 
       SubscriptBox["F", "1"]}], "\[InvisibleApplication]", 
      RowBox[{"(", 
       RowBox[{
        TagBox[
         TagBox[
          TagBox["1",
           Hypergeometric1F1,
           Editable->True,
           Selectable->True],
          InterpretTemplate[{
            SlotSequence[1]}& ]],
         Hypergeometric1F1,
         Editable->False,
         Selectable->False], ";", 
        TagBox[
         TagBox[
          TagBox["2",
           Hypergeometric1F1,
           Editable->True,
           Selectable->True],
          InterpretTemplate[{
            SlotSequence[1]}& ]],
         Hypergeometric1F1,
         Editable->False,
         Selectable->False], ";", 
        TagBox["x",
         Hypergeometric1F1,
         Editable->True,
         Selectable->True]}], ")"}]}],
     InterpretTemplate[HypergeometricPFQ[#, #2, #3]& ],
     Editable->False,
     Selectable->False],
    Hypergeometric1F1], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->786574672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Hypergeometric1F1", "[", 
    RowBox[{"1", ",", "2", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73705564],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->295469541]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55216552],

Cell["Series at the origin:", "ExampleText",
 CellID->44700959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Hypergeometric1F1", "[", 
    RowBox[{"a", ",", "b", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->845624955],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWetqE0EUnuzsrm1D0wg2bXrBhf7SX2q1oiCCYP0liD5BKEIriFJb/9R3
yaPkkfII487Nzn57Zmd2k6qggWTmnDlzLt+cuZz27eTi9OPnycXZyaR4cz75
enp28q04/nJesniPsd49xtjBNiv7ouypr/zcL7+6q3sf5C+3o4LtAH0YGO8D
vQv0U2XlPXD3gH4YGF8Feh/oI2VF+paVzD3TpqZdAenE8G8Bnxt+RsTMDb9J
Xw781KMP7fr88c1/oqJVSGe/uIrn42Ykl7LX5GdKasFZ4yV6gIjSWkJ+J1G2
43Q3YY9Zm3eK2WbZ70e7km+tUeZE9PHamnDF3f5vZ3NovC3eSclMYBQzOfXI
4ckU4zulB2mJempO1C52KaRj7JJYLkGvk92p5jL1KUCO1yTwrsFIB7UZ6POY
inHJNhA3xGk9qMFBCO95evc5UmsUiuh/w6qiVfR+Uf2rZBSoZT2g5fqNk5jM
sW8SSbsI64/kbpgWI9o3s9NOs/s1ad4grV+AsnvbSPRNu1YZaXpVrmjMuLDp
owbR0l2g3wF9BXTuYFiPPjEt7gbtC3XbLeJL3KmdVD0l9gLtnb3ZtZez2cyg
OFBQlrSR4x65l0puOp0G5D4pueFwOJ/PXbm46LigM+hPIv43+tQ1C+QP/RZO
qxpFlx0Q0N6wu6UmbuxdW30FUnhKPwK6bWV6IKonqD2VcA17yqvXwMU36QOg
21awL4R+8WgMtoTeNzb7LCZ3BF1p+irI3NHje4fJdtxSb+bRG1vZxvrlrjGz
8mwkqCyDU9ygtXidELcn69bpyuFmqpSbrHjrkT0WenWaVsO+3Dc7oWDzK85D
a2tnIVvdkF6s6rWeHwFfnznyFHCroJGh2+ZQbub5rO921Jt59C7bv+fi/66P
ycWYarVLTM+EzUb3vnTvJMkPVZFDZ37TmZ8YuVi9Gx69oZp00MKfxJx69XcA
7v8toLGqKwLzR0DH1Y6bBCYurf6+zo6rK2vi2g7MLchZGCddE6IU6lb3O/sO
3B+k95cOV2JwBfQhqQtf2Nqi7Or/f7DeT/HTXao=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{297, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53722259]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25411],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->13109848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1", "[", 
  RowBox[{
   RowBox[{"2", "+", "I"}], ",", "2", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32905410],

Cell[BoxData[
 RowBox[{"1.6183312284015026`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.3792577715004695`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183796559]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132811654],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->751502790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Hypergeometric1F1", "[", 
    RowBox[{"10", ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"-", "1"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->524282076],

Cell[BoxData[
 RowBox[{"1.\
0856469662771144181060999200053894821341819655655417002263588031475`50.\
15051499783199", "+", 
  RowBox[{"0``50.11482637471883", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{447, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117680037]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3342846],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->267441545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1", "[", 
  RowBox[{"10", ",", 
   RowBox[{"1", "/", "3"}], ",", 
   RowBox[{"-", "1.000000000000000000000000000000000000"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->92732113],

Cell[BoxData["1.085646966277114418106099920005389482091474954198`33.\
96901264928785"], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25809649]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16832041],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric1F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric1F1"]], "InlineFormula"],
 " automatically evaluates to simpler functions for certain parameters:"
}], "ExampleText",
 CellID->74740598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "1", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->420147945],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"x", "/", "2"}]], " ", 
  RowBox[{"BesselI", "[", 
   RowBox[{"0", ",", 
    FractionBox["x", "2"]}], "]"}]}]], "Output",
 ImageSize->{122, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->265499815]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1", "[", 
  RowBox[{"2", ",", "1", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->153313181],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", "x"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66776222]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1", "[", 
  RowBox[{"1", ",", 
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->66390113],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], " ", 
   SqrtBox["\[Pi]"], " ", 
   SqrtBox["x"], " ", 
   RowBox[{"Erf", "[", 
    SqrtBox["x"], "]"}]}]}]], "Output",
 ImageSize->{153, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->34829438]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47939284],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric1F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric1F1"]], "InlineFormula"],
 " threads element-wise over list arguments and parameters:"
}], "ExampleText",
 CellID->917636806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}], ",", "5.0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->173298581],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "29.48263182051532`", ",", "11.39305272820613`", ",", 
   "6.2358316369236775`"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212517767]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->166305613],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->55294528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hypergeometric1F1", "[", 
   RowBox[{"a", ",", "b", ",", "x"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119842281],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVVNsOgyAMRRHELJuve/Qz/ILtaR9hzBL3sGxx/j+jeKGWTjMSoOXSc06p
3pqhuz+b4dE21bVv3t2j/VSXV++WZCKEqF0vz8LZ1lm+19bCnI3T2ArnSDcr
WATD+hb5BfFz4qc+aLpzS+5E2UNJWBQwNccH+yBWBuWwn07JwLM/koV74wok
FLARvlrOTEHZjCgcaeZhIgysW/zG3NCXcfsrDHpDsyroC6R/MRFzeW0yoVWg
N/PBs8BvCYgZedNYGacfVwWMxoYqWOPlEUfDcJQMDq6oUHv0hGeiFiaY8+5X
ciR+GbE3bEZoXBqH+iETmtF/mFScmLy431E0iuQLuB5auA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->670395410]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8957],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["Hypergeometric1F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric1F1"]], "InlineFormula"],
 " to a power series:"
}], "ExampleText",
 CellID->800720049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1", "[", 
  RowBox[{
   RowBox[{"1", "/", "7"}], ",", 
   RowBox[{"3", "/", "7"}], ",", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "z"}], "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "z", "]"}], "^", "5"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90598217],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox["z", "3"], "-", 
   FractionBox[
    SuperscriptBox["z", "2"], "30"], "+", 
   FractionBox[
    RowBox[{"13", " ", 
     SuperscriptBox["z", "3"]}], "765"], "-", 
   FractionBox[
    RowBox[{"67", " ", 
     SuperscriptBox["z", "4"]}], "6120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "5"],
    SeriesData[$CellContext`z, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {1, 
    Rational[1, 3], 
    Rational[-1, 30], 
    Rational[13, 765], 
    Rational[-67, 6120]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{205, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202306004]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71413963],

Cell[TextData[{
 "Expand ",
 Cell[BoxData[
  ButtonBox["Hypergeometric1F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric1F1"]], "InlineFormula"],
 " in a series around infinity:"
}], "ExampleText",
 CellID->377328237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Hypergeometric1F1", "[", 
    RowBox[{
     RowBox[{"1", "/", "7"}], ",", 
     RowBox[{"3", "/", "7"}], ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126076502],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "z"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"Gamma", "[", 
         FractionBox["3", "7"], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "z"], ")"}], 
         RowBox[{"2", "/", "7"}]]}], 
       RowBox[{"Gamma", "[", 
        FractionBox["1", "7"], "]"}]], "+", 
      FractionBox[
       RowBox[{"12", " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["3", "7"], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "z"], ")"}], 
         RowBox[{"9", "/", "7"}]]}], 
       RowBox[{"49", " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["1", "7"], "]"}]}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "z"], "]"}], 
        RowBox[{"15", "/", "7"}]],
       SeriesData[$CellContext`z, 
        DirectedInfinity[1], {}, 2, 15, 7],
       Editable->False]}],
     SeriesData[$CellContext`z, 
      DirectedInfinity[1], {Gamma[
          Rational[1, 7]]^(-1) Gamma[
         Rational[3, 7]], 0, 0, 0, 0, 0, 0, Rational[12, 49] Gamma[
          Rational[1, 7]]^(-1) Gamma[
         Rational[3, 7]]}, 2, 15, 7],
     Editable->False], ")"}]}], "+", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"6", "/", "7"}]], " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["3", "7"], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "z"], ")"}], 
         RowBox[{"1", "/", "7"}]]}], 
       RowBox[{"Gamma", "[", 
        FractionBox["2", "7"], "]"}]]}], "+", 
     FractionBox[
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"6", "/", "7"}]], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["3", "7"], "]"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "z"], ")"}], 
        RowBox[{"8", "/", "7"}]]}], 
      RowBox[{"49", " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["2", "7"], "]"}]}]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "z"], "]"}], 
       RowBox[{"15", "/", "7"}]],
      SeriesData[$CellContext`z, 
       DirectedInfinity[1], {}, 1, 15, 7],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     DirectedInfinity[1], {-(-1)^Rational[6, 7] Gamma[
         Rational[2, 7]]^(-1) Gamma[
        Rational[3, 7]], 0, 0, 0, 0, 0, 0, 
      Rational[5, 49] (-1)^Rational[6, 7] Gamma[
         Rational[2, 7]]^(-1) Gamma[
        Rational[3, 7]]}, 1, 15, 7],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{427, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54588368]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24407],

Cell["Solve the confluent hypergeometric differential equation:", \
"ExampleText",
 CellID->535048042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"z", " ", 
       RowBox[{
        SuperscriptBox["w", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"b", "-", "z"}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["w", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "-", 
      RowBox[{"a", " ", 
       RowBox[{"w", "[", "z", "]"}]}]}], "\[Equal]", "0"}], ",", 
    RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540869044],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{
         RowBox[{"-", "a"}], "+", "b"}], "]"}], " ", 
       RowBox[{"Hypergeometric1F1", "[", 
        RowBox[{"a", ",", "b", ",", "z"}], "]"}]}], 
      RowBox[{
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "-", "a"}], "]"}], " ", 
       RowBox[{"Gamma", "[", "b", "]"}]}]], "+", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"HypergeometricU", "[", 
       RowBox[{"a", ",", "b", ",", "z"}], "]"}]}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{580, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->461206471]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1984234],

Cell["Hydrogen atom radial wave function for continuous spectrum:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->233200486],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"\[ScriptCapitalE]_", ",", "l_", ",", "r_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"k", "=", 
      RowBox[{"Sqrt", "[", "\[ScriptCapitalE]", "]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "I"}], " ", "k", " ", "r"}], "]"}], 
     RowBox[{"r", "^", "l"}], " ", 
     RowBox[{"Hypergeometric1F1", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"I", "/", "k"}], "+", 
        RowBox[{"(", 
         RowBox[{"1", "+", "l"}], ")"}]}], ",", 
       RowBox[{"2", "+", 
        RowBox[{"2", " ", "l"}]}], ",", 
       RowBox[{"2", " ", "I", " ", "r", " ", "k"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35125489],

Cell["\<\
Compute the energy eigenvalue from the differential equation:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->48853258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"D", "[", 
           RowBox[{"#", ",", "r", ",", "r"}], "]"}], "#"], "+", 
         RowBox[{
          FractionBox["2", 
           RowBox[{"r", " ", "#"}]], 
          RowBox[{"D", "[", 
           RowBox[{"#", ",", "r"}], "]"}]}], "-", 
         FractionBox[
          RowBox[{"l", 
           RowBox[{"(", 
            RowBox[{"l", "+", "1"}], ")"}]}], 
          SuperscriptBox["r", "2"]], "+", 
         FractionBox["2", "r"]}], ")"}]}], "&"}], "[", 
     RowBox[{"\[Psi]", "[", 
      RowBox[{"\[ScriptCapitalE]", ",", "l", ",", "r"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", "0", ",", "5"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->287936358],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[ScriptCapitalE]", "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "r", "]"}], "6"],
    SeriesData[$CellContext`r, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`r, 0, {$CellContext`\[ScriptCapitalE]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->196658879]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->283418759],

Cell[TextData[{
 "Closed form for Pad\[EAcute] approximation of ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " to any order:"
}], "ExampleText",
 CellID->484628655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{"-", "i"}], ",", 
      RowBox[{
       RowBox[{"-", "i"}], "-", "j"}], ",", "z"}], "]"}], 
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{"-", "j"}], ",", 
      RowBox[{
       RowBox[{"-", "i"}], "-", "j"}], ",", 
      RowBox[{"-", "z"}]}], "]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21904899473679702393,5",
 CellLabel->"In[1]:=",
 CellID->1169495805],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", 
       FractionBox["z", "2"]}], 
      RowBox[{"1", "-", 
       FractionBox["z", "2"]}]], ",", 
     FractionBox[
      RowBox[{"1", "+", 
       FractionBox["z", "3"]}], 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"2", " ", "z"}], "3"], "+", 
       FractionBox[
        SuperscriptBox["z", "2"], "6"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", 
       FractionBox[
        RowBox[{"2", " ", "z"}], "3"], "+", 
       FractionBox[
        SuperscriptBox["z", "2"], "6"]}], 
      RowBox[{"1", "-", 
       FractionBox["z", "3"]}]], ",", 
     FractionBox[
      RowBox[{"1", "+", 
       FractionBox["z", "2"], "+", 
       FractionBox[
        SuperscriptBox["z", "2"], "12"]}], 
      RowBox[{"1", "-", 
       FractionBox["z", "2"], "+", 
       FractionBox[
        SuperscriptBox["z", "2"], "12"]}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{309, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21904899473679702393,5",
 CellLabel->"Out[1]=",
 CellID->251266365]
}, Open  ]],

Cell["Compare with explicit approximants:", "ExampleText",
 CellID->525629217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"PadeApproximant", "[", 
    RowBox[{
     RowBox[{"Exp", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "j"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21904899473679702393,5",
 CellLabel->"In[2]:=",
 CellID->841455900],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", 
       FractionBox["z", "2"]}], 
      RowBox[{"1", "-", 
       FractionBox["z", "2"]}]], ",", 
     FractionBox[
      RowBox[{"1", "+", 
       FractionBox["z", "3"]}], 
      RowBox[{"1", "-", 
       FractionBox[
        RowBox[{"2", " ", "z"}], "3"], "+", 
       FractionBox[
        SuperscriptBox["z", "2"], "6"]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", 
       FractionBox[
        RowBox[{"2", " ", "z"}], "3"], "+", 
       FractionBox[
        SuperscriptBox["z", "2"], "6"]}], 
      RowBox[{"1", "-", 
       FractionBox["z", "3"]}]], ",", 
     FractionBox[
      RowBox[{"1", "+", 
       FractionBox["z", "2"], "+", 
       FractionBox[
        SuperscriptBox["z", "2"], "12"]}], 
      RowBox[{"1", "-", 
       FractionBox["z", "2"], "+", 
       FractionBox[
        SuperscriptBox["z", "2"], "12"]}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{309, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21904899473679702393,5",
 CellLabel->"Out[2]=",
 CellID->180951251]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->227],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " may give results involving ",
 Cell[BoxData[
  ButtonBox["Hypergeometric1F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric1F1"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->82518600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["t", "a"], "  ", 
    FractionBox[
     RowBox[{"Exp", "[", 
      RowBox[{"-", "t"}], "]"}], 
     SqrtBox[
      RowBox[{"1", "+", "t"}]]]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"a", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->814711375],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{
     FractionBox["1", "2"], "+", "a"}], "]"}], " ", 
   RowBox[{"Hypergeometric1F1", "[", 
    RowBox[{
     FractionBox["1", "2"], ",", 
     RowBox[{
      FractionBox["1", "2"], "-", "a"}], ",", "1"}], "]"}]}], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Gamma", "[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], "-", "a"}], "]"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "a"}], "]"}], " ", 
    RowBox[{"Hypergeometric1F1", "[", 
     RowBox[{
      RowBox[{"1", "+", "a"}], ",", 
      RowBox[{
       FractionBox["3", "2"], "+", "a"}], ",", "1"}], "]"}]}], 
   SqrtBox["\[Pi]"]]}]], "Output",
 ImageSize->{402, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47911319]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->381335416],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to convert confluent hypergeometric functions:"
}], "ExampleText",
 CellID->1633786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"WhittakerM", "[", 
   RowBox[{"m", ",", "k", ",", "x"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->84972935],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "x"}], "/", "2"}]], " ", 
  SuperscriptBox["x", 
   RowBox[{
    FractionBox["1", "2"], "+", "k"}]], " ", 
  RowBox[{"Hypergeometric1F1", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "+", "k", "-", "m"}], ",", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "k"}]}], ",", "x"}], "]"}]}]], "Output",
 ImageSize->{314, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388500558]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25106],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HypergeometricU",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HypergeometricU"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypergeometric2F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric2F1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HypergeometricPFQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HypergeometricPFQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypergeometric1F1Regularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric1F1Regularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WhittakerM",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WhittakerM"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pochhammer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pochhammer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gamma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GammaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpIntegralE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpIntegralE"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9265]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9365],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->26756]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->7184],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/\n\
ConfluentHypergeometricFunctionoftheFirstKind.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/HypergeometricFunctions/\n\
Hypergeometric1F1/"], None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Hypergeometric1F1"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->514403173],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->571085424],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->30574473],

Cell[TextData[ButtonBox["Hypergeometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HypergeometricFunctions"]], "MoreAbout",
 CellID->19160411]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hypergeometric1F1 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 55.8978930}", "context" -> "System`", 
    "keywords" -> {
     "1F1", "Bateman functions", "confluent hypergeometric function", 
      "Coulomb wave function", "Cunningham function", "hypergeometric 1F1", 
      "hypergeometric functions", "Kummer function", 
      "parabolic cylinder functions", "Poisson-Charlier polynomials", 
      "Whittaker functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Hypergeometric1F1[a, b, z] is the Kummer confluent hypergeometric \
function \\[Null]_1F_1 (a; b; z). ", "synonyms" -> {"hypergeometric 1f1"}, 
    "title" -> "Hypergeometric1F1", "type" -> "Symbol", "uri" -> 
    "ref/Hypergeometric1F1"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6942, 218, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->22254638]},
 "Ex--21904899473679702393,5"->{
  Cell[30731, 1054, 626, 21, 70, "Input",
   CellTags->"Ex--21904899473679702393,5",
   CellID->1169495805],
  Cell[31360, 1077, 1187, 42, 74, "Output",
   CellTags->"Ex--21904899473679702393,5",
   CellID->251266365],
  Cell[32665, 1127, 494, 16, 70, "Input",
   CellTags->"Ex--21904899473679702393,5",
   CellID->841455900],
  Cell[33162, 1145, 1187, 42, 74, "Output",
   CellTags->"Ex--21904899473679702393,5",
   CellID->180951251]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 44050, 1535},
 {"Ex--21904899473679702393,5", 44202, 1539}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3161, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3784, 97, 54, 1, 70, "ObjectName",
 CellID->1864],
Cell[3841, 100, 847, 26, 70, "Usage",
 CellID->20566]
}, Open  ]],
Cell[CellGroupData[{
Cell[4725, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5203, 148, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5326, 154, 849, 31, 70, "Notes",
 CellID->27931],
Cell[6178, 187, 266, 8, 70, "Notes",
 CellID->399162356],
Cell[6447, 197, 236, 7, 70, "Notes",
 CellID->31226],
Cell[6686, 206, 219, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6942, 218, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->22254638],
Cell[CellGroupData[{
Cell[7326, 232, 146, 5, 70, "ExampleSection",
 CellID->1204557],
Cell[7475, 239, 64, 1, 70, "ExampleText",
 CellID->157333599],
Cell[CellGroupData[{
Cell[7564, 244, 147, 4, 28, "Input",
 CellID->23863280],
Cell[7714, 250, 175, 5, 36, "Output",
 CellID->457470148]
}, Open  ]],
Cell[7904, 258, 124, 3, 70, "ExampleDelimiter",
 CellID->74192982],
Cell[8031, 263, 1166, 44, 70, "ExampleText",
 CellID->786574672],
Cell[CellGroupData[{
Cell[9222, 311, 282, 9, 28, "Input",
 CellID->73705564],
Cell[9507, 322, 2559, 46, 173, "Output",
 Evaluatable->False,
 CellID->295469541]
}, Open  ]],
Cell[12081, 371, 124, 3, 70, "ExampleDelimiter",
 CellID->55216552],
Cell[12208, 376, 63, 1, 70, "ExampleText",
 CellID->44700959],
Cell[CellGroupData[{
Cell[12296, 381, 264, 8, 28, "Input",
 CellID->845624955],
Cell[12563, 391, 1288, 25, 56, "Output",
 Evaluatable->False,
 CellID->53722259]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13900, 422, 216, 7, 70, "ExampleSection",
 CellID->25411],
Cell[14119, 431, 88, 1, 70, "ExampleText",
 CellID->13109848],
Cell[CellGroupData[{
Cell[14232, 436, 171, 5, 70, "Input",
 CellID->32905410],
Cell[14406, 443, 273, 7, 36, "Output",
 CellID->183796559]
}, Open  ]],
Cell[14694, 453, 125, 3, 70, "ExampleDelimiter",
 CellID->132811654],
Cell[14822, 458, 70, 1, 70, "ExampleText",
 CellID->751502790],
Cell[CellGroupData[{
Cell[14917, 463, 249, 8, 70, "Input",
 CellID->524282076],
Cell[15169, 473, 325, 9, 36, "Output",
 CellID->117680037]
}, Open  ]],
Cell[15509, 485, 123, 3, 70, "ExampleDelimiter",
 CellID->3342846],
Cell[15635, 490, 113, 3, 70, "ExampleText",
 CellID->267441545],
Cell[CellGroupData[{
Cell[15773, 497, 228, 7, 70, "Input",
 CellID->92732113],
Cell[16004, 506, 227, 6, 36, "Output",
 CellID->25809649]
}, Open  ]],
Cell[16246, 515, 124, 3, 70, "ExampleDelimiter",
 CellID->16832041],
Cell[16373, 520, 263, 7, 70, "ExampleText",
 CellID->74740598],
Cell[CellGroupData[{
Cell[16661, 531, 170, 5, 70, "Input",
 CellID->420147945],
Cell[16834, 538, 324, 11, 49, "Output",
 CellID->265499815]
}, Open  ]],
Cell[CellGroupData[{
Cell[17195, 554, 146, 4, 70, "Input",
 CellID->153313181],
Cell[17344, 560, 264, 9, 36, "Output",
 CellID->66776222]
}, Open  ]],
Cell[CellGroupData[{
Cell[17645, 574, 169, 5, 70, "Input",
 CellID->66390113],
Cell[17817, 581, 337, 12, 43, "Output",
 CellID->34829438]
}, Open  ]],
Cell[18169, 596, 124, 3, 70, "ExampleDelimiter",
 CellID->47939284],
Cell[18296, 601, 252, 7, 70, "ExampleText",
 CellID->917636806],
Cell[CellGroupData[{
Cell[18573, 612, 207, 6, 70, "Input",
 CellID->173298581],
Cell[18783, 620, 273, 9, 36, "Output",
 CellID->212517767]
}, Open  ]],
Cell[19071, 632, 125, 3, 70, "ExampleDelimiter",
 CellID->166305613],
Cell[19199, 637, 202, 7, 70, "ExampleText",
 CellID->55294528],
Cell[CellGroupData[{
Cell[19426, 648, 188, 6, 70, "Input",
 CellID->119842281],
Cell[19617, 656, 581, 13, 70, "Output",
 Evaluatable->False,
 CellID->670395410]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20247, 675, 238, 7, 70, "ExampleSection",
 CellID->8957],
Cell[20488, 684, 225, 8, 70, "ExampleText",
 CellID->800720049],
Cell[CellGroupData[{
Cell[20738, 696, 331, 11, 70, "Input",
 CellID->90598217],
Cell[21072, 709, 778, 27, 54, "Output",
 CellID->202306004]
}, Open  ]],
Cell[21865, 739, 124, 3, 70, "ExampleDelimiter",
 CellID->71413963],
Cell[21992, 744, 236, 8, 70, "ExampleText",
 CellID->377328237],
Cell[CellGroupData[{
Cell[22253, 756, 323, 10, 70, "Input",
 CellID->126076502],
Cell[22579, 768, 3032, 96, 118, "Output",
 CellID->54588368]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25660, 870, 223, 7, 70, "ExampleSection",
 CellID->24407],
Cell[25886, 879, 102, 2, 70, "ExampleText",
 CellID->535048042],
Cell[CellGroupData[{
Cell[26013, 885, 661, 21, 70, "Input",
 CellID->540869044],
Cell[26677, 908, 836, 27, 53, "Output",
 CellID->461206471]
}, Open  ]],
Cell[27528, 938, 123, 3, 70, "ExampleDelimiter",
 CellID->1984234],
Cell[27654, 943, 241, 6, 70, "ExampleText",
 CellID->233200486],
Cell[27898, 951, 793, 25, 70, "Input",
 CellID->35125489],
Cell[28694, 978, 248, 7, 70, "ExampleText",
 CellID->48853258],
Cell[CellGroupData[{
Cell[28967, 989, 899, 29, 70, "Input",
 CellID->287936358],
Cell[29869, 1020, 462, 14, 36, "Output",
 CellID->196658879]
}, Open  ]],
Cell[30346, 1037, 125, 3, 70, "ExampleDelimiter",
 CellID->283418759],
Cell[30474, 1042, 232, 8, 70, "ExampleText",
 CellID->484628655],
Cell[CellGroupData[{
Cell[30731, 1054, 626, 21, 70, "Input",
 CellTags->"Ex--21904899473679702393,5",
 CellID->1169495805],
Cell[31360, 1077, 1187, 42, 74, "Output",
 CellTags->"Ex--21904899473679702393,5",
 CellID->251266365]
}, Open  ]],
Cell[32562, 1122, 78, 1, 70, "ExampleText",
 CellID->525629217],
Cell[CellGroupData[{
Cell[32665, 1127, 494, 16, 70, "Input",
 CellTags->"Ex--21904899473679702393,5",
 CellID->841455900],
Cell[33162, 1145, 1187, 42, 74, "Output",
 CellTags->"Ex--21904899473679702393,5",
 CellID->180951251]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34398, 1193, 231, 7, 70, "ExampleSection",
 CellID->227],
Cell[34632, 1202, 349, 12, 70, "ExampleText",
 CellID->82518600],
Cell[CellGroupData[{
Cell[35006, 1218, 440, 15, 70, "Input",
 CellID->814711375],
Cell[35449, 1235, 842, 29, 93, "Output",
 CellID->47911319]
}, Open  ]],
Cell[36306, 1267, 125, 3, 70, "ExampleDelimiter",
 CellID->381335416],
Cell[36434, 1272, 243, 8, 70, "ExampleText",
 CellID->1633786],
Cell[CellGroupData[{
Cell[36702, 1284, 179, 6, 70, "Input",
 CellID->84972935],
Cell[36884, 1292, 532, 18, 52, "Output",
 CellID->388500558]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37477, 1317, 311, 9, 70, "SeeAlsoSection",
 CellID->25106],
Cell[37791, 1328, 2281, 80, 70, "SeeAlso",
 CellID->9265]
}, Open  ]],
Cell[CellGroupData[{
Cell[40109, 1413, 313, 9, 70, "TutorialsSection",
 CellID->9365],
Cell[40425, 1424, 144, 3, 70, "Tutorials",
 CellID->26756]
}, Open  ]],
Cell[CellGroupData[{
Cell[40606, 1432, 320, 9, 70, "RelatedLinksSection",
 CellID->7184],
Cell[40929, 1443, 220, 5, 70, "RelatedLinks"],
Cell[41152, 1450, 213, 4, 70, "RelatedLinks"],
Cell[41368, 1456, 395, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41800, 1474, 319, 9, 70, "MoreAboutSection",
 CellID->514403173],
Cell[42122, 1485, 178, 3, 70, "MoreAbout",
 CellID->571085424],
Cell[42303, 1490, 164, 3, 70, "MoreAbout",
 CellID->30574473],
Cell[42470, 1495, 158, 3, 70, "MoreAbout",
 CellID->19160411]
}, Open  ]],
Cell[42643, 1501, 27, 0, 70, "History"],
Cell[42673, 1503, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

