(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33536,       1225]
NotebookOptionsPosition[     26939,       1000]
NotebookOutlinePosition[     28398,       1039]
CellTagsIndexPosition[     28312,       1034]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HypergeometricPFQ" :> 
          Documentation`HelpLookup["paclet:ref/HypergeometricPFQ"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"HypergeometricPFQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypergeometric Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/HypergeometricFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Hypergeometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HypergeometricPFQRegularized", "ObjectName",
 CellID->13599],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HypergeometricPFQRegularized",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HypergeometricPFQRegularized"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["p", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["q", "TI"]]}], "}"}], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the regularized generalized hypergeometric function \
",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         SubscriptBox["\[Null]", "p"], "\[InvisibleSpace]", 
         SubscriptBox["F", "q"], "(", 
         RowBox[{"a", ";", "b", ";", "z"}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"\[CapitalGamma]", "(", 
          RowBox[{
           SubscriptBox["b", "1"], ")"}], "\[Ellipsis]", 
          RowBox[{"\[CapitalGamma]", "(", 
           SubscriptBox["b", "q"]}], ")"}], ")"}]}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->137]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HypergeometricPFQRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQRegularized"]], "InlineFormula"],
 " is finite for all finite values of its arguments so long as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "\[LessEqual]", "q"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->28728],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["HypergeometricPFQRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQRegularized"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->408475707],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HypergeometricPFQRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQRegularized"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->316474381],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->245722486],

Cell["Evaluate numerically:", "ExampleText",
 CellID->889008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQRegularized", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36498888],

Cell[BoxData["15.062110268295823`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->533516428]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->631276111],

Cell["Evaluate symbolically:", "ExampleText",
 CellID->554700884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQRegularized", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6225217],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"9", " ", 
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"128", "+", 
      RowBox[{"768", " ", "x"}], "+", 
      RowBox[{"288", " ", 
       SuperscriptBox["x", "2"]}], "-", 
      RowBox[{"32", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "4"]}]}], ")"}]}], 
   RowBox[{"128", " ", 
    SqrtBox[
     RowBox[{"1", "-", "x"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], "6"]}]]}]], "Output",
 ImageSize->{247, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->439657164]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67993],

Cell["Series expansion at the origin:", "ExampleText",
 CellID->310743244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HypergeometricPFQRegularized", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", "x"}], "]"}], "+", 
  RowBox[{
   RowBox[{"O", "[", "x", "]"}], "^", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77677133],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"Gamma", "[", "c", "]"}], " ", 
     RowBox[{"Gamma", "[", "d", "]"}]}]], "+", 
   FractionBox[
    RowBox[{"a", " ", "b", " ", "x"}], 
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "c"}], "]"}], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "d"}], "]"}]}]], "+", 
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "a"}], ")"}], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "b"}], ")"}], " ", 
     SuperscriptBox["x", "2"]}], 
    RowBox[{"2", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"2", "+", "c"}], "]"}], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"2", "+", "d"}], "]"}]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"],
    SeriesData[$CellContext`x, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   Gamma[$CellContext`c]^(-1)/
    Gamma[$CellContext`d], $CellContext`a $CellContext`b 
    Gamma[1 + $CellContext`c]^(-1)/Gamma[1 + $CellContext`d], 
    Rational[1, 2] $CellContext`a (1 + $CellContext`a) $CellContext`b (
     1 + $CellContext`b) Gamma[2 + $CellContext`c]^(-1)/Gamma[
    2 + $CellContext`d]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{522, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262138747]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29559],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->334604611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQRegularized", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "I"}], ",", "I", ",", "I"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"0.5", "-", 
    RowBox[{"I", "/", "3"}]}]}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->700643707],

Cell[BoxData[
 RowBox[{"130.55842307544165`", "\[InvisibleSpace]", "-", 
  RowBox[{"1000.6611106228994`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46049711]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->340023748],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->408366865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"HypergeometricPFQRegularized", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "+", "I"}], ",", "I", ",", "I"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", "2"}], "]"}], ",", "30"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25741616],

Cell[BoxData[
 RowBox[{"1.158883156991163856827898123711038157747275437`30.146958381094283*^\
7", "-", 
  RowBox[{
  "1.48922995322853554858225460825717432670945695`29.255880492845524*^6", " ",
    "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{531, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212175379]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->251886520],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->706656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQRegularized", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "I"}], ",", "I", ",", "I"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", "2.00000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->262549215],

Cell[BoxData[
 RowBox[{"1.15888315699115556241814533`13.86694635575132*^7", "-", 
  RowBox[{
  "1.4892299532284266451754966`12.975872639399126*^6", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{293, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156110505]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->87423458],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HypergeometricPFQRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQRegularized"]], "InlineFormula"],
 " evaluates to simpler functions for certain parameters:"
}], "ExampleText",
 CellID->161265628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQRegularized", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->542064829],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", "z"], " ", 
  SuperscriptBox["z", "3"], " ", 
  RowBox[{"(", 
   RowBox[{"96", "+", 
    RowBox[{"504", " ", "z"}], "+", 
    RowBox[{"528", " ", 
     SuperscriptBox["z", "2"]}], "+", 
    RowBox[{"184", " ", 
     SuperscriptBox["z", "3"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["z", "4"]}], "+", 
    SuperscriptBox["z", "5"]}], ")"}]}]], "Output",
 ImageSize->{273, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->366019423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->384533180],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HypergeometricPFQRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQRegularized"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists in its third argument:"
}], "ExampleText",
 CellID->17939029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQRegularized", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1", ",", " ", "0.3", ",", " ", "0.5"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->395261281],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.878653833298633`*^-7", ",", "4.997426920137476`*^-7", ",", 
   "5.126155211963009`*^-7"}], "}"}]], "Output",
 ImageSize->{295, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137484919]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->279227404],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->62129516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HypergeometricPFQRegularized", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["a", "1"], ",", 
      SubscriptBox["a", "2"], ",", 
      SubscriptBox["a", "3"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["b", "1"], ",", 
      SubscriptBox["b", "2"]}], "}"}], ",", "z"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127944837],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyNVctuwjAQdOw0IQkSoLZSj/xE1T9oT/2ICFWCAwJRjvx76nU2ibM7mCIl
9m7G49mHzXd73f8c2+th126/Lu15f9j9bj9PF+9ymTHm5p/Nm/Hzzs/Cc+s6
Pzo/rf0s9+MTecjRhV+wyTQuQMltGsZaga0Z64S/Yj/CI56FsG2vMoEigbn4
Xgb5o82opVglWZdwVYMUiUhSrDKiTEVEq6x/ygc72agWaCfLNYS4PI7rHlLm
0bJvwGuWIvk15yrTFtSGFHsffyoOXD0b7YDVlgohO1ojHCtdzPUDdo2Q7IVC
6LhVTRFHMnasrlSIVOyYA+8N+1mhoJ7I1pkIvKXgifdUmQQepaNKsMpc4z6D
WdE7izvOFDGif//nbhM5EWdmOEN3OkKc1FoptczRzDlYoeN82THsATCswV/Q
jTePQ/daBWInc8XjmkfUN/MTu1IeuSbvpv8ioOvO3U3TD2Gvhf2qGPFpkJV+
xPss7EltAXL3znXY8PgCcuv/8id9s2ydR398+9P7FK3r3yb7A98+FFo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{124, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->54218114]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28630],

Cell[TextData[{
 "Find a fractional derivative of ",
 Cell[BoxData[
  ButtonBox["BesselJ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BesselJ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->731491295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalD]", "[", 
   RowBox[{"n_", ",", "z_", ",", "m_"}], "]"}], "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "t"}], ")"}], 
      RowBox[{
       RowBox[{"-", "m"}], "-", "1"}]], " ", 
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"n", ",", "t"}], "]"}], "/", 
      RowBox[{"Gamma", "[", 
       RowBox[{"-", "m"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "z"}], "}"}], ",", 
    RowBox[{"GenerateConditions", "->", "False"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1923565638],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{"m", "-", 
    RowBox[{"2", " ", "n"}]}]], " ", 
  SqrtBox["\[Pi]"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox["1", "z"], ")"}], 
   RowBox[{"-", "n"}]], " ", 
  SuperscriptBox["z", 
   RowBox[{"-", "m"}]], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "n"}], "]"}], " ", 
  RowBox[{"HypergeometricPFQRegularized", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", "n"}], "2"], ",", 
      FractionBox[
       RowBox[{"2", "+", "n"}], "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "m", "+", "n"}], ")"}]}], ",", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", "m", "+", "n"}], ")"}]}], ",", 
      RowBox[{"1", "+", "n"}]}], "}"}], ",", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["z", "2"], "4"]}]}], "]"}]}]], "Output",
 ImageSize->{567, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->282048926]
}, Open  ]],

Cell[TextData[{
 "Integral of order ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "2"}], TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BesselJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselJ"], "[", 
   RowBox[{"0", ",", "z"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->235848200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalD]", "[", 
   RowBox[{"0", ",", "z", ",", 
    RowBox[{"-", 
     FractionBox["1", "2"]}]}], "]"}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->616599796],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  SqrtBox["z"], " ", 
  RowBox[{"BesselJ", "[", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], ",", 
    FractionBox["z", "2"]}], "]"}], " ", 
  RowBox[{"BesselJ", "[", 
   RowBox[{
    FractionBox["1", "4"], ",", 
    FractionBox["z", "2"]}], "]"}]}]], "Output",
 ImageSize->{270, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75515620]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2676],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to express the input in terms of simpler functions:"
}], "ExampleText",
 CellID->288523338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", " ", 
  RowBox[{"HypergeometricPFQRegularized", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "3"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "/", "3"}], ",", 
      RowBox[{"-", "1"}]}], "}"}], ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6225398],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"z", "/", "2"}]], " ", 
    SuperscriptBox["z", 
     RowBox[{"13", "/", "6"}]], " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"3", " ", "z"}]}], ")"}], " ", 
    RowBox[{"BesselI", "[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "6"]}], ",", 
      FractionBox["z", "2"]}], "]"}], " ", 
    RowBox[{"Gamma", "[", 
     FractionBox["5", "6"], "]"}]}], 
   RowBox[{"9", " ", 
    SuperscriptBox["2", 
     RowBox[{"1", "/", "3"}]], " ", 
    RowBox[{"Gamma", "[", 
     FractionBox["5", "3"], "]"}]}]], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"z", "/", "2"}]], " ", 
    SuperscriptBox["z", 
     RowBox[{"13", "/", "6"}]], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"3", " ", "z"}]}], ")"}], " ", 
    RowBox[{"BesselI", "[", 
     RowBox[{
      FractionBox["5", "6"], ",", 
      FractionBox["z", "2"]}], "]"}], " ", 
    RowBox[{"Gamma", "[", 
     FractionBox["5", "6"], "]"}]}], 
   RowBox[{"9", " ", 
    SuperscriptBox["2", 
     RowBox[{"1", "/", "3"}]], " ", 
    RowBox[{"Gamma", "[", 
     FractionBox["5", "3"], "]"}]}]]}]], "Output",
 ImageSize->{565, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18344283]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->122026929],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " may return results involving ",
 Cell[BoxData[
  ButtonBox["HypergeometricPFQRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQRegularized"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->43573482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", " ", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"BesselJ", "[", 
     RowBox[{"n", ",", "x"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188199709],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{
    RowBox[{"-", "1"}], "-", "n"}]], " ", 
  SuperscriptBox["x", 
   RowBox[{"2", "+", "n"}]], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", 
    FractionBox["n", "2"]}], "]"}], " ", 
  RowBox[{"HypergeometricPFQRegularized", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", "+", 
      FractionBox["n", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "+", "n"}], ",", 
      RowBox[{"2", "+", 
       FractionBox["n", "2"]}]}], "}"}], ",", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["x", "2"], "4"]}]}], "]"}]}]], "Output",
 ImageSize->{527, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73276451]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14658],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->24084]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15812],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->31831]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->11684],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/index.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/HypergeometricFunctions/\
Hypergeometric0F1Regularized/"], None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->505780049],

Cell[TextData[ButtonBox["Hypergeometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HypergeometricFunctions"]], "MoreAbout",
 CellID->610465044]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HypergeometricPFQRegularized - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 59.6479890}", "context" -> "System`", 
    "keywords" -> {"regularized hypergeometric function"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "HypergeometricPFQRegularized[{a_1, ..., a_p}, {b_1, ..., b_q}, z] is the \
regularized generalized hypergeometric function \\[Null]_pF_q (a; b; \
z)/(\\[CapitalGamma](b_1) ... \\[CapitalGamma](b_q)). ", 
    "synonyms" -> {"hypergeometric regularized"}, "title" -> 
    "HypergeometricPFQRegularized", "type" -> "Symbol", "uri" -> 
    "ref/HypergeometricPFQRegularized"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5715, 190, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->316474381]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28169, 1027}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1777, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2400, 74, 66, 1, 70, "ObjectName",
 CellID->13599],
Cell[2469, 77, 1645, 50, 70, "Usage",
 CellID->137]
}, Open  ]],
Cell[CellGroupData[{
Cell[4151, 132, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4629, 149, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4752, 155, 374, 11, 70, "Notes",
 CellID->28728],
Cell[5129, 168, 288, 8, 70, "Notes",
 CellID->408475707],
Cell[5420, 178, 258, 7, 70, "Notes",
 CellID->31226]
}, Closed]],
Cell[CellGroupData[{
Cell[5715, 190, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->316474381],
Cell[CellGroupData[{
Cell[6100, 204, 148, 5, 70, "ExampleSection",
 CellID->245722486],
Cell[6251, 211, 61, 1, 70, "ExampleText",
 CellID->889008],
Cell[CellGroupData[{
Cell[6337, 216, 386, 13, 28, "Input",
 CellID->36498888],
Cell[6726, 231, 176, 5, 36, "Output",
 CellID->533516428]
}, Open  ]],
Cell[6917, 239, 125, 3, 70, "ExampleDelimiter",
 CellID->631276111],
Cell[7045, 244, 65, 1, 70, "ExampleText",
 CellID->554700884],
Cell[CellGroupData[{
Cell[7135, 249, 353, 12, 70, "Input",
 CellID->6225217],
Cell[7491, 263, 718, 25, 61, "Output",
 CellID->439657164]
}, Open  ]],
Cell[8224, 291, 121, 3, 70, "ExampleDelimiter",
 CellID->67993],
Cell[8348, 296, 74, 1, 70, "ExampleText",
 CellID->310743244],
Cell[CellGroupData[{
Cell[8447, 301, 334, 11, 70, "Input",
 CellID->77677133],
Cell[8784, 314, 1440, 43, 56, "Output",
 CellID->262138747]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10273, 363, 216, 7, 70, "ExampleSection",
 CellID->29559],
Cell[10492, 372, 89, 1, 70, "ExampleText",
 CellID->334604611],
Cell[CellGroupData[{
Cell[10606, 377, 389, 13, 70, "Input",
 CellID->700643707],
Cell[10998, 392, 272, 7, 36, "Output",
 CellID->46049711]
}, Open  ]],
Cell[11285, 402, 125, 3, 70, "ExampleDelimiter",
 CellID->340023748],
Cell[11413, 407, 70, 1, 70, "ExampleText",
 CellID->408366865],
Cell[CellGroupData[{
Cell[11508, 412, 404, 14, 70, "Input",
 CellID->25741616],
Cell[11915, 428, 360, 10, 36, "Output",
 CellID->212175379]
}, Open  ]],
Cell[12290, 441, 125, 3, 70, "ExampleDelimiter",
 CellID->251886520],
Cell[12418, 446, 110, 3, 70, "ExampleText",
 CellID->706656],
Cell[CellGroupData[{
Cell[12553, 453, 357, 12, 70, "Input",
 CellID->262549215],
Cell[12913, 467, 319, 9, 36, "Output",
 CellID->156110505]
}, Open  ]],
Cell[13247, 479, 124, 3, 70, "ExampleDelimiter",
 CellID->87423458],
Cell[13374, 484, 272, 7, 70, "ExampleText",
 CellID->161265628],
Cell[CellGroupData[{
Cell[13671, 495, 302, 10, 70, "Input",
 CellID->542064829],
Cell[13976, 507, 555, 18, 39, "Output",
 CellID->366019423]
}, Open  ]],
Cell[14546, 528, 125, 3, 70, "ExampleDelimiter",
 CellID->384533180],
Cell[14674, 533, 279, 7, 70, "ExampleText",
 CellID->17939029],
Cell[CellGroupData[{
Cell[14978, 544, 363, 11, 70, "Input",
 CellID->395261281],
Cell[15344, 557, 284, 9, 39, "Output",
 CellID->137484919]
}, Open  ]],
Cell[15643, 569, 125, 3, 70, "ExampleDelimiter",
 CellID->279227404],
Cell[15771, 574, 202, 7, 70, "ExampleText",
 CellID->62129516],
Cell[CellGroupData[{
Cell[15998, 585, 441, 15, 70, "Input",
 CellID->127944837],
Cell[16442, 602, 772, 16, 70, "Output",
 Evaluatable->False,
 CellID->54218114]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17263, 624, 223, 7, 70, "ExampleSection",
 CellID->28630],
Cell[17489, 633, 213, 8, 70, "ExampleText",
 CellID->731491295],
Cell[CellGroupData[{
Cell[17727, 645, 660, 21, 70, "Input",
 CellID->1923565638],
Cell[18390, 668, 1145, 40, 84, "Output",
 CellID->282048926]
}, Open  ]],
Cell[19550, 711, 351, 14, 70, "ExampleText",
 CellID->235848200],
Cell[CellGroupData[{
Cell[19926, 729, 226, 7, 70, "Input",
 CellID->616599796],
Cell[20155, 738, 479, 18, 60, "Output",
 CellID->75515620]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20683, 762, 232, 7, 70, "ExampleSection",
 CellID->2676],
Cell[20918, 771, 250, 8, 70, "ExampleText",
 CellID->288523338],
Cell[CellGroupData[{
Cell[21193, 783, 403, 13, 70, "Input",
 CellID->6225398],
Cell[21599, 798, 1375, 47, 68, "Output",
 CellID->18344283]
}, Open  ]],
Cell[22989, 848, 125, 3, 70, "ExampleDelimiter",
 CellID->122026929],
Cell[23117, 853, 373, 12, 70, "ExampleText",
 CellID->43573482],
Cell[CellGroupData[{
Cell[23515, 869, 219, 7, 70, "Input",
 CellID->188199709],
Cell[23737, 878, 763, 27, 54, "Output",
 CellID->73276451]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24561, 912, 311, 9, 70, "SeeAlsoSection",
 CellID->14658],
Cell[24875, 923, 214, 6, 70, "SeeAlso",
 CellID->24084]
}, Open  ]],
Cell[CellGroupData[{
Cell[25126, 934, 314, 9, 70, "TutorialsSection",
 CellID->15812],
Cell[25443, 945, 144, 3, 70, "Tutorials",
 CellID->31831]
}, Open  ]],
Cell[CellGroupData[{
Cell[25624, 953, 321, 9, 70, "RelatedLinksSection",
 CellID->11684],
Cell[25948, 964, 176, 4, 70, "RelatedLinks"],
Cell[26127, 970, 222, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26386, 979, 319, 9, 70, "MoreAboutSection",
 CellID->505780049],
Cell[26708, 990, 159, 3, 70, "MoreAbout",
 CellID->610465044]
}, Open  ]],
Cell[26882, 996, 27, 0, 70, "History"],
Cell[26912, 998, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

