(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11623,        396]
NotebookOptionsPosition[      8734,        301]
NotebookOutlinePosition[     10050,        339]
CellTagsIndexPosition[      9966,        334]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Text and Font Options" :> 
          Documentation`HelpLookup["paclet:tutorial/TextAndFontOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Text and Font Options\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TextJustification" :> 
          Documentation`HelpLookup["paclet:ref/TextJustification"], 
          "LanguageCategory" :> 
          Documentation`HelpLookup["paclet:ref/LanguageCategory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TextJustification\"\>", 
       2->"\<\"LanguageCategory\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Font Options" :> 
          Documentation`HelpLookup["paclet:guide/FontOptions"], 
          "Text Layout Options" :> 
          Documentation`HelpLookup["paclet:guide/TextLayoutOptions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Font Options\"\>", 
       2->"\<\"Text Layout Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Hyphenation", "ObjectName",
 CellID->213],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Hyphenation",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Hyphenation"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether to allow hyphenation for words of text. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23594]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The choice of hyphenation points is based when possible on dictionaries and \
algorithms for the language in which the text is specified to be written. \
\>", "Notes",
 CellID->15707]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->273388844],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->194404724],

Cell["Make a cell with no automatic hyphenation:", "ExampleText",
 CellID->287868666],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<hyphenation \>\"", ",", 
       RowBox[{"{", "12", "}"}]}], "]"}], "]"}], ",", "\"\<Text\>\"", ",", 
    RowBox[{"Hyphenation", "\[Rule]", "False"}], ",", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"200", ",", "200"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "6"}], "}"}]}], "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->339836243],

Cell["\<\
hyphenation hyphenation hyphenation hyphenation hyphenation hyphenation \
hyphenation hyphenation hyphenation hyphenation hyphenation hyphenation \
\>", "Text",
 CellMargins->{{200, 200}, {6, 6}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 Hyphenation->False,
 CellID->131289233],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->87617150],

Cell["Make a cell with automatic hyphenation:", "ExampleText",
 CellID->15301220],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<hyphenation \>\"", ",", 
       RowBox[{"{", "12", "}"}]}], "]"}], "]"}], ",", "\"\<Text\>\"", ",", 
    RowBox[{"Hyphenation", "\[Rule]", "True"}], ",", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"200", ",", "200"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "6"}], "}"}]}], "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48551558],

Cell["\<\
hyphenation hyphenation hyphenation hyphenation hyphenation hyphenation \
hyphenation hyphenation hyphenation hyphenation hyphenation hyphenation \
\>", "Text",
 CellMargins->{{200, 200}, {6, 6}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 Hyphenation->True,
 CellID->740933515]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24508],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TextJustification",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextJustification"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LanguageCategory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LanguageCategory"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1802]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12075],

Cell[TextData[ButtonBox["Text and Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TextAndFontOptions"]], "Tutorials",
 CellID->3266]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->130152051],

Cell[TextData[ButtonBox["Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FontOptions"]], "MoreAbout",
 CellID->4265655],

Cell[TextData[ButtonBox["Text Layout Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextLayoutOptions"]], "MoreAbout",
 CellID->7156765]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hyphenation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 4.1793550}", "context" -> "System`", 
    "keywords" -> {
     "breaking of words", "words", "hyphenation", "word breaks", 
      "word splits"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Hyphenation is an option for Cell which specifies whether to allow \
hyphenation for words of text. ", "synonyms" -> {}, "title" -> "Hyphenation", 
    "type" -> "Symbol", "uri" -> "ref/Hyphenation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4038, 129, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->273388844]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9823, 327}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2013, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2636, 77, 47, 1, 70, "ObjectName",
 CellID->213],
Cell[2686, 80, 607, 18, 70, "Usage",
 CellID->23594]
}, Open  ]],
Cell[CellGroupData[{
Cell[3330, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3808, 120, 193, 4, 70, "Notes",
 CellID->15707]
}, Closed]],
Cell[CellGroupData[{
Cell[4038, 129, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->273388844],
Cell[CellGroupData[{
Cell[4423, 143, 148, 5, 70, "ExampleSection",
 CellID->194404724],
Cell[4574, 150, 85, 1, 70, "ExampleText",
 CellID->287868666],
Cell[4662, 153, 601, 17, 70, "Input",
 CellID->339836243],
Cell[5266, 172, 295, 8, 70, "Text",
 CellID->131289233],
Cell[5564, 182, 124, 3, 70, "ExampleDelimiter",
 CellID->87617150],
Cell[5691, 187, 81, 1, 70, "ExampleText",
 CellID->15301220],
Cell[5775, 190, 599, 17, 70, "Input",
 CellID->48551558],
Cell[6377, 209, 294, 8, 70, "Text",
 CellID->740933515]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6720, 223, 311, 9, 70, "SeeAlsoSection",
 CellID->24508],
Cell[7034, 234, 484, 17, 70, "SeeAlso",
 CellID->1802]
}, Open  ]],
Cell[CellGroupData[{
Cell[7555, 256, 314, 9, 70, "TutorialsSection",
 CellID->12075],
Cell[7872, 267, 149, 3, 70, "Tutorials",
 CellID->3266]
}, Open  ]],
Cell[CellGroupData[{
Cell[8058, 275, 319, 9, 70, "MoreAboutSection",
 CellID->130152051],
Cell[8380, 286, 133, 3, 70, "MoreAbout",
 CellID->4265655],
Cell[8516, 291, 146, 3, 70, "MoreAbout",
 CellID->7156765]
}, Open  ]],
Cell[8677, 297, 27, 0, 70, "History"],
Cell[8707, 299, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

