(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    315115,       6965]
NotebookOptionsPosition[    297269,       6336]
NotebookOutlinePosition[    298447,       6371]
CellTagsIndexPosition[    298360,       6366]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], "Complex Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/ComplexNumbers"], 
          "Mathematical Constants" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalConstants"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Complex Numbers\"\>", 
       3->"\<\"Mathematical Constants\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex" :> Documentation`HelpLookup["paclet:ref/Complex"], 
          "Re" :> Documentation`HelpLookup["paclet:ref/Re"], "Im" :> 
          Documentation`HelpLookup["paclet:ref/Im"], "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"], 
          "GaussianIntegers" :> 
          Documentation`HelpLookup["paclet:ref/GaussianIntegers"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Complex\"\>", 2->"\<\"Re\"\>", 
       3->"\<\"Im\"\>", 4->"\<\"ComplexExpand\"\>", 
       5->"\<\"GaussianIntegers\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex Numbers" :> 
          Documentation`HelpLookup["paclet:guide/ComplexNumbers"], 
          "Hyperbolic Functions" :> 
          Documentation`HelpLookup["paclet:guide/HyperbolicFunctions"], 
          "Mathematical Constants" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalConstants"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], 
          "Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Complex Numbers\"\>", 
       2->"\<\"Hyperbolic Functions\"\>", 3->"\<\"Mathematical Constants\"\>",
        4->"\<\"Mathematical Functions\"\>", 
       5->"\<\"Numerical Evaluation & Precision\"\>", 
       6->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "I ",
 StyleBox["(\[ImaginaryI])", "OperatorCharacter"]
}], "ObjectName",
 CellID->8130],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["I",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/I"]], "InlineFormula"],
     "\[LineSeparator]represents the imaginary unit ",
     Cell[BoxData[
      FormBox[
       SqrtBox[
        RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17230]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Numbers containing ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " are converted to the type ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7614],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " can be entered in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData["\[ImaginaryI]"], "InlineFormula"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ii\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[ImaginaryI]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ImaginaryI"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->26598],

Cell[TextData[{
 Cell[BoxData["\[ImaginaryJ]"], "InlineFormula"],
 ", ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]jj\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " and ",
 Cell[TextData[ButtonBox["\\[ImaginaryJ]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ImaginaryJ"]], "InlineCharacterName"],
 " can also be used. "
}], "Notes",
 CellID->17139],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " is output as ",
 Cell[BoxData["\[ImaginaryI]"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29546]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->733765935],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->82584308],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]ii\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " (for \"imaginary i\"):"
}], "ExampleText",
 CellID->203694883],

Cell[CellGroupData[{

Cell[BoxData["I"], "Input",
 CellLabel->"In[1]:=",
 CellID->594505050],

Cell[BoxData["\[ImaginaryI]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->294990976]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->226110433],

Cell["Generate from square roots of negative real numbers:", "ExampleText",
 CellID->289573092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"-", "16"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27551984],

Cell[BoxData[
 RowBox[{"4", " ", "\[ImaginaryI]"}]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166456580]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->515265040],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " in exact and approximate calculations:"
}], "ExampleText",
 CellID->7146610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"3", "+", "I"}], ")"}], "^", "2"}], "/", 
  RowBox[{"(", 
   RowBox[{"5", "-", "I"}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->326821536],

Cell[BoxData[
 RowBox[{
  FractionBox["17", "13"], "+", 
  FractionBox[
   RowBox[{"19", " ", "\[ImaginaryI]"}], "13"]}]], "Output",
 ImageSize->{64, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22445252]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{"3.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->126616372],

Cell[BoxData[
 RowBox[{"0.1454766053920648`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.8030960470021755`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48459055]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->370344466],

Cell["Built-in mathematical functions work with complex numbers:", \
"ExampleText",
 CellID->104436638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"4.5", "+", 
   RowBox[{"2", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->333644638],

Cell[BoxData[
 RowBox[{"1.594208308691746`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.4182243295792291`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41936508]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{
   RowBox[{"3", "-", "I"}], ",", 
   RowBox[{"66", "+", 
    RowBox[{"2", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->302849425],

Cell[BoxData[
 RowBox[{"1", "+", "\[ImaginaryI]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7848115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39826705],

Cell["Extract imaginary parts:", "ExampleText",
 CellID->232532372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Im", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"E", "+", 
     RowBox[{"I", " ", "Pi"}]}], ")"}], "^", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171982608],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", 
   SuperscriptBox["\[ExponentialE]", "2"], " ", "\[Pi]"}], "-", 
  SuperscriptBox["\[Pi]", "3"]}]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131561458]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->244045368],

Cell[TextData[{
 "Use ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]jj\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " to enter the engineering notation \[ImaginaryJ] for ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->23068299],

Cell[CellGroupData[{

Cell[BoxData["\[ImaginaryJ]"], "Input",
 CellLabel->"In[1]:=",
 CellID->95738320],

Cell[BoxData["\[ImaginaryI]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87910026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->578287121],

Cell["Use as a direction in infinite quantities:", "ExampleText",
 CellID->89310168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectedInfinity", "[", "I", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97219679],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox["\[ImaginaryI]",
    "DirectedInfinityCoefficient",
    Editable->True], " ", "\[Infinity]"}],
  DirectedInfinity,
  Editable->False]], "Output",
 ImageSize->{23, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->722330369]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"I", " ", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245497521],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->352726052]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56794946],

Cell[TextData[{
 "Use as a direction in ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->545837199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"I", "/", "x"}], "]"}], ",", 
   RowBox[{"x", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120224854],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33463274]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->271773706],

Cell["Use as generator of extension fields:", "ExampleText",
 CellID->474598974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->383858454],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->278151246]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "1"}], ",", 
   RowBox[{"Extension", "\[Rule]", 
    RowBox[{"{", "I", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->348619409],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->189970955]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194776517],

Cell["Factor integers over the Gaussians:", "ExampleText",
 CellID->1888187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{
   RowBox[{"Prime", "[", "100", "]"}], ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4223473],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"10", "+", 
      RowBox[{"21", " ", "\[ImaginaryI]"}]}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"21", "+", 
      RowBox[{"10", " ", "\[ImaginaryI]"}]}], ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173444821]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->599411533],

Cell["Use as an expansion point for series:", "ExampleText",
 CellID->303077153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "I", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258621666],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Pi]", " ", 
   RowBox[{"Floor", "[", 
    FractionBox[
     RowBox[{
      FractionBox["\[Pi]", "2"], "-", 
      RowBox[{"Arg", "[", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], "+", "z"}], "]"}]}], 
     RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "+", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"\[Pi]", "+", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         RowBox[{"Log", "[", "2", "]"}]}], "-", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], "+", "z"}], "]"}]}]}], ")"}]}], 
     "+", 
     FractionBox[
      RowBox[{"z", "-", "\[ImaginaryI]"}], "4"], "+", 
     RowBox[{
      FractionBox["1", "16"], " ", "\[ImaginaryI]", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"z", "-", "\[ImaginaryI]"}], ")"}], "2"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"z", "-", "\[ImaginaryI]"}], "]"}], "3"],
      SeriesData[$CellContext`z, 
       Complex[0, 1], {}, 0, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 
     Complex[0, 1], {
     Rational[1, 4] (Pi + Complex[0, 2] Log[2] + 
       Complex[0, -2] Log[Complex[0, -1] + $CellContext`z]), 
      Rational[1, 4], 
      Complex[0, 
       Rational[1, 16]]}, 0, 3, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{444, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1145495]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->85873571],

Cell["Convert a complex number from polar to rectangular form:", "ExampleText",
 CellID->113753601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2.5", " ", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", "30", " ", "Degree"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->101715519],

Cell[BoxData[
 RowBox[{"2.165063509461097`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.2499999999999998`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225136594]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->152004641],

Cell["\<\
Flow around a cylinder as the real part of a complex\[Hyphen]valued function:\
\
\>", "ExampleText",
 CellID->21257428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"#", "+", 
        FractionBox["1", "#"]}], ")"}], "&"}], "[", 
     RowBox[{
      RowBox[{"I", " ", "x"}], "-", "y"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"Contours", "\[Rule]", "25"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->11155172],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnXeclTWw91l2WVARUOkgHRQBBQtFwBxEqjSxAgICgmJBaQKCiNJVQBCR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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{3250, 1614, 1049}, {7445, 4810, 3369}, {5561, 5431, 
         1613}, {3971, 3931, 340}, {5436, 5438, 1614}, {5160, 4128, 340}, {
         4128, 6315, 340}, {3368, 3370, 1048}, {5976, 5435, 1614}, {5290, 
         5253, 280}, {3792, 3371, 345}, {6315, 5061, 340}, {3977, 3978, 
         3791}, {5082, 6330, 345}, {1613, 3392, 1048}, {6330, 4145, 345}, {
         3369, 3368, 340}, {5971, 5429, 1613}, {1614, 3373, 1049}, {3371, 
         3372, 345}, {2828, 3250, 1049}, {4814, 7448, 3372}, {5242, 5290, 
         280}, {5438, 5433, 1614}, {6952, 6951, 2829}, {5432, 5971, 1613}, {
         5433, 5976, 1614}, {3370, 1613, 1048}, {3791, 3792, 345}, {2828, 
         2825, 280}, {6947, 6948, 2827}, {2825, 2826, 280}, {4145, 5018, 
         345}, {5429, 5561, 1613}, {3373, 3371, 1049}, {3392, 2826, 1048}, {
         2826, 2825, 1048}, {3940, 3972, 1048}, {2825, 2828, 1049}, {2829, 
         2828, 280}, {3975, 3941, 1049}, {2826, 2827, 280}},
         VertexColors->None], 
        PolygonBox[{{6946, 6947, 2827, 2826}, {7683, 5137, 3952, 3959}, {7444,
          4812, 3370, 3368}, {5253, 6952, 2829, 280}, {3972, 3973, 3368, 
         1048}, {5018, 7583, 3791, 345}, {5137, 7605, 3933, 3952}, {5061, 
         7445, 3369, 340}, {3976, 3975, 1049, 3371}, {3941, 3970, 2825, 
         1049}, {3974, 3976, 3371, 3792}, {7658, 7683, 3959, 3957}, {7694, 
         7633, 3955, 3960}, {4815, 7447, 3371, 3373}, {7605, 5162, 3954, 
         3933}, {4810, 7444, 3368, 3369}, {4812, 5432, 1613, 3370}, {7447, 
         4814, 3372, 3371}, {5435, 4815, 3373, 1614}, {4854, 6946, 2826, 
         3392}, {3970, 3940, 1048, 2825}, {3978, 3974, 3792, 3791}, {7448, 
         5082, 345, 3372}, {6951, 6950, 2828, 2829}, {5024, 7613, 3935, 
         3949}, {7613, 4920, 3943, 3935}, {3973, 3971, 340, 3368}, {4700, 
         5436, 1614, 3250}, {6948, 5242, 280, 2827}, {7633, 7658, 3957, 
         3955}, {4920, 7719, 3962, 3943}, {6950, 4700, 3250, 2828}, {5431, 
         4854, 3392, 1613}, {7719, 7694, 3960, 3962}},
         VertexColors->None], 
        PolygonBox[{{7583, 5024, 3949, 3977, 3791}, {5162, 5160, 340, 3931, 
         3954}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.39016807509839174`, 0.22563012924673778`, 0.6654087459405057], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{4701, 5259, 1050}, {4811, 5067, 1191}, {4540, 5292, 
         1536}, {5291, 4540, 1536}, {5975, 5089, 1193}, {4854, 5431, 1254}, {
         4815, 5435, 1193}, {5436, 4700, 1050}, {5559, 5560, 1697}, {6947, 
         6946, 1254}, {4812, 7444, 1191}, {4816, 5084, 1193}, {6946, 4854, 
         1254}, {4814, 7447, 1193}, {4853, 5244, 1254}, {5432, 4812, 1191}, {
         6950, 6951, 1050}, {5247, 4853, 1254}, {5067, 5969, 1191}, {7444, 
         4810, 1191}, {4700, 6950, 1050}, {7447, 4815, 1193}, {5439, 5437, 
         1615}, {5255, 4701, 1050}, {5089, 4816, 1193}, {5065, 4811, 1191}},
         VertexColors->None], 
        PolygonBox[{{4146, 5019, 5018, 4145}, {5560, 5247, 1254, 1697}, {7614,
          4921, 4920, 7613}, {7684, 5138, 5137, 7683}, {6316, 5062, 5061, 
         6315}, {7634, 7659, 7658, 7633}, {7606, 5163, 5162, 7605}, {7695, 
         7634, 7633, 7694}, {5019, 7584, 7583, 5018}, {7584, 5025, 5024, 
         7583}, {5062, 7446, 7445, 5061}, {5163, 5161, 5160, 5162}, {7720, 
         7695, 7694, 7719}, {5438, 5436, 1050, 1615}, {6949, 5243, 5242, 
         6948}, {5434, 5977, 5976, 5433}, {5972, 5430, 5429, 5971}, {5161, 
         4129, 4128, 5160}, {5431, 5561, 1697, 1254}, {5083, 6331, 6330, 
         5082}, {5259, 5439, 1615, 1050}, {7449, 5083, 5082, 7448}, {4921, 
         7720, 7719, 4920}, {5138, 7606, 7605, 5137}, {6331, 4146, 4145, 
         6330}, {5254, 6953, 6952, 5253}, {7659, 7684, 7683, 7658}, {5025, 
         7614, 7613, 5024}, {4129, 6316, 6315, 4128}},
         VertexColors->None], 
        PolygonBox[{{5292, 5254, 5253, 5290, 1536}, {5969, 5972, 5971, 5432, 
         1191}, {6953, 5255, 1050, 6951, 6952}, {5084, 7449, 7448, 4814, 
         1193}, {5977, 5975, 1193, 5435, 5976}, {5244, 6949, 6948, 6947, 
         1254}, {5243, 5291, 1536, 5290, 5242}, {5430, 5559, 1697, 5561, 
         5429}, {5437, 5434, 5433, 5438, 1615}, {7446, 5065, 1191, 4810, 
         7445}},
         VertexColors->None]}]}, 
     {RGBColor[0.4195960394139505, 0.27679741172824945`, 0.7067733097754351], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{5161, 5163, 1492}, {5537, 5535, 1679}, {5194, 5185, 
         1506}, {4490, 6332, 2270}, {5222, 5231, 1510}, {5258, 4542, 757}, {
         6254, 5164, 1492}, {5164, 5862, 1492}, {5972, 5969, 1990}, {4503, 
         5293, 1513}, {5247, 5560, 1514}, {5254, 5292, 1518}, {6180, 4385, 
         1470}, {5020, 6295, 1440}, {4192, 5240, 429}, {5559, 5430, 429}, {
         5294, 4508, 1518}, {5286, 4504, 1514}, {5539, 5260, 1520}, {6295, 
         4223, 1440}, {5439, 5259, 1520}, {5291, 5243, 1513}, {5243, 6949, 
         1513}, {7584, 5019, 1440}, {5434, 5437, 430}, {5063, 6180, 1470}, {
         4195, 5387, 430}, {5260, 5981, 1520}, {5245, 5286, 1514}, {7446, 
         5062, 1470}, {4541, 5249, 757}, {5065, 7446, 1470}, {4392, 5085, 
         1475}, {5083, 7449, 1475}, {5975, 5977, 1992}, {5885, 5020, 1440}, {
         5255, 6953, 1518}, {5240, 4193, 429}, {4194, 5087, 430}, {5967, 5245,
          1514}, {6953, 5254, 1518}, {5066, 4192, 429}, {5387, 4194, 430}, {
         6317, 4483, 2265}, {6949, 5244, 1513}, {4423, 6254, 1492}, {5025, 
         7584, 1440}, {5982, 5258, 757}, {5532, 5534, 1678}, {5249, 5982, 
         757}, {4509, 5539, 1520}, {7449, 5084, 1475}},
         VertexColors->None], 
        PolygonBox[{{4193, 5967, 1514, 429}, {5244, 4853, 1698, 1513}, {5977, 
         5434, 430, 1992}, {7696, 7635, 7634, 7695}, {5085, 4490, 2270, 
         1475}, {5437, 5439, 1520, 430}, {7685, 5139, 5138, 7684}, {5970, 
         5066, 429, 1990}, {7635, 7660, 7659, 7634}, {5292, 4540, 757, 
         1518}, {5440, 4509, 1520, 1616}, {5293, 4541, 757, 1513}, {4922, 
         7721, 7720, 4921}, {5185, 4423, 1492, 1506}, {5562, 4503, 1513, 
         1698}, {4483, 5063, 1470, 2265}, {4385, 5532, 1678, 1470}, {4540, 
         5291, 1513, 757}, {6331, 5083, 1475, 2270}, {5087, 5978, 1992, 
         430}, {7614, 5025, 1440, 1510}, {4542, 5294, 1518, 757}, {5163, 7606,
          1506, 1492}, {7660, 7685, 7684, 7659}, {4504, 5562, 1698, 1514}, {
         4811, 5065, 1470, 1678}, {5430, 5972, 1990, 429}, {5084, 4816, 1679, 
         1475}, {4701, 5255, 1518, 1616}, {5259, 4701, 1616, 1520}, {5560, 
         5559, 429, 1514}, {5535, 4392, 1475, 1679}, {5981, 4195, 430, 
         1520}, {4508, 5440, 1616, 1518}, {5062, 6316, 2265, 1470}, {4223, 
         5222, 1510, 1440}, {7721, 7696, 7695, 7720}, {4853, 5247, 1514, 
         1698}},
         VertexColors->None], 
        PolygonBox[{{5534, 5068, 5067, 4811, 1678}, {6332, 4147, 4146, 6331, 
         2270}, {5862, 4130, 4129, 5161, 1492}, {5139, 5194, 1506, 7606, 
         5138}, {5090, 5537, 1679, 4816, 5089}, {5231, 4922, 4921, 7614, 
         1510}, {4147, 5885, 1440, 5019, 4146}, {5978, 5090, 5089, 5975, 
         1992}, {4130, 6317, 2265, 6316, 4129}, {5068, 5970, 1990, 5969, 
         5067}},
         VertexColors->None]}]}, 
     {RGBColor[0.44902400372950924`, 0.3279646942097612, 0.7481378736103645], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{4387, 5069, 1471}, {5562, 4504, 720}, {5256, 5257, 
         1519}, {1538, 1519, 723}, {5295, 4979, 723}, {6334, 5882, 1944}, {
         6320, 5861, 1936}, {5967, 4193, 1989}, {5066, 5970, 1471}, {5257, 
         5296, 1519}, {4532, 5287, 1534}, {5537, 5090, 1476}, {5440, 4508, 
         723}, {5250, 5248, 1515}, {5964, 5965, 1988}, {4195, 5981, 1993}, {
         4509, 5440, 723}, {6317, 4130, 1936}, {5979, 5980, 1993}, {5858, 
         6320, 1936}, {5886, 6334, 1944}, {5885, 4147, 1944}, {4978, 5540, 
         720}, {5090, 5978, 1476}, {5970, 5068, 1471}, {4503, 5562, 720}, {
         5968, 5966, 1989}, {5068, 5534, 1471}, {4147, 6332, 1944}, {5541, 
         5250, 1515}, {4541, 5293, 1537}, {5974, 5973, 1991}, {1515, 1537, 
         720}, {5538, 4817, 1680}, {5088, 4394, 1476}, {5294, 4542, 1538}, {
         4130, 5862, 1936}, {5978, 5087, 1476}},
         VertexColors->None], 
        PolygonBox[{{5287, 4978, 720, 1534}, {4542, 5258, 1519, 1538}, {5540, 
         5541, 1515, 720}, {4224, 5223, 5222, 4223}, {5539, 4509, 723, 
         1680}, {5069, 5964, 1988, 1471}, {5296, 5295, 723, 1519}, {4192, 
         5066, 1471, 1988}, {6296, 4224, 4223, 6295}, {6181, 4386, 4385, 
         6180}, {4484, 5064, 5063, 4483}, {7636, 7661, 7660, 7635}, {4508, 
         5294, 1538, 723}, {7686, 5140, 5139, 7685}, {7722, 7697, 7696, 
         7721}, {5982, 5249, 1515, 1994}, {4979, 5538, 1680, 723}, {6255, 
         5165, 5164, 6254}, {7661, 7686, 7685, 7660}, {5536, 4393, 4392, 
         5535}, {4204, 5256, 1519, 1994}, {5186, 4424, 4423, 5185}, {5293, 
         4503, 720, 1537}, {4923, 7722, 7721, 4922}, {5195, 5186, 5185, 
         5194}, {4393, 5086, 5085, 4392}, {5087, 4194, 1991, 1476}, {5223, 
         5232, 5231, 5222}, {5973, 5088, 1476, 1991}, {5086, 4491, 4490, 
         5085}, {5064, 6181, 6180, 5063}, {5232, 4923, 4922, 5231}, {7697, 
         7636, 7635, 7696}, {5258, 5982, 1994, 1519}, {5249, 4541, 1537, 
         1515}, {4424, 6255, 6254, 4423}, {5248, 4204, 1994, 1515}, {5140, 
         5195, 5194, 5139}, {4504, 5286, 1534, 720}, {4386, 5533, 5532, 
         4385}, {5021, 6296, 6295, 5020}},
         VertexColors->None], 
        PolygonBox[{{4491, 5886, 1944, 6332, 4490}, {5241, 5968, 1989, 4193, 
         5240}, {5261, 5979, 1993, 5981, 5260}, {5533, 4387, 1471, 5534, 
         5532}, {4817, 5261, 5260, 5539, 1680}, {5882, 5021, 5020, 5885, 
         1944}, {4394, 5536, 5535, 5537, 1476}, {5980, 5388, 5387, 4195, 
         1993}, {5246, 4532, 1534, 5286, 5245}, {5966, 5246, 5245, 5967, 
         1989}, {5388, 5974, 1991, 4194, 5387}, {5965, 5241, 5240, 4192, 
         1988}, {5165, 5858, 1936, 5862, 5164}, {5861, 4484, 4483, 6317, 
         1936}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.47845196804506795`, 0.37913197669127285`, 0.7895024374452939], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlm9o1WUUx5/rdLtut7zXO+9v9+53i5pWNvpv5ZtBoiurtWJaGhaUEKj0
Z2SZWSxtyxpNyDe+KOzPcGg2V5TvEmwtZlp7YVkERVhOhf4YGgRJSN+P3yeC
HX7Pc+55znPO93zPeXbJyie6Hp8SQjgoqZEcbwrhhORcNoSexhA6kxB+l8Gp
C0KYlPTkQtgi/eGZIeyeGsI9+v1Z7U9OC2FuIYS3Z4WwWfb7GkJ4Tj42SH6d
EcJ3svlb/htkv7Q5hM9k82QxhJ3SD+jsmM61Fnz2NZ1t1Lmi5Khs7tWZXbrr
mOL6WfKP9PdJl9OZebUhLJe/i7Q/oLOvysePRa/75adGtlMkyyTLJUOK4aHp
3m/TejIvvzp7t/adWX/R10mfkf9rMrIp+g58fiifa2SzWrK11rGPKLb9uvcX
xfaXbBaWQ+it6g7d05mGcLP26+VzQpgtLTqXxdLPln6F9HdqfZ3Wa7SeL3wv
17mrtV4ofUX6Dq0XSH+V9G1aP6L1eq33BmMB9r9xbyWERZIr6kNYJdl5oYu6
ZZp11KtPPl+Qz9d1fm698UOfSF+S5OW7r9H5kAs1z8tWcIQOneurGr/35Lck
LMakH5BuasExXZuxHtz6pDtecq3RJVG/LGcf4NyqdVXri7Vekho7cBtUHrdV
nQf3r9XZo3WOh7zQjcj3DNVlZV3EWli8LD+HFP+XknHdNagari0aA3h6V2K8
4M4DifNfUjT/4N6jSnRjPNui+LdL3yd9g/Tjuu8G6bfq3KLUHH1K33VgmnMc
3RnbbMt4fVbxtIgXgyX7Ia7e6L9HOZ3RmdOSPwG4ydwi15/qnC+9UkiMIZzj
d+rePd17+HxYmO1JXZP35fsDSU2te48epEZwh36CP8RFrPQjNdsQfQ4p1x2z
zGtsyQ/u7Wr4vz8O5Z0/vw3rOyKZk3U9iJc0+BI/Nf1IGI43mZ+lnOsAr14q
eBaQV4e+E0XbNMP51Lbw4nT0wzly4iwcpe+YSyd14R+Je7s/Y/7BsU+k+1Ry
k/S7ZbMuMdbnSp4R9DJzoSZicqv41l5xTzDjqBv4DDfYN/PilUbzg9rtgyeJ
zx/R91tJe9bxcg/9+4ZsHkuMBT3Nfei3S/eWJM2a4+9UzPMHc64rNcUvPU9s
9A39Q33h2ak4h8l3IubM/nyvBn+xoffpC+pH7b7RnV2pe4Qemow2O0quE/gX
xKVNVfPl+rJxBENyYjYR/2jiucZMo5d4K6gF9YLTYMB86Y+1yMnP81Vj8L34
/IPka9ntSTz7mHvwi7nATFiR+I1hLr2ZeFYyJ2enngtgRYwH844TfJkj8GRO
2byEk2AFLtSRerIGH3qIGQrn92ccZ5ukuezaUBfek4HIE+blpjgzqQN4j8Ue
5D2gD5kTlxbc47wbvalzhzvUdShi/t88407u/iq+R/AMjh3RG/FFo9+Uz4ue
ofTIgZLnHX1bo1ieqRpv+htejMW+Ho3zh77mDaa34QJYUGvuJY+2yJ3+GAPv
c9NMY3W7ML5D0qpYN+ueM3nnytt+ZXyjwZ13mjnxcNlvAHfOL7sf2uPseTG+
Fat538rew4WP8+ZDd5yV+jv/tpzIG4/tWXMEPJ9mxpYdP2d41+kl3thjeXMc
PN7NG5O9Bf/vAicXV4wpeOKjJbWf0TifuXee+Hhjs/uM9+Cyer/RZyOmYMK8
AQ/8jKQ+g/2qsucvOW7Ut6tibO8vGztwu0W6BRX7HS75/wD8/wsO0j++
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlX1olXUUx8823VsXfK679z733t0FNWfpsOjNhAp009CcFVqZWFBCtAa1
lSVCUFNHKhRUEJSRlRjq1KXRf1lRxCxDRMz6o+jFLYVqBQaFFdHn2/f548Dv
PL/zOy/f8z3nuWTd4MpH6iNiEJmGLK5F9CJ9nAvNEXe0RaxCnsFoLwaX5iO6
yhGvcTfCt/eSiDfaI7ZfFHFZS8Q+9BfRn0LvQF9SjZg/M+Laxog5rRH7uTuH
zd28P4DNWBpxEBkgXhffigViI8uRAvIld6eRrdwv4f7XjoimiyMakSnO7+Nv
Ojk9yd0R/I2iT+L/NvS96IfRf0cfQH8H/StscxXnuiAX8TG+P0I24n8+NjdS
aze+5yI3cO4nh0eRIeRBpBdZho+lSA/nW6hvKTIGNt2trnUh+uxW13wd8ZuI
f2VdREr8l3j3I/j9S6xz0yNmkUtXxbWvJYefuGsH/xK5/QG+e4jxLm+mOD+L
/Xb0bch4ne8XE6sHGSX+5cQc5/0E8g/+fql3b44Qv6HZPVrBubdq2+fwdz4x
RsJmCEw+x/exzL9q2sPdscRceB6bPFjNzvr/Cf7HSxFHkXVNEdfw5mziHqu3
9+FvPRi+jb+GRscb4e5VbH7Afj0231FbnvrnYbuImncXIx5rc60vNJpLo9if
bzKnZqD/PCPiQjhmH3fLqsZebz5LnLNylc9Jck3BM8kZww2cn0CiIeJpvr3J
2x28SbDtx8dc8vm+zVwX5wfIrR/Zj/1mbHZR6+6SsRX/NQufthkLYXIQ32M1
91pvxB1xSlwSh5rhx/3424ivB4gf6Gsqxv7enLldzLgvjm/B1wiyo8UcWsl5
FbK6xTOxGbu3isZK/bqT/tyVmnuq4WzZGKh2cW5a3jOjWVEOf6L3Vdyr1cTv
Rp8k16P1rn84dY/UG3FoQ+oZ0uyoJ4cK5qS4qB6LizdXPevi5BXcTYDXGWQe
50XcHSg5N83IROocFFszu5PYr5Dvy+IY5+GCa1Rt4uTD2J/AvjtnDkXZmApL
zfhvqTEVltoxnWA1q+bequdVam1Has3ecROJd4Z2hTA9U/aMajY1Q7fi7/bU
ujDcQi4jWb3KR7luwsdw4pyvwvfVFe8S7TTtkplIPtspOp9mb33R4W86a6dN
Zd+0W4bwM1j2jnmd2DtT74b/c852UE+2I2UrjIWt3pSp/fGaua0Z0W58qGLu
akd+iM3f4P8X8gHnFfjuS81n1ViqeaY0S5oZzYZmVrOqGTlOTzrz5r7eVGve
KZpt7ayTxN9VtK7+36PcU5/FyevJZUHFu1w7dxPnYeSmOnNcXDlMXofK5oyw
7c92rzD+hlw6y45/ipy+JZ85eXNVnNVu+rrdd5pH1SpOiUuqWdxpqPjfJA79
B1Ln8sM=
         "],
         VertexColors->None], 
        PolygonBox[{{4492, 6335, 6334, 5886, 711}, {6321, 4485, 708, 5861, 
         6320}},
         VertexColors->None]}]}, 
     {RGBColor[0.5078799323606267, 0.4302992591727845, 0.8308670012802233], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHuMVdUVxvfMHXCYuffOHeZx75m5EK0wM1grIEWwSQsqDtBAIKCRmTFN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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllslWUQhr/20E0O9rSnPad/z2kThLZECMoWwIiArRQQhABGQGIEDQFZ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         "],
         VertexColors->None], 
        PolygonBox[{{5919, 6336, 2271, 4492, 5918}, {6333, 5884, 5883, 6335, 
         2271}, {6319, 5900, 5899, 4485, 2266}, {7001, 5919, 5918, 7000, 
         2886}, {5900, 6997, 2882, 6996, 5899}, {5860, 6318, 2266, 6321, 
         5859}},
         VertexColors->None]}]}, 
     {RGBColor[0.5373078966761854, 0.4814665416542962, 0.8722315651151527], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH2Q1WUVx599cdnL3t29u3eX3727lyGaYYU/Igmakj8CKRN60YVAl4UZ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlltsVVUQhlevnNJCT3vas8+BAmJCkURIsBiFRBHSKvdLBaFgAvQFClgU
E0UFwx2R1AiiIsitEAxWQIEXHkCRS4nREDAIxARICkijBgQExWj8/vznYZI1
e2bPzJr5Z2b1rJ9X25gdQtgD5UIzEiHUQ6f5uBl6qDSEf8pCaMsL4fucEKaW
hPAk/FlkO6Fb3UIo6B5CDLrJ+UXkE1MhfBOzfDa6r0LzoQboXnkI96FcbP2W
FULvKIRHoOY829yWDGELNKUDvqA/kO3pil3sTYXu8O9t6Hx+CBegHGQ70K9D
9/eOIWxIO0b53lsQQg0+R8KPgKo5v4vuamgk+qOgKr7VlviuuvOPxSHshrZi
qxz5ac7N0Eb4QvgH6N9CP4HvSqgJW+9Bh7jPa/w/DP/DoVpiXR2s259/zuX5
n8vEfglq5XwKuhsPYRV5W9KZO/L/O/DNCefiKvm5Ab8C+ULk4/g2Bttj087F
Buw3k59t0EeFIfTgWz7+mtBfhX4D+j2p31sVjvUHYpxALBPLXMtPkfdCtqNL
CHO4X4+iENaTz734vMddFxfadjf8DSiwjzLqfB77P0EJzuuQJ5D3Q7620FiI
sJ8sMyb6dvc/0n0Uukh8ndHvg/4g/A3H//bIsQ+Hr4H/AD4JXwN/Bv089Hug
3w9+IfKHS32XDwscizB4MxNTM/Ev5f/8mH20cbc1Sdf6FHe8DH8JOsb5OLQS
+/vB68/oZ2E/V/HAn4v52wXs/Yv/v7F1hvsdgL9PfhqRHYQ/j69ByMch3wU/
mvNkbEzG1mJiPIZ8AN9GIN+OfB98b/ih8JvgN4OtL9UD2FtLPA3ENktE7bcT
80rOK1Qf+HHIR2F7P/p90B9d5NrdLXcvqIadwM6yLtat7WjsHkd/YMwYFrb3
o7Mvzxi/iuw54Yl4dhPPDOxPh2aDjZnYf4nz3ApjSTnbEzdGhA3VZA6+Grs4
1kPoVKRdQ9VOmElg/2JX50492sL/C6jTTPCZi34p+s+gP7TIGGqiHpOI7w3i
u0LMg9Gf2NX2lZOj6B+DPuvgnDzLeQL/TyjyHe7FXSPVZj78VrCyPelZ8gC+
Ff2T0JFs23iMf6ugvvz/F/YOa3alLJPORuLZlsHDDWg9/NbMfLoOfwLZcejX
4G91+K6OOzbZmITta+RgfMyYUKwX4IfFHHM28U1NO9Zp8GORnxSmkI+Hr0q7
5qq1MFQaOad1mXy0U88W4pkGf5MYKtPuKfWSMNZOvMPI58vkcwj8wLR9yLYw
2xH/0ypc61nQSuKvrPAsmE29q7A9IOnZ1498DOE8NOnZ+AR8C7avlHuWjcH/
0wn3vHr9KeGM3OxNGRuqYf8K97R6WTlfBBY6EVMlvTIXTBzgn7vIpxQYo5rd
8/n/lZRneBO64zPzehc6y8nFMmhwcM8LW7nopHOMsSXIjlCPEvSrcjxL1aPq
Tc3U3dzl8VLvCuVQs7Me+dYcz1DN5inw63I8o9uKvXO0a1TzE5Fzolyox76K
nDPlSj2tXda/1LEKH23cb3mmP4WRjzW7I+cuQr+e89q4d2MOPm/Bt8c9+xVD
O/yNyLNfO6aSc6/Iu0s7Js65ODI2hBHN4jHQ6MxM3kQel2FvKbSRcxl3K0/b
t3K4g2/NKe8eYT6L859x7ybl5HVsfxF376pmjfCb4e9nOefz4LfE3Uva8Yfj
rrFqqxqUyWeJd+Ue1Zzz5xn86s2wIPKO0G7QDmqNPEM1O9UTK7oao8KmfDaQ
z1kJ73vtzBrucjDh3VtX4LvrDVCdyYF2fWvKvSsMTUd3WsK7UDlUbmZn3irK
0URkN4rdW7nk9xT/vpn27vlFPZzyzNKs+hqaQayt8KXIzxL/kApjUNjTjHu+
zDtHu0ZvKr1l3o9bV28azZpPSmxb+ddbQT2s3tWb4WLknaNdoxlyO/IM0ezQ
G6ma2O6U+O6ToQORd452jXaG3mLqUfWm3mR6CyXQXxPzm2hnwjNPs05vsuuR
d4R2g2bYIvTfTrp22hHZKc8QzQ7tRPWuYpBv9fD6yG8EvQ2001/A/lHu1JLv
Gf9dsXegdp9mVCLlHa3drJjUK9cSzr165r+0Z7pmuXaysDOnxLkXhr4t9w7U
7pOP/wEX7H4c
         "],
         VertexColors->None], 
        PolygonBox[{{6258, 4467, 697, 5167, 6257}, {4478, 6299, 6298, 5023, 
         702}},
         VertexColors->None]}]}, 
     {RGBColor[0.565964059993707, 0.5310089505679995, 0.9095475995103106], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl3mMlWcVxl/mcuduU+bO3Ln3zr0z1Sk1tjEqYmnaxD/YSTGCUECjhZaC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmdsFlQUhi8tXwdt4Cv9NkUKGDFGQBADRiOzDUQslKUEkKURaFmCgyGy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         "],
         VertexColors->None], 
        PolygonBox[{{6250, 6209, 6208, 4467, 2250}, {6267, 6300, 2260, 4478, 
         6266}, {6762, 5482, 5481, 6760, 2627}, {5902, 4846, 2627, 6761, 
         5901}, {6600, 4476, 4475, 6598, 2508}, {6291, 4228, 4227, 6299, 
         2260}, {4465, 6764, 2628, 6763, 4464}, {4847, 5902, 5901, 6766, 
         2628}, {5482, 5909, 1956, 4160, 5481}, {4710, 5917, 5916, 6595, 
         2506}, {5917, 4711, 2508, 6599, 5916}, {4428, 6246, 2250, 6258, 
         4427}},
         VertexColors->None]}]}, 
     {RGBColor[0.5876004231578922, 0.5657725657907595, 0.9100408419495447], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHuwlVUZxtc5e5999j4XzobDvm/SpBk10YwRs4Gm5JblFHIQMAlEQCjk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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl39s1OUdx5/22mvv2s5ry/34HjedukSdTtwizmQYhWLZVISWIU4mKCCd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         "],
         VertexColors->None], 
        PolygonBox[{{6290, 6601, 6600, 4711, 1063}, {6765, 6243, 1250, 4847, 
         6764}},
         VertexColors->None]}]}, 
     {RGBColor[0.6092367863220773, 0.6005361810135197, 0.9105340843887787], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmX+UlGUVx1/Y2Z39MTO7O8syMzuzocfqqJloPzyJYUHqIikuKiqayi9L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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlw1dUVx2+SB4QsJHnJS957vxfR6bQViwK2HQtULVbWFgEJUETWgFoF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         "],
         VertexColors->None], 
        PolygonBox[{{6288, 6269, 6268, 4477, 2259}, {6630, 6768, 2629, 4848, 
         6629}, {6945, 6630, 6629, 6944, 2824}, {6211, 6244, 2249, 4466, 
         6210}},
         VertexColors->None]}]}, 
     {RGBColor[0.6308731494862625, 0.6352997962362799, 0.9110273268280128], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3mYlcWVxr9uui/0drv7Nrfp7nuvIE/GyCaGPcpinjgalCWETaMC4hbH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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeUVdUVxi/DzDB9Xp327lhIYiJgpQYrhmBQBEElKGKkKBCUEvuiicuO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         "],
         VertexColors->None], 
        PolygonBox[{{4744, 5478, 1647, 5480, 4743}, {4088, 6627, 2532, 6945, 
         4087}, {6631, 4744, 4743, 6632, 2533}, {6579, 6587, 2503, 4707, 
         6578}, {6623, 6633, 2533, 4749, 6622}, {6585, 4097, 4096, 6957, 
         2503}, {6591, 6579, 6578, 4709, 2505}, {6628, 6623, 6622, 4748, 
         2532}},
         VertexColors->None]}]}, 
     {RGBColor[0.6525095126504477, 0.67006341145904, 0.9115205692672469], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3e8lMW5x/ccTj+7e87ZPQvbDoqA3miuCigg2HIBEdBosKWA1wLYMSrt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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHm4jdUex18HhzPvs/fZ5+y9331IkeZMEVLubbgVGlRy72MsY4ZSpksI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         "],
         VertexColors->None], 
        PolygonBox[{{7591, 7705, 7704, 7729, 1385}, {7669, 5109, 1490, 7693, 
         7668}},
         VertexColors->None]}]}, 
     {RGBColor[0.6741458758146328, 0.7048270266818002, 0.912013811706481], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnuUleV1xj+YM2cu55yZc87czjVqFDUCjaurXQExyYoSjSZNI6wqggIq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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeQ1dUVx++yfd+Wt2/be2/fAhqQqjKZMYUiUUDBlBGYSJPepSWEFhEh
YDIJYACJio4GU2BpCZnJLnUhDgoJ4CAQAyy7FB0xQCYaFxcwoeTzne/+cebd
87vnnnZPu++ecbMGzWwVQihOCyGD316JEJqKQxicG8Ig4FgyhB1FIaxnb3xO
CNmVIeQAb7P3b769w/4B4OW8EF4B2peE8BZ4d/a/nwl9LIQx8OyaHcK6dM6y
v45vn7N/G4H7S0P4C7AF2qfgNxXe0Sr4FIQwLIJerF+C33B438e3R8GHg/cE
HwT+OviX4PXwri0MYS7ru+hbyNn+0FRgy0l4vgf+AjJ3I2tXqWU9xplfQVsL
npUVws+gX4auP09hTz42Q39WupWBs98GOFDkM6L9AnwBtryBDoeR3Qd7fhyH
B7AUWAA8B7+FwBL8+wr8DsHvIDAK2e2weSe8blaEMAHfboHnNGhnIX8e8pdB
Xw/t7GgIdfBujbz2yEoh8zDnu2P/0pRliPdqzoxjbxf4QfD2nFmN7s9U2pfV
6NANWdPAh4M3cPGTOT8FmMXZ8eBzOBtH79XoswIe55D/PvK3ous9yL8G/i/g
KtAENOoXGyZzv23Zf5jzvROOnR7wG1UewkigS7Zj4J/I7smdbIL/eXSYjb41
yL+fsz3Rtwj79vDtTdZxZJ5ElwcrrOunnCkAjwAHOLsU/HlkdYT+A/zxGjLn
QvsP+Hfkfq9mO1ZOxH1WMbMWXfsjYxS+ewyaOdDPBp6F32XoN8PraXR8Anw7
MvuB/xoZNfDeAdzF3o/wRw26dUXnRejeDprjyF+BD3eD7wFOQXsF/k2cvYPM
Knz/H74l0KUCOBqxj6cgexIwE/w08v+O7Er21+Q4ZuXbOmTmZdnHJdznZeQ1
4J8eWY7NEnKqItMxOhVeR7D/K+hSn+1c3sH+nzOd08nW3Cn2NwIJ1gv5zUXH
Nuj/DDG8CX6bgVr4H0mzbW8lbLts/AX4OHz6CL4covuCthA4mWYd3oD2TeDz
HH+rZr0J2JPrmK9Gn/3osxvaa9B8Aj4cHa5yH4+nt9QG6D/LdY34GHw18oYh
73Xs2wj9Q9i4N9sylrF/EH+fwd6zQBG8p8OvDbaMwH8B3e7gvy5ZjjHFziT4
P5frGJKv7vAtnmufzcf/q7jfE/Cfyv4V+O2EppS9v6HzRs5uSPhuZdMU6Nuq
/hErQ6HvhC6TK3yX9+Y7l/PjjlXl9HX4ZaBPOtDM+gj6HS6z7brjKPbMSLhW
zYc+guxDyHgH3ov49h1ov1vmXOmBf48gqzHqXJsIjzHk2ljgNdZP8W1Tle9c
d13NugleY+C5uZVtrEb3F4mxAuhn4eMenO1Zbl5fheYcujcAl1jfwIYvkTe6
3LxVs/ZiQx2wHPo1wbn+WdS9Qjl/hrNVyMxE/yLsySjznemuumHvfuTvS7oW
qwZvwfb38dmH7D8f3AvqYvateoJ8kY/+L+TYJ1sTPiPaffjndNwxpthqArrD
65tABH0fgue+mHuKeolqYDGyo0BffJmd59g6FfdZxdif4L0daJvhnreT9ZiY
a6tq7CX0+aTSvUIx0IG9n6Rci8/w7Yzukm+NrBuAgfDuBfQEngQ2I3sLcAZZ
iA/fQvcBfO8P9GZ9kfMrYs61afinM7LmJd3b1ONS4M3cX1bEPta6Me670rfr
4P3A69S7wQuhLwA+TXdOPM5e60rviaYReeeAleizQD5BVg5wJ9c69Ma28+jV
Nd09aQW+HJ1wb/9poXvxf4GP8tyTjyP/Gngj+I+wb02Ze5J6kWr8XfUidHgX
2SFi2we2+EY+uB21DPEe18qzyE34XczzTPIxujTC72CWZ46r4J3Rpy/rJ1QT
WDck7PvfIPPDqGu4ardqYmvVR/y7LsM1qY/yo8y+7oo+a5OuKaolmkGywDOB
gWn2yTb0aQY/z97S4Np6HWhuqbEPwO8AOTEff0bh8TXkZ5d49lkueSXmobO6
k3p0aVfl3rcXmgTn45X2TRqwCll9qjz7RKC5zH1cAW7kWqfx7C9viRfV6K7Y
3iXhXJZP1Gs2JZ3r6jmr4P3bqHvlwohjcQnfZkUckzOQ1Q8YkeeaeipmG6S7
esRiaNdG3Wt0Zh74zKh7xxTwLiWuQao9nVUnuNNn8fkJ7vs48BL8jqH/xXzn
/GB8P6jM+dWc4d58Wz0z1z16Jfi78C/HnvvxVyXnF6Q8e2gm2sZ6AOeHgNfB
r5PkAnfRPwN+x6KeaTTLaOZMJT0TaBYoyvPZidCMipiHenFSNTC4Jw+Nuger
9ypmRiH/98isQdYO4Ba+/l/CsnQnmpWU08plzUwbod2Qci7ozNkiz4Ca/ZQz
6xOeqTVL13K+Juoerd6ch80PK/dUN9Bla45ngQnFnlU0E2j2XAIsbplBZ3Af
04FtGbapotIxpViSTzSL1UPXnOOZLIbskqRrYUfOrEk65hRr6sGKbfUw9S7F
uGQtQMf5UcssjLuHqXepRkvXXsjYkmOdv4DXItWLXOeMev2rMc9G6vln4+4Z
6hXS6XzcNsvWm8Aw+QYYydkO6DSWs7UJz96KmUr2NsZ8l4XAL6Pu6erlF8CL
8f36YsdmVr5nwQboD6V7JkzEPHNr1ta333E3HUs8q4/lzjqodwBv4+9HMz0b
9o213JVqTNQ5pVzSTLGQeK2N+u5UM5/GnhFx1yLVvNPIOlXq3qmZcmjSNso2
zYx/LHFNUy3TDK5al0zaNtW8J8EHljlX1MO+jW4FUc8GizVToUsWNt+KWOd5
mh1L/ZZ5D54Xyl3zVOtU83sUe0bXbK4Z9q+cPQTkpHnGWhF3TVMtUw6rNvSt
cq1SjdAsd1+J336a6T6A39dTnq01Y55gfRzYnuacz0w5Z5Wr0nEl/F+MuzaI
RrPy9ITfQpqZd6Vsg3Q/CnRBlxr2HylwP9R6Z8v7R99uF/uNqLehZhTFXqeY
3wqKwQz434m6t2xI91tuScq9W2+6TPbvRv020kylt0Z1yrmuN4dif4jek6XO
gZHoMyDq3qk3RBL/Vpb7raiadYO7u550LKqH6exovQdbeORy/lKR39bKmW3o
+4eEZxvNIHrbfCPlWUZvnPqEY1SxqRnj5aRnZs3KypHvocucEseq3qB626aX
efbSG/cktMkqz7aqEZp1J6LD4Ihn3kL2Jyc8e/4g37PrtZa3n2bYCZXOKeWS
zkxK+Yxo9ab8YcwxqVjUzKlZ8kLcuayZcm7Md6q7VIwdRdaRhGuPemYT9rSP
+W2lGUL/NVyI+e2r/xwehHe3Kt+17nwivApivkvN+Pn4vqDcvUIzoHytnqRe
JJ/fintm16yuHvNAlWcsxZJ4/h8z7WlL
         "],
         VertexColors->None], 
        PolygonBox[{{6942, 6753, 6752, 6943, 2823}, {6753, 4844, 2625, 6754, 
         6752}, {6205, 4455, 2236, 6214, 6204}, {7171, 6265, 6264, 6775, 
         2632}},
         VertexColors->None]}]}, 
     {RGBColor[0.695782238978818, 0.7395906419045604, 0.9125070541457151], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH2MlNUVxu/ysTOzO7szs7vszDszawX7BVW0/yiULzUaUkxbUNSmNYJA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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQ1WUZx19o9+we9nJ+Z89lz+/sWZPshsqlf0qFZVdHJ8GpuCVOMUFA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         "],
         VertexColors->None], 
        PolygonBox[{{6759, 4845, 1249, 6215, 6758}, {4471, 7168, 3066, 7171, 
         4470}, {7170, 6276, 6275, 6265, 3066}, {4856, 6778, 6777, 6774, 
         1258}},
         VertexColors->None]}]}, 
     {RGBColor[0.7174186021430031, 0.7743542571273204, 0.9130002965849492], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuMldUVxQ8zOI97Z+Y+ZuY+hhkRDDSBFk1ti6AtCBLoYOsjgjStICgQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmds1lUUxi8UOmjp+3/7tu/qghrqF0HiQBGwgCIkmICDCnGwQTBBGWVJ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         "],
         VertexColors->None], 
        PolygonBox[{{5475, 4157, 2880, 6993, 5474}, {6277, 4218, 4217, 6273, 
         2255}, {6757, 5896, 5895, 4845, 2626}, {6749, 5475, 5474, 6750, 
         2623}, {6776, 4472, 4471, 6778, 2633}, {6771, 5913, 5912, 4855, 
         2631}, {4458, 6207, 6206, 6226, 2237}, {5913, 6779, 2633, 4856, 
         5912}, {5896, 6751, 2623, 4843, 5895}, {7169, 4473, 2255, 7170, 
         7168}, {4418, 6219, 2237, 6218, 4417}, {4457, 6756, 2626, 6759, 
         4456}},
         VertexColors->None]}]}, 
     {RGBColor[0.7390549653071883, 0.8091178723500805, 0.9134935390241832], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl32QlWUZxp/djT17zi7sHs76vuec/QBkwoomwRBNBBNnlhwkphgXmQJD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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtllls1FUUxk8H6DIgnekM/1m6ABIFRVlkE1kikBBFKhFCoWhRiIUIRrC1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         "],
         VertexColors->None], 
        PolygonBox[{{5014, 6278, 6277, 4473, 700}, {6220, 5150, 689, 4458, 
         6219}},
         VertexColors->None]}]}, 
     {RGBColor[0.7606913284713734, 0.8438814875728406, 0.9139867814634173], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l3mIlVUYxo/36nz3Xse5987o983cOyOYtumY5jhqpUNBUYRtRmDWPwWi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtllts1FUQxg9b2v63CN3ttme3u9vFShUQaAv0ghGrRIxGKWrVRIovYgho
UG4GCCC8CEq8UC8pYKtGTIACEqNGBbWNgFGDFgWaaIIRiK0hAcqtYPuCvy+z
D5Od2XNmzsycb77zL5+3uOmFkHPuY2Q4ctg7VxBxrmyEc2vznTsYde6tYueu
5vJ/2LlQqXPDkBBOKez/Es5dR3YPc24E9nX29iMXkGvIn4XOfY7sLHCugngD
Kf5HDgTOfYh9KeZcfdy5b9E7iJEhVhlnrif+wRznbrB2iXyasVuwW4i5GPtI
vuVUxP4i9r/I+u4cO3sm9r1Ry2E0cpSaupEM+nriHcC/kP0V7N+JPiHt3Lib
8CVmG+vvIQ/Sixt5zj1U4lyYPWn60YzdhX0bsb/n7A7sFvb+xHqSeJOJd4Za
y5POxan3SeItYn0b6wPU5lnvLeJ/al6Nfxv+eeSVi/Si9yEl6MVIP/pF5Dz+
55B3yWcs8e6k3vmc/3VgPbzAWi/xZ3P+OuKvxHcFchd7G5CN6BuQ+9EfQI6y
vxtZQbwUdphcHkVWZuspZ+/NyCD6ELIVPS9ud6XzTqH/jWzAv5z/uqn3I2Qb
9YYVj/xyyG8B+bxPPpvpeQd2H/YQMhzfBvKdMcJi9uC7D9mOfwb7Wc5biExF
r0FmsPd4zPq9A/s1sFdFD/8h9m/8N1SGsD4oQV/L/rmc2YysiRgWGslpVsIw
cYyzdiEfcF4s37DUxt7BXMPUN8IHspD6Ith16FdidpYweiVhmBVWw+C9lVzb
vN21cmpn/y/EHEOt07E7sHchc4iXx54t+L5CjI1IK/oznF3FbyUyD30vNWQy
zACyB/0Pcn3MW6+FgSL+iyHlBTZzlWCtCkkV2PlT0WuQDPZZ7NX4rvE2G7qT
uehPeZslYSaBXuoNu5qJJczCMmQt8/Al/4XFB95mRTNfgX6rt9qE+UXoz3u7
a83oRPQuzm/h/Fn810Ndybjdne7worceqPZ+9Oq0cYq45HbOXMfez/B/CX8H
3o4kDePCtjgkKDaOEbfkI3VwST2SAk+XIbC36c2SUsv9zVHWW/VUvVSPryaM
08Rlur9r2G/w/9mQ8Vc9Madx3nfke5J86xI2A8K+Zm6CtxpVm+74JPmt8jZr
nQWGrWP4zwwMYxFyq6TG8dS2HQkixiniEuUsrqhNWGxxxhTsvkK7v9FIE/65
2fnTzBwG+03ZedV6J3Z7Fn/yF3ZOU+upMsPQGOLdkjRsaM8k9IlJw68wszRt
HCFu0J3PRn/Y2yw2hGy2gmyvNWP1+NYlDVvC4FH0A4X2fiwIbJZPk29jYDMt
bujErg2MI5SbZnYwm2MP/s95m/UvWG9n/272VwSGIWEh3xs3ChPj8DnPnkH0
6SOd+4p1740rX+a/SdTTzf1+GraeH2LtB29vWRf2IzHjcHGdeiiu0AzOy3LG
v4V2B+qt1rvI5W78a0NWw/G49Ui90R0vA2vLkVfD9gbtYX2yMBKyGsSlP3Ln
0cA4Vdy+P2LYFseL6y5GrHfivDP4Py6+DlkP9TbojdLbpDeimPuuoQf3Ufsm
zvyZfMd7e6vEMb9iV3vjGnHYFuz9SeNyvWmK/YS3t1hnqLZ7vHGhajzB/kZv
b4M4/i/sOd7eHt3xWPq3h/61Em8+/bkcM07ULInjX4/ZTGmWxE/qxRRvb4N6
8jvxGrxxq96gfdzVqYS9DZrBMu4vk7Z4wmhtmc24Zls1620L4bMqsDfuRMze
MN2n+GUyte7whk/NUDRlM6jZE2Y2xw0zworuZGmp9VS91B22g4FDxB8Ztjch
mrAZ12xvYn910mZQ+FD8O+JWs2oVZ4jb9Qbp7RHHnys0zAqrevODhGFeWFcN
9QmbYc2uOEBnD2T7pxy2Emc5/k+Psm+IaSnDtLCsb5Kp+L5TalylmoX9qrRx
qWZgb4l9c+hbQ3emb4Fo1GrRN0E6apwprtQ3l876hPxKcuxMvZ36htK3k97Q
iYqdtm8ZfTP9D/sRWmQ=
         "],
         VertexColors->None], 
        PolygonBox[{{5911, 4489, 2269, 6327, 5910}, {5914, 5911, 5910, 5915, 
         1958}, {5839, 6312, 2264, 6311, 5838}, {4482, 5898, 5897, 6314, 
         2264}, {6328, 5872, 5871, 6326, 2269}, {5898, 6994, 2881, 6995, 
         5897}},
         VertexColors->None]}]}, 
     {RGBColor[0.7803199659242172, 0.8528967987965381, 0.9061063591176103], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VVtoVFcU3ROdzMyNmszcyT13bmZC6ytajTWaGFHxgZaaClqCFql+CUqL
tZL2Q1RQEbQ0X74CivlQVBAVUdNS2g9TEi2CJWhsQf9qQfSjFZVahQTsWq7T
j805Z5999nPtfd7dtL3zyyozuwIaA5oTmbWAshmzwJntz5sNQmA6zp9kzXog
86jO7KnTOcH6e2j2C2TuYP0mr31rxaxYMPsBSrtzZh9ltB/EfW/RbBQya2Bn
NaiCu6ng99ebHQD/V+jvhd4G6E9ltK6C3c2QWRjDV8ish61H0H9/rNkwdOzz
frZB/jPInzXxtoXi068XkXx7Um32GNQMmRGsBcgvwv4W7B5yOvdC9jr0n4b+
E/B3EPsz2LdAPg7En5iYTUp0fga7DvE1Qs/KCYr3Lvbv434WqAKZpeAtAQ2A
/yHs5BDvXOj7HnfzwO8D/72Mck3/L9cit6CD2PdhfVCr/FN3h9d/NG1WDuRb
v7dB/XsCxckYmxD7CZ/bw4hlAOcR7F8hl69B41CfY2mtrMvLWHXinnGVc4qN
7/6J9bY7ZfYz6A/oT5XMqkqSOw0fh0Cfg/+sxuzHrOpFf7uz8u058vzGqU7v
BMrBWfjf3oA8gJIa6aaNxaDOBmGRdVzs+S0p1ac9Vi26cB5lPUGlGslRZhB1
nI/3u2G/abziPAf5OvDyoNewP+R1Mhbab6vIB+K3qyTcfo31q5KwzFoSB8z5
EeR1S14xfofc9oHS1bJHnXNA/aj/TPhRBd52Ygwyv9H/lPxuBX0LHc4Jn//C
h5cNyt9y8B6Eys9SJyzS7n0fM+PdBt1fRMLQRqwbIuFoN9ZdkTAxq6yYGW+X
t40yvcXjzqywNwY+5GKdC9gXYtWMvs/w/t9ATmYn8mfA+089F5GHplCxEGuT
88LbLvCO1yvvlKXflFkLfX8inknQ2QjfKqB4HOoMfi4SdjkPPg6lZxpq8let
ry/uY9ALyEzBOhk0iv153A+DdrDvoG8oL9xeDpQP9hTjfxWIz/oM+RrlUJdV
9cIM7yjDXuZKXDV6XLG37/oe5J7YIFY6JuieMQ54LLIebb6vqYe26f8S+NvP
OZPRW76jXc6DFU79kMZ+mRPORv17vr2J/J8qCsPsH8bGuFgzzhHaYs04C9hr
D53mCGcI5+WletXg71rllDqZp+ay4ubsOxBoHm4NhW9imzO4O9AcTmU1Xzhb
OkNh4i0+I8XGuBjDxEB+XneaC5wJ/FsuOv0vF7D2gv8pcwVMtSd6w95lTpjn
q4j1GmhstWYdV84f/hv3nP4Ozp7ZZc0f/ku3E/1NDr6f8b027IQPYmOhU36Z
25uRZgT7taeoN5TvwbozlE3WucPXmutKX2vilff/z0PqYB2ZP2KTOWTOiE3m
jeuI3wfA241I2AtRh0JF82kRfFjgNNNY5w+cckh9z71O/l2cy8Qk/SGG6Bvn
DvuMc/tkUbOGsbBv+Y8yz5wxiZ8z1Mdaso7rIvUk+3Em8tec6F9JO81fzt6f
oG+v05tW3M9NNL/ZN9k6xf4fN+AOrw==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlU9sVGUUxe+0tNMZMLQzj/depzMFKWoEsbW0FMXEGiFEE5WQYExhJWo0
iERdmIp/VojpSqNVErsxSIKKRi1GYCELxJhgpEExsnABidGFxmJEGkqiv5Mz
i5v5vnf/nXu/e+5c/8juLU+3RMRuZAHyaBIxUI3oR3ZwLqURHchv7RG/I69n
EUdrEXvLEZWOiF8470E/Wow4wbfLPRHr8ohj6GYXRkxhfxybCXQ9fJtDdxm5
RtJFpYj/0M+g/wT9E+hf4T7N/WXuBe4ZsY93+nyJ/Hnqbzr/LTxgfAOZJ96P
BX7BXeLegVzl/HhXxJ2c36O4T7FZTexVyAHudXJMLQY39xbwj1H/DLE/AN8h
5AznncrVaWzD2KyjvhL328i1h/tG8G5C1oDlIDEvYb+fvO8gs5y/J/6geojt
k8S/lVwDFfyxb5D/JWJtB9825EXOb/M7mTRrAe95/Lfi34f/JP6v5faR7T7O
B7A9mLif8unD9ttOv808OUaweazLtasHS3sjLjYiLiC9nAfAM4QsA8v76Ffh
vxIpFN2TWWJvxH8D8lfiWThE/NmiZ0K233X6beVznrpvwnZvi+Op1uXEz8uu
+dluasDnPmwneP8KOLbh/1YbftdFjKNrxX+ceHdhs497hfsE93u5zyXGJCxX
kLP0Z1Q26J6nP9N8e6HqeG3tnr0b0F9r9wx28X5/4jOP7Rz3c9je2MT7DVKi
Xz/h80XZGFak7ql6qRhjnH8F70PobibnBt7+nsy1agbUmwI11kvu0UV0F5BX
w2+4nvj/9pgbepMT6L7KPBuqYTN4tlQdT5jOgfVBcjaKjjFIP9eCb3nZ+cTF
7tRcECc1+3PN3ogDK6htpuraFE+17cJ+bdE1Hss9s5rVo7m5V07NdXFwdZ2Z
rbtXWStvlboHqn0lsovYtzf5fpL4TzU5I64oxzP04rluv/WXreZef82zLw5+
RO0fZuaeODJArv66c6mHmtV55GpzZn/A9mzmt1ZP/iF3L/b5IvPl8BJiIkNw
4Wfi7+d8qmJuaibW1NxD9U4zvywx58X1pZqd1DOo2dNOG8a+2vBsKoawaMdo
twjT19ieSr0LBgvenR/z/XDDO/RusI5mrlXzP8z3oYZ7UVto7h5JPKvi8B+8
98NVY9eMKpY4K64qZoNax5ixN9tc8x3EXp85tvh9ktoml1ivnCM11yDsmplK
7p2tXS1O9XGeSu0rjoqb4py4Jo7qbXdWPat64ymwvtvcT8IrLLfUvEuVU7t8
e+rZ0E7XbtN/yo7mjnsgd8/V6/s5n8Z+erF3mzjVQbyRHvdGO1a7Rz6y1Q7S
rriS+79D76n/mrbMsyd8nyfeoZqFBfRkHOyfJT4Ln3azdqh2p3b0/9pe8J0=

         "],
         VertexColors->None], 
        PolygonBox[{{6313, 5842, 707, 4482, 6312}, {5874, 6329, 6328, 4489, 
         710}},
         VertexColors->None]}]}, 
     {RGBColor[0.799750888528718, 0.8593764937298713, 0.8974013232034775], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{5961, 5079, 1474}, {5951, 5179, 1504}, {5181, 5951, 
         1504}, {5297, 4985, 744}, {6329, 5874, 1941}, {5270, 5298, 1527}, {
         5959, 5957, 1986}, {4685, 5401, 1603}, {5555, 4529, 746}, {5525, 
         4803, 1675}, {1602, 1527, 744}, {5958, 4191, 1986}, {5079, 5531, 
         1474}, {4525, 5417, 744}, {5285, 5283, 1532}, {5524, 5181, 1504}, {
         5300, 5285, 1532}, {4115, 6310, 1923}, {4391, 5081, 1474}, {1532, 
         1603, 746}, {5180, 4454, 1504}, {4139, 5875, 1941}, {4189, 5954, 
         1984}, {4528, 5555, 746}, {5947, 5946, 1982}, {5400, 4684, 1602}, {
         6313, 5840, 1923}, {5417, 4524, 744}, {4805, 5528, 1676}, {5873, 
         6329, 1941}, {6325, 4139, 1941}, {5269, 5270, 1527}, {5841, 4115, 
         1923}, {5952, 5953, 1984}, {4986, 5299, 746}, {5955, 5956, 1985}, {
         5078, 5961, 1474}, {5842, 6313, 1923}},
         VertexColors->None], 
        PolygonBox[{{5179, 4188, 1982, 1504}, {5283, 5399, 1601, 1532}, {5528,
          4986, 746, 1676}, {5401, 4528, 746, 1603}, {4974, 6202, 6201, 
         4973}, {6223, 5153, 5152, 6222}, {7676, 5116, 5115, 7675}, {7712, 
         7651, 7650, 7711}, {4985, 5525, 1675, 744}, {4389, 5073, 5072, 
         4388}, {7651, 7676, 7675, 7650}, {4529, 5527, 1676, 746}, {5361, 
         4422, 4421, 5360}, {4972, 5523, 5522, 4971}, {4190, 5078, 1474, 
         1985}, {5526, 4525, 744, 1675}, {5017, 6281, 6280, 5016}, {5130, 
         5369, 5368, 5129}, {5298, 5297, 744, 1527}, {4422, 6223, 6222, 
         4421}, {4222, 5213, 5212, 4221}, {5399, 5269, 1527, 1601}, {4913, 
         7598, 7597, 4912}, {5284, 4685, 1603, 1532}, {5073, 4488, 4487, 
         5072}, {4684, 5271, 1527, 1602}, {5530, 4389, 4388, 5529}, {6281, 
         4222, 4221, 6280}, {5221, 4913, 4912, 5220}, {5946, 5180, 1504, 
         1982}, {5299, 5300, 1532, 746}, {4481, 4974, 4973, 4480}, {7598, 
         7712, 7711, 7597}, {5116, 5130, 5129, 5115}, {4683, 5284, 1532, 
         1601}, {5213, 5221, 5220, 5212}, {5369, 5361, 5360, 5368}, {6202, 
         4972, 4971, 6201}, {5271, 4683, 1601, 1527}, {5081, 5955, 1985, 
         1474}, {4524, 5400, 1602, 744}},
         VertexColors->None], 
        PolygonBox[{{4188, 5382, 5381, 5947, 1982}, {5382, 4189, 1984, 5953, 
         5381}, {4488, 6325, 1941, 5874, 4487}, {5527, 5281, 5280, 4805, 
         1676}, {5523, 5524, 1504, 4454, 5522}, {5274, 5526, 1675, 4803, 
         5273}, {5386, 4190, 1985, 5956, 5385}, {5954, 5274, 5273, 5952, 
         1984}, {5281, 5958, 1986, 5957, 5280}, {5875, 5017, 5016, 5873, 
         1941}, {6310, 4481, 4480, 5842, 1923}, {5531, 5530, 5529, 4391, 
         1474}, {5153, 5841, 1923, 5840, 5152}, {4191, 5386, 5385, 5959, 
         1986}},
         VertexColors->None]}]}, 
     {RGBColor[0.8191818111332189, 0.8658561886632046, 0.8886962872893449], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{5816, 5279, 1530}, {4189, 5382, 427}, {5400, 4524, 
         1526}, {4528, 5401, 1530}, {4190, 5386, 428}, {6281, 5017, 1439}, {
         5277, 5816, 1530}, {5361, 5369, 1573}, {4685, 5284, 1043}, {4481, 
         6310, 2263}, {6223, 4422, 1491}, {5281, 5527, 1531}, {5552, 5424, 
         428}, {5530, 5531, 1677}, {6202, 4974, 1415}, {4525, 5526, 1528}, {
         5527, 4529, 1531}, {5414, 5272, 1528}, {5865, 5008, 1439}, {5282, 
         5553, 1531}, {6712, 5070, 1472}, {4972, 6202, 1415}, {5073, 4389, 
         1472}, {6694, 4975, 1415}, {6325, 4488, 2268}, {4188, 5179, 427}, {
         5841, 5153, 1491}, {5810, 5277, 1530}, {5154, 5348, 1491}, {5266, 
         5809, 1526}, {5006, 5865, 1439}, {4113, 6694, 1415}, {5074, 6712, 
         1472}, {5153, 6223, 1491}, {5408, 5412, 427}, {5348, 5148, 1491}, {
         5271, 4684, 1043}, {5524, 5523, 1674}, {5962, 5960, 1987}, {4222, 
         6281, 1439}, {5284, 4683, 1043}, {4683, 5271, 1043}, {5813, 5266, 
         1526}, {5386, 4191, 428}, {5274, 5954, 1528}, {5078, 4190, 428}, {
         5017, 5875, 1439}, {5221, 5213, 1509}, {5268, 5813, 1526}, {5958, 
         5281, 1531}, {5382, 4188, 427}, {5526, 5274, 1528}, {5948, 5949, 
         1983}},
         VertexColors->None], 
        PolygonBox[{{4524, 5417, 1608, 1526}, {5279, 4849, 1694, 1530}, {5179,
          5951, 1983, 427}, {5424, 5962, 1987, 428}, {4974, 4481, 2263, 
         1415}, {5809, 5808, 1043, 1526}, {7652, 7677, 7676, 7651}, {7599, 
         7713, 7712, 7598}, {4422, 5361, 1573, 1491}, {4488, 5073, 1472, 
         2268}, {4914, 7599, 7598, 4913}, {4975, 4802, 1674, 1415}, {5808, 
         5810, 1530, 1043}, {6308, 4113, 1415, 2263}, {5213, 4222, 1439, 
         1509}, {5954, 4189, 427, 1528}, {5117, 5131, 5130, 5116}, {4389, 
         5530, 1677, 1472}, {5401, 4685, 1043, 1530}, {4693, 5268, 1526, 
         1608}, {4684, 5400, 1526, 1043}, {4807, 5074, 1472, 1677}, {5272, 
         4693, 1608, 1528}, {5553, 5552, 428, 1531}, {4849, 5282, 1531, 
         1694}, {5555, 4528, 1530, 1694}, {5523, 4972, 1415, 1674}, {4529, 
         5555, 1694, 1531}, {7713, 7652, 7651, 7712}, {5417, 4525, 1528, 
         1608}, {5961, 5078, 428, 1987}, {5412, 5414, 1528, 427}, {7615, 5154,
          1491, 1573}, {5949, 5408, 427, 1983}, {5008, 7607, 1509, 1439}, {
         4191, 5958, 1531, 428}, {5070, 6323, 2268, 1472}, {7677, 5117, 5116, 
         7676}},
         VertexColors->None], 
        PolygonBox[{{5960, 5080, 5079, 5961, 1987}, {5148, 4116, 4115, 5841, 
         1491}, {4802, 5182, 5181, 5524, 1674}, {5080, 4807, 1677, 5531, 
         5079}, {5131, 7615, 1573, 5369, 5130}, {4116, 6308, 2263, 6310, 
         4115}, {5182, 5948, 1983, 5951, 5181}, {7607, 4914, 4913, 5221, 
         1509}, {4140, 5006, 1439, 5875, 4139}, {6323, 4140, 4139, 6325, 
         2268}},
         VertexColors->None]}]}, 
     {RGBColor[0.8386127337377198, 0.8723358835965378, 0.8799912513752123], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{5268, 4693, 1045}, {4802, 4975, 1186}, {5427, 4808, 
         1190}, {5808, 5809, 1899}, {4850, 5426, 1251}, {4799, 5843, 1186}, {
         5414, 5412, 1606}, {4800, 5410, 1186}, {4849, 5279, 1251}, {5843, 
         4800, 1186}, {4807, 5080, 1190}, {5080, 5960, 1190}, {5810, 5808, 
         1899}, {5878, 4806, 1190}, {5948, 5182, 1186}, {5282, 4849, 1251}, {
         4693, 5272, 1045}, {5182, 4802, 1186}, {5411, 4691, 1045}, {4808, 
         5878, 1190}, {5074, 4807, 1190}, {5815, 5422, 1251}, {5403, 5811, 
         1045}, {5422, 4850, 1251}, {5552, 5553, 1693}, {4691, 5403, 1045}},
         VertexColors->None], 
        PolygonBox[{{5349, 5149, 5148, 5348}, {5278, 5817, 5816, 5277}, {7616,
          5155, 5154, 7615}, {5071, 6324, 6323, 5070}, {4114, 6695, 6694, 
         4113}, {5009, 7608, 7607, 5008}, {4141, 5007, 5006, 4140}, {7678, 
         5118, 5117, 7677}, {6713, 5071, 5070, 6712}, {5007, 5866, 5865, 
         5006}, {5553, 5282, 1251, 1693}, {5413, 5411, 1045, 1606}, {5425, 
         5963, 5962, 5424}, {7608, 4915, 4914, 7607}, {5950, 5409, 5408, 
         5949}, {5149, 4117, 4116, 5148}, {4915, 7600, 7599, 4914}, {7600, 
         7714, 7713, 7599}, {7653, 7678, 7677, 7652}, {5426, 5554, 1693, 
         1251}, {7714, 7653, 7652, 7713}, {5272, 5414, 1606, 1045}, {5814, 
         5267, 5266, 5813}, {5118, 5132, 5131, 5117}, {4117, 6309, 6308, 
         4116}, {5155, 5349, 5348, 5154}, {6309, 4114, 4113, 6308}, {5866, 
         5009, 5008, 5865}, {6324, 4141, 4140, 6323}, {5132, 7616, 7615, 
         5131}},
         VertexColors->None], 
        PolygonBox[{{6695, 4799, 1186, 4975, 6694}, {4806, 6713, 6712, 5074, 
         1190}, {5963, 5427, 1190, 5960, 5962}, {5409, 5413, 1606, 5412, 
         5408}, {4089, 5278, 5277, 5810, 1899}, {5410, 5950, 5949, 5948, 
         1186}, {5817, 5815, 1251, 5279, 5816}, {5554, 5425, 5424, 5552, 
         1693}, {5267, 4089, 1899, 5809, 5266}, {5811, 5814, 5813, 5268, 
         1045}},
         VertexColors->None]}]}, 
     {RGBColor[0.8580436563422206, 0.878815578529871, 0.8712862154610796], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{6324, 5071, 343}, {5557, 4697, 1610}, {6309, 4117, 
         323}, {5815, 5817, 1901}, {5950, 5410, 1605}, {5411, 5413, 1605}, {
         5554, 5426, 1610}, {4089, 5267, 278}, {4687, 5416, 1605}, {4799, 
         6695, 2585}, {4994, 5418, 278}, {4114, 6309, 323}, {5278, 4089, 
         278}, {5409, 5950, 1605}, {7621, 4118, 323}, {6713, 4806, 2595}, {
         5007, 4141, 343}, {4697, 6718, 1610}, {4141, 6324, 343}, {5963, 5425,
          1610}, {6697, 4687, 1605}, {5814, 5811, 1900}, {7627, 4135, 343}, {
         5425, 5554, 1610}, {5402, 4994, 278}, {5344, 7621, 323}, {4142, 7627,
          343}, {4117, 5149, 323}, {5427, 5963, 1610}, {5413, 5409, 1605}},
         VertexColors->None], 
        PolygonBox[{{5418, 5818, 1901, 278}, {5071, 6713, 2595, 343}, {6714, 
         4142, 343, 2595}, {6695, 4114, 323, 2585}, {4118, 6692, 2585, 323}, {
         5267, 5814, 1900, 278}, {5423, 4851, 4850, 5422}, {5812, 5402, 278, 
         1900}, {5119, 5133, 5132, 5118}, {7654, 7679, 7678, 7653}, {7679, 
         5119, 5118, 7678}, {5844, 4801, 4800, 5843}, {7617, 5156, 5155, 
         7616}, {4809, 5879, 5878, 4808}, {7715, 7654, 7653, 7714}, {5156, 
         5350, 5349, 5155}, {5133, 7617, 7616, 5132}, {7601, 7715, 7714, 
         7600}, {4916, 7601, 7600, 4915}, {7609, 4916, 4915, 7608}, {5867, 
         5010, 5009, 5866}, {5010, 7609, 7608, 5009}, {5817, 5278, 278, 
         1901}, {4692, 5404, 5403, 4691}},
         VertexColors->None], 
        PolygonBox[{{5818, 5423, 5422, 5815, 1901}, {5879, 6714, 2595, 4806, 
         5878}, {6718, 4809, 4808, 5427, 1610}, {4801, 6697, 1605, 5410, 
         4800}, {5350, 5344, 323, 5149, 5349}, {4851, 5557, 1610, 5426, 
         4850}, {5404, 5812, 1900, 5811, 5403}, {4135, 5867, 5866, 5007, 
         343}, {6692, 5844, 5843, 4799, 2585}, {5416, 4692, 4691, 5411, 
         1605}},
         VertexColors->None]}]}, 
     {RGBColor[0.8774745789467215, 0.8852952734632042, 0.8625811795469469], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{5419, 4694, 1609}, {6697, 4801, 2586}, {5402, 5812, 
         1604}, {4686, 5405, 1604}, {4692, 5416, 1607}, {6716, 6717, 2596}, {
         4809, 6718, 2596}, {5423, 5818, 1609}, {6698, 6696, 2586}, {5818, 
         5418, 1609}, {5812, 5404, 1604}, {5557, 4851, 1695}},
         VertexColors->None], 
        PolygonBox[{{5415, 4686, 1604, 1607}, {4143, 7628, 7627, 4142}, {4119,
          6693, 6692, 4118}, {5351, 5345, 5344, 5350}, {5345, 7622, 7621, 
         5344}, {7716, 7655, 7654, 7715}, {5011, 7610, 7609, 5010}, {4851, 
         5423, 1609, 1695}, {7622, 4119, 4118, 7621}, {4694, 5556, 1695, 
         1609}, {6715, 4143, 4142, 6714}, {5120, 5134, 5133, 5119}, {7628, 
         4136, 4135, 7627}, {7618, 5157, 5156, 7617}, {6693, 5845, 5844, 
         6692}, {7655, 7680, 7679, 7654}, {7610, 4917, 4916, 7609}, {5157, 
         5351, 5350, 5156}, {5404, 4692, 1607, 1604}, {7602, 7716, 7715, 
         7601}, {5134, 7618, 7617, 5133}, {4917, 7602, 7601, 4916}, {7680, 
         5120, 5119, 7679}, {5868, 5011, 5010, 5867}, {5880, 6715, 6714, 
         5879}, {4136, 5868, 5867, 4135}},
         VertexColors->None], 
        PolygonBox[{{5405, 4995, 4994, 5402, 1604}, {6717, 5880, 5879, 4809, 
         2596}, {4698, 6716, 2596, 6718, 4697}, {4995, 5419, 1609, 5418, 
         4994}, {5845, 6698, 2586, 4801, 5844}, {6696, 4688, 4687, 6697, 
         2586}, {4688, 5415, 1607, 5416, 4687}, {5556, 4698, 4697, 5557, 
         1695}},
         VertexColors->None]}]}, 
     {RGBColor[0.8969055015512224, 0.8917749683965375, 0.8538761436328143], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{4689, 4998, 1044}, {4143, 6715, 1942}, {5556, 4694, 
         1046}, {4686, 5415, 1044}, {6698, 5845, 1924}, {5000, 4695, 1046}, {
         5880, 6717, 1942}, {5845, 6693, 1924}, {6715, 5880, 1942}, {4688, 
         6696, 1044}, {6716, 4698, 1046}, {4695, 7631, 1046}, {7625, 4689, 
         1044}, {5415, 4688, 1044}, {4698, 5556, 1046}, {6693, 4119, 1924}},
         VertexColors->None], 
        PolygonBox[{{4918, 7603, 7602, 4917}, {7717, 7656, 7655, 7716}, {5846,
          7625, 1044, 1924}, {5135, 7619, 7618, 5134}, {5346, 7623, 7622, 
         5345}, {7656, 7681, 7680, 7655}, {7611, 4918, 4917, 7610}, {5352, 
         5346, 5345, 5351}, {5158, 5352, 5351, 5157}, {5869, 5012, 5011, 
         5868}, {5406, 4996, 4995, 5405}, {5121, 5135, 5134, 5120}, {6717, 
         6716, 1046, 1942}, {7603, 7717, 7716, 7602}, {7681, 5121, 5120, 
         7680}, {4137, 5869, 5868, 4136}, {7629, 4137, 4136, 7628}, {4996, 
         5420, 5419, 4995}, {7619, 5158, 5157, 7618}, {7631, 5876, 1942, 
         1046}, {5012, 7611, 7610, 5011}, {6696, 6698, 1924, 1044}},
         VertexColors->None], 
        PolygonBox[{{7623, 5846, 1924, 4119, 7622}, {5420, 5000, 1046, 4694, 
         5419}, {4998, 5406, 5405, 4686, 1044}, {5876, 7629, 7628, 4143, 
         1942}},
         VertexColors->None]}]}, 
     {RGBColor[0.9163364241557233, 0.8982546633298707, 0.8451711077186816], 
      EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{7630, 4138, 4137, 7629}, {4999, 5407, 5406, 4998}, {4997, 
        5421, 5420, 4996}, {5136, 7620, 7619, 5135}, {4919, 7604, 7603, 
        4918}, {7620, 5159, 5158, 7619}, {7632, 5877, 5876, 7631}, {5870, 
        5013, 5012, 5869}, {7682, 5122, 5121, 7681}, {5159, 5353, 5352, 
        5158}, {7604, 7718, 7717, 7603}, {5847, 7626, 7625, 5846}, {5353, 
        5347, 5346, 5352}, {5013, 7612, 7611, 5012}, {4696, 7632, 7631, 
        4695}, {5347, 7624, 7623, 5346}, {5407, 4997, 4996, 5406}, {5877, 
        7630, 7629, 5876}, {7718, 7657, 7656, 7717}, {7657, 7682, 7681, 
        7656}, {7624, 5847, 5846, 7623}, {4138, 5870, 5869, 4137}, {7612, 
        4919, 4918, 7611}, {5122, 5136, 5135, 5121}, {4690, 4999, 4998, 
        4689}, {7626, 4690, 4689, 7625}, {5001, 4696, 4695, 5000}, {5421, 
        5001, 5000, 5420}},
        VertexColors->None]]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{5421, 4997, 1435}, {5407, 4999, 1435}, {5347, 5353, 
         1572}, {3932, 3965, 1435}, {3936, 3963, 1572}, {4997, 5407, 1435}, {
         3968, 3967, 1940}, {3964, 3932, 1435}, {5870, 4138, 1940}, {5001, 
         5421, 1435}},
         VertexColors->None], 
        PolygonBox[{{4919, 7612, 3934, 3942}, {7630, 5877, 3969, 3946}, {7632,
          4696, 3939, 3947}, {7612, 5013, 3948, 3934}, {7718, 7604, 3930, 
         3961}, {7620, 5136, 3951, 3937}, {7657, 7718, 3961, 3956}, {5159, 
         7620, 3937, 3953}, {5136, 5122, 3950, 3951}, {7604, 4919, 3942, 
         3930}, {7626, 5847, 3966, 3945}, {5847, 7624, 3944, 3966}, {5877, 
         7632, 3947, 3969}, {7682, 7657, 3956, 3958}, {5122, 7682, 3958, 
         3950}, {4690, 7626, 3945, 3938}},
         VertexColors->None], 
        PolygonBox[{{5353, 5159, 3953, 3936, 1572}, {4999, 4690, 3938, 3964, 
         1435}, {5013, 5870, 1940, 3967, 3948}, {4696, 5001, 1435, 3965, 
         3939}, {4138, 7630, 3946, 3968, 1940}, {7624, 5347, 1572, 3963, 
         3944}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5013, 7612, 4919, 7604, 7718, 7657, 7682, 5122, 5136, 7620, 
         5159, 5353, 5347, 7624, 5847, 7626, 4690, 4999, 5407, 4997, 5421, 
         5001, 4696, 7632, 5877, 7630, 4138, 5870, 5013}],
        "6.02`"],
       Annotation[#, 6.02, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5012, 7611, 4918, 7603, 7717, 7656, 7681, 5121, 5135, 7619, 
         5158, 5352, 5346, 7623, 5846, 7625, 4689, 4998, 5406, 4996, 5420, 
         5000, 4695, 7631, 5876, 7629, 4137, 5869, 5012}],
        "5.59`"],
       Annotation[#, 5.59, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5011, 7610, 4917, 7602, 7716, 7655, 7680, 5120, 5134, 7618, 
         5157, 5351, 5345, 7622, 4119, 6693, 5845, 6698, 6696, 4688, 5415, 
         4686, 5405, 4995, 5419, 4694, 5556, 4698, 6716, 6717, 5880, 6715, 
         4143, 7628, 4136, 5868, 5011}],
        "5.16`"],
       Annotation[#, 5.16, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4801, 6697, 4687, 5416, 4692, 5404, 5812, 5402, 4994, 5418, 
         5818, 5423, 4851, 5557, 4697, 6718, 4809, 5879, 6714, 4142, 7627, 
         4135, 5867, 5010, 7609, 4916, 7601, 7715, 7654, 7679, 5119, 5133, 
         7617, 5156, 5350, 5344, 7621, 4118, 6692, 5844, 4801}],
        "4.7299999999999995`"],
       Annotation[#, 4.7299999999999995`, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5410, 4800, 5843, 4799, 6695, 4114, 6309, 4117, 5149, 5349, 
         5155, 7616, 5132, 5118, 7678, 7653, 7714, 7600, 4915, 7608, 5009, 
         5866, 5007, 4141, 6324, 5071, 6713, 4806, 5878, 4808, 5427, 5963, 
         5425, 5554, 5426, 4850, 5422, 5815, 5817, 5278, 4089, 5267, 5814, 
         5811, 5403, 4691, 5411, 5413, 5409, 5950, 5410}],
        "4.3`"],
       Annotation[#, 4.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7607, 5008, 5865, 5006, 4140, 6323, 5070, 6712, 5074, 4807, 
         5080, 5960, 5962, 5424, 5552, 5553, 5282, 4849, 5279, 5816, 5277, 
         5810, 5808, 5809, 5266, 5813, 5268, 4693, 5272, 5414, 5412, 5408, 
         5949, 5948, 5182, 4802, 4975, 6694, 4113, 6308, 4116, 5148, 5348, 
         5154, 7615, 5131, 5117, 7677, 7652, 7713, 7599, 4914, 7607}],
        "3.87`"],
       Annotation[#, 3.87, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5527, 5281, 5958, 4191, 5386, 4190, 5078, 5961, 5079, 5531, 
         5530, 4389, 5073, 4488, 6325, 4139, 5875, 5017, 6281, 4222, 5213, 
         5221, 4913, 7598, 7712, 7651, 7676, 5116, 5130, 5369, 5361, 4422, 
         6223, 5153, 5841, 4115, 6310, 4481, 4974, 6202, 4972, 5523, 5524, 
         5181, 5951, 5179, 4188, 5382, 4189, 5954, 5274, 5526, 4525, 5417, 
         4524, 5400, 4684, 5271, 4683, 5284, 4685, 5401, 4528, 5555, 4529, 
         5527}],
        "3.44`"],
       Annotation[#, 3.44, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5280, 4805, 5528, 4986, 5299, 5300, 5285, 5283, 5399, 5269, 
         5270, 5298, 5297, 4985, 5525, 4803, 5273, 5952, 5953, 5381, 5947, 
         5946, 5180, 4454, 5522, 4971, 6201, 4973, 4480, 5842, 6313, 5840, 
         5152, 6222, 4421, 5360, 5368, 5129, 5115, 7675, 7650, 7711, 7597, 
         4912, 5220, 5212, 4221, 6280, 5016, 5873, 6329, 5874, 4487, 5072, 
         4388, 5529, 4391, 5081, 5955, 5956, 5385, 5959, 5957, 5280}],
        "3.01`"],
       Annotation[#, 3.01, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4106, 5828, 5829, 5827, 6968, 4105, 5451, 4104, 6967, 6966, 
         7477, 7476, 4628, 6513, 6515, 6514, 5768, 5767, 4370, 6162, 6877, 
         5755, 5754, 5753, 4355, 6153, 6870, 5741, 5740, 5739, 4337, 6143, 
         6864, 5724, 5723, 5722, 4325, 6126, 6859, 4019, 4057, 5717, 5716, 
         6114, 6113, 4014, 4053, 5711, 5710, 6099, 6098, 4008, 4050, 5696, 
         5695, 6079, 6078, 4001, 4046, 5682, 5681, 6059, 6058, 3996, 6847, 
         5676, 5675, 5674, 4300, 6044, 6842, 5669, 5668, 5667, 4296, 6032, 
         6840, 5657, 5656, 5655, 4282, 6015, 6835, 5642, 5641, 5640, 4264, 
         6401, 6402, 7216, 7215, 4558, 7213, 7214, 6928, 6929, 4077, 7464, 
         4076, 4952, 4837, 5548, 5547, 4903}],
        "2.58`"],
       Annotation[#, 2.58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5911, 4489, 6328, 5872, 5015, 6279, 4220, 5211, 5219, 4911, 
         7596, 7710, 7649, 7674, 5114, 5128, 5367, 5359, 4420, 6221, 5151, 
         5839, 6312, 4482, 5898, 6994, 5893, 6200, 7157, 7158, 6203, 4453, 
         6199, 4798, 5788, 6691, 6690, 4656, 6702, 6703, 6699, 6701, 6700, 
         4186, 7197, 7198, 6388, 4546, 5265, 5264, 4207, 5275, 5276, 4547, 
         6389, 6392, 6391, 4187, 7442, 7443, 6709, 6711, 6710, 4658, 6707, 
         6708, 6704, 4804, 4946, 4944, 5567, 4390, 5077, 5914, 5911}],
        "2.58`"],
       Annotation[#, 2.58, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3985, 6829, 7539, 4248, 7043, 4249, 5996, 4557, 7210, 7212, 
         7211, 4263, 5637, 5638, 5639, 6834, 6014, 4281, 5652, 5653, 5654, 
         6839, 6031, 4295, 5664, 5665, 5666, 6841, 3991, 6042, 6043, 5672, 
         5673, 4041, 3995, 6056, 6057, 5679, 5680, 4045, 4000, 6074, 6075, 
         5693, 5694, 4049, 4007, 6094, 6095, 5708, 5709, 4052, 4013, 6111, 
         6112, 5714, 5715, 4056, 4018, 6124, 6125, 5720, 5721, 4061, 4026, 
         6863, 6142, 4336, 5736, 5737, 5738, 6869, 6152, 4354, 5750, 5751, 
         5752, 6876, 6161, 4369, 5765, 5766, 7281, 7282, 7280, 4627, 6512, 
         7570, 4380, 7126, 4381, 6174, 4631}],
        "2.15`"],
       Annotation[#, 2.15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6327, 5910, 5915, 4161, 5075, 6783, 5076, 4873, 4945, 7587, 
         4071, 6706, 4070, 6922, 6705, 5798, 4659, 6547, 4442, 5175, 5944, 
         5945, 5004, 6390, 5005, 4527, 6260, 4526, 6368, 4545, 5263, 4521, 
         5343, 4522, 5106, 6387, 5105, 5943, 5942, 5107, 4409, 6539, 4655, 
         5782, 5787, 6914, 4066, 6689, 6197, 6198, 5784, 5894, 5892, 4158, 
         6995, 5897, 6314, 6311, 5838, 5150, 6220, 4419, 5358, 5366, 5127, 
         5113, 7673, 7648, 7709, 7595, 4910, 5218, 5210, 4219, 6278, 5014, 
         5871, 6326, 6327}],
        "2.15`"],
       Annotation[#, 2.15, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3984, 6828, 7538, 4246, 7042, 4247, 5995, 4556, 6400, 7542, 
         4261, 7057, 4262, 7227, 7228, 6832, 6833, 6013, 4280, 5649, 5650, 
         5651, 6838, 6030, 4294, 5662, 5663, 4036, 3990, 6040, 6041, 5670, 
         5671, 4040, 3994, 5039, 6853, 6852, 5602, 4587, 5041, 5040, 7242, 
         6447, 6448, 6073, 6077, 6076, 7245, 6453, 6454, 6093, 6097, 6096, 
         6466, 5048, 5049, 4598, 6474, 4597, 7254, 4055, 4017, 6122, 6123, 
         5718, 5719, 4060, 4025, 6140, 6141, 5733, 5734, 5735, 6868, 6151, 
         4353, 5747, 5748, 5749, 6875, 7274, 7275, 7113, 7112, 4367, 7114, 
         4368, 6160, 4626, 6511, 7569, 4378, 7125, 4379, 6173, 4630}],
        "1.72`"],
       Annotation[#, 1.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6219, 4458, 6207, 4457, 6756, 6757, 5896, 6751, 6749, 5475, 
         4157, 5890, 5891, 6176, 7127, 6175, 5785, 5786, 4766, 6649, 6648, 
         5783, 4654, 6538, 4410, 5471, 4957, 4958, 4523, 4956, 4955, 5455, 
         4408, 5320, 5321, 4637, 5342, 4638, 7289, 4639, 7290, 6520, 6261, 
         7590, 4469, 6259, 6263, 6262, 4214, 5491, 4213, 5002, 4530, 4966, 
         4965, 5492, 4441, 6549, 4660, 5797, 5799, 5800, 4773, 6810, 4894, 
         6227, 6811, 7588, 6812, 4895, 7494, 4896, 6813, 4875, 7485, 7486, 
         6999, 6998, 4162, 6782, 6770, 6771, 5913, 6779, 6776, 4472, 7169, 
         4473, 6277, 4218, 5209, 5217, 4909, 7594, 7708, 7647, 7672, 5112, 
         5126, 5365, 5357, 4418, 6219}],
        "1.72`"],
       Annotation[#, 1.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3983, 6827, 7537, 4244, 7041, 4245, 5994, 4555, 6399, 7541, 
         4259, 7056, 4260, 6411, 4566, 6410, 6831, 6012, 4279, 5646, 5647, 
         5648, 6837, 6029, 4293, 5660, 5661, 4035, 3989, 5302, 5303, 4584, 
         6432, 4583, 6433, 5034, 7239, 6434, 6435, 6053, 6055, 6054, 6445, 
         6446, 6071, 4310, 5690, 4311, 6072, 4593, 6091, 4317, 5706, 4318, 
         6092, 7249, 7248, 6464, 6465, 6108, 6110, 6109, 6475, 5053, 5617, 
         5616, 5615, 4607, 4943, 4059, 4024, 6138, 6139, 5730, 5731, 5732, 
         6867, 6150, 4352, 5744, 5745, 5746, 6874, 7273, 4623, 7579, 6873, 
         4365, 7111, 4366, 6159, 4625, 6510, 7568, 4376, 7124, 4377, 6172, 
         4629}],
        "1.29`"],
       Annotation[#, 1.29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5863, 4753, 5825, 4092, 5448, 4091, 5824, 4755, 5881, 6981, 
         4144, 5174, 7307, 7308, 6548, 6551, 6550, 4165, 5183, 5184, 5507, 
         7509, 5506, 5585, 4893, 6814, 4899, 6615, 7356, 7357, 5568, 7487, 
         7488, 6784, 6786, 6785, 4874, 6772, 6781, 4855, 5912, 4856, 6778, 
         4471, 7168, 7170, 6276, 6273, 4217, 5208, 5216, 4908, 7593, 7707, 
         7646, 7671, 5111, 5125, 5364, 5356, 4417, 6218, 6226, 6206, 4456, 
         6759, 4845, 5895, 4843, 6750, 5474, 6993, 6992, 7404, 7406, 7405, 
         6665, 6177, 4383, 5501, 5502, 5057, 5056, 4153, 6536, 6537, 6533, 
         6535, 6534, 5108, 4126, 5854, 5853, 4741, 5316, 5315, 5314, 4084, 
         5807, 4727, 5837, 6975, 4112, 5104, 5319, 7422, 4778, 7421, 4779, 
         5513, 5512, 4171, 5514, 5515, 4781, 7423, 4780, 7424, 4133, 5003, 
         4134, 5864, 5863}],
        "1.29`"],
       Annotation[#, 1.29, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3982, 6825, 6826, 7040, 7039, 4243, 5993, 4554, 6398, 7540, 
         4257, 7055, 4258, 6005, 4565, 7224, 7226, 7225, 4278, 5643, 5644, 
         5645, 6836, 6028, 4292, 5658, 5659, 4034, 3988, 5301, 6846, 6845, 
         5597, 4581, 5305, 5304, 5310, 5311, 5037, 4302, 5341, 4303, 5038, 
         4586, 6442, 6444, 6443, 4309, 5689, 5691, 5692, 6855, 6090, 4316, 
         5705, 5707, 6462, 6463, 6461, 4594, 5046, 4321, 5375, 4322, 5047, 
         5335, 5334, 5051, 5052, 4606, 7260, 4605, 7578, 6905, 6906, 4058, 
         4023, 6136, 6137, 5727, 5728, 5729, 6866, 6149, 4351, 5742, 5743, 
         7271, 7272, 7270, 4622, 6503, 7566, 4363, 7110, 4364, 6158, 4624, 
         6509, 7567, 4375, 7122, 7123, 6171, 6170, 6517}],
        "0.86`"],
       Annotation[#, 0.86, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6780, 6582, 6584, 4706, 5458, 5459, 4863, 5457, 5456, 4120, 
         6672, 6673, 6671, 6675, 6674, 4712, 6602, 6603, 5826, 6958, 6283, 
         4474, 6282, 6285, 6284, 4196, 7376, 7377, 7374, 4754, 7375, 6570, 
         6571, 6569, 6573, 6572, 4703, 6575, 6576, 6574, 6920, 6919, 4069, 
         6921, 6189, 4413, 6188, 4414, 6366, 6367, 6363, 6365, 6364, 4085, 
         6940, 6941, 6360, 6362, 6361, 4412, 7143, 4411, 7507, 6614, 7354, 
         7353, 6565, 6566, 6564, 6568, 6567, 4590, 5317, 5318, 4889, 4904, 
         4003, 6617, 4740, 6616, 6619, 6618, 4183, 6235, 6236, 6234, 7167, 
         4462, 7573, 6936, 6937, 6935, 7466, 7465, 4674, 6651, 6652, 6650, 
         7401, 7400, 5055, 6661, 6662, 6660, 6664, 6663, 4746, 6755, 4844, 
         6753, 6942, 6215, 6758, 4455, 6205, 6225, 6217, 4416, 5355, 5363, 
         5124, 5110, 7670, 7645, 7706, 7592, 4907, 5215, 5207, 4216, 6272, 
         6275, 6265, 7171, 4470, 6777, 6774, 6954, 7470, 7472, 7471, 6780}],
        "0.86`"],
       Annotation[#, 0.86, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3981, 6823, 6824, 5990, 5992, 5991, 7209, 6396, 6397, 6002, 
         6004, 6003, 7223, 4564, 6409, 7547, 4276, 7071, 4277, 6011, 4573, 
         7230, 4574, 7231, 4210, 5337, 4633, 7287, 4634, 4827, 7496, 3987, 
         6684, 4774, 6683, 6682, 5596, 4580, 6816, 4901, 6815, 4900, 4902, 
         7514, 4582, 5577, 5578, 5309, 5308, 4082, 5340, 7288, 4635, 6519, 
         4636, 7461, 4831, 6850, 6851, 6559, 4676, 6558, 4677, 6560, 4644, 
         7293, 4645, 6898, 6899, 4048, 4006, 7333, 7334, 7332, 4702, 7335, 
         4648, 6526, 4649, 6525, 6900, 6901, 4012, 4931, 4665, 5805, 6925, 
         6926, 5374, 5376, 7348, 4722, 7347, 4723, 5453, 5452, 4109, 7499, 
         4721, 4447, 7153, 4448, 7154, 4239, 7031, 4238, 7536, 6902, 6903, 
         6904, 4022, 6862, 6135, 4335, 5725, 5726, 6496, 4615, 6494, 4614, 
         6495, 7563, 4349, 7100, 4350, 6148, 4621, 7269, 6501, 6502, 6155, 
         6157, 6156, 7279, 6507, 6508, 6167, 6169, 6168, 6516}],
        "0.43`"],
       Annotation[#, 0.43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6354, 5935, 5936, 7019, 4797, 7441, 6802, 7586, 6803, 4879, 
         7532, 7533, 7493, 7492, 4826, 7459, 4825, 7460, 4885, 7439, 4794, 
         7438, 4795, 5521, 5520, 7018, 7017, 7440, 4796, 7582, 7016, 6688, 
         7141, 7142, 6532, 7497, 6531, 7304, 5379, 5380, 4739, 7365, 7367, 
         7366, 4079, 5394, 4080, 4725, 7352, 4726, 5339, 5338, 5546, 4883, 
         7535, 4884, 5391, 5390, 6556, 6557, 6357, 4518, 5941, 6358, 6359, 
         4519, 5054, 4382, 4790, 7504, 4184, 5395, 4840, 4452, 7500, 4111, 
         4777, 7004, 7005, 4169, 5511, 6734, 6620, 6621, 5855, 6979, 5472, 
         4742, 6624, 4747, 7368, 4745, 6754, 6752, 6943, 4086, 6213, 6214, 
         6204, 6224, 6216, 4415, 5354, 5362, 5123, 5109, 7669, 7644, 7705, 
         7591, 4906, 5214, 5206, 4215, 6271, 6274, 6264, 6775, 6773, 4095, 
         6955, 6580, 6583, 4704, 6577, 4705, 6581, 7294, 7355, 4728, 7580, 
         7296, 4647, 7297, 7298, 6524, 6523, 6735, 6798, 4174, 4980, 4897, 
         7463, 7462, 6984, 6983, 7174, 7173, 7340, 5449, 4197, 7021, 7020, 
         4818, 7450, 4397, 5097, 4535, 7013, 7012, 7185, 4511, 7030, 4206, 
         5544, 5545, 4823, 7524, 4822, 4150, 4871, 7531, 4872, 4760, 6641, 
         4759, 6642, 4094, 5332, 4093, 6744, 6745, 6806, 6805, 4836, 6800, 
         6801, 6799, 7491, 7490, 6746, 6353, 6354}],
        "0.43`"],
       Annotation[#, 0.43, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3980, 7035, 7036, 7034, 7038, 7037, 7208, 7051, 7052, 7050, 
         7054, 7053, 7222, 7067, 7068, 7066, 7070, 7069, 7229, 4838, 7526, 
         4839, 4670, 7320, 7321, 7317, 7319, 7318, 7322, 4865, 7529, 4866, 
         4730, 7361, 7362, 7358, 7360, 7359, 4078, 6933, 6934, 6613, 6612, 
         7351, 4724, 6972, 6973, 6974, 5454, 4110, 6971, 6970, 7350, 7349, 
         4178, 5579, 4179, 4983, 5940, 4177, 6355, 6356, 5939, 5938, 5937, 
         4517, 5101, 5100, 4039, 6844, 6843, 5595, 4579, 4776, 7521, 4775, 
         6932, 6931, 6930, 4399, 7133, 5781, 4991, 7589, 4212, 5392, 5393, 
         4990, 4989, 4044, 3999, 6186, 4403, 6185, 4404, 7140, 4406, 7139, 
         4405, 6187, 7554, 4307, 7081, 4308, 6070, 4589, 5103, 4407, 5551, 
         4953, 4954, 4514, 7188, 4515, 7189, 4315, 5586, 4939, 4940, 5605, 
         4011, 5173, 6858, 6857, 5607, 4833, 4858, 7527, 4857, 4860, 7528, 
         4859, 5566, 4663, 7516, 4891, 4664, 5262, 4516, 5587, 4981, 4982, 
         4533, 7192, 4534, 7193, 4234, 5608, 5609, 5610, 4544, 6386, 4020, 
         4934, 4536, 7024, 7025, 7026, 7200, 7199, 4199, 4987, 4880, 7505, 
         4201, 5574, 4200, 7310, 7311, 7309, 4666, 5389, 6989, 6988, 6987, 
         4765, 7394, 4236, 5983, 6963, 6962, 4102, 7455, 7456, 7454, 7458, 
         7457, 4824, 4882, 7534, 4881, 7453, 7433, 7434, 7432, 7436, 7435, 
         4667, 4669, 7517, 4668, 7262, 7096, 7097, 7095, 7099, 7098, 7268, 
         7106, 7107, 7105, 7109, 7108, 7278, 7118, 7119, 7117, 7121, 7120, 
         7283}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5832, 4652, 6530, 4653, 6337, 4496, 5924, 6338, 6339, 4497, 
         7510, 4498, 4495, 7182, 4494, 7575, 6393, 7576, 4548, 6394, 4549, 
         7201, 4550, 7202, 4209, 5575, 4208, 7506, 4886, 5289, 5288, 4180, 
         4984, 4878, 7503, 4182, 5573, 4181, 7302, 7303, 7301, 4650, 6184, 
         4124, 6183, 4400, 7163, 7164, 7160, 7162, 7161, 7484, 7396, 7397, 
         7395, 7399, 7398, 4731, 4733, 7519, 4732, 4081, 4735, 7520, 4736, 
         4734, 5468, 5469, 4830, 5583, 5584, 4898, 5582, 5581, 5503, 5476, 
         5477, 4887, 5479, 5478, 4744, 6631, 6633, 6623, 6628, 6627, 4088, 
         6242, 6245, 6212, 6253, 6249, 4431, 5193, 5202, 5147, 7693, 7668, 
         7643, 7704, 7729, 4930, 5239, 5230, 4231, 6294, 6303, 6270, 6289, 
         6287, 4097, 6585, 6587, 6579, 6591, 6590, 4646, 6637, 6639, 6634, 
         6636, 6635, 7489, 6796, 6797, 6676, 6678, 6677, 4761, 6646, 6647, 
         6643, 6645, 6644, 4101, 7388, 7389, 7387, 7391, 7390, 4762, 7385, 
         7386, 7382, 7384, 7383, 7420, 7178, 7179, 7177, 7181, 7180, 4237, 
         5984, 4152, 6193, 7313, 7314, 7312, 7316, 7315, 4202, 5580, 4203, 
         4988, 5934, 4176, 6732, 6733, 5933, 5932, 5931, 4788, 5614, 4021, 
         5178, 6196, 4449, 6195, 4450, 4538, 7511, 4537, 4108, 7498, 4451, 
         4320, 5031, 4235, 5325, 5326, 4888, 6804, 5611, 5612, 5099, 5030, 
         5172, 4439, 5576, 4440, 7152, 4446, 7151, 4445, 5823, 5822, 6192, 
         7147, 7146, 7145, 5836, 6969, 5835, 7135, 7137, 7138, 7136, 6351, 
         6352, 4512, 7186, 4513, 7187, 4402, 7134, 4401, 7571, 6194, 7156, 
         7155, 5102, 6611, 4715, 6610, 4716, 4718, 7518, 4717, 5834, 5833, 
         5832}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4031, 4064, 6913, 6912, 7116, 7115, 4029, 4062, 6911, 6910, 
         7104, 7103, 4028, 6909, 6908, 6907, 4348, 7094, 4027, 6865, 4613, 
         7261, 4334, 7088, 4333, 7515, 6488, 6687, 6686, 7428, 4785, 6485, 
         4603, 6484, 4604, 6737, 4835, 6736, 4834, 4933, 4932, 5549, 5550, 
         5447, 5446, 4090, 6807, 6808, 4964, 4963, 5564, 4720, 7480, 4862, 
         7479, 4861, 6562, 4681, 6561, 4682, 6563, 4680, 7346, 4719, 7343, 
         7345, 7344, 7478, 7329, 7330, 7328, 4679, 7331, 4678, 6748, 4842, 
         6747, 4841, 7469, 4992, 4993, 4651, 5780, 6739, 6740, 6742, 6741, 
         4065, 7324, 4671, 7323, 4672, 5307, 5306, 4828, 7525, 4829, 6894, 
         6893, 4299, 7080, 4211, 5592, 5593, 5594, 4673, 6555, 6424, 6425, 
         6027, 4291, 7078, 4290, 7077, 7577, 4572, 7513, 7512, 6892, 6891, 
         6890, 4275, 7065, 3986, 4033, 6889, 6888, 7049, 7048, 3979, 4032, 
         6887, 6886, 7033, 7032, 7207}],
        RowBox[{"-", "0.43`"}]],
       Annotation[#, -0.43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6350, 6348, 6731, 7027, 7585, 4821, 7452, 7028, 7029, 5372, 
         5373, 4643, 6895, 6896, 6897, 4005, 7426, 4782, 7425, 4783, 5517, 
         5516, 7011, 7010, 7427, 4784, 7581, 7009, 6685, 7148, 7150, 7149, 
         5852, 5851, 4123, 5465, 5466, 4864, 7481, 7483, 7482, 5467, 5327, 
         4100, 7393, 4763, 7392, 4764, 5500, 5499, 4151, 4786, 7522, 4787, 
         5519, 5518, 4175, 5930, 5929, 4510, 7184, 6375, 6376, 4539, 5098, 
         4398, 7451, 4819, 7022, 7023, 4198, 5450, 7475, 7175, 7176, 6985, 
         6986, 7416, 7417, 7002, 7003, 4167, 5508, 4166, 5920, 5921, 7379, 
         7380, 7378, 6640, 7381, 4757, 6638, 7295, 6592, 4709, 6578, 4707, 
         6588, 6586, 6957, 4096, 6286, 6288, 6269, 6302, 6293, 4230, 5229, 
         5238, 4929, 7728, 7703, 7642, 7667, 7692, 5146, 5201, 5192, 4430, 
         6248, 6252, 6211, 6244, 6241, 4087, 6945, 6630, 6768, 4748, 6622, 
         4749, 6632, 4743, 5480, 5473, 5856, 6625, 7369, 6626, 5889, 5888, 
         4154, 5470, 4155, 6991, 6990, 7403, 7402, 6978, 6977, 7166, 7165, 
         7325, 5398, 4185, 7015, 7014, 4793, 7437, 4976, 4977, 4520, 7008, 
         7007, 7006, 4499, 7183, 7468, 7467, 5396, 5397, 4792, 7523, 4791, 
         4125, 4867, 7530, 4868, 4738, 7363, 4737, 7364, 4083, 5312, 5313, 
         7430, 7431, 7429, 4789, 5384, 5383, 6743, 6349, 7502, 6350}],
        RowBox[{"-", "0.43`"}]],
       Annotation[#, -0.43, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4030, 4063, 5779, 5778, 4374, 6166, 6882, 5764, 5763, 5762, 
         4362, 6154, 6872, 6871, 7267, 7266, 4347, 7093, 4346, 7562, 6493, 
         4612, 6134, 4332, 7087, 6133, 6487, 6486, 7259, 5333, 6481, 4601, 
         6480, 4602, 5329, 5328, 4016, 5606, 4942, 4941, 5445, 4319, 5045, 
         5604, 5603, 6460, 6459, 4314, 5700, 4313, 6089, 4588, 6069, 4306, 
         5686, 4305, 6440, 6441, 5601, 6849, 4938, 4937, 5378, 4301, 5036, 
         5591, 3993, 4038, 4935, 4578, 5588, 5589, 5590, 6554, 6553, 6423, 
         6025, 6026, 6024, 7076, 4289, 7552, 6416, 4571, 6010, 4274, 7064, 
         4273, 7062, 7063, 7221, 7220, 6830, 5636, 5635, 5634, 4256, 6001, 
         6822, 5629, 5628, 5627, 5989, 5988, 6395}],
        RowBox[{"-", "0.86`"}]],
       Annotation[#, -0.86, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6767, 4848, 6629, 6944, 6243, 6765, 4466, 6210, 6251, 6247, 
         4429, 5191, 5200, 5145, 7691, 7666, 7641, 7702, 7727, 4928, 5237, 
         5228, 4229, 6292, 6301, 6268, 4477, 6601, 6290, 6956, 7337, 7339, 
         7338, 6597, 6589, 7336, 4708, 5495, 5496, 4870, 5494, 5493, 5094, 
         7418, 7419, 6679, 6681, 6680, 4714, 7473, 7474, 6959, 6961, 6960, 
         7572, 4461, 7159, 6231, 6233, 6232, 4205, 5542, 5543, 4892, 6809, 
         5703, 5704, 5460, 5461, 4890, 5463, 5462, 4713, 6607, 6608, 6604, 
         6606, 6605, 4074, 6924, 6923, 7508, 4437, 7144, 4438, 6346, 6347, 
         6345, 6385, 6384, 7196, 6380, 6381, 6379, 6383, 6382, 4436, 6190, 
         4435, 6191, 6918, 4068, 6916, 6917, 6544, 6546, 6545, 4591, 5485, 
         5486, 4832, 4905, 4004, 7371, 4751, 7370, 7373, 7372, 4170, 6239, 
         6240, 6237, 4463, 6238, 6939, 6938, 7327, 7326, 4675, 6658, 6659, 
         6655, 6657, 6656, 5058, 7407, 7408, 6666, 6669, 6668, 4750, 6767}],
        RowBox[{"-", "0.86`"}]],
       Annotation[#, -0.86, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4553, 5987, 4242, 5624, 5625, 5626, 6821, 6000, 4255, 5632, 
         5633, 6408, 4563, 6406, 4562, 6407, 7546, 4271, 7061, 4272, 6009, 
         4570, 6415, 7551, 4288, 7075, 6021, 6023, 6022, 6422, 5032, 5033, 
         4577, 6430, 4576, 7238, 4037, 3992, 6051, 6052, 5677, 5678, 4043, 
         3998, 6848, 6068, 4304, 5685, 5687, 5688, 6854, 6088, 4312, 5699, 
         5701, 5702, 6856, 4010, 6106, 6107, 5712, 5713, 4054, 4015, 5050, 
         6861, 6860, 5613, 4600, 5331, 5330, 7258, 6482, 6483, 6131, 7086, 
         4331, 6132, 4611, 6492, 7561, 4344, 7092, 4345, 6147, 4619, 6499, 
         4620, 6500, 4361, 5759, 5760, 5761, 6881, 6165, 4373, 5775, 5776, 
         5777, 6885}],
        RowBox[{"-", "1.29`"}]],
       Annotation[#, -1.29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5442, 4769, 7412, 4768, 7413, 4131, 5490, 4132, 7501, 4869, 
         5489, 5488, 4699, 6769, 4852, 5819, 5820, 5821, 5558, 5483, 5484, 
         4752, 5857, 6980, 4127, 5170, 7305, 7306, 6540, 6543, 6542, 4156, 
         5059, 5060, 5505, 5504, 4384, 6178, 7409, 7410, 7411, 6667, 5908, 
         5909, 5482, 6762, 4846, 5902, 4847, 6764, 4465, 6209, 6250, 6246, 
         4428, 5190, 5199, 5144, 7690, 7665, 7640, 7701, 7726, 4927, 5236, 
         5227, 4228, 6291, 6300, 6267, 4476, 6600, 4711, 5917, 4710, 6596, 
         6594, 4772, 6794, 6795, 6791, 6793, 6792, 5572, 4756, 5497, 4396, 
         5509, 5510, 5096, 5095, 4168, 5922, 5923, 5848, 6976, 4121, 5177, 
         4122, 5850, 5849, 4729, 4967, 4098, 5565, 4099, 4970, 4758, 5887, 
         6982, 4149, 5029, 4148, 7415, 4770, 7414, 4771, 5444, 5443, 5563, 
         5441, 5442}],
        RowBox[{"-", "1.29`"}]],
       Annotation[#, -1.29, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4552, 5986, 4241, 5621, 5622, 5623, 6820, 5999, 4254, 5630, 
         5631, 7218, 7219, 7217, 4561, 6405, 7545, 4269, 7060, 4270, 6008, 
         4569, 6414, 7550, 4287, 7074, 6018, 6020, 6019, 7234, 6420, 6421, 
         6037, 6039, 6038, 6431, 5035, 5600, 5599, 5598, 4585, 4936, 4042, 
         3997, 6064, 6065, 5683, 5684, 4047, 4002, 6084, 6085, 5697, 5698, 
         4051, 4009, 5042, 5043, 4596, 6468, 4595, 6469, 5044, 7253, 6472, 
         6473, 6119, 6121, 6120, 7257, 6478, 6479, 6129, 7085, 4330, 6130, 
         4610, 6491, 7560, 4342, 7091, 4343, 6146, 4618, 7263, 7265, 7264, 
         4360, 5756, 5757, 5758, 6880, 6164, 4372, 5772, 5773, 5774, 6884}],
        RowBox[{"-", "1.72`"}]],
       Annotation[#, -1.72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4478, 6299, 4227, 5226, 5235, 4926, 7725, 7700, 7639, 7664, 
         7689, 5143, 5198, 5189, 4427, 6258, 4467, 6208, 4464, 6763, 6766, 
         5901, 6761, 6760, 5481, 4160, 5906, 5907, 7129, 7130, 7128, 6653, 
         6654, 4767, 5793, 5792, 5790, 4657, 6541, 4433, 5487, 4961, 4962, 
         4502, 4960, 4959, 5428, 4432, 5204, 5205, 4640, 5371, 4468, 5203, 
         4486, 6322, 7574, 4479, 7172, 6305, 6307, 6306, 4233, 5498, 4232, 
         5026, 4507, 4969, 4968, 5464, 4444, 6229, 4460, 5802, 4459, 6230, 
         6228, 4493, 4951, 4950, 5569, 5570, 4877, 6787, 6790, 6789, 4163, 
         6670, 6593, 6595, 5916, 6599, 6598, 4475, 6266, 4478}],
        RowBox[{"-", "1.72`"}]],
       Annotation[#, -1.72, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4551, 5985, 4240, 5618, 5619, 5620, 6819, 7205, 7206, 7046, 
         7045, 4252, 7047, 4253, 5998, 4560, 6404, 7544, 4267, 7059, 4268, 
         6007, 4568, 6413, 7549, 4285, 7073, 4286, 6017, 7233, 7232, 6418, 
         6419, 6034, 6036, 6035, 7237, 6428, 6429, 6048, 6050, 6049, 7241, 
         6438, 6439, 6063, 6067, 6066, 7244, 6451, 6452, 6083, 6087, 6086, 
         7247, 6457, 6458, 6103, 6105, 6104, 7252, 6470, 6471, 6116, 6118, 
         6117, 7255, 7256, 6477, 7557, 4328, 7084, 4329, 6128, 4609, 6490, 
         7559, 4340, 7090, 4341, 6145, 4617, 6498, 7565, 4358, 7102, 4359, 
         7276, 7277, 6878, 6879, 6163, 4371, 5769, 5770, 5771, 6883}],
        RowBox[{"-", "2.15`"}]],
       Annotation[#, -2.15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5176, 4443, 6552, 4661, 5801, 5803, 4073, 6719, 4072, 4949, 
         4876, 5093, 6788, 5091, 4164, 7001, 5919, 6336, 6333, 5884, 5023, 
         6298, 4226, 5225, 5234, 4925, 7724, 7699, 7638, 7663, 7688, 5142, 
         5197, 5188, 4426, 6257, 5167, 5860, 6318, 6319, 5900, 6997, 4159, 
         5903, 5904, 5789, 5795, 6915, 4067, 6369, 6340, 6341, 5791, 4500, 
         6343, 4434, 5171, 5925, 5926, 5168, 6727, 5169, 4592, 5370, 7291, 
         4641, 6521, 4642, 7292, 6522, 6344, 4505, 6304, 4506, 5028, 6377, 
         5027, 5928, 5927, 5176}],
        RowBox[{"-", "2.15`"}]],
       Annotation[#, -2.15, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4107, 5830, 5831, 5806, 6927, 4075, 5336, 4632, 7284, 7286, 
         7285, 6518, 7203, 7204, 6818, 7495, 6817, 4250, 7044, 4251, 5997, 
         4559, 6403, 7543, 4265, 7058, 4266, 6006, 4567, 6412, 7548, 4283, 
         7072, 4284, 6016, 4575, 6417, 7553, 4297, 7079, 4298, 6033, 7236, 
         7235, 6426, 6427, 6045, 6047, 6046, 7240, 6436, 6437, 6060, 6062, 
         6061, 7243, 6449, 6450, 6080, 6082, 6081, 7246, 6455, 6456, 6100, 
         6102, 6101, 7250, 7251, 6467, 7555, 4323, 7082, 4324, 6115, 4599, 
         6476, 7556, 4326, 7083, 4327, 6127, 4608, 6489, 7558, 4338, 7089, 
         4339, 6144, 4616, 6497, 7564, 4356, 7101, 4357, 6505, 6506, 6504, 
         6609, 7341, 7342, 6964, 6965, 4103, 5377, 7299, 7300, 6527, 6529, 
         6528, 6738}],
        RowBox[{"-", "2.58`"}]],
       Annotation[#, -2.58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5899, 4485, 6321, 5859, 5166, 6256, 4425, 5187, 5196, 5141, 
         7687, 7662, 7637, 7698, 7723, 4924, 5233, 5224, 4225, 6297, 5022, 
         5883, 6335, 4492, 5918, 7000, 5092, 4395, 5571, 4947, 4948, 4813, 
         5804, 6721, 6720, 4662, 6725, 6726, 6722, 6724, 6723, 4173, 7194, 
         7195, 6378, 4543, 5252, 5251, 5324, 5322, 5323, 4820, 6728, 6730, 
         6729, 4172, 7190, 7191, 6372, 6374, 6373, 4501, 6370, 6371, 6342, 
         4531, 5796, 5794, 6179, 7132, 7131, 6182, 5905, 6996, 5899}],
        RowBox[{"-", "2.58`"}]],
       Annotation[#, -2.58, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5246, 4532, 5287, 4978, 5540, 5541, 5250, 5248, 4204, 5256, 
         5257, 5296, 5295, 4979, 5538, 4817, 5261, 5979, 5980, 5388, 5974, 
         5973, 5088, 4394, 5536, 4393, 5086, 4491, 5886, 6334, 5882, 5021, 
         6296, 4224, 5223, 5232, 4923, 7722, 7697, 7636, 7661, 7686, 5140, 
         5195, 5186, 4424, 6255, 5165, 5858, 6320, 5861, 4484, 5064, 6181, 
         4386, 5533, 4387, 5069, 5964, 5965, 5241, 5968, 5966, 5246}],
        RowBox[{"-", "3.01`"}]],
       Annotation[#, -3.01, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5286, 5245, 5967, 4193, 5240, 4192, 5066, 5970, 5068, 5534, 
         5532, 4385, 6180, 5063, 4483, 6317, 4130, 5862, 5164, 6254, 4423, 
         5185, 5194, 5139, 7685, 7660, 7635, 7696, 7721, 4922, 5231, 5222, 
         4223, 6295, 5020, 5885, 4147, 6332, 4490, 5085, 4392, 5535, 5537, 
         5090, 5978, 5087, 4194, 5387, 4195, 5981, 5260, 5539, 4509, 5440, 
         4508, 5294, 4542, 5258, 5982, 5249, 4541, 5293, 4503, 5562, 4504, 
         5286}],
        RowBox[{"-", "3.44`"}]],
       Annotation[#, -3.44, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7606, 5163, 5161, 4129, 6316, 5062, 7446, 5065, 4811, 5067, 
         5969, 5972, 5430, 5559, 5560, 5247, 4853, 5244, 6949, 5243, 5291, 
         4540, 5292, 5254, 6953, 5255, 4701, 5259, 5439, 5437, 5434, 5977, 
         5975, 5089, 4816, 5084, 7449, 5083, 6331, 4146, 5019, 7584, 5025, 
         7614, 4921, 7720, 7695, 7634, 7659, 7684, 5138, 7606}],
        RowBox[{"-", "3.87`"}]],
       Annotation[#, -3.87, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5435, 4815, 7447, 4814, 7448, 5082, 6330, 4145, 5018, 7583, 
         5024, 7613, 4920, 7719, 7694, 7633, 7658, 7683, 5137, 7605, 5162, 
         5160, 4128, 6315, 5061, 7445, 4810, 7444, 4812, 5432, 5971, 5429, 
         5561, 5431, 4854, 6946, 6947, 6948, 5242, 5290, 5253, 6952, 6951, 
         6950, 4700, 5436, 5438, 5433, 5976, 5435}],
        RowBox[{"-", "4.3`"}]],
       Annotation[#, -4.3, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Epilog->DiskBox[{0, 0}, 1],
  Frame->True,
  ImageMargins->0.,
  ImageSize->Small,
  PlotRange->{{-3, 3}, {-3, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->713590942]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->736902023],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " is represented as a complex number with vanishing real part:"
}], "ExampleText",
 CellID->124085200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "I", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->391042939],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Complex", "[", 
    RowBox[{"0", ",", "1"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->36115453]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->272218178],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " is an exact number:"
}], "ExampleText",
 CellID->39073678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExactNumberQ", "[", "I", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->208134614],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120212622]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53835014],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ComplexExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexExpand"]], "InlineFormula"],
 " to extract real and imaginary parts:"
}], "ExampleText",
 CellID->75526733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"I", "^", 
   RowBox[{"I", "^", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->411627200],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[Pi]"}], "/", "2"}]], " ", "\[Pi]"}], "]"}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[Pi]"}], "/", "2"}]], " ", "\[Pi]"}], 
    "]"}]}]}]], "Output",
 ImageSize->{205, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136997166]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59472066],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ExpToTrig",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpToTrig"]], "InlineFormula"],
 " to convert exponentials containing ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " into trigonometric form:"
}], "ExampleText",
 CellID->55767220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpToTrig", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->384737143],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", "x", "]"}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Sin", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52284367]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->508619467],

Cell[TextData[{
 "Simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->75241713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Im", "[", 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"I", " ", 
        RowBox[{"Pi", "/", "3"}]}], "]"}], " ", "x"}], "]"}]}], ",", 
   RowBox[{"Im", "[", 
    RowBox[{"2", "+", 
     RowBox[{"3", " ", "I", " ", "x"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337714292],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Im", "[", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "3"]], " ", "x"}], "]"}]}], 
   ",", 
   RowBox[{"3", " ", 
    RowBox[{"Re", "[", "x", "]"}]}]}], "}"}]], "Output",
 ImageSize->{146, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75570950]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"x", " ", ">", " ", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->193559237],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SqrtBox["3"], " ", 
     SuperscriptBox["x", "2"]}], "2"], ",", 
   RowBox[{"3", " ", "x"}]}], "}"}]], "Output",
 ImageSize->{90, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->360671181]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->178793228],

Cell["\[ImaginaryI] is an algebraic number:", "ExampleText",
 CellID->116428332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{"I", ",", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23562335],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->358278844]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->364189198],

Cell["\<\
Trigonometric functions with purely imaginary arguments evaluate to simpler \
forms:\
\>", "ExampleText",
 CellID->381828069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43939515],

Cell[BoxData[
 RowBox[{"Cosh", "[", "x", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->399657361]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sech", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->426360147],

Cell[BoxData[
 RowBox[{"Sec", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12038351]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14115987],

Cell["\<\
Obtain \[ImaginaryI] in solutions of polynomial equations:\
\>", "ExampleText",
 CellID->561440478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", "1"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->989598009],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "\[ImaginaryI]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "\[ImaginaryI]"}], "}"}]}], "}"}]], "Output",
 ImageSize->{127, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24719746]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->86507048],

Cell["\<\
Roots of quadratic polynomials can evaluate to complex numbers:\
\>", "ExampleText",
 CellID->41282528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "2"}], "+", "1"}], "&"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->503654988],

Cell[BoxData["\[ImaginaryI]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58994512]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->670409420],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Chop"]], "InlineFormula"],
 " to remove small imaginary parts:"
}], "ExampleText",
 CellID->108939833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"2", "+", 
   RowBox[{
    RowBox[{"10", "^", 
     RowBox[{"-", "12"}]}], " ", "I"}]}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318706837],

Cell[BoxData[
 RowBox[{"2.`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.`*^-12", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->206697202]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->70060011],

Cell[BoxData["2.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->43063201]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8957025],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " as limits of integration:"
}], "ExampleText",
 CellID->74501728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "I"}], ",", "I"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->425254638],

Cell[BoxData["\[ImaginaryI]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->337417381]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "I"}], ",", "I"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->70629007],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.000000000000001`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->273066971]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->138055060],

Cell["Sort numbers by increasing imaginary parts:", "ExampleText",
 CellID->42417829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "-", 
      RowBox[{"2", "I"}]}], ",", 
     RowBox[{"5", "+", 
      RowBox[{"3", "I"}]}], ",", 
     RowBox[{"2", "I"}], ",", 
     RowBox[{"-", "4"}], ",", 
     RowBox[{
      RowBox[{"-", "6"}], "+", 
      RowBox[{"6", "I"}]}]}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Im", "[", "#1", "]"}], "<", 
     RowBox[{"Im", "[", "#2", "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->675392001],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3", "-", 
    RowBox[{"2", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"-", "4"}], ",", 
   RowBox[{"2", " ", "\[ImaginaryI]"}], ",", 
   RowBox[{"5", "+", 
    RowBox[{"3", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "6"}], "+", 
    RowBox[{"6", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61322118]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->183650011],

Cell[TextData[{
 "Machine\[Hyphen]precision evaluation of ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " yields an approximate zero real part:"
}], "ExampleText",
 CellID->639556419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "I", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->333375947],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->158860638]
}, Open  ]],

Cell["\<\
Arbitrary\[Hyphen]precision evaluation yields an exact zero real part:\
\>", "ExampleText",
 CellID->238939779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"I", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->291279411],

Cell[BoxData[
 RowBox[{"1.`20.", " ", "\[ImaginaryI]"}]], "Output",
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->553676570]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->524890685],

Cell["\<\
Real and imaginary parts of complex numbers can have different precisions:\
\>", "ExampleText",
 CellID->158497086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.64", "+", "I"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144530740],

Cell[BoxData[
 RowBox[{"1.64`", "\[InvisibleSpace]", "+", "\[ImaginaryI]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21609059]
}, Open  ]],

Cell["Arithmetic operations will typically mix them:", "ExampleText",
 CellID->160590928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "^", "4"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->57594589],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "7.903651839999999`"}], "+", 
  RowBox[{"11.083775999999999`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->399498295]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->82120532],

Cell["\<\
The overall precision of a complex number depends on both real and imaginary \
parts:\
\>", "ExampleText",
 CellID->416455423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetPrecision", "[", 
   RowBox[{"1", ",", "10"}], "]"}], "+", " ", 
  RowBox[{"I", " ", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{"100", ",", "20"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->353264976],

Cell[BoxData[
 RowBox[{"1.`10.", "+", 
  RowBox[{"100.`20.", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{252, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222427569]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->135797636],

Cell[BoxData["12.000021713638432`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->349837007]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->665330092],

Cell[TextData[{
 "Complex numbers are atomic objects and do not explicitly contain ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->136798067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"2", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161938095],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Complex", "[", 
    RowBox[{"2", ",", "1"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->104992490]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"2", "+", "I"}], ",", 
   RowBox[{"_", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->295509437],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->237076355]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"2", "+", "I"}], ",", "I"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2901872],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->27270161]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14658586],

Cell["\<\
Disguised purely real quantities that contain \[ImaginaryI] cannot be used in \
numerical comparisons:\
\>", "ExampleText",
 CellID->180088791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"I", "^", "I"}], " ", "<", " ", "1"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148306135],

Cell[BoxData[
 RowBox[{
  RowBox[{"Less", "::", "\<\"nord\"\>"}], ":", 
  " ", "\<\"Invalid comparison with \\!\\(\[ImaginaryI]\\^\[ImaginaryI]\\) \
attempted. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/nord\\\", \
ButtonNote -> \\\"Less::nord\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->706395316],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ImaginaryI]", "\[ImaginaryI]"], "<", "1"}]], "Output",
 ImageSize->{39, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31873706]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43573458],

Cell[TextData[{
 "Real roots of irreducible cubics still contain ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " in their algebraic forms:"
}], "ExampleText",
 CellID->394032211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "61"}], "+", 
     RowBox[{"110", "x"}], "-", 
     RowBox[{"60", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"10", " ", 
      SuperscriptBox["x", "3"]}]}], "==", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->635178715],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"2", "+", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["1119"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]], 
       SuperscriptBox["6", 
        RowBox[{"2", "/", "3"}]]], "+", 
      FractionBox[
       SuperscriptBox["2", 
        RowBox[{"2", "/", "3"}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["3", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["1119"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"2", "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "5"], " ", 
           RowBox[{"(", 
            RowBox[{"9", "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              SqrtBox["1119"]}]}], ")"}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["6", 
         RowBox[{"2", "/", "3"}]]}]], "-", 
      FractionBox[
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["6", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["1119"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"2", "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "5"], " ", 
           RowBox[{"(", 
            RowBox[{"9", "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              SqrtBox["1119"]}]}], ")"}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["6", 
         RowBox[{"2", "/", "3"}]]}]], "-", 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["6", "5"], " ", 
          RowBox[{"(", 
           RowBox[{"9", "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["1119"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{432, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92470573]
}, Open  ]],

Cell["\<\
Machine-precision numerical evaluation gives a spurious imaginary part:\
\>", "ExampleText",
 CellID->68891093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->842876305],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"3.0466805318046024`", "\[InvisibleSpace]", "-", 
      RowBox[{"8.326672684688674`*^-17", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.8989687421189891`", "\[InvisibleSpace]", "+", 
      RowBox[{"1.1102230246251565`*^-16", " ", "\[ImaginaryI]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.0543507260764087`", "\[InvisibleSpace]", "-", 
      RowBox[{"1.1102230246251565`*^-16", " ", "\[ImaginaryI]"}]}]}], "}"}]}],
   "}"}]], "Output",
 ImageSize->{428, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->437614812]
}, Open  ]],

Cell["\<\
Arbitrary-precision evaluation still leaves an imaginary part:\
\>", "ExampleText",
 CellID->61540449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%%", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->551382145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "3.04668053180460226115865631199604889929`20.15051499783199", "+", 
      RowBox[{"0``19.666688080382638", " ", "\[ImaginaryI]"}]}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "1.89896874211898918231164565878620286272`20.150514997831987", "+", 
      RowBox[{"0``19.871997181718967", " ", "\[ImaginaryI]"}]}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "1.05435072607640855652969802921775806279`20.15051499783199", "+", 
      RowBox[{"0``20.1275298963836", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{561, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->146552496]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " with an option to get explicitly real roots:"
}], "ExampleText",
 CellID->99880813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "61"}], "+", 
     RowBox[{"110", "x"}], "-", 
     RowBox[{"60", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"10", " ", 
      SuperscriptBox["x", "3"]}]}], "==", "0"}], ",", "x", ",", 
   RowBox[{"Cubics", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->775406464],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "61"}], "+", 
       RowBox[{"110", " ", "#1"}], "-", 
       RowBox[{"60", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "61"}], "+", 
       RowBox[{"110", " ", "#1"}], "-", 
       RowBox[{"60", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "3"]}]}], "&"}], ",", "2"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "61"}], "+", 
       RowBox[{"110", " ", "#1"}], "-", 
       RowBox[{"60", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "3"]}]}], "&"}], ",", "3"}], "]"}]}]}]], "Output",\

 ImageSize->{562, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->231922029]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->101299379],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "1.054350726076409`"}], "||", 
  RowBox[{"x", "\[Equal]", "1.898968742118989`"}], "||", 
  RowBox[{"x", "\[Equal]", "3.046680531804602`"}]}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->123889709]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268145091],

Cell["\<\
Finite imaginary quantities are absorbed by infinite real or complex \
quantities:\
\>", "ExampleText",
 CellID->249189941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Infinity", "+", "I"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->637810749],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53586203]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Im", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->102488656],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->239191557]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->222172342],

Cell["\<\
\[ImaginaryI] can not be used in intervals:\
\>", "ExampleText",
 CellID->168865690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntervalMemberQ", "[", 
  RowBox[{
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "I"}], ",", " ", "I"}], "}"}], "]"}], " ", ",", "0"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->735456430],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222413341]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110212999],

Cell[TextData[{
 "The symbol ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 " needs to be evaluated to become a complex number:"
}], "ExampleText",
 CellID->637322382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", 
  RowBox[{"Unevaluated", "[", "I", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->76789975],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->474860401]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"Unevaluated", "[", "I", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->414570313],

Cell[BoxData["Symbol"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->562260056]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->551200392],

Cell["Nested powers of \[ImaginaryI]:", "ExampleText",
 CellID->76606373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "#", "]"}], ",", 
      RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
   RowBox[{"NestList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"I", "^", "#"}], "&"}], ",", 
     RowBox[{"N", "[", "I", "]"}], ",", "100"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36253447],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWE1rE0EY3mZ3o0k/bEGhEoWSU+gPEFppkjb2g35YETQRBAlFbA9aqb3a
X6A3hZq2HkTrUcGiP0AQPXn17B9ZZ3Z3dnafmZ2ZTRNpaHfz7jzv+7xfMzuT
tfbu5sPH7d2tjfbE4k776ebWxrOJhe0d8sgesCzrhPzvjFvku0e++f8nnkfu
4rVCrjkCsKnkUiT7kO9Wjtwdch/UomxyH1KiHHq3o6dWsQc27XB0zJcvAcMF
enG4zHz48P53beYN02caVC4KGnmwaYN8XquRA7nQK47EE2QZiTJC8zMqzYQD
GZB7x5BYP9ErhgyMBp+cNKtd2HQDmdd+NFPNyZftJ18iQ1rOeFewLhvUInMg
6zWye5MTEKaZcMM49JwMifURu4Mh03NkjmBz3nQ2x/WSI2LHZY/dLCJc0cyQ
8oqNhuhzSTvh06H4aHy1UIzhqlBU4FisqnHuN5WOpFHUfTlYY1+++G7dU6Ca
d44Jar5xqET9+vmXzN1vX/+EKNqVny3Z7MF4Me84nhV/2vH/zXfW/OkH34Df
Cdg54xr5ckb8RU/Wn4eap+mzRKfZT3tNLzlD5xL2W15yZs4pbPCZKUf1J8r4
/gJ3cPH3CK4OoXZihdatmCh3a4OKMt2095IJL+wCUyyleqzcg4qZdsMoHE++
NzCp3wMv2XnTChTvQBWKd+C0Af8c8DelqGuAKoA/Ki2OKoB/Ki2OGgPu9URU
K8CxLrW5DDblKPksXAP+1QT/TeBfldqogI0y+DMC49eFXpPNarYfw/6ugE8l
KruB9a1Hn0IOGziHQSv0IXVeW5Z4xkK5AnH675CRiDMgq890yLVRPwgeEkjk
xDDo98KnBr3kI4rAeOvusU1PwO5s7YCMc8YVCWP6LpuuAJTK53AjK0QiMVsO
ZXBq1U6UgFWJdeHsK6lwDWoXP8VTkjy92CS6eP9nXvFq0BE+SzGQ/b+Of92v
V/dpGasdEuoN8MwVOlm3atag5v54gcjzjSNC1qh3Fhfe3r717vWrHyGiAJxT
4HfgA5uxS37cxF6r+ZHYIwrY+VPgAdeP+7kEWtirs1KtKvjqVyEfaUUDODuX
FNa4D0WQbZBVVrjnRZBtkLmVfuzmrkLkz6U6VyCyMmi1FFo8kjJYkWvNglbL
M43fZAWPa8l3EF3uVEQt4ddCk51R2i8f1HcqLkPmJ0EuS2zqfhHEvCxDnSZl
1T/lewH3CJOyXpGuZCwT3ez/7kO2ZhQoHq8KxT2Wo876Wax7lhLkck+oWJZd
VAlyvteDHitBhbq1qTs7pcVkcGYyiEJ34jPJRPppSu37/+kza+Af8cBV7Q==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46655076]
}, Open  ]],

Cell["Find the limit in closed form:", "ExampleText",
 CellID->447723952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"I", "^", "w"}], "==", "w"}], ",", "w"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->247259035],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->10195627],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->144889319],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"w", "\[Rule]", 
    FractionBox[
     RowBox[{"2", " ", "\[ImaginaryI]", " ", 
      RowBox[{"ProductLog", "[", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "2"]}], "]"}]}], "\[Pi]"]}],
    "}"}], "}"}]], "Output",
 ImageSize->{189, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59887012]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->319124758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"w", "\[Rule]", 
    RowBox[{"0.4382829367270321`", "\[InvisibleSpace]", "+", 
     RowBox[{"0.3605924718713855`", " ", "\[ImaginaryI]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->477145355]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->741941209],

Cell["\<\
Generate all possible nestings of powers of \[ImaginaryI]:\
\>", "ExampleText",
 CellID->101816833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Flatten", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"ReplaceList", "[", 
           RowBox[{"#", ",", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a___", ",", "b_", ",", "c_", ",", "d___"}], "}"}], " ",
              ":>", " ", 
             RowBox[{"{", 
              RowBox[{"a", ",", 
               RowBox[{"b", "^", "c"}], ",", "d"}], "}"}]}]}], "]"}], "&"}], "/@",
          "#"}], ",", "1"}], "]"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
       "I", ",", "I", ",", "I", ",", "I", ",", "I", ",", "I", ",", "I"}], 
       "}"}], "}"}], ",", "5"}], "]"}], "//", "Flatten"}], "//", 
  "Union"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->498807491],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{563, 238},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33751055]
}, Open  ]],

Cell["Plot the points in the complex plane:", "ExampleText",
 CellID->260193320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "#", "]"}], ",", 
      RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "/@", " ", 
   RowBox[{"N", "[", "%", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->107162010],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWFtrE0EUnmQ3aUUFocVbklK8/QOhILY1toqtxQeVYrVIKEIL2pvxyYf4
YhGJP0Cr0oq2gk+lUOmDIii0PhRffdU/sp6Z2ZnZPTszu9uYaGjSOTPn8s25
zJndkUp18s69SnVqotJ9cb4yOzk1cb/7wsw8TDkZQsgv+D46TGDswYh9D3me
Rxw6Yh+yRX8Inc3C5LakgjxtjL419r7v7PPLQ8vkk5HLAQ7zKnEWHn8un1uc
vrsW0KHsMg1AZQOyhNLwzWtxt6NZzOVopfg0/2QFGaOFko3YxFKuv/Nk+3IR
ndNKtfk6xf+cNapbu5rdvb7mIdHlDR0m9y+LmatoYvBwXOZE9fDIvXv7A8bP
6l99xPH2mZw7en2FiE9S5Nzi9+3fMP648TOxRXtO5dH/1uTUKUY/qG7AuXJ7
/AN5beEq9y8CF/xZud4s7wwPLT198iXA1bycFt4L5on9RMtH4tKmi1xsZvJw
BtRo9ahTbbd2o3Li1Em6P5x3zTvbBhmt+lhNy9VliVnR9xmhjU7M+/wlz9y9
CjB2DSdUUbMm5HISIaW6YmN0VNB+l41WeQlJ4CgdQSjciIYi4sAYslqvlpJj
9+n02BvX8O+wF3RIQhq6EAeuE4VdnyuiYjCSeKxuUGcqjI6nqjWJX/Geihp9
8VgjkdF01uBMIRaHq8W/l9GqOx3wwmdUwQv3zFLKdZtV1e02Q3Hfx1ZVl9vU
6rD1tYNiV7BAd7Uf7ZLFIC/pKyPLMBgovyoiPi6nTttuRg+UKe7+3hdknFnr
gN8dsJQJ2Ab0MEPR4yqR0fV3x7Hw3cLs/Ow6aB4fW+VnKdyeqIM09aq9T9MM
kI7DHIzOcVo9xXA76nZnxBu0E+mpY6MrfeCQpDgtdFr+RuUpf0ZGL64+eG7C
zXRmep3eTPFuj4mowdTg+ZfkJFo/jugTiM5LFKoSVJ2cQdYfWjDfvEGzdvjS
kqF+zDUY5dLVYtqbSy/y5IKFS6GSzx5A0Oyshez3IXSu8D5wU+/XtDYGkRdx
jOe0UlcRsrkQkmsICV9t98z3MPMd0d6n8f2rFXLqjh3lFz0Z76cHRa5ukbfV
bw+KaT3k2VCfyUspafY0inU9FDUmJlV/U3FXmqRoYLXF7wbSdz51mvPbjMrt
1QCXejLnXCq3V6WPTe8k8BN6J7LDs0jVA9e4B2mK3oUchL8TIVtLoyf07qED
IUqlKfIuIl4O5/FWQ3Ii38U96/96L/a39SlJXQ7aT1DsYe3zUQul1NmJucUz
SbJ9aG9zxjwJnYtGH/M3as1/K66PNMn8AZRbRg8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17698096]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1224],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Complex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complex"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Re",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Re"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Im",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Im"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GaussianIntegers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GaussianIntegers"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8692]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4762],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->767],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexNumbers"]], "Tutorials",
 CellID->26854],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathematicalConstants"]], "Tutorials",
 CellID->28448]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->23828],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/i.html"], None}], "IT"]], "RelatedLinks",\

 CellID->388731424],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Constants/I/"], None}]], "RelatedLinks",
 CellID->347239238]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->2552034],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "MoreAbout",
 CellID->226837441],

Cell[TextData[ButtonBox["Hyperbolic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HyperbolicFunctions"]], "MoreAbout",
 CellID->118897193],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalConstants"]], "MoreAbout",
 CellID->996404073],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->381764814],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->530171],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->196147058]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"I (\[ImaginaryI]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 28.8206108}", "context" -> "System`", 
    "keywords" -> {"imaginary unit"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "I represents the imaginary unit Sqrt[-1]. ", "synonyms" -> {}, "title" -> 
    "I", "type" -> "Symbol", "uri" -> "ref/I"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7067, 227, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->733765935]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 298217, 6359}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3262, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3885, 98, 105, 4, 70, "ObjectName",
 CellID->8130],
Cell[3993, 104, 523, 18, 70, "Usage",
 CellID->17230]
}, Open  ]],
Cell[CellGroupData[{
Cell[4553, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5031, 144, 327, 13, 70, "Notes",
 CellID->7614],
Cell[5361, 159, 766, 27, 70, "Notes",
 CellID->26598],
Cell[6130, 188, 388, 12, 70, "Notes",
 CellID->17139],
Cell[6521, 202, 509, 20, 70, "Notes",
 CellID->29546]
}, Closed]],
Cell[CellGroupData[{
Cell[7067, 227, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->733765935],
Cell[CellGroupData[{
Cell[7452, 241, 147, 5, 70, "ExampleSection",
 CellID->82584308],
Cell[7602, 248, 325, 11, 70, "ExampleText",
 CellID->203694883],
Cell[CellGroupData[{
Cell[7952, 263, 70, 2, 28, "Input",
 CellID->594505050],
Cell[8025, 267, 170, 5, 36, "Output",
 CellID->294990976]
}, Open  ]],
Cell[8210, 275, 125, 3, 70, "ExampleDelimiter",
 CellID->226110433],
Cell[8338, 280, 95, 1, 70, "ExampleText",
 CellID->289573092],
Cell[CellGroupData[{
Cell[8458, 285, 118, 4, 70, "Input",
 CellID->27551984],
Cell[8579, 291, 192, 6, 36, "Output",
 CellID->166456580]
}, Open  ]],
Cell[8786, 300, 125, 3, 70, "ExampleDelimiter",
 CellID->515265040],
Cell[8914, 305, 209, 8, 70, "ExampleText",
 CellID->7146610],
Cell[CellGroupData[{
Cell[9148, 317, 211, 8, 70, "Input",
 CellID->326821536],
Cell[9362, 327, 261, 9, 51, "Output",
 CellID->22445252]
}, Open  ]],
Cell[CellGroupData[{
Cell[9660, 341, 124, 4, 70, "Input",
 CellID->126616372],
Cell[9787, 347, 272, 7, 36, "Output",
 CellID->48459055]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10108, 360, 220, 7, 70, "ExampleSection",
 CellID->370344466],
Cell[10331, 369, 103, 2, 70, "ExampleText",
 CellID->104436638],
Cell[CellGroupData[{
Cell[10459, 375, 143, 5, 70, "Input",
 CellID->333644638],
Cell[10605, 382, 271, 7, 36, "Output",
 CellID->41936508]
}, Open  ]],
Cell[CellGroupData[{
Cell[10913, 394, 191, 7, 70, "Input",
 CellID->302849425],
Cell[11107, 403, 190, 6, 36, "Output",
 CellID->7848115]
}, Open  ]],
Cell[11312, 412, 124, 3, 70, "ExampleDelimiter",
 CellID->39826705],
Cell[11439, 417, 67, 1, 70, "ExampleText",
 CellID->232532372],
Cell[CellGroupData[{
Cell[11531, 422, 197, 7, 70, "Input",
 CellID->171982608],
Cell[11731, 431, 284, 9, 36, "Output",
 CellID->131561458]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12064, 446, 243, 7, 70, "ExampleSection",
 CellID->244045368],
Cell[12310, 455, 345, 12, 70, "ExampleText",
 CellID->23068299],
Cell[CellGroupData[{
Cell[12680, 471, 81, 2, 70, "Input",
 CellID->95738320],
Cell[12764, 475, 169, 5, 36, "Output",
 CellID->87910026]
}, Open  ]],
Cell[12948, 483, 125, 3, 70, "ExampleDelimiter",
 CellID->578287121],
Cell[13076, 488, 84, 1, 70, "ExampleText",
 CellID->89310168],
Cell[CellGroupData[{
Cell[13185, 493, 111, 3, 70, "Input",
 CellID->97219679],
Cell[13299, 498, 319, 12, 36, "Output",
 CellID->722330369]
}, Open  ]],
Cell[CellGroupData[{
Cell[13655, 515, 122, 4, 70, "Input",
 CellID->245497521],
Cell[13780, 521, 158, 5, 36, "Output",
 CellID->352726052]
}, Open  ]],
Cell[13953, 529, 124, 3, 70, "ExampleDelimiter",
 CellID->56794946],
Cell[14080, 534, 199, 8, 70, "ExampleText",
 CellID->545837199],
Cell[CellGroupData[{
Cell[14304, 546, 248, 8, 70, "Input",
 CellID->120224854],
Cell[14555, 556, 157, 5, 36, "Output",
 CellID->33463274]
}, Open  ]],
Cell[14727, 564, 125, 3, 70, "ExampleDelimiter",
 CellID->271773706],
Cell[14855, 569, 80, 1, 70, "ExampleText",
 CellID->474598974],
Cell[CellGroupData[{
Cell[14960, 574, 149, 5, 70, "Input",
 CellID->383858454],
Cell[15112, 581, 204, 7, 36, "Output",
 CellID->278151246]
}, Open  ]],
Cell[CellGroupData[{
Cell[15353, 593, 237, 8, 70, "Input",
 CellID->348619409],
Cell[15593, 603, 318, 11, 36, "Output",
 CellID->189970955]
}, Open  ]],
Cell[15926, 617, 125, 3, 70, "ExampleDelimiter",
 CellID->194776517],
Cell[16054, 622, 76, 1, 70, "ExampleText",
 CellID->1888187],
Cell[CellGroupData[{
Cell[16155, 627, 213, 6, 70, "Input",
 CellID->4223473],
Cell[16371, 635, 531, 19, 36, "Output",
 CellID->173444821]
}, Open  ]],
Cell[16917, 657, 125, 3, 70, "ExampleDelimiter",
 CellID->599411533],
Cell[17045, 662, 80, 1, 70, "ExampleText",
 CellID->303077153],
Cell[CellGroupData[{
Cell[17150, 667, 218, 7, 70, "Input",
 CellID->258621666],
Cell[17371, 676, 1626, 51, 89, "Output",
 CellID->1145495]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19046, 733, 226, 7, 70, "ExampleSection",
 CellID->85873571],
Cell[19275, 742, 99, 1, 70, "ExampleText",
 CellID->113753601],
Cell[CellGroupData[{
Cell[19399, 747, 164, 5, 70, "Input",
 CellID->101715519],
Cell[19566, 754, 272, 7, 36, "Output",
 CellID->225136594]
}, Open  ]],
Cell[19853, 764, 125, 3, 70, "ExampleDelimiter",
 CellID->152004641],
Cell[19981, 769, 129, 4, 70, "ExampleText",
 CellID->21257428],
Cell[CellGroupData[{
Cell[20135, 777, 724, 25, 70, "Input",
 CellID->11155172],
Cell[20862, 804, 223674, 3723, 70, "Output",
 CellID->713590942]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[244585, 4533, 238, 7, 70, "ExampleSection",
 CellID->736902023],
Cell[244826, 4542, 224, 7, 70, "ExampleText",
 CellID->124085200],
Cell[CellGroupData[{
Cell[245075, 4553, 104, 3, 70, "Input",
 CellID->391042939],
Cell[245182, 4558, 348, 13, 50, "Output",
 CellID->36115453]
}, Open  ]],
Cell[245545, 4574, 125, 3, 70, "ExampleDelimiter",
 CellID->272218178],
Cell[245673, 4579, 182, 7, 70, "ExampleText",
 CellID->39073678],
Cell[CellGroupData[{
Cell[245880, 4590, 108, 3, 70, "Input",
 CellID->208134614],
Cell[245991, 4595, 161, 5, 36, "Output",
 CellID->120212622]
}, Open  ]],
Cell[246167, 4603, 124, 3, 70, "ExampleDelimiter",
 CellID->53835014],
Cell[246294, 4608, 232, 8, 70, "ExampleText",
 CellID->75526733],
Cell[CellGroupData[{
Cell[246551, 4620, 156, 5, 70, "Input",
 CellID->411627200],
Cell[246710, 4627, 593, 20, 51, "Output",
 CellID->136997166]
}, Open  ]],
Cell[247318, 4650, 124, 3, 70, "ExampleDelimiter",
 CellID->59472066],
Cell[247445, 4655, 358, 13, 70, "ExampleText",
 CellID->55767220],
Cell[CellGroupData[{
Cell[247828, 4672, 159, 5, 70, "Input",
 CellID->384737143],
Cell[247990, 4679, 276, 9, 36, "Output",
 CellID->52284367]
}, Open  ]],
Cell[248281, 4691, 125, 3, 70, "ExampleDelimiter",
 CellID->508619467],
Cell[248409, 4696, 200, 8, 70, "ExampleText",
 CellID->75241713],
Cell[CellGroupData[{
Cell[248634, 4708, 379, 13, 70, "Input",
 CellID->337714292],
Cell[249016, 4723, 456, 16, 49, "Output",
 CellID->75570950]
}, Open  ]],
Cell[CellGroupData[{
Cell[249509, 4744, 166, 5, 70, "Input",
 CellID->193559237],
Cell[249678, 4751, 316, 12, 56, "Output",
 CellID->360671181]
}, Open  ]],
Cell[250009, 4766, 125, 3, 70, "ExampleDelimiter",
 CellID->178793228],
Cell[250137, 4771, 80, 1, 70, "ExampleText",
 CellID->116428332],
Cell[CellGroupData[{
Cell[250242, 4776, 134, 4, 70, "Input",
 CellID->23562335],
Cell[250379, 4782, 161, 5, 36, "Output",
 CellID->358278844]
}, Open  ]],
Cell[250555, 4790, 125, 3, 70, "ExampleDelimiter",
 CellID->364189198],
Cell[250683, 4795, 135, 4, 70, "ExampleText",
 CellID->381828069],
Cell[CellGroupData[{
Cell[250843, 4803, 121, 4, 70, "Input",
 CellID->43939515],
Cell[250967, 4809, 188, 6, 36, "Output",
 CellID->399657361]
}, Open  ]],
Cell[CellGroupData[{
Cell[251192, 4820, 123, 4, 70, "Input",
 CellID->426360147],
Cell[251318, 4826, 186, 6, 36, "Output",
 CellID->12038351]
}, Open  ]],
Cell[251519, 4835, 124, 3, 70, "ExampleDelimiter",
 CellID->14115987],
Cell[251646, 4840, 109, 3, 70, "ExampleText",
 CellID->561440478],
Cell[CellGroupData[{
Cell[251780, 4847, 203, 8, 70, "Input",
 CellID->989598009],
Cell[251986, 4857, 358, 12, 36, "Output",
 CellID->24719746]
}, Open  ]],
Cell[252359, 4872, 124, 3, 70, "ExampleDelimiter",
 CellID->86507048],
Cell[252486, 4877, 113, 3, 70, "ExampleText",
 CellID->41282528],
Cell[CellGroupData[{
Cell[252624, 4884, 193, 7, 70, "Input",
 CellID->503654988],
Cell[252820, 4893, 169, 5, 36, "Output",
 CellID->58994512]
}, Open  ]],
Cell[253004, 4901, 125, 3, 70, "ExampleDelimiter",
 CellID->670409420],
Cell[253132, 4906, 211, 8, 70, "ExampleText",
 CellID->108939833],
Cell[CellGroupData[{
Cell[253368, 4918, 197, 7, 70, "Input",
 CellID->318706837],
Cell[253568, 4927, 245, 7, 36, "Output",
 CellID->206697202]
}, Open  ]],
Cell[CellGroupData[{
Cell[253850, 4939, 99, 3, 70, "Input",
 CellID->70060011],
Cell[253952, 4944, 159, 5, 36, "Output",
 CellID->43063201]
}, Open  ]],
Cell[254126, 4952, 123, 3, 70, "ExampleDelimiter",
 CellID->8957025],
Cell[254252, 4957, 197, 8, 70, "ExampleText",
 CellID->74501728],
Cell[CellGroupData[{
Cell[254474, 4969, 239, 8, 70, "Input",
 CellID->425254638],
Cell[254716, 4979, 170, 5, 36, "Output",
 CellID->337417381]
}, Open  ]],
Cell[CellGroupData[{
Cell[254923, 4989, 239, 8, 70, "Input",
 CellID->70629007],
Cell[255165, 4999, 255, 7, 36, "Output",
 CellID->273066971]
}, Open  ]],
Cell[255435, 5009, 125, 3, 70, "ExampleDelimiter",
 CellID->138055060],
Cell[255563, 5014, 85, 1, 70, "ExampleText",
 CellID->42417829],
Cell[CellGroupData[{
Cell[255673, 5019, 520, 19, 70, "Input",
 CellID->675392001],
Cell[256196, 5040, 491, 16, 36, "Output",
 CellID->61322118]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[256736, 5062, 230, 7, 70, "ExampleSection",
 CellID->183650011],
Cell[256969, 5071, 246, 8, 70, "ExampleText",
 CellID->639556419],
Cell[CellGroupData[{
Cell[257240, 5083, 97, 3, 70, "Input",
 CellID->333375947],
Cell[257340, 5088, 240, 7, 36, "Output",
 CellID->158860638]
}, Open  ]],
Cell[257595, 5098, 121, 3, 70, "ExampleText",
 CellID->238939779],
Cell[CellGroupData[{
Cell[257741, 5105, 121, 4, 70, "Input",
 CellID->291279411],
Cell[257865, 5111, 198, 6, 36, "Output",
 CellID->553676570]
}, Open  ]],
Cell[258078, 5120, 125, 3, 70, "ExampleDelimiter",
 CellID->524890685],
Cell[258206, 5125, 125, 3, 70, "ExampleText",
 CellID->158497086],
Cell[CellGroupData[{
Cell[258356, 5132, 95, 3, 70, "Input",
 CellID->144530740],
Cell[258454, 5137, 216, 6, 36, "Output",
 CellID->21609059]
}, Open  ]],
Cell[258685, 5146, 89, 1, 70, "ExampleText",
 CellID->160590928],
Cell[CellGroupData[{
Cell[258799, 5151, 91, 3, 70, "Input",
 CellID->57594589],
Cell[258893, 5156, 269, 8, 36, "Output",
 CellID->399498295]
}, Open  ]],
Cell[259177, 5167, 124, 3, 70, "ExampleDelimiter",
 CellID->82120532],
Cell[259304, 5172, 136, 4, 70, "ExampleText",
 CellID->416455423],
Cell[CellGroupData[{
Cell[259465, 5180, 252, 8, 70, "Input",
 CellID->353264976],
Cell[259720, 5190, 228, 7, 36, "Output",
 CellID->222427569]
}, Open  ]],
Cell[CellGroupData[{
Cell[259985, 5202, 105, 3, 70, "Input",
 CellID->135797636],
Cell[260093, 5207, 176, 5, 36, "Output",
 CellID->349837007]
}, Open  ]],
Cell[260284, 5215, 125, 3, 70, "ExampleDelimiter",
 CellID->665330092],
Cell[260412, 5220, 234, 8, 70, "ExampleText",
 CellID->136798067],
Cell[CellGroupData[{
Cell[260671, 5232, 127, 4, 70, "Input",
 CellID->161938095],
Cell[260801, 5238, 349, 13, 50, "Output",
 CellID->104992490]
}, Open  ]],
Cell[CellGroupData[{
Cell[261187, 5256, 173, 6, 70, "Input",
 CellID->295509437],
Cell[261363, 5264, 162, 5, 36, "Output",
 CellID->237076355]
}, Open  ]],
Cell[CellGroupData[{
Cell[261562, 5274, 148, 5, 70, "Input",
 CellID->2901872],
Cell[261713, 5281, 161, 5, 36, "Output",
 CellID->27270161]
}, Open  ]],
Cell[261889, 5289, 124, 3, 70, "ExampleDelimiter",
 CellID->14658586],
Cell[262016, 5294, 153, 4, 70, "ExampleText",
 CellID->180088791],
Cell[CellGroupData[{
Cell[262194, 5302, 125, 4, 70, "Input",
 CellID->148306135],
Cell[262322, 5308, 391, 7, 70, "Message",
 CellID->706395316],
Cell[262716, 5317, 227, 7, 38, "Output",
 CellID->31873706]
}, Open  ]],
Cell[262958, 5327, 124, 3, 70, "ExampleDelimiter",
 CellID->43573458],
Cell[263085, 5332, 241, 8, 70, "ExampleText",
 CellID->394032211],
Cell[CellGroupData[{
Cell[263351, 5344, 349, 12, 70, "Input",
 CellID->635178715],
Cell[263703, 5358, 3105, 102, 182, "Output",
 CellID->92470573]
}, Open  ]],
Cell[266823, 5463, 121, 3, 70, "ExampleText",
 CellID->68891093],
Cell[CellGroupData[{
Cell[266969, 5470, 97, 3, 70, "Input",
 CellID->842876305],
Cell[267069, 5475, 770, 22, 58, "Output",
 CellID->437614812]
}, Open  ]],
Cell[267854, 5500, 112, 3, 70, "ExampleText",
 CellID->61540449],
Cell[CellGroupData[{
Cell[267991, 5507, 122, 4, 70, "Input",
 CellID->551382145],
Cell[268116, 5513, 833, 25, 58, "Output",
 CellID->146552496]
}, Open  ]],
Cell[268964, 5541, 226, 8, 70, "ExampleText",
 CellID->99880813],
Cell[CellGroupData[{
Cell[269215, 5553, 394, 13, 70, "Input",
 CellID->775406464],
Cell[269612, 5568, 1185, 40, 58, "Output",
 CellID->231922029]
}, Open  ]],
Cell[CellGroupData[{
Cell[270834, 5613, 97, 3, 70, "Input",
 CellID->101299379],
Cell[270934, 5618, 334, 9, 36, "Output",
 CellID->123889709]
}, Open  ]],
Cell[271283, 5630, 125, 3, 70, "ExampleDelimiter",
 CellID->268145091],
Cell[271411, 5635, 133, 4, 70, "ExampleText",
 CellID->249189941],
Cell[CellGroupData[{
Cell[271569, 5643, 99, 3, 70, "Input",
 CellID->637810749],
Cell[271671, 5648, 167, 5, 36, "Output",
 CellID->53586203]
}, Open  ]],
Cell[CellGroupData[{
Cell[271875, 5658, 98, 3, 70, "Input",
 CellID->102488656],
Cell[271976, 5663, 158, 5, 36, "Output",
 CellID->239191557]
}, Open  ]],
Cell[272149, 5671, 125, 3, 70, "ExampleDelimiter",
 CellID->222172342],
Cell[272277, 5676, 94, 3, 70, "ExampleText",
 CellID->168865690],
Cell[CellGroupData[{
Cell[272396, 5683, 256, 9, 70, "Input",
 CellID->735456430],
Cell[272655, 5694, 162, 5, 36, "Output",
 CellID->222413341]
}, Open  ]],
Cell[272832, 5702, 125, 3, 70, "ExampleDelimiter",
 CellID->110212999],
Cell[272960, 5707, 229, 8, 70, "ExampleText",
 CellID->637322382],
Cell[CellGroupData[{
Cell[273214, 5719, 140, 4, 70, "Input",
 CellID->76789975],
Cell[273357, 5725, 162, 5, 36, "Output",
 CellID->474860401]
}, Open  ]],
Cell[CellGroupData[{
Cell[273556, 5735, 138, 4, 70, "Input",
 CellID->414570313],
Cell[273697, 5741, 163, 5, 36, "Output",
 CellID->562260056]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[273909, 5752, 228, 7, 70, "ExampleSection",
 CellID->551200392],
Cell[274140, 5761, 73, 1, 70, "ExampleText",
 CellID->76606373],
Cell[CellGroupData[{
Cell[274238, 5766, 415, 14, 70, "Input",
 CellID->36253447],
Cell[274656, 5782, 1554, 30, 70, "Output",
 Evaluatable->False,
 CellID->46655076]
}, Open  ]],
Cell[276225, 5815, 73, 1, 70, "ExampleText",
 CellID->447723952],
Cell[CellGroupData[{
Cell[276323, 5820, 174, 6, 70, "Input",
 CellID->247259035],
Cell[276500, 5828, 427, 8, 70, "Message",
 CellID->10195627],
Cell[276930, 5838, 453, 8, 70, "Message",
 CellID->144889319],
Cell[277386, 5848, 449, 15, 60, "Output",
 CellID->59887012]
}, Open  ]],
Cell[CellGroupData[{
Cell[277872, 5868, 97, 3, 70, "Input",
 CellID->319124758],
Cell[277972, 5873, 357, 11, 36, "Output",
 CellID->477145355]
}, Open  ]],
Cell[278344, 5887, 125, 3, 70, "ExampleDelimiter",
 CellID->741941209],
Cell[278472, 5892, 109, 3, 70, "ExampleText",
 CellID->101816833],
Cell[CellGroupData[{
Cell[278606, 5899, 844, 27, 70, "Input",
 CellID->498807491],
Cell[279453, 5928, 11338, 190, 70, "Output",
 Evaluatable->False,
 CellID->33751055]
}, Open  ]],
Cell[290806, 6121, 80, 1, 70, "ExampleText",
 CellID->260193320],
Cell[CellGroupData[{
Cell[290911, 6126, 298, 10, 70, "Input",
 CellID->107162010],
Cell[291212, 6138, 1533, 29, 70, "Output",
 Evaluatable->False,
 CellID->17698096]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[292806, 6174, 310, 9, 70, "SeeAlsoSection",
 CellID->1224],
Cell[293119, 6185, 1185, 44, 70, "SeeAlso",
 CellID->8692]
}, Open  ]],
Cell[CellGroupData[{
Cell[294341, 6234, 313, 9, 70, "TutorialsSection",
 CellID->4762],
Cell[294657, 6245, 161, 3, 70, "Tutorials",
 CellID->767],
Cell[294821, 6250, 140, 3, 70, "Tutorials",
 CellID->26854],
Cell[294964, 6255, 154, 3, 70, "Tutorials",
 CellID->28448]
}, Open  ]],
Cell[CellGroupData[{
Cell[295155, 6263, 321, 9, 70, "RelatedLinksSection",
 CellID->23828],
Cell[295479, 6274, 190, 5, 70, "RelatedLinks",
 CellID->388731424],
Cell[295672, 6281, 199, 4, 70, "RelatedLinks",
 CellID->347239238]
}, Open  ]],
Cell[CellGroupData[{
Cell[295908, 6290, 317, 9, 70, "MoreAboutSection",
 CellID->2552034],
Cell[296228, 6301, 141, 3, 70, "MoreAbout",
 CellID->226837441],
Cell[296372, 6306, 151, 3, 70, "MoreAbout",
 CellID->118897193],
Cell[296526, 6311, 155, 3, 70, "MoreAbout",
 CellID->996404073],
Cell[296684, 6316, 155, 3, 70, "MoreAbout",
 CellID->381764814],
Cell[296842, 6321, 172, 3, 70, "MoreAbout",
 CellID->530171],
Cell[297017, 6326, 157, 3, 70, "MoreAbout",
 CellID->196147058]
}, Open  ]],
Cell[297189, 6332, 50, 0, 70, "History"],
Cell[297242, 6334, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

