(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18285,        664]
NotebookOptionsPosition[     14189,        522]
NotebookOutlinePosition[     15479,        560]
CellTagsIndexPosition[     15394,        555]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Constructing Matrices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ConstructingMatrices"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Vectors and Matrices\"\>", 
       2->"\<\"Constructing Matrices\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DiagonalMatrix" :> 
          Documentation`HelpLookup["paclet:ref/DiagonalMatrix"], 
          "KroneckerDelta" :> 
          Documentation`HelpLookup["paclet:ref/KroneckerDelta"], "UnitVector" :> 
          Documentation`HelpLookup["paclet:ref/UnitVector"], "Table" :> 
          Documentation`HelpLookup["paclet:ref/Table"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DiagonalMatrix\"\>", 2->"\<\"KroneckerDelta\"\>",
        3->"\<\"UnitVector\"\>", 4->"\<\"Table\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "Geometric Transforms" :> 
          Documentation`HelpLookup["paclet:guide/GeometricTransforms"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup[
           "paclet:guide/MatricesAndLinearAlgebra"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Constructing Matrices\"\>", 
       2->"\<\"Geometric Transforms\"\>", 
       3->"\<\"Matrices and Linear Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IdentityMatrix", "ObjectName",
 CellID->21426],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IdentityMatrix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IdentityMatrix"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      RowBox[{
       StyleBox["n", "TI"], "\[Cross]", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " identity matrix. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19786]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->137695292],

Cell["\<\
Construct a 3\[Times]3 identity matrix:\
\>", "ExampleText",
 CellID->55125053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IdentityMatrix", "[", "3", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->538133064],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0"},
     {"0", "1", "0"},
     {"0", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[0.7]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->165250559]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30012],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DiagonalMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiagonalMatrix"]], "InlineFormula"],
 " for general diagonal matrices:"
}], "ExampleText",
 CellID->11826483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DiagonalMatrix", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90181359],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "b", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36305597]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->142039384],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["KroneckerProduct",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/KroneckerProduct"]], "InlineFormula"],
 " of a matrix with the identity matrix is a block diagonal matrix:"
}], "ExampleText",
 CellID->478218870],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417489266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"KroneckerProduct", "[", 
   RowBox[{
    RowBox[{"IdentityMatrix", "[", "3", "]"}], ",", "a"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->87208810],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "0", "0", "0", "0"},
     {"3", "4", "0", "0", "0", "0"},
     {"0", "0", "1", "2", "0", "0"},
     {"0", "0", "3", "4", "0", "0"},
     {"0", "0", "0", "0", "1", "2"},
     {"0", "0", "0", "0", "3", "4"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{106, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->263485851]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17964088],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IdentityMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IdentityMatrix"]], "InlineFormula"],
 " gives a matrix with dense storage. ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " is more compact: "
}], "ExampleText",
 CellID->87797353],

Cell[BoxData[
 RowBox[{
  RowBox[{"sparseIdentityMatrix", "[", "n_", "]"}], " ", ":=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", " ", "i_"}], "}"}], "\[Rule]", "1"}], "}"}], ",", 
    " ", 
    RowBox[{"{", 
     RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->430759272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"sparseIdentityMatrix", "[", "1000", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->115752004],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1000", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 1000, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"1000", ",", "1000"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149677]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"IdentityMatrix", "[", "1000", "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->51880591],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " representation uses a fraction of the memory:"
}], "ExampleText",
 CellID->1543482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"ByteCount", "[", "m", "]"}], "/", 
   RowBox[{"ByteCount", "[", "s", "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->434265509],

Cell[BoxData["321.1368015414258`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->26768279]
}, Open  ]],

Cell["\<\
For matrix and arithmetic operations they are effectively equal:\
\>", "ExampleText",
 CellID->23224321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", " ", "\[Equal]", " ", "s"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->230181862],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->772342990]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->800],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiagonalMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiagonalMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KroneckerDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KroneckerDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnitVector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnitVector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16804]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4611],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->18822],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConstructingMatrices"]], "Tutorials",
 CellID->869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->359756791],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->595664308],

Cell[TextData[ButtonBox["Geometric Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeometricTransforms"]], "MoreAbout",
 CellID->89364018],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->123977477]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IdentityMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 4.4293614}", "context" -> "System`", 
    "keywords" -> {
     "identity", "identity array", "unit array", "unit diagonal", 
      "unit matrix"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "IdentityMatrix[n] gives the n*n identity matrix. ", 
    "synonyms" -> {"identity matrix"}, "title" -> "IdentityMatrix", "type" -> 
    "Symbol", "uri" -> "ref/IdentityMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3893, 114, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15259, 548}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2563, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3186, 86, 52, 1, 70, "ObjectName",
 CellID->21426],
Cell[3241, 89, 615, 20, 70, "Usage",
 CellID->19786]
}, Open  ]],
Cell[CellGroupData[{
Cell[3893, 114, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4270, 128, 148, 5, 70, "ExampleSection",
 CellID->137695292],
Cell[4421, 135, 89, 3, 70, "ExampleText",
 CellID->55125053],
Cell[CellGroupData[{
Cell[4535, 142, 143, 4, 28, "Input",
 CellID->538133064],
Cell[4681, 148, 725, 23, 78, "Output",
 CellID->165250559]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5455, 177, 233, 7, 70, "ExampleSection",
 CellID->30012],
Cell[5691, 186, 228, 8, 70, "ExampleText",
 CellID->11826483],
Cell[CellGroupData[{
Cell[5944, 198, 166, 5, 70, "Input",
 CellID->90181359],
Cell[6113, 205, 390, 13, 36, "Output",
 CellID->36305597]
}, Open  ]],
Cell[6518, 221, 125, 3, 70, "ExampleDelimiter",
 CellID->142039384],
Cell[6646, 226, 267, 8, 70, "ExampleText",
 CellID->478218870],
Cell[6916, 236, 265, 10, 70, "Input",
 CellID->417489266],
Cell[CellGroupData[{
Cell[7206, 250, 214, 7, 70, "Input",
 CellID->87208810],
Cell[7423, 259, 914, 26, 122, "Output",
 CellID->263485851]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8386, 291, 229, 7, 70, "ExampleSection",
 CellID->17964088],
Cell[8618, 300, 372, 12, 70, "ExampleText",
 CellID->87797353],
Cell[8993, 314, 393, 13, 70, "Input",
 CellID->430759272],
Cell[CellGroupData[{
Cell[9411, 331, 152, 4, 70, "Input",
 CellID->115752004],
Cell[9566, 337, 488, 17, 36, "Output",
 CellID->149677]
}, Open  ]],
Cell[10069, 357, 164, 5, 70, "Input",
 CellID->51880591],
Cell[10236, 364, 236, 8, 70, "ExampleText",
 CellID->1543482],
Cell[CellGroupData[{
Cell[10497, 376, 194, 6, 70, "Input",
 CellID->434265509],
Cell[10694, 384, 174, 5, 36, "Output",
 CellID->26768279]
}, Open  ]],
Cell[10883, 392, 114, 3, 70, "ExampleText",
 CellID->23224321],
Cell[CellGroupData[{
Cell[11022, 399, 109, 3, 70, "Input",
 CellID->230181862],
Cell[11134, 404, 161, 5, 36, "Output",
 CellID->772342990]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11356, 416, 309, 9, 70, "SeeAlsoSection",
 CellID->800],
Cell[11668, 427, 963, 35, 70, "SeeAlso",
 CellID->16804]
}, Open  ]],
Cell[CellGroupData[{
Cell[12668, 467, 313, 9, 70, "TutorialsSection",
 CellID->4611],
Cell[12984, 478, 149, 3, 70, "Tutorials",
 CellID->18822],
Cell[13136, 483, 150, 3, 70, "Tutorials",
 CellID->869]
}, Open  ]],
Cell[CellGroupData[{
Cell[13323, 491, 319, 9, 70, "MoreAboutSection",
 CellID->359756791],
Cell[13645, 502, 153, 3, 70, "MoreAbout",
 CellID->595664308],
Cell[13801, 507, 150, 3, 70, "MoreAbout",
 CellID->89364018],
Cell[13954, 512, 163, 3, 70, "MoreAbout",
 CellID->123977477]
}, Open  ]],
Cell[14132, 518, 27, 0, 70, "History"],
Cell[14162, 520, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

