(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41994,       1515]
NotebookOptionsPosition[     33645,       1222]
NotebookOutlinePosition[     35079,       1261]
CellTagsIndexPosition[     34993,       1256]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Relational and Logical Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RelationalAndLogicalOperators"], "Conditionals" :> 
          Documentation`HelpLookup["paclet:tutorial/Conditionals"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Relational and Logical Operators\"\>", 
       2->"\<\"Conditionals\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Switch" :> Documentation`HelpLookup["paclet:ref/Switch"], 
          "Which" :> Documentation`HelpLookup["paclet:ref/Which"], 
          "Condition" :> Documentation`HelpLookup["paclet:ref/Condition"], 
          "Piecewise" :> Documentation`HelpLookup["paclet:ref/Piecewise"], 
          "Boole" :> Documentation`HelpLookup["paclet:ref/Boole"], 
          "DiracDelta" :> 
          Documentation`HelpLookup["paclet:ref/DiracDelta"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Switch\"\>", 2->"\<\"Which\"\>", 
       3->"\<\"Condition\"\>", 4->"\<\"Piecewise\"\>", 5->"\<\"Boole\"\>", 
       6->"\<\"DiracDelta\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Language Overview\"\>", 3->"\<\"Logic & Boolean Algebra\"\>", 
       4->"\<\"Procedural Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["If", "ObjectName",
 CellID->20671],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["If",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/If"], "[", 
       RowBox[{
        StyleBox["condition", "TI"], ",", 
        StyleBox["t", "TI"], ",", 
        StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["condition", "TI"]], "InlineFormula"],
     " evaluates to ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " if it evaluates to ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["If",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/If"], "[", 
       RowBox[{
        StyleBox["condition", "TI"], ",", 
        StyleBox["t", "TI"], ",", 
        StyleBox["f", "TI"], ",", 
        StyleBox["u", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["condition", "TI"]], "InlineFormula"],
     " evaluates to neither ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " nor ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15031]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 " evaluates only the argument determined by the value of the condition. "
}], "Notes",
 CellID->24252],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"], "[", 
   RowBox[{
    StyleBox["condition", "TI"], ",", 
    StyleBox["t", "TI"], ",", 
    StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
 " is left unevaluated if ",
 Cell[BoxData[
  StyleBox["condition", "TI"]], "InlineFormula"],
 " evaluates to neither ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " nor ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7253],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"], "[", 
   RowBox[{
    StyleBox["condition", "TI"], ",", 
    StyleBox["t", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  StyleBox["condition", "TI"]], "InlineFormula"],
 " evaluates to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14399]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->70670205],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->361511948],

Cell[BoxData[
 RowBox[{
  RowBox[{"abs", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", "<", "0"}], ",", 
    RowBox[{"-", "x"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->761396215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"abs", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->210429286],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "1"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->234447382]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->805953521],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Evaluation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->612371689],

Cell[TextData[{
 "If the condition is neither ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " nor ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 " remains unevaluated:"
}], "ExampleText",
 CellID->201999957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"a", "<", "b"}], ",", "1", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108149728],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"a", "<", "b"}], ",", "1", ",", "0"}], "]"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59281721]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->389166042],

Cell["\<\
The form with an explicit case for an undetermined condition evaluates in any \
case:\
\>", "ExampleText",
 CellID->178970992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"a", "<", "b"}], ",", "1", ",", "0", ",", "Indeterminate"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->265924599],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306764873]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->845613308],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrueQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrueQ"]], "InlineFormula"],
 " to force the condition to always return a Boolean value:"
}], "ExampleText",
 CellID->30841451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"TrueQ", "[", 
    RowBox[{"a", "<", "b"}], "]"}], ",", "1", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195619338],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->494896214]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Symbolic Transformations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->109919502],

Cell[TextData[{
 "Define a piecewise function with both ",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 " as piecewise elements:"
}], "ExampleText",
 CellID->382272454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Round", "[", "x", "]"}], ">", "x"}], ",", "x", ",", 
    RowBox[{"-", "x"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162757792],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Round", "[", "x", "]"}], ">", "x"}], ",", "x", ",", 
   RowBox[{"-", "x"}]}], "]"}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264408815]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 " to get it into piecewise normal form: "
}], "ExampleText",
 CellID->140481461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"f", ",", 
   RowBox[{"0", "<", "x", "<", "5"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->164933792],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWL1uE0EQXvv+7ECAmATSgEwRSKAwggYhQQMJSCE9FcEKkZIiwgop3PkR
XPoRXPoReAQ/hks/wnF7t4PX38167mITTvLtze7MN397s3M+al+dnV60r85P
2s1Pl+3O2fnJr+bBz8tkyqsoVfmhlNrZVslznDylP32dJj+lPH33u93u7/Sa
TCZ67dtszev1eil/nIodl1wJkls1UVk141YyeirjC8yo5zPB7NK8vjHzKYsa
plaTJ1ruYcoxm/EEmmyy5/Rtl9UXGSu3i2gJ/tLGpZvUE6wgbtoC3+1Jbtat
D7P/ALNg5jN1yoDZEhqRBJ6xOh7nfOLi/cYpGxnGtyyHvh3f6Epm/WAwGA6H
tPLdWpnJfDGx2XeMLTOGlnSn0+n3+yRtR2m/JN0COmT9WrWW4D9qObS4lIlz
GboFdLGI1YH2gX4FdE3gf/2P+R8ViuVXAeWdsP5+yfUd1qrb8Xz1WY+zihpY
o72OubkvaPUNTmhGH/BoflPA0XyajBw4a8DfEPBqBo/sQz/J/60C/nFyG2y0
11MRu3LfAzx2789J1IymbFeOx+NeeqVqUtpwBgUsz59sGEcvp/8WcASCHaxe
lL+GHXUTh2jJOGDEIzEDaJsUAcmCYGkNlZjbbfRuUYezwXhKO4kiOXuXptPp
nLaELuMPRBjxZzvYrUfaOZi5EPSQX/UV+BOaWoW4RfyQ8MOSeHy27ziyTJVt
DbRgZ8pZJVmpR+ynpSz5gEN2SZWWrxPonet7whVz4t9kYyrX68jCWfwOSycl
1h1Czn/BUOSkiBFC3YmEtVw6NfMIbv9pf0j7LF/9SLLB5gQ7lruAh/vNA/6G
GdF3rkNYRFcBF/ON+ZS6SLRb0ocdk4Rv26NUvpPDOHHnIuen1BEhjt1Z5rP7
BLj3SnrJdzW7gu/Fak1ZWzDizxesc/LFviuaJs6IXsRHTb4oaRV14qhPiga9
1Xsxvy+u5/0RcH0w6J+ZeTsXLwuhL/r+1Y/S9+8CLf5oNMrO96SNOwS+j/H8
/xoHxqtWbFXblDn7T1NV/gCvJUJk\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{356, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->205057171]
}, Open  ]],

Cell["Perform several different symbolic operations: ", "ExampleText",
 CellID->337932224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "<", "5"}], "&&", 
    RowBox[{"0", "<", "x", "<", "10"}]}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37862673],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "<", "x", "<", 
   FractionBox["11", "2"]}], "||", 
  RowBox[{"6", "\[LessEqual]", "x", "\[LessEqual]", 
   FractionBox["13", "2"]}], "||", 
  RowBox[{"7", "\[LessEqual]", "x", "<", 
   FractionBox["15", "2"]}], "||", 
  RowBox[{"8", "\[LessEqual]", "x", "\[LessEqual]", 
   FractionBox["17", "2"]}], "||", 
  RowBox[{"9", "\[LessEqual]", "x", "<", 
   FractionBox["19", "2"]}]}]], "Output",
 ImageSize->{384, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->842158175]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1035490],

Cell[BoxData[
 FractionBox["5", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->676902627]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->479096687],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Round", "[", "x", "]"}], ">", "x"}], ",", "1", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->12111121]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->85741918],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->423411754]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1933],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 " can be used as a statement:"
}], "ExampleText",
 CellID->309300441],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"-", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", "<", "0"}], ",", 
    RowBox[{"y", "=", 
     RowBox[{"-", "x"}]}], ",", 
    RowBox[{"y", "=", "x"}]}], "]"}], ";", "y"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->725724969],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47422893]
}, Open  ]],

Cell["It can also be used as an expression returning a value:", "ExampleText",
 CellID->444289974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", "<", "0"}], ",", 
    RowBox[{"-", "x"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20886531],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92168810]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->74706796],

Cell["Only the branch actually taken is evaluated:", "ExampleText",
 CellID->764761958],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "1"}], ";"}], "\n", 
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"x", "\[NotEqual]", "0"}], ",", 
   RowBox[{"1", "/", "x"}], ",", "Indeterminate"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->659037528],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->323149531]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->484348347],

Cell["Define a function by cases:", "ExampleText",
 CellID->7015881],

Cell[BoxData[
 RowBox[{
  RowBox[{"sign", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", "<", "0"}], ",", 
    RowBox[{"-", "1"}], ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459463238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sign", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "I"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8052875],

Cell[BoxData[
 RowBox[{
  RowBox[{"Less", "::", "\<\"nord\"\>"}], ":", 
  " ", "\<\"Invalid comparison with \\!\\(\[ImaginaryI]\\) \
attempted.\"\>"}]], "Message", "MSG",
 CellID->319432153],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", "1", ",", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", "<", "0"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "]"}]}], "}"}]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20940500]
}, Open  ]],

Cell["Alternatively, use several conditional definitions:", "ExampleText",
 CellID->66053603],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sign2", "[", 
   RowBox[{"x_", "/;", 
    RowBox[{"x", "<", "0"}]}], "]"}], ":=", 
  RowBox[{"-", "1"}]}], "\n", 
 RowBox[{
  RowBox[{"sign2", "[", 
   RowBox[{"x_", "/;", 
    RowBox[{"x", "\[GreaterEqual]", "0"}]}], "]"}], ":=", "x"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->589065518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sign2", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "I"}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->591148143],

Cell[BoxData[
 RowBox[{
  RowBox[{"Less", "::", "\<\"nord\"\>"}], ":", 
  " ", "\<\"Invalid comparison with \\!\\(\[ImaginaryI]\\) \
attempted.\"\>"}]], "Message", "MSG",
 CellID->63711503],

Cell[BoxData[
 RowBox[{
  RowBox[{"GreaterEqual", "::", "\<\"nord\"\>"}], ":", 
  " ", "\<\"Invalid comparison with \\!\\(\[ImaginaryI]\\) \
attempted.\"\>"}]], "Message", "MSG",
 CellID->105180199],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "0", ",", "1", ",", 
   RowBox[{"sign2", "[", "\[ImaginaryI]", "]"}]}], "}"}]], "Output",
 ImageSize->{138, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->18460414]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26466032],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Which",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Which"]], "InlineFormula"],
 " rather than a nested if-then-elsif chain:"
}], "ExampleText",
 CellID->748792227],

Cell[BoxData[
 RowBox[{
  RowBox[{"cut", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", "<", 
     RowBox[{"-", "1"}]}], ",", 
    RowBox[{"-", "1"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"x", "<", "1"}], ",", "x", ",", "1"}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->521334923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cut", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2"}], ",", 
    RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->87422372],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->607714064]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"cut2", "[", "x_", "]"}], ":=", 
  RowBox[{"Which", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "<", 
     RowBox[{"-", "1"}]}], ",", 
    RowBox[{"-", "1"}], ",", "\[IndentingNewLine]", 
    RowBox[{"x", "<", "1"}], ",", "x", ",", "\[IndentingNewLine]", "True", 
    ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->527710047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cut2", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2"}], ",", 
    RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2"}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->383614711],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->77127598]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13787413],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 " to convert ",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->212175576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"If", "[", 
   RowBox[{"c", ",", "a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->382521058],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFVM0OgjAMLvuRC+LFKMYL76AeeAE9+RALMcGD0SDvjx0ruIxB/EtcsrX9
+t8SjqoqThdVnXOVHkp1K875Pd1fS4R4AAAZ3nUCyNfINTera6T2y/HlqJJI
JdKYZE6ypgyIAXMYsoIoKbRL3RyY6Ed2MrnFjpXr5cqsjW9h4tf5el7/yShH
Z+mbROSJre3EcFd+1N+bMLLZ9szdDOWi4YDRtFUyeH5TfDiDJU+tjCai2+3c
G0dSNl1fiHThtdo0aFvZrpNsm+0I6o/3DRrSxiOaUjI8pd7OIi+6fDeCZbUa
rFG8bP1ZrTpASDSmfEbb/0tB8ABiUHti\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167993514]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{"c1", ",", "a1", ",", "b1"}], "]"}], ",", "a", ",", "b"}], "]"}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34817470],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV0tOwzAQdeOYAupnW1EJygkQS8QeVhwiqiq1CwQq3QNHQFwEWPR6xo6d
xHme1EkogUiJ/cafN36ZjCZ3yWa5uE82q3kyu10nj8vV/Gl287BWJt5jjG3V
PZ0w1Zeql95bKVXrPrl6cjUkVCtUO7KYW6zbiNkOM1ekurFqn/MdmF4i04sd
6IfIsV02glm4CnFkeVzb6775vFV/wyh2akkpMSD21vPi6lN51mpGFhts3vYY
34zlMmTp5XgZsSKmXqoZHDx0GM2OeNo3ch9h2bR/fdW+k7M+Umvm2VeO3Dmf
O6z0fmidAr4AfAQ4DoxfEWf1WU8AXwI+DLDi+DU132PtSxOxQ7BnGcPNFHo4
i+HMLt0Ycmyazc086G0/cJp0vIgjWeQv0cALjE4R8IqTGtXLEPR3iQyifK7M
3ZJF1NqplaK/4u+4lb8daS3y7GdnRaQV12LkdKh2TY9DHoROQOuvd40Jxbm1
N2UR/0LXEGsot7bTcp+xXEvnTnIGVcEgbqX3DzIIt98DZ36F49bEeLbI2nWr
faYifC8RWqrBQp6gOqKmZ0aPGViPAZ9Sq5rWGd67wlUTwFR94Vcn5wSXVuRM
OhVx00qspH2mNVZbgwoGU6uZvyvW+wZ3iyW4\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{182, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->320449924]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"If", "[", 
   RowBox[{"c", ",", 
    RowBox[{"If", "[", 
     RowBox[{"c2", ",", "a2", ",", "b2"}], "]"}], ",", "b"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->392571396],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVktuwjAQNY5DKgGlFf1/JKp2V1W9Baw4RIQqwaJqRFmwyxFYcgSWHKFH
4Bgcw/W3GSaTEMoGS/HYD8+b8XjsYRBPRx+f8XQ8jLv9SZyMxsPvbu9roqCg
xhgbqO/1hqmxVCPzDaRUEvaB7sVsNvsxbbPZ9DI8SNNUmsZC1YXM4lq2lAzA
XEvO3IDZxtVQKNkmGeuGVnvlm9fJo6dG9w91XMVz7pkAdr6HF5ivXcU+vZd/
eiCQbqUIkB6EpSdARQpzt4jfufex4gmW5ICwa23ORMhWE825s22NmwZ2wd3Z
aYWzYouAj95DA/hlIRyjJ5I9dD5EzgftfaTkM7m6f7Sov+1XaNd1t697o2Vj
slgslsulHkZkLB9J9A4wZHZphkvkRYjmD4ArSZL5fH4oV9Wb0qHYCva6O/ep
aItyfbD6Gs1fSC2fobeVVh9DLtKoPt0Q1ZsA1KVIbtcjCd8OgAmZr2OH1aom
iZrM2HpRghxCZw9tZR8/d73n8KZk+chJFNclfH9E4WkJQhu/7icUW4k1fAf2
iQrmapCryHqx88Zjbp75JVarVWraer327ymueg0XL5/F/tb6FwF7VTP8HdKX
NxK1kbpw9t+dtKdn/xmy2i8HdpG0\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{77, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->650640072]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17192],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Switch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Switch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Which",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Which"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Condition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Condition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Boole",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boole"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiracDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiracDelta"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7546]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12623],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RelationalAndLogicalOperators"]], "Tutorials",
 CellID->16100],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Conditionals"]], "Tutorials",
 CellID->20036]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->359317203],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->352447506],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->350361639],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->427392635],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->152631298]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
If"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"If - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 5.0700028}", "context" -> "System`", 
    "keywords" -> {
     "branch", "conditionals", "else", "piecewise functions", "step function",
       "then", "threshold function", "program flow", "control flow"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "If[condition, t, f] gives t if condition evaluates to True, and f if it \
evaluates to False. If[condition, t, f, u] gives u if condition evaluates to \
neither True nor False. ", "synonyms" -> {"cond"}, "title" -> "If", "type" -> 
    "Symbol", "uri" -> "ref/If"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7449, 245, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->70670205]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34851, 1249}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2810, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3433, 89, 40, 1, 70, "ObjectName",
 CellID->20671],
Cell[3476, 92, 1930, 66, 70, "Usage",
 CellID->15031]
}, Open  ]],
Cell[CellGroupData[{
Cell[5443, 163, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5921, 180, 226, 7, 70, "Notes",
 CellID->24252],
Cell[6150, 189, 647, 25, 70, "Notes",
 CellID->7253],
Cell[6800, 216, 612, 24, 70, "Notes",
 CellID->14399]
}, Closed]],
Cell[CellGroupData[{
Cell[7449, 245, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->70670205],
Cell[CellGroupData[{
Cell[7833, 259, 148, 5, 70, "ExampleSection",
 CellID->361511948],
Cell[7984, 266, 232, 8, 70, "Input",
 CellID->761396215],
Cell[CellGroupData[{
Cell[8241, 278, 172, 6, 28, "Input",
 CellID->210429286],
Cell[8416, 286, 213, 7, 36, "Output",
 CellID->234447382]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8678, 299, 220, 7, 70, "ExampleSection",
 CellID->805953521],
Cell[CellGroupData[{
Cell[8923, 310, 231, 7, 70, "ExampleSubsection",
 CellID->612371689],
Cell[9157, 319, 460, 18, 70, "ExampleText",
 CellID->201999957],
Cell[CellGroupData[{
Cell[9642, 341, 155, 5, 70, "Input",
 CellID->108149728],
Cell[9800, 348, 242, 8, 36, "Output",
 CellID->59281721]
}, Open  ]],
Cell[10057, 359, 125, 3, 70, "ExampleDelimiter",
 CellID->389166042],
Cell[10185, 364, 136, 4, 70, "ExampleText",
 CellID->178970992],
Cell[CellGroupData[{
Cell[10346, 372, 180, 6, 70, "Input",
 CellID->265924599],
Cell[10529, 380, 170, 5, 36, "Output",
 CellID->306764873]
}, Open  ]],
Cell[10714, 388, 125, 3, 70, "ExampleDelimiter",
 CellID->845613308],
Cell[10842, 393, 236, 8, 70, "ExampleText",
 CellID->30841451],
Cell[CellGroupData[{
Cell[11103, 405, 189, 6, 70, "Input",
 CellID->195619338],
Cell[11295, 413, 158, 5, 36, "Output",
 CellID->494896214]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11502, 424, 245, 7, 70, "ExampleSubsection",
 CellID->109919502],
Cell[11750, 433, 354, 13, 70, "ExampleText",
 CellID->382272454],
Cell[CellGroupData[{
Cell[12129, 450, 235, 8, 70, "Input",
 CellID->162757792],
Cell[12367, 460, 297, 10, 36, "Output",
 CellID->264408815]
}, Open  ]],
Cell[12679, 473, 239, 8, 70, "ExampleText",
 CellID->140481461],
Cell[CellGroupData[{
Cell[12943, 485, 168, 5, 70, "Input",
 CellID->164933792],
Cell[13114, 492, 1277, 25, 70, "Output",
 Evaluatable->False,
 CellID->205057171]
}, Open  ]],
Cell[14406, 520, 90, 1, 70, "ExampleText",
 CellID->337932224],
Cell[CellGroupData[{
Cell[14521, 525, 227, 8, 70, "Input",
 CellID->37862673],
Cell[14751, 535, 561, 16, 51, "Output",
 CellID->842158175]
}, Open  ]],
Cell[CellGroupData[{
Cell[15349, 556, 186, 6, 70, "Input",
 CellID->1035490],
Cell[15538, 564, 178, 6, 51, "Output",
 CellID->676902627]
}, Open  ]],
Cell[CellGroupData[{
Cell[15753, 575, 120, 4, 70, "Input",
 CellID->479096687],
Cell[15876, 581, 296, 10, 36, "Output",
 CellID->12111121]
}, Open  ]],
Cell[CellGroupData[{
Cell[16209, 596, 202, 7, 70, "Input",
 CellID->85741918],
Cell[16414, 605, 2380, 43, 70, "Output",
 Evaluatable->False,
 CellID->423411754]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[18855, 655, 238, 7, 70, "ExampleSection",
 CellID->1933],
Cell[19096, 664, 193, 7, 70, "ExampleText",
 CellID->309300441],
Cell[CellGroupData[{
Cell[19314, 675, 323, 12, 70, "Input",
 CellID->725724969],
Cell[19640, 689, 157, 5, 36, "Output",
 CellID->47422893]
}, Open  ]],
Cell[19812, 697, 98, 1, 70, "ExampleText",
 CellID->444289974],
Cell[CellGroupData[{
Cell[19935, 702, 199, 7, 70, "Input",
 CellID->20886531],
Cell[20137, 711, 157, 5, 36, "Output",
 CellID->92168810]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20343, 722, 236, 7, 70, "ExampleSection",
 CellID->74706796],
Cell[20582, 731, 87, 1, 70, "ExampleText",
 CellID->764761958],
Cell[CellGroupData[{
Cell[20694, 736, 254, 8, 70, "Input",
 CellID->659037528],
Cell[20951, 746, 158, 5, 36, "Output",
 CellID->323149531]
}, Open  ]],
Cell[21124, 754, 125, 3, 70, "ExampleDelimiter",
 CellID->484348347],
Cell[21252, 759, 68, 1, 70, "ExampleText",
 CellID->7015881],
Cell[21323, 762, 233, 8, 70, "Input",
 CellID->459463238],
Cell[CellGroupData[{
Cell[21581, 774, 181, 6, 70, "Input",
 CellID->8052875],
Cell[21765, 782, 190, 5, 70, "Message",
 CellID->319432153],
Cell[21958, 789, 366, 12, 36, "Output",
 CellID->20940500]
}, Open  ]],
Cell[22339, 804, 93, 1, 70, "ExampleText",
 CellID->66053603],
Cell[22435, 807, 327, 11, 70, "Input",
 CellID->589065518],
Cell[CellGroupData[{
Cell[22787, 822, 184, 6, 70, "Input",
 CellID->591148143],
Cell[22974, 830, 189, 5, 70, "Message",
 CellID->63711503],
Cell[23166, 837, 198, 5, 70, "Message",
 CellID->105180199],
Cell[23367, 844, 287, 9, 36, "Output",
 CellID->18460414]
}, Open  ]],
Cell[23669, 856, 124, 3, 70, "ExampleDelimiter",
 CellID->26466032],
Cell[23796, 861, 222, 8, 70, "ExampleText",
 CellID->748792227],
Cell[24021, 871, 351, 13, 70, "Input",
 CellID->521334923],
Cell[CellGroupData[{
Cell[24397, 888, 211, 7, 70, "Input",
 CellID->87422372],
Cell[24611, 897, 272, 9, 36, "Output",
 CellID->607714064]
}, Open  ]],
Cell[24898, 909, 389, 11, 70, "Input",
 CellID->527710047],
Cell[CellGroupData[{
Cell[25312, 924, 213, 7, 70, "Input",
 CellID->383614711],
Cell[25528, 933, 271, 9, 36, "Output",
 CellID->77127598]
}, Open  ]],
Cell[25814, 945, 124, 3, 70, "ExampleDelimiter",
 CellID->13787413],
Cell[25941, 950, 455, 18, 70, "ExampleText",
 CellID->212175576],
Cell[CellGroupData[{
Cell[26421, 972, 174, 5, 70, "Input",
 CellID->382521058],
Cell[26598, 979, 548, 13, 70, "Output",
 Evaluatable->False,
 CellID->167993514]
}, Open  ]],
Cell[CellGroupData[{
Cell[27183, 997, 246, 8, 70, "Input",
 CellID->34817470],
Cell[27432, 1007, 858, 18, 70, "Output",
 Evaluatable->False,
 CellID->320449924]
}, Open  ]],
Cell[CellGroupData[{
Cell[28327, 1030, 247, 8, 70, "Input",
 CellID->392571396],
Cell[28577, 1040, 849, 18, 70, "Output",
 Evaluatable->False,
 CellID->650640072]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29487, 1065, 311, 9, 70, "SeeAlsoSection",
 CellID->17192],
Cell[29801, 1076, 1422, 53, 70, "SeeAlso",
 CellID->7546]
}, Open  ]],
Cell[CellGroupData[{
Cell[31260, 1134, 314, 9, 70, "TutorialsSection",
 CellID->12623],
Cell[31577, 1145, 172, 3, 70, "Tutorials",
 CellID->16100],
Cell[31752, 1150, 135, 3, 70, "Tutorials",
 CellID->20036]
}, Open  ]],
Cell[CellGroupData[{
Cell[31924, 1158, 319, 9, 70, "MoreAboutSection",
 CellID->359317203],
Cell[32246, 1169, 136, 3, 70, "MoreAbout",
 CellID->352447506],
Cell[32385, 1174, 145, 3, 70, "MoreAbout",
 CellID->350361639],
Cell[32533, 1179, 157, 3, 70, "MoreAbout",
 CellID->427392635],
Cell[32693, 1184, 155, 3, 70, "MoreAbout",
 CellID->152631298]
}, Open  ]],
Cell[CellGroupData[{
Cell[32885, 1192, 305, 8, 70, "RelatedLinksSection"],
Cell[33193, 1202, 380, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[33588, 1218, 27, 0, 70, "History"],
Cell[33618, 1220, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

