(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29390,        956]
NotebookOptionsPosition[     25098,        813]
NotebookOutlinePosition[     26457,        852]
CellTagsIndexPosition[     26372,        847]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ImageSize" :> Documentation`HelpLookup["paclet:ref/ImageSize"],
           "FrameMargins" :> 
          Documentation`HelpLookup["paclet:ref/FrameMargins"], "CellMargins" :> 
          Documentation`HelpLookup["paclet:ref/CellMargins"], 
          "PlotRangeClipping" :> 
          Documentation`HelpLookup["paclet:ref/PlotRangeClipping"], 
          "PlotRangePadding" :> 
          Documentation`HelpLookup["paclet:ref/PlotRangePadding"], 
          "ImagePadding" :> 
          Documentation`HelpLookup["paclet:ref/ImagePadding"], 
          "PreserveImageOptions" :> 
          Documentation`HelpLookup["paclet:ref/PreserveImageOptions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ImageSize\"\>", 
       2->"\<\"FrameMargins\"\>", 3->"\<\"CellMargins\"\>", 
       4->"\<\"PlotRangeClipping\"\>", 5->"\<\"PlotRangePadding\"\>", 
       6->"\<\"ImagePadding\"\>", 
       7->"\<\"PreserveImageOptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Controls Options" :> 
          Documentation`HelpLookup["paclet:guide/ControlsOptions"], 
          "Graphics Shape & Size" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsShapeAndSize"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"], 
          "Plotting and Image Regions" :> 
          Documentation`HelpLookup["paclet:guide/PlottingAndImageRegions"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Controls Options\"\>", 
       2->"\<\"Graphics Shape & Size\"\>", 
       3->"\<\"Options & Styling for Interactive Manipulation\"\>", 
       4->"\<\"Plotting and Image Regions\"\>", 
       5->"\<\"User Interface Structuring & Layout\"\>", 
       6->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ImageMargins", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ImageMargins",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImageMargins"]], "InlineFormula"],
     "\[LineSeparator]is an option which specifies the absolute margins to \
leave around the image displayed for an object. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18703]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["ImageMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageMargins"]], "InlineFormula"],
 " are given in printer\[CloseCurlyQuote]s points. "
}], "Notes",
 CellID->29967],

Cell[TextData[{
 "Margins specified by ",
 Cell[BoxData[
  ButtonBox["ImageMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageMargins"]], "InlineFormula"],
 " appear outside the region defined by ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4683],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["ImageMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageMargins"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->13460],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "margins to be determined by where the object appears ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["m", "TI"], Cell[
    "the same margins on all sides ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["left", "TI"], ",", 
        StyleBox["right", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["bottom", "TI"], ",", 
        StyleBox["top", "TI"]}], "}"}]}], "}"}], Cell[
    "different margins on different sides ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1714],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImageMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageMargins"]], "InlineFormula"],
 " can be used in functions such as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 ", as well as for objects such as ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->12444],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ImageMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageMargins"]], "InlineFormula"],
 " represents space to be left inside whatever ",
 Cell[BoxData[
  ButtonBox["CellMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellMargins"]], "InlineFormula"],
 " are specified for a particular cell. "
}], "Notes",
 CellID->12415]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->771165742],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->654365473],

Cell[TextData[{
 "No margins outside of ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->434772925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{"Disk", "[", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59828532],

Cell[BoxData[
 FrameBox[
  GraphicsBox[DiskBox[{0, 0}]],
  StripOnInput->False]], "Output",
 ImageSize->{114, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->22249457]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->478927274],

Cell["Have 20-point margins on all sides:", "ExampleText",
 CellID->232923249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Disk", "[", "]"}], ",", 
    RowBox[{"ImageMargins", "\[Rule]", "20"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->467423309],

Cell[BoxData[
 FrameBox[
  GraphicsBox[DiskBox[{0, 0}],
   ImageMargins->20],
  StripOnInput->False]], "Output",
 ImageSize->{154, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->11465511]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->680165949],

Cell["Leave different margins on each side:", "ExampleText",
 CellID->919940589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Disk", "[", "]"}], ",", 
    RowBox[{"ImageMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "30"}], "}"}]}], "}"}]}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->853089041],

Cell[BoxData[
 FrameBox[
  GraphicsBox[DiskBox[{0, 0}],
   ImageMargins->{{5, 10}, {20, 30}}],
  StripOnInput->False]], "Output",
 ImageSize->{129, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->192187866]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25086],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImageMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageMargins"]], "InlineFormula"],
 " is defined outside of ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->148872213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pink", ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"ImageMargins", "\[Rule]", "k"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "70"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}], ",",
          
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}]}], 
        "}"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20", ",", "30"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->65892421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[
     {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
     Frame->True,
     FrameTicks->{{{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}, {{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}},
     ImageMargins->10,
     ImageSize->70],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
     Frame->True,
     FrameTicks->{{{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}, {{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}},
     ImageMargins->20,
     ImageSize->70],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
     Frame->True,
     FrameTicks->{{{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}, {{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}},
     ImageMargins->30,
     ImageSize->70],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{401, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221098]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->514312571],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImagePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImagePadding"]], "InlineFormula"],
 " is defined within ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->261838529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pink", ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"ImagePadding", "\[Rule]", "k"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}], ",",
          
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}]}], 
        "}"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20", ",", "30"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->17799],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[
     {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
     Frame->True,
     FrameTicks->{{{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}, {{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}},
     ImagePadding->10,
     ImageSize->100],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
     Frame->True,
     FrameTicks->{{{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}, {{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}},
     ImagePadding->20,
     ImageSize->100],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
     Frame->True,
     FrameTicks->{{{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}, {{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}},
     ImagePadding->30,
     ImageSize->100],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{371, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56653739]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26200],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameMargins"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellMargins"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRangeClipping",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRangeClipping"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRangePadding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRangePadding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImagePadding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImagePadding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PreserveImageOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PreserveImageOptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1667]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->32838596],

Cell[TextData[ButtonBox["Controls Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlsOptions"]], "MoreAbout",
 CellID->353818149],

Cell[TextData[ButtonBox["Graphics Shape & Size",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsShapeAndSize"]], "MoreAbout",
 CellID->468411816],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->116764699],

Cell[TextData[ButtonBox["Plotting and Image Regions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingAndImageRegions"]], "MoreAbout",
 CellID->167844205],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->722769180],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->48433651]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ImageMargins - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 5.7731458}", "context" -> "System`", 
    "keywords" -> {
     "image margins", "graphics margins", "picture margins", 
      "graphics boundary"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ImageMargins is an option which specifies the absolute margins to leave \
around the image displayed for an object. ", "synonyms" -> {"image margins"}, 
    "title" -> "ImageMargins", "type" -> "Symbol", "uri" -> 
    "ref/ImageMargins"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12235, 337, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->771165742]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26228, 840}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2922, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3545, 89, 4196, 83, 70, "ObjectNameGrid"],
Cell[7744, 174, 494, 14, 70, "Usage",
 CellID->18703]
}, Open  ]],
Cell[CellGroupData[{
Cell[8275, 193, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8753, 210, 242, 8, 70, "Notes",
 CellID->29967],
Cell[8998, 220, 366, 13, 70, "Notes",
 CellID->4683],
Cell[9367, 235, 208, 8, 70, "Notes",
 CellID->13460],
Cell[9578, 245, 1113, 30, 70, "2ColumnTableMod",
 CellID->1714],
Cell[10694, 277, 986, 35, 70, "Notes",
 CellID->12444],
Cell[11683, 314, 515, 18, 70, "Notes",
 CellID->12415]
}, Closed]],
Cell[CellGroupData[{
Cell[12235, 337, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->771165742],
Cell[CellGroupData[{
Cell[12620, 351, 148, 5, 70, "ExampleSection",
 CellID->654365473],
Cell[12771, 358, 207, 8, 70, "ExampleText",
 CellID->434772925],
Cell[CellGroupData[{
Cell[13003, 370, 163, 5, 28, "Input",
 CellID->59828532],
Cell[13169, 377, 274, 9, 133, "Output",
 CellID->22249457]
}, Open  ]],
Cell[13458, 389, 125, 3, 70, "ExampleDelimiter",
 CellID->478927274],
Cell[13586, 394, 78, 1, 70, "ExampleText",
 CellID->232923249],
Cell[CellGroupData[{
Cell[13689, 399, 232, 7, 70, "Input",
 CellID->467423309],
Cell[13924, 408, 295, 10, 173, "Output",
 CellID->11465511]
}, Open  ]],
Cell[14234, 421, 125, 3, 70, "ExampleDelimiter",
 CellID->680165949],
Cell[14362, 426, 80, 1, 70, "ExampleText",
 CellID->919940589],
Cell[CellGroupData[{
Cell[14467, 431, 403, 14, 70, "Input",
 CellID->853089041],
Cell[14873, 447, 313, 10, 183, "Output",
 CellID->192187866]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15235, 463, 233, 7, 70, "ExampleSection",
 CellID->25086],
Cell[15471, 472, 335, 12, 70, "ExampleText",
 CellID->148872213],
Cell[CellGroupData[{
Cell[15831, 488, 1017, 33, 70, "Input",
 CellID->65892421],
Cell[16851, 523, 1544, 49, 166, "Output",
 CellID->221098]
}, Open  ]],
Cell[18410, 575, 125, 3, 70, "ExampleDelimiter",
 CellID->514312571],
Cell[18538, 580, 331, 12, 70, "ExampleText",
 CellID->261838529],
Cell[CellGroupData[{
Cell[18894, 596, 1015, 33, 70, "Input",
 CellID->17799],
Cell[19912, 631, 1549, 49, 133, "Output",
 CellID->56653739]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21522, 687, 311, 9, 70, "SeeAlsoSection",
 CellID->26200],
Cell[21836, 698, 1757, 62, 70, "SeeAlso",
 CellID->1667]
}, Open  ]],
Cell[CellGroupData[{
Cell[23630, 765, 318, 9, 70, "MoreAboutSection",
 CellID->32838596],
Cell[23951, 776, 143, 3, 70, "MoreAbout",
 CellID->353818149],
Cell[24097, 781, 153, 3, 70, "MoreAbout",
 CellID->468411816],
Cell[24253, 786, 204, 4, 70, "MoreAbout",
 CellID->116764699],
Cell[24460, 792, 161, 3, 70, "MoreAbout",
 CellID->167844205],
Cell[24624, 797, 180, 3, 70, "MoreAbout",
 CellID->722769180],
Cell[24807, 802, 196, 4, 70, "MoreAbout",
 CellID->48433651]
}, Open  ]],
Cell[25018, 809, 50, 0, 70, "History"],
Cell[25071, 811, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

