(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8178,        287]
NotebookOptionsPosition[      6335,        229]
NotebookOutlinePosition[      7423,        259]
CellTagsIndexPosition[      7380,        256]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ImageSize" :> Documentation`HelpLookup["paclet:ref/ImageSize"], 
         "ImageMargins" :> 
         Documentation`HelpLookup["paclet:ref/ImageMargins"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"ImageSize\"\>", 
      2->"\<\"ImageMargins\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ImageRegion", "ObjectName",
 CellID->30838],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->3252929],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ImageRegion",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImageRegion"]], "InlineFormula"],
     "\[LineSeparator]is an option for cells that specifies the size and \
position of the bounding box within which a graphic is rendered."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7613]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"ImageRegion", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", " ", "1"}], "}"}]}], "}"}]}]], "InlineFormula"],
 ", the bounding box of the graphic coincides with the viewing rectangle for \
the image. The size and position of the viewing rectangle is determined by \
the settings for ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ImageMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageMargins"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8550],

Cell[TextData[{
 "By changing the value of ",
 Cell[BoxData[
  ButtonBox["ImageRegion",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageRegion"]], "InlineFormula"],
 ", you can select a specific region of a graphic for viewing. This option is \
specified as ",
 Cell[BoxData[
  RowBox[{"ImageRegion", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["l", "TI"], ",", " ", 
       StyleBox["r", "TI"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["b", "TI"], ",", " ", 
       StyleBox["t", "TI"]}], "}"}]}], "}"}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["l", "TI"], ",", " ", 
    StyleBox["r", "TI"]}], "}"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["b", "TI"], ",", " ", 
    StyleBox["t", "TI"]}], "}"}]], "InlineFormula"],
 StyleBox[" ",
  FontSlant->"Italic"],
 "specify the coordinates of the bottom left and top right corners of the \
bounding box of the graphic."
}], "Notes",
 CellID->8933],

Cell["\<\
The size of the graphic scales according to the size of the bounding box. \
Hence, you can use this option for zooming in or zooming out. If the bounding \
box you specify is larger than the image size, only the part of the graphic \
that fits within the viewing rectangle for the image is displayed.\
\>", "Notes",
 CellID->5348],

Cell[TextData[{
 "The numbers ",
 Cell[BoxData[
  StyleBox["l", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " can take any positive or negative value, subject to the constraint that \
the aspect ratio of the graphic, which is equal to ",
 Cell[BoxData[
  FractionBox[
   RowBox[{
    StyleBox["b", "TI"], 
    StyleBox[" ", "TI"], "-", " ", 
    StyleBox["t", "TI"]}], 
   RowBox[{
    StyleBox["l", "TI"], " ", "-", " ", 
    StyleBox["r", "TI"]}]]], "InlineFormula"],
 ", is always preserved."
}], "Notes",
 CellID->22831]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4117],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageMargins"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26324]
}, Open  ]],

Cell["New in 4.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ImageRegion - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 12.3358138}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ImageRegion is an option for cells that specifies the size and position \
of the bounding box within which a graphic is rendered.", 
    "synonyms" -> {"image region"}, "title" -> "ImageRegion", "type" -> 
    "Symbol", "uri" -> "ref/ImageRegion"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 676, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1299, 43, 49, 1, 70, "ObjectName",
 CellID->30838],
Cell[1351, 46, 216, 6, 70, "AwaitingReviewNote",
 CellID->3252929],
Cell[1570, 54, 505, 14, 70, "Usage",
 CellID->7613]
}, Open  ]],
Cell[CellGroupData[{
Cell[2112, 73, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2590, 90, 749, 24, 70, "Notes",
 CellID->8550],
Cell[3342, 116, 1059, 37, 70, "Notes",
 CellID->8933],
Cell[4404, 155, 340, 6, 70, "Notes",
 CellID->5348],
Cell[4747, 163, 703, 26, 70, "Notes",
 CellID->22831]
}, Closed]],
Cell[CellGroupData[{
Cell[5487, 194, 310, 9, 70, "SeeAlsoSection",
 CellID->4117],
Cell[5800, 205, 461, 17, 70, "SeeAlso",
 CellID->26324]
}, Open  ]],
Cell[6276, 225, 29, 0, 70, "History"],
Cell[6308, 227, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

