(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18992,        605]
NotebookOptionsPosition[     15630,        493]
NotebookOutlinePosition[     17038,        532]
CellTagsIndexPosition[     16953,        527]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"], 
          "Exporting Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExportingGraphicsAndSounds"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing Graphics and Sounds\"\>", 
       2->"\<\"Exporting Graphics and Sounds\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ImageSize" :> Documentation`HelpLookup["paclet:ref/ImageSize"],
           "Rasterize" :> Documentation`HelpLookup["paclet:ref/Rasterize"], 
          "RasterSize" :> Documentation`HelpLookup["paclet:ref/RasterSize"], 
          "Magnification" :> 
          Documentation`HelpLookup["paclet:ref/Magnification"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ImageSize\"\>", 
       2->"\<\"Rasterize\"\>", 3->"\<\"RasterSize\"\>", 
       4->"\<\"Magnification\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Graphics Importing & Exporting\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ImageResolution", "ObjectName",
 CellID->20224],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ImageResolution",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImageResolution"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Export",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Export"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Rasterize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Rasterize"]], "InlineFormula"],
     " which specifies at what resolution bitmap images should be rendered. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4986]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ImageResolution", "->", 
   StyleBox["r", "TI"]}]], "InlineFormula"],
 " specifies that a bitmap should be rendered at a resolution of ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " dpi. "
}], "Notes",
 CellID->20463],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImageResolution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageResolution"]], "InlineFormula"],
 " is relevant only for bitmap graphics formats such as ",
 Cell[BoxData[
  ButtonBox["\"\<TIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TIFF"]], "InlineFormula"],
 ", and not for resolution\[Hyphen]independent formats such as ",
 Cell[BoxData[
  ButtonBox["\"\<EPS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/EPS"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13331],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"ImageResolution", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " typically uses a resolution of 72 dpi for bitmap graphics formats. "
}], "Notes",
 CellID->21901]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->94839487],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->641196724],

Cell["Set different image resolution in dpi:", "ExampleText",
 CellID->573595349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Rasterize", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ",", "40"}], "]"}], ",", 
     RowBox[{"ImageResolution", "\[Rule]", "r"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "40", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->58150907],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJzVks0JgDAMhQve3cGDu/TsCC7gpeN0l4ySUTTpjyjYGG0RDBQKDe977+kw
L9PcGWN6OiMdvq+/HW9NHOvxQ6iD8iu46Ih2DldxwAvuWUROh9SC9cGYqgcB
hyGbHDARFZ3n/KUvBC7Y5j0BSLCc7q7IIFZIh4dUDL5cio4Zl7zfEq9xuaCz
pmpw/6dVcRvosMEq1GOd74gAkDbreEqdvfTKdK103s4G3fJx3Q==
     "], {{0, 0}, {133.20000000000002`, 50.4}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{133.20000000000002`, 50.4},
    PlotRange->{{0, 133.20000000000002`}, {0, 50.4}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztlssNwyAQRJFSRY5pJuKcEtxALpTjXlwKpSRAHBvwoniXkdaRPJIl2wf2
DbN8bsPzMVyMMdfw3MMT31+nTnE0ObORHb02FkbRnJu0KaDyow35aFNgJY0p
zsWqeYSiofvD96MTrIYEIS2eEq5r4nKXOErVLcW1V5UpaBsLHM0t17lBLKbQ
q5LtaAXwZPswtEQtHyKDovUbsEimM6YPB/og4GVUd0iHpe9Q8NON5YioLuu8
cmawphiO6CXMx6HGAZra76hZlBVTfpxuT9hlHGKlg28pRdXGbw8kSZtGNn/h
W+nehSSJ03WM6z2QpPvIgwlIUqeuJyRJSP0QnpAk/+8p7Si++gYxKZEUTau6
6wFJsgu18n7XJnkDbffz1g==
     "], {{0, 0}, {126., 45.}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{126., 45.},
    PlotRange->{{0, 126.}, {0, 45.}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJztm8ttwzAQRAWkkhSSu88pwQ3k4nLcRCpwKSqFUWzJkvVdUjZ3hp4HBMgh
TlaLp1mKYj6PP9/Hj6qqvpqv3+br//sghBBCCCEoqM+HKorDufauWbwUKSHs
XE6SQIzoEuR08a5EgFDLCTGmHx7elQgUFBRigoJCjFFQiAkKCjEGJSg6N5eY
L2/jU9p3SaHf4/QNirdW4nYZINP7oacINfW78PHVoOgdDZAS49cgGJ1Ms6KX
G+MqYsBR4t7F0xlkRdERawWzDwFHiXtEXCcu3KOH3QpyHwKMEmMH+si4uNY1
wGIFvw8BRImZZ0+Ux9EH1q0owoeAocT8mMA8RrFkRSk+BAQlFvMAMijCnBUF
+RAAlFhbSWIGRXi0oiwfgrsSG0mAGhRhaAWdD9HnYKe87ibdftiEDYowtILI
hwCthCkDUINi/EIDrLwdOA4O634UYFAM1w973oNA4qZExN0PFhTT9WRZVngp
EbdljRMUS88XBVnho0T0fY8RFOvPm6VY4aJEylst96Cw7D8UYYWDEol3vKsT
9v0ofivyK5H+4ttreMTuT5JbkVuJXYsCj6DofYipmNmKzErsPRuTMSjWDtfO
Orm2KTh/vVunfk2/5OnkUmLt6tf/uv2Tz+3w2yqRCz4lMtAWbJiD15/0L5gO
xg53GhuOdPrv01FC2eF24EAoWiaMHb4HnHchxcLY4W51yvfUygJlh1uVqWrm
grHD9jWySIOxw23AUdXMBWOHKcceFZQdZhx7XDB2mLFmLhg7fKuZauqRQdjh
dupRicwFYYdvJVN5TAZfh7uKvesoF6QON6Vsy4lUMB1kHTZOsW4FlKWmsiDs
sGW9S7jXBgRfh7e20axHQMQShB2ul85zD/9boPaprQwoOxx9+FdEwtnh6Rlv
oCwrgoQO/wHwA9+E
     "], {{0, 0}, {127.44, 43.92}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{127.44, 43.92},
    PlotRange->{{0, 127.44}, {0, 43.92}}]}], "}"}]], "Output",
 ImageSize->{427, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65210234]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31809],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RasterSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RasterSize"]], "InlineFormula"],
 " overrides ",
 Cell[BoxData[
  ButtonBox["ImageResolution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageResolution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->182039707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Rasterize", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ",", "50"}], "]"}], ",", 
     RowBox[{"RasterSize", "\[Rule]", "100"}]}], "]"}], ",", 
   RowBox[{"Rasterize", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ",", "50"}], "]"}], ",", 
     RowBox[{"ImageResolution", "\[Rule]", "20"}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->482299855],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJztmF0OgyAQhE16kqaX8blHsAfoi8fxLh6Fo1gWrEEF/GFYuw2TmJi2kZ2P
KQvem/ezuVVV9dDXS190PxQVFfnVt1VQdaeuLu931dUE6OoqJMhErO2vLkOC
Sqj2qoRqt4Ch8nQLZw7i36KlRwM/nUAhS7Y8Il3U/iB3itGgpmlGrlRhVspM
C8eqiAVlHGlDpvwMEzBnxUdpwIJy+IzEQA+2mrNipTRAQc3gZAgVaaTTM1Ma
gKBWZHKEimSbRW5KseNZUpP1YMkSKjVyYj9NYhIVYIIOlbMujXcK9uwtQUAF
gSBDtVq90Ru2uACgojRAofp2vMXHjKzSQW2gAIQquvXmYpUKStmjnYoPcTpU
q+bjFDst656zQKRpnbSbAmpZzZJXyCXehb+09cNoWgW92uBxsSPrAsTkgqZE
PCsmF4XVsVEkLU1+8bgorI6NUv6Du2Q6iPhYsbig+RBPCuzCuykTtuFkceHD
Lm+ZYnGxOGPmeuOaWUwuZsdKUX86V//h4nJ9ABKW5l0=
     "], {{0, 0}, {157.41, 55.64999999999999}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{157.41, 55.64999999999999},
    PlotRange->{{0, 157.41}, {0, 55.64999999999999}}], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzdlc0JwzAMhQWdoCP03EV07ghZoBePo108ikdp/VM5uJDoqTgEKjAooDx9
flHs2/J8LBciuuZ1z6vkr7+MJEw9WNJpIMIHd48hRKOAjIrVrVKY612uIQAm
QWNgaXlNse4AQPkEEhDB7gPWfRiyzdfUf2HbBJV0zsyuA+sERsuEpMZXDAAX
AEjDvvdMUDsLgeYowybAZ5rbxvsDJvqlQS6iuZrVjkmtf9aszJMh3JoxzgUA
NVP5jVqxfZ6C4dR0nk4owvl35BhvilG5Yg==
     "], {{0, 0}, {154.8, 61.2}}, {0, 255},
     ColorFunction->RGBColor],
    ImageSize->{154.8, 61.2},
    PlotRange->{{0, 154.8}, {0, 61.2}}]}], "}"}]], "Output",
 ImageSize->{342, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94644737]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rasterize", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ",", "50"}], "]"}], ",", 
   RowBox[{"RasterSize", "\[Rule]", "100"}], ",", 
   RowBox[{"ImageResolution", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->961760909],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmF0OgyAQhE16kqaX8blHsAfoi8fxLh6Fo1gWrEEF/GFYuw2TmJi2kZ2P
KQvem/ezuVVV9dDXS190PxQVFfnVt1VQdaeuLu931dUE6OoqJMhErO2vLkOC
Sqj2qoRqt4Ch8nQLZw7i36KlRwM/nUAhS7Y8Il3U/iB3itGgpmlGrlRhVspM
C8eqiAVlHGlDpvwMEzBnxUdpwIJy+IzEQA+2mrNipTRAQc3gZAgVaaTTM1Ma
gKBWZHKEimSbRW5KseNZUpP1YMkSKjVyYj9NYhIVYIIOlbMujXcK9uwtQUAF
gSBDtVq90Ru2uACgojRAofp2vMXHjKzSQW2gAIQquvXmYpUKStmjnYoPcTpU
q+bjFDst656zQKRpnbSbAmpZzZJXyCXehb+09cNoWgW92uBxsSPrAsTkgqZE
PCsmF4XVsVEkLU1+8bgorI6NUv6Du2Q6iPhYsbig+RBPCuzCuykTtuFkceHD
Lm+ZYnGxOGPmeuOaWUwuZsdKUX86V//h4nJ9ABKW5l0=
   "], {{0, 0}, {157.41, 55.64999999999999}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{157.41, 55.64999999999999},
  PlotRange->{{0, 157.41}, {0, 55.64999999999999}}]], "Output",
 ImageSize->{161, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->250603838]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12728],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rasterize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rasterize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RasterSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RasterSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Magnification",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magnification"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24251]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30753],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "Tutorials",
 CellID->9009],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "Tutorials",
 CellID->503348882]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->280297403],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout",
 CellID->449434395]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ImageResolution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 12.5389440}", "context" -> "System`", 
    "keywords" -> {
     "density of lines", "dot density", "dots per inch", "printer resolution",
       "resolution", "screen density"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ImageResolution is an option for Export and Rasterize which specifies at \
what resolution bitmap images should be rendered. ", 
    "synonyms" -> {"image resolution"}, "title" -> "ImageResolution", "type" -> 
    "Symbol", "uri" -> "ref/ImageResolution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5471, 174, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->94839487]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16811, 520}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2324, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2947, 82, 53, 1, 70, "ObjectName",
 CellID->20224],
Cell[3003, 85, 774, 23, 70, "Usage",
 CellID->4986]
}, Open  ]],
Cell[CellGroupData[{
Cell[3814, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4292, 130, 275, 9, 70, "Notes",
 CellID->20463],
Cell[4570, 141, 558, 17, 70, "Notes",
 CellID->13331],
Cell[5131, 160, 303, 9, 70, "Notes",
 CellID->21901]
}, Closed]],
Cell[CellGroupData[{
Cell[5471, 174, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->94839487],
Cell[CellGroupData[{
Cell[5855, 188, 148, 5, 70, "ExampleSection",
 CellID->641196724],
Cell[6006, 195, 81, 1, 70, "ExampleText",
 CellID->573595349],
Cell[CellGroupData[{
Cell[6112, 200, 498, 17, 28, "Input",
 CellID->58150907],
Cell[6613, 219, 2372, 49, 73, "Output",
 CellID->65210234]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9034, 274, 233, 7, 70, "ExampleSection",
 CellID->31809],
Cell[9270, 283, 331, 12, 70, "ExampleText",
 CellID->182039707],
Cell[CellGroupData[{
Cell[9626, 299, 629, 21, 70, "Input",
 CellID->482299855],
Cell[10258, 322, 1431, 31, 84, "Output",
 CellID->94644737]
}, Open  ]],
Cell[CellGroupData[{
Cell[11726, 358, 363, 11, 70, "Input",
 CellID->961760909],
Cell[12092, 371, 910, 19, 77, "Output",
 CellID->250603838]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13063, 397, 311, 9, 70, "SeeAlsoSection",
 CellID->12728],
Cell[13377, 408, 959, 35, 70, "SeeAlso",
 CellID->24251]
}, Open  ]],
Cell[CellGroupData[{
Cell[14373, 448, 314, 9, 70, "TutorialsSection",
 CellID->30753],
Cell[14690, 459, 165, 3, 70, "Tutorials",
 CellID->9009],
Cell[14858, 464, 170, 3, 70, "Tutorials",
 CellID->503348882]
}, Open  ]],
Cell[CellGroupData[{
Cell[15065, 472, 319, 9, 70, "MoreAboutSection",
 CellID->280297403],
Cell[15387, 483, 171, 3, 70, "MoreAbout",
 CellID->449434395]
}, Open  ]],
Cell[15573, 489, 27, 0, 70, "History"],
Cell[15603, 491, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

