(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     93584,       2384]
NotebookOptionsPosition[     85904,       2128]
NotebookOutlinePosition[     87634,       2171]
CellTagsIndexPosition[     87548,       2166]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Scaled" :> Documentation`HelpLookup["paclet:ref/Scaled"], 
          "PlotRange" :> Documentation`HelpLookup["paclet:ref/PlotRange"], 
          "PlotRegion" :> Documentation`HelpLookup["paclet:ref/PlotRegion"], 
          "Offset" :> Documentation`HelpLookup["paclet:ref/Offset"], 
          "ImageSize" :> Documentation`HelpLookup["paclet:ref/ImageSize"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Scaled\"\>", 
       2->"\<\"PlotRange\"\>", 3->"\<\"PlotRegion\"\>", 4->"\<\"Offset\"\>", 
       5->"\<\"ImageSize\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Coordinates" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsCoordinates"], 
          "Graphics Shape & Size" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsShapeAndSize"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicGraphicsLanguage"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graphics Coordinates\"\>", 
       2->"\<\"Graphics Shape & Size\"\>", 
       3->"\<\"Symbolic Graphics Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ImageScaled", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ImageScaled",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ImageScaled"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the position of a graphical object in terms of \
coordinates scaled to run from ",
     Cell[BoxData["0"], "InlineFormula"],
     " to ",
     Cell[BoxData["1"], "InlineFormula"],
     " across the whole image region in each direction. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ImageScaled",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ImageScaled"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["dx", "TI"], ",", 
          StyleBox["dy", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["0", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["0", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a position obtained by starting at ordinary \
coordinates ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["0", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["0", "TR"]]}], "}"}]], "InlineFormula"],
     ", then moving by an image\[Hyphen]scaled offset ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["dx", "TI"], ",", 
        StyleBox["dy", "TI"]}], "}"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->12771]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " can be used to specify scaled coordinates in any two\[Hyphen]dimensional \
graphics primitive. "
}], "Notes",
 CellID->9537],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " to represent objects that occupy a fixed region in the image associated \
with a graphic. "
}], "Notes",
 CellID->17140],

Cell[TextData[{
 "The image region used to define ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " includes only the region in which the graphic can actually be drawn. It \
does not include empty space arising from mismatches in shape between ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 ", or defined by ",
 Cell[BoxData[
  ButtonBox["ImageMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageMargins"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->51975148]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->455874348],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->441505081],

Cell["Positions of objects by fractions of the whole image:", "ExampleText",
 CellID->232526863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"ImageScaled", "[", 
       RowBox[{"{", 
        RowBox[{".2", ",", ".4"}], "}"}], "]"}], ",", "1"}], "]"}], "}"}], 
   ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->411764437],

Cell[BoxData[
 GraphicsBox[DiskBox[ImageScaled[{0.2, 0.4}]],
  Frame->True,
  PlotRange->{{0, 10}, {0, 10}}]], "Output",
 ImageSize->{154, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->391506624]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->413691147],

Cell["Radii by fractions of the whole image:", "ExampleText",
 CellID->377632899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"ImageScaled", "[", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".25"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71870058],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}, ImageScaled[{0.5, 0.25}]],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->21645351]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->282726276],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageScaled Positions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->72931868],

Cell["Specify coordinates by fractions of the whole image:", "ExampleText",
 CellID->438146033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"ImageScaled", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", ".4"}], "}"}], "]"}], ",", 
     RowBox[{"ImageScaled", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", ".6"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->561502949],

Cell[BoxData[
 GraphicsBox[RectangleBox[ImageScaled[{0, 0.4}], ImageScaled[{1, 0.6}]],
  Frame->True,
  PlotRange->{{0, 10}, {0, 10}}]], "Output",
 ImageSize->{154, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->274906227]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4539416],

Cell["Specify the radii by fractions of the whole image:", "ExampleText",
 CellID->43264506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"ImageScaled", "[", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".25"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->343461723],

Cell[BoxData[
 GraphicsBox[DiskBox[{0, 0}, ImageScaled[{0.5, 0.25}]],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->168832360]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->89173722],

Cell["\<\
Specify the positions of light sources in the view coordinate system pointing \
to the center: \
\>", "ExampleText",
 CellID->395910470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<Directional\>\"", ",", "Red", ",", 
        RowBox[{"ImageScaled", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Directional\>\"", ",", "Blue", ",", 
        RowBox[{"ImageScaled", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "2"}], ",", "2"}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Directional\>\"", ",", "Green", ",", 
        RowBox[{"ImageScaled", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2", ",", "2"}], "}"}], "]"}]}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->302605855],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  Lighting->{{"Directional", 
     RGBColor[1, 0, 0], 
     ImageScaled[{2, 2, 2}]}, {"Directional", 
     RGBColor[0, 0, 1], 
     ImageScaled[{-2, -2, 2}]}, {"Directional", 
     RGBColor[0, 1, 0], 
     ImageScaled[{-2, 2, 2}]}}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->84947337,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageScaled Offsets",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->90466844],

Cell["Specify image-scaled offsets from the ordinary coordinates:", \
"ExampleText",
 CellID->447526172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"ImageScaled", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".25"}], ",", ".25"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->239011770],

Cell[BoxData[
 GraphicsBox[CircleBox[ImageScaled[{-0.25, 0.25}, {0, 0}]],
  Frame->True]], "Output",
 ImageSize->{184, 171},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->718071159]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24972],

Cell["Place a watermark on top of the graphic:", "ExampleText",
 CellID->13673568],

Cell[BoxData[
 RowBox[{
  RowBox[{"wm", "[", "pos_", "]"}], ":=", 
  RowBox[{"Text", "[", 
   RowBox[{
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Grid", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{"\"\<xyz\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "5"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "5"}], "}"}]}], "]"}], ",", 
        RowBox[{"Spacings", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{".3", ",", ".3"}], "}"}]}]}], "]"}], ",", "Large", ",", 
      "Bold", ",", 
      RowBox[{"Opacity", "[", ".1", "]"}]}], "]"}], ",", "pos", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27475518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"ImagePadding", "\[Rule]", "20"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"wm", "[", 
     RowBox[{"ImageScaled", "[", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5"}], "}"}], "]"}], "]"}]}], ",", 
   RowBox[{"PlotRangeClipping", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->268124671],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Epilog->InsetBox[
    FormBox[
     StyleBox[
      TagBox[
       GridBox[{{"\"xyz\"", "\"xyz\"", "\"xyz\"", "\"xyz\"", "\"xyz\""}, {
         "\"xyz\"", "\"xyz\"", "\"xyz\"", "\"xyz\"", "\"xyz\""}, {
         "\"xyz\"", "\"xyz\"", "\"xyz\"", "\"xyz\"", "\"xyz\""}, {
         "\"xyz\"", "\"xyz\"", "\"xyz\"", "\"xyz\"", "\"xyz\""}, {
         "\"xyz\"", "\"xyz\"", "\"xyz\"", "\"xyz\"", "\"xyz\""}}, 
        GridBoxItemSize -> {
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, ColumnsEqual -> 
        False, RowsEqual -> False, 
        GridBoxSpacings -> {"Columns" -> {{0.3}}, "Rows" -> {{0.3}}}], 
       "Grid"], Large, Bold, 
      Opacity[0.1], StripOnInput -> False], TraditionalForm], 
    ImageScaled[{0.5, 0.5}], {0, 0}, Automatic, {2, 1}],
  ImagePadding->20,
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
     0, 6.283185307179586}, {-0.9999998592131705, 0.9999998782112116}}],
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->377271549]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->575947693],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " is proportional to ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " is proportional to ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->102209229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", 
          RowBox[{".1", ",", "Blue"}], "]"}], ",", 
         RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"ImageScaled", "[", 
            RowBox[{"{", 
             RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}], ",", 
           RowBox[{"ImageScaled", "[", 
            RowBox[{"{", 
             RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}]}], "]"}]}], "}"}], ",",
        
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"ImagePadding", "\[Rule]", "n"}]}], "]"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "0"}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", "Orange"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "20", ",", "40"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107703904],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[
     {RGBColor[0, 0, 1], Opacity[0.1], EdgeForm[GrayLevel[0]], 
      DiskBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.5, 0.5}]]},
     Frame->True,
     ImagePadding->0],
    FrameMargins->0,
    FrameStyle->RGBColor[1, 0.5, 0],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     {RGBColor[0, 0, 1], Opacity[0.1], EdgeForm[GrayLevel[0]], 
      DiskBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.5, 0.5}]]},
     Frame->True,
     ImagePadding->20],
    FrameMargins->0,
    FrameStyle->RGBColor[1, 0.5, 0],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     {RGBColor[0, 0, 1], Opacity[0.1], EdgeForm[GrayLevel[0]], 
      DiskBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.5, 0.5}]]},
     Frame->True,
     ImagePadding->40],
    FrameMargins->0,
    FrameStyle->RGBColor[1, 0.5, 0],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{497, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->6956200]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->812392729],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " operates relative to the whole image:"
}], "ExampleText",
 CellID->9100586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{".2", ",", ".2"}], "}"}], "]"}], ",", ".2"}], "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->626875500],

Cell[BoxData[
 FrameBox[
  GraphicsBox[DiskBox[ImageScaled[{0.2, 0.2}], 0.2],
   Frame->True],
  FrameMargins->None,
  StripOnInput->False]], "Output",
 ImageSize->{156, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->317870368]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64790640],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " operates relative to the plot range:"
}], "ExampleText",
 CellID->39172006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{".2", ",", ".2"}], "}"}], "]"}], ",", ".2"}], "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->305388891],

Cell[BoxData[
 FrameBox[
  GraphicsBox[DiskBox[Scaled[{0.2, 0.2}], 0.2],
   Frame->True],
  FrameMargins->None,
  StripOnInput->False]], "Output",
 ImageSize->{156, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->4525275]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23134457],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["PlotRangeClipping",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangeClipping"]], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", objects outside of the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " will be clipped: "
}], "ExampleText",
 CellID->34655400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Disk", "[", 
        RowBox[{
         RowBox[{"ImageScaled", "[", 
          RowBox[{"{", 
           RowBox[{".2", ",", ".2"}], "}"}], "]"}], ",", ".3"}], "]"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotRangeClipping", "\[Rule]", "prc"}]}], "]"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"prc", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->955088660],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[DiskBox[ImageScaled[{0.2, 0.2}], 0.3],
     Frame->True,
     PlotRangeClipping->False],
    FrameMargins->None,
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[DiskBox[ImageScaled[{0.2, 0.2}], 0.3],
     Frame->True,
     PlotRangeClipping->True],
    FrameMargins->None,
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{334, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->761193327]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->639586970],

Cell[TextData[{
 "Objects with image-scaled coordinates outside ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " may not be displayed:"
}], "ExampleText",
 CellID->385152146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"ImageScaled", "[", 
      RowBox[{"{", 
       RowBox[{"1.5", ",", ".5"}], "}"}], "]"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->619069663],

Cell[BoxData[
 GraphicsBox[DiskBox[ImageScaled[{1.5, 0.5}]],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->39246537]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41897285],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["PlotRangeClipping",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangeClipping"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " for plot functions: "
}], "ExampleText",
 CellID->466702994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"x", "^", "2"}], "]"}], ",", 
        RowBox[{"ImageScaled", "[", 
         RowBox[{"{", 
          RowBox[{"0.5", ",", "1"}], "}"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", "Medium"}], 
     "]"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1981185],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20798797]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " to include objects outside of the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->44783562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"x", "^", "2"}], "]"}], ",", 
        RowBox[{"ImageScaled", "[", 
         RowBox[{"{", 
          RowBox[{"0.5", ",", "1"}], "}"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", "Medium"}], 
     "]"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRangeClipping", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->127508062],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11541786]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->309175476],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " sizes, the appearance of the graphic will depend on the ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->103790996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{".5", ",", ".5"}], "}"}], "]"}], ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{".25", ",", ".25"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}], ",", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}]}], 
       "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "n"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "70", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->42263118],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[DiskBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->50], ",", 
   GraphicsBox[DiskBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->70], ",", 
   GraphicsBox[DiskBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->100]}], "}"}]], "Output",
 ImageSize->{261, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->552593872]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{".5", ",", ".5"}], "}"}], "]"}], ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{".25", ",", ".25"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}], ",", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}]}], 
       "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "n"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->284727558],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[DiskBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    AspectRatio->1,
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->100], ",", 
   GraphicsBox[DiskBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    AspectRatio->NCache[
      Rational[1, 2], 0.5],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->100], ",", 
   GraphicsBox[DiskBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    AspectRatio->NCache[
      Rational[1, 3], 0.3333333333333333],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->100]}], "}"}]], "Output",
 ImageSize->{341, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->161469580]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3636],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRegion"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Offset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Offset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3461]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1215616],

Cell[TextData[ButtonBox["Graphics Coordinates",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsCoordinates"]], "MoreAbout",
 CellID->19474329],

Cell[TextData[ButtonBox["Graphics Shape & Size",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsShapeAndSize"]], "MoreAbout",
 CellID->657683352],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->5781288]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ImageScaled - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 13.1952108}", "context" -> "System`", 
    "keywords" -> {
     "camera-fixed coordinates", "camera-fixed lights", 
      "final image coordinates", "image scaled coordinates", 
      "image size oriented coordinates", "relative coordinates", 
      "scaled coordinates", "view-fixed coordinates", "view-fixed lights"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ImageScaled[{x, y}] gives the position of a graphical object in terms of \
coordinates scaled to run from 0 to 1 across the whole image region in each \
direction. ImageScaled[{dx, dy}, {x_0, y_0}] gives a position obtained by \
starting at ordinary coordinates {x_0, y_0}, then moving by an image-scaled \
offset {dx, dy}. ", "synonyms" -> {"image scaled"}, "title" -> "ImageScaled", 
    "type" -> "Symbol", "uri" -> "ref/ImageScaled"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7879, 240, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->455874348]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 87405, 2159}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1875, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2498, 68, 1576, 37, 70, "ObjectNameGrid"],
Cell[4077, 107, 1927, 61, 70, "Usage",
 CellID->12771]
}, Open  ]],
Cell[CellGroupData[{
Cell[6041, 173, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6519, 190, 268, 8, 70, "Notes",
 CellID->9537],
Cell[6790, 200, 281, 9, 70, "Notes",
 CellID->17140],
Cell[7074, 211, 768, 24, 70, "Notes",
 CellID->51975148]
}, Closed]],
Cell[CellGroupData[{
Cell[7879, 240, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->455874348],
Cell[CellGroupData[{
Cell[8264, 254, 148, 5, 70, "ExampleSection",
 CellID->441505081],
Cell[8415, 261, 96, 1, 70, "ExampleText",
 CellID->232526863],
Cell[CellGroupData[{
Cell[8536, 266, 563, 19, 47, "Input",
 CellID->411764437],
Cell[9102, 287, 304, 9, 174, "Output",
 CellID->391506624]
}, Open  ]],
Cell[9421, 299, 125, 3, 70, "ExampleDelimiter",
 CellID->413691147],
Cell[9549, 304, 81, 1, 70, "ExampleText",
 CellID->377632899],
Cell[CellGroupData[{
Cell[9655, 309, 374, 12, 70, "Input",
 CellID->71870058],
Cell[10032, 323, 281, 8, 163, "Output",
 CellID->21645351]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10362, 337, 220, 7, 70, "ExampleSection",
 CellID->282726276],
Cell[CellGroupData[{
Cell[10607, 348, 241, 7, 70, "ExampleSubsection",
 CellID->72931868],
Cell[10851, 357, 95, 1, 70, "ExampleText",
 CellID->438146033],
Cell[CellGroupData[{
Cell[10971, 362, 631, 20, 70, "Input",
 CellID->561502949],
Cell[11605, 384, 330, 9, 174, "Output",
 CellID->274906227]
}, Open  ]],
Cell[11950, 396, 123, 3, 70, "ExampleDelimiter",
 CellID->4539416],
Cell[12076, 401, 92, 1, 70, "ExampleText",
 CellID->43264506],
Cell[CellGroupData[{
Cell[12193, 406, 373, 12, 70, "Input",
 CellID->343461723],
Cell[12569, 420, 280, 8, 163, "Output",
 CellID->168832360]
}, Open  ]],
Cell[12864, 431, 124, 3, 70, "ExampleDelimiter",
 CellID->89173722],
Cell[12991, 436, 146, 4, 70, "ExampleText",
 CellID->395910470],
Cell[CellGroupData[{
Cell[13162, 444, 946, 27, 70, "Input",
 CellID->302605855],
Cell[14111, 473, 29904, 498, 184, 295, 8, "CachedBoxData", "BoxData", \
"Output",
 CellID->84947337]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44064, 977, 239, 7, 70, "ExampleSubsection",
 CellID->90466844],
Cell[44306, 986, 104, 2, 70, "ExampleText",
 CellID->447526172],
Cell[CellGroupData[{
Cell[44435, 992, 434, 14, 70, "Input",
 CellID->239011770],
Cell[44872, 1008, 232, 7, 192, "Output",
 CellID->718071159]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[45165, 1022, 223, 7, 70, "ExampleSection",
 CellID->24972],
Cell[45391, 1031, 82, 1, 70, "ExampleText",
 CellID->13673568],
Cell[45476, 1034, 818, 25, 70, "Input",
 CellID->27475518],
Cell[CellGroupData[{
Cell[46319, 1063, 521, 15, 70, "Input",
 CellID->268124671],
Cell[46843, 1080, 10219, 180, 148, "Output",
 CellID->377271549]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[57111, 1266, 237, 7, 70, "ExampleSection",
 CellID->575947693],
Cell[57351, 1275, 598, 22, 70, "ExampleText",
 CellID->102209229],
Cell[CellGroupData[{
Cell[57974, 1301, 1059, 30, 70, "Input",
 CellID->107703904],
Cell[59036, 1333, 1110, 35, 175, "Output",
 CellID->6956200]
}, Open  ]],
Cell[60161, 1371, 125, 3, 70, "ExampleDelimiter",
 CellID->812392729],
Cell[60289, 1376, 219, 7, 70, "ExampleText",
 CellID->9100586],
Cell[CellGroupData[{
Cell[60533, 1387, 435, 13, 70, "Input",
 CellID->626875500],
Cell[60971, 1402, 335, 11, 166, "Output",
 CellID->317870368]
}, Open  ]],
Cell[61321, 1416, 124, 3, 70, "ExampleDelimiter",
 CellID->64790640],
Cell[61448, 1421, 209, 7, 70, "ExampleText",
 CellID->39172006],
Cell[CellGroupData[{
Cell[61682, 1432, 430, 13, 70, "Input",
 CellID->305388891],
Cell[62115, 1447, 328, 11, 166, "Output",
 CellID->4525275]
}, Open  ]],
Cell[62458, 1461, 124, 3, 70, "ExampleDelimiter",
 CellID->23134457],
Cell[62585, 1466, 497, 18, 70, "ExampleText",
 CellID->34655400],
Cell[CellGroupData[{
Cell[63107, 1488, 684, 20, 70, "Input",
 CellID->955088660],
Cell[63794, 1510, 584, 20, 166, "Output",
 CellID->761193327]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[64427, 1536, 230, 7, 70, "ExampleSection",
 CellID->639586970],
Cell[64660, 1545, 269, 9, 70, "ExampleText",
 CellID->385152146],
Cell[CellGroupData[{
Cell[64954, 1558, 320, 10, 70, "Input",
 CellID->619069663],
Cell[65277, 1570, 324, 9, 162, "Output",
 CellID->39246537]
}, Open  ]],
Cell[65616, 1582, 124, 3, 70, "ExampleDelimiter",
 CellID->41897285],
Cell[65743, 1587, 359, 13, 70, "ExampleText",
 CellID->466702994],
Cell[CellGroupData[{
Cell[66127, 1604, 762, 23, 70, "Input",
 CellID->1981185],
Cell[66892, 1629, 4689, 81, 70, "Output",
 Evaluatable->False,
 CellID->20798797]
}, Open  ]],
Cell[71596, 1713, 342, 13, 70, "ExampleText",
 CellID->44783562],
Cell[CellGroupData[{
Cell[71963, 1730, 824, 24, 70, "Input",
 CellID->127508062],
Cell[72790, 1756, 4709, 81, 70, "Output",
 Evaluatable->False,
 CellID->11541786]
}, Open  ]],
Cell[77514, 1840, 125, 3, 70, "ExampleDelimiter",
 CellID->309175476],
Cell[77642, 1845, 513, 18, 70, "ExampleText",
 CellID->103790996],
Cell[CellGroupData[{
Cell[78180, 1867, 1091, 36, 70, "Input",
 CellID->42263118],
Cell[79274, 1905, 1423, 38, 126, "Output",
 CellID->552593872]
}, Open  ]],
Cell[CellGroupData[{
Cell[80734, 1948, 1196, 38, 70, "Input",
 CellID->284727558],
Cell[81933, 1988, 1514, 42, 127, "Output",
 CellID->161469580]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[83508, 2037, 310, 9, 70, "SeeAlsoSection",
 CellID->3636],
Cell[83821, 2048, 1185, 44, 70, "SeeAlso",
 CellID->3461]
}, Open  ]],
Cell[CellGroupData[{
Cell[85043, 2097, 317, 9, 70, "MoreAboutSection",
 CellID->1215616],
Cell[85363, 2108, 150, 3, 70, "MoreAbout",
 CellID->19474329],
Cell[85516, 2113, 153, 3, 70, "MoreAbout",
 CellID->657683352],
Cell[85672, 2118, 160, 3, 70, "MoreAbout",
 CellID->5781288]
}, Open  ]],
Cell[85847, 2124, 27, 0, 70, "History"],
Cell[85877, 2126, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

