(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     89778,       2469]
NotebookOptionsPosition[     81738,       2196]
NotebookOutlinePosition[     83136,       2235]
CellTagsIndexPosition[     83050,       2230]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"], 
          "Exporting Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExportingGraphicsAndSounds"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing Graphics and Sounds\"\>", 
       2->"\<\"Exporting Graphics and Sounds\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ImageMargins" :> 
          Documentation`HelpLookup["paclet:ref/ImageMargins"], "FrameMargins" :> 
          Documentation`HelpLookup["paclet:ref/FrameMargins"], "Magnify" :> 
          Documentation`HelpLookup["paclet:ref/Magnify"], "Magnification" :> 
          Documentation`HelpLookup["paclet:ref/Magnification"], 
          "PreserveImageOptions" :> 
          Documentation`HelpLookup["paclet:ref/PreserveImageOptions"], 
          "ImageSizeAction" :> 
          Documentation`HelpLookup["paclet:ref/ImageSizeAction"], 
          "ImageSizeMultipliers" :> 
          Documentation`HelpLookup["paclet:ref/ImageSizeMultipliers"], 
          "PlotRange" :> Documentation`HelpLookup["paclet:ref/PlotRange"], 
          "Inset" :> Documentation`HelpLookup["paclet:ref/Inset"], "Pane" :> 
          Documentation`HelpLookup["paclet:ref/Pane"], "RasterSize" :> 
          Documentation`HelpLookup["paclet:ref/RasterSize"], 
          "ImageResolution" :> 
          Documentation`HelpLookup["paclet:ref/ImageResolution"], 
          "PixelConstrained" :> 
          Documentation`HelpLookup["paclet:ref/PixelConstrained"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ImageMargins\"\>", 
       2->"\<\"FrameMargins\"\>", 3->"\<\"Magnify\"\>", 
       4->"\<\"Magnification\"\>", 5->"\<\"PreserveImageOptions\"\>", 
       6->"\<\"ImageSizeAction\"\>", 7->"\<\"ImageSizeMultipliers\"\>", 
       8->"\<\"PlotRange\"\>", 9->"\<\"Inset\"\>", 10->"\<\"Pane\"\>", 
       11->"\<\"RasterSize\"\>", 12->"\<\"ImageResolution\"\>", 
       13->"\<\"PixelConstrained\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Accessibility" :> 
          Documentation`HelpLookup["paclet:guide/Accessibility"], 
          "Controls Options" :> 
          Documentation`HelpLookup["paclet:guide/ControlsOptions"], 
          "Creating Web Pages" :> 
          Documentation`HelpLookup["paclet:guide/CreatingWebPages"], 
          "Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Function Visualization" :> 
          Documentation`HelpLookup["paclet:guide/FunctionVisualization"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Graphics Shape & Size" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsShapeAndSize"], 
          "Graphics Styling in Notebooks" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsStylingInNotebooks"],
           "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"], 
          "Plotting and Image Regions" :> 
          Documentation`HelpLookup["paclet:guide/PlottingAndImageRegions"], 
          "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "Text Layout Options" :> 
          Documentation`HelpLookup["paclet:guide/TextLayoutOptions"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Accessibility\"\>", 
       2->"\<\"Controls Options\"\>", 3->"\<\"Creating Web Pages\"\>", 
       4->"\<\"Data Visualization\"\>", 5->"\<\"Function Visualization\"\>", 
       6->"\<\"Graphics Importing & Exporting\"\>", 
       7->"\<\"Graphics Options & Styling\"\>", 
       8->"\<\"Graphics Shape & Size\"\>", 
       9->"\<\"Graphics Styling in Notebooks\"\>", 
       10->"\<\"Options & Styling for Interactive Manipulation\"\>", 
       11->"\<\"Plotting and Image Regions\"\>", 12->"\<\"Stylesheets\"\>", 
       13->"\<\"Text Layout Options\"\>", 
       14->"\<\"User Interface Structuring & Layout\"\>", 
       15->"\<\"New in 6.0: Formatting & Styling\"\>", 
       16->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ImageSize", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ImageSize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
     "\[LineSeparator]is an option which specifies the overall size of an \
image to display for an object. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16590]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given: ", "Notes",
 CellID->145],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["w", "TI"], Cell[TextData[{
     "width specified by ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     StyleBox["s", "TI"], "}"}], Cell[TextData[{
     "maximum width and height specified by ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["w", "TI"], ",", 
      StyleBox["h", "TI"]}], "}"}], Cell[
    "explicit width and height ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       SubscriptBox[
        StyleBox["w", "TI"], 
        StyleBox["max", "TI"]], "}"}], ",", 
      RowBox[{"{", 
       SubscriptBox[
        StyleBox["h", "TI"], 
        StyleBox["max", "TI"]], "}"}]}], "}"}], Cell[
    "width and height maximums", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["w", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["w", "TI"], 
         StyleBox["max", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["h", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["h", "TI"], 
         StyleBox["max", "TI"]]}], "}"}]}], "}"}], Cell[
    "width and height ranges", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->21370],

Cell["\<\
Specifications for both width and height can be any of the following: \
\>", "Notes",
 CellID->21013],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[Cell[BoxData[
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]], "InlineFormula"]], "TableText"], 
    Cell["determined by location or other dimension (default) ", 
     "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Tiny",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Small",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Small"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Medium",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Large",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Large"]], "InlineFormula"]
    }], "TableText"], Cell[
    "pre\[Hyphen]defined absolute sizes ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["d", "TI"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " printer\[CloseCurlyQuote]s points (before magnification) "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"72", 
     StyleBox["di", "TI"]}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["di", "TI"]], "InlineFormula"],
     " inches (before magnification) "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Full",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Full"], Cell[
    "fill out the enclosing region ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "a fraction ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " of the enclosing region "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "size that fits all objects in a collection ", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->9836],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["w", "TI"], ",", 
     StyleBox["h", "TI"]}], "}"}]}]], "InlineFormula"],
 " an object will always be drawn in a ",
 Cell[BoxData[
  RowBox[{
   StyleBox["w", "TI"], "\[Times]", 
   StyleBox["h", "TI"]}]], "InlineFormula"],
 " region, and will be sized to fit in the region. "
}], "Notes",
 CellID->10068],

Cell[TextData[{
 "If the object has a definite aspect ratio that is not ",
 Cell[BoxData[
  RowBox[{
   StyleBox["w", "TI"], "/", 
   StyleBox["h", "TI"]}]], "InlineFormula"],
 ", then space will be left around it."
}], "Notes",
 CellID->6906],

Cell[TextData[{
 "The position of the object within the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["w", "TI"], "\[Times]", 
   StyleBox["h", "TI"]}]], "InlineFormula"],
 " region is determined by the setting for the object's ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 " option."
}], "Notes",
 CellID->12707],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      SubscriptBox[
       StyleBox["w", "TI"], 
       StyleBox["max", "TI"]], "}"}], ",", 
     RowBox[{"{", 
      SubscriptBox[
       StyleBox["h", "TI"], 
       StyleBox["max", "TI"]], "}"}]}], "}"}]}]], "InlineFormula"],
 ", an object is sized so that its width and height are as large as possible \
while not exceeding the specified maximums."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26956],

Cell["\<\
No extra space is then left around the object, so that the region in which \
the object is drawn is always the same shape as the object itself. \
\>", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->7701],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   RowBox[{"{", 
    StyleBox["s", "TI"], "}"}]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      StyleBox["s", "TI"], "}"}], ",", 
     RowBox[{"{", 
      StyleBox["s", "TI"], "}"}]}], "}"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->16479],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["w", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["w", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["h", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["h", "TI"], 
        StyleBox["max", "TI"]]}], "}"}]}], "}"}]}]], "InlineFormula"],
 ", the object is sized to be as large as possible while not exceeding \
specified maximums, with extra space being left if necessary in order to \
satisfy the minimums."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->23494],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["max", "TI"]]}], "}"}], "}"}]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["max", "TI"]]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["min", "TI"]], ",", 
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["max", "TI"]]}], "}"}]}], "}"}]}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->30254],

Cell[TextData[{
 "Objects maintain a fixed aspect ratio when resized by ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " specifications, except when the objects have ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AspectRatio",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AspectRatio"], "->", 
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"]}]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->18126],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   StyleBox["w", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["w", "TI"], ",", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], "}"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1113],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], ",", 
     StyleBox["h", "TI"]}], "}"}]}]], "InlineFormula"],
 " normally determines image size from height, with width left unconstrained. \
"
}], "Notes",
 CellID->20646],

Cell[TextData[{
 "Symbolic settings such as ",
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   ButtonBox["Small",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Small"]}]], "InlineFormula"],
 " define width and height maximums, with no extra space being left. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->25443],

Cell[TextData[{
 "For an object that appears directly in a notebook cell, ",
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"]}]], "InlineFormula"],
 " corresponds to the full width of the content area for the cell. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->28914],

Cell[TextData[{
 "When the cell is printed, ",
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"]}]], "InlineFormula"],
 " corresponds to the full width of the content area of the page. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->12515],

Cell[TextData[{
 "For an object that appears as an element in a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"]}]], "InlineFormula"],
 " corresponds to the full width of the cell in the grid. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->18787],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " is an option not only for ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", but also for objects such as ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Pane",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pane"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " is also an option for ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->90],

Cell[TextData[{
 "Settings such as ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 " yield different image sizes for different objects. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->32197],

Cell[TextData[{
 "For constructs such as ",
 Cell[BoxData[
  ButtonBox["SlideView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SlideView"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " specifies that a fixed image size should be used that fits all possible \
elements that can be displayed. ",
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " specifies that the image size should be determined by the currently \
displayed element. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->29569],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " by default refers to both width and height; ",
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], ",", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}], "}"}]}]], "InlineFormula"],
 " leaves enough vertical space for all images, but adjusts horizontal space \
separately for each image."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->2433],

Cell[TextData[{
 "For a graphic with ",
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " that appears directly in a notebook cell, the image size is determined by \
the ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " setting for the style of the cell. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24148],

Cell[TextData[{
 "Graphics with ",
 Cell[BoxData[
  RowBox[{"ImageSize", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " are rendered smaller when they appear in lists or grids, and even smaller \
when they appear in text\[Hyphen]like constructs. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26130]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->300872478],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->472242216],

Cell["Use predefined symbolic sizes: ", "ExampleText",
 CellID->21504024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8246273],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->Tiny], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->Small]}], "}"}]], "Output",
 ImageSize->{310, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->310455259]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1808076656],

Cell["Use an explicit image width: ", "ExampleText",
 CellID->324773305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1.5"}], "}"}]}], "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->239643983],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->100], ",", 
   GraphicsBox[CircleBox[{0, 0}, {1., 1.5}],
    ImageSize->100]}], "}"}]], "Output",
 ImageSize->{230, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47055527]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->580251779],

Cell["Use an explicit image width and height: ", "ExampleText",
 CellID->399315391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"100", ",", "100"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1.5"}], "}"}]}], "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"100", ",", "100"}], "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44725941],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->{100, 100}], ",", 
   GraphicsBox[CircleBox[{0, 0}, {1., 1.5}],
    ImageSize->{100, 100}]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70557871]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->405069763],

Cell["Use proportional size of its enclosing area:", "ExampleText",
 CellID->28257916],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"Scaled", "[", ".8", "]"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->473738244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"g", ",", "g"}], "}"}], "}"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"10", ",", "15"}], "}"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->541855607],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{334, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23102891]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->202703397],

Cell["Specify the sizes of controls:", "ExampleText",
 CellID->181297468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58126917],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x],
    ImageSize->Tiny], ",", 
   SliderBox[Dynamic[$CellContext`x],
    ImageSize->Small], ",", 
   SliderBox[Dynamic[$CellContext`x],
    ImageSize->Medium]}], "}"}]], "Output",
 ImageSize->{411, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90445327]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29102],

Cell["Use predefined symbolic sizes in 3D:", "ExampleText",
 CellID->86190724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69731536],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ImageSize->Tiny,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ImageSize->Small,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{302, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->574277996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->803871923],

Cell[TextData[{
 "Prevent the height and the width from exceeding ",
 Cell[BoxData[
  FormBox["100", TraditionalForm]], "InlineMath"],
 " points:"
}], "ExampleText",
 CellID->191252585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", 
          RowBox[{"-", "3"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", "100", "}"}]}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "3"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", 
          RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", "100", "}"}]}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13809528],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CylinderBox[{{0, 0, -3}, {0, 0, 3}}],
    ImageSize->{100},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], " ", 
   Graphics3DBox[
    CylinderBox[
     NCache[{{0, 0, Rational[-1, 3]}, {0, 0, Rational[1, 3]}}, {{
       0, 0, -0.3333333333333333}, {0, 0, 0.3333333333333333}}]],
    ImageSize->{100},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{168, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2283508]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139241340],

Cell["Use a fraction of the enclosing region:", "ExampleText",
 CellID->63016390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Pane", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"Scaled", "[", ".5", "]"}]}]}], "]"}], ",", "100"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->715202888],

Cell[BoxData[
 FrameBox[
  PaneBox[
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->Scaled[0.5]],
   ImageSize->100],
  StripOnInput->False]], "Output",
 ImageSize->{114, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75746162]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Pane", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", ".3", "]"}], ",", 
         RowBox[{"Scaled", "[", ".3", "]"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->592813691],

Cell[BoxData[
 FrameBox[
  PaneBox[
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->{
      Scaled[0.3], 
      Scaled[0.3]}],
   ImageSize->{100, 100}],
  StripOnInput->False]], "Output",
 ImageSize->{114, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73559882]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Rectangle", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"Scaled", "[", ".3", "]"}]}]}], "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Disk", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"Scaled", "[", ".3", "]"}]}]}], "]"}]}], "}"}], "}"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", "10"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->419420163],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[RectangleBox[{0, 0}],
      ImageSize->Scaled[0.3]], 
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->Scaled[0.3]]}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{10}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{275, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->469331180]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Rectangle", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Scaled", "[", ".3", "]"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Scaled", "[", ".5", "]"}], "}"}]}], "}"}]}]}], "]"}], 
      ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Disk", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"Scaled", "[", ".3", "]"}]}]}], "]"}]}], "}"}], "}"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"10", ",", "10"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->587972316],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[RectangleBox[{0, 0}],
      ImageSize->{{
         Scaled[0.3]}, {
         Scaled[0.5]}}], 
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->Scaled[0.3]]}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{10}}, "Rows" -> {{10}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{275, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->438386600]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17804],

Cell["A wide range of aspect ratios with bounded image size: ", "ExampleText",
 CellID->38857332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{
     RowBox[{"CellularAutomaton", "[", 
      RowBox[{"i", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "30"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "100", "}"}], ",", 
        RowBox[{"{", "50", "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8579],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{527, 160},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10513670]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4309],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageMargins"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameMargins"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Magnify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magnify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Magnification",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magnification"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PreserveImageOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PreserveImageOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSizeAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSizeAction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSizeMultipliers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSizeMultipliers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RasterSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RasterSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageResolution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageResolution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PixelConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PixelConstrained"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4568]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7204],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "Tutorials",
 CellID->9009],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "Tutorials",
 CellID->503348882]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->254748100],

Cell[TextData[ButtonBox["Accessibility",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Accessibility"]], "MoreAbout",
 CellID->263566273],

Cell[TextData[ButtonBox["Controls Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlsOptions"]], "MoreAbout",
 CellID->55367212],

Cell[TextData[ButtonBox["Creating Web Pages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingWebPages"]], "MoreAbout",
 CellID->45829626],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->229774031],

Cell[TextData[ButtonBox["Function Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionVisualization"]], "MoreAbout",
 CellID->41072319],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout",
 CellID->9212144],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->254108006],

Cell[TextData[ButtonBox["Graphics Shape & Size",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsShapeAndSize"]], "MoreAbout",
 CellID->478519893],

Cell[TextData[ButtonBox["Graphics Styling in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsStylingInNotebooks"]], "MoreAbout",
 CellID->414274456],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->144590088],

Cell[TextData[ButtonBox["Plotting and Image Regions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingAndImageRegions"]], "MoreAbout",
 CellID->278327333],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->364578601],

Cell[TextData[ButtonBox["Text Layout Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextLayoutOptions"]], "MoreAbout",
 CellID->34778411],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->89930350],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->481694134],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->365431]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ImageSize - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 15.1015096}", "context" -> "System`", 
    "keywords" -> {
     "graphics size", "picture size", "size", "width", "height", 
      "image width", "image height", "graphics size", "3D graphics size", 
      "control size"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ImageSize is an option which specifies the overall size of an image to \
display for an object. ", "synonyms" -> {"image size"}, "title" -> 
    "ImageSize", "type" -> "Symbol", "uri" -> "ref/ImageSize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[29998, 881, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->300872478]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 82906, 2223}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 5955, 119, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[6578, 146, 4193, 83, 70, "ObjectNameGrid"],
Cell[10774, 231, 471, 14, 70, "Usage",
 CellID->16590]
}, Open  ]],
Cell[CellGroupData[{
Cell[11282, 250, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11760, 267, 68, 1, 70, "Notes",
 CellID->145],
Cell[11831, 270, 2485, 73, 70, "2ColumnTableMod",
 CellID->21370],
Cell[14319, 345, 111, 3, 70, "Notes",
 CellID->21013],
Cell[14433, 350, 3104, 85, 70, "2ColumnTableMod",
 CellID->9836],
Cell[17540, 437, 420, 15, 70, "Notes",
 CellID->10068],
Cell[17963, 454, 243, 8, 70, "Notes",
 CellID->6906],
Cell[18209, 464, 387, 13, 70, "Notes",
 CellID->12707],
Cell[18599, 479, 631, 20, 70, "Notes",
 CellID->26956],
Cell[19233, 501, 314, 7, 70, "Notes",
 CellID->7701],
Cell[19550, 510, 535, 19, 70, "Notes",
 CellID->16479],
Cell[20088, 531, 896, 29, 70, "Notes",
 CellID->23494],
Cell[20987, 562, 1040, 38, 70, "Notes",
 CellID->30254],
Cell[22030, 602, 639, 20, 70, "Notes",
 CellID->18126],
Cell[22672, 624, 395, 15, 70, "Notes",
 CellID->1113],
Cell[23070, 641, 359, 12, 70, "Notes",
 CellID->20646],
Cell[23432, 655, 424, 12, 70, "Notes",
 CellID->25443],
Cell[23859, 669, 450, 12, 70, "Notes",
 CellID->28914],
Cell[24312, 683, 419, 12, 70, "Notes",
 CellID->12515],
Cell[24734, 697, 549, 17, 70, "Notes",
 CellID->18787],
Cell[25286, 716, 1232, 45, 70, "Notes",
 CellID->90],
Cell[26521, 763, 496, 16, 70, "Notes",
 CellID->32197],
Cell[27020, 781, 1086, 35, 70, "Notes",
 CellID->29569],
Cell[28109, 818, 765, 23, 70, "Notes",
 CellID->2433],
Cell[28877, 843, 601, 18, 70, "Notes",
 CellID->24148],
Cell[29481, 863, 480, 13, 70, "Notes",
 CellID->26130]
}, Closed]],
Cell[CellGroupData[{
Cell[29998, 881, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->300872478],
Cell[CellGroupData[{
Cell[30383, 895, 148, 5, 70, "ExampleSection",
 CellID->472242216],
Cell[30534, 902, 73, 1, 70, "ExampleText",
 CellID->21504024],
Cell[CellGroupData[{
Cell[30632, 907, 363, 12, 28, "Input",
 CellID->8246273],
Cell[30998, 921, 310, 11, 203, "Output",
 CellID->310455259]
}, Open  ]],
Cell[31323, 935, 126, 3, 70, "ExampleDelimiter",
 CellID->1808076656],
Cell[31452, 940, 72, 1, 70, "ExampleText",
 CellID->324773305],
Cell[CellGroupData[{
Cell[31549, 945, 531, 17, 70, "Input",
 CellID->239643983],
Cell[32083, 964, 317, 11, 170, "Output",
 CellID->47055527]
}, Open  ]],
Cell[32415, 978, 125, 3, 70, "ExampleDelimiter",
 CellID->580251779],
Cell[32543, 983, 83, 1, 70, "ExampleText",
 CellID->399315391],
Cell[CellGroupData[{
Cell[32651, 988, 644, 21, 70, "Input",
 CellID->44725941],
Cell[33298, 1011, 331, 11, 123, "Output",
 CellID->70557871]
}, Open  ]],
Cell[33644, 1025, 125, 3, 70, "ExampleDelimiter",
 CellID->405069763],
Cell[33772, 1030, 86, 1, 70, "ExampleText",
 CellID->28257916],
Cell[33861, 1033, 352, 11, 70, "Input",
 CellID->473738244],
Cell[CellGroupData[{
Cell[34238, 1048, 361, 12, 28, "Input",
 CellID->541855607],
Cell[34602, 1062, 3932, 69, 118, "Output",
 Evaluatable->False,
 CellID->23102891]
}, Open  ]],
Cell[38549, 1134, 125, 3, 70, "ExampleDelimiter",
 CellID->202703397],
Cell[38677, 1139, 73, 1, 70, "ExampleText",
 CellID->181297468],
Cell[CellGroupData[{
Cell[38775, 1144, 386, 13, 70, "Input",
 CellID->58126917],
Cell[39164, 1159, 384, 13, 70, "Output",
 CellID->90445327]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39597, 1178, 216, 7, 70, "ExampleSection",
 CellID->29102],
Cell[39816, 1187, 78, 1, 70, "ExampleText",
 CellID->86190724],
Cell[CellGroupData[{
Cell[39919, 1192, 368, 12, 70, "Input",
 CellID->69731536],
Cell[40290, 1206, 13423, 228, 218, "Output",
 CellID->574277996]
}, Open  ]],
Cell[53728, 1437, 125, 3, 70, "ExampleDelimiter",
 CellID->803871923],
Cell[53856, 1442, 185, 6, 70, "ExampleText",
 CellID->191252585],
Cell[CellGroupData[{
Cell[54066, 1452, 973, 30, 70, "Input",
 CellID->13809528],
Cell[55042, 1484, 6015, 108, 123, "Output",
 CellID->2283508]
}, Open  ]],
Cell[61072, 1595, 125, 3, 70, "ExampleDelimiter",
 CellID->139241340],
Cell[61200, 1600, 81, 1, 70, "ExampleText",
 CellID->63016390],
Cell[CellGroupData[{
Cell[61306, 1605, 337, 11, 70, "Input",
 CellID->715202888],
Cell[61646, 1618, 283, 11, 84, "Output",
 CellID->75746162]
}, Open  ]],
Cell[CellGroupData[{
Cell[61966, 1634, 487, 15, 70, "Input",
 CellID->592813691],
Cell[62456, 1651, 320, 13, 134, "Output",
 CellID->73559882]
}, Open  ]],
Cell[CellGroupData[{
Cell[62813, 1669, 653, 19, 70, "Input",
 CellID->419420163],
Cell[63469, 1690, 483, 17, 68, "Output",
 CellID->469331180]
}, Open  ]],
Cell[CellGroupData[{
Cell[63989, 1712, 884, 27, 70, "Input",
 CellID->587972316],
Cell[64876, 1741, 541, 19, 130, "Output",
 CellID->438386600]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[65466, 1766, 223, 7, 70, "ExampleSection",
 CellID->17804],
Cell[65692, 1775, 97, 1, 70, "ExampleText",
 CellID->38857332],
Cell[CellGroupData[{
Cell[65814, 1780, 598, 19, 70, "Input",
 CellID->8579],
Cell[66415, 1801, 7938, 134, 70, "Output",
 Evaluatable->False,
 CellID->10513670]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74414, 1942, 310, 9, 70, "SeeAlsoSection",
 CellID->4309],
Cell[74727, 1953, 3253, 116, 70, "SeeAlso",
 CellID->4568]
}, Open  ]],
Cell[CellGroupData[{
Cell[78017, 2074, 313, 9, 70, "TutorialsSection",
 CellID->7204],
Cell[78333, 2085, 165, 3, 70, "Tutorials",
 CellID->9009],
Cell[78501, 2090, 170, 3, 70, "Tutorials",
 CellID->503348882]
}, Open  ]],
Cell[CellGroupData[{
Cell[78708, 2098, 319, 9, 70, "MoreAboutSection",
 CellID->254748100],
Cell[79030, 2109, 138, 3, 70, "MoreAbout",
 CellID->263566273],
Cell[79171, 2114, 142, 3, 70, "MoreAbout",
 CellID->55367212],
Cell[79316, 2119, 145, 3, 70, "MoreAbout",
 CellID->45829626],
Cell[79464, 2124, 147, 3, 70, "MoreAbout",
 CellID->229774031],
Cell[79614, 2129, 154, 3, 70, "MoreAbout",
 CellID->41072319],
Cell[79771, 2134, 169, 3, 70, "MoreAbout",
 CellID->9212144],
Cell[79943, 2139, 163, 3, 70, "MoreAbout",
 CellID->254108006],
Cell[80109, 2144, 153, 3, 70, "MoreAbout",
 CellID->478519893],
Cell[80265, 2149, 167, 3, 70, "MoreAbout",
 CellID->414274456],
Cell[80435, 2154, 204, 4, 70, "MoreAbout",
 CellID->144590088],
Cell[80642, 2160, 161, 3, 70, "MoreAbout",
 CellID->278327333],
Cell[80806, 2165, 134, 3, 70, "MoreAbout",
 CellID->364578601],
Cell[80943, 2170, 147, 3, 70, "MoreAbout",
 CellID->34778411],
Cell[81093, 2175, 179, 3, 70, "MoreAbout",
 CellID->89930350],
Cell[81275, 2180, 171, 3, 70, "MoreAbout",
 CellID->481694134],
Cell[81449, 2185, 194, 4, 70, "MoreAbout",
 CellID->365431]
}, Open  ]],
Cell[81658, 2192, 50, 0, 70, "History"],
Cell[81711, 2194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

