(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17256,        576]
NotebookOptionsPosition[     13493,        456]
NotebookOutlinePosition[     15004,        496]
CellTagsIndexPosition[     14919,        491]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Magnify" :> Documentation`HelpLookup["paclet:ref/Magnify"], 
          "Pane" :> Documentation`HelpLookup["paclet:ref/Pane"], 
          "ImageSizeMultipliers" :> 
          Documentation`HelpLookup["paclet:ref/ImageSizeMultipliers"], 
          "PixelConstrained" :> 
          Documentation`HelpLookup["paclet:ref/PixelConstrained"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Magnify\"\>", 2->"\<\"Pane\"\>", 
       3->"\<\"ImageSizeMultipliers\"\>", 
       4->"\<\"PixelConstrained\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Accessibility" :> 
          Documentation`HelpLookup["paclet:guide/Accessibility"], 
          "Graphics Shape & Size" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsShapeAndSize"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Accessibility\"\>", 
       2->"\<\"Graphics Shape & Size\"\>", 
       3->"\<\"Options & Styling for Interactive Manipulation\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ImageSizeAction", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ImageSizeAction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImageSizeAction"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Pane",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Pane"]], "InlineFormula"],
     " and related constructs which specifies what to do if the specified ",
     Cell[BoxData[
      ButtonBox["ImageSize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
     " setting does not match the size of the contents."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6635]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Typical possible settings for ",
 Cell[BoxData[
  ButtonBox["ImageSizeAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSizeAction"]], "InlineFormula"],
 " are:"
}], "Notes",
 CellID->22881],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Clip\>\"", Cell[TextData[{
     "clip at the specified ",
     Cell[BoxData[
      ButtonBox["ImageSize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ResizeToFit\>\"", Cell[TextData[{
     "resize to make the contents exactly fit ",
     Cell[BoxData[
      ButtonBox["ImageSize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ShrinkToFit\>\"", Cell[
    "shrink if necessary to make the contents fit", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->7516],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ImageSizeAction", "->", "\"\<ShrinkToFit\>\""}]], 
  "InlineFormula"],
 ", the contents can be made smaller, but never larger."
}], "Notes",
 CellID->519051293]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->326736048],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->617257359],

Cell[TextData[{
 "The default for ",
 Cell[BoxData[
  ButtonBox["ImageSizeAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSizeAction"]], "InlineFormula"],
 " is ",
 Cell[BoxData["\"\<Clip\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22323998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pane", "[", 
  RowBox[{
   RowBox[{"150", "!"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6857009],

Cell[BoxData[
 PaneBox["57133839564458545904789328652610540031895535786011264182548375833179\
829124845398393126574488675311145377107878746854204162666250198684504466355949\
195922066574942592095735778929325357290444962472405416790722118445437122269675\
520000000000000000000000000000000000000",
  ImageSize->{100, 100}]], "Output",
 ImageSize->{104, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->386169889]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13779813],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\"\<ShrinkToFit\>\""], "InlineFormula"],
 " to shrink so that all the data fits in the pane:"
}], "ExampleText",
 CellID->161510045],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pane", "[", 
  RowBox[{
   RowBox[{"150", "!"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], ",", 
   RowBox[{"ImageSizeAction", "\[Rule]", "\"\<ShrinkToFit\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->911655883],

Cell[BoxData[
 PaneBox["57133839564458545904789328652610540031895535786011264182548375833179\
829124845398393126574488675311145377107878746854204162666250198684504466355949\
195922066574942592095735778929325357290444962472405416790722118445437122269675\
520000000000000000000000000000000000000",
  ImageSize->{100, 100},
  ImageSizeAction->"ShrinkToFit"]], "Output",
 ImageSize->{104, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->563918133]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->200873825],

Cell[TextData[{
 Cell[BoxData["\"\<ResizeToFit\>\""], "InlineFormula"],
 " shrinks or expands so that the data just fills the pane:"
}], "ExampleText",
 CellID->8555582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pane", "[", 
  RowBox[{"5", ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], ",", 
   RowBox[{"ImageSizeAction", "\[Rule]", "\"\<ResizeToFit\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47620002],

Cell[BoxData[
 PaneBox["5",
  ImageSize->{100, 100},
  ImageSizeAction->"ResizeToFit"]], "Output",
 ImageSize->{104, 168},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66168080]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->223726851],

Cell[TextData[{
 Cell[BoxData["\"\<ShrinkToFit\>\""], "InlineFormula"],
 " shrinks but never expands:"
}], "ExampleText",
 CellID->140203684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Pane", "[", 
  RowBox[{"5", ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], ",", 
   RowBox[{"ImageSizeAction", "\[Rule]", "\"\<ShrinkToFit\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->223385900],

Cell[BoxData[
 PaneBox["5",
  ImageSize->{100, 100},
  ImageSizeAction->"ShrinkToFit"]], "Output",
 ImageSize->{104, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->402503239]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24681],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Magnify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magnify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSizeMultipliers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSizeMultipliers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PixelConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PixelConstrained"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27823]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->511724562],

Cell[TextData[ButtonBox["Accessibility",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Accessibility"]], "MoreAbout",
 CellID->195702659],

Cell[TextData[ButtonBox["Graphics Shape & Size",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsShapeAndSize"]], "MoreAbout",
 CellID->148475956],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->629210698]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ImageSizeAction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 14.1171094}", "context" -> "System`", 
    "keywords" -> {
     "bounding box", "constrain to fit", "expand image", "fit", 
      "font size fitting", "magnification", "resize image", "resize to fit", 
      "shrink image", "shrink to fit"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ImageSizeAction is an option for Pane and related constructs which \
specifies what to do if the specified ImageSize setting does not match the \
size of the contents.", "synonyms" -> {"image size action"}, "title" -> 
    "ImageSizeAction", "type" -> "Symbol", "uri" -> "ref/ImageSizeAction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6838, 201, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->326736048]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14776, 484}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1886, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2509, 70, 1580, 37, 70, "ObjectNameGrid"],
Cell[4092, 109, 813, 23, 70, "Usage",
 CellID->6635]
}, Open  ]],
Cell[CellGroupData[{
Cell[4942, 137, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5420, 154, 221, 8, 70, "Notes",
 CellID->22881],
Cell[5644, 164, 942, 23, 70, "2ColumnTableMod",
 CellID->7516],
Cell[6589, 189, 212, 7, 70, "Notes",
 CellID->519051293]
}, Closed]],
Cell[CellGroupData[{
Cell[6838, 201, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->326736048],
Cell[CellGroupData[{
Cell[7223, 215, 148, 5, 70, "ExampleSection",
 CellID->617257359],
Cell[7374, 222, 270, 10, 70, "ExampleText",
 CellID->22323998],
Cell[CellGroupData[{
Cell[7669, 236, 235, 8, 28, "Input",
 CellID->6857009],
Cell[7907, 246, 464, 10, 124, "Output",
 CellID->386169889]
}, Open  ]],
Cell[8386, 259, 124, 3, 70, "ExampleDelimiter",
 CellID->13779813],
Cell[8513, 264, 172, 5, 70, "ExampleText",
 CellID->161510045],
Cell[CellGroupData[{
Cell[8710, 273, 312, 10, 70, "Input",
 CellID->911655883],
Cell[9025, 285, 498, 11, 124, "Output",
 CellID->563918133]
}, Open  ]],
Cell[9538, 299, 125, 3, 70, "ExampleDelimiter",
 CellID->200873825],
Cell[9666, 304, 169, 4, 70, "ExampleText",
 CellID->8555582],
Cell[CellGroupData[{
Cell[9860, 312, 290, 9, 70, "Input",
 CellID->47620002],
Cell[10153, 323, 229, 8, 189, "Output",
 CellID->66168080]
}, Open  ]],
Cell[10397, 334, 125, 3, 70, "ExampleDelimiter",
 CellID->223726851],
Cell[10525, 339, 141, 4, 70, "ExampleText",
 CellID->140203684],
Cell[CellGroupData[{
Cell[10691, 347, 291, 9, 70, "Input",
 CellID->223385900],
Cell[10985, 358, 230, 8, 124, "Output",
 CellID->402503239]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11276, 373, 311, 9, 70, "SeeAlsoSection",
 CellID->24681],
Cell[11590, 384, 971, 35, 70, "SeeAlso",
 CellID->27823]
}, Open  ]],
Cell[CellGroupData[{
Cell[12598, 424, 319, 9, 70, "MoreAboutSection",
 CellID->511724562],
Cell[12920, 435, 138, 3, 70, "MoreAbout",
 CellID->195702659],
Cell[13061, 440, 153, 3, 70, "MoreAbout",
 CellID->148475956],
Cell[13217, 445, 204, 4, 70, "MoreAbout",
 CellID->629210698]
}, Open  ]],
Cell[13436, 452, 27, 0, 70, "History"],
Cell[13466, 454, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

