(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16334,        541]
NotebookOptionsPosition[     12827,        427]
NotebookOutlinePosition[     14259,        467]
CellTagsIndexPosition[     14174,        462]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ScriptSizeMultipliers" :> 
          Documentation`HelpLookup["paclet:ref/ScriptSizeMultipliers"], 
          "ImageSize" :> Documentation`HelpLookup["paclet:ref/ImageSize"], 
          "Magnify" :> Documentation`HelpLookup["paclet:ref/Magnify"], 
          "ImageSizeAction" :> 
          Documentation`HelpLookup["paclet:ref/ImageSizeAction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ScriptSizeMultipliers\"\>", 
       2->"\<\"ImageSize\"\>", 3->"\<\"Magnify\"\>", 
       4->"\<\"ImageSizeAction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Graphics Shape & Size" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsShapeAndSize"], 
          "Graphics Styling in Notebooks" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsStylingInNotebooks"],
           "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "Text Layout Options" :> 
          Documentation`HelpLookup["paclet:guide/TextLayoutOptions"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graphics Annotation & Appearance\"\>", 
       2->"\<\"Graphics Options & Styling\"\>", 
       3->"\<\"Graphics Shape & Size\"\>", 
       4->"\<\"Graphics Styling in Notebooks\"\>", 5->"\<\"Stylesheets\"\>", 
       6->"\<\"Text Layout Options\"\>", 
       7->"\<\"New in 6.0: Formatting & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ImageSizeMultipliers", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ImageSizeMultipliers",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImageSizeMultipliers"]], "InlineFormula"],
     " \[LineSeparator]is an option which specifies how much smaller to \
render graphics that appear within other constructs."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14614]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ImageSizeMultipliers", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["u", "TI"], ",", 
     StyleBox["v", "TI"]}], "}"}]}]], "InlineFormula"],
 " specifies that graphics inside list-like constructs should be ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " times their normal size, while graphics inside function-like constructs \
should be ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " times their normal size."
}], "Notes",
 CellID->22686],

Cell[TextData[{
 "A typical default setting for ",
 Cell[BoxData[
  ButtonBox["ImageSizeMultipliers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSizeMultipliers"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0.5", ",", " ", "0.25"}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1705]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17971912],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->338696498],

Cell["The original graphic size:", "ExampleText",
 CellID->87374991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Circle", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68463969],

Cell[BoxData[
 StyleBox[
  GraphicsBox[CircleBox[{0, 0}, {3., 1.}]],
  StripOnInput->False,
  GraphicsBoxOptions->{ImageSize->Automatic}]], "Output",
 ImageSize->{364, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->332343884]
}, Open  ]],

Cell["\<\
Specify that the graphic inside a list is 0.4 times its normal size:\
\>", "ExampleText",
 CellID->670213564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}]}], "]"}], "]"}], "}"}], ",", 
   RowBox[{"ImageSizeMultipliers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28741958],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   GraphicsBox[CircleBox[{0, 0}, {3., 1.}]], "}"}],
  StripOnInput->False,
  ImageSizeMultipliers->{0.4, 0.2},
  GraphicsBoxOptions->{ImageSize->Automatic}]], "Output",
 ImageSize->{162, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->125857169]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->463424180],

Cell["\<\
Specify that the graphic inside a function is 0.2 times its normal size:\
\>", "ExampleText",
 CellID->431845390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"ImageSizeMultipliers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->358157864],

Cell[BoxData[
 StyleBox[
  RowBox[{"f", "[", 
   GraphicsBox[CircleBox[{0, 0}, {3., 1.}]], "]"}],
  StripOnInput->False,
  ImageSizeMultipliers->{0.4, 0.2},
  GraphicsBoxOptions->{ImageSize->Automatic}]], "Output",
 ImageSize->{97, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55064882]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14502],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScriptSizeMultipliers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScriptSizeMultipliers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Magnify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magnify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSizeAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSizeAction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31057]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->564300061],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->48453756],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->9194354],

Cell[TextData[ButtonBox["Graphics Shape & Size",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsShapeAndSize"]], "MoreAbout",
 CellID->354651152],

Cell[TextData[ButtonBox["Graphics Styling in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsStylingInNotebooks"]], "MoreAbout",
 CellID->49478769],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->696096887],

Cell[TextData[ButtonBox["Text Layout Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextLayoutOptions"]], "MoreAbout",
 CellID->133618094],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->317339736]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ImageSizeMultipliers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 14.4921190}", "context" -> "System`", 
    "keywords" -> {
     "images in text", "images in formulas", "graphics in text", 
      "graphics in formulas", "graphics in lists"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ImageSizeMultipliers is an option which specifies how much smaller to \
render graphics that appear within other constructs.", 
    "synonyms" -> {"image size multipliers"}, "title" -> 
    "ImageSizeMultipliers", "type" -> "Symbol", "uri" -> 
    "ref/ImageSizeMultipliers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6666, 191, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->17971912]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14032, 455}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2539, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3162, 81, 1585, 37, 70, "ObjectNameGrid"],
Cell[4750, 120, 511, 14, 70, "Usage",
 CellID->14614]
}, Open  ]],
Cell[CellGroupData[{
Cell[5298, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5776, 156, 519, 16, 70, "Notes",
 CellID->22686],
Cell[6298, 174, 331, 12, 70, "Notes",
 CellID->1705]
}, Closed]],
Cell[CellGroupData[{
Cell[6666, 191, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17971912],
Cell[CellGroupData[{
Cell[7050, 205, 148, 5, 70, "ExampleSection",
 CellID->338696498],
Cell[7201, 212, 68, 1, 70, "ExampleText",
 CellID->87374991],
Cell[CellGroupData[{
Cell[7294, 217, 262, 9, 28, "Input",
 CellID->68463969],
Cell[7559, 228, 281, 9, 151, "Output",
 CellID->332343884]
}, Open  ]],
Cell[7855, 240, 119, 3, 70, "ExampleText",
 CellID->670213564],
Cell[CellGroupData[{
Cell[7999, 247, 465, 15, 70, "Input",
 CellID->28741958],
Cell[8467, 264, 340, 11, 75, "Output",
 CellID->125857169]
}, Open  ]],
Cell[8822, 278, 125, 3, 70, "ExampleDelimiter",
 CellID->463424180],
Cell[8950, 283, 123, 3, 70, "ExampleText",
 CellID->431845390],
Cell[CellGroupData[{
Cell[9098, 290, 471, 15, 70, "Input",
 CellID->358157864],
Cell[9572, 307, 343, 11, 49, "Output",
 CellID->55064882]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9976, 325, 311, 9, 70, "SeeAlsoSection",
 CellID->14502],
Cell[10290, 336, 981, 35, 70, "SeeAlso",
 CellID->31057]
}, Open  ]],
Cell[CellGroupData[{
Cell[11308, 376, 319, 9, 70, "MoreAboutSection",
 CellID->564300061],
Cell[11630, 387, 174, 3, 70, "MoreAbout",
 CellID->48453756],
Cell[11807, 392, 161, 3, 70, "MoreAbout",
 CellID->9194354],
Cell[11971, 397, 153, 3, 70, "MoreAbout",
 CellID->354651152],
Cell[12127, 402, 166, 3, 70, "MoreAbout",
 CellID->49478769],
Cell[12296, 407, 134, 3, 70, "MoreAbout",
 CellID->696096887],
Cell[12433, 412, 148, 3, 70, "MoreAbout",
 CellID->133618094],
Cell[12584, 417, 171, 3, 70, "MoreAbout",
 CellID->317339736]
}, Open  ]],
Cell[12770, 423, 27, 0, 70, "History"],
Cell[12800, 425, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

