(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65430,       1663]
NotebookOptionsPosition[     57486,       1439]
NotebookOutlinePosition[     60836,       1505]
CellTagsIndexPosition[     60750,       1500]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing and Exporting Data" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingAndExportingData"], 
          "Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"], 
          "Importing and Exporting Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingAndExportingFiles"], 
          "Mathematica Internet Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InternetConnectivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing and Exporting Data\"\>", 
       2->"\<\"Importing Graphics and Sounds\"\>", 
       3->"\<\"Importing and Exporting Files\"\>", 
       4->"\<\"Mathematica Internet Connectivity\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Export" :> Documentation`HelpLookup["paclet:ref/Export"], 
          "ImportString" :> 
          Documentation`HelpLookup["paclet:ref/ImportString"], 
          "$ImportFormats" :> 
          Documentation`HelpLookup["paclet:ref/$ImportFormats"], "ReadList" :> 
          Documentation`HelpLookup["paclet:ref/ReadList"], "BinaryReadList" :> 
          Documentation`HelpLookup["paclet:ref/BinaryReadList"], "FileFormat" :> 
          Documentation`HelpLookup["paclet:ref/FileFormat"], "FilePrint" :> 
          Documentation`HelpLookup["paclet:ref/FilePrint"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Export\"\>", 
       2->"\<\"ImportString\"\>", 3->"\<\"$ImportFormats\"\>", 
       4->"\<\"ReadList\"\>", 5->"\<\"BinaryReadList\"\>", 
       6->"\<\"FileFormat\"\>", 7->"\<\"FilePrint\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Input & Output in Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/BasicInputAndOutputInPrograms"], 
          "Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Database Connectivity" :> 
          Documentation`HelpLookup["paclet:guide/DatabaseConnectivity"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Files" :> Documentation`HelpLookup["paclet:guide/Files"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Image Processing" :> 
          Documentation`HelpLookup["paclet:guide/ImageProcessing"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Importing & Exporting in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/ImportingAndExportingInNotebooks"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"], 
          "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"], 
          "Sound and Sonification" :> 
          Documentation`HelpLookup["paclet:guide/SoundAndSonification"], 
          "Web Operations" :> 
          Documentation`HelpLookup["paclet:guide/WebOperations"], 
          "XML Import & Export" :> 
          Documentation`HelpLookup["paclet:guide/XMLImportAndExport"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: System Interfaces & Deployment" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60SystemInterfacesAndDeployment"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Basic Input & Output in Programs\"\>", 
       2->"\<\"Constructing Lists\"\>", 3->"\<\"Database Connectivity\"\>", 
       4->"\<\"External Operations\"\>", 5->"\<\"Files\"\>", 
       6->"\<\"Graphics Importing & Exporting\"\>", 
       7->"\<\"Handling Arrays of Data\"\>", 8->"\<\"Image Processing\"\>", 
       9->"\<\"Importing & Exporting\"\>", 
       10->"\<\"Importing & Exporting in Notebooks\"\>", 
       11->"\<\"Procedural Programming\"\>", 12->"\<\"Signal Processing\"\>", 
       13->"\<\"Sound and Sonification\"\>", 14->"\<\"Web Operations\"\>", 
       15->"\<\"XML Import & Export\"\>", 
       16->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       17->"\<\"New in 6.0: System Interfaces & Deployment\"\>", 
       18->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Import", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Import",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]imports data from a file, returning a complete ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " version of it. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Import",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Import"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
        StyleBox["elements", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]imports the specified elements from a file."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Import",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Import"], "[", 
       RowBox[{"\"\<http://\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Import",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Import"], "[", 
       RowBox[{"\"\<ftp://\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]imports from any accessible URL. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->17156]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " handles a large number of formats, each typically with many different \
possible elements.",
 " ",
 "The possible formats are given in the list ",
 Cell[BoxData[
  ButtonBox["$ImportFormats",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ImportFormats"]], "InlineFormula"],
 ", and in the \"",
 ButtonBox["Listing of All Formats\".",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/ImportingAndExporting"]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->4787983],

Cell[TextData[{
 "The format of a file is by default deduced from the file extension in its \
name, or by ",
 Cell[BoxData[
  ButtonBox["FileFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileFormat"]], "InlineFormula"],
 " from its contents."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->454771001],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements determine which aspects of a file should be imported, and how \
they should be returned to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->116760393],

Cell["The following forms of element specifications can be given:", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->21068205],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", Cell[
    "take the file to be in the specified format", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    StyleBox["elem", "TI"], Cell[
    "import a single element assuming the default format", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", ",", 
      StyleBox["elem", "TI"]}], "}"}], Cell[
    "import an element assuming the specified format", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"comp\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "assume also compression formats ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"comp\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
     " (e.g. \"GZIP\")"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["11", "TR"]]}], "}"}], Cell[TextData[{
     "import subelement ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["11", "TR"]]], "InlineFormula"],
     " of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["11", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "import subelements of subelements", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["1", "TR"]], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["11", "TR"]], ",", 
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["12", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}], Cell[TextData[{
     "import several subelements of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["n", "TI"]}], "}"}], Cell[TextData[{
     "import the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "th part of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->405487078],

Cell["Types of elements typically supported include:", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->15573885],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Elements\>\"", Cell[
    "a list of names of elements", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Rules\>\"", Cell[
    "rules for the values of all elements ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Options\>\"", Cell[
    "rules for options, settings, meta-information, etc.", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Data\>\"", Cell[TextData[{
     "data in a generic ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " form (list, string, etc.)"
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<RawData\>\"", Cell[
    "raw data as used in the format (e.g. indexed colors)", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Graphics\>\"", Cell[
    "2D graphics (for graphical or geometry formats)", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Graphics3D\>\"", Cell[
    "3D graphics (for graphical or geometry formats)", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Sound\>\"", Cell[
    "sound (for sound formats)", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Plaintext\>\"", Cell[
    "plain text (for textual formats)", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Grid\>\"", Cell[
    "grid format (for arrays, spreadsheets, etc.)", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->937754380],

Cell[TextData[{
 "If no element specification is given, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " will typically return expressions that display or operate as much as \
possible as they would in an external viewer of the file being imported. \
Graphical formats, for example, are by default returned as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " expressions. "
}], "Notes",
 CellID->9382452],

Cell[TextData[{
 "For some formats, there are options that specify details of how the import \
process should be performed; these are given as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{
    StyleBox["source", "TI"], ",", 
    StyleBox["elems", "TI"], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->333050903],

Cell[TextData[{
 "Names of ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options such as ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " can be given as elements for ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->144045357],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{
     ButtonBox["Path",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Path"], "->", 
     StyleBox["path", "TI"]}]}], "]"}]], "InlineFormula"],
 " searches for ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 " on the specified ",
 Cell[BoxData[
  StyleBox["path", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->463719547],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<!\!\(\*
StyleBox[\"prog\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " imports data from a pipe. "
}], "Notes",
 CellID->16411],

Cell[TextData[{
 "When importing from a remote URL, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses whatever proxy and related settings are specified in your \
environment, but not cookies or other authentication. "
}], "Notes",
 CellID->17008]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->187556448],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->276534759],

Cell["Import a complete GIF image file:", "ExampleText",
 CellID->87016493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/rose.gif\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144430391],

Cell[BoxData[
 GraphicsBox[{{}, GeometricTransformationBox[RasterBox[CompressedData["
1:eJztvXt8U+eZLjq2jCWFlrAP7dj4tg/YartP6yQmO/u0TXJCwMzunn3CJKTM
NBemxYBDKGbqtnuaBHxwicFguzVVzEVyIoErW5It2V66LGktWZcGWuOc0uq2
tKQ0kQy1gCRt0iQEY/mf87yf7DSdJg0kTUn4nde2ZBsj1uPnvTzv+33fYlnD
v61rKPy7v/s7Ez4y+Jj9/+2vZNPX+gI+Ksvh42VT79O/nM7lrkuUudmn4719
umcuM6jXn538eThuMPT1vnCd4cvN5nIzvc+Mj5smTCZTX1/vTy+zb+euG5gX
e00nxuOmMMHrhf3y4nUDDTz99tSJ3rBp3ER2vFfXe+eBXsTg9eKkp3+k6wVz
4fgEHsHecYOu95kDz1/+xMMDgOnLP+01HD9OxME3T548zsxwHC5qYFk0H4Kf
UKi52YnjSCemOXimk6Y8PvJRQ++pTyiqOcvlXuvtgx1n9BF7JtNPj/8U4Ig9
sqdf/sQyhwt/oVf4I7w5IyoBsO846Hv6p1/pffETCQ8xlZs40Wc60cuckYiD
/TSPtu+4AWbqhYv26nQn3pr/G58cy81efq7XBN/86fHed7BnwGd9x02ETve0
7riO7Ee3PfvbmU+ak148+cwJU+8JijKCNw+Q0ibBA2vA3cHwGQ7s7z15jvj+
xEC8eOLEeO8J8Nfbu5+SyPF5dIg5gDPAK1H/8Ebw8Kbb3/vSpWt90Vdo07N/
6GMKrA8Xv58+OgiSwUDgeg1GoxG+qdP17ifvZOAB07Bf1yt9EujL5aAye3Vh
CjBdR8d+HfNBA/HFYOF7BnxrHzB3MHyGfBD27tfdeeKVa33172u53MlxMCQY
4YIdBK+9na6+vaOjHZ/iOx14au9oNxj2deBL5p6MRfJV08y1vvz3s9zsOSEc
DgMhrnvfvn3tDAzZPrL2Dewb+nZ9B4Oah5fntf1A/Fpf/ftb7g9xSQr3m/Lo
5gzc5eFt+BKDymjsaNe361iSoVrRqzuge+ntV5mfWuRmP25V4w8TkUjYBPZ0
XL+pY84YcRse/vy+DbB97Zvz4NqZ5wIgoYNzvvSOl3k1j/Djhi938VQY5Bk7
9vVLrn6jsdN47FhHR29HO0MGhIC3eWN7x+Z2/ZYtW/Qs+gyUgOCgv6H+nr3K
L5cVzL/euwO8VpBzF03h8XHO0GFyR1yEk9B19OYpBLyH//Ef/5kRCPa6uwFQ
T5GnZ+kzDqfMX/cNqhdm5mBM3/nyn/8rr776t8T0R8vlciZgMnZ0uMLhKHjk
8HknqoHxbTd9+B8f3rBxw4aNG7d0I9HoO8hBmZe2/7fZX+dfY9mnC17Kfzb7
BUUBfZNonZ5mcvbl5+6omb5G9BE8E8E7NvF8JByegHvmgRk6OvAJJczNmzY9
/J//8wbKoRv0AuCx0qHT9el6f0biJfdzlaLgV7Mvz/765dOfVi5Z8oWLl3Kz
L9YW1CxYVFN6w421i++4dsEIeGFBQOj1M3guCj/jMSMKoA56pUOfLwgd+n0P
P/y/b9iM7EIMUik06HV9/+2O2dmZOxUKpUKlKlAt+4xCoV6iWKJWfrq2VLFA
VbtItXjxgpprmmiIPSMcsj8cfj4angi78vRBjDGhogfAY65IhDt2TM+1PwwK
9XpgxINO3yfocr/tVSqXKIHvM8sU9KxUKJYoli9TLioprTv9yvT0RZZ7rnDY
TXNxNoyc+42wv3vHszO56dmvzv/I/BO5fo6+usQc6L1fdOZUH3jqj0aed4Wj
EcA7dtxoON6Rp02v79rsCkvShKQ73u8yfmnDli2bYeSfhj5jX4GC4MAKiUKC
p1arF9/46UWfOnn1wfbqH3LTc3l3hiCyF/j9z2sWfPn304sLam6ZfXbBK6/i
J3Klz81OvzJ7afbV01fwqjmq6MawFJEi0ahLELhjRiIQbqnfjEc955aklOuN
cH+/sd/UvmHzJgBEEaT60AdwSgJFjyqlQq1WLXvmYu49asP7XsjLNYueoww7
TSQB6uxsbW1pcWlJWWkxovjmG2trbyi+8caK0xU3aEpPF/w+d6ngV7nZ596v
M3sGF9o/EX3+eYIH9gzAx1LKZqKK491SKtV//pypv5/jjBs26YFv44Z23RaD
MK7KuyOhUyiWPfPKDGXL6Q8YbdO5Z9TLlVXKX8xoWDupWaiqKC0uUaurK0rL
SjQlNRWlsOLS0sIKVVE5gl1VUrCsVpV79S8BzAEeyIMDPg/tSZHHgbKOLR0A
B+PcIA/s9Usp/KnAdaBINGyBd24heEso4OCXyqrPtUu/ufwnk8IPsrq0uESp
VpKHF6sXLlxYpFYuLV0I9srKgKuisrKiAg+V5RWl5epFiIKSBcULFAsWFDw7
W5DLzZA3/1kXimt5zqDrd0dQ8yYibneY64By6SKOGhu7N3aKnBiNSZlMODIx
IQkcx3VAw6AEbmjf0m4QFIoCRZVBSMeEcEQKn5v9UOUNf/UllZqBoxBWKovU
JQtLSkvKS9RlFTWV5QSvUqPRVFYsLAXQiuKyYrVSjfBf8Kk7XkTovkdAvGjo
QG6EZ7oZfcdcyCf6xk0b/3Xjw1ucbiEixpLJzBnEJioI8Ok3b2nfSFUQ0dfe
Fx8X8F0BCKXwT1/+UMWb/m7lcmJOXULw6KOopKyEuSfDVlkL8uCiwFZaWoKf
KkHgFxYoCgoKvvDi/Ev8R5vuOD4RDUej0Yjb5eI4s16/pbFh48aHNpq3OBxc
BPgSUlpKSZOTsbCA2NRvyNeHLXpBMHNCJAKAUjosmOLxcx8CHbu8X4C4hcUl
RUTeQnhq0VIl0JXBHyvINSsq6+rqKunTZaUlS9XFC5RKVaGa4MHeLQQpiHtN
YSnsjrKi3onI27KR0H2ju3sT53DAYSOxWCo9lYqHYwAi9OMn8CvQG9vxxRYh
FuMiMZlxGzbFP/QIpqKyUK0GOuadavpUqS4pKyyt0VTWlNZUaipL6zQLAba0
YgH4UxepChVFikKAUxTUUF2p/dOeZQafmsLPU1oJh+F7Xd0UchsfenDjNxo2
dgKew8m5xUQyNTklgT9JYroGALu79d1mgyiKQI/ck0kb04Z4/+mZD1gV5n/b
L6nKFpYpi4rLlEtx8aBPCfqKy0sqKmsqS+GZwAdoFWUVFYuZB6uo6BYw/yz4
9Iu5Oz49+6f/fG72Yn9YgiBDv+DiOglew0PfeOihf/oXrdYx6nCIZrfoEKNJ
KTWVBbroBFQ3AtBsxrvZLHAxISmlY1lXOmIi/l744MSRTZ9eWAi+iLdi5JaF
LAQXlpQsXFpeWVNBWbNmKcOHKsHgUUkqLCie80/YLf/xJePjqOmRCHg5hpau
saGh4UHYP/2LxeqwIhJlM2d28tFoKguAwIcAdfXrqfnbYjY7HDE+FotlJtPh
M+GI0B+e+O1/+PVdpeXK8o6Zv3Q8FwFFubqkpKSsEphqEHilFeqKUk3pIoKn
QuwtIPZgzENVBSf/5OVmz4E8hE48Au426TcC3UMPPnj/g//U0GmFObuDotXp
cPB8FNU9NZXCzxJAI4Vod/cxjovF0ul0SgqfkYwC6DONv/yhRHTN4hs0hcXq
soUlFHZFeYx4XlpSskJdUV6hKVcvVC+sLC0jeKgjRQsWKOYdFNpQtaDgnf98
bvakMAFdIkWYZwLdQ7AHH/zXhharZWjUbrVbLRaLddThdCZSEhiU4kgmrEDo
uxu6u82CKMak2KSU7riQDZskYVzQ3fn0zOwHHUvkZpfdQP5YjLgroeSipERD
mRQM1pUsrFSXQsLgrUZFLBcqlYUKZVHBIgXeCxWMRMU79wK8HBYgS8KghOsi
x9z4zW/iATAbu7u1ZjMx6LAyHvmk9EZmanIyFSU/DnP6Ld2NZqvZLIspKQ23
nTCBPCEsjN924LbnPuCIENd1epFSXUYBV6RkDgr2StRL1cq6hUXlS0vVGnV5
2cKF6kVlFSV5Ny4CpAUMWt5HFQXL/igLc6YwBEeEsqZ5YyP0VmN3V5d5oEtr
7tJqAbC7sVsL68ZXZjGJBJm5EJ2IhN0RKO4tXY3dZo7bgtQppFMZJB68zPg4
1/cl3X7dyYsfLARzsxWUMReyulBEj0XknkvxvlRdXl5RBr+tLF5UUqwBtjJ1
sYLgIYGqFPOmUryDPFME5EUl3mHubGw0j5rNnfrGzs4uM0uNo45RjrOYGzft
BkSEIC9nktHz50mFdnSiinR1m82cnutPX5DOpAkd2OvvD5v27Ttw4MCpix+I
v9oCyiXwzDnHJBXKkmQJ1Yry8pLyykVQMsX4CaArLiaCC9UFygKm69G3ACgr
8fiYQVKBZ/Jul7tT3+kEOnMX6NuCyzY75FQqkeB5ftTRufFe7b/s3u2xmzNc
Us6kpKTb2OFOIVq3dHdDh0bDEDVTEUhTod9EtX9f+226H/2IhNJVriThp3+m
ZsiYY0J3VivzLspQli0tqS4pL6X0umhet5GkL2IkouMEvs8o/uv+O+/s7T15
0nRKECLRiAS9OdplJiSWri5iztxpjmRSmSlINZ4X3aI51Kh9aON//x9dchIC
NJOOxaJh17FOnkN1cIholLJCOn3GiNogjPfDDAd0t+kO3PnLuab0qiBO42rz
McdwKYAgXwpLUAhRISA3CV5xMSXU/K+hsEClUOfhwQ7EDZ///Je+BFWMSoxM
D+HFc5zoHh0dNQNel77TnMxmpqYymVQqyuPNzY+GNt790EP/43/+qxyQk3Iq
mYqEXRG9kzMTPqG9HcUhk06Hw1DYpn7BFAY6na73zmevekF+evZ0Cbqhsrf5
Y5kT2QbkIXuWo7klka1eVKxWlTP4xDFIY9DoUfdzk65d96XPb9jHwTdTKdR0
t6uT5538qNnaaR6NQoNNTaYIHgAiMqORY4nRgEfb8I0B+R/0gUxGljPShWgU
jjra0GW2ct369rSYZhkYopT5p47mafsPHDj5cu4qEd5aWKbOh9wcgegYlPk6
X6ZQL14GGpctYlmTMAPQgjxrS/BeUKJQhMf7DIaO9n2f1wt8NGa8EIsKDkdX
gncgkVg4FHCX60L2fHZq6jxsaiqVgisiBkd5q7ahwf6vjUEvYMc6oT870GCY
rU7OIei7Uf7OSnE0TXgHwD7Qd1v7AV2v7kfx3FW1trmbAK+sumyOvbK8dAF3
DG+5smTZYoatmPw2z18x4w0gkWJ+ZzIZDbp2w74NXESKJYVUNBbhCB7vdrit
fDTB5AkZVBhsKpNKJhKIQd5p1e5uaNFaQklZll2p1LFOfcLcaOY5B8QbF0PX
NEn0CS4XQPYB2/4D+3sP9OquUoj+mJJiGeML/MAzWX1gX5cpl6PJrSJ0JXls
iFPFnItSzVM+owsDnqH9S5v1QiQWiSUjkRgusDEQBTw+lCRw58EdGKIsQjCB
TwY8x6hT2zgwdK/2brtMKSbBbepMOrq0IvoKBKEDnQO0Ha2nhV3gT7efFnHv
1PWOn7q6Iv/V0iJ1FUhTEH+MIcot6rJ8l7RcNYdPnfddRVGRao48mkf+Js6W
54zt7WZ3LJqCopJiotu8BdfvFuUk8XZ+KkWIZBlBSAAzU0CakKKi064daB3U
WmSrU6Q/FkUeskUEPqqT7hgARsbDaHChuk0mw77eAzTONp54l1WH93TN2Vdn
CpRqamnL5ioCI7KMvePLalUJ9FhZWT4858rHXFr5TNWpU4g8o864r2Mz75ak
jBCLRJAzzSgLbh4ZMZOaymRBYDIVcobkQCiZStK3ADcpJ3ifeXdjDwlR65A9
lBGTUd45apVlEZlXD1njkNLpOCC6qPYJ42xc39d7whS+jBJ7ZeBgMxoUNRW9
qRiEufRfNZdw0CYUL1iEVk/NApP9Wb7oqRS6U7TZSGfSGfa50ARI+izyhuiw
NprlCA+Po6YAWBKo6HzI77NZ7bycyjADPhHh16i12Xif12n2+ZIoGuIoCp/M
xSjJcKIYQeMYoeRCCdTUbjD09vX2nRj//ZXT92qtoryIhdZc4csnz/k6Ae/E
p/DbsuL8d4qKiuYCr0rxOcSFiXYF7NPvi0UhxqIRdyQqjnY1WqLuaCbJeh4Q
15EMBW3DDU88cM8/3Ns1mgrBExmBvMNp2+0LBAI+J9/lDSHleB3d8FNO5tyI
P4eI5i/G6kN/PxKMibYyGQx9p9JXDm/2ldqScjBXUp53xvnCkKdpLsmo2JRi
Dq8q/6RYogJ3pn5Db6/B2I60CXjJWIr3Oh1dm3ieqEulKM4QgbKl5d4H7m9e
/7X//vd/37gpEWJihfzT67DwgYBXdI4ODATlmBwY7fIFMmLCDfqsZkeE0ME9
Wf40CbQnBv7ZJ1yN/vzUDaymASLRwmaDSpV6jis8VSnzcpuiMd8SKpRL6F1n
GB8/EQZ7fRGOQ2aIiXxATPBOaBWfGKO8ksrGMqFQcGhd2+rm5p1/z8zzWeto
xodino0lQ3zCYkHWgVTTaodCctLr2yhnYrGEyLvd6Jyod0eFYA6KCMxviukT
+n53FWPdlwqqFy8HffnLJ5ZUJCrn6FMvzwMk0Cjr1dWsNDA11ieMm0y6PqOh
17gPlxSLuROU/Ua1XV3OWJKoo9ALjQ2s27V65WM77iNwn/2H/7TpP332awE5
kA1lk5kQ57PKvlBAdFuHBnxBmfdptTawKqJw0NzJEQPREhMwQGg0tht0z/T1
nTp15cplelajpBlmWc2i4rL8QIW1duSELI0sz3soy6l59orINRVsH3FfX9jQ
C9GCcEImF708b7VoGyw8UiR8M5uRQ/7W5vsP3XV36477Vtevhnd+7Wtfu/vu
zzaGhuQUQlCWrT45GODdzoEWK6LPZ99oTqBIBERRcKMAOkQpPRlLEouxSJht
EjH0jZ+48hFhbnYFiy7Y8rxvFqvn8sd8plmu/mMbUZ0X4Erl5+ICbZHuQ7Sb
OvRJORaTHTycytLV0oA0j+DKZhFgnp6m5u2rv/bZ1h1r761fvXr1PavvXf21
lXff/fVQkFKMLPt8shxCSbC0NFhDAZ9F6+PhuQkRaYoDt+5YOp1M0+A3kxUM
fQyeMP7CVejO6coSRYmmlNInq3mEjvKHOq+cWfacA6pUL2Hjss8oC3QIPNN4
WPcFA61vxRBsQopHPu/SPoTsl8zIqOApObR+z5HWe1au9OxqWnvPPavr7yFb
vXrlypV3WzxBmRh0yqlQCPC0D7QGx4IOq4w2V0YNpPruEK1iDOhSyalsJotW
CfSZeg1x0/z85QrYm60oWba0hMmUMqVKRUNrtWJefuXJom5hrqoD35IqheK/
mITxvjgq3n5aTN8nypQQRNHZ3b27wUl6Bak/m0oOtbR964meoBzctY3gAVv9
PfXE4tfuWtkyHELekQEylAw5Rgd2PTHg81nsIV5Em4SyyEUAzxeIUaeRnDqb
zXJGll36TKb4xJU75+wNYA99QUmZsqz6iyUKtpxSTFFWVDTXAynAapXiM+o5
EhVVS9CmxPvYNlSDUQB9YpR3cLzZYel+qDUUy+QLumwZsFjghEHZ37R27bq1
a+/D29q1a9bW16/6+qqVLR5P0O/39DBFxg/tam4YGBzyBINWJ3ltUuAjYswn
igxeFoHMmY19tNB53HRqYvpKG6PcdG2puqycRhJoZYtUrCyolCpAW7Bgrth9
BqyVMWzsSanUmcLjkCsmlCITqp6gR3aPIZdbGrsftPEkVwCPtw94PF4vkt+Y
du3Wrfdt3b59KxkArrv37tX1q9a33js84m+zAUvCa2ltbm7tGQSfPopH9Iai
yMm+WAz6ANIOoScIBiO6L0Nfryn+0vsDm2ePpnzoesognylBFlezTKmg1rZQ
pSya7xCqqtRVefaqqtKmcTpdYjD1mkz6Dv3nN28JBBy8w9zd8FAjL1LVTqXG
Wi2815tIJkPy0ODaR9be39zctP3++++/r6lp/crGoWH/2PDhPW17mw/+IAg4
Xtvu1taWXT2+QDLBW4PQNbJI3i46YqQOspkLbk6gDaHP9CJ3njr31pXt4Z2e
vUOTH/LRwIEyqEI9L55p1WEuUVIpmJOiyiUFvzFFKOT6+gz029S3b2j4nz6f
Y9TR1bh792hCzlBd8DbKvDcEhRIKeQ41rX10XXPTg83N393e3NS07olgcMxj
Gxoe3tPWur7l0WG/Uw4NobK37u4ZCQYSAacP6SWdFh1OXwDUIkuBPbcgUG55
Bv9k3/jJy1c2Vrp0urRIxRS1evH8UhENVtRvN3fFlGiAC6ShL1RWLVli0oWN
wrhAZaHPIHDc5g0bG7Q+q1nbvfsJrZcGfHKGHw2NImWgWQ2NDbaufZSw7dq1
a/uOXU3/z7A8FkLUDWmHh1tXrrxrT5sf6WVMq/UMtR4cDoYSEKE+Cj/RR3UD
woX6KMATBaGPwPXpxk2/qnnhUu79O/dcQfnSshIaBKoXzi030LRFwRb9VPns
OSewocTKqGmAlO6XGDw0DCBPv3nDNzf+s8Ns7W5oeMLHRxFscogPBaCmycY8
bWBsTytNcLVwwGFZDmZCnuG9g8Pfumvl/+YJNt1FyTPYYwvatQd7/CFZDDmd
lFGAD/BY33g2m0GZFwwGI0LP0HfCFP9KzQ0//t0VUfgzVZm6iPyyRLUory+V
hRBmykLUP7WyWFGoyG+ioT6+qqr6DNoTtiGOtUMd+n0b//mb//KNht2tD+7a
6EgkAC+RsFDRJscM2QaH997TOhzc6xkcHOxpNSdScLyA3z/cUr961aqvr/TL
h+9BlxcKDflDdsuuHmKSD9mtMvVN3X6rmJaT6dRUVnSYqe+jcxAGk2n8xCl1
eW1FXU3Fj3+fj0J8sONluT/vBW9Fw1pCLqoqzg+rSXcqaapZyOQn/oTtN2Ex
OG7sHx939Y+jBQOBRj3gbdzY8FDD7gakdjGaQDJJekeRUFCtQ0HfwMgD97W1
WYY8zHzQYX6bdlfTPfWrH6lftWrV3wPoyIgfv4dBf8hr6znkp1+L04fiSfBE
nz+NKMwQPAf8H8HeR/T1nTh1q6aytrb25srSGk3dTXU33XzTr3LvsdvgZ6VM
tChVZWhcWaix1EmfLChmqXOuDUKrYNJNvH1uBt5p2LzhYXP3xm5aDdq9S5uI
JqI8WgFcrtfrDdltnuChe5pGPCstniEPMk3Gp33gnrX37Vi3dut9a9fVr7qr
xe+XEYQhxl7Ad+TQCGIOZdALZZfJ+HziBUGWUGeynMMK74RvztmpFzSaihUa
TWVlebkGduutdbdXXJye/fOMmnvx9goU9hINavrcvG9OcSrgpDTWZCptiVKl
uA1+geay32UyhUlyHjfqN3dzXUC3e/fuJ3b5RXCXkPlEKoQ2NeSzD3cN72xq
9QdXr2wbHhm2++9d27RzR9Pa7c3bt1JxX/V/dQ3bstbhQ2Ne2SPLgYDt0Igf
vKF7D7Li4Lea0zEa0WQ5ZBawJ5ygiAd7J54+VVNXWVlXV4nHSo2mbkWlpq6y
5itfefblS3/OoWaBar5NV0CzKIvZyIxNbVX5XVCs+N12VpqAoVsQTCyxtHds
oMldp7Zh90PftPKhZDRr5/ksH+ADZovY6O8ZXvODw8HQqm1bm9bet72pCQq7
uen+5u07tm/dBnR3Dfl7PMExnx3qDPIsOjZoo6gNoIlnTT24lRm8pNnqEB0c
m7uY+piPnogv6tXcWvvVutpaTaWGAa2rW3HTLbe8y7Apd2t5Ic3+UP6oNV/A
Zi60oMdSJjmsio3ez0vnpPA4jSEEOhV0vKNdL9ICEHmn1hnwpnhzMuRNur28
lw+O2nuGW7c92RZKtKxfsxXYHtjZvLOp+f7mH+zYvv2R+rvuaqkfHh4JBj02
21iQ6JJ9NgYvQcKTgo/g0egiI1tthExEk0nbX/pOnUD6PL34pspa2n0Dq8vD
q6u5893CbzpXCMryQ5YFyDHKYlS8ojLKnLSgPl/cq/oBTwK6cfYrPG7Qb+Cc
Zq6T4GltfAiJxRvyhlIJLz+F9OlpO7RqTVOb1ztUv3V7Ewofg7ceT83b161a
tXJolWfYjxo/hieZkPhH/KxPQsPH6GNf0PhJtFoFK1paIRYfHx8XTlFVOnHy
hWrAImxwzzqCeHvp6XdXM7cjvbCVPSXUp4J8k2YRKmWhiunQeWm27A0pLk2M
h6ko9EFy7mvnRI7gaRt6fHI0wUeRUUKAGU2MjiaDba2r13y/zZsIrdkBeDt3
Ne/c+UDTuqbWpgcfqF+HzmHdIHQ1bGRwxD/I4CG1yDFUdpFSC2MPvpnNOGhh
l00Ex8PjwjgdfzSZnjl1qhrgauuIOzJN7ex7lPrc7C2KZcoithKkLmeKTEne
yPRZcaEyv51NqXhNmpicCIfjFOBoT/Z1Al4nt6mxoUtMdGb0SJxeH/AlU9zo
6OhQ25r6bY+2eUIt9WubYSBv/bp71x/e29b2w70769evWj/sR1Hw+8ag0A6P
Bf17R/x+NOfQmwk+SamFUYjPuq3dDgfbtxSB78RP0PnHE6f6Xnhm8fK6m2+u
BXOauvJbS3/9rtjydmtJ+fwuCTbTROAVkugsUhbPt0ZoFqakF+MIvVMnDH0m
g2GzXuRp7X/LbjOa9ZA7KvK83YvSxXe6eYun9dH1q3a0DXm+vuZRJJSm5gea
dq5v9XiG2/a2tPxwW33915lz+gKe4eGnnvRYvnUQzpmU5BjPO0MMXp6+jNzd
rbVyyCyRSDwO+sLxcFyAJDz1KzUxV1tXd9NNlbdW/P692iT69nRpUdH89Da/
S0lVxODRcEIx5526+JT0wkSc9oSDPt0mLobMyXVu0lpR8BIpcOfxkm70jvJ2
+9A96+rrt7UNeurXbN2xvbn5weame5/w7G1pa2lp2dmCsrfKY2Pw/P6jjz01
hrZ3BCo1mYnx4A8tf5DQAWbGCu/vJngAJqWBbSI8EY7Hx+O/Kwe2WvLLurqb
/8KAlwKyEuqlmg3MCtWsmWVrlooiWo6dm3EqFG/Q4kY4X9d1ug5edIM9rnu3
PYFWZtTrHRsKIrv4eB/vGWq775FVax7d0+qv3/btR5uaH0S3oPVDw7S0tu5p
2rZ+1aqWYY8/CJkZGjn4k2FUBhuxJ8eSCXTqlEjziQaFsLu7G64pOMAe+JuI
/4aNz0zGU0iXtbUrblqBp0uzf3F9+tWKanV5yRfLiorK55p0VZFCwSYw72j7
wpMEj7Yz9qHq6TlajDV3djX4oqFAwusN+nz2UNBrD3iD9qHWpnX1ax79YZt9
zZptj27f3rSmvtXfOjD0RGtT047mNUAHMWoTUQpGDj/21CDg+ZFBochpQSUR
y/itviB1DkgsZj3hM5N3RiLpeFxCC5gRsr/RMHi1mhU33Xzn++jr6dkfl/+4
PL9AC50JNAuK1EW0d5utilXly0Y14EmTdJjGRIcT3LzDzR0zd+32iwEv3oIB
El92b7DTax9oA7xVj+xpGqlf88ha9LHr1gwPtXS1PNG6c+fOZpT1+laQh/xB
rnl0MJSHl4FopcWKhBxk5VCUZdp9AKPYi8XxHj97Npt2CBe+WF7J8gqlz9L3
2wFKunv6qzfVzK1DK1gSLVSo8/GnmBeeF8I0GQ8L/bQJXBB5pwPOadltS3gh
VXzeYNCxJWQebURRH2pb17x+1bZ1I6vr16xZt+7wsGfv0LdaNrUQvubmrWvW
r2vzA97Inscff/zoCIWdfziYQbsYQ93kA7J2ZGTEZhPF7jw8PfUMtGPNlD57
NhM7o/pCNcIOhb227lZN6btIsXeD+OsFtH1OWVK+mGoePkfXAKwKdX7hUqEy
TUlhCbrMZNB36GleTvtSObNZhoiGb9q9nXbfgN066rAOPnnfjqb1LWvHVq/a
tmrb8NDeIc9ei6ULkQf6mppW/XBNj9/ntx1+/PuPHT06TBUP7KGUS0m8LC/b
eo4cOWKz2axWQGNbs4i+dDwtSZkLk6+DMiapNeXldZpbS69sMH+ptuBTKH4L
8pwBTqGCfaJQzo92l5ylnfy0WZ/Tc7wYAXkuzmwx+wme3Ysra7TafHbzqAXO
2bRt1fr1e4GubbitFRViqGtTV8u3WlpR45vWtKDs+YJtT37v+wefArxgSLZR
fpFjUkKMRMSeXQcPAqC1m+UVzq3XG4R4PBY7c+bshez5L2hW5PfT1mgqKleU
Xsk5BMZf7qWb4ZTFhUXILKCPVfP5kcuSJYVqRZzG/mgcjMc6XKLodrtpT625
ywJwdo+XN486rVqbx+K0DAwMNK1es20bClzb3qa2QXRFlsZNlhbQ98CuXTvW
1LcEAz75kcf/178D3TDiDL2fTItHEi1hiz0H8/BQFQzklnn2Yul0ajL7xn9Z
TthWaCoriL7S01e8pQc/98qNStKdRUULiog4FAbV3LKeslqpMNGmRsDjjnXw
fIR3RyDKuK5Gi9M3ZrfaQ87Rzu4Bq8dudQxZLG1r1qzZuWrb3qYH2lpbBy34
jqWzsbGldeeunf/2aL3H75PlR3Z89yfwzWF/aGzksI3pzGRMFEXfkYMHe3p6
rFqCZxYiolFvBEqWNd/ordbU3nx7XQ01Q3hfdOnqzgJcKmVKhXoGyir5lS+F
soqWi6p00WgkjJbdxYluJ7FHy6lmq8Xu8Qz5orxjFH5pAX3WodHBnfetaVq1
ZseOHc2trW2DQ0Ndlq6ugZbWvc0/+OGqFuhNn7z+vu8ePdJjs4/5/buOUOjJ
bMkkKoM92n6GvNIN4iIxgIuPR+Lp9IWpUxW3193+VRTzmsrSuqUVtc9e7Za6
3P9ZjCJPzVB+sUhNU87lbCShYGuKJpPAcVG30yE4ODfBMw/YIB09AcAdtViH
fHbnqMUy2Na0Y/Xa70BPQ00TvoGurkaklubtj+1Y6wkFg8iP248+daRnyDM8
cvTg0aDMvFNOplIyuebbmUWIZYxGCOo0Bd5bX9DUriAFXV5eWb608ooD7x30
zd48NzkrJGU2J6jzFSObjkfG+7l+lwDqHEgteXjdVvvwsCXkBnvWgQG73wF4
Wu1jTWua6h/99vYmwNs7ODyoBbhdjz128N/vHw6GqMsb2fPU0UM9Q0NjIz1H
R0Ks7LFNIpmDR47OoQO8SFTmhPFYOpM9f/7N/1pzMzVClZU11KbXaa76lMrl
2V9UlK5Qzq+isB1k8wvQSxB8tKLPuYCNXJNENQDCkwYHW0M8raxaBqxjtPe2
W6vd9cNHt23durUJAPf0DNsA7uBjj6PhO+oPeqlFl4889dShvcNDtp6eI1Qc
5JicidHkvefoT47YrD2AZ2UpBQ/h9OSZ8288swxlvLIc8Cory+tWlNf++IOc
NZp+7pYbadmvkB0/mRu/QM8sqaKWyOUSOCHsctPiCcfR9kattqfnaJM/FHGb
nXardpAPwUuBuakVVR0AtzfvbDs82PbYDx//3k+a/VZrkEIvIIfaDh86PDh0
pO3Q4CATmFnRnUqBQCp7PTYkFkqcESkmxCJT0uvnX/9dTQ1kGOIOla+sXHPT
rZc+2H7d6dlbbqxZtIggsWELHT9jS7bpcCwMaC63m+f5sCNPHojqOfjUwSMh
trNo1Eqh12XZ3dqqbd1G8L796KPf+cGTT37/se9+79+3N9saxoIkuQJycPDo
QSDT7hnWsu4nJqeSUgLwbKwqgDy6lQGDJ0nnXj8/o6LDP5XsCBBA1v78w2wn
f+WOGxX5kcsSdX5GqKxaQscwAI/Psv0eUTEiuIi9gbaeXUd3+UM+XkAAOoeG
dg/RYHrXridRHh759rcf/c6O737/+9/7/o7tR0ZsgObx+Hy+4MihQwcPtWp7
bPgeakIqloomohExIPuOWG1UFozHjPATKQ05Nnnu7JvPrFhBXslmLJXIMF/O
fcDzKvRrgZT7mRJVb0mV8u3NH1X7zoYFF8RYMptKphK01M9D1JsHtNrdRw/t
QWl3O51W+wMIRRq8a3ftzK/vwT937PhOU/Ouo7JP9hF5PnvQc/Tw4aNard3m
8Vho9SWTkiCFUPcCIz2AZ3ZweiNt+5egpSdfP/tmXL10KTvfpKHxX13l7b++
9OFOU91ccCPlTxpO5BF+TvFmxkjRHo1lpzLpJO0ihodakS/37Dn0+IifdwGe
5VueVg9bWaCVofvWrlkDiOtaUb/9flr5kYOhEIE8+uSTP+g54hlD+0OLDalU
OiYiT4r+EVsP+aaeM7r6+9kWl3T2tTeriTaCR9Pbyltv/ZB3jsz97IYbVWXL
8kPP+VH8586M055+KZnKZjNJtJ+0B9CKPNK258mnevw8TwnVbhkeHhpu69G2
Ik9u39rU1LrnEKB5g4GgLLJBJiAGPU/uOnT0yMhYkFYtZbbdJ4l2SPaNjGiB
jrY/coKpnzbDoii81qspr2Zuydqg2yu/+v4I/iI69pCbOX1TgYKCT0XHP6vU
Juj2dCqdSeHfnJpKJWJANGp1DFh79h7WjvAinNflNIcGdg6PjDTv2nPo0N7D
wzabD7yJNGMPBERg9IvD/mHtk9AsQ2M+36g3Ked3MwGg6BsZtrG8gi6Ic5nC
1MVmsmfPqcuq5+KOOoba0x/unBg7/zHNDkhPaxTKmsVojarVS9SKL4VjMZCX
ZttR89vcHawM7D18qMfn8KG2j6Iu/N/3Hzp09GjboSPD0GvUyqOjD6DnDSQS
su2ftv6vpx6H3uxB2+pzBEOZDGNv6vxUVraNeJBXzOZjZgh2Yz/gpaey59/4
wjKSmcurq5lvam6e/qCna98D7qVlt6hUavWna+KxiIjKF5OTEu0/QgQGEHDW
gZ7Bnh6bzc6LTM7Y7WNBv33Aztu9Ph4pCCkjJHtlmU/K2vu/+2/feeroUdsg
2icfGn3aEAkDvGzGh8gDeXozByGN1OKKSGcmX3/rxDJNOZU7DcBV3F76gU43
/EV4v395doZ+YTPxCDpnFx0BisA/kRDQxQCe1QZ4PTaf1+2A9hy1WkedNv+Y
J+gL+kBbIBFIhCiBoKpt3779e0AHWenzee28PEpphe0YyV6QbTYt1QS0eUa9
wBnpPK10Ifum5v8o01RT4KGsV9be/te/iVR+xRcA42HaKsumZAJNkimDen0O
q30QdNh8CT4qkh5FbrBa7XBLVHCEXYIWbJOZrHyw+d++99hRikePPxDwhmSn
OL+NMHshgxqoZYFnJu6Mxv5+YSKTfbNquaaczdtv/nLtiunchyoI74mPzURn
X4pPQJrleyGzDHgZuKeXt1qHbIODgyNQxkimLicUjNVB+EL5XVa0ZDCVGmn+
yXe/hwadmAvyPtTwEK3J409oS3nGah200egIvgkTCF44MnXBtBxZs5rg1dTe
+p4j27+OvTwhSYJAvQInWK1ylp3Hi/Jo+ayDg0fQlvIS2yHoFJ28c3TU5rP5
2bwZ7yM9P0FCGdGO2Pz+gDPkFDMhmQ/JsQxc88IfLmSstp5BrYO9Mg06HLTw
5eayZ9Rf0VSXoRXS/O6jBMYs94eJMDtJwTmAziqKFH8o8D5oMevgEcKXoq18
csDhpW39Vt/gCDp4aw+S6+GjsCODtrExfzBES0FiyB+gXXZAl30jOWrrsVvN
VjCn7xfC4XHIzQgnRM6XlatYtrzl9o/+zh+5mV+6JHJO2rlutTrkNCtYpNCc
Qwi+IauNpudob6IBHqAdvJ02s9iGe3oO0VhsxD82BmXmlaMBX8CJDzR5KWQV
Wgyy2a0WarNcHJW7eOr8hWwmJuxfVlH71dO/eOVvcjeh3GzcBeeM0dFeGmWJ
YIvqcZS2gFsHkWBGhjwhcscptmeM50d9dsAbPDQC5QJsoQAqQUhMxAKhjBzw
sR89n83KZjR4HNzSiHYyGolKFKoM9slT069Of4BjUh8Q3nNSlDbJcgLNWczW
jJiiGZcUczqdPrsNOdFqg74Mpl4/z3aM86Nep+wfsrMWnQ8kRLarhyodbQwk
PUY7x0QzkyounuuISNB9rHPP8pnzr7/1kUP6U3suzvoiAKRez0w7Vmm7VSwm
+mwwu9V2BFrSLwdCNP3KyN6Qk7eiyaPS4KV1BNqeRVOVPLwM7XAVUTcpW7rc
YsTtirjppEdqKpyd/NvfMfglKSzE3dS0U6/X4MvQFAG/7WjCa3faCeGRI0cR
Y7RI5/PZHKgRZqtIciwRSPJy5m2TIT/Z9t20w9oNz4zQvRWQS5hkT029/voM
rWz9zfHRPdfCEy5W+SzdDtpxnKDjC0gWlCNt8NDhYRtzPH8Q7Y4586ZTFGkH
kpyNZSlR0qmpbDIh5xfxROgUK7QOeUQslpEkOtR4/nUWb9fgLkm/jNNCcIcJ
LcsWc5c5IMbkKPkhhBfvsdvhomNDHlBHo0u/XwYwXswv1yGDpC8QNDrdJidl
kcohyr/gEB0iJ4UldEQi8KfOvzVzzW7/9DxUixDW98doCK/tdgBYNEFjypgo
EjyrD/BsIyM2KuW0LZzP93j5beQXMpk0Q8v2zCNjIkFxDit0eiY8JSUz6cz5
c2/NfCTC68rshTAdQOvvN+o5kGfukmOJqBygA6OJhJd3Oh00SRkjfHOLrCL+
iGWQCyhkaT+0AP1BCoIgK5jtDlpcRp8uoBpIQJz5A+vGriE8lxQJu2ipqJOy
ixhDWkHuSIKrqOh0OFHZ0NccoQQ6pzdZQiGnpJ1z4ty+gIwcNdP9QDg4JtIK
x01Jmezr2Yv5+wJfM3i/HQ+PmwTBCPqOcWYLlItIRyvRi0OAyLzD7wd3QDcy
cuTIkfx+HNJdtFETCdXHwIFSAHPQiWi0Vy7JlA6nBbCZ/e01vx3pa2GXccpg
iPSzm5JYHFZZjiQldKw8aoCVzuL5SYWBOyAcGRmZd1Ghuxt0jhA80S/6aDVI
jEVibviCJJx3h7NSNvvGtb9z5Wvj/f1vGvoFztV/jDVGjqQoReliRd7nG4Jq
sViJPUSfn9D56RFNOKPTNu+utClOjDGEgls6ZpTOAt81TJhv28V4/0TYKHB0
0zFXHh5buqI5BI8uyOqwofez9fRoAQetHQOHJwYZjd5cQpXT0AMxWYgJ4UzE
1Y8seu5jAA5B30+3v3D1s9O71Haa6X4kEGW8I8I7RbNjFNnTatMyvmC+Eb8N
TkkL5lY0Cw6RJZYLFI35Q1ARVwQV4czZj8c9VXN0m192dtDFhhKwTB4e3XnA
gR4WIWi15f3TRr0rPdI3bD4UBdTzdPjsucmp87QXQhShxGiiMvlx+V9vckLE
ZOQ4owv1r5/u2yXqBVpWjRK8qJu6bI4jNFpCZBth2tPhI7/0+ZyxZOTsGzUz
kFyX33ojlZJBHtRK9vK1RvVHMwkdejRmrLqHeQEVS0/74CO85HZB9LsFF03m
mTEerX6fA7XegY5JjMWkybdyT7+Yf6XLb0xNRoSY9NrMtax0/8EmOP0+9zG+
3xVxhaUIF3EIbj4pJaJuVDDBJdCd2BwOgRp6hpCc0md1+ESnG72FJJEXvmOH
4vSrV7Tz5m9nE8e2uI/FjklxOl+ORjYS4flkDF0unXV1cXSbJ7b0B4AsDB02
VHAQGEmI6djUW3RfszuuNYa/YGcFsxBJSdLzdPOE5ycBMBaOAGTUDc90G5Fz
wi7Wm3KjhI+El8MhHuP4bCydzN9k7dlrjeEv2FvCpkyG5n+T0uTkuXOTZ84A
oUTjH1eYQ7lw86gbtFoUdrvmUmuEhGU2LGXn7s2cu4p7JPytbeZXB04+f+Ec
qAO2c+fPnz2TziCmJD4cjgjQIG6XUXK5wxGe3c4RxR/ZRwgLYjotzczPhG75
eMXbn1huZubyiy9MTr74W7r1BbtvCYxuzclHEILRZIbojLrddGcLIX/3h3BM
iiNnzr3Cx6gOvIvlKZi5+BYCb3Lq3Lnz2ezZs5I7OkGj1xhLOJI0d+cc6BtT
P7uT2cvvbOL+0u7ua2pzx3XYjYNzucuXz02ePXv23LlzqbAUlTJsaTPD6ExN
0v5dRh0NiM69A13u8qVr2JBfnd3x9IVzYC+Tkl6fOp86O5WdYncQwvNUOr/T
x21Ouj4p//XJn9nlZUuqdGfePJO9IKXOs1sITSHhwGGztB8gCtXFC2d/e62v
8oMbu11I1W3pN4Uz6cnz0nHalsyqBiUdSYqGw39MKp88yxWVwaqUVcrbfvO7
17IpIKO7dV6cnXnr9df/cO7s5OQLV3innI+jzUzfqAa6asJY/cXb4tnsGYlu
E3utr+uvZJdmazV0w0i8sTPEys/tN5177bW/9drHR2Uzsz8uncOWZ7Ba/emP
UX/zoW36FTqcyuDRMx6+fN1gmyWeXlSxm4DljT69nuABYKlSyZDlb3amLrt+
XHOW6PtVSZ4+FoHqssrrCB4ToKfZbZXKqtRVDOO1vqa/ur1coMzfEkVdVKS+
+VpfzV/bcrOXvshuKYjsWX76x9f6cj4Cu6iiAx7KsqKbrsf/Y312+lPL1OXV
6uqFp6+fvPIOy92wsGR5mbp0wfR1yV7uhkWlgLfw5uvoP1d/py0uLVtWolJP
X6fwSpfR/dZLcn/dfc4fG/tV8aJydfmXr/VlfESWQ/Bp1MW/uNbX8RHZ9Gxp
aY269OO8fPBhLDddWaoq0Vz9kchPiv1Io1r0sZ0+f3h7VlNzbf+nw4/WfqFZ
VnGdVgWyn2s0P78+S/os9UQ/q/3Uld5B8xNouV/UvngdDQD/zG7/fz+5s/Yr
sBev9fT2/wPbLdKh
     "], {{0, 0}, {223, 164}},
     ColorFunction->(Apply[RGBColor, 
       Part[CompressedData["
1:eJzFlzmOFEEQRRvEATBxOUnfgSMgYXMVZmGTQOojYDCLiYGBgdFCLcQswNDs
wyIOwAyQ3Xpdypf1p8YjnFL16x8RGRm51NXrN6/duDj6ZxdGo0ujzi4vbDIe
VfZr9X5lYbsNX+oejc/mk/HtzWJPo37tVrEnq3dz9ObEvX+v2LPGP36THv7w
QbHn0T96/m+O3tzxzck7cX7nf0O8rnPnP/G7d4q9XM2T63ewvzDVxfWdqr6T
sTnx6z7p/Kf+ePtmYZFTD+Kk+jhP6zfWi72I9YOfPX+zQX3dp62ePoLXcadN
/er6zJr+Nbe+rluqzzTWB04fDek9PuvN914tLNaX8aX41if/KT79yf+Snv+Z
k1/S13WfrepU9+9sld8Q5x3O7346Pvkl//U6bf0n/vpwYdE/nKe562//cPQe
n/0n7j5K4yMPc48z5ce7+yPx5fwcxfN1fa3Yu8iX9ZzH/ROezs+tx8U+RD28
7uuO72wX+xT57k6xz5EzPvrC+xv5133Tjo8+T/r+c7CLD/f+ab059Un5bW8V
+xg59RnS133b8nQ+4L9eV238Wj9p9OeN7/rYf6ov68oc/3CPD95/j+niJz18
SA93fu4fn0+Mr/8e1I7P9w+Pz9zjS3r2H8dHn7jj+3yj/9Gbo2cfNHf8/vP3
i/aHrj/394p9jevHfEjv+V+O+3jQf1of5vZ/eFDsW9yfTn4X+x79m6f8U3+j
r8+lzv/pSbEf5+b2/+e02M9BTn+k8af1B0dvbv/mzE9an66f1xec/jW3f38f
wNEnTv7mjm/O/KT17fqZo0/ceq9f6/u/f+aq77Th6H1/5P6U7qfwdP9j//J3
FJz9KXH2p5QfvztPc84R3h0fvetH/fvvkV3/998ju/5J/tHD0/zjP81/4vaf
9PRB0ide3w+PmvnnfKrHN4t6z5+556++v84bTv9RH39fkF/i3L8Tt3/2AXPy
G+LOv77ftry+37b+3X9eP6wv8u//PjyO81ef3/OGu38d3zzpNzeKvY/c3xGp
f62H199p7fjS/Nf3p3n4fj1e5W/O/SRx+0/zi97c/s29/h0fnvTk53uq4/ue
7PlD7/ien8R9z3f+Kb71Q9zrz+cL6wRe9/189e71T32tJy4cP3DevQ8ljh84
+wc8xfc+lPTm/O6nOf7N8Z84v7NP8269/cDR+X+pv10f1p/PudT/iZOHOfHh
rq/15u5/+6e/fQ9K3P7N3V/kn+YP7j5K3PNn7vmjPt5HnT/fAc7feucHRz/E
nT/9A3f+zs/6+vvvuOHsr0P+0SeOn7Q+8M97Gh9P6/0/6z0PiQ/peXd9kv/6
+7jNz/Wz3vVLes+z4zuP5D+Nz09z9gmeyb/1zn+I84Sf75ns//O/eAO3Yg==

        "], #]]& ),
     ColorFunctionScaling->False], {0., 0.}]},
  Background->None,
  ImageSize->{223, 164},
  PlotRange->{{0, 223}, {0, 164}}]], "Output",
 ImageSize->{227, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177200961]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100855591],

Cell["Find what elements are available to import:", "ExampleText",
 CellID->174747470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/rose.gif\>\"", ",", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163781585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Animation\"\>", ",", "\<\"Background\"\>", 
   ",", "\<\"BitDepth\"\>", ",", "\<\"ColorMap\"\>", 
   ",", "\<\"ColorSpace\"\>", ",", "\<\"Data\"\>", ",", "\<\"DataType\"\>", 
   ",", "\<\"FrameRate\"\>", ",", "\<\"Frames\"\>", 
   ",", "\<\"GlobalColorMap\"\>", ",", "\<\"Graphics\"\>", 
   ",", "\<\"ImageSize\"\>", ",", "\<\"RawData\"\>", 
   ",", "\<\"RepeatAnimation\"\>", ",", "\<\"TransitionEffect\"\>", 
   ",", "\<\"UserComments\"\>", ",", "\<\"UserInputFlag\"\>"}], 
  "}"}]], "Output",
 ImageSize->{504, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->318852376]
}, Open  ]],

Cell["Import the image size:", "ExampleText",
 CellID->92501618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/rose.gif\>\"", ",", "\"\<ImageSize\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->428416605],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"223", ",", "164"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->645623726]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20270],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Working with Elements",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->138842657],

Cell["Import the complete array of data:", "ExampleText",
 CellID->11416149],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<ExampleData/rose.gif\>\"", ",", "\"\<Data\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->353161195],

Cell["Extract information for one part of the array:", "ExampleText",
 CellID->532559330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"[", 
   RowBox[{"100", ",", "100"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->490951026],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"222", ",", "156", ",", "115", ",", "255"}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49194835]
}, Open  ]],

Cell["Extract the part directly:", "ExampleText",
 CellID->749132279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/rose.gif\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Data\>\"", ",", "100", ",", "100"}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->1955637],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"222", ",", "156", ",", "115", ",", "255"}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->11520277]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4227],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImportString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImportString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ImportFormats",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ImportFormats"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReadList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinaryReadList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinaryReadList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileFormat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileFormat"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FilePrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FilePrint"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25205]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5107],

Cell[TextData[ButtonBox["Importing and Exporting Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingData"]], "Tutorials",
 CellID->12912],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "Tutorials",
 CellID->14332],

Cell[TextData[ButtonBox["Importing and Exporting Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingAndExportingFiles"]], "Tutorials",
 CellID->509],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"],
  FontSlant->"Italic"],
 ButtonBox[" Internet Connectivity",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"]
}], "Tutorials",
 CellID->613781627]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->829751321],

Cell[TextData[ButtonBox["Basic Input & Output in Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicInputAndOutputInPrograms"]], "MoreAbout",
 CellID->31733911],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->67156743],

Cell[TextData[ButtonBox["Database Connectivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DatabaseConnectivity"]], "MoreAbout",
 CellID->57502065],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->267083066],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->611194968],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout",
 CellID->129830314],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->443786392],

Cell[TextData[ButtonBox["Image Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImageProcessing"]], "MoreAbout",
 CellID->372898975],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout",
 CellID->15201656],

Cell[TextData[ButtonBox["Importing & Exporting in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExportingInNotebooks"]], "MoreAbout",
 CellID->377179290],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->44531129],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->545702064],

Cell[TextData[ButtonBox["Sound and Sonification",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SoundAndSonification"]], "MoreAbout",
 CellID->62876589],

Cell[TextData[ButtonBox["Web Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebOperations"]], "MoreAbout",
 CellID->548843000],

Cell[TextData[ButtonBox["XML Import & Export",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLImportAndExport"]], "MoreAbout",
 CellID->113224511],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->188931587],

Cell[TextData[ButtonBox["New in 6.0: System Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60SystemInterfacesAndDeployment"]], "MoreAbout",
 CellID->656098447],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->19378156]
}, Open  ]],

Cell["New in 4  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Import - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 26.3674230}", "context" -> "System`", 
    "keywords" -> {
     "AIFF format", "arrays", "astronomical data", "audio", "AU format", 
      "AutoCAD format", "biomedical image format", "bitmap graphics formats", 
      "bits", "BMP", "CAD", "capturing images", "comma-separated values", 
      "computer-aided design", "converting", "CSV format", "data", 
      "ddf format", "desktop publishing", "DICOM", "DIF format", 
      "drawing format", "draw programs", "DXF format", 
      "Encapsulated PostScript", "EPS", "EPSF", "EPSI", "EPSTIFF", 
      "Excel format", "ExpressionML", "external data", "files", "FITS format",
       "Flexible Image Transport System", "foreign data", "ftp", 
      "geometry data", "GIF", "GIS data", "Harwell-Boeing format", "HDF", 
      "Hierarchical Data Format", "http", "image capture", "image processing",
       "interchange format", "JPEG", "lines of text", "lists", 
      "lithography format", "Lotus 1-2-3 format", "Macintosh PICT", 
      "MAT format", "matrices", "Matrix Market format", "medical imaging", 
      "metafile format", "MGF graphics format", "Microsoft metafile format", 
      "Microsoft wave format", "MPS", "MTX format", "mu law format", 
      "NotebookML", "paint programs", "PBM graphics format", "PCX", 
      "PGM graphics format", "PICT", "pixmap graphics format", "PNG", 
      "PNM graphics format", "portable anymap format", 
      "portable bitmap format", "portable graymap format", 
      "portable pixmap format", "PPM graphics format", "processing images", 
      "radiology formats", "rasters", "reading", "SDTS importing", 
      "SND format", "solid object modeling", "spreadsheets", 
      "stereolithography format", "STL format", "strings", "SymbolicXML", 
      "tab-delimited data", "tables", "tabular data", "terrain data", 
      "three-dimensional graphics", "TIFF", "TSV format", "URLs", 
      "WAV format", "web import", "Windows Metafile Format", "WMF", "words", 
      "XBitmap format", "XLS format", "XML", "X Windows graphics format"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Import[\"file\"] imports data from a file, returning a complete \
Mathematica version of it. Import[\"file\", elements] imports the specified \
elements from a file. Import[\"http:// url\", ...] and Import[\"ftp:// url\", \
...] imports from any accessible URL. ", "synonyms" -> {}, "title" -> 
    "Import", "type" -> "Symbol", "uri" -> "ref/Import"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[26019, 691, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->187556448]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 60606, 1493}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 5828, 119, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[6451, 146, 4190, 83, 70, "ObjectNameGrid"],
Cell[10644, 231, 1625, 49, 70, "Usage",
 CellID->17156]
}, Open  ]],
Cell[CellGroupData[{
Cell[12306, 285, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[12784, 302, 705, 21, 70, "Notes",
 CellID->4787983],
Cell[13492, 325, 417, 12, 70, "Notes",
 CellID->454771001],
Cell[13912, 339, 453, 14, 70, "Notes",
 CellID->116760393],
Cell[14368, 355, 225, 4, 70, "Notes",
 CellID->21068205],
Cell[14596, 361, 4715, 133, 70, "2ColumnTableMod",
 CellID->405487078],
Cell[19314, 496, 212, 4, 70, "Notes",
 CellID->15573885],
Cell[19529, 502, 3323, 72, 70, "2ColumnTableMod",
 CellID->937754380],
Cell[22855, 576, 684, 20, 70, "Notes",
 CellID->9382452],
Cell[23542, 598, 438, 14, 70, "Notes",
 CellID->333050903],
Cell[23983, 614, 605, 21, 70, "Notes",
 CellID->144045357],
Cell[24591, 637, 731, 25, 70, "Notes",
 CellID->463719547],
Cell[25325, 664, 332, 11, 70, "Notes",
 CellID->16411],
Cell[25660, 677, 322, 9, 70, "Notes",
 CellID->17008]
}, Closed]],
Cell[CellGroupData[{
Cell[26019, 691, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->187556448],
Cell[CellGroupData[{
Cell[26404, 705, 148, 5, 70, "ExampleSection",
 CellID->276534759],
Cell[26555, 712, 75, 1, 70, "ExampleText",
 CellID->87016493],
Cell[CellGroupData[{
Cell[26655, 717, 129, 3, 28, "Input",
 CellID->144430391],
Cell[26787, 722, 20626, 346, 185, "Output",
 CellID->177200961]
}, Open  ]],
Cell[47428, 1071, 125, 3, 70, "ExampleDelimiter",
 CellID->100855591],
Cell[47556, 1076, 86, 1, 70, "ExampleText",
 CellID->174747470],
Cell[CellGroupData[{
Cell[47667, 1081, 170, 5, 70, "Input",
 CellID->163781585],
Cell[47840, 1088, 670, 15, 71, "Output",
 CellID->318852376]
}, Open  ]],
Cell[48525, 1106, 64, 1, 70, "ExampleText",
 CellID->92501618],
Cell[CellGroupData[{
Cell[48614, 1111, 171, 5, 70, "Input",
 CellID->428416605],
Cell[48788, 1118, 207, 7, 36, "Output",
 CellID->645623726]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49044, 1131, 216, 7, 70, "ExampleSection",
 CellID->20270],
Cell[CellGroupData[{
Cell[49285, 1142, 242, 7, 70, "ExampleSubsection",
 CellID->138842657],
Cell[49530, 1151, 76, 1, 70, "ExampleText",
 CellID->11416149],
Cell[49609, 1154, 213, 7, 70, "Input",
 CellID->353161195],
Cell[49825, 1163, 89, 1, 70, "ExampleText",
 CellID->532559330],
Cell[CellGroupData[{
Cell[49939, 1168, 151, 5, 70, "Input",
 CellID->490951026],
Cell[50093, 1175, 231, 7, 36, "Output",
 CellID->49194835]
}, Open  ]],
Cell[50339, 1185, 69, 1, 70, "ExampleText",
 CellID->749132279],
Cell[CellGroupData[{
Cell[50433, 1190, 226, 7, 70, "Input",
 CellID->1955637],
Cell[50662, 1199, 231, 7, 36, "Output",
 CellID->11520277]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50966, 1214, 310, 9, 70, "SeeAlsoSection",
 CellID->4227],
Cell[51279, 1225, 1710, 62, 70, "SeeAlso",
 CellID->25205]
}, Open  ]],
Cell[CellGroupData[{
Cell[53026, 1292, 313, 9, 70, "TutorialsSection",
 CellID->5107],
Cell[53342, 1303, 164, 3, 70, "Tutorials",
 CellID->12912],
Cell[53509, 1308, 166, 3, 70, "Tutorials",
 CellID->14332],
Cell[53678, 1313, 164, 3, 70, "Tutorials",
 CellID->509],
Cell[53845, 1318, 299, 9, 70, "Tutorials",
 CellID->613781627]
}, Open  ]],
Cell[CellGroupData[{
Cell[54181, 1332, 319, 9, 70, "MoreAboutSection",
 CellID->829751321],
Cell[54503, 1343, 172, 3, 70, "MoreAbout",
 CellID->31733911],
Cell[54678, 1348, 146, 3, 70, "MoreAbout",
 CellID->67156743],
Cell[54827, 1353, 152, 3, 70, "MoreAbout",
 CellID->57502065],
Cell[54982, 1358, 149, 3, 70, "MoreAbout",
 CellID->267083066],
Cell[55134, 1363, 122, 3, 70, "MoreAbout",
 CellID->611194968],
Cell[55259, 1368, 171, 3, 70, "MoreAbout",
 CellID->129830314],
Cell[55433, 1373, 155, 3, 70, "MoreAbout",
 CellID->443786392],
Cell[55591, 1378, 143, 3, 70, "MoreAbout",
 CellID->372898975],
Cell[55737, 1383, 153, 3, 70, "MoreAbout",
 CellID->15201656],
Cell[55893, 1388, 178, 3, 70, "MoreAbout",
 CellID->377179290],
Cell[56074, 1393, 154, 3, 70, "MoreAbout",
 CellID->44531129],
Cell[56231, 1398, 145, 3, 70, "MoreAbout",
 CellID->545702064],
Cell[56379, 1403, 153, 3, 70, "MoreAbout",
 CellID->62876589],
Cell[56535, 1408, 139, 3, 70, "MoreAbout",
 CellID->548843000],
Cell[56677, 1413, 149, 3, 70, "MoreAbout",
 CellID->113224511],
Cell[56829, 1418, 185, 3, 70, "MoreAbout",
 CellID->188931587],
Cell[57017, 1423, 193, 4, 70, "MoreAbout",
 CellID->656098447],
Cell[57213, 1429, 178, 3, 70, "MoreAbout",
 CellID->19378156]
}, Open  ]],
Cell[57406, 1435, 50, 0, 70, "History"],
Cell[57459, 1437, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

