(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7113,        236]
NotebookOptionsPosition[      5260,        179]
NotebookOutlinePosition[      6410,        210]
CellTagsIndexPosition[      6367,        207]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"InputAutoReplacements" :> 
         Documentation`HelpLookup["paclet:ref/InputAutoReplacements"], 
         "ExportAutoReplacements" :> 
         Documentation`HelpLookup["paclet:ref/ExportAutoReplacements"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"InputAutoReplacements\"\>", 
      2->"\<\"ExportAutoReplacements\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ImportAutoReplacements", "ObjectName",
 CellID->20809],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->178057385],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ImportAutoReplacements",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImportAutoReplacements"]], "InlineFormula"],
     "\[LineSeparator]is an option for cells that specifies which replacement \
rules ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " automatically applies when importing text."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7588]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The replacement rules to be applied are specified as a list, each element \
of which has the form ",
 Cell[BoxData[
  RowBox[{"\"\<\!\(\*
StyleBox[\"string1\", \"TI\"]\)\>\"", "->", "\"\<\!\(\*
StyleBox[\"string2\", \"TI\"]\)\>\""}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19774],

Cell["\<\
This option allows you to control the appearance of selected expressions or \
operators in a notebook. Some replacement rules that are usually set by \
default are as follows.\
\>", "Notes",
 CellID->31774],

Cell[TextData[{
 StyleBox["\"->\" \[Rule] \"", "MR"],
 StyleBox[ButtonBox["\[Backslash][Rule]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Rule"], "MR"],
 StyleBox["\"\n\":>\" \[Rule] \"", "MR"],
 StyleBox[ButtonBox["\[Backslash][RuleDelayed]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RuleDelayed"], "MR"],
 StyleBox["\"\n\"<=\" \[Rule] \"", "MR"],
 StyleBox[ButtonBox["\[Backslash][LessEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LessEqual"], "MR"],
 StyleBox["\"\n\">=\" \[Rule] \"", "MR"],
 StyleBox[ButtonBox["\[Backslash][GreaterEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/GreaterEqual"], "MR"],
 StyleBox["\"\n\"!=\" \[Rule] \"", "MR"],
 StyleBox[ButtonBox["\[Backslash][NotEqual]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/NotEqual"], "MR"],
 StyleBox["\"\n\"==\" \[Rule] \"", "MR"],
 StyleBox[ButtonBox["\[Backslash][Equal]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Equal"], "MR"],
 StyleBox["\"", "MR"]
}], "Notes",
 CellID->867]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29753],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputAutoReplacements",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputAutoReplacements"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExportAutoReplacements",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExportAutoReplacements"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30709]
}, Open  ]],

Cell["New in 4.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ImportAutoReplacements - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 26.1486674}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ImportAutoReplacements is an option for cells that specifies which \
replacement rules Mathematica automatically applies when importing text.", 
    "synonyms" -> {"import auto replacements"}, "title" -> 
    "ImportAutoReplacements", "type" -> "Symbol", "uri" -> 
    "ref/ImportAutoReplacements"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 753, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1376, 44, 60, 1, 70, "ObjectName",
 CellID->20809],
Cell[1439, 47, 218, 6, 70, "AwaitingReviewNote",
 CellID->178057385],
Cell[1660, 55, 583, 17, 70, "Usage",
 CellID->7588]
}, Open  ]],
Cell[CellGroupData[{
Cell[2280, 77, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2758, 94, 304, 9, 70, "Notes",
 CellID->19774],
Cell[3065, 105, 216, 5, 70, "Notes",
 CellID->31774],
Cell[3284, 112, 1046, 27, 70, "Notes",
 CellID->867]
}, Closed]],
Cell[CellGroupData[{
Cell[4367, 144, 311, 9, 70, "SeeAlsoSection",
 CellID->29753],
Cell[4681, 155, 505, 17, 70, "SeeAlso",
 CellID->30709]
}, Open  ]],
Cell[5201, 175, 29, 0, 70, "History"],
Cell[5233, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

