(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13285,        474]
NotebookOptionsPosition[     10141,        369]
NotebookOutlinePosition[     11422,        405]
CellTagsIndexPosition[     11337,        400]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using a Text\[Hyphen]Based Interface" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UsingATextBasedInterface"], 
          "Doing Computations in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DoingComputationsInNotebooks"], "The Main Loop" :> 
          Documentation`HelpLookup["paclet:tutorial/TheMainLoop"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Using a Text\[Hyphen]Based Interface\"\>", 
       2->"\<\"Doing Computations in Notebooks\"\>", 
       3->"\<\"The Main Loop\"\>", 
       4->"\<\"Mathematica Sessions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"In" :> Documentation`HelpLookup["paclet:ref/In"], 
          "$SyntaxHandler" :> 
          Documentation`HelpLookup["paclet:ref/$SyntaxHandler"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"In\"\>", 
       2->"\<\"$SyntaxHandler\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Session History" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionHistory"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathematica Session History\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InString", "ObjectName",
 CellID->6598],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InString"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a global object that is assigned to be the text of \
the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " input line. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17903]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InString"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " gives the string that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " read for the",
 " ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " ",
 "input line. The string includes all intermediate newlines in the input, but \
not the newline at the end. "
}], "Notes",
 CellID->29641],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InString"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " is assigned after the input is verified to be syntactically correct, and \
after any function given as the value of ",
 Cell[BoxData[
  ButtonBox["$PreRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
 " has been applied. "
}], "Notes",
 CellID->31787],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InString"], "[", "]"}]], "InlineFormula"],
 " gives the text of the last input line. "
}], "Notes",
 CellID->29286],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InString"], "[", 
   RowBox[{"-", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " gives the text of the input ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " lines back. "
}], "Notes",
 CellID->20994]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->255401092],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->112529467],

Cell["Show input as a string:", "ExampleText",
 CellID->30014090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", "1."}], ";", 
  RowBox[{"a", " ", "=", " ", 
   RowBox[{
    RowBox[{"a", "/", "2"}], "+", 
    RowBox[{"1", "/", "a"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->223269144],

Cell[BoxData["1.5`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121509280]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " input, the string represents a typeset expression:"
}], "ExampleText",
 CellID->177392681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InString", "[", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->369594586],

Cell[BoxData["\<\"\\\\(\\\\(a = 1.\\\\) ; \\\\(a = \\\\(\\\\(a/2\\\\) + \
\\\\(1/a\\\\)\\\\)\\\\)\\\\)\"\>"], "Output",
 ImageSize->{326, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->135960404]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14990],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$SyntaxHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$SyntaxHandler"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28189]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23288],

Cell[TextData[ButtonBox["Using a Text\[Hyphen]Based Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingATextBasedInterface"]], "Tutorials",
 CellID->18221],

Cell[TextData[ButtonBox["Doing Computations in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DoingComputationsInNotebooks"]], "Tutorials",
 CellID->15589],

Cell[TextData[ButtonBox["The Main Loop",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMainLoop"]], "Tutorials",
 CellID->1589],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "Tutorials",
 CellID->522604605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->288829224],

Cell[TextData[ButtonBox["Mathematica Session History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionHistory"]], "MoreAbout",
 CellID->533536541]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InString - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 8.3216220}", "context" -> "System`", 
    "keywords" -> {"input as string", "text of input", "input history"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InString[n] is a global object that is assigned to be the text of the \
n\\[Null]^th input line. ", "synonyms" -> {"in string"}, "title" -> 
    "InString", "type" -> "Symbol", "uri" -> "ref/InString"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5947, 201, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->255401092]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11194, 393}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2391, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3014, 85, 45, 1, 70, "ObjectName",
 CellID->6598],
Cell[3062, 88, 683, 22, 70, "Usage",
 CellID->17903]
}, Open  ]],
Cell[CellGroupData[{
Cell[3782, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4260, 132, 570, 21, 70, "Notes",
 CellID->29641],
Cell[4833, 155, 496, 16, 70, "Notes",
 CellID->31787],
Cell[5332, 173, 233, 8, 70, "Notes",
 CellID->29286],
Cell[5568, 183, 342, 13, 70, "Notes",
 CellID->20994]
}, Closed]],
Cell[CellGroupData[{
Cell[5947, 201, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->255401092],
Cell[CellGroupData[{
Cell[6332, 215, 148, 5, 70, "ExampleSection",
 CellID->112529467],
Cell[6483, 222, 65, 1, 70, "ExampleText",
 CellID->30014090],
Cell[CellGroupData[{
Cell[6573, 227, 223, 8, 28, "Input",
 CellID->223269144],
Cell[6799, 237, 161, 5, 36, "Output",
 CellID->121509280]
}, Open  ]],
Cell[6975, 245, 246, 8, 70, "ExampleText",
 CellID->177392681],
Cell[CellGroupData[{
Cell[7246, 257, 99, 3, 28, "Input",
 CellID->369594586],
Cell[7348, 262, 250, 6, 36, "Output",
 CellID->135960404]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7659, 275, 311, 9, 70, "SeeAlsoSection",
 CellID->14990],
Cell[7973, 286, 451, 17, 70, "SeeAlso",
 CellID->28189]
}, Open  ]],
Cell[CellGroupData[{
Cell[8461, 308, 314, 9, 70, "TutorialsSection",
 CellID->23288],
Cell[8778, 319, 171, 3, 70, "Tutorials",
 CellID->18221],
Cell[8952, 324, 170, 3, 70, "Tutorials",
 CellID->15589],
Cell[9125, 329, 134, 3, 70, "Tutorials",
 CellID->1589],
Cell[9262, 334, 284, 9, 70, "Tutorials",
 CellID->522604605]
}, Open  ]],
Cell[CellGroupData[{
Cell[9583, 348, 319, 9, 70, "MoreAboutSection",
 CellID->288829224],
Cell[9905, 359, 164, 3, 70, "MoreAbout",
 CellID->533536541]
}, Open  ]],
Cell[10084, 365, 27, 0, 70, "History"],
Cell[10114, 367, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

