(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22420,        886]
NotebookOptionsPosition[     16367,        672]
NotebookOutlinePosition[     17647,        709]
CellTagsIndexPosition[     17562,        704]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Forms of Assignment" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialFormsOfAssignment"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Special Forms of Assignment\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PreIncrement" :> 
          Documentation`HelpLookup["paclet:ref/PreIncrement"], "AddTo" :> 
          Documentation`HelpLookup["paclet:ref/AddTo"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PreIncrement\"\>", 2->"\<\"AddTo\"\>", 
       3->"\<\"Set\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Procedural Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Increment ",
 StyleBox["(++)", "OperatorCharacter"]
}], "ObjectName",
 CellID->32667],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "++"}]], "InlineFormula"],
     "\[LineSeparator]increases the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " by 1, returning the old value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25198]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Increment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Increment"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7357]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->154768632],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->536746837],

Cell["Increment the value by one, and return the old value:", "ExampleText",
 CellID->234082894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", "1"}], ";", 
  RowBox[{"k", "++"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->570760497],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81362417]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["k"], "Input",
 CellLabel->"In[2]:=",
 CellID->286656288],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->192285276]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10742],

Cell["Increment a numerical value:", "ExampleText",
 CellID->1113876286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "1.5"}], ";", " ", 
  RowBox[{"x", "++"}], ";", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1774324750],

Cell[BoxData["2.5`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->784304806]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206580424],

Cell["Increment a symbolic value:", "ExampleText",
 CellID->838884225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", "a"}], ";", 
  RowBox[{"v", "++"}], ";", "v"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1698859122],

Cell[BoxData[
 RowBox[{"1", "+", "a"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46737067]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2063940682],

Cell["Increment all values in a list:", "ExampleText",
 CellID->822015323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2332824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->842664567]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "++"}], ";", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1729906436],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1495203530]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->169568066],

Cell["Find the first integer with a certain property:", "ExampleText",
 CellID->2078680352],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"i", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Prime", "[", "i", "]"}], "<", 
     RowBox[{"10", "^", "6"}]}], ",", 
    RowBox[{"i", "++"}]}], "]"}], ";"}], "\n", "i"}], "Input",
 CellLabel->"In[1]:=",
 CellID->84768696],

Cell[BoxData["78499"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2057014827]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22215],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Increment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Increment"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PreIncrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreIncrement"]], "InlineFormula"],
 " differ only in the return value of the operation:"
}], "ExampleText",
 CellID->440092738],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->550656451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "++"}], ",", 
   RowBox[{"++", "b"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->532828009],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->465619533]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->195309579],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->320585950]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->300188328],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Increment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Increment"]], "InlineFormula"],
 " is a short form of this assignment:"
}], "ExampleText",
 CellID->2065810971],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\n", 
 RowBox[{"k", "=", 
  RowBox[{"k", "+", "1"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1887499219],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1736880614]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->607562233],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Increment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Increment"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["AddTo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AddTo"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1728269985],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\n", 
 RowBox[{"k", "+=", "1"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->683214900],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1283532592]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->224632663],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Decrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decrement"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PreDecrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreDecrement"]], "InlineFormula"],
 " are closely related operations:"
}], "ExampleText",
 CellID->73150939],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->634282679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "++"}], ",", 
   RowBox[{"++", "b"}], ",", 
   RowBox[{"c", "--"}], ",", 
   RowBox[{"--", "d"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->463191000],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "1", ",", "0"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177942332]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->95912239],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->96917032]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6213],

Cell["A variable to be incremented must have an initial value:", "ExampleText",
 CellID->992262862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "++"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1397421414],

Cell[BoxData[
 RowBox[{
  RowBox[{"Increment", "::", "\<\"rvalue\"\>"}], ":", 
  " ", "\<\"\\!\\(x\\) is not a variable with a value, so its value cannot be \
changed. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\
\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/rvalue\\\", \
ButtonNote -> \\\"Increment::rvalue\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->678308786],

Cell[BoxData[
 RowBox[{"x", "++"}]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2039298759]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31600],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PreIncrement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PreIncrement"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AddTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AddTo"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1491]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3241],

Cell[TextData[ButtonBox["Special Forms of Assignment",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFormsOfAssignment"]], "Tutorials",
 CellID->19150]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->423218654],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->316243739]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Increment (++) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 31.2894240}", "context" -> "System`", 
    "keywords" -> {
     "implicit assignment ", "implicit set", "increment", "post-increment"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "x++ increases the value of x by 1, returning the old value of x. ", 
    "synonyms" -> {"++"}, "title" -> "Increment", "type" -> "Symbol", "uri" -> 
    "ref/Increment"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4090, 139, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->154768632]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17419, 697}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1954, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2577, 76, 103, 4, 70, "ObjectName",
 CellID->32667],
Cell[2683, 82, 544, 18, 70, "Usage",
 CellID->25198]
}, Open  ]],
Cell[CellGroupData[{
Cell[3264, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3742, 122, 311, 12, 70, "Notes",
 CellID->7357]
}, Closed]],
Cell[CellGroupData[{
Cell[4090, 139, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->154768632],
Cell[CellGroupData[{
Cell[4475, 153, 148, 5, 70, "ExampleSection",
 CellID->536746837],
Cell[4626, 160, 96, 1, 70, "ExampleText",
 CellID->234082894],
Cell[CellGroupData[{
Cell[4747, 165, 134, 5, 28, "Input",
 CellID->570760497],
Cell[4884, 172, 157, 5, 36, "Output",
 CellID->81362417]
}, Open  ]],
Cell[CellGroupData[{
Cell[5078, 182, 70, 2, 28, "Input",
 CellID->286656288],
Cell[5151, 186, 158, 5, 36, "Output",
 CellID->192285276]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5358, 197, 216, 7, 70, "ExampleSection",
 CellID->10742],
Cell[5577, 206, 72, 1, 70, "ExampleText",
 CellID->1113876286],
Cell[CellGroupData[{
Cell[5674, 211, 152, 5, 70, "Input",
 CellID->1774324750],
Cell[5829, 218, 161, 5, 36, "Output",
 CellID->784304806]
}, Open  ]],
Cell[6005, 226, 125, 3, 70, "ExampleDelimiter",
 CellID->206580424],
Cell[6133, 231, 70, 1, 70, "ExampleText",
 CellID->838884225],
Cell[CellGroupData[{
Cell[6228, 236, 145, 5, 70, "Input",
 CellID->1698859122],
Cell[6376, 243, 179, 6, 36, "Output",
 CellID->46737067]
}, Open  ]],
Cell[6570, 252, 126, 3, 70, "ExampleDelimiter",
 CellID->2063940682],
Cell[6699, 257, 74, 1, 70, "ExampleText",
 CellID->822015323],
Cell[CellGroupData[{
Cell[6798, 262, 147, 5, 70, "Input",
 CellID->2332824],
Cell[6948, 269, 213, 7, 36, "Output",
 CellID->842664567]
}, Open  ]],
Cell[CellGroupData[{
Cell[7198, 281, 112, 4, 70, "Input",
 CellID->1729906436],
Cell[7313, 287, 214, 7, 36, "Output",
 CellID->1495203530]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7576, 300, 227, 7, 70, "ExampleSection",
 CellID->169568066],
Cell[7806, 309, 91, 1, 70, "ExampleText",
 CellID->2078680352],
Cell[CellGroupData[{
Cell[7922, 314, 314, 11, 70, "Input",
 CellID->84768696],
Cell[8239, 327, 163, 5, 36, "Output",
 CellID->2057014827]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8451, 338, 233, 7, 70, "ExampleSection",
 CellID->22215],
Cell[8687, 347, 366, 12, 70, "ExampleText",
 CellID->440092738],
Cell[9056, 361, 208, 8, 70, "Input",
 CellID->550656451],
Cell[CellGroupData[{
Cell[9289, 373, 155, 6, 70, "Input",
 CellID->532828009],
Cell[9447, 381, 203, 7, 36, "Output",
 CellID->465619533]
}, Open  ]],
Cell[CellGroupData[{
Cell[9687, 393, 115, 4, 70, "Input",
 CellID->195309579],
Cell[9805, 399, 203, 7, 36, "Output",
 CellID->320585950]
}, Open  ]],
Cell[10023, 409, 125, 3, 70, "ExampleDelimiter",
 CellID->300188328],
Cell[10151, 414, 216, 7, 70, "ExampleText",
 CellID->2065810971],
Cell[CellGroupData[{
Cell[10392, 425, 169, 6, 70, "Input",
 CellID->1887499219],
Cell[10564, 433, 159, 5, 36, "Output",
 CellID->1736880614]
}, Open  ]],
Cell[10738, 441, 125, 3, 70, "ExampleDelimiter",
 CellID->607562233],
Cell[10866, 446, 321, 12, 70, "ExampleText",
 CellID->1728269985],
Cell[CellGroupData[{
Cell[11212, 462, 146, 5, 70, "Input",
 CellID->683214900],
Cell[11361, 469, 159, 5, 36, "Output",
 CellID->1283532592]
}, Open  ]],
Cell[11535, 477, 125, 3, 70, "ExampleDelimiter",
 CellID->224632663],
Cell[11663, 482, 347, 12, 70, "ExampleText",
 CellID->73150939],
Cell[12013, 496, 248, 8, 70, "Input",
 CellID->634282679],
Cell[CellGroupData[{
Cell[12286, 508, 215, 8, 70, "Input",
 CellID->463191000],
Cell[12504, 518, 223, 7, 36, "Output",
 CellID->177942332]
}, Open  ]],
Cell[CellGroupData[{
Cell[12764, 530, 134, 4, 70, "Input",
 CellID->95912239],
Cell[12901, 536, 222, 7, 36, "Output",
 CellID->96917032]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13172, 549, 225, 7, 70, "ExampleSection",
 CellID->6213],
Cell[13400, 558, 99, 1, 70, "ExampleText",
 CellID->992262862],
Cell[CellGroupData[{
Cell[13524, 563, 89, 3, 70, "Input",
 CellID->1397421414],
Cell[13616, 568, 408, 7, 70, "Message",
 CellID->678308786],
Cell[14027, 577, 177, 6, 36, "Output",
 CellID->2039298759]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14265, 590, 311, 9, 70, "SeeAlsoSection",
 CellID->31600],
Cell[14579, 601, 687, 26, 70, "SeeAlso",
 CellID->1491]
}, Open  ]],
Cell[CellGroupData[{
Cell[15303, 632, 313, 9, 70, "TutorialsSection",
 CellID->3241],
Cell[15619, 643, 162, 3, 70, "Tutorials",
 CellID->19150]
}, Open  ]],
Cell[CellGroupData[{
Cell[15818, 651, 319, 9, 70, "MoreAboutSection",
 CellID->423218654],
Cell[16140, 662, 155, 3, 70, "MoreAbout",
 CellID->316243739]
}, Open  ]],
Cell[16310, 668, 27, 0, 70, "History"],
Cell[16340, 670, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

