(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47931,       1749]
NotebookOptionsPosition[     38087,       1396]
NotebookOutlinePosition[     39369,       1433]
CellTagsIndexPosition[     39283,       1428]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Levels in Expressions" :> 
          Documentation`HelpLookup["paclet:tutorial/LevelsInExpressions"], 
          "Indeterminate and Infinite Results" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IndeterminateAndInfiniteResults"], 
          "Mathematical Constants" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalConstants"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Levels in Expressions\"\>", 
       3->"\<\"Indeterminate and Infinite Results\"\>", 
       4->"\<\"Mathematical Constants\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ComplexInfinity" :> 
          Documentation`HelpLookup["paclet:ref/ComplexInfinity"], 
          "Indeterminate" :> 
          Documentation`HelpLookup["paclet:ref/Indeterminate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ComplexInfinity\"\>", 
       2->"\<\"Indeterminate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Characters" :> 
          Documentation`HelpLookup["paclet:guide/SpecialCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Infinity", "ObjectName",
 CellID->10778],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
     "\[LineSeparator]is a symbol that represents a positive infinite \
quantity. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14781]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 " can be entered as ",
 Cell[TextData[ButtonBox["\\[Infinity]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Infinity"]], "InlineCharacterName"],
 " or ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]inf\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ". "
}], "Notes",
 CellID->20334],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " is printed as ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->5051],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " is converted to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"], "[", "1", "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->32040],

Cell[TextData[{
 "Certain arithmetic operations work with ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2710],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"], "[", "Infinity", "]"}]], 
  "InlineFormula"],
 " yields ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32538]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->226013454],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->580836945],

Cell["Use as iterator limit:", "ExampleText",
 CellID->390445370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"n", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25628],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "2"], "6"]], "Output",
 ImageSize->{22, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->276596527]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17786],

Cell["Do arithmetic with infinite quantities:", "ExampleText",
 CellID->377802644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", "Infinity"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8373],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160544242]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16981],

Cell[TextData[{
 "Use \[EscapeKey]inf\[EscapeKey] to enter ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->130525081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115277459],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->307129802]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->411077002],

Cell["Series expansion at \[Infinity]:", "ExampleText",
 CellID->304880450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->254426321],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", "x"], ")"}], "2"], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", "x"], ")"}], "3"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", "x"], ")"}], "5"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "x"], "]"}], "6"],
    SeriesData[$CellContext`x, 
     DirectedInfinity[1], {}, 2, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   DirectedInfinity[1], {1, -1, 0, 1}, 2, 6, 1],
  Editable->False]], "Output",
 ImageSize->{172, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4513814]
}, Open  ]],

Cell["Infinite limits of integration and summation:", "ExampleText",
 CellID->261590317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7114351],

Cell[BoxData[
 SqrtBox["\[Pi]"]], "Output",
 ImageSize->{29, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2525163]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", "4"}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", "1"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->62843912],

Cell[BoxData["2.3140184714800416`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->609694080]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"n", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->377352791],

Cell[BoxData[
 RowBox[{"EllipticTheta", "[", 
  RowBox[{"3", ",", "0", ",", 
   FractionBox["1", "\[ExponentialE]"]}], "]"}]], "Output",
 ImageSize->{157, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->77450752]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSum", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"n", "^", "4"}]}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"n", "^", "2"}], "+", "1"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->93264665],

Cell[BoxData["2.2951933825849773`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->84780112]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->489354476],

Cell["Extended arithmetic with infinite quantities:", "ExampleText",
 CellID->701551511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Infinity", " ", "Infinity"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168052378],

Cell[BoxData["\[Infinity]"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->457191815]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "Infinity"}], "-", "Infinity"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->165036801],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(\\(\\(-\[Infinity]\\)\\) + \
\[Infinity]\\) encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->225739536],

Cell[BoxData["Indeterminate"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->424321475]
}, Open  ]],

Cell["\<\
In this case the result depends on the growth rates of the two terms:\
\>", "ExampleText",
 CellID->209129375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "t"}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "+", "1"}], ")"}]}], ",", 
   RowBox[{"t", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->772619823],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->227830774]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "t"}], "-", 
    RowBox[{"(", 
     RowBox[{"t", "+", "1"}], ")"}]}], ",", 
   RowBox[{"t", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->223162989],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->466363642]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143283420],

Cell["Use infinite quantities in predicates:", "ExampleText",
 CellID->66297710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"10", "^", "100"}], "<", "Infinity"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157588880],

Cell[BoxData["True"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168828697]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->183367527],

Cell["Find values of mathematical functions at infinities:", "ExampleText",
 CellID->38189092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"-", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->283149415],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->320567560]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->653446464],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->77854669]
}, Open  ]],

Cell["\<\
For some functions there is no definite limit, but a limiting interval:\
\>", "ExampleText",
 CellID->913913263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15387442],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->457948067]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->47406793],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], 
  "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->336302729]
}, Open  ]],

Cell["In this case no limiting interval exists:", "ExampleText",
 CellID->56174958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exp", "[", 
  RowBox[{"I", " ", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->353389144],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \
\\!\\(\[ExponentialE]\\^\\*TagBox[\\(\\*TagBox[\\\"\[ImaginaryI]\\\", \
\\\"DirectedInfinityCoefficient\\\", Rule[Editable, True]]\\\\ \
\[Infinity]\\), DirectedInfinity, Rule[Editable, False]]\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/indet\\\", \
ButtonNote -> \\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->1010163831],

Cell[BoxData["Indeterminate"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->256881824]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->589936267],

Cell["\<\
Mathematical functions can also return infinite quantities at finite points:\
\>", "ExampleText",
 CellID->354943076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30319830],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->322487326]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gamma", "[", "0", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->134374207],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->352483887]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->89028684],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cases"]], "InlineFormula"],
 " finds matches only at the first level by default:"
}], "ExampleText",
 CellID->550282479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "=", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Gamma", "[", "x", "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], 
    RowBox[{"Gamma", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "1"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152155383],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", 
   RowBox[{"Gamma", "[", "x", "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 ImageSize->{208, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->469637661]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"e", ",", "_Gamma"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->261375648],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->76446832]
}, Open  ]],

Cell[TextData[{
 "Set the level to ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " to include all levels:"
}], "ExampleText",
 CellID->62920026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"e", ",", "_Gamma", ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->249976076],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Gamma", "[", "x", "]"}], ",", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}], "}"}]], "Output",
 ImageSize->{167, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->56281859]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13394],

Cell["Stirling's asymptotic approximation:", "ExampleText",
 CellID->35071895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"n", "!"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150752983],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"Log", "[", 
        FractionBox["1", "n"], "]"}]}], 
      FractionBox["1", "n"]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "n"], "]"}], "3"],
      SeriesData[$CellContext`n, 
       DirectedInfinity[1], {}, -1, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`n, 
     DirectedInfinity[1], {-1 - Log[$CellContext`n^(-1)]}, -1, 3, 1],
    Editable->False]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"2", " ", "\[Pi]"}]], 
      SqrtBox[
       FractionBox["1", "n"]]], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SqrtBox[
       FractionBox["\[Pi]", "2"]], " ", 
      SqrtBox[
       FractionBox["1", "n"]]}], "+", 
     RowBox[{
      FractionBox["1", "144"], " ", 
      SqrtBox[
       FractionBox["\[Pi]", "2"]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "n"], ")"}], 
       RowBox[{"3", "/", "2"}]]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "n"], "]"}], 
       RowBox[{"5", "/", "2"}]],
      SeriesData[$CellContext`n, 
       DirectedInfinity[1], {}, -1, 5, 2],
      Editable->False]}],
    SeriesData[$CellContext`n, 
     DirectedInfinity[
     1], {(2 Pi)^Rational[1, 2], 0, 
      Rational[1, 6] (Rational[1, 2] Pi)^Rational[1, 2], 0, 
      Rational[1, 144] (Rational[1, 2] Pi)^Rational[1, 2]}, -1, 5, 2],
    Editable->False], ")"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{422, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236843427]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11060273],

Cell[TextData[{
 "Setting the precision to ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " will produce a rational approximation:"
}], "ExampleText",
 CellID->138650463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{"3.14", ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->649589075],

Cell[BoxData[
 FractionBox["7070651414971679", "2251799813685248"]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{131, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->961132781]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->105635719],

Cell[BoxData["3.14`"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->403344664]
}, Open  ]],

Cell["Some functions require infinite precision or exact input:", \
"ExampleText",
 CellID->73538741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "^", "2"}], "+", 
     RowBox[{"2.5", " ", 
      RowBox[{"x", "^", "2"}]}]}], "<", "1.5"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->229530547],

Cell[BoxData[
 RowBox[{
  RowBox[{"CylindricalDecomposition", "::", "\<\"nrtpi\"\>"}], ":", 
  " ", "\<\"\\!\\(\\(\\(\\(\\(2.5`\\\\ x\\^2\\)\\) + y\\^2\\)\\) < 1.5`\\) is \
not a logical formula consisting of polynomial equations and inequalities in \
\\!\\({x, y}\\) with rational number coefficients. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/CylindricalDecomposition/nrtpi\\\", \
ButtonNote -> \\\"CylindricalDecomposition::nrtpi\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->359343001],

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2.5`", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     SuperscriptBox["y", "2"]}], "<", "1.5`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Output",
 ImageSize->{333, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->132151942]
}, Open  ]],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["SetPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetPrecision"]], "InlineFormula"],
 " to the whole expression to rationalize all inexact numbers:"
}], "ExampleText",
 CellID->374999629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{"SetPrecision", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"2.5", " ", 
        RowBox[{"x", "^", "2"}]}]}], "<", "1.5"}], ",", "Infinity"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5132394],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     FractionBox["3", "5"]]}], "<", "x", "<", 
   SqrtBox[
    FractionBox["3", "5"]]}], "&&", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SqrtBox[
      RowBox[{"3", "-", 
       RowBox[{"5", " ", 
        SuperscriptBox["x", "2"]}]}]], 
     SqrtBox["2"]]}], "<", "y", "<", 
   FractionBox[
    SqrtBox[
     RowBox[{"3", "-", 
      RowBox[{"5", " ", 
       SuperscriptBox["x", "2"]}]}]], 
    SqrtBox["2"]]}]}]], "Output",
 ImageSize->{302, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->57400905]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28552],

Cell[TextData[{
 "Use an infinite ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->646584957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "x"}], "+", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "->", "Infinity"}], ",", " ", 
    RowBox[{"EvaluationMonitor", " ", ":>", " ", 
     RowBox[{"Sow", "[", "x", "]"}]}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "3"}], ",", 
    RowBox[{"MaxRecursion", "\[Rule]", "0"}]}], " ", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114150040],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{5.*^-7, 1.000001}, {0.4809021994374947, 
       1.9618043988749894`}, {0.9999995, 2.999999}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 1.},
    PlotRange->{{0, 1}, {1.000001, 2.999999}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["4722366482869645", "9444732965739290427392"], ",", 
      FractionBox["2165790966188353", "4503599627370496"], ",", 
      FractionBox["9007194751141365", "9007199254740992"]}], "}"}], "}"}]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{495, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152124448]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Numerator", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "->", "Infinity"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "1000"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "0"}]}], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->534321981],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->309835531]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3621],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexInfinity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Indeterminate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Indeterminate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11088]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7507],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->6349],

Cell[TextData[ButtonBox["Levels in Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LevelsInExpressions"]], "Tutorials",
 CellID->1951],

Cell[TextData[ButtonBox["Indeterminate and Infinite Results",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IndeterminateAndInfiniteResults"]], "Tutorials",\

 CellID->11350],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathematicalConstants"]], "Tutorials",
 CellID->27606]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->24795],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Infinity.html"], 
   None}], "IT"]], "RelatedLinks",
 CellID->632339716],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Constants/Infinity/"], 
   None}]], "RelatedLinks",
 CellID->222950970]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->55960847],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialCharacters"]], "MoreAbout",
 CellID->32506979]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Infinity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 36.2114250}", "context" -> "System`", 
    "keywords" -> {
     "directed infinity", "directional infinity", "infinite", "infinity"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Infinity or \\[Infinity] is a symbol that represents a positive infinite \
quantity. ", "synonyms" -> {}, "title" -> "Infinity", "type" -> "Symbol", 
    "uri" -> "ref/Infinity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5930, 206, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->226013454]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39140, 1421}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2437, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3060, 86, 46, 1, 70, "ObjectName",
 CellID->10778],
Cell[3109, 89, 538, 17, 70, "Usage",
 CellID->14781]
}, Open  ]],
Cell[CellGroupData[{
Cell[3684, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4162, 128, 408, 13, 70, "Notes",
 CellID->20334],
Cell[4573, 143, 404, 16, 70, "Notes",
 CellID->5051],
Cell[4980, 161, 360, 14, 70, "Notes",
 CellID->32040],
Cell[5343, 177, 213, 8, 70, "Notes",
 CellID->2710],
Cell[5559, 187, 334, 14, 70, "Notes",
 CellID->32538]
}, Closed]],
Cell[CellGroupData[{
Cell[5930, 206, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->226013454],
Cell[CellGroupData[{
Cell[6315, 220, 148, 5, 70, "ExampleSection",
 CellID->580836945],
Cell[6466, 227, 65, 1, 70, "ExampleText",
 CellID->390445370],
Cell[CellGroupData[{
Cell[6556, 232, 223, 8, 28, "Input",
 CellID->25628],
Cell[6782, 242, 206, 7, 54, "Output",
 CellID->276596527]
}, Open  ]],
Cell[7003, 252, 121, 3, 70, "ExampleDelimiter",
 CellID->17786],
Cell[7127, 257, 82, 1, 70, "ExampleText",
 CellID->377802644],
Cell[CellGroupData[{
Cell[7234, 262, 94, 3, 70, "Input",
 CellID->8373],
Cell[7331, 267, 158, 5, 36, "Output",
 CellID->160544242]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7538, 278, 216, 7, 70, "ExampleSection",
 CellID->16981],
Cell[7757, 287, 179, 6, 70, "ExampleText",
 CellID->130525081],
Cell[CellGroupData[{
Cell[7961, 297, 188, 6, 70, "Input",
 CellID->115277459],
Cell[8152, 305, 158, 5, 36, "Output",
 CellID->307129802]
}, Open  ]],
Cell[8325, 313, 125, 3, 70, "ExampleDelimiter",
 CellID->411077002],
Cell[8453, 318, 75, 1, 70, "ExampleText",
 CellID->304880450],
Cell[CellGroupData[{
Cell[8553, 323, 303, 10, 70, "Input",
 CellID->254426321],
Cell[8859, 335, 739, 26, 52, "Output",
 CellID->4513814]
}, Open  ]],
Cell[9613, 364, 88, 1, 70, "ExampleText",
 CellID->261590317],
Cell[CellGroupData[{
Cell[9726, 369, 297, 10, 70, "Input",
 CellID->7114351],
Cell[10026, 381, 171, 6, 38, "Output",
 CellID->2525163]
}, Open  ]],
Cell[CellGroupData[{
Cell[10234, 392, 407, 14, 70, "Input",
 CellID->62843912],
Cell[10644, 408, 176, 5, 36, "Output",
 CellID->609694080]
}, Open  ]],
Cell[CellGroupData[{
Cell[10857, 418, 293, 10, 70, "Input",
 CellID->377352791],
Cell[11153, 430, 266, 8, 51, "Output",
 CellID->77450752]
}, Open  ]],
Cell[CellGroupData[{
Cell[11456, 443, 401, 14, 70, "Input",
 CellID->93264665],
Cell[11860, 459, 175, 5, 36, "Output",
 CellID->84780112]
}, Open  ]],
Cell[12050, 467, 125, 3, 70, "ExampleDelimiter",
 CellID->489354476],
Cell[12178, 472, 88, 1, 70, "ExampleText",
 CellID->701551511],
Cell[CellGroupData[{
Cell[12291, 477, 106, 3, 70, "Input",
 CellID->168052378],
Cell[12400, 482, 216, 7, 36, "Output",
 CellID->457191815]
}, Open  ]],
Cell[CellGroupData[{
Cell[12653, 494, 129, 4, 70, "Input",
 CellID->165036801],
Cell[12785, 500, 419, 8, 70, "Message",
 CellID->225739536],
Cell[13207, 510, 218, 7, 36, "Output",
 CellID->424321475]
}, Open  ]],
Cell[13440, 520, 120, 3, 70, "ExampleText",
 CellID->209129375],
Cell[CellGroupData[{
Cell[13585, 527, 283, 10, 70, "Input",
 CellID->772619823],
Cell[13871, 539, 185, 6, 36, "Output",
 CellID->227830774]
}, Open  ]],
Cell[CellGroupData[{
Cell[14093, 550, 256, 9, 70, "Input",
 CellID->223162989],
Cell[14352, 561, 168, 5, 36, "Output",
 CellID->466363642]
}, Open  ]],
Cell[14535, 569, 125, 3, 70, "ExampleDelimiter",
 CellID->143283420],
Cell[14663, 574, 80, 1, 70, "ExampleText",
 CellID->66297710],
Cell[CellGroupData[{
Cell[14768, 579, 125, 4, 70, "Input",
 CellID->157588880],
Cell[14896, 585, 209, 7, 36, "Output",
 CellID->168828697]
}, Open  ]],
Cell[15120, 595, 125, 3, 70, "ExampleDelimiter",
 CellID->183367527],
Cell[15248, 600, 94, 1, 70, "ExampleText",
 CellID->38189092],
Cell[CellGroupData[{
Cell[15367, 605, 124, 4, 70, "Input",
 CellID->283149415],
Cell[15494, 611, 158, 5, 36, "Output",
 CellID->320567560]
}, Open  ]],
Cell[CellGroupData[{
Cell[15689, 621, 106, 3, 70, "Input",
 CellID->653446464],
Cell[15798, 626, 167, 5, 36, "Output",
 CellID->77854669]
}, Open  ]],
Cell[15980, 634, 122, 3, 70, "ExampleText",
 CellID->913913263],
Cell[CellGroupData[{
Cell[16127, 641, 105, 3, 70, "Input",
 CellID->15387442],
Cell[16235, 646, 308, 11, 36, "Output",
 CellID->457948067]
}, Open  ]],
Cell[CellGroupData[{
Cell[16580, 662, 105, 3, 70, "Input",
 CellID->47406793],
Cell[16688, 667, 331, 12, 36, "Output",
 CellID->336302729]
}, Open  ]],
Cell[17034, 682, 83, 1, 70, "ExampleText",
 CellID->56174958],
Cell[CellGroupData[{
Cell[17142, 687, 129, 4, 70, "Input",
 CellID->353389144],
Cell[17274, 693, 569, 10, 70, "Message",
 CellID->1010163831],
Cell[17846, 705, 218, 7, 36, "Output",
 CellID->256881824]
}, Open  ]],
Cell[18079, 715, 125, 3, 70, "ExampleDelimiter",
 CellID->589936267],
Cell[18207, 720, 127, 3, 70, "ExampleText",
 CellID->354943076],
Cell[CellGroupData[{
Cell[18359, 727, 98, 3, 70, "Input",
 CellID->30319830],
Cell[18460, 732, 185, 6, 36, "Output",
 CellID->322487326]
}, Open  ]],
Cell[CellGroupData[{
Cell[18682, 743, 101, 3, 70, "Input",
 CellID->134374207],
Cell[18786, 748, 173, 5, 36, "Output",
 CellID->352483887]
}, Open  ]],
Cell[18974, 756, 124, 3, 70, "ExampleDelimiter",
 CellID->89028684],
Cell[19101, 761, 221, 7, 70, "ExampleText",
 CellID->550282479],
Cell[CellGroupData[{
Cell[19347, 772, 330, 12, 70, "Input",
 CellID->152155383],
Cell[19680, 786, 394, 14, 39, "Output",
 CellID->469637661]
}, Open  ]],
Cell[CellGroupData[{
Cell[20111, 805, 129, 4, 70, "Input",
 CellID->261375648],
Cell[20243, 811, 174, 6, 36, "Output",
 CellID->76446832]
}, Open  ]],
Cell[20432, 820, 221, 8, 70, "ExampleText",
 CellID->62920026],
Cell[CellGroupData[{
Cell[20678, 832, 146, 4, 70, "Input",
 CellID->249976076],
Cell[20827, 838, 321, 11, 39, "Output",
 CellID->56281859]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21197, 855, 223, 7, 70, "ExampleSection",
 CellID->13394],
Cell[21423, 864, 78, 1, 70, "ExampleText",
 CellID->35071895],
Cell[CellGroupData[{
Cell[21526, 869, 210, 7, 70, "Input",
 CellID->150752983],
Cell[21739, 878, 1872, 63, 100, "Output",
 CellID->236843427]
}, Open  ]],
Cell[23626, 944, 124, 3, 70, "ExampleDelimiter",
 CellID->11060273],
Cell[23753, 949, 246, 8, 70, "ExampleText",
 CellID->138650463],
Cell[CellGroupData[{
Cell[24024, 961, 141, 4, 70, "Input",
 CellID->649589075],
Cell[24168, 967, 257, 8, 51, "Output",
 CellID->961132781]
}, Open  ]],
Cell[CellGroupData[{
Cell[24462, 980, 97, 3, 70, "Input",
 CellID->105635719],
Cell[24562, 985, 210, 7, 36, "Output",
 CellID->403344664]
}, Open  ]],
Cell[24787, 995, 101, 2, 70, "ExampleText",
 CellID->73538741],
Cell[CellGroupData[{
Cell[24913, 1001, 324, 11, 70, "Input",
 CellID->229530547],
Cell[25240, 1014, 577, 10, 70, "Message",
 CellID->359343001],
Cell[25820, 1026, 417, 14, 39, "Output",
 CellID->132151942]
}, Open  ]],
Cell[26252, 1043, 256, 8, 70, "ExampleText",
 CellID->374999629],
Cell[CellGroupData[{
Cell[26533, 1055, 408, 14, 70, "Input",
 CellID->5132394],
Cell[26944, 1071, 629, 26, 65, "Output",
 CellID->57400905]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27622, 1103, 224, 7, 70, "ExampleSection",
 CellID->28552],
Cell[27849, 1112, 335, 13, 70, "ExampleText",
 CellID->646584957],
Cell[CellGroupData[{
Cell[28209, 1129, 527, 14, 70, "Input",
 CellID->114150040],
Cell[28739, 1145, 921, 28, 176, "Output",
 CellID->152124448]
}, Open  ]],
Cell[CellGroupData[{
Cell[29697, 1178, 385, 10, 70, "Input",
 CellID->534321981],
Cell[30085, 1190, 4775, 82, 70, "Output",
 Evaluatable->False,
 CellID->309835531]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34921, 1279, 310, 9, 70, "SeeAlsoSection",
 CellID->3621],
Cell[35234, 1290, 475, 17, 70, "SeeAlso",
 CellID->11088]
}, Open  ]],
Cell[CellGroupData[{
Cell[35746, 1312, 313, 9, 70, "TutorialsSection",
 CellID->7507],
Cell[36062, 1323, 162, 3, 70, "Tutorials",
 CellID->6349],
Cell[36227, 1328, 150, 3, 70, "Tutorials",
 CellID->1951],
Cell[36380, 1333, 178, 4, 70, "Tutorials",
 CellID->11350],
Cell[36561, 1339, 154, 3, 70, "Tutorials",
 CellID->27606]
}, Open  ]],
Cell[CellGroupData[{
Cell[36752, 1347, 321, 9, 70, "RelatedLinksSection",
 CellID->24795],
Cell[37076, 1358, 199, 5, 70, "RelatedLinks",
 CellID->632339716],
Cell[37278, 1365, 210, 5, 70, "RelatedLinks",
 CellID->222950970]
}, Open  ]],
Cell[CellGroupData[{
Cell[37525, 1375, 318, 9, 70, "MoreAboutSection",
 CellID->55960847],
Cell[37846, 1386, 146, 3, 70, "MoreAbout",
 CellID->32506979]
}, Open  ]],
Cell[38007, 1392, 50, 0, 70, "History"],
Cell[38060, 1394, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

