(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15904,        539]
NotebookOptionsPosition[     13006,        444]
NotebookOutlinePosition[     14307,        481]
CellTagsIndexPosition[     14222,        476]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Defining Output Formats" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DefiningOutputFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Defining Output Formats\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Postfix" :> Documentation`HelpLookup["paclet:ref/Postfix"], 
          "Prefix" :> Documentation`HelpLookup["paclet:ref/Prefix"], 
          "PrecedenceForm" :> 
          Documentation`HelpLookup["paclet:ref/PrecedenceForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Postfix\"\>", 2->"\<\"Prefix\"\>", 
       3->"\<\"PrecedenceForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Defining Custom Notation" :> 
          Documentation`HelpLookup["paclet:guide/DefiningCustomNotation"], 
          "Symbolic Notational Forms" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicNotationalForms"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Defining Custom Notation\"\>", 
       2->"\<\"Symbolic Notational Forms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Infix", "ObjectName",
 CellID->12953],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Infix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Infix"], "[", 
       RowBox[{
        StyleBox["f", "TI"], "[", 
        RowBox[{
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["e", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " given in default infix form: ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], "~", 
        StyleBox["f", "TI"], "~", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]], "~", 
        StyleBox["f", "TI"], "~", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["3", "TR"]]}], 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Infix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Infix"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with arguments separated by ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     ": ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["1", "TR"]], " ", 
       StyleBox["h", "TI"], " ", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["2", "TR"]], " ", 
       StyleBox["h", "TI"], " ", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["3", "TR"]], 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->12059]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Infix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infix"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["h", "TI"], ",", 
    StyleBox["precedence", "TI"], ",", 
    StyleBox["grouping", "TI"]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " can be used to specify how the output form should be parenthesized. "
}], "Notes",
 CellID->26368],

Cell[TextData[{
 "Precedence levels are specified by integers. In ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ", some precedence levels are: "
}], "Notes",
 CellID->31041],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["x", "TI"], ".", 
     StyleBox["y", "TI"], ".", 
     StyleBox["z", "TI"]}], Cell[TextData[Cell[BoxData[
    "490"], "InlineFormula"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["x", "TI"], " ", 
     StyleBox["y", "TI"], " ", 
     StyleBox["z", "TI"]}], Cell[TextData[Cell[BoxData[
    "400"], "InlineFormula"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["x", "TI"], "+", 
     StyleBox["y", "TI"], "+", 
     StyleBox["z", "TI"]}], Cell[TextData[Cell[BoxData[
    "310"], "InlineFormula"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["x", "TI"], "==", 
     StyleBox["y", "TI"]}], Cell[TextData[Cell[BoxData[
    "290"], "InlineFormula"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["x", "TI"], "=", 
     StyleBox["y", "TI"]}], Cell[TextData[Cell[BoxData[
    "40"], "InlineFormula"]], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->3617],

Cell["Possible grouping (associativity) specifications are: ", "Notes",
 CellID->16460],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "NonAssociative", Cell["\<\
not associative\[LongDash]always parenthesized \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
always associative\[LongDash]never parenthesized \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Left",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Left"], Cell[TextData[{
     "left associative (e.g., ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         StyleBox["a", "TI"], "/", 
         StyleBox["b", "TI"]}], ")"}], "/", 
       StyleBox["c", "TI"]}]], "InlineFormula"],
     ") "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Right",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Right"], Cell[TextData[{
     "right associative (e.g., ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], "^", 
       RowBox[{"(", 
        RowBox[{
         StyleBox["b", "TI"], "^", 
         StyleBox["c", "TI"]}], ")"}]}]], "InlineFormula"],
     ") "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->7253]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->159289437],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->65759520],

Cell["Use an infix notation:", "ExampleText",
 CellID->27715403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Infix", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "\"\<#\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152946242],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"a", "\<\"#\"\>", "b", "\<\"#\"\>", "c"}],
  Infix[
   $CellContext`f[$CellContext`a, $CellContext`b, $CellContext`c], "#"],
  Editable->False]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317105661]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2749],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Postfix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Postfix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Prefix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prefix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrecedenceForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrecedenceForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12273]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8650],

Cell[TextData[ButtonBox["Defining Output Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiningOutputFormats"]], "Tutorials",
 CellID->12586]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Defining Custom Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DefiningCustomNotation"]], "MoreAbout",
 CellID->482274109],

Cell[TextData[ButtonBox["Symbolic Notational Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicNotationalForms"]], "MoreAbout",
 CellID->95702541]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Infix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 36.6020600}", "context" -> "System`", 
    "keywords" -> {"~"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Infix[f[e_1, e_2, ...]] prints with f[e_1, e_2, ...] given in default \
infix form: e_1~f~e_2~f~e_3 .... Infix[expr, h] prints with arguments \
separated by h: e_1 h e_2 h e_3 .... ", "synonyms" -> {"~"}, "title" -> 
    "Infix", "type" -> "Symbol", "uri" -> "ref/Infix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9536, 306, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->159289437]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14079, 469}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2139, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2762, 79, 43, 1, 70, "ObjectName",
 CellID->12953],
Cell[2808, 82, 2398, 81, 70, "Usage",
 CellID->12059]
}, Open  ]],
Cell[CellGroupData[{
Cell[5243, 168, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5721, 185, 432, 14, 70, "Notes",
 CellID->26368],
Cell[6156, 201, 254, 8, 70, "Notes",
 CellID->31041],
Cell[6413, 211, 1438, 38, 70, "2ColumnTableMod",
 CellID->3617],
Cell[7854, 251, 87, 1, 70, "Notes",
 CellID->16460],
Cell[7944, 254, 1555, 47, 70, "2ColumnTableMod",
 CellID->7253]
}, Closed]],
Cell[CellGroupData[{
Cell[9536, 306, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->159289437],
Cell[CellGroupData[{
Cell[9921, 320, 147, 5, 70, "ExampleSection",
 CellID->65759520],
Cell[10071, 327, 64, 1, 70, "ExampleText",
 CellID->27715403],
Cell[CellGroupData[{
Cell[10160, 332, 199, 7, 28, "Input",
 CellID->152946242],
Cell[10362, 341, 329, 10, 36, "Output",
 CellID->317105661]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10752, 358, 310, 9, 70, "SeeAlsoSection",
 CellID->2749],
Cell[11065, 369, 702, 26, 70, "SeeAlso",
 CellID->12273]
}, Open  ]],
Cell[CellGroupData[{
Cell[11804, 400, 313, 9, 70, "TutorialsSection",
 CellID->8650],
Cell[12120, 411, 155, 3, 70, "Tutorials",
 CellID->12586]
}, Open  ]],
Cell[CellGroupData[{
Cell[12312, 419, 299, 8, 70, "MoreAboutSection"],
Cell[12614, 429, 158, 3, 70, "MoreAbout",
 CellID->482274109],
Cell[12775, 434, 159, 3, 70, "MoreAbout",
 CellID->95702541]
}, Open  ]],
Cell[12949, 440, 27, 0, 70, "History"],
Cell[12979, 442, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

