(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46814,       1625]
NotebookOptionsPosition[     33940,       1199]
NotebookOutlinePosition[     38932,       1341]
CellTagsIndexPosition[     38216,       1321]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Getting Help with a Text\[Hyphen]Based Interface" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GettingHelpWithATextBasedInterface"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Getting Help with a Text\[Hyphen]Based Interface\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Definition" :> 
          Documentation`HelpLookup["paclet:ref/Definition"], "Names" :> 
          Documentation`HelpLookup["paclet:ref/Names"], "ValueQ" :> 
          Documentation`HelpLookup["paclet:ref/ValueQ"], "DownValues" :> 
          Documentation`HelpLookup["paclet:ref/DownValues"], "UpValues" :> 
          Documentation`HelpLookup["paclet:ref/UpValues"], "Message" :> 
          Documentation`HelpLookup["paclet:ref/Message"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Definition\"\>", 2->"\<\"Names\"\>", 
       3->"\<\"ValueQ\"\>", 4->"\<\"DownValues\"\>", 5->"\<\"UpValues\"\>", 
       6->"\<\"Message\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assignments" :> 
          Documentation`HelpLookup["paclet:guide/Assignments"], 
          "Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessions"], 
          "Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"], 
          "Mathematica Syntax" :> 
          Documentation`HelpLookup["paclet:guide/Syntax"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Assignments\"\>", 
       2->"\<\"Mathematica Session Information\"\>", 
       3->"\<\"Mathematica Sessions\"\>", 4->"\<\"Symbol Handling\"\>", 
       5->"\<\"Mathematica Syntax\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Information", "ObjectName",
 CellID->26096],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Information",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Information"], "[", 
       StyleBox["symbol", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints information about a symbol. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28407]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Information",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Information"], "[", 
   StyleBox["symbol", "TI"], "]"}]], "InlineFormula"],
 " prints the same information as the input escape ",
 Cell[BoxData[
  RowBox[{"??", 
   StyleBox["symbol", "TI"]}]], "InlineFormula"],
 " would give. "
}], "Notes",
 CellID->11951],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19922]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5451813],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->33356654],

Cell["Get usage and attribute information: ", "ExampleText",
 CellID->375604012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", "Sin", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200516301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Sin\\\", \\\"[\\\", StyleBox[\\\"z\\\", \
\\\"TI\\\"], \\\"]\\\"}]\) gives the sine of \!\(\*StyleBox[\\\"z\\\", \\\"TI\
\\\"]\). \"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]}]], "Print", "PrintUsage",
 CellTags->"Info3382807602-7634156",
 CellID->418985],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Sin", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"Listable", ",", "NumericFunction", ",", "Protected"}], 
       "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["Sin"],
  Editable->False]], "Print",
 CellTags->"Info3382807602-7634156",
 CellID->576507571]
}, Open  ]]
}, Open  ]],

Cell["Short input form:", "ExampleText",
 CellID->539627687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "Sin"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72563778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Sin\\\", \\\"[\\\", StyleBox[\\\"z\\\", \
\\\"TI\\\"], \\\"]\\\"}]\) gives the sine of \!\(\*StyleBox[\\\"z\\\", \\\"TI\
\\\"]\). \"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]}]], "Print", "PrintUsage",
 CellTags->"Info3382807604-3891369",
 CellID->64041057],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Sin", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"Listable", ",", "NumericFunction", ",", "Protected"}], 
       "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["Sin"],
  Editable->False]], "Print",
 CellTags->"Info3382807604-3891369",
 CellID->252372405]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->448815092],

Cell["Get usage information only:", "ExampleText",
 CellID->280196286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", 
  RowBox[{"Sin", ",", 
   RowBox[{"LongForm", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->754254446],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Sin\\\", \\\"[\\\", StyleBox[\\\"z\\\", \
\\\"TI\\\"], \\\"]\\\"}]\) gives the sine of \!\(\*StyleBox[\\\"z\\\", \\\"TI\
\\\"]\). \"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]}]], "Print", "PrintUsage",
 CellTags->"Info3382807606-6901933",
 CellID->216119673]
}, Open  ]],

Cell["Short input form:", "ExampleText",
 CellID->809034534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Sin"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->828366519],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Sin\\\", \\\"[\\\", StyleBox[\\\"z\\\", \
\\\"TI\\\"], \\\"]\\\"}]\) gives the sine of \!\(\*StyleBox[\\\"z\\\", \\\"TI\
\\\"]\). \"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]}]], "Print", "PrintUsage",
 CellTags->"Info3382807608-1496944",
 CellID->104735161]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->302862613],

Cell[TextData[{
 "For built-in symbols, ",
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " gives attributes, defaults, and options, as well as usage messages:"
}], "ExampleText",
 CellID->26013284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", "Definition", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->204249407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Definition\\\", \\\"[\\\", \
StyleBox[\\\"symbol\\\", \\\"TI\\\"], \\\"]\\\"}]\) prints as the definitions \
given for a symbol. \"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]}]], "Print", "PrintUsage",
 CellTags->"Info3382807613-8728860",
 CellID->510340806],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "\<\"Definition\"\>", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"HoldAll", ",", "Protected"}], "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["Definition"],
  Editable->False]], "Print",
 CellTags->"Info3382807613-8728860",
 CellID->130503248]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139361254],

Cell[TextData[{
 "For user-defined symbols, ",
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " gives definitions as well:"
}], "ExampleText",
 CellID->407498939],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "Listable"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->68482110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->840306275],

Cell[CellGroupData[{

Cell["Cell$$41139`f", "Print", "PrintUsage",
 CellTags->"Info3382807616-5736232",
 CellID->1074290],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "f", "]"}], "=", 
      RowBox[{"{", "Listable", "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         SuperscriptBox["x", "2"]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3382807616-5736232",
 CellID->46569487]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->196542146],

Cell[TextData[{
 "For string patterns, ",
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " gives a clickable list of matching symbols:"
}], "ExampleText",
 CellID->5317024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", "\"\<*Values\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->113392216],

Cell[BoxData[
 DynamicModuleBox[{Typeset`open$$ = True}, 
  PaneSelectorBox[{False->
   RowBox[{
    OpenerBox[Dynamic[Typeset`open$$],
     ImageSize->Small], 
    StyleBox["System`", "InfoHeading"]}], True->GridBox[{
     {
      RowBox[{
       OpenerBox[Dynamic[Typeset`open$$],
        ImageSize->Small], 
       StyleBox["System`", "InfoHeading"]}]},
     {GridBox[{
        {
         ButtonBox["CounterValues",
          BaseStyle->"InformationLinkLF",
          ButtonData:>{"Info3382807631-8023995", "System`CounterValues"},
          ButtonNote->"System`"], 
         ButtonBox["FormatValues",
          BaseStyle->"InformationLinkLF",
          ButtonData:>{"Info3382807631-8023995", "System`FormatValues"},
          ButtonNote->"System`"], 
         ButtonBox["SubValues",
          BaseStyle->"InformationLinkLF",
          ButtonData:>{"Info3382807631-8023995", "System`SubValues"},
          ButtonNote->"System`"]},
        {
         ButtonBox["DefaultValues",
          BaseStyle->"InformationLinkLF",
          ButtonData:>{"Info3382807631-8023995", "System`DefaultValues"},
          ButtonNote->"System`"], 
         ButtonBox["NValues",
          BaseStyle->"InformationLinkLF",
          ButtonData:>{"Info3382807631-8023995", "System`NValues"},
          ButtonNote->"System`"], 
         ButtonBox["UpValues",
          BaseStyle->"InformationLinkLF",
          ButtonData:>{"Info3382807631-8023995", "System`UpValues"},
          ButtonNote->"System`"]},
        {
         ButtonBox["DownValues",
          BaseStyle->"InformationLinkLF",
          ButtonData:>{"Info3382807631-8023995", "System`DownValues"},
          ButtonNote->"System`"], 
         ButtonBox["OwnValues",
          BaseStyle->"InformationLinkLF",
          ButtonData:>{"Info3382807631-8023995", "System`OwnValues"},
          ButtonNote->"System`"], ""},
        {
         ButtonBox["DynamicModuleValues",
          BaseStyle->"InformationLinkLF",
          
          ButtonData:>{
           "Info3382807631-8023995", "System`DynamicModuleValues"},
          ButtonNote->"System`"], 
         ButtonBox["SingularValues",
          BaseStyle->"InformationLinkLF",
          ButtonData:>{"Info3382807631-8023995", "System`SingularValues"},
          ButtonNote->"System`"], ""}
       },
       DefaultBaseStyle->"InfoGrid",
       GridBoxItemSize->{"Columns" -> {{
            Scaled[0.31666666666666665`]}}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}]}, 
   Dynamic[Typeset`open$$],
   ImageSize->Automatic]]], "Print", "InfoCell",
 CellID->51940860]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->183250495],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LongForm",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->589663],

Cell[TextData[{
 "The default is ",
 StyleBox["LongForm->True", "InlineCode"],
 ":"
}], "ExampleText",
 CellID->125352884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", "Union", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->895947811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Union\\\", \\\"[\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"list\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"list\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"]\\\"}]\) gives a sorted list of all the distinct elements \
that appear in any of the \!\(\*SubscriptBox[StyleBox[\\\"list\\\", \
\\\"TI\\\"], StyleBox[\\\"i\\\", \\\"TI\\\"]]\). \\n\!\(\*RowBox[{\\\"Union\\\
\", \\\"[\\\", StyleBox[\\\"list\\\", \\\"TI\\\"], \\\"]\\\"}]\) gives a \
sorted version of a list, in which all duplicated elements have been dropped. \
\"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Union"]}]], "Print", "PrintUsage",
 CellTags->"Info3382807641-4638052",
 CellID->573720537],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Union", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"Flat", ",", "OneIdentity", ",", "Protected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Options", "[", "Union", "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"SameTest", "\[Rule]", "Automatic"}], "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["Union"],
  Editable->False]], "Print",
 CellTags->"Info3382807641-4638052",
 CellID->415732850]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->462102822],

Cell["The short form gives only usage messages:", "ExampleText",
 CellID->341882285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", 
  RowBox[{"Union", ",", 
   RowBox[{"LongForm", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272361070],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Union\\\", \\\"[\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"list\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"list\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"]\\\"}]\) gives a sorted list of all the distinct elements \
that appear in any of the \!\(\*SubscriptBox[StyleBox[\\\"list\\\", \
\\\"TI\\\"], StyleBox[\\\"i\\\", \\\"TI\\\"]]\). \\n\!\(\*RowBox[{\\\"Union\\\
\", \\\"[\\\", StyleBox[\\\"list\\\", \\\"TI\\\"], \\\"]\\\"}]\) gives a \
sorted version of a list, in which all duplicated elements have been dropped. \
\"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Union"]}]], "Print", "PrintUsage",
 CellTags->"Info3382807643-3658916",
 CellID->118537570]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->237315024],

Cell[TextData[{
 "If no usage message exists, ",
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " gives the symbol name only, including the context:"
}], "ExampleText",
 CellID->918220130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", "f", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126637226],

Cell["Cell$$41162`f", "Print", "PrintUsage",
 CellTags->"Info3382807649-4164229",
 CellID->37664711]
}, Open  ]],

Cell["Add a usage message: ", "ExampleText",
 CellID->652119970],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "::", "usage"}], "=", "\"\<f[x] computes xxxx.\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->430981999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->139989930],

Cell[BoxData[
 StyleBox["\<\"f[x] computes xxxx.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3382807652-8532002",
 CellID->430832913]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81862317],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " prints the values rendered by ",
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 ", as well as usage messages:"
}], "ExampleText",
 CellID->26523415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", "Union", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11667923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Union\\\", \\\"[\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"list\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"list\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"]\\\"}]\) gives a sorted list of all the distinct elements \
that appear in any of the \!\(\*SubscriptBox[StyleBox[\\\"list\\\", \
\\\"TI\\\"], StyleBox[\\\"i\\\", \\\"TI\\\"]]\). \\n\!\(\*RowBox[{\\\"Union\\\
\", \\\"[\\\", StyleBox[\\\"list\\\", \\\"TI\\\"], \\\"]\\\"}]\) gives a \
sorted version of a list, in which all duplicated elements have been dropped. \
\"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Union"]}]], "Print", "PrintUsage",
 CellTags->"Info3382807655-1687610",
 CellID->335051896],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Union", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"Flat", ",", "OneIdentity", ",", "Protected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Options", "[", "Union", "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"SameTest", "\[Rule]", "Automatic"}], "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["Union"],
  Editable->False]], "Print",
 CellTags->"Info3382807655-1687610",
 CellID->395949769]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->446338031],

Cell[TextData[{
 Cell[BoxData["??"], "InlineFormula"],
 " is the same as ",
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->47407235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "Definition"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406785884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Definition\\\", \\\"[\\\", \
StyleBox[\\\"symbol\\\", \\\"TI\\\"], \\\"]\\\"}]\) prints as the definitions \
given for a symbol. \"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]}]], "Print", "PrintUsage",
 CellTags->"Info3382807657-9606872",
 CellID->180304272],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "\<\"Definition\"\>", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"HoldAll", ",", "Protected"}], "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["Definition"],
  Editable->False]], "Print",
 CellTags->"Info3382807657-9606872",
 CellID->571792015]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215757121],

Cell[TextData[{
 Cell[BoxData["?"], "InlineFormula"],
 " is the same as ",
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " with ",
 StyleBox["LongForm->False", "InlineCode"],
 ":"
}], "ExampleText",
 CellID->925130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "Definition"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->473670349],

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Definition\\\", \\\"[\\\", \
StyleBox[\\\"symbol\\\", \\\"TI\\\"], \\\"]\\\"}]\) prints as the definitions \
given for a symbol. \"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]}]], "Print", "PrintUsage",
 CellTags->"Info3382807658-4025395",
 CellID->81082948]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->826607838],

Cell["For a read-protected symbol, no definitions are printed:", "ExampleText",
 CellID->127982124],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "ReadProtected"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->201872909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129582955],

Cell[CellGroupData[{

Cell["Cell$$41184`f", "Print", "PrintUsage",
 CellTags->"Info3382807661-3157594",
 CellID->445042334],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "f", "]"}], "=", 
      RowBox[{"{", "ReadProtected", "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3382807661-3157594",
 CellID->12713366]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->948276076],

Cell["\<\
Information prints output as a side effect, it does not return a value:\
\>", "ExampleText",
 CellID->151525857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"Information", "[", "Information", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->226899107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"Information\\\", \\\"[\\\", \
StyleBox[\\\"symbol\\\", \\\"TI\\\"], \\\"]\\\"}]\) prints information about \
a symbol. \"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]}]], "Print", "PrintUsage",
 CellTags->"Info3382807668-8104255",
 CellID->785143933],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Information", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"HoldAll", ",", "Protected", ",", "ReadProtected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Options", "[", "Information", "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"LongForm", "\[Rule]", "True"}], "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["Information"],
  Editable->False]], "Print",
 CellTags->"Info3382807668-8104255",
 CellID->178960752]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox["Null",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->621605958]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8117],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Definition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Definition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Names",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Names"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ValueQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ValueQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DownValues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DownValues"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UpValues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UpValues"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Message",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Message"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15444]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18804],

Cell[TextData[ButtonBox["Getting Help with a Text\[Hyphen]Based Interface",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/GettingHelpWithATextBasedInterface"]], "Tutorials",
 CellID->12190]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Assignments",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Assignments"]], "MoreAbout",
 CellID->404115104],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->71165158],

Cell[TextData[ButtonBox["Mathematica Sessions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessions"]], "MoreAbout",
 CellID->19247759],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->166817939],

Cell[TextData[ButtonBox["Mathematica Syntax",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Syntax"]], "MoreAbout",
 CellID->561671421]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Information - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 36.8833172}", "context" -> "System`", 
    "keywords" -> {
     "function attributes", "function defaults", "function definition", 
      "function options", "function usage", "function values", 
      "symbol attributes", "symbol defaults", "symbol definition", 
      "symbol options", "symbol usage", "symbol values"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Information[symbol] prints information about a symbol. ", 
    "synonyms" -> {"??"}, "title" -> "Information", "type" -> "Symbol", "uri" -> 
    "ref/Information"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5296, 164, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->5451813]},
 "Info3382807602-7634156"->{
  Cell[6068, 197, 413, 11, 70, "Print",
   CellTags->"Info3382807602-7634156",
   CellID->418985],
  Cell[6484, 210, 505, 16, 70, "Print",
   CellTags->"Info3382807602-7634156",
   CellID->576507571]},
 "Info3382807604-3891369"->{
  Cell[7215, 242, 415, 11, 70, "Print",
   CellTags->"Info3382807604-3891369",
   CellID->64041057],
  Cell[7633, 255, 505, 16, 70, "Print",
   CellTags->"Info3382807604-3891369",
   CellID->252372405]},
 "Info3382807606-6901933"->{
  Cell[8564, 292, 416, 11, 70, "Print",
   CellTags->"Info3382807606-6901933",
   CellID->216119673]},
 "Info3382807608-1496944"->{
  Cell[9172, 316, 416, 11, 70, "Print",
   CellTags->"Info3382807608-1496944",
   CellID->104735161]},
 "Info3382807613-8728860"->{
  Cell[10303, 361, 422, 11, 70, "Print",
   CellTags->"Info3382807613-8728860",
   CellID->510340806],
  Cell[10728, 374, 494, 15, 70, "Print",
   CellTags->"Info3382807613-8728860",
   CellID->130503248]},
 "Info3382807616-5736232"->{
  Cell[12023, 427, 99, 2, 70, "Print",
   CellTags->"Info3382807616-5736232",
   CellID->1074290],
  Cell[12125, 431, 899, 28, 70, "Print",
   CellTags->"Info3382807616-5736232",
   CellID->46569487]},
 "Info3382807641-4638052"->{
  Cell[17130, 601, 928, 18, 70, "Print",
   CellTags->"Info3382807641-4638052",
   CellID->573720537],
  Cell[18061, 621, 1019, 30, 70, "Print",
   CellTags->"Info3382807641-4638052",
   CellID->415732850]},
 "Info3382807643-3658916"->{
  Cell[19522, 672, 928, 18, 70, "Print",
   CellTags->"Info3382807643-3658916",
   CellID->118537570]},
 "Info3382807649-4164229"->{
  Cell[21153, 723, 100, 2, 70, "Print",
   CellTags->"Info3382807649-4164229",
   CellID->37664711]},
 "Info3382807652-8532002"->{
  Cell[21638, 746, 143, 3, 70, "Print",
   CellTags->"Info3382807652-8532002",
   CellID->430832913]},
 "Info3382807655-1687610"->{
  Cell[22452, 780, 928, 18, 70, "Print",
   CellTags->"Info3382807655-1687610",
   CellID->335051896],
  Cell[23383, 800, 1019, 30, 70, "Print",
   CellTags->"Info3382807655-1687610",
   CellID->395949769]},
 "Info3382807657-9606872"->{
  Cell[24947, 859, 422, 11, 70, "Print",
   CellTags->"Info3382807657-9606872",
   CellID->180304272],
  Cell[25372, 872, 494, 15, 70, "Print",
   CellTags->"Info3382807657-9606872",
   CellID->571792015]},
 "Info3382807658-4025395"->{
  Cell[26440, 916, 421, 11, 70, "Print",
   CellTags->"Info3382807658-4025395",
   CellID->81082948]},
 "Info3382807661-3157594"->{
  Cell[27515, 957, 101, 2, 70, "Print",
   CellTags->"Info3382807661-3157594",
   CellID->445042334],
  Cell[27619, 961, 437, 14, 70, "Print",
   CellTags->"Info3382807661-3157594",
   CellID->12713366]},
 "Info3382807668-8104255"->{
  Cell[28674, 1006, 413, 11, 70, "Print",
   CellTags->"Info3382807668-8104255",
   CellID->785143933],
  Cell[29090, 1019, 1037, 30, 70, "Print",
   CellTags->"Info3382807668-8104255",
   CellID->178960752]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35169, 1227},
 {"Info3382807602-7634156", 35316, 1231},
 {"Info3382807604-3891369", 35547, 1238},
 {"Info3382807606-6901933", 35780, 1245},
 {"Info3382807608-1496944", 35912, 1249},
 {"Info3382807613-8728860", 36044, 1253},
 {"Info3382807616-5736232", 36280, 1260},
 {"Info3382807641-4638052", 36511, 1267},
 {"Info3382807643-3658916", 36748, 1274},
 {"Info3382807649-4164229", 36881, 1278},
 {"Info3382807652-8532002", 37012, 1282},
 {"Info3382807655-1687610", 37144, 1286},
 {"Info3382807657-9606872", 37381, 1293},
 {"Info3382807658-4025395", 37617, 1300},
 {"Info3382807661-3157594", 37749, 1304},
 {"Info3382807668-8104255", 37983, 1311}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2888, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3511, 92, 49, 1, 70, "ObjectName",
 CellID->26096],
Cell[3563, 95, 488, 15, 70, "Usage",
 CellID->28407]
}, Open  ]],
Cell[CellGroupData[{
Cell[4088, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4566, 132, 378, 13, 70, "Notes",
 CellID->11951],
Cell[4947, 147, 312, 12, 70, "Notes",
 CellID->19922]
}, Closed]],
Cell[CellGroupData[{
Cell[5296, 164, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5451813],
Cell[CellGroupData[{
Cell[5679, 178, 147, 5, 70, "ExampleSection",
 CellID->33356654],
Cell[5829, 185, 80, 1, 70, "ExampleText",
 CellID->375604012],
Cell[CellGroupData[{
Cell[5934, 190, 109, 3, 70, "Input",
 CellID->200516301],
Cell[CellGroupData[{
Cell[6068, 197, 413, 11, 70, "Print",
 CellTags->"Info3382807602-7634156",
 CellID->418985],
Cell[6484, 210, 505, 16, 70, "Print",
 CellTags->"Info3382807602-7634156",
 CellID->576507571]
}, Open  ]]
}, Open  ]],
Cell[7016, 230, 60, 1, 70, "ExampleText",
 CellID->539627687],
Cell[CellGroupData[{
Cell[7101, 235, 89, 3, 70, "Input",
 CellID->72563778],
Cell[CellGroupData[{
Cell[7215, 242, 415, 11, 70, "Print",
 CellTags->"Info3382807604-3891369",
 CellID->64041057],
Cell[7633, 255, 505, 16, 70, "Print",
 CellTags->"Info3382807604-3891369",
 CellID->252372405]
}, Open  ]]
}, Open  ]],
Cell[8165, 275, 125, 3, 70, "ExampleDelimiter",
 CellID->448815092],
Cell[8293, 280, 70, 1, 70, "ExampleText",
 CellID->280196286],
Cell[CellGroupData[{
Cell[8388, 285, 173, 5, 70, "Input",
 CellID->754254446],
Cell[8564, 292, 416, 11, 70, "Print",
 CellTags->"Info3382807606-6901933",
 CellID->216119673]
}, Open  ]],
Cell[8995, 306, 60, 1, 70, "ExampleText",
 CellID->809034534],
Cell[CellGroupData[{
Cell[9080, 311, 89, 3, 70, "Input",
 CellID->828366519],
Cell[9172, 316, 416, 11, 70, "Print",
 CellTags->"Info3382807608-1496944",
 CellID->104735161]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9637, 333, 220, 7, 70, "ExampleSection",
 CellID->302862613],
Cell[9860, 342, 277, 8, 70, "ExampleText",
 CellID->26013284],
Cell[CellGroupData[{
Cell[10162, 354, 116, 3, 70, "Input",
 CellID->204249407],
Cell[CellGroupData[{
Cell[10303, 361, 422, 11, 70, "Print",
 CellTags->"Info3382807613-8728860",
 CellID->510340806],
Cell[10728, 374, 494, 15, 70, "Print",
 CellTags->"Info3382807613-8728860",
 CellID->130503248]
}, Open  ]]
}, Open  ]],
Cell[11249, 393, 125, 3, 70, "ExampleDelimiter",
 CellID->139361254],
Cell[11377, 398, 241, 8, 70, "ExampleText",
 CellID->407498939],
Cell[11621, 408, 245, 8, 70, "Input",
 CellID->68482110],
Cell[CellGroupData[{
Cell[11891, 420, 107, 3, 70, "Input",
 CellID->840306275],
Cell[CellGroupData[{
Cell[12023, 427, 99, 2, 70, "Print",
 CellTags->"Info3382807616-5736232",
 CellID->1074290],
Cell[12125, 431, 899, 28, 70, "Print",
 CellTags->"Info3382807616-5736232",
 CellID->46569487]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13085, 466, 243, 7, 70, "ExampleSection",
 CellID->196542146],
Cell[13331, 475, 251, 8, 70, "ExampleText",
 CellID->5317024],
Cell[CellGroupData[{
Cell[13607, 487, 121, 3, 70, "Input",
 CellID->113392216],
Cell[13731, 492, 2591, 67, 70, "Print",
 CellID->51940860]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16371, 565, 222, 7, 70, "ExampleSection",
 CellID->183250495],
Cell[CellGroupData[{
Cell[16618, 576, 226, 7, 70, "ExampleSubsection",
 CellID->589663],
Cell[16847, 585, 122, 5, 70, "ExampleText",
 CellID->125352884],
Cell[CellGroupData[{
Cell[16994, 594, 111, 3, 70, "Input",
 CellID->895947811],
Cell[CellGroupData[{
Cell[17130, 601, 928, 18, 70, "Print",
 CellTags->"Info3382807641-4638052",
 CellID->573720537],
Cell[18061, 621, 1019, 30, 70, "Print",
 CellTags->"Info3382807641-4638052",
 CellID->415732850]
}, Open  ]]
}, Open  ]],
Cell[19107, 655, 125, 3, 70, "ExampleDelimiter",
 CellID->462102822],
Cell[19235, 660, 84, 1, 70, "ExampleText",
 CellID->341882285],
Cell[CellGroupData[{
Cell[19344, 665, 175, 5, 70, "Input",
 CellID->272361070],
Cell[19522, 672, 928, 18, 70, "Print",
 CellTags->"Info3382807643-3658916",
 CellID->118537570]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[20511, 697, 237, 7, 70, "ExampleSection",
 CellID->237315024],
Cell[20751, 706, 267, 8, 70, "ExampleText",
 CellID->918220130],
Cell[CellGroupData[{
Cell[21043, 718, 107, 3, 70, "Input",
 CellID->126637226],
Cell[21153, 723, 100, 2, 70, "Print",
 CellTags->"Info3382807649-4164229",
 CellID->37664711]
}, Open  ]],
Cell[21268, 728, 64, 1, 70, "ExampleText",
 CellID->652119970],
Cell[21335, 731, 168, 6, 70, "Input",
 CellID->430981999],
Cell[CellGroupData[{
Cell[21528, 741, 107, 3, 70, "Input",
 CellID->139989930],
Cell[21638, 746, 143, 3, 70, "Print",
 CellTags->"Info3382807652-8532002",
 CellID->430832913]
}, Open  ]],
Cell[21796, 752, 124, 3, 70, "ExampleDelimiter",
 CellID->81862317],
Cell[21923, 757, 369, 12, 70, "ExampleText",
 CellID->26523415],
Cell[CellGroupData[{
Cell[22317, 773, 110, 3, 70, "Input",
 CellID->11667923],
Cell[CellGroupData[{
Cell[22452, 780, 928, 18, 70, "Print",
 CellTags->"Info3382807655-1687610",
 CellID->335051896],
Cell[23383, 800, 1019, 30, 70, "Print",
 CellTags->"Info3382807655-1687610",
 CellID->395949769]
}, Open  ]]
}, Open  ]],
Cell[24429, 834, 125, 3, 70, "ExampleDelimiter",
 CellID->446338031],
Cell[24557, 839, 243, 9, 70, "ExampleText",
 CellID->47407235],
Cell[CellGroupData[{
Cell[24825, 852, 97, 3, 70, "Input",
 CellID->406785884],
Cell[CellGroupData[{
Cell[24947, 859, 422, 11, 70, "Print",
 CellTags->"Info3382807657-9606872",
 CellID->180304272],
Cell[25372, 872, 494, 15, 70, "Print",
 CellTags->"Info3382807657-9606872",
 CellID->571792015]
}, Open  ]]
}, Open  ]],
Cell[25893, 891, 125, 3, 70, "ExampleDelimiter",
 CellID->215757121],
Cell[26021, 896, 295, 11, 70, "ExampleText",
 CellID->925130],
Cell[CellGroupData[{
Cell[26341, 911, 96, 3, 70, "Input",
 CellID->473670349],
Cell[26440, 916, 421, 11, 70, "Print",
 CellTags->"Info3382807658-4025395",
 CellID->81082948]
}, Open  ]],
Cell[26876, 930, 125, 3, 70, "ExampleDelimiter",
 CellID->826607838],
Cell[27004, 935, 99, 1, 70, "ExampleText",
 CellID->127982124],
Cell[27106, 938, 252, 8, 70, "Input",
 CellID->201872909],
Cell[CellGroupData[{
Cell[27383, 950, 107, 3, 70, "Input",
 CellID->129582955],
Cell[CellGroupData[{
Cell[27515, 957, 101, 2, 70, "Print",
 CellTags->"Info3382807661-3157594",
 CellID->445042334],
Cell[27619, 961, 437, 14, 70, "Print",
 CellTags->"Info3382807661-3157594",
 CellID->12713366]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28117, 982, 230, 7, 70, "ExampleSection",
 CellID->948276076],
Cell[28350, 991, 122, 3, 70, "ExampleText",
 CellID->151525857],
Cell[CellGroupData[{
Cell[28497, 998, 152, 4, 70, "Input",
 CellID->226899107],
Cell[CellGroupData[{
Cell[28674, 1006, 413, 11, 70, "Print",
 CellTags->"Info3382807668-8104255",
 CellID->785143933],
Cell[29090, 1019, 1037, 30, 70, "Print",
 CellTags->"Info3382807668-8104255",
 CellID->178960752]
}, Open  ]],
Cell[30142, 1052, 292, 11, 50, "Output",
 CellID->621605958]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30495, 1070, 310, 9, 70, "SeeAlsoSection",
 CellID->8117],
Cell[30808, 1081, 1427, 53, 70, "SeeAlso",
 CellID->15444]
}, Open  ]],
Cell[CellGroupData[{
Cell[32272, 1139, 314, 9, 70, "TutorialsSection",
 CellID->18804],
Cell[32589, 1150, 196, 4, 70, "Tutorials",
 CellID->12190]
}, Open  ]],
Cell[CellGroupData[{
Cell[32822, 1159, 299, 8, 70, "MoreAboutSection"],
Cell[33124, 1169, 134, 3, 70, "MoreAbout",
 CellID->404115104],
Cell[33261, 1174, 171, 3, 70, "MoreAbout",
 CellID->71165158],
Cell[33435, 1179, 150, 3, 70, "MoreAbout",
 CellID->19247759],
Cell[33588, 1184, 141, 3, 70, "MoreAbout",
 CellID->166817939],
Cell[33732, 1189, 136, 3, 70, "MoreAbout",
 CellID->561671421]
}, Open  ]],
Cell[33883, 1195, 27, 0, 70, "History"],
Cell[33913, 1197, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

