(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8319,        276]
NotebookOptionsPosition[      6258,        213]
NotebookOutlinePosition[      7460,        244]
CellTagsIndexPosition[      7417,        241]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebook Security" :> 
          Documentation`HelpLookup["paclet:tutorial/NotebookSecurity"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Notebook Security\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluate Initialization Cells" :> 
          Documentation`HelpLookup[
           "paclet:ref/menuitem/EvaluateInitializationCells"], 
          "InitializationCell" :> 
          Documentation`HelpLookup["paclet:ref/InitializationCell"], 
          "InitializationCellWarning" :> 
          Documentation`HelpLookup[
           "paclet:ref/InitializationCellWarning"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Evaluate Initialization Cells\"\>", 
       2->"\<\"InitializationCell\"\>", 
       3->"\<\"InitializationCellWarning\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InitializationCellEvaluation", "ObjectName",
 CellID->5004],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->544897962],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["InitializationCellEvaluation",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InitializationCellEvaluation"]], 
      "InlineFormula"],
     "\[LineSeparator]is an option for notebooks that specifies whether \
initialization cells in a notebook are automatically evaluated when the \
notebook is opened."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19649]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"InitializationCellEvaluation", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", a dialog box appears when the notebook is opened, asking the user to \
specify whether initialization cells should be evaluated."
}], "Notes",
 CellID->22754],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"InitializationCellEvaluation", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the initialization cells are not evaluated when the notebook is opened."
}], "Notes",
 CellID->5233],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"InitializationCellEvaluation", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the initialization cells are evaluated without any action by the user."
}], "Notes",
 CellID->17570]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10495],

Cell[TextData[{
 StyleBox[ButtonBox["Evaluate Initialization Cells",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/EvaluateInitializationCells"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InitializationCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InitializationCell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InitializationCellWarning",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InitializationCellWarning"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "  "
}], "SeeAlso",
 CellID->1166]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8549],

Cell[TextData[ButtonBox["Notebook Security",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NotebookSecurity"]], "Tutorials",
 CellID->12806]
}, Open  ]],

Cell["New in 4.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InitializationCellEvaluation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 37.8208412}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InitializationCellEvaluation is an option for notebooks that specifies \
whether initialization cells in a notebook are automatically evaluated when \
the notebook is opened.", "synonyms" -> {"initialization cell evaluation"}, 
    "title" -> "InitializationCellEvaluation", "type" -> "Symbol", "uri" -> 
    "ref/InitializationCellEvaluation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1551, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2174, 65, 65, 1, 70, "ObjectName",
 CellID->5004],
Cell[2242, 68, 218, 6, 70, "AwaitingReviewNote",
 CellID->544897962],
Cell[2463, 76, 575, 16, 70, "Usage",
 CellID->19649]
}, Open  ]],
Cell[CellGroupData[{
Cell[3075, 97, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3553, 114, 383, 10, 70, "Notes",
 CellID->22754],
Cell[3939, 126, 314, 9, 70, "Notes",
 CellID->5233],
Cell[4256, 137, 307, 9, 70, "Notes",
 CellID->17570]
}, Closed]],
Cell[CellGroupData[{
Cell[4600, 151, 311, 9, 70, "SeeAlsoSection",
 CellID->10495],
Cell[4914, 162, 773, 25, 70, "SeeAlso",
 CellID->1166]
}, Open  ]],
Cell[CellGroupData[{
Cell[5724, 192, 313, 9, 70, "TutorialsSection",
 CellID->8549],
Cell[6040, 203, 144, 3, 70, "Tutorials",
 CellID->12806]
}, Open  ]],
Cell[6199, 209, 29, 0, 70, "History"],
Cell[6231, 211, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

