(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8290,        272]
NotebookOptionsPosition[      6304,        211]
NotebookOutlinePosition[      7484,        242]
CellTagsIndexPosition[      7441,        239]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebook Security" :> 
          Documentation`HelpLookup["paclet:tutorial/NotebookSecurity"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Notebook Security\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluate Initialization Cells" :> 
          Documentation`HelpLookup[
           "paclet:ref/menuitem/EvaluateInitializationCells"], 
          "InitializationCell" :> 
          Documentation`HelpLookup["paclet:ref/InitializationCell"], 
          "InitializationCellEvaluation" :> 
          Documentation`HelpLookup[
           "paclet:ref/InitializationCellEvaluation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Evaluate Initialization Cells\"\>", 
       2->"\<\"InitializationCell\"\>", 
       3->"\<\"InitializationCellEvaluation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InitializationCellWarning", "ObjectName",
 CellID->5682],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->13329274],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["InitializationCellWarning",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InitializationCellWarning"]], "InlineFormula"],
     
     "\[LineSeparator]is an option for notebooks that specifies whether a \
warning should be given when a notebook containing initialization cells is \
opened."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27833]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"InitializationCellWarning", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", a warning in the form of a dialog box is given, asking the user to choose \
whether the initialization cells should be automatically evaluated."
}], "Notes",
 CellID->2660],

Cell[TextData[{
 "In order for the warning ",
 StyleBox["not",
  FontSlant->"Italic"],
 " to occur, this option must be set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " both in the notebook being opened and at the global level. This is a \
security feature to prevent a notebook from silently evaluating cells without \
the user\[CloseCurlyQuote]s knowledge, unless the user has specifically \
enabled this by setting the option to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " at the global level."
}], "Notes",
 CellID->31250]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23911],

Cell[TextData[{
 StyleBox[ButtonBox["Evaluate Initialization Cells",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/EvaluateInitializationCells"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InitializationCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InitializationCell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InitializationCellEvaluation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InitializationCellEvaluation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10507]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2985],

Cell[TextData[ButtonBox["Notebook Security",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NotebookSecurity"]], "Tutorials",
 CellID->17644]
}, Open  ]],

Cell["New in 4.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InitializationCellWarning - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 43.8366202}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InitializationCellWarning is an option for notebooks that specifies \
whether a warning should be given when a notebook containing initialization \
cells is opened.", "synonyms" -> {"initialization cell warning"}, "title" -> 
    "InitializationCellWarning", "type" -> "Symbol", "uri" -> 
    "ref/InitializationCellWarning"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1560, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2183, 65, 62, 1, 70, "ObjectName",
 CellID->5682],
Cell[2248, 68, 217, 6, 70, "AwaitingReviewNote",
 CellID->13329274],
Cell[2468, 76, 561, 16, 70, "Usage",
 CellID->27833]
}, Open  ]],
Cell[CellGroupData[{
Cell[3066, 97, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3544, 114, 384, 10, 70, "Notes",
 CellID->2660],
Cell[3931, 126, 678, 19, 70, "Notes",
 CellID->31250]
}, Closed]],
Cell[CellGroupData[{
Cell[4646, 150, 311, 9, 70, "SeeAlsoSection",
 CellID->23911],
Cell[4960, 161, 773, 24, 70, "SeeAlso",
 CellID->10507]
}, Open  ]],
Cell[CellGroupData[{
Cell[5770, 190, 313, 9, 70, "TutorialsSection",
 CellID->2985],
Cell[6086, 201, 144, 3, 70, "Tutorials",
 CellID->17644]
}, Open  ]],
Cell[6245, 207, 29, 0, 70, "History"],
Cell[6277, 209, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

