(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37777,       1441]
NotebookOptionsPosition[     30516,       1190]
NotebookOutlinePosition[     31876,       1228]
CellTagsIndexPosition[     31790,       1223]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/StructuralOperations"], 
          "Tensors" :> 
          Documentation`HelpLookup["paclet:tutorial/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Structural Operations\"\>", 
       2->"\<\"Tensors\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Outer" :> Documentation`HelpLookup["paclet:ref/Outer"], "Dot" :> 
          Documentation`HelpLookup["paclet:ref/Dot"], "Thread" :> 
          Documentation`HelpLookup["paclet:ref/Thread"], "MapThread" :> 
          Documentation`HelpLookup["paclet:ref/MapThread"], "ListCorrelate" :> 
          Documentation`HelpLookup["paclet:ref/ListCorrelate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Outer\"\>", 2->"\<\"Dot\"\>", 
       3->"\<\"Thread\"\>", 4->"\<\"MapThread\"\>", 
       5->"\<\"ListCorrelate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Lists" :> 
          Documentation`HelpLookup["paclet:guide/ApplyingFunctionsToLists"], 
          "Tensors" :> Documentation`HelpLookup["paclet:guide/Tensors"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Applying Functions to Lists\"\>", 
       2->"\<\"Tensors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Inner", "ObjectName",
 CellID->9429],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Inner",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Inner"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["g", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a generalization of ",
     Cell[BoxData[
      ButtonBox["Dot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
     " in which ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " plays the role of multiplication and ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " of addition. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7229]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Inner", "[", 
    RowBox[{
     StyleBox["f", "TI"], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         StyleBox["a", "TI"], ",", 
         StyleBox["b", "TI"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["c", "TI"], ",", 
         StyleBox["d", "TI"]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"]}], "}"}], ",", 
     StyleBox["g", "TI"]}], "]"}], "\[LongRightArrow]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      StyleBox["g", "TI"], "[", 
      RowBox[{
       RowBox[{
        StyleBox["f", "TI"], "[", 
        RowBox[{
         StyleBox["a", "TI"], ",", 
         StyleBox["x", "TI"]}], "]"}], ",", 
       RowBox[{
        StyleBox["f", "TI"], "[", 
        RowBox[{
         StyleBox["b", "TI"], ",", 
         StyleBox["y", "TI"]}], "]"}]}], "]"}], ",", 
     RowBox[{
      StyleBox["g", "TI"], "[", 
      RowBox[{
       RowBox[{
        StyleBox["f", "TI"], "[", 
        RowBox[{
         StyleBox["c", "TI"], ",", 
         StyleBox["x", "TI"]}], "]"}], ",", 
       RowBox[{
        StyleBox["f", "TI"], "[", 
        RowBox[{
         StyleBox["d", "TI"], ",", 
         StyleBox["y", "TI"]}], "]"}]}], "]"}]}], "}"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11187],

Cell[TextData[{
 "Like ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Inner",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inner"]], "InlineFormula"],
 " effectively contracts the last index of the first tensor with the first \
index of the second tensor. Applying ",
 Cell[BoxData[
  ButtonBox["Inner",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inner"]], "InlineFormula"],
 " to a rank ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " tensor and a rank ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " tensor gives a rank ",
 Cell[BoxData[
  FormBox[
   RowBox[{"r", "+", "s", "-", "2"}], TraditionalForm]], "InlineMath"],
 " tensor. "
}], "Notes",
 CellID->2431],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Inner",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inner"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " uses ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23503],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Inner",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inner"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["g", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " contracts index ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " of the first tensor with the first index of the second tensor. "
}], "Notes",
 CellID->20406],

Cell[TextData[{
 "The heads of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " must be the same, but need not necessarily be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1722953700,
  ButtonNote->"1722953700"]
}], "Notes",
 CellID->27050]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->127613464],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->266336289],

Cell["Compute the \"inner f\" of two list, with \"plus operation\" g:", \
"ExampleText",
 CellID->202814341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "g"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1199269900],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "y"}], "]"}]}], "]"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109961840]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->221813303],

Cell["\<\
Compute a generalized inner product of a matrix and a vector:\
\>", "ExampleText",
 CellID->85212409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "g"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175782609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "x"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "y"}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"c", ",", "x"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"d", ",", "y"}], "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82380952]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110551329],

Cell["Use familiar operations:", "ExampleText",
 CellID->31939129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"Times", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Plus"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49887403],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "x"}], "+", 
  RowBox[{"b", " ", "y"}]}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21493641]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"Power", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Times"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->1160202903],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "x"], " ", 
  SuperscriptBox["b", "y"], " ", 
  SuperscriptBox["c", "z"]}]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1500097650]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11486],

Cell["Generalized inner product of a two matrices:", "ExampleText",
 CellID->106940317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"w", ",", "x"}], "}"}]}], "}"}], ",", "g"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1254100186],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"a", ",", "u"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"b", ",", "w"}], "]"}]}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"a", ",", "v"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"b", ",", "x"}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"c", ",", "u"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"d", ",", "w"}], "]"}]}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"c", ",", "v"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"d", ",", "x"}], "]"}]}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{578, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->727713616]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->758734432],

Cell["Inner product of a matrix with a vector:", "ExampleText",
 CellID->1056004281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "t"}], "}"}], ",", "g"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191586286],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "s"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "t"}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"c", ",", "s"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"d", ",", "t"}], "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154178026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->788320221],

Cell["Inner product of a vector with a matrix:", "ExampleText",
 CellID->236121806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", "g"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->571360600],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "a"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "c"}], "]"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "b"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"y", ",", "d"}], "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115264624]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24667],

Cell["Contract over the first index of the first matrix:", "ExampleText",
 CellID->1960322881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"w", ",", "x"}], "}"}]}], "}"}], ",", "g", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->631114584],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"a", ",", "u"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"c", ",", "w"}], "]"}]}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"a", ",", "v"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"c", ",", "x"}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"b", ",", "u"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"d", ",", "w"}], "]"}]}], "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"b", ",", "v"}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"d", ",", "x"}], "]"}]}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{578, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145739905]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1791929846],

Cell[TextData[{
 "Inner works with heads other than ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1722953700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"s", ",", 
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", "2", "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2042051005],

Cell[BoxData[
 RowBox[{"t", "[", 
  RowBox[{"s", "[", 
   RowBox[{"1", ",", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23331941]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21214],

Cell["\<\
The divergence of a vector field is an inner differentiation:\
\>", "ExampleText",
 CellID->450959685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"D", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "x"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "y"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Plus"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1601590653],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["x", "2"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ")"}], "2"]], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox["y", "2"]}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], ")"}], "2"]], "-", 
  FractionBox["2", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}]]}]], "Output",
 ImageSize->{194, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75662211]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->608381825],

Cell["Inner product of two Boolean matrices:", "ExampleText",
 CellID->646804873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"And", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", "Or"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->252246212],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "False"}], "}"}]}], "}"}]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165600286]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->631573049],

Cell["Applying the functions in a list to corresponding arguments:", \
"ExampleText",
 CellID->465355440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#1", "[", "#2", "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g", ",", "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "List"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->878042529],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"g", "[", "b", "]"}], ",", 
   RowBox[{"h", "[", "c", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->749191115]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1939],

Cell["This gives the scalar product of two vectors:", "ExampleText",
 CellID->868474426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "1"], ",", " ", 
     SubscriptBox["a", "2"], ",", " ", 
     SubscriptBox["a", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["b", "1"], ",", " ", 
     SubscriptBox["b", "2"], ",", " ", 
     SubscriptBox["b", "3"]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1859790047],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["a", "1"], " ", 
   SubscriptBox["b", "1"]}], "+", 
  RowBox[{
   SubscriptBox["a", "2"], " ", 
   SubscriptBox["b", "2"]}], "+", 
  RowBox[{
   SubscriptBox["a", "3"], " ", 
   SubscriptBox["b", "3"]}]}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75783272]
}, Open  ]],

Cell["This does the same thing:", "ExampleText",
 CellID->278626398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"Times", ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "1"], ",", " ", 
     SubscriptBox["a", "2"], ",", " ", 
     SubscriptBox["a", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["b", "1"], ",", " ", 
     SubscriptBox["b", "2"], ",", " ", 
     SubscriptBox["b", "3"]}], "}"}], ",", "Plus"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1112089236],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["a", "1"], " ", 
   SubscriptBox["b", "1"]}], "+", 
  RowBox[{
   SubscriptBox["a", "2"], " ", 
   SubscriptBox["b", "2"]}], "+", 
  RowBox[{
   SubscriptBox["a", "3"], " ", 
   SubscriptBox["b", "3"]}]}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->234351050]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2041796004],

Cell[TextData[{
 "Combining the products with ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 " gives the same as ",
 Cell[BoxData[
  ButtonBox["MapThread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapThread"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2081889962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inner", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "List"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1413008861],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "y"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "z"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150065196]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->755188356],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "y"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "z"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->235013225]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25995],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Outer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Outer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thread",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thread"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapThread",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapThread"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListCorrelate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListCorrelate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17564]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22595],

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StructuralOperations"]], "Tutorials",
 CellID->16070],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Tensors"]], "Tutorials",
 CellID->32069]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->7399854],

Cell[TextData[ButtonBox["Applying Functions to Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], "MoreAbout",
 CellID->49198896],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "MoreAbout",
 CellID->201691023]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Inner"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Inner - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 44.7116426}", "context" -> "System`", 
    "keywords" -> {
     "contraction of tensors", "generalized inner products", "inner product", 
      "scalar product", "divergence operator"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Inner[f, list_1, list_2, g] is a generalization of Dot in which f plays \
the role of multiplication and g of addition. ", "synonyms" -> {}, "title" -> 
    "Inner", "type" -> "Symbol", "uri" -> "ref/Inner"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8588, 300, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->127613464]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31647, 1216}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2344, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2967, 81, 42, 1, 70, "ObjectName",
 CellID->9429],
Cell[3012, 84, 1042, 34, 70, "Usage",
 CellID->7229]
}, Open  ]],
Cell[CellGroupData[{
Cell[4091, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4569, 140, 1388, 51, 70, "Notes",
 CellID->11187],
Cell[5960, 193, 803, 29, 70, "Notes",
 CellID->2431],
Cell[6766, 224, 601, 24, 70, "Notes",
 CellID->23503],
Cell[7370, 250, 615, 21, 70, "Notes",
 CellID->20406],
Cell[7988, 273, 563, 22, 70, "Notes",
 CellID->27050]
}, Closed]],
Cell[CellGroupData[{
Cell[8588, 300, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->127613464],
Cell[CellGroupData[{
Cell[8973, 314, 148, 5, 70, "ExampleSection",
 CellID->266336289],
Cell[9124, 321, 108, 2, 70, "ExampleText",
 CellID->202814341],
Cell[CellGroupData[{
Cell[9257, 327, 243, 8, 28, "Input",
 CellID->1199269900],
Cell[9503, 337, 317, 11, 36, "Output",
 CellID->109961840]
}, Open  ]],
Cell[9835, 351, 125, 3, 70, "ExampleDelimiter",
 CellID->221813303],
Cell[9963, 356, 111, 3, 70, "ExampleText",
 CellID->85212409],
Cell[CellGroupData[{
Cell[10099, 363, 348, 12, 70, "Input",
 CellID->175782609],
Cell[10450, 377, 543, 19, 36, "Output",
 CellID->82380952]
}, Open  ]],
Cell[11008, 399, 125, 3, 70, "ExampleDelimiter",
 CellID->110551329],
Cell[11136, 404, 66, 1, 70, "ExampleText",
 CellID->31939129],
Cell[CellGroupData[{
Cell[11227, 409, 248, 8, 70, "Input",
 CellID->49887403],
Cell[11478, 419, 225, 8, 36, "Output",
 CellID->21493641]
}, Open  ]],
Cell[CellGroupData[{
Cell[11740, 432, 273, 9, 70, "Input",
 CellID->1160202903],
Cell[12016, 443, 263, 9, 36, "Output",
 CellID->1500097650]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12328, 458, 216, 7, 70, "ExampleSection",
 CellID->11486],
Cell[12547, 467, 87, 1, 70, "ExampleText",
 CellID->106940317],
Cell[CellGroupData[{
Cell[12659, 472, 455, 16, 70, "Input",
 CellID->1254100186],
Cell[13117, 490, 1030, 35, 36, "Output",
 CellID->727713616]
}, Open  ]],
Cell[14162, 528, 125, 3, 70, "ExampleDelimiter",
 CellID->758734432],
Cell[14290, 533, 84, 1, 70, "ExampleText",
 CellID->1056004281],
Cell[CellGroupData[{
Cell[14399, 538, 348, 12, 70, "Input",
 CellID->191586286],
Cell[14750, 552, 544, 19, 36, "Output",
 CellID->154178026]
}, Open  ]],
Cell[15309, 574, 125, 3, 70, "ExampleDelimiter",
 CellID->788320221],
Cell[15437, 579, 83, 1, 70, "ExampleText",
 CellID->236121806],
Cell[CellGroupData[{
Cell[15545, 584, 348, 12, 70, "Input",
 CellID->571360600],
Cell[15896, 598, 544, 19, 36, "Output",
 CellID->115264624]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16489, 623, 239, 7, 70, "ExampleSection",
 CellID->24667],
Cell[16731, 632, 94, 1, 70, "ExampleText",
 CellID->1960322881],
Cell[CellGroupData[{
Cell[16850, 637, 467, 17, 70, "Input",
 CellID->631114584],
Cell[17320, 656, 1030, 35, 36, "Output",
 CellID->145739905]
}, Open  ]],
Cell[18365, 694, 126, 3, 70, "ExampleDelimiter",
 CellID->1791929846],
Cell[18494, 699, 258, 9, 70, "ExampleText",
 CellID->1722953700],
Cell[CellGroupData[{
Cell[18777, 712, 203, 6, 70, "Input",
 CellID->2042051005],
Cell[18983, 720, 236, 8, 36, "Output",
 CellID->23331941]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19268, 734, 223, 7, 70, "ExampleSection",
 CellID->21214],
Cell[19494, 743, 112, 3, 70, "ExampleText",
 CellID->450959685],
Cell[CellGroupData[{
Cell[19631, 750, 568, 20, 70, "Input",
 CellID->1601590653],
Cell[20202, 772, 693, 26, 61, "Output",
 CellID->75662211]
}, Open  ]],
Cell[20910, 801, 125, 3, 70, "ExampleDelimiter",
 CellID->608381825],
Cell[21038, 806, 81, 1, 70, "ExampleText",
 CellID->646804873],
Cell[CellGroupData[{
Cell[21144, 811, 487, 17, 70, "Input",
 CellID->252246212],
Cell[21634, 830, 315, 11, 36, "Output",
 CellID->165600286]
}, Open  ]],
Cell[21964, 844, 125, 3, 70, "ExampleDelimiter",
 CellID->631573049],
Cell[22092, 849, 105, 2, 70, "ExampleText",
 CellID->465355440],
Cell[CellGroupData[{
Cell[22222, 855, 316, 10, 70, "Input",
 CellID->878042529],
Cell[22541, 867, 301, 10, 36, "Output",
 CellID->749191115]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22891, 883, 232, 7, 70, "ExampleSection",
 CellID->1939],
Cell[23126, 892, 88, 1, 70, "ExampleText",
 CellID->868474426],
Cell[CellGroupData[{
Cell[23239, 897, 411, 14, 70, "Input",
 CellID->1859790047],
Cell[23653, 913, 397, 15, 36, "Output",
 CellID->75783272]
}, Open  ]],
Cell[24065, 931, 68, 1, 70, "ExampleText",
 CellID->278626398],
Cell[CellGroupData[{
Cell[24158, 936, 440, 14, 70, "Input",
 CellID->1112089236],
Cell[24601, 952, 398, 15, 36, "Output",
 CellID->234351050]
}, Open  ]],
Cell[25014, 970, 126, 3, 70, "ExampleDelimiter",
 CellID->2041796004],
Cell[25143, 975, 349, 13, 70, "ExampleText",
 CellID->2081889962],
Cell[CellGroupData[{
Cell[25517, 992, 266, 8, 70, "Input",
 CellID->1413008861],
Cell[25786, 1002, 376, 13, 36, "Output",
 CellID->150065196]
}, Open  ]],
Cell[CellGroupData[{
Cell[26199, 1020, 303, 10, 70, "Input",
 CellID->755188356],
Cell[26505, 1032, 376, 13, 36, "Output",
 CellID->235013225]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26942, 1052, 311, 9, 70, "SeeAlsoSection",
 CellID->25995],
Cell[27256, 1063, 1178, 44, 70, "SeeAlso",
 CellID->17564]
}, Open  ]],
Cell[CellGroupData[{
Cell[28471, 1112, 314, 9, 70, "TutorialsSection",
 CellID->22595],
Cell[28788, 1123, 152, 3, 70, "Tutorials",
 CellID->16070],
Cell[28943, 1128, 125, 3, 70, "Tutorials",
 CellID->32069]
}, Open  ]],
Cell[CellGroupData[{
Cell[29105, 1136, 317, 9, 70, "MoreAboutSection",
 CellID->7399854],
Cell[29425, 1147, 162, 3, 70, "MoreAbout",
 CellID->49198896],
Cell[29590, 1152, 126, 3, 70, "MoreAbout",
 CellID->201691023]
}, Open  ]],
Cell[CellGroupData[{
Cell[29753, 1160, 305, 8, 70, "RelatedLinksSection"],
Cell[30061, 1170, 383, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[30459, 1186, 27, 0, 70, "History"],
Cell[30489, 1188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

