(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26718,        827]
NotebookOptionsPosition[     22839,        700]
NotebookOutlinePosition[     24277,        740]
CellTagsIndexPosition[     24192,        735]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Requesting Input" :> 
          Documentation`HelpLookup["paclet:tutorial/RequestingInput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Requesting Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InputString" :> 
          Documentation`HelpLookup["paclet:ref/InputString"], "InputField" :> 
          Documentation`HelpLookup["paclet:ref/InputField"], "Import" :> 
          Documentation`HelpLookup["paclet:ref/Import"], "Read" :> 
          Documentation`HelpLookup["paclet:ref/Read"], "Get" :> 
          Documentation`HelpLookup["paclet:ref/Get"], "Dialog" :> 
          Documentation`HelpLookup["paclet:ref/Dialog"], "Button" :> 
          Documentation`HelpLookup["paclet:ref/Button"], "ChoiceDialog" :> 
          Documentation`HelpLookup["paclet:ref/ChoiceDialog"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InputString\"\>", 
       2->"\<\"InputField\"\>", 3->"\<\"Import\"\>", 4->"\<\"Read\"\>", 
       5->"\<\"Get\"\>", 6->"\<\"Dialog\"\>", 7->"\<\"Button\"\>", 
       8->"\<\"ChoiceDialog\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Input & Output in Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/BasicInputAndOutputInPrograms"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Dialog Boxes" :> 
          Documentation`HelpLookup["paclet:guide/DialogBoxes"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Basic Input & Output in Programs\"\>", 
       2->"\<\"Custom Interface Construction\"\>", 3->"\<\"Dialog Boxes\"\>", 
       4->"\<\"Procedural Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Input", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Input",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Input"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]interactively reads in one ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Input",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Input"], "[", 
       StyleBox["prompt", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]requests input, displaying ",
     Cell[BoxData[
      StyleBox["prompt", "TI"]], "InlineFormula"],
     " as a \"prompt\"."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Input",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Input"], "[", 
       RowBox[{
        StyleBox["prompt", "TI"], ",", 
        StyleBox["init", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]in a notebook front end uses ",
     Cell[BoxData[
      StyleBox["init", "TI"]], "InlineFormula"],
     " as the initial contents of the input field."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->28491]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " returns the expression it reads. "
}], "Notes",
 CellID->10365],

Cell[TextData[{
 "The operation of ",
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " may vary from one computer system to another. When a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end is used, ",
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " typically works through a dialog box. "
}], "Notes",
 CellID->32249],

Cell[TextData[{
 "When no front end is used, ",
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " reads from standard input. "
}], "Notes",
 CellID->30336],

Cell[TextData[{
 "If the standard input is a file, then ",
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["EndOfFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfFile"]], "InlineFormula"],
 " if you try to read past the end of the file. "
}], "Notes",
 CellID->28007],

Cell[TextData[{
 "On systems with textual input, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Input"], "[", "]"}]], "InlineFormula"],
 " uses ",
 Cell[BoxData["?"], "InlineFormula"],
 " as a prompt. "
}], "Notes",
 CellID->17646],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " is evaluated, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stops until the input has been read. "
}], "Notes",
 CellID->12436],

Cell[TextData[{
 "With a notebook front end, ",
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " by default puts up a dialog window with a standard appearance."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->896288002],

Cell["The prompt given can be text, graphics or any expression.", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->50064272],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " takes notebook options. The default settings include ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowFloating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowFloating"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowSize"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowTitle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowTitle"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24975032],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " by default puts up a dialog in the middle of the main display screen. \
Explicit settings for ",
 Cell[BoxData[
  ButtonBox["WindowMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
 " override this."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->6914],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["FieldSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FieldSize"]], "InlineFormula"],
 " can be used to specify the size of the field used for input."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->148938813],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Input"], "[", 
   StyleBox["prompt", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Input"], "[", 
   RowBox[{
    StyleBox["prompt", "TI"], ",", "\"\<\>\""}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->222766941]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->377046044],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->150089786],

Cell["Get an input expression and square it:", "ExampleText",
 CellID->44821838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Input", "[", "]"}], "^", "2"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->58185332],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"a", "+", "b"}], ")"}], "2"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34863730]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellContext->"Global`",
 CellID->160714057],

Cell["Request input of a function to plot:", "ExampleText",
 CellContext->"Global`",
 CellID->233088894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
    "Input", "[", 
     "\"\<Please input a function of x to plot on the unit interval\>\"", 
     "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->358387337],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 CellContext->"Global`",
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12514830]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30220],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputField"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Read",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Read"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChoiceDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChoiceDialog"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30809]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11227],

Cell[TextData[ButtonBox["Requesting Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RequestingInput"]], "Tutorials",
 CellID->32522]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->35461292],

Cell[TextData[ButtonBox["Basic Input & Output in Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicInputAndOutputInPrograms"]], "MoreAbout",
 CellID->84302814],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->386555298],

Cell[TextData[ButtonBox["Dialog Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DialogBoxes"]], "MoreAbout",
 CellID->839935859],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->395050361]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Input - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 53.6337460}", "context" -> "System`", 
    "keywords" -> {
     "front end", "reading files", "requesting input", "input dialog", 
      "input prompt"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Input[] interactively reads in one Mathematica expression. Input[prompt] \
requests input, displaying prompt as a \"prompt\". Input[prompt, init] in a \
notebook front end uses init as the initial contents of the input field.", 
    "synonyms" -> {}, "title" -> "Input", "type" -> "Symbol", "uri" -> 
    "ref/Input"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14659, 433, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->377046044]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24048, 728}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2907, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3530, 91, 4189, 83, 70, "ObjectNameGrid"],
Cell[7722, 176, 1357, 43, 70, "Usage",
 CellID->28491]
}, Open  ]],
Cell[CellGroupData[{
Cell[9116, 224, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9594, 241, 195, 7, 70, "Notes",
 CellID->10365],
Cell[9792, 250, 468, 16, 70, "Notes",
 CellID->32249],
Cell[10263, 268, 221, 8, 70, "Notes",
 CellID->30336],
Cell[10487, 278, 385, 13, 70, "Notes",
 CellID->28007],
Cell[10875, 293, 286, 11, 70, "Notes",
 CellID->17646],
Cell[11164, 306, 278, 11, 70, "Notes",
 CellID->12436],
Cell[11445, 319, 390, 11, 70, "Notes",
 CellID->896288002],
Cell[11838, 332, 223, 4, 70, "Notes",
 CellID->50064272],
Cell[12064, 338, 1059, 37, 70, "Notes",
 CellID->24975032],
Cell[13126, 377, 534, 16, 70, "Notes",
 CellID->6914],
Cell[13663, 395, 380, 11, 70, "Notes",
 CellID->148938813],
Cell[14046, 408, 576, 20, 70, "Notes",
 CellID->222766941]
}, Closed]],
Cell[CellGroupData[{
Cell[14659, 433, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->377046044],
Cell[CellGroupData[{
Cell[15044, 447, 148, 5, 70, "ExampleSection",
 CellID->150089786],
Cell[15195, 454, 80, 1, 70, "ExampleText",
 CellID->44821838],
Cell[CellGroupData[{
Cell[15300, 459, 143, 5, 28, "Input",
 CellID->58185332],
Cell[15446, 466, 227, 8, 36, "Output",
 CellID->34863730]
}, Open  ]],
Cell[15688, 477, 150, 4, 70, "ExampleDelimiter",
 CellID->160714057],
Cell[15841, 483, 104, 2, 70, "ExampleText",
 CellID->233088894],
Cell[CellGroupData[{
Cell[15970, 489, 358, 12, 47, "Input",
 CellID->358387337],
Cell[16331, 503, 2636, 48, 137, "Output",
 Evaluatable->False,
 CellID->12514830]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19028, 558, 311, 9, 70, "SeeAlsoSection",
 CellID->30220],
Cell[19342, 569, 1909, 71, 70, "SeeAlso",
 CellID->30809]
}, Open  ]],
Cell[CellGroupData[{
Cell[21288, 645, 314, 9, 70, "TutorialsSection",
 CellID->11227],
Cell[21605, 656, 142, 3, 70, "Tutorials",
 CellID->32522]
}, Open  ]],
Cell[CellGroupData[{
Cell[21784, 664, 318, 9, 70, "MoreAboutSection",
 CellID->35461292],
Cell[22105, 675, 172, 3, 70, "MoreAbout",
 CellID->84302814],
Cell[22280, 680, 168, 3, 70, "MoreAbout",
 CellID->386555298],
Cell[22451, 685, 135, 3, 70, "MoreAbout",
 CellID->839935859],
Cell[22589, 690, 155, 3, 70, "MoreAbout",
 CellID->395050361]
}, Open  ]],
Cell[22759, 696, 50, 0, 70, "History"],
Cell[22812, 698, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

