(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51124,       1798]
NotebookOptionsPosition[     42475,       1507]
NotebookOutlinePosition[     44346,       1552]
CellTagsIndexPosition[     44260,       1547]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dynamic" :> Documentation`HelpLookup["paclet:ref/Dynamic"], 
          "PopupMenu" :> Documentation`HelpLookup["paclet:ref/PopupMenu"], 
          "Deploy" :> Documentation`HelpLookup["paclet:ref/Deploy"], "Input" :> 
          Documentation`HelpLookup["paclet:ref/Input"], "Dialog" :> 
          Documentation`HelpLookup["paclet:ref/Dialog"], "FileNameSetter" :> 
          Documentation`HelpLookup["paclet:ref/FileNameSetter"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dynamic\"\>", 
       2->"\<\"PopupMenu\"\>", 3->"\<\"Deploy\"\>", 4->"\<\"Input\"\>", 
       5->"\<\"Dialog\"\>", 6->"\<\"FileNameSetter\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Creating Inspectors" :> 
          Documentation`HelpLookup["paclet:guide/CreatingInspectors"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "Toolbars" :> Documentation`HelpLookup["paclet:guide/Toolbars"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Creating Inspectors\"\>", 
       3->"\<\"Custom Interface Construction\"\>", 
       4->"\<\"Stand-Alone Interfaces\"\>", 5->"\<\"Toolbars\"\>", 
       6->"\<\"New in 6.0: Dynamic Interactivity\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["InputField", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InputField",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InputField"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a blank editable input field. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InputField",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InputField"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an editable input field that currently \
contains the expression ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InputField",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InputField"], "[", 
       RowBox[{
        ButtonBox["Dynamic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Dynamic"], "[", 
        StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the contents of the input field to be the \
dynamically updated current value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " being reset if new contents are entered. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InputField",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InputField"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        ButtonBox["String",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/String"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an input field whose contents are taken to \
be a string. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InputField",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InputField"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        ButtonBox["Number",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Number"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an input field whose contents are taken to \
be a number. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InputField",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InputField"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an input field whose contents are taken to \
be of the specified type. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->27132]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following are possible types: ", "Notes",
 CellID->21724],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "Boxes", Cell[
    "raw boxes ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Expression",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Expression"], Cell[
    "expression (default) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Hold",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Hold"], "[", 
     ButtonBox["Expression",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Expression"], "]"}], Cell[
    "expression in held form ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Number",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Number"], Cell["number ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["String",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/String"], Cell["string ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->19495],

Cell[TextData[{
 "The setting for the input field is not updated until its contents are \
explicitly entered, typically by pressing ",
 StyleBox["Enter", "KeyEvent"],
 " or by moving focus away from the input field. "
}], "Notes",
 CellID->6197],

Cell["\<\
If the data given in the input field cannot be converted to the type \
specified, then the setting for the input field will not be updated. \
\>", "Notes",
 CellID->20779],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"],
 " and ",
 Cell[BoxData["Boxes"], "InlineFormula"],
 " types the conversion can always be done. "
}], "Notes",
 CellID->30231],

Cell[TextData[{
 "For expressions, a blank input field is taken to have value ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ". For strings, it is taken to have value ",
 Cell[BoxData["\"\<\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25172],

Cell[TextData[{
 StyleBox["Tab", "KeyEvent"],
 " moves between input fields. "
}], "Notes",
 CellID->27982],

Cell["The following options can be given: ", "Notes",
 CellID->31556],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the input field ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the input field", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContinuousAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContinuousAction"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to update continuously every time any change is made to the input\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the input field is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FieldSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FieldSize"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"20.", ",", " ", "20."}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.", ",", 
        ButtonBox["Infinity",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Infinity"]}], "}"}]}], "}"}], Cell[
    "the size of the input field ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the displayed input field ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size of the displayed input field ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->10982],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Appearance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Appearance"]], "InlineFormula"],
 " include ",
 Cell[BoxData["\"\<Framed\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Frameless\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15743],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InputField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputField"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InputField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputField"], "[", 
   ButtonBox["Null",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Null"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18362],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<InputField\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->184788216],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->78448368],

Cell[TextData[{
 "Dynamically update the variable via the ",
 Cell[BoxData[
  ButtonBox["InputField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputField"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->26014769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InputField", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->253431506],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InputFieldBox[Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{298, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->733199528]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->436063580],

Cell["Restrict the input to a specific type:", "ExampleText",
 CellID->253591526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputField", "[", 
  RowBox[{"1", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314657207],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`i$$ = 1}, 
   InputFieldBox[Dynamic[Typeset`i$$], Number],
   DynamicModuleValues:>{}],
  InputField[
   Setting[#], Number]& ]], "Output",
 ImageSize->{265, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->443583802]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputField", "[", 
  RowBox[{"\"\<a\>\"", ",", "String"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37308142],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`i$$ = "a"}, 
   InputFieldBox[Dynamic[Typeset`i$$], String],
   DynamicModuleValues:>{}],
  InputField[
   Setting[#], String]& ]], "Output",
 ImageSize->{265, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->171489807]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->368840894],

Cell[TextData[{
 "Use ",
 StyleBox["Tab", "KeyEvent"],
 " to move between input fields:"
}], "ExampleText",
 CellID->281380085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InputField", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FieldSize", "\[Rule]", "10"}]}], "]"}], ",", 
   RowBox[{"InputField", "[", 
    RowBox[{"y", ",", 
     RowBox[{"FieldSize", "\[Rule]", "10"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126820833],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
     InputFieldBox[Dynamic[Typeset`i$$],
      FieldSize->10],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#], FieldSize -> 10]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = $CellContext`y}, 
     InputFieldBox[Dynamic[Typeset`i$$],
      FieldSize->10],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#], FieldSize -> 10]& ]}], "}"}]], "Output",
 ImageSize->{300, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121456301]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->553173772],

Cell["\<\
The input field will not be updated if the input is not of the specified \
type:\
\>", "ExampleText",
 CellID->748079618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputField", "[", 
  RowBox[{"1", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41857232],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`i$$ = 1}, 
   InputFieldBox[Dynamic[Typeset`i$$], Number],
   DynamicModuleValues:>{}],
  InputField[
   Setting[#], Number]& ]], "Output",
 ImageSize->{265, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17123534]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->155546460],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->230742493],

Cell[TextData[{
 "Display ",
 Cell[BoxData[
  ButtonBox["InputField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputField"]], "InlineFormula"],
 " without a frame:"
}], "ExampleText",
 CellID->93491856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"InputField", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Framed\>\"", ",", "\"\<Frameless\>\""}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19856661],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
     InputFieldBox[Dynamic[Typeset`i$$],
      Appearance->"Framed"],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#], Appearance -> "Framed"]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
     InputFieldBox[Dynamic[Typeset`i$$],
      Appearance->"Frameless"],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#], Appearance -> "Frameless"]& ]}], "}"}]], "Output",
 ImageSize->{542, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->269868512]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->361742915],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["InputField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputField"]], "InlineFormula"],
 " is enabled: "
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputField", "[", "0.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94729581],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`i$$ = 0.5}, 
   InputFieldBox[Dynamic[Typeset`i$$]],
   DynamicModuleValues:>{}],
  InputField[
   Setting[#]]& ]], "Output",
 ImageSize->{265, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71747497]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29667437],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], "\[Rule]", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the field is disabled but visible in its current state:"
}], "ExampleText",
 CellID->576258550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputField", "[", 
  RowBox[{"0.3", ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227336428],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`i$$ = 0.3}, 
   InputFieldBox[Dynamic[Typeset`i$$],
    Enabled->False],
   DynamicModuleValues:>{}],
  InputField[
   Setting[#], Enabled -> False]& ]], "Output",
 ImageSize->{265, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->722887813]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FieldSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->11189714],

Cell["Alter the field width:", "ExampleText",
 CellID->170464553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"InputField", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FieldSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "5", ",", "10"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->211289354],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
     InputFieldBox[Dynamic[Typeset`i$$],
      FieldSize->3],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#], FieldSize -> 3]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
     InputFieldBox[Dynamic[Typeset`i$$],
      FieldSize->5],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#], FieldSize -> 5]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
     InputFieldBox[Dynamic[Typeset`i$$],
      FieldSize->10],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#], FieldSize -> 10]& ]}], "}"}]], "Output",
 ImageSize->{295, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80547354]
}, Open  ]],

Cell["Adjust the height and width:", "ExampleText",
 CellID->164344496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"InputField", "[", 
     RowBox[{"x", ",", 
      RowBox[{"FieldSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "5"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "5", ",", "10"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->271526948],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        FieldSize->{3, 1}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], FieldSize -> {3, 1}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        FieldSize->{5, 1}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], FieldSize -> {5, 1}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        FieldSize->{10, 1}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], FieldSize -> {10, 1}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        FieldSize->{3, 3}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], FieldSize -> {3, 3}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        FieldSize->{5, 3}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], FieldSize -> {5, 3}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        FieldSize->{10, 3}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], FieldSize -> {10, 3}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        FieldSize->{3, 5}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], FieldSize -> {3, 5}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        FieldSize->{5, 5}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], FieldSize -> {5, 5}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        FieldSize->{10, 5}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], FieldSize -> {10, 5}]& ]}
   }],
  "Grid"]], "Output",
 ImageSize->{274, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->124444132]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->361031283],

Cell["Set the width of the field:", "ExampleText",
 CellID->61510325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"InputField", "[", 
    RowBox[{"x", ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"30", ",", "50", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->196544841],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
     InputFieldBox[Dynamic[Typeset`i$$],
      ImageSize->30],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#], ImageSize -> 30]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
     InputFieldBox[Dynamic[Typeset`i$$],
      ImageSize->50],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#], ImageSize -> 50]& ], ",", 
   TagBox[
    DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
     InputFieldBox[Dynamic[Typeset`i$$],
      ImageSize->100],
     DynamicModuleValues:>{}],
    InputField[
     Setting[#], ImageSize -> 100]& ]}], "}"}]], "Output",
 ImageSize->{221, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->776726709]
}, Open  ]],

Cell["Set the overall size of the field:", "ExampleText",
 CellID->15922789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"InputField", "[", 
     RowBox[{"x", ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "40", ",", "70"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"30", ",", "50", ",", "70"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->261837333],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        ImageSize->{30, 20}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], ImageSize -> {30, 20}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        ImageSize->{50, 20}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], ImageSize -> {50, 20}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        ImageSize->{70, 20}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], ImageSize -> {70, 20}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        ImageSize->{30, 40}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], ImageSize -> {30, 40}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        ImageSize->{50, 40}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], ImageSize -> {50, 40}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        ImageSize->{70, 40}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], ImageSize -> {70, 40}]& ]},
    {
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        ImageSize->{30, 70}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], ImageSize -> {30, 70}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        ImageSize->{50, 70}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], ImageSize -> {50, 70}]& ], 
     TagBox[
      DynamicModuleBox[{Typeset`i$$ = $CellContext`x}, 
       InputFieldBox[Dynamic[Typeset`i$$],
        ImageSize->{70, 70}],
       DynamicModuleValues:>{}],
      InputField[
       Setting[#], ImageSize -> {70, 70}]& ]}
   }],
  "Grid"]], "Output",
 ImageSize->{170, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->162254557]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->95050065],

Cell["Plot any function:", "ExampleText",
 CellID->529396048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Panel", "[", 
  RowBox[{"DynamicModule", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", "=", 
      RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
    RowBox[{"Column", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"InputField", "[", 
        RowBox[{"Dynamic", "[", "f", "]"}], "]"}], ",", 
       RowBox[{"Dynamic", "[", 
        RowBox[{"Plot", "[", 
         RowBox[{"f", ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], "]"}]}], "}"}], 
     "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->226057322],

Cell[BoxData[
 PanelBox[
  DynamicModuleBox[{$CellContext`f$$ = Sin[$CellContext`x]}, 
   TagBox[GridBox[{
      {
       InputFieldBox[Dynamic[$CellContext`f$$]]},
      {
       DynamicBox[ToBoxes[
         Plot[$CellContext`f$$, {$CellContext`x, -5, 5}], StandardForm],
        ImageSizeCache->{180., {57., 62.}}]}
     },
     ColumnsEqual->False,
     GridBoxAlignment->{"Columns" -> {{Left}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Column"],
   DynamicModuleValues:>{}]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{206, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1314056808]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->118261434],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Manipulator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulator"]], "InlineFormula"],
 " is constructed with ",
 Cell[BoxData[
  ButtonBox["InputField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputField"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->123867317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Manipulator", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137115766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    PaneBox[
     DynamicModuleBox[{Typeset`open$$ = True, Typeset`paused$$ = 0, 
      Typeset`rate$$ = Automatic, Typeset`dir$$ = Forward}, 
      StyleBox[
       DynamicBox[FEPrivate`FrontEndResource[
        "FEExpressions", "Manipulator04"][
         Dynamic[$CellContext`x], 
         Dynamic[$CellContext`x], {0, 1}, Medium, Small, Automatic, True, 
         Automatic, False, True, True, All, False, {}, 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`paused$$], 
         Dynamic[Typeset`rate$$], 
         Dynamic[Typeset`dir$$]],
        ImageSizeCache->{212., {34., 14.}}],
       DynamicUpdating->True],
      DynamicModuleValues:>{}],
     BaselinePosition->Baseline,
     ImageMargins->0],
    Manipulate`InterpretManipulator[
     Dynamic[$CellContext`x], {0, 1}, {Appearance -> "Open"}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{256, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->486764433]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Slider", "[", 
     RowBox[{"Dynamic", "[", "y", "]"}], "]"}], ",", 
    RowBox[{"InputField", "[", 
     RowBox[{"Dynamic", "[", "y", "]"}], "]"}]}], "}"}], "//", 
  "Column"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->339964805],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SliderBox[Dynamic[$CellContext`y]]},
    {
     InputFieldBox[Dynamic[$CellContext`y]]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{265, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->778545307]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->752837619],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputField"]], "InlineFormula"],
 " will remain unevaluated if the expression does not match the type:"
}], "ExampleText",
 CellID->673292282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputField", "[", 
  RowBox[{"\"\<a\>\"", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->601064704],

Cell[BoxData[
 RowBox[{"InputField", "[", 
  RowBox[{"\<\"a\"\>", ",", "Number"}], "]"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325219820]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputField", "[", 
  RowBox[{"2", ",", "Number"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19775064],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{Typeset`i$$ = 2}, 
   InputFieldBox[Dynamic[Typeset`i$$], Number],
   DynamicModuleValues:>{}],
  InputField[
   Setting[#], Number]& ]], "Output",
 ImageSize->{265, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1517456]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19586],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupMenu"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Deploy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Deploy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Input"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileNameSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNameSetter"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13279]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1207],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->404785301],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->119642292],

Cell[TextData[ButtonBox["Creating Inspectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingInspectors"]], "MoreAbout",
 CellID->67975148],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->527352507],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->182479373],

Cell[TextData[ButtonBox["Toolbars",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Toolbars"]], "MoreAbout",
 CellID->271203199],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->331044238]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InputField - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 52.3055870}", "context" -> "System`", 
    "keywords" -> {
     "input bar", "input box", "text field", "number field", 
      "expression field", "user input field", "forms"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InputField[] represents a blank editable input field. InputField[x] \
represents an editable input field that currently contains the expression x. \
InputField[Dynamic[x]] takes the contents of the input field to be the \
dynamically updated current value of x, with the value of x being reset if \
new contents are entered. InputField[x, String] represents an input field \
whose contents are taken to be a string. InputField[x, Number] represents an \
input field whose contents are taken to be a number. InputField[x, type] \
represents an input field whose contents are taken to be of the specified \
type. ", "synonyms" -> {"input field"}, "title" -> "InputField", "type" -> 
    "Symbol", "uri" -> "ref/InputField"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15099, 450, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->184788216]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 44116, 1540}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3151, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3774, 96, 1575, 37, 70, "ObjectNameGrid"],
Cell[5352, 135, 2873, 87, 70, "Usage",
 CellID->27132]
}, Open  ]],
Cell[CellGroupData[{
Cell[8262, 227, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8740, 244, 67, 1, 70, "Notes",
 CellID->21724],
Cell[8810, 247, 1299, 34, 70, "2ColumnTableMod",
 CellID->19495],
Cell[10112, 283, 245, 6, 70, "Notes",
 CellID->6197],
Cell[10360, 291, 181, 4, 70, "Notes",
 CellID->20779],
Cell[10544, 297, 266, 10, 70, "Notes",
 CellID->30231],
Cell[10813, 309, 317, 10, 70, "Notes",
 CellID->25172],
Cell[11133, 321, 107, 4, 70, "Notes",
 CellID->27982],
Cell[11243, 327, 69, 1, 70, "Notes",
 CellID->31556],
Cell[11315, 330, 2611, 70, 70, "3ColumnTableMod",
 CellID->10982],
Cell[13929, 402, 329, 12, 70, "Notes",
 CellID->15743],
Cell[14261, 416, 451, 17, 70, "Notes",
 CellID->18362],
Cell[14715, 435, 347, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[15099, 450, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->184788216],
Cell[CellGroupData[{
Cell[15484, 464, 147, 5, 70, "ExampleSection",
 CellID->78448368],
Cell[15634, 471, 226, 8, 70, "ExampleText",
 CellID->26014769],
Cell[CellGroupData[{
Cell[15885, 483, 224, 7, 28, "Input",
 CellID->253431506],
Cell[16112, 492, 329, 10, 43, "Output",
 CellID->733199528]
}, Open  ]],
Cell[16456, 505, 125, 3, 70, "ExampleDelimiter",
 CellID->436063580],
Cell[16584, 510, 81, 1, 70, "ExampleText",
 CellID->253591526],
Cell[CellGroupData[{
Cell[16690, 515, 134, 4, 70, "Input",
 CellID->314657207],
Cell[16827, 521, 321, 11, 70, "Output",
 CellID->443583802]
}, Open  ]],
Cell[CellGroupData[{
Cell[17185, 537, 141, 4, 70, "Input",
 CellID->37308142],
Cell[17329, 543, 323, 11, 70, "Output",
 CellID->171489807]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17701, 560, 220, 7, 70, "ExampleSection",
 CellID->368840894],
Cell[17924, 569, 127, 5, 70, "ExampleText",
 CellID->281380085],
Cell[CellGroupData[{
Cell[18076, 578, 323, 10, 70, "Input",
 CellID->126820833],
Cell[18402, 590, 622, 21, 70, "Output",
 CellID->121456301]
}, Open  ]],
Cell[19039, 614, 125, 3, 70, "ExampleDelimiter",
 CellID->553173772],
Cell[19167, 619, 131, 4, 70, "ExampleText",
 CellID->748079618],
Cell[CellGroupData[{
Cell[19323, 627, 133, 4, 70, "Input",
 CellID->41857232],
Cell[19459, 633, 320, 11, 70, "Output",
 CellID->17123534]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19828, 650, 222, 7, 70, "ExampleSection",
 CellID->155546460],
Cell[CellGroupData[{
Cell[20075, 661, 231, 7, 70, "ExampleSubsection",
 CellID->230742493],
Cell[20309, 670, 210, 8, 70, "ExampleText",
 CellID->93491856],
Cell[CellGroupData[{
Cell[20544, 682, 361, 12, 70, "Input",
 CellID->19856661],
Cell[20908, 696, 656, 21, 70, "Output",
 CellID->269868512]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21613, 723, 228, 7, 70, "ExampleSubsection",
 CellID->361742915],
Cell[21844, 732, 210, 8, 70, "ExampleText",
 CellID->154813376],
Cell[CellGroupData[{
Cell[22079, 744, 107, 3, 70, "Input",
 CellID->94729581],
Cell[22189, 749, 306, 11, 70, "Output",
 CellID->71747497]
}, Open  ]],
Cell[22510, 763, 124, 3, 70, "ExampleDelimiter",
 CellID->29667437],
Cell[22637, 768, 358, 12, 70, "ExampleText",
 CellID->576258550],
Cell[CellGroupData[{
Cell[23020, 784, 171, 5, 70, "Input",
 CellID->227336428],
Cell[23194, 791, 345, 12, 70, "Output",
 CellID->722887813]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23588, 809, 229, 7, 70, "ExampleSubsection",
 CellID->11189714],
Cell[23820, 818, 65, 1, 70, "ExampleText",
 CellID->170464553],
Cell[CellGroupData[{
Cell[23910, 823, 340, 11, 70, "Input",
 CellID->211289354],
Cell[24253, 836, 836, 28, 70, "Output",
 CellID->80547354]
}, Open  ]],
Cell[25104, 867, 71, 1, 70, "ExampleText",
 CellID->164344496],
Cell[CellGroupData[{
Cell[25200, 872, 565, 19, 70, "Input",
 CellID->271526948],
Cell[25768, 893, 2339, 74, 70, "Output",
 CellID->124444132]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28156, 973, 230, 7, 70, "ExampleSubsection",
 CellID->361031283],
Cell[28389, 982, 69, 1, 70, "ExampleText",
 CellID->61510325],
Cell[CellGroupData[{
Cell[28483, 987, 345, 12, 70, "Input",
 CellID->196544841],
Cell[28831, 1001, 843, 28, 70, "Output",
 CellID->776726709]
}, Open  ]],
Cell[29689, 1032, 76, 1, 70, "ExampleText",
 CellID->15922789],
Cell[CellGroupData[{
Cell[29790, 1037, 570, 19, 70, "Input",
 CellID->261837333],
Cell[30363, 1058, 2369, 74, 70, "Output",
 CellID->162254557]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[32793, 1139, 226, 7, 70, "ExampleSection",
 CellID->95050065],
Cell[33022, 1148, 61, 1, 70, "ExampleText",
 CellID->529396048],
Cell[CellGroupData[{
Cell[33108, 1153, 633, 20, 70, "Input",
 CellID->226057322],
Cell[33744, 1175, 739, 23, 70, "Output",
 CellID->1314056808]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34532, 1204, 237, 7, 70, "ExampleSection",
 CellID->118261434],
Cell[34772, 1213, 333, 12, 70, "ExampleText",
 CellID->123867317],
Cell[CellGroupData[{
Cell[35130, 1229, 303, 9, 70, "Input",
 CellID->137115766],
Cell[35436, 1240, 1118, 30, 70, "Output",
 CellID->486764433]
}, Open  ]],
Cell[CellGroupData[{
Cell[36591, 1275, 296, 10, 70, "Input",
 CellID->339964805],
Cell[36890, 1287, 338, 13, 70, "Output",
 CellID->778545307]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37277, 1306, 230, 7, 70, "ExampleSection",
 CellID->752837619],
Cell[37510, 1315, 248, 7, 70, "ExampleText",
 CellID->673292282],
Cell[CellGroupData[{
Cell[37783, 1326, 142, 4, 70, "Input",
 CellID->601064704],
Cell[37928, 1332, 231, 7, 36, "Output",
 CellID->325219820]
}, Open  ]],
Cell[CellGroupData[{
Cell[38196, 1344, 133, 4, 70, "Input",
 CellID->19775064],
Cell[38332, 1350, 319, 11, 70, "Output",
 CellID->1517456]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38712, 1368, 311, 9, 70, "SeeAlsoSection",
 CellID->19586],
Cell[39026, 1379, 1429, 53, 70, "SeeAlso",
 CellID->13279]
}, Open  ]],
Cell[CellGroupData[{
Cell[40492, 1437, 313, 9, 70, "TutorialsSection",
 CellID->1207],
Cell[40808, 1448, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[40970, 1453, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[41155, 1461, 319, 9, 70, "MoreAboutSection",
 CellID->404785301],
Cell[41477, 1472, 141, 3, 70, "MoreAbout",
 CellID->119642292],
Cell[41621, 1477, 148, 3, 70, "MoreAbout",
 CellID->67975148],
Cell[41772, 1482, 168, 3, 70, "MoreAbout",
 CellID->527352507],
Cell[41943, 1487, 154, 3, 70, "MoreAbout",
 CellID->182479373],
Cell[42100, 1492, 128, 3, 70, "MoreAbout",
 CellID->271203199],
Cell[42231, 1497, 172, 3, 70, "MoreAbout",
 CellID->331044238]
}, Open  ]],
Cell[42418, 1503, 27, 0, 70, "History"],
Cell[42448, 1505, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

