(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18955,        662]
NotebookOptionsPosition[     15197,        535]
NotebookOutlinePosition[     16534,        572]
CellTagsIndexPosition[     16449,        567]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebooks" :> Documentation`HelpLookup["paclet:ref/Notebooks"],
           "SelectedNotebook" :> 
          Documentation`HelpLookup["paclet:ref/SelectedNotebook"], 
          "EvaluationNotebook" :> 
          Documentation`HelpLookup["paclet:ref/EvaluationNotebook"], 
          "ButtonNotebook" :> 
          Documentation`HelpLookup["paclet:ref/ButtonNotebook"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Notebooks\"\>", 
       2->"\<\"SelectedNotebook\"\>", 3->"\<\"EvaluationNotebook\"\>", 
       4->"\<\"ButtonNotebook\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InputNotebook", "ObjectName",
 CellID->21780],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InputNotebook",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InputNotebook"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives the current notebook into which keyboard input in \
the front end will be directed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27582]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputNotebook"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15371],

Cell[TextData[{
 "If there is no current input notebook, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InputNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputNotebook"], "[", "]"}]], "InlineFormula"],
 " will return ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13237],

Cell["\<\
The current input notebook is the notebook to which textual commands in the \
front end are normally directed. \
\>", "Notes",
 CellID->25270],

Cell["\<\
A palette window can be a currently selected notebook but cannot normally be \
an input notebook. \
\>", "Notes",
 CellID->25764]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->123155836],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->12027114],

Cell["Give the notebook object for the current input notebook:", "ExampleText",
 CellID->246868896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputNotebook", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178178888],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["njg_shm", 1, 1]], 66]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       TagBox[
        TooltipBox["\<\"InputNotebook - Wolfram Mathematica\"\>",
         "\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\Documentation\\\\English\\\\System\\\\\
ReferencePages\\\\Symbols\\\\InputNotebook.nb\""],
        Annotation[#, 
         "C:\\Program Files\\Wolfram \
Research\\Mathematica\\6.0\\Documentation\\English\\System\\ReferencePages\\\
Symbols\\InputNotebook.nb", "Tooltip"]& ]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["njg_shm", 1, 1]], 66],
  Editable->False]], "Output",
 ImageSize->{348, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17666498]
}, Open  ]],

Cell["Perform additional operations:", "ExampleText",
 CellID->233943367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"%", ",", "WindowSize"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->292233033],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"WindowSize", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"720", ",", "734"}], "}"}]}], "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->559959542]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->325976531],

Cell["\<\
The notebook that starts an evaluation might not be the input notebook:\
\>", "ExampleText",
 CellID->130402128],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", "\"\<document\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InputNotebook", "[", "]"}], ",", 
   RowBox[{"EvaluationNotebook", "[", "]"}]}], "}"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->392519421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{"NotebookObject", "[", 
     PanelBox[GridBox[{
        {
         TooltipBox[
          ButtonBox[
           
           DynamicBox[FEPrivate`FrontEndResource[
            "FEBitmaps", "ManipulatePasteIcon"],
            ImageSizeCache->{13., {4., 9.}}],
           BaseStyle->{},
           ButtonFrame->None,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetSelectedNotebook[
               NotebookObject[
                FrontEndObject[
                 LinkObject["njg_shm", 1, 1]], 71]]}],
           Evaluator->None,
           Method->"Queued"],
          "Bring this notebook to the front"], 
         StyleBox["\<\"Untitled-1\"\>",
          StripOnInput->False,
          FontColor->GrayLevel[0.5]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]], "]"}],
    NotebookObject[
     FrontEndObject[
      LinkObject["njg_shm", 1, 1]], 71],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{"NotebookObject", "[", 
     PanelBox[GridBox[{
        {
         TooltipBox[
          ButtonBox[
           
           DynamicBox[FEPrivate`FrontEndResource[
            "FEBitmaps", "ManipulatePasteIcon"],
            ImageSizeCache->{13., {4., 9.}}],
           BaseStyle->{},
           ButtonFrame->None,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetSelectedNotebook[
               NotebookObject[
                FrontEndObject[
                 LinkObject["njg_shm", 1, 1]], 69]]}],
           Evaluator->None,
           Method->"Queued"],
          "Bring this notebook to the front"], 
         TagBox[
          TooltipBox["\<\"InputNotebook - Wolfram Mathematica\"\>",
           
           "\"C:\\\\Program Files\\\\Wolfram Research\\\\Mathematica\\\\6.0\\\
\\Documentation\\\\English\\\\System\\\\ReferencePages\\\\Symbols\\\\\
InputNotebook.nb\""],
          
          Annotation[#, 
           "C:\\Program Files\\Wolfram \
Research\\Mathematica\\6.0\\Documentation\\English\\System\\ReferencePages\\\
Symbols\\InputNotebook.nb", "Tooltip"]& ]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]], "]"}],
    NotebookObject[
     FrontEndObject[
      LinkObject["njg_shm", 1, 1]], 69],
    Editable->False]}], "}"}]], "Output",
 ImageSize->{579, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39967834]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->54742845],

Cell["\<\
Both programmed operations and user interactions can change which notebook is \
taking input:\
\>", "ExampleText",
 CellID->79588227],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"WindowTitle", "\[Rule]", "\"\<Other\>\""}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312785252],

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{
   RowBox[{"SetSelectedNotebook", "[", 
    RowBox[{"EvaluationNotebook", "[", "]"}], "]"}], ";", 
   RowBox[{"snb1", "=", 
    RowBox[{"InputNotebook", "[", "]"}]}], ";", "\[IndentingNewLine]", 
   RowBox[{"SetSelectedNotebook", "[", "nb", "]"}], ";", 
   RowBox[{"snb2", "=", 
    RowBox[{"InputNotebook", "[", "]"}]}], ";"}], ")"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->241184568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<WindowTitle\>\"", "/.", 
  RowBox[{"NotebookInformation", "/@", 
   RowBox[{"{", 
    RowBox[{"snb1", ",", "snb2"}], "}"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->302472505],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"InputNotebook.nb\"\>", ",", "\<\"Other\"\>"}], "}"}]], "Output",\

 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->56857989]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13095],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Notebooks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Notebooks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectedNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectedNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluationNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluationNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButtonNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ButtonNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9710]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32565],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->9953]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->138666222]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InputNotebook - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 54.1962604}", "context" -> "System`", 
    "keywords" -> {
     "focus notebook", "input focus", "keyboard notebook", "target notebook"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InputNotebook[] gives the current notebook into which keyboard input in \
the front end will be directed. ", "synonyms" -> {"input notebook"}, "title" -> 
    "InputNotebook", "type" -> "Symbol", "uri" -> "ref/InputNotebook"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4994, 168, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->123155836]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16306, 560}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2235, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2858, 82, 51, 1, 70, "ObjectName",
 CellID->21780],
Cell[2912, 85, 520, 16, 70, "Usage",
 CellID->27582]
}, Open  ]],
Cell[CellGroupData[{
Cell[3469, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3947, 123, 326, 12, 70, "Notes",
 CellID->15371],
Cell[4276, 137, 384, 14, 70, "Notes",
 CellID->13237],
Cell[4663, 153, 152, 4, 70, "Notes",
 CellID->25270],
Cell[4818, 159, 139, 4, 70, "Notes",
 CellID->25764]
}, Closed]],
Cell[CellGroupData[{
Cell[4994, 168, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->123155836],
Cell[CellGroupData[{
Cell[5379, 182, 147, 5, 70, "ExampleSection",
 CellID->12027114],
Cell[5529, 189, 99, 1, 70, "ExampleText",
 CellID->246868896],
Cell[CellGroupData[{
Cell[5653, 194, 104, 3, 28, "Input",
 CellID->178178888],
Cell[5760, 199, 1443, 41, 60, "Output",
 CellID->17666498]
}, Open  ]],
Cell[7218, 243, 73, 1, 70, "ExampleText",
 CellID->233943367],
Cell[CellGroupData[{
Cell[7316, 248, 135, 4, 28, "Input",
 CellID->292233033],
Cell[7454, 254, 272, 9, 36, "Output",
 CellID->559959542]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7775, 269, 237, 7, 70, "ExampleSection",
 CellID->325976531],
Cell[8015, 278, 122, 3, 70, "ExampleText",
 CellID->130402128],
Cell[CellGroupData[{
Cell[8162, 285, 303, 9, 70, "Input",
 CellID->392519421],
Cell[8468, 296, 2613, 77, 70, "Output",
 CellID->39967834]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11130, 379, 229, 7, 70, "ExampleSection",
 CellID->54742845],
Cell[11362, 388, 143, 4, 70, "ExampleText",
 CellID->79588227],
Cell[11508, 394, 298, 10, 70, "Input",
 CellID->312785252],
Cell[11809, 406, 428, 11, 70, "Input",
 CellID->241184568],
Cell[CellGroupData[{
Cell[12262, 421, 208, 6, 70, "Input",
 CellID->302472505],
Cell[12473, 429, 240, 8, 36, "Output",
 CellID->56857989]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12774, 444, 311, 9, 70, "SeeAlsoSection",
 CellID->13095],
Cell[13088, 455, 990, 35, 70, "SeeAlso",
 CellID->9710]
}, Open  ]],
Cell[CellGroupData[{
Cell[14115, 495, 314, 9, 70, "TutorialsSection",
 CellID->32565],
Cell[14432, 506, 185, 4, 70, "Tutorials",
 CellID->9953]
}, Open  ]],
Cell[CellGroupData[{
Cell[14654, 515, 299, 8, 70, "MoreAboutSection"],
Cell[14956, 525, 169, 3, 70, "MoreAbout",
 CellID->138666222]
}, Open  ]],
Cell[15140, 531, 27, 0, 70, "History"],
Cell[15170, 533, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

