(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23414,        757]
NotebookOptionsPosition[     19314,        624]
NotebookOutlinePosition[     20806,        664]
CellTagsIndexPosition[     20721,        659]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Requesting Input" :> 
          Documentation`HelpLookup["paclet:tutorial/RequestingInput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Requesting Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Input" :> Documentation`HelpLookup["paclet:ref/Input"], 
          "InputField" :> Documentation`HelpLookup["paclet:ref/InputField"], 
          "Import" :> Documentation`HelpLookup["paclet:ref/Import"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Input\"\>", 
       2->"\<\"InputField\"\>", 3->"\<\"Import\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Input & Output in Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/BasicInputAndOutputInPrograms"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Dialog Boxes" :> 
          Documentation`HelpLookup["paclet:guide/DialogBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Basic Input & Output in Programs\"\>", 
       2->"\<\"Custom Interface Construction\"\>", 
       3->"\<\"Dialog Boxes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["InputString", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InputString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InputString"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]interactively reads in a character string. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InputString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InputString"], "[", 
       StyleBox["prompt", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]requests input, displaying ",
     Cell[BoxData[
      StyleBox["prompt", "TI"]], "InlineFormula"],
     " as a \"prompt\". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InputString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InputString"], "[", 
       RowBox[{
        StyleBox["prompt", "TI"], ",", 
        StyleBox["init", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]in a notebook front end uses ",
     Cell[BoxData[
      StyleBox["init", "TI"]], "InlineFormula"],
     " as the initial contents of the input field."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->10210]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputString"]], "InlineFormula"],
 " returns what it reads as a string, without evaluation. "
}], "Notes",
 CellID->10365],

Cell[TextData[{
 "The operation of ",
 Cell[BoxData[
  ButtonBox["InputString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputString"]], "InlineFormula"],
 " may vary from one computer system to another. When a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end is used, ",
 Cell[BoxData[
  ButtonBox["InputString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputString"]], "InlineFormula"],
 " typically works through a dialog box. "
}], "Notes",
 CellID->32249],

Cell[TextData[{
 "When no front end is used, ",
 Cell[BoxData[
  ButtonBox["InputString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputString"]], "InlineFormula"],
 " reads from standard input. "
}], "Notes",
 CellID->30336],

Cell[TextData[{
 "If the standard input is a file, then ",
 Cell[BoxData[
  ButtonBox["InputString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputString"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["EndOfFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndOfFile"]], "InlineFormula"],
 " if you try to read past the end of the file. "
}], "Notes",
 CellID->28007],

Cell[TextData[{
 "On systems with textual input, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InputString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputString"], "[", "]"}]], "InlineFormula"],
 " uses ",
 Cell[BoxData["?"], "InlineFormula"],
 " as a prompt. "
}], "Notes",
 CellID->17646],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["InputString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputString"]], "InlineFormula"],
 " is evaluated, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stops until the input has been read. "
}], "Notes",
 CellID->12436],

Cell[TextData[{
 "With a notebook front end, ",
 Cell[BoxData[
  ButtonBox["InputString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputString"]], "InlineFormula"],
 " by default puts up a dialog window with a standard appearance."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->896288002],

Cell["The prompt given can be text, graphics or any expression.", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->50064272],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputString"]], "InlineFormula"],
 " takes notebook options. The default settings include ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowFloating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowFloating"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowSize"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowTitle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowTitle"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24975032],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputString"]], "InlineFormula"],
 " by default puts up a dialog in the middle of the main display screen. \
Explicit settings for ",
 Cell[BoxData[
  ButtonBox["WindowMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
 " override this."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->6914],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["FieldSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FieldSize"]], "InlineFormula"],
 " can be used to specify the size of the field used for input."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->148938813],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InputString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputString"], "[", 
   StyleBox["prompt", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InputString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputString"], "[", 
   RowBox[{
    StyleBox["prompt", "TI"], ",", "\"\<\>\""}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->222766941]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->842580323],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->965853307],

Cell["Get a string from input:", "ExampleText",
 CellID->245932270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputString", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->230011674],

Cell[BoxData["\<\"This string is a sentence.\"\>"], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->430806300]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40360751],

Cell["Encode an input string:", "ExampleText",
 CellID->310969753],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", ",", "e"}], "}"}], "=", 
   RowBox[{"Sort", "[", 
    RowBox[{"ToCharacterCode", "[", "\"\<az\>\"", "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cipher", "=", " ", 
   RowBox[{"Thread", "[", 
    RowBox[{
     RowBox[{"RandomSample", "[", 
      RowBox[{"Range", "[", 
       RowBox[{"b", ",", "e"}], "]"}], "]"}], "\[Rule]", 
     RowBox[{"Range", "[", 
      RowBox[{"b", ",", "e"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->578835809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"enc", "=", 
  RowBox[{"FromCharacterCode", "[", 
   RowBox[{
    RowBox[{"ToCharacterCode", "[", 
     RowBox[{"InputString", "[", "]"}], "]"}], " ", "/.", " ", "cipher"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->177192556],

Cell[BoxData["\<\"am fwjvs\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->522887149]
}, Open  ]],

Cell["Decode:", "ExampleText",
 CellID->530070145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", 
  RowBox[{
   RowBox[{"ToCharacterCode", "[", "enc", "]"}], " ", "/.", " ", 
   RowBox[{"Map", "[", 
    RowBox[{"Reverse", ",", " ", "cipher"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->237881162],

Cell[BoxData["\<\"my input\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->537541131]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26100],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Input"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputField"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19954]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22596],

Cell[TextData[ButtonBox["Requesting Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RequestingInput"]], "Tutorials",
 CellID->2591]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Basic Input & Output in Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicInputAndOutputInPrograms"]], "MoreAbout",
 CellID->863962185],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->134687795],

Cell[TextData[ButtonBox["Dialog Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DialogBoxes"]], "MoreAbout",
 CellID->18890818]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InputString - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 0.0557854}", "context" -> "System`", 
    "keywords" -> {
     "front end", "reading files", "requesting input", "input dialog", 
      "input prompt", "string input"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InputString[] interactively reads in a character string. \
InputString[prompt] requests input, displaying prompt as a \"prompt\". \
InputString[prompt, init] in a notebook front end uses init as the initial \
contents of the input field.", "synonyms" -> {"input string"}, "title" -> 
    "InputString", "type" -> "Symbol", "uri" -> "ref/InputString"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14150, 420, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->842580323]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20577, 652}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2252, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2875, 81, 4195, 83, 70, "ObjectNameGrid"],
Cell[7073, 166, 1331, 40, 70, "Usage",
 CellID->10210]
}, Open  ]],
Cell[CellGroupData[{
Cell[8441, 211, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8919, 228, 229, 7, 70, "Notes",
 CellID->10365],
Cell[9151, 237, 492, 16, 70, "Notes",
 CellID->32249],
Cell[9646, 255, 233, 8, 70, "Notes",
 CellID->30336],
Cell[9882, 265, 397, 13, 70, "Notes",
 CellID->28007],
Cell[10282, 280, 298, 11, 70, "Notes",
 CellID->17646],
Cell[10583, 293, 290, 11, 70, "Notes",
 CellID->12436],
Cell[10876, 306, 402, 11, 70, "Notes",
 CellID->896288002],
Cell[11281, 319, 223, 4, 70, "Notes",
 CellID->50064272],
Cell[11507, 325, 1071, 37, 70, "Notes",
 CellID->24975032],
Cell[12581, 364, 546, 16, 70, "Notes",
 CellID->6914],
Cell[13130, 382, 380, 11, 70, "Notes",
 CellID->148938813],
Cell[13513, 395, 600, 20, 70, "Notes",
 CellID->222766941]
}, Closed]],
Cell[CellGroupData[{
Cell[14150, 420, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->842580323],
Cell[CellGroupData[{
Cell[14535, 434, 148, 5, 70, "ExampleSection",
 CellID->965853307],
Cell[14686, 441, 67, 1, 70, "ExampleText",
 CellID->245932270],
Cell[CellGroupData[{
Cell[14778, 446, 102, 3, 28, "Input",
 CellID->230011674],
Cell[14883, 451, 192, 5, 36, "Output",
 CellID->430806300]
}, Open  ]],
Cell[15090, 459, 124, 3, 70, "ExampleDelimiter",
 CellID->40360751],
Cell[15217, 464, 66, 1, 70, "ExampleText",
 CellID->310969753],
Cell[15286, 467, 560, 18, 70, "Input",
 CellID->578835809],
Cell[CellGroupData[{
Cell[15871, 489, 262, 8, 70, "Input",
 CellID->177192556],
Cell[16136, 499, 173, 5, 36, "Output",
 CellID->522887149]
}, Open  ]],
Cell[16324, 507, 50, 1, 70, "ExampleText",
 CellID->530070145],
Cell[CellGroupData[{
Cell[16399, 512, 264, 7, 70, "Input",
 CellID->237881162],
Cell[16666, 521, 173, 5, 36, "Output",
 CellID->537541131]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16900, 533, 311, 9, 70, "SeeAlsoSection",
 CellID->26100],
Cell[17214, 544, 690, 26, 70, "SeeAlso",
 CellID->19954]
}, Open  ]],
Cell[CellGroupData[{
Cell[17941, 575, 314, 9, 70, "TutorialsSection",
 CellID->22596],
Cell[18258, 586, 141, 3, 70, "Tutorials",
 CellID->2591]
}, Open  ]],
Cell[CellGroupData[{
Cell[18436, 594, 299, 8, 70, "MoreAboutSection"],
Cell[18738, 604, 173, 3, 70, "MoreAbout",
 CellID->863962185],
Cell[18914, 609, 168, 3, 70, "MoreAbout",
 CellID->134687795],
Cell[19085, 614, 134, 3, 70, "MoreAbout",
 CellID->18890818]
}, Open  ]],
Cell[19234, 620, 50, 0, 70, "History"],
Cell[19287, 622, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

