(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24704,        903]
NotebookOptionsPosition[     19836,        735]
NotebookOutlinePosition[     21272,        774]
CellTagsIndexPosition[     21187,        769]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Adding, Removing and Modifying List Elements" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AddingRemovingAndModifyingListElements"], 
          "Manipulating Lists by Their Indices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingListsByTheirIndices"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Adding, Removing and Modifying List Elements\"\>", 
       2->"\<\"Manipulating Lists by Their Indices\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Prepend" :> Documentation`HelpLookup["paclet:ref/Prepend"], 
          "Append" :> Documentation`HelpLookup["paclet:ref/Append"], "Riffle" :> 
          Documentation`HelpLookup["paclet:ref/Riffle"], "StringInsert" :> 
          Documentation`HelpLookup["paclet:ref/StringInsert"], "Take" :> 
          Documentation`HelpLookup["paclet:ref/Take"], "Drop" :> 
          Documentation`HelpLookup["paclet:ref/Drop"], "Delete" :> 
          Documentation`HelpLookup["paclet:ref/Delete"], "ReplacePart" :> 
          Documentation`HelpLookup["paclet:ref/ReplacePart"], "FlattenAt" :> 
          Documentation`HelpLookup["paclet:ref/FlattenAt"], "Position" :> 
          Documentation`HelpLookup["paclet:ref/Position"], "Sequence" :> 
          Documentation`HelpLookup["paclet:ref/Sequence"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Prepend\"\>", 2->"\<\"Append\"\>", 
       3->"\<\"Riffle\"\>", 4->"\<\"StringInsert\"\>", 5->"\<\"Take\"\>", 
       6->"\<\"Drop\"\>", 7->"\<\"Delete\"\>", 8->"\<\"ReplacePart\"\>", 
       9->"\<\"FlattenAt\"\>", 10->"\<\"Position\"\>", 
       11->"\<\"Sequence\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Parts of Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Insert", "ObjectName",
 CellID->12789],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Insert",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Insert"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["elem", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]inserts ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " at position ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". If ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " is negative, the position is counted from the end. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Insert",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Insert"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["elem", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          StyleBox["j", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]inserts ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " at position ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Insert",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Insert"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["elem", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["j", "TI"], 
             StyleBox["1", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["j", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]inserts ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " at several positions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->6509]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " can have any head, not necessarily ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->410],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Insert",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Insert"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects by effectively inserting into the corresponding ordinary lists. "
}], "Notes",
 CellID->25734]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6782089],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->358984868],

Cell[TextData[{
 "Insert ",
 Cell[BoxData["x"], "InlineFormula"],
 " to be at position ",
 Cell[BoxData["3"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->6043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Insert", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "x", 
   ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15937],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "x", ",", "c", ",", "d", ",", "e"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22060]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20610],

Cell[TextData[{
 "Insert ",
 Cell[BoxData["x"], "InlineFormula"],
 " to be at position 2 from the end:"
}], "ExampleText",
 CellID->10797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Insert", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "x", 
   ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "x", ",", "e"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11447]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17829],

Cell[TextData[{
 "Insert ",
 Cell[BoxData["x"], "InlineFormula"],
 " at several positions:"
}], "ExampleText",
 CellID->24763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Insert", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "x", 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"-", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28683],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "a", ",", "b", ",", "x", ",", "c", ",", "d", ",", "e", ",", "x"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10704]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26899],

Cell["Insert into a 2D array:", "ExampleText",
 CellID->14985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Insert", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22939],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15992]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6916],

Cell["Insert into an expression with any head:", "ExampleText",
 CellID->24458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Insert", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], ",", "x", ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->627],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "x", ",", "b", ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9017]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21394],

Cell["Insert at any position in any expression:", "ExampleText",
 CellID->15609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"x", "^", 
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}]}], "+", 
  RowBox[{"y", "^", 
   RowBox[{"(", 
    RowBox[{"c", "+", "d"}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14878],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", 
   RowBox[{"a", "+", "b"}]], "+", 
  SuperscriptBox["y", 
   RowBox[{"c", "+", "d"}]]}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23701]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Insert", "[", 
  RowBox[{"%", ",", "zzz", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5549],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", 
   RowBox[{"a", "+", "b"}]], "+", 
  SuperscriptBox["y", 
   RowBox[{"c", "+", "d", "+", "zzz"}]]}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32345]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24621],

Cell["Insert into a held expression:", "ExampleText",
 CellID->13555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Insert", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{"x", "+", "x"}], "]"}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10401],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"x", "+", "y", "+", "x"}], "]"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15939]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9951],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Prepend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Prepend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Append",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Append"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Riffle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Riffle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringInsert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringInsert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Drop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Drop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Delete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Delete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplacePart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FlattenAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FlattenAt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Position",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Position"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22859]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17366],

Cell[TextData[ButtonBox["Adding, Removing and Modifying List Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AddingRemovingAndModifyingListElements"]], "Tutorials",
 CellID->15962],

Cell[TextData[ButtonBox["Manipulating Lists by Their Indices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingListsByTheirIndices"]], "Tutorials",\

 CellID->13158]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->69668879],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->64560709],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->361784084]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Insert"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Insert - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 0.8058046}", "context" -> "System`", 
    "keywords" -> {"insert element in list"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Insert[list, elem, n] inserts elem at position n in list. If n is \
negative, the position is counted from the end. Insert[expr, elem, {i, j, \
...}] inserts elem at position {i, j, ...} in expr. Insert[expr, elem, {{i_1, \
j_1, ...}, {i_2, j_2, ...}, ...}] inserts elem at several positions. ", 
    "synonyms" -> {}, "title" -> "Insert", "type" -> "Symbol", "uri" -> 
    "ref/Insert"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7903, 241, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->6782089]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21046, 762}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3130, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3753, 93, 44, 1, 70, "ObjectName",
 CellID->12789],
Cell[3800, 96, 2912, 94, 70, "Usage",
 CellID->6509]
}, Open  ]],
Cell[CellGroupData[{
Cell[6749, 195, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7227, 212, 260, 10, 70, "Notes",
 CellID->410],
Cell[7490, 224, 376, 12, 70, "Notes",
 CellID->25734]
}, Closed]],
Cell[CellGroupData[{
Cell[7903, 241, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6782089],
Cell[CellGroupData[{
Cell[8286, 255, 148, 5, 70, "ExampleSection",
 CellID->358984868],
Cell[8437, 262, 166, 7, 70, "ExampleText",
 CellID->6043],
Cell[CellGroupData[{
Cell[8628, 273, 214, 7, 28, "Input",
 CellID->15937],
Cell[8845, 282, 243, 8, 36, "Output",
 CellID->22060]
}, Open  ]],
Cell[9103, 293, 121, 3, 70, "ExampleDelimiter",
 CellID->20610],
Cell[9227, 298, 138, 5, 70, "ExampleText",
 CellID->10797],
Cell[CellGroupData[{
Cell[9390, 307, 233, 8, 70, "Input",
 CellID->22106],
Cell[9626, 317, 243, 8, 36, "Output",
 CellID->11447]
}, Open  ]],
Cell[9884, 328, 121, 3, 70, "ExampleDelimiter",
 CellID->17829],
Cell[10008, 333, 126, 5, 70, "ExampleText",
 CellID->24763],
Cell[CellGroupData[{
Cell[10159, 342, 373, 13, 70, "Input",
 CellID->28683],
Cell[10535, 357, 266, 9, 36, "Output",
 CellID->10704]
}, Open  ]],
Cell[10816, 369, 121, 3, 70, "ExampleDelimiter",
 CellID->26899],
Cell[10940, 374, 62, 1, 70, "ExampleText",
 CellID->14985],
Cell[CellGroupData[{
Cell[11027, 379, 335, 12, 70, "Input",
 CellID->22939],
Cell[11365, 393, 308, 11, 36, "Output",
 CellID->15992]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11722, 410, 238, 7, 70, "ExampleSection",
 CellID->6916],
Cell[11963, 419, 79, 1, 70, "ExampleText",
 CellID->24458],
Cell[CellGroupData[{
Cell[12067, 424, 206, 7, 70, "Input",
 CellID->627],
Cell[12276, 433, 234, 7, 36, "Output",
 CellID->9017]
}, Open  ]],
Cell[12525, 443, 121, 3, 70, "ExampleDelimiter",
 CellID->21394],
Cell[12649, 448, 80, 1, 70, "ExampleText",
 CellID->15609],
Cell[CellGroupData[{
Cell[12754, 453, 242, 9, 70, "Input",
 CellID->14878],
Cell[12999, 464, 282, 10, 36, "Output",
 CellID->23701]
}, Open  ]],
Cell[CellGroupData[{
Cell[13318, 479, 191, 6, 70, "Input",
 CellID->5549],
Cell[13512, 487, 295, 10, 36, "Output",
 CellID->32345]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13856, 503, 223, 7, 70, "ExampleSection",
 CellID->24621],
Cell[14082, 512, 69, 1, 70, "ExampleText",
 CellID->13555],
Cell[CellGroupData[{
Cell[14176, 517, 237, 8, 70, "Input",
 CellID->10401],
Cell[14416, 527, 217, 7, 36, "Output",
 CellID->15939]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14694, 541, 310, 9, 70, "SeeAlsoSection",
 CellID->9951],
Cell[15007, 552, 2642, 98, 70, "SeeAlso",
 CellID->22859]
}, Open  ]],
Cell[CellGroupData[{
Cell[17686, 655, 314, 9, 70, "TutorialsSection",
 CellID->17366],
Cell[18003, 666, 196, 4, 70, "Tutorials",
 CellID->15962],
Cell[18202, 672, 179, 4, 70, "Tutorials",
 CellID->13158]
}, Open  ]],
Cell[CellGroupData[{
Cell[18418, 681, 318, 9, 70, "MoreAboutSection",
 CellID->69668879],
Cell[18739, 692, 143, 3, 70, "MoreAbout",
 CellID->64560709],
Cell[18885, 697, 150, 3, 70, "MoreAbout",
 CellID->361784084]
}, Open  ]],
Cell[CellGroupData[{
Cell[19072, 705, 305, 8, 70, "RelatedLinksSection"],
Cell[19380, 715, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[19779, 731, 27, 0, 70, "History"],
Cell[19809, 733, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

