(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    323722,       7966]
NotebookOptionsPosition[    304183,       7297]
NotebookOutlinePosition[    305989,       7341]
CellTagsIndexPosition[    305902,       7336]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Insetting Objects in Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InsettingObjectsInGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Insetting Objects in Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphicsGroup" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsGroup"], "Item" :> 
          Documentation`HelpLookup["paclet:ref/Item"], "Graphics" :> 
          Documentation`HelpLookup["paclet:ref/Graphics"], "Graphics3D" :> 
          Documentation`HelpLookup["paclet:ref/Graphics3D"], "Locator" :> 
          Documentation`HelpLookup["paclet:ref/Locator"], "Text" :> 
          Documentation`HelpLookup["paclet:ref/Text"], "Rectangle" :> 
          Documentation`HelpLookup["paclet:ref/Rectangle"], "Pane" :> 
          Documentation`HelpLookup["paclet:ref/Pane"], "Panel" :> 
          Documentation`HelpLookup["paclet:ref/Panel"], "PlotMarkers" :> 
          Documentation`HelpLookup["paclet:ref/PlotMarkers"], 
          "ImageSizeAction" :> 
          Documentation`HelpLookup["paclet:ref/ImageSizeAction"], "Scale" :> 
          Documentation`HelpLookup["paclet:ref/Scale"], "Rotate" :> 
          Documentation`HelpLookup["paclet:ref/Rotate"], "Magnify" :> 
          Documentation`HelpLookup["paclet:ref/Magnify"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GraphicsGroup\"\>", 2->"\<\"Item\"\>", 
       3->"\<\"Graphics\"\>", 4->"\<\"Graphics3D\"\>", 5->"\<\"Locator\"\>", 
       6->"\<\"Text\"\>", 7->"\<\"Rectangle\"\>", 8->"\<\"Pane\"\>", 
       9->"\<\"Panel\"\>", 10->"\<\"PlotMarkers\"\>", 
       11->"\<\"ImageSizeAction\"\>", 12->"\<\"Scale\"\>", 
       13->"\<\"Rotate\"\>", 14->"\<\"Magnify\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Combining Graphics" :> 
          Documentation`HelpLookup["paclet:guide/CombiningGraphics"], 
          "Dynamic Graphics Elements" :> 
          Documentation`HelpLookup["paclet:guide/DynamicGraphicsElements"], 
          "Graphics Objects" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsObjects"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Combining Graphics\"\>", 
       3->"\<\"Dynamic Graphics Elements\"\>", 4->"\<\"Graphics Objects\"\>", 
       5->"\<\"Graphics Options & Styling\"\>", 
       6->"\<\"Symbolic Graphics Language\"\>", 
       7->"\<\"New in 6.0: Graphics Primitives & Directives\"\>", 
       8->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Inset", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Inset",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Inset"], "[", 
       StyleBox["obj", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an object ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     " inset in a graphic. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Inset",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Inset"], "[", 
       RowBox[{
        StyleBox["obj", "TI"], ",", 
        StyleBox["pos", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that the inset should be placed at position ",
     
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     " in the graphic. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Inset",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Inset"], "[", 
       RowBox[{
        StyleBox["obj", "TI"], ",", 
        StyleBox["pos", "TI"], ",", 
        StyleBox["opos", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]aligns the inset so that position ",
     Cell[BoxData[
      StyleBox["opos", "TI"]], "InlineFormula"],
     " in the object lies at position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     " in the enclosing graphic. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Inset",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Inset"], "[", 
       RowBox[{
        StyleBox["obj", "TI"], ",", 
        StyleBox["pos", "TI"], ",", 
        StyleBox["opos", "TI"], ",", 
        StyleBox["size", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies the size of the inset in the coordinate \
system of the enclosing graphic. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Inset",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Inset"], "[", 
       RowBox[{
        StyleBox["obj", "TI"], ",", 
        StyleBox["pos", "TI"], ",", 
        StyleBox["opos", "TI"], ",", 
        StyleBox["size", "TI"], ",", 
        StyleBox["dirs", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that the axes of the inset should be oriented \
in directions ",
     Cell[BoxData[
      StyleBox["dirs", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->14222]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In interactive manipulation, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"], "[", 
   RowBox[{
    StyleBox["obj", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " is by default selected as a single unit. A double\[Hyphen]click is \
required to select individual elements inside. "
}], "Notes",
 CellID->975],

Cell[TextData[{
 "The object ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 " can be a graphic, cell expression, string, or any other expression. "
}], "Notes",
 CellID->4255],

Cell["Positions can be specified by: ", "Notes",
 CellID->416],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], Cell[
    "ordinary coordinates in a plot ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "scaled coordinates from 0 to 1 ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["ImageScaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ImageScaled"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell[
    "scaled coordinates from 0 to 1 across a whole image ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Offset",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Offset"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["dx", "TI"], ",", 
        StyleBox["dy", "TI"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], Cell["\<\
absolute offset in printer\[CloseCurlyQuote]s points \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Center",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Center"], Cell[", etc.", "TableText"]}], Cell[
    TextData[{
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        ButtonBox["Center",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Center"], ",", 
        ButtonBox["Center",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Center"]}], "}"}]], "InlineFormula"],
     ", etc. "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->8119],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinates can be numbers, ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Axis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Axis"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26066],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " coordinates can be numbers, ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Baseline",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Baseline"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Axis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Axis"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3536],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Axis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Axis"]], "InlineFormula"],
 " corresponds to the position of the axis in a plot, or the center line in \
typeset text. "
}], "Notes",
 CellID->21654],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 " corresponds to a position centered with respect to the whole image. "
}], "Notes",
 CellID->31474],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"], "[", 
   StyleBox["obj", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"], "[", 
   RowBox[{
    StyleBox["obj", "TI"], ",", 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22385],

Cell[TextData[{
 "The default for ",
 Cell[BoxData[
  StyleBox["opos", "TI"]], "InlineFormula"],
 " is the setting for the ",
 Cell[BoxData[
  ButtonBox["AlignmentPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlignmentPoint"]], "InlineFormula"],
 " option of ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 ", or by default, the center of the bounding box for ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4304],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["size", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", the inset is given at its natural size: "
}], "Notes",
 CellID->30047],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell["graphic", "TableText"], Cell[
    TextData[{
     "determined by ",
     Cell[BoxData[
      ButtonBox["ImageSize",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
     " setting "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["typeset expression", "TableText"], 
    Cell["absolute size without wrapping ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1819],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  StyleBox["size", "TI"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["w", "TI"], ",", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"]}], "}"}]], "InlineFormula"],
 " specifies that a typeset expression should be wrapped at width ",
 Cell[BoxData[
  StyleBox["w", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32610],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["size", "TI"]], "InlineFormula"],
 " is given as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["w", "TI"], ",", 
    StyleBox["h", "TI"]}], "}"}]], "InlineFormula"],
 ", then any object ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 " whose aspect ratio is not fixed will be horizontally or vertically \
stretched so as to fit exactly in a ",
 Cell[BoxData[
  RowBox[{
   StyleBox["w", "TI"], "\[Cross]", 
   StyleBox["h", "TI"]}]], "InlineFormula"],
 " rectangle. "
}], "Notes",
 CellID->21434],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 " is an object with fixed aspect ratio, then blank space will be left \
equally on both sides if there is a direction where the object would have to \
be stretched in order to fit exactly. "
}], "Notes",
 CellID->6935],

Cell[TextData[{
 "The setting for the option ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " specifies the background to be used for the whole region of the inset. "
}], "Notes",
 CellID->29570],

Cell[TextData[{
 "By default, the inset is arranged so that its ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " directions are oriented with the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " directions of the enclosing graphic. "
}], "Notes",
 CellID->26286],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"], "[", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], ",", 
    StyleBox["dirs", "TI"]}], "]"}]], "InlineFormula"],
 " can be used to specify different orientations. "
}], "Notes",
 CellID->16405],

Cell[TextData[{
 "Possible choices for ",
 Cell[BoxData[
  StyleBox["dirs", "TI"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->25231],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "default orientation ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["xx", "TI"], ",", 
      StyleBox["xy", "TI"]}], "}"}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " direction along ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         StyleBox["xx",
          FontSlant->"Italic"], ",", 
         StyleBox["xy",
          FontSlant->"Italic"]}], "}"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["yx", "TI"], ",", 
        StyleBox["yy", "TI"]}], "}"}]}], "}"}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " direction along ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         StyleBox["yx",
          FontSlant->"Italic"], ",", 
         StyleBox["yy",
          FontSlant->"Italic"]}], "}"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["xx", "TI"], ",", 
        StyleBox["xy", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["yx", "TI"], ",", 
        StyleBox["yy", "TI"]}], "}"}]}], "}"}], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " directions along ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         StyleBox["xx",
          FontSlant->"Italic"], ",", 
         StyleBox["xy",
          FontSlant->"Italic"]}], "}"}], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         StyleBox["yx",
          FontSlant->"Italic"], ",", 
         StyleBox["yy",
          FontSlant->"Italic"]}], "}"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "never reorient the contents of the ",
     Cell[BoxData[
      ButtonBox["Inset",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Inset"]], "InlineFormula"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->22723],

Cell[TextData[{
 "Specifying only the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " or only the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " direction in general leads to a rigid rotation of the inset. "
}], "Notes",
 CellID->24620],

Cell[TextData[{
 "Specifying both the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " directions in general leads to a rotation and shear, in which the original \
inset rectangle becomes a parallelogram defined by the vector directions \
given. "
}], "Notes",
 CellID->17173],

Cell[TextData[{
 "Only the directions of the vectors ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["xx", "TI"], ",", 
    StyleBox["xy", "TI"]}], "}"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["yx", "TI"], ",", 
    StyleBox["yy", "TI"]}], "}"}]], "InlineFormula"],
 " are significant; the scale of the inset is determined by ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["w", "TI"], ",", 
    StyleBox["h", "TI"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18782],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  StyleBox["dirs", "TI"]], "InlineFormula"],
 " specified as ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " direction of ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 " is always maintained as horizontal."
}], "Notes",
 CellID->214993187],

Cell[TextData[{
 "The following options can be given for ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 ": "
}], "Notes",
 CellID->3613],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    ButtonBox["Left",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Left"], Cell[
    "how to align the contents of the inset ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "the background to use for the whole region of the inset ", 
     "TableText"]},
   {Cell[" ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], "\"\<Inset\>\"", Cell[
    "the base style to use for the inset ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContentSelectable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContentSelectable"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to allow contents to be selected ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FormatType",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FormatType"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "format type for text", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->24768],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Background",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Background"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " uses whatever background has been specified for the whole graphic \
containing the inset."
}], "Notes",
 CellID->871495]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->332188086],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->136229339],

Cell["Inset a plot into a disk:", "ExampleText",
 CellID->72880157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"LightGray", ",", 
    RowBox[{"Disk", "[", "]"}], ",", 
    RowBox[{"Inset", "[", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Tan", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->487826758],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->887026338]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->362827247],

Cell["Inset an expression in a graphic: ", "ExampleText",
 CellID->366593615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Circle", "[", "]"}], ",", 
    RowBox[{"Inset", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18946940],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}], InsetBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "\[LongEqual]", "1"}], {0, 0}]},
  ImageSize->{112., Automatic}]], "Output",
 ImageSize->{116, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178088740]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->151698370],

Cell["Inset 3D graphics above 2D plot:", "ExampleText",
 CellID->449816466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Inset", "[", 
     RowBox[{
      RowBox[{"Graphics3D", "[", 
       RowBox[{
        RowBox[{"Cylinder", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "60"}], ",", 
        RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.5", ",", "Center"}], "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251926865],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175567406]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(15)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->149542555],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Positions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->451902446],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 " is used for the position:"
}], "ExampleText",
 CellID->708131636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Inset", "[", "\"\<ABCDEF\>\"", "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Inset", "[", 
        RowBox[{"\"\<ABCDEF\>\"", ",", "Center"}], "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45399102],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF"],
      "InsetString"], CircleBox[{0, 0}]},
    Axes->True,
    Ticks->None], ",", 
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF", ImageScaled[{0.5, 0.5}]],
      "InsetString"], CircleBox[{0, 0}]},
    Axes->True,
    Ticks->None]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->495471172]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->118282339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Inset", "[", 
      RowBox[{"\"\<ABCDEF\>\"", ",", "Automatic"}], "]"}], ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->124639199],

Cell[BoxData[
 GraphicsBox[{
   TagBox[InsetBox["ABCDEF", ImageScaled[{0.5, 0.5}]],
    "InsetString"], CircleBox[{0, 0}]},
  Axes->True,
  Ticks->None]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->33994576]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->478150516],

Cell["Specify ordinary coordinates in a graphic:", "ExampleText",
 CellID->24874326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Inset", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", ".5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32481493],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "\[LongEqual]", "1"}], {0, 0.5}], 
   CircleBox[{0, 0}]},
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->593152126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240881684],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates:"
}], "ExampleText",
 CellID->98858528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Inset", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{".5", ",", ".25"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16077544],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "\[LongEqual]", "1"}], Scaled[{0.5, 0.25}]],
    CircleBox[{0, 0}]},
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->295200074]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->310744906],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " specify coordinates in a whole image including padding:"
}], "ExampleText",
 CellID->204734463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
        RowBox[{"ImageScaled", "[", 
         RowBox[{"{", 
          RowBox[{".5", ",", ".5"}], "}"}], "]"}]}], "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
    RowBox[{"ImagePadding", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "50"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31285653],

Cell[BoxData[
 FrameBox[
  GraphicsBox[{InsetBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[LongEqual]", "1"}], 
     ImageScaled[{0.5, 0.5}]], CircleBox[{0, 0}]},
   ImagePadding->{{0, 50}, {0, 0}}],
  StripOnInput->False]], "Output",
 ImageSize->{164, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->2787691]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177144847],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " coordinates:"
}], "ExampleText",
 CellID->295814833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Inset", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
      RowBox[{"Offset", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"10", ",", "20"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->567715396],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "\[LongEqual]", "1"}], 
    Offset[{10, 20}, {0, 0}]], CircleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->91701912]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26503835],

Cell["Symbolic positions can be specified:", "ExampleText",
 CellID->127055650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{"\"\<ABCDEF\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"s", ",", "Center"}], "}"}]}], "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33958350],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF", ImageScaled[{0., 0.5}]],
      "InsetString"], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF", ImageScaled[{0.5, 0.5}]],
      "InsetString"], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF", ImageScaled[{1., 0.5}]],
      "InsetString"], CircleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->172892161]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{"\"\<ABCDEF\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"Center", ",", "s"}], "}"}]}], "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->270810687],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF", ImageScaled[{0.5, 1.}]],
      "InsetString"], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF", ImageScaled[{0.5, 0.5}]],
      "InsetString"], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF", ImageScaled[{0.5, 0.}]],
      "InsetString"], CircleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->1751586]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignments",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->47364530],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 " is used for the alignment position:"
}], "ExampleText",
 CellID->58274548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Inset", "[", 
        RowBox[{"\"\<ABCDEF\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Inset", "[", 
        RowBox[{"\"\<ABCDEF\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "Center"}], "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115309776],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF", {0, 0}],
      "InsetString"], CircleBox[{0, 0}]},
    Axes->True,
    Ticks->None], ",", 
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF", {0, 0}, Center],
      "InsetString"], CircleBox[{0, 0}]},
    Axes->True,
    Ticks->None]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->689322422]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->396420914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Inset", "[", 
      RowBox[{"\"\<ABCDEF\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "Automatic"}], "]"}], ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14736714],

Cell[BoxData[
 GraphicsBox[{
   TagBox[InsetBox["ABCDEF", {0, 0}, Automatic],
    "InsetString"], CircleBox[{0, 0}]},
  Axes->True,
  Ticks->None]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->628273418]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->494427806],

Cell["\<\
Specify an alignment position within the inset, using symbolic positions:\
\>", "ExampleText",
 CellID->841860508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Inset", "[", 
        RowBox[{"\"\<ABCDEF\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", "Center"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"False", ",", "True"}], "}"}]}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"Right", ",", "Center", ",", "Left"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166865608],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF", {0, 0}, {Right, Center}],
      "InsetString"], CircleBox[{0, 0}]},
    Axes->{False, True},
    Ticks->None], ",", 
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF", {0, 0}, {Center, Center}],
      "InsetString"], CircleBox[{0, 0}]},
    Axes->{False, True},
    Ticks->None], ",", 
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF", {0, 0}, {Left, Center}],
      "InsetString"], CircleBox[{0, 0}]},
    Axes->{False, True},
    Ticks->None]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->3455456]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Inset", "[", 
        RowBox[{"\"\<ABCDEF\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Center", ",", "p"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->57894440],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF", {0, 0}, {Center, Top}],
      "InsetString"], CircleBox[{0, 0}]},
    Axes->{True, False},
    Ticks->None], ",", 
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF", {0, 0}, {Center, Center}],
      "InsetString"], CircleBox[{0, 0}]},
    Axes->{True, False},
    Ticks->None], ",", 
   GraphicsBox[{
     TagBox[InsetBox["ABCDEF", {0, 0}, {Center, Bottom}],
      "InsetString"], CircleBox[{0, 0}]},
    Axes->{True, False},
    Ticks->None]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->269262515]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->393547073],

Cell["\<\
Specify an alignment position using the inset graphics coordinates:\
\>", "ExampleText",
 CellID->270213322],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Ticks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "Pi", ",", 
          RowBox[{"2", "Pi"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "60"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12285342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Inset", "[", 
        RowBox[{"g", ",", "Center", ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", "0"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"False", ",", "True"}], "}"}]}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "Pi", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->472765693],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->513949018]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Inset", "[", 
        RowBox[{"g", ",", "Center", ",", 
         RowBox[{"{", 
          RowBox[{"Pi", ",", "p"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->574508612],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->36721199]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17512351],

Cell[TextData[{
 "Set the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis as an alignment position:"
}], "ExampleText",
 CellID->265052685],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "60"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->475449113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Inset", "[", 
      RowBox[{"g", ",", "Center", ",", 
       RowBox[{"{", 
        RowBox[{"Center", ",", "Axis"}], "}"}]}], "]"}], ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", "Dashed"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->391372021],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->821098972]
}, Open  ]],

Cell[TextData[{
 "Set the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis as an alignment position:"
}], "ExampleText",
 CellID->26878365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Inset", "[", 
      RowBox[{"g", ",", "Center", ",", 
       RowBox[{"{", 
        RowBox[{"Axis", ",", "Center"}], "}"}]}], "]"}], ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", "Dashed"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->585356332],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->96261497]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sizes",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->262482467],

Cell[TextData[{
 "If the size is not given, or is ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", the image size of the inset graphic is used:"
}], "ExampleText",
 CellID->43448241],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122198035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Inset", "[", "g", "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Inset", "[", 
        RowBox[{"g", ",", "Center", ",", "Center", ",", "Automatic"}], "]"}], 
       ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33528725],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{226, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->239295371]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->481200231],

Cell["For typeset expressions, absolute font size is used:", "ExampleText",
 CellID->127954471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<ABCDEF\>\"", ",", "10"}], "]"}], "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<ABCDEF\>\"", ",", "20"}], "]"}], "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->371823481],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{InsetBox[
      StyleBox["\<\"ABCDEF\"\>",
       StripOnInput->False,
       FontSize->10]], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{InsetBox[
      StyleBox["\<\"ABCDEF\"\>",
       StripOnInput->False,
       FontSize->20]], CircleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->218374147]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->247658495],

Cell["\<\
Specify the width of the inset by the units of the enclosing graphic:\
\>", "ExampleText",
 CellID->87556433],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17716294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Inset", "[", 
        RowBox[{"g", ",", "Automatic", ",", "Automatic", ",", "s"}], "]"}], 
       ",", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}]}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->141577087],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->353561883]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->403326058],

Cell["\<\
Given both width and height sizes, the inset graphic will be stretched, if \
aspect ratio is not fixed:\
\>", "ExampleText",
 CellID->490824923],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "Full"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61635207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Inset", "[", 
        RowBox[{"g", ",", "Automatic", ",", "Automatic", ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", "s"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}]}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->93271662],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->162886604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->440083380],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["w", "TI"], ",", " ", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"]}], "}"}]], "InlineFormula"],
 " specify the width where a typeset expression should be wrapped:"
}], "ExampleText",
 CellID->313904953],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", "\"\<abcd xyz abcd xyz abcd xyz abcd xyz abcd xyz\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188941247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Inset", "[", 
        RowBox[{
         RowBox[{"Framed", "[", "t", "]"}], ",", "Automatic", ",", 
         "Automatic", ",", 
         RowBox[{"{", 
          RowBox[{"s", ",", "Automatic"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}]}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->964571532],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{InsetBox[
      FrameBox["\<\"abcd xyz abcd xyz abcd xyz abcd xyz abcd xyz\"\>",
       StripOnInput->False], ImageScaled[{0.5, 0.5}], Automatic, {
      2, Automatic}], CircleBox[{0, 0}, 2]},
    Frame->True], ",", 
   GraphicsBox[{InsetBox[
      FrameBox["\<\"abcd xyz abcd xyz abcd xyz abcd xyz abcd xyz\"\>",
       StripOnInput->False], ImageScaled[{0.5, 0.5}], Automatic, {
      4, Automatic}], CircleBox[{0, 0}, 2]},
    Frame->True]}], "}"}]], "Output",
 ImageSize->{330, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->80589204]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Directions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->467290813],

Cell[TextData[{
 "Specify the direction that the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis of the inset should be aligned at:"
}], "ExampleText",
 CellID->696495985],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->718128506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{
       "g", ",", "Automatic", ",", "Automatic", ",", "1.5", ",", "d"}], "]"}],
       ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->157232685],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->328706877]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{
       "\"\<ABCDEF\>\"", ",", "Automatic", ",", "Automatic", ",", "Automatic",
         ",", "d"}], "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->517675944],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     TagBox[
      InsetBox["ABCDEF", ImageScaled[{0.5, 0.5}], Automatic, Automatic, {1, 
       0}],
      "InsetString"], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{
     TagBox[
      InsetBox["ABCDEF", ImageScaled[{0.5, 0.5}], Automatic, Automatic, {1, 
       1}],
      "InsetString"], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{
     TagBox[
      InsetBox["ABCDEF", ImageScaled[{0.5, 0.5}], Automatic, Automatic, {0, 
       1}],
      "InsetString"], CircleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->637182904]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->594629384],

Cell[TextData[{
 "Specify the direction that the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis of the inset should be aligned at:"
}], "ExampleText",
 CellID->192705398],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->106034834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{"g", ",", "Automatic", ",", "Automatic", ",", "1.5", ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "d"}], "}"}]}], "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->402927335],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->171176787]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{
       "\"\<ABCDEF\>\"", ",", "Automatic", ",", "Automatic", ",", "Automatic",
         ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "d"}], "}"}]}], "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->67456907],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     TagBox[
      InsetBox["ABCDEF", ImageScaled[{0.5, 0.5}], Automatic, Automatic, {
       Automatic, {1, 0}}],
      "InsetString"], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{
     TagBox[
      InsetBox["ABCDEF", ImageScaled[{0.5, 0.5}], Automatic, Automatic, {
       Automatic, {1, 1}}],
      "InsetString"], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{
     TagBox[
      InsetBox["ABCDEF", ImageScaled[{0.5, 0.5}], Automatic, Automatic, {
       Automatic, {0, 1}}],
      "InsetString"], CircleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->862523671]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->184018105],

Cell[TextData[{
 "Specify the direction for ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axes separately:"
}], "ExampleText",
 CellID->445281689],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->525255113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Inset", "[", 
     RowBox[{"g", ",", "Automatic", ",", "Automatic", ",", "1.5", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->424535648],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->39121679]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Inset", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<ABCDEF\>\"", ",", "20"}], "]"}], ",", "Automatic", ",", 
      "Automatic", ",", "Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->152450187],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    StyleBox["\<\"ABCDEF\"\>",
     StripOnInput->False,
     FontSize->20], ImageScaled[{0.5, 0.5}], Automatic, Automatic, {{2, 0}, {
    1, 2}}], CircleBox[{0, 0}]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->437993807]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->839],

Cell[TextData[{
 "Flip in ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->178591179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Inset", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<ABCDEF\>\"", ",", "20"}], "]"}], ",", "Automatic", ",", 
      "Automatic", ",", "Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->581921417],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    StyleBox["\<\"ABCDEF\"\>",
     StripOnInput->False,
     FontSize->20], ImageScaled[{0.5, 0.5}], Automatic, Automatic, {{-1, 0}, {
    0, 1}}], CircleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->95681562]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->575453613],

Cell[TextData[{
 "Flip in ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->127188552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Inset", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<ABCDEF\>\"", ",", "20"}], "]"}], ",", "Automatic", ",", 
      "Automatic", ",", "Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108914382],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    StyleBox["\<\"ABCDEF\"\>",
     StripOnInput->False,
     FontSize->20], ImageScaled[{0.5, 0.5}], Automatic, Automatic, {{1, 0}, {
    0, -1}}], CircleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->722916172]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->198516876],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->35704154],

Cell["Determine how to align the contents of the inset:", "ExampleText",
 CellID->642016114],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", "\"\<abcd xyz abcd xyz abcd xyz abcd xyz\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50263331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{
        RowBox[{"Framed", "[", "t", "]"}], ",", "Automatic", ",", "Automatic",
         ",", 
        RowBox[{"{", 
         RowBox[{"1.5", ",", "Automatic"}], "}"}], ",", 
        RowBox[{"Alignment", "\[Rule]", "a"}]}], "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->252409706],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{InsetBox[
      FrameBox["\<\"abcd xyz abcd xyz abcd xyz abcd xyz\"\>",
       StripOnInput->False], ImageScaled[{0.5, 0.5}], Automatic, {
      1.5, Automatic},
      Alignment->Left], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{InsetBox[
      FrameBox["\<\"abcd xyz abcd xyz abcd xyz abcd xyz\"\>",
       StripOnInput->False], ImageScaled[{0.5, 0.5}], Automatic, {
      1.5, Automatic},
      Alignment->Center], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{InsetBox[
      FrameBox["\<\"abcd xyz abcd xyz abcd xyz abcd xyz\"\>",
       StripOnInput->False], ImageScaled[{0.5, 0.5}], Automatic, {
      1.5, Automatic},
      Alignment->Right], CircleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->23667392]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4500943],

Cell["Specify the background color:", "ExampleText",
 CellID->184101264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Inset", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
      RowBox[{"Background", "\[Rule]", "LightRed"}]}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176800642],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "<", "1"}],
    Background->RGBColor[1, 0.85, 0.85]], CircleBox[{0, 0}]}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->2766543]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaseStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->168767647],

Cell["Set the starting style: ", "ExampleText",
 CellID->65039657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Inset", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<circle\>\"", ",", "Blue"}], "]"}], ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"Directive", "[", 
        RowBox[{"Large", ",", "Italic"}], "]"}]}]}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20543643],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    StyleBox["\<\"circle\"\>",
     StripOnInput->False,
     FrontFaceColor->RGBColor[0, 0, 1],
     BackFaceColor->RGBColor[0, 0, 1],
     GraphicsColor->RGBColor[0, 0, 1],
     FontColor->RGBColor[0, 0, 1]],
    BaseStyle->Directive[Large, Italic]], CircleBox[{0, 0}]}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->259089229]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34951749],

Cell["Use a named style: ", "ExampleText",
 CellID->682617663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Inset", "[", 
     RowBox[{"\"\<circle\>\"", ",", 
      RowBox[{"BaseStyle", "\[Rule]", "\"\<Title\>\""}]}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->428511758],

Cell[BoxData[
 GraphicsBox[{
   TagBox[InsetBox["circle",
     BaseStyle->"Title"],
    "InsetString"], CircleBox[{0, 0}]}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->196092109]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ContentSelectable",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->293683928],

Cell["Determine whether to allow the contents to be selected:", "ExampleText",
 CellID->61780937],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132359157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{"g", ",", 
        RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{"g", ",", 
        RowBox[{"ContentSelectable", "\[Rule]", "False"}]}], "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->126989272],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->4021208]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FormatType",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->261032255],

Cell[TextData[{
 "By default, expressions are displayed using ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->130415530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Inset", "[", 
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", "Medium"}], "]"}], "]"}],
     ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140419832],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    StyleBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "<", "1"}],
     StripOnInput->False,
     FontSize->Medium]], CircleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->335976202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127269120],

Cell[TextData[{
 "Display expressions using ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->260195582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Inset", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", "Medium"}], "]"}], ",", 
      
      RowBox[{"FormatType", "\[Rule]", "StandardForm"}]}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->225311832],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    StyleBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "<", "1"}],
     StripOnInput->False,
     FontSize->Medium],
    FormatType->StandardForm], CircleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->251054021]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2025],

Cell["Multiple function plot with legend:", "ExampleText",
 CellID->552131345],

Cell[BoxData[
 RowBox[{
  RowBox[{"legendPlot", "[", 
   RowBox[{"xl_List", ",", "d_", ",", "args___"}], "]"}], ":=", 
  RowBox[{"Plot", "[", 
   RowBox[{"xl", ",", "d", ",", 
    RowBox[{"Epilog", "\[Rule]", 
     RowBox[{"Inset", "[", 
      RowBox[{
       RowBox[{"Panel", "[", 
        RowBox[{"Grid", "[", 
         RowBox[{"MapIndexed", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Graphics", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"ColorData", "[", 
                   RowBox[{"1", ",", 
                    RowBox[{"First", "@", "#2"}]}], "]"}], ",", "Thick", ",", 
                  
                  RowBox[{"Line", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], 
                ",", 
                RowBox[{"AspectRatio", "\[Rule]", ".1"}], ",", 
                RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}], ",", "#1"}], 
             "}"}], "&"}], ",", "xl"}], "]"}], "]"}], "]"}], ",", 
       RowBox[{"Offset", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "2"}]}], "}"}], ",", 
         RowBox[{"Scaled", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"Right", ",", "Top"}], "}"}]}], "]"}]}], ",", "args"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->303183403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"legendPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"Sinc", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->264622111],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJwV2Xk8VF8bAHC7GXuyzCDLjJC0pyI6DyUlWiWyFEIq6peKUCkqZStUKlHS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     "]]}, 
   {Hue[0.14213595499957954`, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Xk4lF8bB3BLZIuZIWSZGSWEJO1S5y5RRH4lJBESQooWkkoSCWUr+xIp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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Epilog->InsetBox[
    BoxData[
     FormBox[
      PanelBox[
       TagBox[
        GridBox[{{
           GraphicsBox[{
             RGBColor[0.24720000000000017`, 0.24, 0.6], 
             Thickness[Large], 
             LineBox[{{0, 0}, {1, 0}}]}, AspectRatio -> 0.1, ImageSize -> 20],
            
           RowBox[{"sin", "(", "x", ")"}]}, {
           GraphicsBox[{
             RGBColor[0.6, 0.24, 0.4428931686004542], 
             Thickness[Large], 
             LineBox[{{0, 0}, {1, 0}}]}, AspectRatio -> 0.1, ImageSize -> 20],
            
           RowBox[{"cos", "(", "x", ")"}]}, {
           GraphicsBox[{
             RGBColor[0.6, 0.5470136627990908, 0.24], 
             Thickness[Large], 
             LineBox[{{0, 0}, {1, 0}}]}, AspectRatio -> 0.1, ImageSize -> 20],
            
           RowBox[{"sinc", "(", "x", ")"}]}}, 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, ColumnsEqual -> 
         False, RowsEqual -> False], "Grid"]], TraditionalForm]], 
    Offset[{-2, -2}, 
     Scaled[{1, 1}]], {Right, Top}],
  PlotRange->{{0, 10}, {-0.9999997966795732, 0.999999999999993}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{304, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->79305454]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->73747830],

Cell["Select countries:", "ExampleText",
 CellID->156782874],

Cell[BoxData[
 RowBox[{
  RowBox[{"co", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<Austria\>\"", ",", "\"\<Belgium\>\"", ",", "\"\<France\>\"", ",", 
     "\"\<Germany\>\"", ",", "\"\<Ireland\>\"", ",", "\"\<Italy\>\"", ",", 
     "\"\<Luxembourg\>\"", ",", "\"\<Netherlands\>\"", ",", 
     "\"\<Portugal\>\"", ",", "\"\<Spain\>\"", ",", "\"\<Switzerland\>\"", 
     ",", "\"\<UnitedKingdom\>\""}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->754824207],

Cell[TextData[{
 "Set up an annotation function using ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->664991618],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "c_", "]"}], ":=", 
   RowBox[{"Inset", "[", 
    RowBox[{
     RowBox[{"Grid", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"c", ",", "SpanFromLeft"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Pop.\>\"", ",", 
           RowBox[{"Row", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Round", "[", 
               RowBox[{
                RowBox[{"CountryData", "[", 
                 RowBox[{"c", ",", "\"\<Population\>\""}], "]"}], "/", 
                RowBox[{"10", "^", "6"}]}], "]"}], ",", "\"\< mil.\>\""}], 
             "}"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<Flag\>\"", ",", 
           RowBox[{"Show", "[", 
            RowBox[{
             RowBox[{"CountryData", "[", 
              RowBox[{"c", ",", "\"\<Flag\>\""}], "]"}], ",", 
             RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}]}], "}"}]}], 
        "}"}], ",", 
       RowBox[{"BaseStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Small", ",", 
          RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}], 
       ",", 
       RowBox[{"Background", "\[Rule]", "White"}], ",", 
       RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}], ",", 
     RowBox[{"Reverse", "@", 
      RowBox[{"CountryData", "[", 
       RowBox[{"c", ",", "\"\<CenterCoordinates\>\""}], "]"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->336499226],

Cell["Display the map with the annotations:", "ExampleText",
 CellID->473137457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "LightBlue", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"CountryData", "[", 
        RowBox[{"#", ",", "\"\<Polygon\>\""}], "]"}], "&"}], "/@", "co"}], 
     ",", "Black", ",", 
     RowBox[{"a", "/@", "co"}]}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->307789243],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{500, 395},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->350764487]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97836616],

Cell["Define a stock plot with legend:", "ExampleText",
 CellID->690395492],

Cell[BoxData[
 RowBox[{
  RowBox[{"stockPlot", "[", 
   RowBox[{"sl_List", ",", 
    RowBox[{"{", 
     RowBox[{"y_", ",", "m_"}], "}"}], ",", "args___"}], "]"}], ":=", 
  RowBox[{"DateListPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FinancialData", "[", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "m"}], "}"}]}], "]"}], "&"}], "/@", "sl"}], ",", 
    RowBox[{"Joined", "\[Rule]", "True"}], ",", 
    RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"All", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "All"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Epilog", "\[Rule]", 
     RowBox[{"Inset", "[", 
      RowBox[{
       RowBox[{"Panel", "[", 
        RowBox[{"Grid", "[", 
         RowBox[{"MapIndexed", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                  "\[FilledCircle]", ",", "\[FilledSquare]", ",", 
                   "\[FilledDiamond]"}], "}"}], "[", 
                 RowBox[{"[", 
                  RowBox[{"First", "@", "#2"}], "]"}], "]"}], ",", 
                RowBox[{"ColorData", "[", 
                 RowBox[{"1", ",", 
                  RowBox[{"First", "@", "#2"}]}], "]"}]}], "]"}], ",", 
              RowBox[{"FinancialData", "[", 
               RowBox[{"#1", ",", "\"\<Name\>\""}], "]"}]}], "}"}], "&"}], 
           ",", "sl"}], "]"}], "]"}], "]"}], ",", 
       RowBox[{"Offset", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
         RowBox[{"Scaled", "[", 
          RowBox[{"{", 
           RowBox[{"1", ",", ".3"}], "}"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"Right", ",", "Bottom"}], "}"}]}], "]"}]}], ",", "args"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172501340],

Cell["Draw stock price changes of few auto makers:", "ExampleText",
 CellID->548036387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stockPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<F\>\"", ",", "\"\<GM\>\"", ",", "\"\<HMC\>\""}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"2007", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58071330],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxVlE9oU0EQh58FFQLSIAU9SBovUhGk2rRpiu/tzl5avFh7qlhKK9prU0Tw
zyUUAqKH9qoHKVYUBEvQS0GQUPGmELEQ9FQVhVAP8aAIojjvt+anuxDCx25m
Zme+zcFz8xMXuqIomtNP+q2rvvd4S3rWRt9f7em1yu0TylNLG9/6pnIpV54q
T6znqtunwbVPytheAm91D7TkGgKAsyPKOL6OePZ8yI0PymOabW0UHO0pBPH6
i8qZ5mo5zoBnZgtBPcs3lQewwPnMYBBvvKCcZstVwZXpDu/Mo/7ryocRELz1
eLCTH+fLx4Y69wGvnFWew/L1V5W/pOG3ff015Vcv0wXufzcUxKtPFluC9h5F
vvZiMciff1Ts9B883iwG9WYrw8F5+1AZ150FlzeVn6fpHHjl93CQr9FX6vQT
PPOg9Le+bvDy61Jwv/rPUtBP+IHf3zD0ozct8E5CPxbi9ERCP7CfM/QD+CKh
Hz6/oR/4+a+EfnjfDP3A/RYT+gFzbUI/fD9i+oH5HInpB66/L6Yft2/pOhPT
D6T7EdMPnz+hH74+Qz+QP2/ph49v6QfOx4Z+3NPt5seEfoBXE/qB+W8m9APp
Lxv6gXnsNvQD4/ps6EfkG0I//Lwt/fiu7du4ZOgH5jNt6Af622XpB3wbs/QD
881a+oHn98TQDz9vRz/Q37dCP7zfjn5g/qcc/cB99zv64e/v6Afuc9LRD7zP
EUc/UF9D6Ae4JvTD1yv0A/VdEfqB+98V+uHfs9AP/x5d6MdXoR+YxyEX+hE5
+oH8b4R+gC8K/UC8BaEf6M+80A/0Y1LoB/r9TOgH/N/h6Md/+/AD9d0X+uHf
i9AP77elH/i7OSD0A/1s//PDvy+hH4i/S+iH11HsH0lqN6A=
   "], {{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
       19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34}]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], 
      LineBox[{35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
        51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 
       68}]}, 
     {Hue[0.14213595499957954`, 0.6, 0.6], 
      LineBox[{69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84,
        85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
       102}]}}, {
     {Hue[0.67, 0.6, 0.6], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 1], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 2], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 3], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 4], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 5], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 6], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 7], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 8], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 9], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 10], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 11], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 12], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 13], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 14], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 15], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 16], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 17], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 18], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 19], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 20], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 21], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 22], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 23], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 24], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 25], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 26], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 27], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 28], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 29], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 30], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 31], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 32], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 33], InsetBox[
       StyleBox["\<\"\[FilledCircle]\"\>",
        StripOnInput->False,
        FontSize->8.96], 34]}, 
     {Hue[0.9060679774997897, 0.6, 0.6], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 35], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 36], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 37], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 38], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 39], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 40], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 41], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 42], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 43], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 44], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 45], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 46], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 47], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 48], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 49], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 50], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 51], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 52], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 53], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 54], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 55], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 56], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 57], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 58], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 59], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 60], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 61], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 62], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 63], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 64], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 65], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 66], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 67], InsetBox[
       StyleBox["\<\"\[FilledSquare]\"\>",
        StripOnInput->False,
        FontSize->8.96], 68]}, 
     {Hue[0.14213595499957954`, 0.6, 0.6], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 69], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 70], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 71], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 72], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 73], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 74], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 75], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 76], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 77], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 78], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 79], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 80], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 81], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 82], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 83], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 84], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 85], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 86], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 87], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 88], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 89], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 90], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 91], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 92], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 93], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 94], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 95], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 96], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 97], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 98], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 99], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 100], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 101], InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        FontSize->10.88], 102]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->{3.382*^9, 0},
  Epilog->InsetBox[
    BoxData[
     FormBox[
      PanelBox[
       TagBox[
        GridBox[{{
           StyleBox["\[FilledCircle]", 
            RGBColor[0.24720000000000017`, 0.24, 0.6], StripOnInput -> False],
            "\"Ford Motor Company\""}, {
           StyleBox["\[FilledSquare]", 
            RGBColor[0.6, 0.24, 0.4428931686004542], StripOnInput -> False], 
           "\"General Motors Corporation\""}, {
           StyleBox["\[FilledDiamond]", 
            RGBColor[0.6, 0.5470136627990908, 0.24], StripOnInput -> False], 
           "\"Honda Motor Co., Ltd.\""}}, 
         GridBoxItemSize -> {
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, ColumnsEqual -> 
         False, RowsEqual -> False], "Grid"]], TraditionalForm]], 
    Offset[{-2, 2}, 
     Scaled[{1, 0.3}]], {Right, Bottom}],
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {{{
       NCache[3382041600, 3.3820416*^9], 
       FormBox["\"Mar 05\"", TraditionalForm]}, {
       NCache[3383251200, 3.3832512*^9], 
       FormBox["\"Mar 19\"", TraditionalForm]}, {
       NCache[3384460800, 3.3844608*^9], 
       FormBox["\"Apr 02\"", TraditionalForm]}, {
       NCache[3385670400, 3.3856704*^9], 
       FormBox["\"Apr 16\"", TraditionalForm]}, {
       NCache[3382646400, 3.3826464*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3383856000, 3.383856*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3385065600, 3.3850656*^9], 
       FormBox["\" \"", TraditionalForm]}}, {{
       NCache[3382041600, 3.3820416*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3383251200, 3.3832512*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3384460800, 3.3844608*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3385670400, 3.3856704*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3382646400, 3.3826464*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3383856000, 3.383856*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3385065600, 3.3850656*^9], 
       FormBox["\" \"", TraditionalForm]}}}},
  GridLines->NCache[{{{3382041600, 
       GrayLevel[0.8]}, {3383251200, 
       GrayLevel[0.8]}, {3384460800, 
       GrayLevel[0.8]}, {3385670400, 
       GrayLevel[0.8]}}, None}, {{{3.3820416*^9, 
       GrayLevel[0.8]}, {3.3832512*^9, 
       GrayLevel[0.8]}, {3.3844608*^9, 
       GrayLevel[0.8]}, {3.3856704*^9, 
       GrayLevel[0.8]}}, None}],
  PlotRange->{All, {0, All}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic},
  Ticks->None]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{404, 270},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{400, Automatic}},
 CellLabel->"Out[2]=",
 CellID->2278029]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14789],

Cell[TextData[{
 "The symbolic positions are relative to ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " coordinates:"
}], "ExampleText",
 CellID->42742432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Inset", "[", 
         RowBox[{"\"\<ABCDEF\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "Center"}], "}"}]}], "]"}], ",", 
        RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
      RowBox[{"ImagePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"10", ",", "40"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365834959],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[{
      TagBox[InsetBox["ABCDEF", ImageScaled[{0., 0.5}]],
       "InsetString"], CircleBox[{0, 0}]},
     ImagePadding->{{10, 40}, {0, 0}}],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[{
      TagBox[InsetBox["ABCDEF", ImageScaled[{0.5, 0.5}]],
       "InsetString"], CircleBox[{0, 0}]},
     ImagePadding->{{10, 40}, {0, 0}}],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[{
      TagBox[InsetBox["ABCDEF", ImageScaled[{1., 0.5}]],
       "InsetString"], CircleBox[{0, 0}]},
     ImagePadding->{{10, 40}, {0, 0}}],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{371, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->223973667]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Inset", "[", 
         RowBox[{"\"\<ABCDEF\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"Center", ",", "s"}], "}"}]}], "]"}], ",", 
        RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
      RowBox[{"ImagePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10", ",", "20"}], "}"}]}], "}"}]}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->806731238],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[{
      TagBox[InsetBox["ABCDEF", ImageScaled[{0.5, 1.}]],
       "InsetString"], CircleBox[{0, 0}]},
     ImagePadding->{{0, 0}, {10, 20}}],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[{
      TagBox[InsetBox["ABCDEF", ImageScaled[{0.5, 0.5}]],
       "InsetString"], CircleBox[{0, 0}]},
     ImagePadding->{{0, 0}, {10, 20}}],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[{
      TagBox[InsetBox["ABCDEF", ImageScaled[{0.5, 0.}]],
       "InsetString"], CircleBox[{0, 0}]},
     ImagePadding->{{0, 0}, {10, 20}}],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{371, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->49394387]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245588419],

Cell[TextData[{
 "For typeset expressions, ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 " offers the similar functionality as ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->183301216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->321628380],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "\[LongEqual]", "1"}], {0, 0}], 
   CircleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->237389153]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}], "+", 
        RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->401912615],

Cell[BoxData[
 Graphics3DBox[{Text3DBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"], "+", 
      SuperscriptBox["z", "2"]}], "\[LongEqual]", "1"}], {0, 0, 0}], 
   SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->53420086,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2986],

Cell["Random collage of text:", "ExampleText",
 CellID->25885965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Inset", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<Mathematica\>\"", ",", 
         RowBox[{"Hue", "[", 
          RowBox[{"RandomReal", "[", "]"}], "]"}], ",", "Italic", ",", 
         RowBox[{"RandomInteger", "[", 
          RowBox[{"{", 
           RowBox[{"10", ",", "30"}], "}"}], "]"}]}], "]"}], ",", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", "2", "}"}]}], "]"}], ",", "Automatic", ",", "Automatic",
        ",", 
       RowBox[{"RandomReal", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", "2", "}"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", "20", "}"}]}], "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", 
    RowBox[{"1", "/", "GoldenRatio"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "300"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->341600935],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.037126944389130445`],
     BackFaceColor->Hue[0.037126944389130445`],
     GraphicsColor->Hue[0.037126944389130445`],
     FontSize->26,
     FontSlant->Italic,
     FontColor->Hue[0.037126944389130445`]], {0.40318314623576135`, 0.12341123202155657`},
     Automatic, Automatic, {0.5719462328194447, 0.343542163387053}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.6631695621818885],
     BackFaceColor->Hue[0.6631695621818885],
     GraphicsColor->Hue[0.6631695621818885],
     FontSize->13,
     FontSlant->Italic,
     FontColor->Hue[0.6631695621818885]], {0.9361389807718141, 0.7235462534414456},
     Automatic, Automatic, {-0.19371213631377637`, -0.9500305319684181}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.8533451718313347],
     BackFaceColor->Hue[0.8533451718313347],
     GraphicsColor->Hue[0.8533451718313347],
     FontSize->23,
     FontSlant->Italic,
     FontColor->Hue[0.8533451718313347]], {0.8344948732897353, 0.9210892729230509},
     Automatic, Automatic, {-0.4271686213054715, 0.34425125435878634`}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.8663924336564726],
     BackFaceColor->Hue[0.8663924336564726],
     GraphicsColor->Hue[0.8663924336564726],
     FontSize->20,
     FontSlant->Italic,
     FontColor->Hue[0.8663924336564726]], {0.46320317274259626`, 0.3139214005171638},
     Automatic, Automatic, {-0.7234415585608427, -0.6522215453236346}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.1516579343881046],
     BackFaceColor->Hue[0.1516579343881046],
     GraphicsColor->Hue[0.1516579343881046],
     FontSize->12,
     FontSlant->Italic,
     FontColor->Hue[0.1516579343881046]], {0.8728539008980953, 0.7351489658924613},
     Automatic, Automatic, {0.8711916516250438, -0.9310824065114849}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.06071487670283271],
     BackFaceColor->Hue[0.06071487670283271],
     GraphicsColor->Hue[0.06071487670283271],
     FontSize->15,
     FontSlant->Italic,
     FontColor->Hue[0.06071487670283271]], {0.9849365706902122, 0.3859500342068347},
     Automatic, Automatic, {-0.1280084575896696, 0.06610603191605513}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.4497161280152686],
     BackFaceColor->Hue[0.4497161280152686],
     GraphicsColor->Hue[0.4497161280152686],
     FontSize->20,
     FontSlant->Italic,
     FontColor->Hue[0.4497161280152686]], {0.980796788726165, 0.05835873141595571},
     Automatic, Automatic, {-0.588663770641745, -0.07457986257462235}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.438180656758854],
     BackFaceColor->Hue[0.438180656758854],
     GraphicsColor->Hue[0.438180656758854],
     FontSize->24,
     FontSlant->Italic,
     FontColor->Hue[0.438180656758854]], {0.7063349205646217, 0.6044220090628061},
     Automatic, Automatic, {-0.4179333481837024, -0.11611219825524222`}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.5436462625825196],
     BackFaceColor->Hue[0.5436462625825196],
     GraphicsColor->Hue[0.5436462625825196],
     FontSize->30,
     FontSlant->Italic,
     FontColor->Hue[0.5436462625825196]], {0.40207647599972973`, 0.9529002495914449},
     Automatic, Automatic, {0.3499366921680047, -0.5580207457688728}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.8072925752446838],
     BackFaceColor->Hue[0.8072925752446838],
     GraphicsColor->Hue[0.8072925752446838],
     FontSize->15,
     FontSlant->Italic,
     FontColor->Hue[0.8072925752446838]], {0.5938163573643105, 0.19072864604080886`},
     Automatic, Automatic, {0.3383680133697422, -0.03615063511246497}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.11569461012080007`],
     BackFaceColor->Hue[0.11569461012080007`],
     GraphicsColor->Hue[0.11569461012080007`],
     FontSize->10,
     FontSlant->Italic,
     FontColor->Hue[0.11569461012080007`]], {0.5005897568382165, 0.24300070766371973`},
     Automatic, Automatic, {-0.31973488476007894`, 0.41620150098248887`}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.24903622786555735`],
     BackFaceColor->Hue[0.24903622786555735`],
     GraphicsColor->Hue[0.24903622786555735`],
     FontSize->30,
     FontSlant->Italic,
     FontColor->Hue[0.24903622786555735`]], {0.3639286750964206, 0.9556880909090235},
     Automatic, Automatic, {-0.22399787348571198`, -0.23598258468489108`}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.7817370494615061],
     BackFaceColor->Hue[0.7817370494615061],
     GraphicsColor->Hue[0.7817370494615061],
     FontSize->23,
     FontSlant->Italic,
     FontColor->Hue[0.7817370494615061]], {0.06095458758304528, 0.517269451460509},
     Automatic, Automatic, {-0.05191063528068263, -0.3466868110126251}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.9948948202038186],
     BackFaceColor->Hue[0.9948948202038186],
     GraphicsColor->Hue[0.9948948202038186],
     FontSize->26,
     FontSlant->Italic,
     FontColor->Hue[0.9948948202038186]], {0.8718150858311235, 0.8077045333605728},
     Automatic, Automatic, {-0.7426338302701683, -0.6185688594203484}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.9152334652996734],
     BackFaceColor->Hue[0.9152334652996734],
     GraphicsColor->Hue[0.9152334652996734],
     FontSize->13,
     FontSlant->Italic,
     FontColor->Hue[0.9152334652996734]], {0.35217608863449645`, 0.5847227091557317},
     Automatic, Automatic, {0.3072876153516253, 0.3069603296452832}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.405230168972025],
     BackFaceColor->Hue[0.405230168972025],
     GraphicsColor->Hue[0.405230168972025],
     FontSize->11,
     FontSlant->Italic,
     FontColor->Hue[0.405230168972025]], {0.17365698911054794`, 0.39193289869913484`},
     Automatic, Automatic, {-0.5073676568847492, -0.8441928058394534}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.38362784957324036`],
     BackFaceColor->Hue[0.38362784957324036`],
     GraphicsColor->Hue[0.38362784957324036`],
     FontSize->16,
     FontSlant->Italic,
     FontColor->Hue[0.38362784957324036`]], {0.1855048127670138, 0.4039668644884018},
     Automatic, Automatic, {-0.8828538951447982, -0.8884268445253278}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.6649633945747178],
     BackFaceColor->Hue[0.6649633945747178],
     GraphicsColor->Hue[0.6649633945747178],
     FontSize->13,
     FontSlant->Italic,
     FontColor->Hue[0.6649633945747178]], {0.4063659183633388, 0.5985326732983776},
     Automatic, Automatic, {0.38494118675765954`, -0.16637617744918565`}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.9077694355709198],
     BackFaceColor->Hue[0.9077694355709198],
     GraphicsColor->Hue[0.9077694355709198],
     FontSize->13,
     FontSlant->Italic,
     FontColor->Hue[0.9077694355709198]], {0.7970191018335757, 0.45537429184911415`},
     Automatic, Automatic, {-0.14121268971871714`, -0.2720420239402199}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.9158857188690623],
     BackFaceColor->Hue[0.9158857188690623],
     GraphicsColor->Hue[0.9158857188690623],
     FontSize->25,
     FontSlant->Italic,
     FontColor->Hue[0.9158857188690623]], {0.001247651557642726, 0.4851467026744556},
     Automatic, Automatic, {-0.8680206637525747, 0.33122054218903907`}]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  ImageSize->300]], "Output",
 ImageSize->{304, 224},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->590615445]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20800],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsGroup"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Item",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Item"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Graphics3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics3D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Locator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Text",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Text"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rectangle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rectangle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Panel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Panel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotMarkers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotMarkers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSizeAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSizeAction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scale",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scale"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rotate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rotate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Magnify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magnify"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22894]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27812],

Cell[TextData[ButtonBox["Insetting Objects in Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/InsettingObjectsInGraphics"]], "Tutorials",
 CellID->96742094]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Inset",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Inset"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->245423985],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->292392854],

Cell[TextData[ButtonBox["Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombiningGraphics"]], "MoreAbout",
 CellID->523321257],

Cell[TextData[ButtonBox["Dynamic Graphics Elements",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicGraphicsElements"]], "MoreAbout",
 CellID->290752885],

Cell[TextData[ButtonBox["Graphics Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsObjects"]], "MoreAbout",
 CellID->426942214],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->226335937],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->197013227],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->768434385],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->394610259]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Inset - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 1.4620714}", "context" -> "System`", 
    "keywords" -> {
     "inset graphic into graphics", "inset text into graphics", 
      "inset 3D graphics into graphics", "transforming graphics", 
      "picture in picture", "inset pictures", "collages"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Inset[obj] represents an object obj inset in a graphic. Inset[obj, pos] \
specifies that the inset should be placed at position pos in the graphic. \
Inset[obj, pos, opos] aligns the inset so that position opos in the object \
lies at position pos in the enclosing graphic. Inset[obj, pos, opos, size] \
specifies the size of the inset in the coordinate system of the enclosing \
graphic. Inset[obj, pos, opos, size, dirs] specifies that the axes of the \
inset should be oriented in directions dirs. ", "synonyms" -> {}, "title" -> 
    "Inset", "type" -> "Symbol", "uri" -> "ref/Inset"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[26589, 867, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->332188086]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 305758, 7329}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4344, 89, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4967, 116, 1570, 37, 70, "ObjectNameGrid"],
Cell[6540, 155, 2659, 83, 70, "Usage",
 CellID->14222]
}, Open  ]],
Cell[CellGroupData[{
Cell[9236, 243, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9714, 260, 419, 13, 70, "Notes",
 CellID->975],
Cell[10136, 275, 191, 6, 70, "Notes",
 CellID->4255],
Cell[10330, 283, 62, 1, 70, "Notes",
 CellID->416],
Cell[10395, 286, 2338, 70, 70, "2ColumnTableMod",
 CellID->8119],
Cell[12736, 358, 744, 30, 70, "Notes",
 CellID->26066],
Cell[13483, 390, 869, 35, 70, "Notes",
 CellID->3536],
Cell[14355, 427, 249, 8, 70, "Notes",
 CellID->21654],
Cell[14607, 437, 232, 7, 70, "Notes",
 CellID->31474],
Cell[14842, 446, 513, 20, 70, "Notes",
 CellID->22385],
Cell[15358, 468, 481, 17, 70, "Notes",
 CellID->4304],
Cell[15842, 487, 288, 11, 70, "Notes",
 CellID->30047],
Cell[16133, 500, 810, 21, 70, "2ColumnTableMod",
 CellID->1819],
Cell[16946, 523, 447, 17, 70, "Notes",
 CellID->32610],
Cell[17396, 542, 574, 21, 70, "Notes",
 CellID->21434],
Cell[17973, 565, 302, 8, 70, "Notes",
 CellID->6935],
Cell[18278, 575, 275, 8, 70, "Notes",
 CellID->29570],
Cell[18556, 585, 424, 15, 70, "Notes",
 CellID->26286],
Cell[18983, 602, 319, 11, 70, "Notes",
 CellID->16405],
Cell[19305, 615, 140, 6, 70, "Notes",
 CellID->25231],
Cell[19448, 623, 3086, 99, 70, "2ColumnTableMod",
 CellID->22723],
Cell[22537, 724, 267, 9, 70, "Notes",
 CellID->24620],
Cell[22807, 735, 357, 11, 70, "Notes",
 CellID->17173],
Cell[23167, 748, 548, 21, 70, "Notes",
 CellID->18782],
Cell[23718, 771, 434, 17, 70, "Notes",
 CellID->214993187],
Cell[24155, 790, 206, 8, 70, "Notes",
 CellID->3613],
Cell[24364, 800, 1810, 48, 70, "3ColumnTableMod",
 CellID->24768],
Cell[26177, 850, 375, 12, 70, "Notes",
 CellID->871495]
}, Closed]],
Cell[CellGroupData[{
Cell[26589, 867, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->332188086],
Cell[CellGroupData[{
Cell[26974, 881, 148, 5, 70, "ExampleSection",
 CellID->136229339],
Cell[27125, 888, 67, 1, 70, "ExampleText",
 CellID->72880157],
Cell[CellGroupData[{
Cell[27217, 893, 422, 14, 28, "Input",
 CellID->487826758],
Cell[27642, 909, 5136, 88, 171, "Output",
 Evaluatable->False,
 CellID->887026338]
}, Open  ]],
Cell[32793, 1000, 125, 3, 70, "ExampleDelimiter",
 CellID->362827247],
Cell[32921, 1005, 77, 1, 70, "ExampleText",
 CellID->366593615],
Cell[CellGroupData[{
Cell[33023, 1010, 415, 14, 70, "Input",
 CellID->18946940],
Cell[33441, 1026, 364, 11, 133, "Output",
 CellID->178088740]
}, Open  ]],
Cell[33820, 1040, 125, 3, 70, "ExampleDelimiter",
 CellID->151698370],
Cell[33948, 1045, 75, 1, 70, "ExampleText",
 CellID->449816466],
Cell[CellGroupData[{
Cell[34048, 1050, 583, 17, 47, "Input",
 CellID->251926865],
Cell[34634, 1069, 3592, 63, 127, "Output",
 Evaluatable->False,
 CellID->175567406]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38275, 1138, 221, 7, 70, "ExampleSection",
 CellID->149542555],
Cell[CellGroupData[{
Cell[38521, 1149, 230, 7, 70, "ExampleSubsection",
 CellID->451902446],
Cell[38754, 1158, 216, 8, 70, "ExampleText",
 CellID->708131636],
Cell[CellGroupData[{
Cell[38995, 1170, 743, 22, 70, "Input",
 CellID->45399102],
Cell[39741, 1194, 524, 18, 123, "Output",
 CellID->495471172]
}, Open  ]],
Cell[40280, 1215, 318, 12, 70, "ExampleText",
 CellID->118282339],
Cell[CellGroupData[{
Cell[40623, 1231, 373, 11, 70, "Input",
 CellID->124639199],
Cell[40999, 1244, 347, 11, 121, "Output",
 CellID->33994576]
}, Open  ]],
Cell[41361, 1258, 125, 3, 70, "ExampleDelimiter",
 CellID->478150516],
Cell[41489, 1263, 84, 1, 70, "ExampleText",
 CellID->24874326],
Cell[CellGroupData[{
Cell[41598, 1268, 487, 16, 70, "Input",
 CellID->32481493],
Cell[42088, 1286, 405, 13, 162, "Output",
 CellID->593152126]
}, Open  ]],
Cell[42508, 1302, 125, 3, 70, "ExampleDelimiter",
 CellID->240881684],
Cell[42636, 1307, 194, 8, 70, "ExampleText",
 CellID->98858528],
Cell[CellGroupData[{
Cell[42855, 1319, 529, 17, 70, "Input",
 CellID->16077544],
Cell[43387, 1338, 416, 13, 162, "Output",
 CellID->295200074]
}, Open  ]],
Cell[43818, 1354, 125, 3, 70, "ExampleDelimiter",
 CellID->310744906],
Cell[43946, 1359, 239, 7, 70, "ExampleText",
 CellID->204734463],
Cell[CellGroupData[{
Cell[44210, 1370, 747, 24, 70, "Input",
 CellID->31285653],
Cell[44960, 1396, 481, 15, 133, "Output",
 CellID->2787691]
}, Open  ]],
Cell[45456, 1414, 125, 3, 70, "ExampleDelimiter",
 CellID->177144847],
Cell[45584, 1419, 195, 8, 70, "ExampleText",
 CellID->295814833],
Cell[CellGroupData[{
Cell[45804, 1431, 546, 18, 70, "Input",
 CellID->567715396],
Cell[46353, 1451, 406, 12, 121, "Output",
 CellID->91701912]
}, Open  ]],
Cell[46774, 1466, 124, 3, 70, "ExampleDelimiter",
 CellID->26503835],
Cell[46901, 1471, 79, 1, 70, "ExampleText",
 CellID->127055650],
Cell[CellGroupData[{
Cell[47005, 1476, 510, 17, 70, "Input",
 CellID->33958350],
Cell[47518, 1495, 604, 17, 123, "Output",
 CellID->172892161]
}, Open  ]],
Cell[CellGroupData[{
Cell[48159, 1517, 511, 17, 70, "Input",
 CellID->270810687],
Cell[48673, 1536, 602, 17, 123, "Output",
 CellID->1751586]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49324, 1559, 230, 7, 70, "ExampleSubsection",
 CellID->47364530],
Cell[49557, 1568, 225, 8, 70, "ExampleText",
 CellID->58274548],
Cell[CellGroupData[{
Cell[49807, 1580, 905, 27, 70, "Input",
 CellID->115309776],
Cell[50715, 1609, 523, 18, 123, "Output",
 CellID->689322422]
}, Open  ]],
Cell[51253, 1630, 318, 12, 70, "ExampleText",
 CellID->396420914],
Cell[CellGroupData[{
Cell[51596, 1646, 439, 13, 70, "Input",
 CellID->14736714],
Cell[52038, 1661, 342, 11, 121, "Output",
 CellID->628273418]
}, Open  ]],
Cell[52395, 1675, 125, 3, 70, "ExampleDelimiter",
 CellID->494427806],
Cell[52523, 1680, 124, 3, 70, "ExampleText",
 CellID->841860508],
Cell[CellGroupData[{
Cell[52672, 1687, 760, 24, 70, "Input",
 CellID->166865608],
Cell[53435, 1713, 730, 23, 123, "Output",
 CellID->3455456]
}, Open  ]],
Cell[CellGroupData[{
Cell[54202, 1741, 759, 24, 70, "Input",
 CellID->57894440],
Cell[54964, 1767, 732, 23, 123, "Output",
 CellID->269262515]
}, Open  ]],
Cell[55711, 1793, 125, 3, 70, "ExampleDelimiter",
 CellID->393547073],
Cell[55839, 1798, 118, 3, 70, "ExampleText",
 CellID->270213322],
Cell[55960, 1803, 620, 20, 70, "Input",
 CellID->12285342],
Cell[CellGroupData[{
Cell[56605, 1827, 696, 22, 70, "Input",
 CellID->472765693],
Cell[57304, 1851, 5311, 91, 70, "Output",
 Evaluatable->False,
 CellID->513949018]
}, Open  ]],
Cell[CellGroupData[{
Cell[62652, 1947, 698, 23, 70, "Input",
 CellID->574508612],
Cell[63353, 1972, 4712, 81, 70, "Output",
 Evaluatable->False,
 CellID->36721199]
}, Open  ]],
Cell[68080, 2056, 124, 3, 70, "ExampleDelimiter",
 CellID->17512351],
Cell[68207, 2061, 166, 6, 70, "ExampleText",
 CellID->265052685],
Cell[68376, 2069, 522, 16, 70, "Input",
 CellID->475449113],
Cell[CellGroupData[{
Cell[68923, 2089, 485, 14, 70, "Input",
 CellID->391372021],
Cell[69411, 2105, 3083, 55, 70, "Output",
 Evaluatable->False,
 CellID->821098972]
}, Open  ]],
Cell[72509, 2163, 165, 6, 70, "ExampleText",
 CellID->26878365],
Cell[CellGroupData[{
Cell[72699, 2173, 485, 14, 70, "Input",
 CellID->585356332],
Cell[73187, 2189, 2943, 52, 70, "Output",
 Evaluatable->False,
 CellID->96261497]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[76179, 2247, 226, 7, 70, "ExampleSubsection",
 CellID->262482467],
Cell[76408, 2256, 261, 8, 70, "ExampleText",
 CellID->43448241],
Cell[76672, 2266, 418, 12, 70, "Input",
 CellID->122198035],
Cell[CellGroupData[{
Cell[77115, 2282, 731, 22, 70, "Input",
 CellID->33528725],
Cell[77849, 2306, 4840, 84, 70, "Output",
 Evaluatable->False,
 CellID->239295371]
}, Open  ]],
Cell[82704, 2393, 125, 3, 70, "ExampleDelimiter",
 CellID->481200231],
Cell[82832, 2398, 95, 1, 70, "ExampleText",
 CellID->127954471],
Cell[CellGroupData[{
Cell[82952, 2403, 585, 18, 70, "Input",
 CellID->371823481],
Cell[83540, 2423, 511, 16, 123, "Output",
 CellID->218374147]
}, Open  ]],
Cell[84066, 2442, 125, 3, 70, "ExampleDelimiter",
 CellID->247658495],
Cell[84194, 2447, 119, 3, 70, "ExampleText",
 CellID->87556433],
Cell[84316, 2452, 366, 11, 70, "Input",
 CellID->17716294],
Cell[CellGroupData[{
Cell[84707, 2467, 627, 20, 70, "Input",
 CellID->141577087],
Cell[85337, 2489, 8101, 137, 70, "Output",
 Evaluatable->False,
 CellID->353561883]
}, Open  ]],
Cell[93453, 2629, 125, 3, 70, "ExampleDelimiter",
 CellID->403326058],
Cell[93581, 2634, 154, 4, 70, "ExampleText",
 CellID->490824923],
Cell[93738, 2640, 421, 12, 70, "Input",
 CellID->61635207],
Cell[CellGroupData[{
Cell[94184, 2656, 679, 21, 70, "Input",
 CellID->93271662],
Cell[94866, 2679, 9711, 163, 70, "Output",
 Evaluatable->False,
 CellID->162886604]
}, Open  ]],
Cell[104592, 2845, 125, 3, 70, "ExampleDelimiter",
 CellID->440083380],
Cell[104720, 2850, 322, 10, 70, "ExampleText",
 CellID->313904953],
Cell[105045, 2862, 164, 5, 70, "Input",
 CellID->188941247],
Cell[CellGroupData[{
Cell[105234, 2871, 728, 23, 70, "Input",
 CellID->964571532],
Cell[105965, 2896, 702, 18, 176, "Output",
 CellID->80589204]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[106716, 2920, 231, 7, 70, "ExampleSubsection",
 CellID->467290813],
Cell[106950, 2929, 198, 6, 70, "ExampleText",
 CellID->696495985],
Cell[107151, 2937, 387, 12, 70, "Input",
 CellID->718128506],
Cell[CellGroupData[{
Cell[107563, 2953, 653, 22, 70, "Input",
 CellID->157232685],
Cell[108219, 2977, 7471, 127, 70, "Output",
 Evaluatable->False,
 CellID->328706877]
}, Open  ]],
Cell[CellGroupData[{
Cell[115727, 3109, 674, 22, 70, "Input",
 CellID->517675944],
Cell[116404, 3133, 741, 23, 123, "Output",
 CellID->637182904]
}, Open  ]],
Cell[117160, 3159, 125, 3, 70, "ExampleDelimiter",
 CellID->594629384],
Cell[117288, 3164, 198, 6, 70, "ExampleText",
 CellID->192705398],
Cell[117489, 3172, 387, 12, 70, "Input",
 CellID->106034834],
Cell[CellGroupData[{
Cell[117901, 3188, 705, 22, 70, "Input",
 CellID->402927335],
Cell[118609, 3212, 7402, 126, 70, "Output",
 Evaluatable->False,
 CellID->171176787]
}, Open  ]],
Cell[CellGroupData[{
Cell[126048, 3343, 740, 24, 70, "Input",
 CellID->67456907],
Cell[126791, 3369, 780, 23, 123, "Output",
 CellID->862523671]
}, Open  ]],
Cell[127586, 3395, 125, 3, 70, "ExampleDelimiter",
 CellID->184018105],
Cell[127714, 3400, 244, 9, 70, "ExampleText",
 CellID->445281689],
Cell[127961, 3411, 387, 12, 70, "Input",
 CellID->525255113],
Cell[CellGroupData[{
Cell[128373, 3427, 462, 14, 70, "Input",
 CellID->424535648],
Cell[128838, 3443, 3562, 63, 70, "Output",
 Evaluatable->False,
 CellID->39121679]
}, Open  ]],
Cell[CellGroupData[{
Cell[132437, 3511, 553, 17, 70, "Input",
 CellID->152450187],
Cell[132993, 3530, 451, 13, 121, "Output",
 CellID->437993807]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[133505, 3550, 237, 7, 70, "ExampleSection",
 CellID->839],
Cell[133745, 3559, 146, 6, 70, "ExampleText",
 CellID->178591179],
Cell[CellGroupData[{
Cell[133916, 3569, 579, 18, 70, "Input",
 CellID->581921417],
Cell[134498, 3589, 401, 11, 121, "Output",
 CellID->95681562]
}, Open  ]],
Cell[134914, 3603, 125, 3, 70, "ExampleDelimiter",
 CellID->575453613],
Cell[135042, 3608, 146, 6, 70, "ExampleText",
 CellID->127188552],
Cell[CellGroupData[{
Cell[135213, 3618, 579, 18, 70, "Input",
 CellID->108914382],
Cell[135795, 3638, 402, 11, 121, "Output",
 CellID->722916172]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[136246, 3655, 222, 7, 70, "ExampleSection",
 CellID->198516876],
Cell[CellGroupData[{
Cell[136493, 3666, 229, 7, 70, "ExampleSubsection",
 CellID->35704154],
Cell[136725, 3675, 92, 1, 70, "ExampleText",
 CellID->642016114],
Cell[136820, 3678, 154, 5, 70, "Input",
 CellID->50263331],
Cell[CellGroupData[{
Cell[136999, 3687, 640, 20, 70, "Input",
 CellID->252409706],
Cell[137642, 3709, 926, 23, 123, "Output",
 CellID->23667392]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[138617, 3738, 229, 7, 70, "ExampleSubsection",
 CellID->4500943],
Cell[138849, 3747, 72, 1, 70, "ExampleText",
 CellID->184101264],
Cell[CellGroupData[{
Cell[138946, 3752, 403, 13, 70, "Input",
 CellID->176800642],
Cell[139352, 3767, 404, 12, 171, "Output",
 CellID->2766543]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[139805, 3785, 230, 7, 70, "ExampleSubsection",
 CellID->168767647],
Cell[140038, 3794, 66, 1, 70, "ExampleText",
 CellID->65039657],
Cell[CellGroupData[{
Cell[140129, 3799, 440, 13, 70, "Input",
 CellID->20543643],
Cell[140572, 3814, 506, 14, 171, "Output",
 CellID->259089229]
}, Open  ]],
Cell[141093, 3831, 124, 3, 70, "ExampleDelimiter",
 CellID->34951749],
Cell[141220, 3836, 62, 1, 70, "ExampleText",
 CellID->682617663],
Cell[CellGroupData[{
Cell[141307, 3841, 307, 9, 70, "Input",
 CellID->428511758],
Cell[141617, 3852, 319, 10, 171, "Output",
 CellID->196092109]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[141985, 3868, 238, 7, 70, "ExampleSubsection",
 CellID->293683928],
Cell[142226, 3877, 97, 1, 70, "ExampleText",
 CellID->61780937],
Cell[142326, 3880, 264, 9, 70, "Input",
 CellID->132359157],
Cell[CellGroupData[{
Cell[142615, 3893, 590, 18, 70, "Input",
 CellID->126989272],
Cell[143208, 3913, 7196, 122, 70, "Output",
 Evaluatable->False,
 CellID->4021208]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[150453, 4041, 231, 7, 70, "ExampleSubsection",
 CellID->261032255],
Cell[150687, 4050, 241, 8, 70, "ExampleText",
 CellID->130415530],
Cell[CellGroupData[{
Cell[150953, 4062, 404, 14, 70, "Input",
 CellID->140419832],
Cell[151360, 4078, 433, 14, 121, "Output",
 CellID->335976202]
}, Open  ]],
Cell[151808, 4095, 125, 3, 70, "ExampleDelimiter",
 CellID->127269120],
Cell[151936, 4100, 217, 8, 70, "ExampleText",
 CellID->260195582],
Cell[CellGroupData[{
Cell[152178, 4112, 491, 16, 70, "Input",
 CellID->225311832],
Cell[152672, 4130, 463, 15, 121, "Output",
 CellID->251054021]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[153196, 4152, 222, 7, 70, "ExampleSection",
 CellID->2025],
Cell[153421, 4161, 78, 1, 70, "ExampleText",
 CellID->552131345],
Cell[153502, 4164, 1729, 48, 70, "Input",
 CellID->303183403],
Cell[CellGroupData[{
Cell[155256, 4216, 348, 11, 70, "Input",
 CellID->264622111],
Cell[155607, 4229, 36514, 622, 70, "Output",
 CellID->79305454]
}, Open  ]],
Cell[192136, 4854, 124, 3, 70, "ExampleDelimiter",
 CellID->73747830],
Cell[192263, 4859, 60, 1, 70, "ExampleText",
 CellID->156782874],
Cell[192326, 4862, 470, 11, 70, "Input",
 CellID->754824207],
Cell[192799, 4875, 213, 8, 70, "ExampleText",
 CellID->664991618],
Cell[193015, 4885, 1550, 43, 70, "Input",
 CellID->336499226],
Cell[194568, 4930, 80, 1, 70, "ExampleText",
 CellID->473137457],
Cell[CellGroupData[{
Cell[194673, 4935, 470, 14, 70, "Input",
 CellID->307789243],
Cell[195146, 4951, 40112, 663, 70, "Output",
 Evaluatable->False,
 CellID->350764487]
}, Open  ]],
Cell[235273, 5617, 124, 3, 70, "ExampleDelimiter",
 CellID->97836616],
Cell[235400, 5622, 75, 1, 70, "ExampleText",
 CellID->690395492],
Cell[235478, 5625, 2052, 58, 70, "Input",
 CellID->172501340],
Cell[237533, 5685, 87, 1, 70, "ExampleText",
 CellID->548036387],
Cell[CellGroupData[{
Cell[237645, 5690, 269, 9, 70, "Input",
 CellID->58071330],
Cell[237917, 5701, 16135, 410, 70, "Output",
 CellID->2278029]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[254101, 6117, 233, 7, 70, "ExampleSection",
 CellID->14789],
Cell[254337, 6126, 239, 8, 70, "ExampleText",
 CellID->42742432],
Cell[CellGroupData[{
Cell[254601, 6138, 806, 26, 70, "Input",
 CellID->365834959],
Cell[255410, 6166, 846, 26, 83, "Output",
 CellID->223973667]
}, Open  ]],
Cell[CellGroupData[{
Cell[256293, 6197, 806, 26, 70, "Input",
 CellID->806731238],
Cell[257102, 6225, 846, 26, 163, "Output",
 CellID->49394387]
}, Open  ]],
Cell[257963, 6254, 125, 3, 70, "ExampleDelimiter",
 CellID->245588419],
Cell[258091, 6259, 355, 13, 70, "ExampleText",
 CellID->183301216],
Cell[CellGroupData[{
Cell[258471, 6276, 415, 14, 70, "Input",
 CellID->321628380],
Cell[258889, 6292, 388, 12, 121, "Output",
 CellID->237389153]
}, Open  ]],
Cell[CellGroupData[{
Cell[259314, 6309, 466, 15, 70, "Input",
 CellID->401912615],
Cell[259783, 6326, 27701, 462, 184, 251, 7, "CachedBoxData", "BoxData", \
"Output",
 CellID->53420086]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[287533, 6794, 223, 7, 70, "ExampleSection",
 CellID->2986],
Cell[287759, 6803, 65, 1, 70, "ExampleText",
 CellID->25885965],
Cell[CellGroupData[{
Cell[287849, 6808, 1041, 29, 70, "Input",
 CellID->341600935],
Cell[288893, 6839, 8533, 207, 245, "Output",
 CellID->590615445]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[297487, 7053, 311, 9, 70, "SeeAlsoSection",
 CellID->20800],
Cell[297801, 7064, 3383, 125, 70, "SeeAlso",
 CellID->22894]
}, Open  ]],
Cell[CellGroupData[{
Cell[301221, 7194, 314, 9, 70, "TutorialsSection",
 CellID->27812],
Cell[301538, 7205, 169, 3, 70, "Tutorials",
 CellID->96742094]
}, Open  ]],
Cell[CellGroupData[{
Cell[301744, 7213, 305, 8, 70, "RelatedLinksSection"],
Cell[302052, 7223, 355, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[302444, 7240, 319, 9, 70, "MoreAboutSection",
 CellID->245423985],
Cell[302766, 7251, 173, 3, 70, "MoreAbout",
 CellID->292392854],
Cell[302942, 7256, 147, 3, 70, "MoreAbout",
 CellID->523321257],
Cell[303092, 7261, 160, 3, 70, "MoreAbout",
 CellID->290752885],
Cell[303255, 7266, 143, 3, 70, "MoreAbout",
 CellID->426942214],
Cell[303401, 7271, 163, 3, 70, "MoreAbout",
 CellID->226335937],
Cell[303567, 7276, 162, 3, 70, "MoreAbout",
 CellID->197013227],
Cell[303732, 7281, 197, 4, 70, "MoreAbout",
 CellID->768434385],
Cell[303932, 7287, 179, 3, 70, "MoreAbout",
 CellID->394610259]
}, Open  ]],
Cell[304126, 7293, 27, 0, 70, "History"],
Cell[304156, 7295, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

