(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30076,       1075]
NotebookOptionsPosition[     23477,        852]
NotebookOutlinePosition[     25212,        900]
CellTagsIndexPosition[     25045,        893]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink" :> 
          Documentation`HelpLookup["paclet:tutorial/MathLink"], 
          "Installing Existing MathLink-Compatible Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"], 
          "Setting Up External Functions to Be Called from Mathematica" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SettingUpExternalFunctionsToBeCalledFromMathematica"], 
          "Portability of MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PortabilityOfMathLinkPrograms"], 
          "Two\[Hyphen]Way Communication with External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TwoWayCommunicationWithExternalPrograms"], 
          "Running Programs on Remote Computers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RunningProgramsOnRemoteComputers"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MathLink\"\>", 
       2->"\<\"Installing Existing MathLink-Compatible Programs\"\>", 
       3->"\<\"Setting Up External Functions to Be Called from \
Mathematica\"\>", 4->"\<\"Portability of MathLink Programs\"\>", 
       5->"\<\"Two\[Hyphen]Way Communication with External Programs\"\>", 
       6->"\<\"Running Programs on Remote Computers\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Get" :> Documentation`HelpLookup["paclet:ref/Get"], "Run" :> 
          Documentation`HelpLookup["paclet:ref/Run"], "RunThrough" :> 
          Documentation`HelpLookup["paclet:ref/RunThrough"], "LinkLaunch" :> 
          Documentation`HelpLookup["paclet:ref/LinkLaunch"], "Uninstall" :> 
          Documentation`HelpLookup["paclet:ref/Uninstall"], "$CurrentLink" :> 
          Documentation`HelpLookup["paclet:ref/$CurrentLink"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Get\"\>", 2->"\<\"Run\"\>", 
       3->"\<\"RunThrough\"\>", 4->"\<\"LinkLaunch\"\>", 
       5->"\<\"Uninstall\"\>", 6->"\<\"$CurrentLink\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup["paclet:guide/CallingExternalPrograms"], 
          "C/C++ Language Interface" :> 
          Documentation`HelpLookup["paclet:guide/CLanguageInterface"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Installable MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/InstallableMathLinkPrograms"], "MathLink API" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkAPI"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Calling External Programs\"\>", 
       2->"\<\"C/C++ Language Interface\"\>", 
       3->"\<\"External Operations\"\>", 
       4->"\<\"Installable MathLink Programs\"\>", 
       5->"\<\"MathLink API\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Install", "ObjectName",
 CellID->3215],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Install",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]starts a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     "-compatible external program and installs ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " definitions to call functions in it. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4140]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " definitions set up by ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 " are typically specified in the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template file used to create the source code for the external program. "
}], "Notes",
 CellID->28152],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\"prog\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " will launch the specified program, then connect to it via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ". "
}], "Notes",
 CellID->217],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["prog", "TI"]], "InlineFormula"],
 " is a directory, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\"prog\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " will try to execute ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["prog", "TI"], "/", 
    ButtonBox["$SystemID",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$SystemID"]}], "/", 
   StyleBox["prog", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20695],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"name\", \"TI\"]`\)]\)\>\"", "]"}]], "InlineFormula"],
 " searches all directories on ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 " for a file or directory called ",
 Cell[BoxData[
  RowBox[{
   StyleBox["name", "TI"], ".", "exe"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24232],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "[", 
   StyleBox["link", "TI"], "]"}]], "InlineFormula"],
 " will take an existing ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 " and set up what is needed to call functions in the program corresponding \
to that ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13513],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 " representing the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection it is using. "
}], "Notes",
 CellID->2267],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinkPatterns",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkPatterns"], "[", 
   StyleBox["link", "TI"], "]"}]], "InlineFormula"],
 " gives a list of the patterns defined when the specified link was set up. "
}], "Notes",
 CellID->18868],

Cell[TextData[{
 "You can remove these definitions, and terminate the execution of the \
external program by calling ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Uninstall",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Uninstall"], "[", 
   StyleBox["link", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20137],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "[", 
   RowBox[{
    ButtonBox["LinkConnect",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LinkConnect"], "[", "\"\<\!\(\*
StyleBox[\"port\", \"TI\"]\)\>\"", "]"}], "]"}]], "InlineFormula"],
 " will install an external program that has created a link on the specified \
port. You can use this to call external programs that have been started in a \
debugger or on a remote computer system. "
}], "Notes",
 CellID->11577],

Cell[TextData[{
 "If you call ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"], "[", "\"\<\!\(\*
StyleBox[\"command\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " multiple times with the same ",
 Cell[BoxData[
  StyleBox["command", "TI"]], "InlineFormula"],
 ", the later calls will overwrite definitions set up by earlier ones, unless \
the definitions depend on the values of global variables which have changed. \
"
}], "Notes",
 CellID->15723],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 " sets up definitions which send ",
 Cell[BoxData[
  ButtonBox["CallPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CallPacket"]], "InlineFormula"],
 " objects to the external program whenever functions in it are called, and \
waits for results to be returned in ",
 Cell[BoxData[
  ButtonBox["ReturnPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReturnPacket"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->27807],

Cell[TextData[{
 "The external program can send ",
 Cell[BoxData[
  ButtonBox["EvaluatePacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EvaluatePacket"]], "InlineFormula"],
 " objects back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to request evaluations while the program is running. "
}], "Notes",
 CellID->21848]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->244699831],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->158759444],

Cell["Set the directory: ", "ExampleText",
 CellContext->"Global`",
 CellID->672120963],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{
   "$InstallationDirectory", "<>", " ", 
    "\"\</SystemFiles/Links/MathLink/DeveloperKit/\>\"", "<>", "$SystemID", 
    "<>", "\"\</PrebuiltExamples/\>\""}], "]"}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->187884416],

Cell[TextData[{
 "Install an external ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "-compatible program:"
}], "ExampleText",
 CellID->559961695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"Install", "[", "\"\<addtwo\>\"", "]"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->278797890],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"addtwo\"\>", ",", "149", ",", "7"}], "]"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48240956]
}, Open  ]],

Cell["Get usage information about linked-in symbols: ", "ExampleText",
 CellContext->"Global`",
 CellID->228134327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "AddTwo"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->242314195],

Cell[BoxData[
 StyleBox["\<\"AddTwo[x, y] gives the sum of two machine integers x and \
y.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3384534333-8440776",
 CellID->187422898]
}, Open  ]],

Cell["Use the new function: ", "ExampleText",
 CellContext->"Global`",
 CellID->952845457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AddTwo", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[4]:=",
 CellID->201895159],

Cell[BoxData["3"], "Output",
 CellContext->"Global`",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->808986841]
}, Open  ]],

Cell["Terminate the external program:", "ExampleText",
 CellContext->"Global`",
 CellID->1721532427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Uninstall", "[", "link", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[5]:=",
 CellID->748324558],

Cell[BoxData["\<\"addtwo\"\>"], "Output",
 CellContext->"Global`",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->581015599]
}, Open  ]],

Cell["Reset to the original directory: ", "ExampleText",
 CellID->565310621],

Cell[BoxData[
 RowBox[{
  RowBox[{"ResetDirectory", "[", "]"}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[6]:=",
 CellID->312836734]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellContext->"Global`",
 CellID->7487],

Cell["Set the directory: ", "ExampleText",
 CellContext->"Global`",
 CellID->210774478],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{
   "$InstallationDirectory", "<>", " ", 
    "\"\</SystemFiles/Links/MathLink/DeveloperKit/\>\"", "<>", "$SystemID", 
    "<>", "\"\</PrebuiltExamples/\>\""}], "]"}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->506558866],

Cell[TextData[{
 "Install an external ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "-compatible program:"
}], "ExampleText",
 CellContext->"Global`",
 CellID->287270249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"Install", "[", "\"\<addtwo\>\"", "]"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->825582282],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"addtwo\"\>", ",", "150", ",", "7"}], "]"}]], "Output",
 CellContext->"Global`",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->33927630]
}, Open  ]],

Cell[TextData[{
 "Get the complete set of ",
 Cell[BoxData[
  ButtonBox["LinkPatterns",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkPatterns"]], "InlineFormula"],
 " installed: "
}], "ExampleText",
 CellContext->"Global`",
 CellID->73579464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkPatterns", "[", "link", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->59619846],

Cell[BoxData[
 RowBox[{"{", 
  TagBox[
   RowBox[{"AddTwo", "[", 
    RowBox[{"i_Integer", ",", "j_Integer"}], "]"}],
   HoldForm], "}"}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->17083812]
}, Open  ]],

Cell["Get usage information about linked in symbols: ", "ExampleText",
 CellContext->"Global`",
 CellID->661897471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "AddTwo"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[4]:=",
 CellID->227051880],

Cell[BoxData[
 StyleBox["\<\"AddTwo[x, y] gives the sum of two machine integers x and \
y.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3384534449-3196840",
 CellID->290522849]
}, Open  ]],

Cell["Use the new function: ", "ExampleText",
 CellContext->"Global`",
 CellID->125900338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AddTwo", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[5]:=",
 CellID->56273106],

Cell[BoxData["3"], "Output",
 CellContext->"Global`",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->94408714]
}, Open  ]],

Cell["Uninstall the external program:", "ExampleText",
 CellContext->"Global`",
 CellID->184445389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Uninstall", "[", "link", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[6]:=",
 CellID->51547842],

Cell[BoxData["\<\"addtwo\"\>"], "Output",
 CellContext->"Global`",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->463343679]
}, Open  ]],

Cell["Reset to the original directory: ", "ExampleText",
 CellContext->"Global`",
 CellID->82136485],

Cell[BoxData[
 RowBox[{
  RowBox[{"ResetDirectory", "[", "]"}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[7]:=",
 CellID->304638792]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7129],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Run",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Run"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RunThrough",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RunThrough"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkLaunch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkLaunch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Uninstall",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Uninstall"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CurrentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CurrentLink"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23032]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14114],

Cell[TextData[StyleBox[ButtonBox["MathLink",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathLink"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->271],

Cell[TextData[{
 ButtonBox["Installing Existing ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"],
  
  FontSlant->"Italic"],
 ButtonBox["-Compatible Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"]
}], "Tutorials",
 CellID->19418],

Cell[TextData[{
 ButtonBox["Setting Up External Functions to Be Called from ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->361474453],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "Tutorials",
 CellID->65592066],

Cell[TextData[ButtonBox["Two\[Hyphen]Way Communication with External \
Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TwoWayCommunicationWithExternalPrograms"]], "Tutorials",
 CellID->26516],

Cell[TextData[ButtonBox["Running Programs on Remote Computers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RunningProgramsOnRemoteComputers"]], "Tutorials",\

 CellID->545737127]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->585923710],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->427136842],

Cell[TextData[ButtonBox["C/C++ Language Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CLanguageInterface"]], "MoreAbout",
 CellID->1520387],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->1080306],

Cell[TextData[ButtonBox["Installable MathLink Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InstallableMathLinkPrograms"]], "MoreAbout",
 CellID->190058],

Cell[TextData[ButtonBox["MathLink API",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkAPI"]], "MoreAbout",
 CellID->38917378]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Install - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 6.0403136}", "context" -> "System`", 
    "keywords" -> {
     "add external function", "extend functions", "install external program", 
      "install MathLink program", "running external programs"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Install[\"name\"] starts a MathLink-compatible external program and \
installs Mathematica definitions to call functions in it. ", "synonyms" -> {},
     "title" -> "Install", "type" -> "Symbol", "uri" -> "ref/Install"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11385, 365, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->244699831]},
 "Info3384534333-8440776"->{
  Cell[13194, 440, 185, 4, 70, "Print",
   CellTags->"Info3384534333-8440776",
   CellID->187422898]},
 "Info3384534449-3196840"->{
  Cell[16869, 601, 185, 4, 70, "Print",
   CellTags->"Info3384534449-3196840",
   CellID->290522849]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24637, 878},
 {"Info3384534333-8440776", 24787, 882},
 {"Info3384534449-3196840", 24919, 886}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3995, 84, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4618, 111, 44, 1, 70, "ObjectName",
 CellID->3215],
Cell[4665, 114, 675, 21, 70, "Usage",
 CellID->4140]
}, Open  ]],
Cell[CellGroupData[{
Cell[5377, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5855, 157, 406, 14, 70, "Notes",
 CellID->28152],
Cell[6264, 173, 348, 12, 70, "Notes",
 CellID->217],
Cell[6615, 187, 577, 22, 70, "Notes",
 CellID->20695],
Cell[7195, 211, 528, 19, 70, "Notes",
 CellID->24232],
Cell[7726, 232, 584, 20, 70, "Notes",
 CellID->13513],
Cell[8313, 254, 397, 15, 70, "Notes",
 CellID->2267],
Cell[8713, 271, 303, 9, 70, "Notes",
 CellID->18868],
Cell[9019, 282, 329, 11, 70, "Notes",
 CellID->20137],
Cell[9351, 295, 557, 15, 70, "Notes",
 CellID->11577],
Cell[9911, 312, 513, 15, 70, "Notes",
 CellID->15723],
Cell[10427, 329, 579, 18, 70, "Notes",
 CellID->27807],
Cell[11009, 349, 339, 11, 70, "Notes",
 CellID->21848]
}, Closed]],
Cell[CellGroupData[{
Cell[11385, 365, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->244699831],
Cell[CellGroupData[{
Cell[11770, 379, 148, 5, 70, "ExampleSection",
 CellID->158759444],
Cell[11921, 386, 87, 2, 70, "ExampleText",
 CellID->672120963],
Cell[12011, 390, 319, 9, 70, "Input",
 CellID->187884416],
Cell[12333, 401, 149, 6, 70, "ExampleText",
 CellID->559961695],
Cell[CellGroupData[{
Cell[12507, 411, 167, 5, 28, "Input",
 CellID->278797890],
Cell[12677, 418, 242, 7, 36, "Output",
 CellID->48240956]
}, Open  ]],
Cell[12934, 428, 115, 2, 70, "ExampleText",
 CellID->228134327],
Cell[CellGroupData[{
Cell[13074, 434, 117, 4, 70, "Input",
 CellID->242314195],
Cell[13194, 440, 185, 4, 70, "Print",
 CellTags->"Info3384534333-8440776",
 CellID->187422898]
}, Open  ]],
Cell[13394, 447, 90, 2, 70, "ExampleText",
 CellID->952845457],
Cell[CellGroupData[{
Cell[13509, 453, 150, 5, 70, "Input",
 CellID->201895159],
Cell[13662, 460, 183, 6, 36, "Output",
 CellID->808986841]
}, Open  ]],
Cell[13860, 469, 100, 2, 70, "ExampleText",
 CellID->1721532427],
Cell[CellGroupData[{
Cell[13985, 475, 133, 4, 70, "Input",
 CellID->748324558],
Cell[14121, 481, 196, 6, 36, "Output",
 CellID->581015599]
}, Open  ]],
Cell[14332, 490, 76, 1, 70, "ExampleText",
 CellID->565310621],
Cell[14411, 493, 148, 5, 70, "Input",
 CellID->312836734]
}, Open  ]],
Cell[CellGroupData[{
Cell[14596, 503, 240, 8, 70, "ExampleSection",
 CellID->7487],
Cell[14839, 513, 87, 2, 70, "ExampleText",
 CellID->210774478],
Cell[14929, 517, 319, 9, 70, "Input",
 CellID->506558866],
Cell[15251, 528, 174, 7, 70, "ExampleText",
 CellID->287270249],
Cell[CellGroupData[{
Cell[15450, 539, 167, 5, 70, "Input",
 CellID->825582282],
Cell[15620, 546, 267, 8, 36, "Output",
 CellID->33927630]
}, Open  ]],
Cell[15902, 557, 250, 9, 70, "ExampleText",
 CellID->73579464],
Cell[CellGroupData[{
Cell[16177, 570, 135, 4, 70, "Input",
 CellID->59619846],
Cell[16315, 576, 279, 10, 36, "Output",
 CellID->17083812]
}, Open  ]],
Cell[16609, 589, 115, 2, 70, "ExampleText",
 CellID->661897471],
Cell[CellGroupData[{
Cell[16749, 595, 117, 4, 70, "Input",
 CellID->227051880],
Cell[16869, 601, 185, 4, 70, "Print",
 CellTags->"Info3384534449-3196840",
 CellID->290522849]
}, Open  ]],
Cell[17069, 608, 90, 2, 70, "ExampleText",
 CellID->125900338],
Cell[CellGroupData[{
Cell[17184, 614, 149, 5, 70, "Input",
 CellID->56273106],
Cell[17336, 621, 182, 6, 36, "Output",
 CellID->94408714]
}, Open  ]],
Cell[17533, 630, 99, 2, 70, "ExampleText",
 CellID->184445389],
Cell[CellGroupData[{
Cell[17657, 636, 132, 4, 70, "Input",
 CellID->51547842],
Cell[17792, 642, 196, 6, 36, "Output",
 CellID->463343679]
}, Open  ]],
Cell[18003, 651, 100, 2, 70, "ExampleText",
 CellID->82136485],
Cell[18106, 655, 148, 5, 70, "Input",
 CellID->304638792]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18303, 666, 310, 9, 70, "SeeAlsoSection",
 CellID->7129],
Cell[18616, 677, 1429, 53, 70, "SeeAlso",
 CellID->23032]
}, Open  ]],
Cell[CellGroupData[{
Cell[20082, 735, 314, 9, 70, "TutorialsSection",
 CellID->14114],
Cell[20399, 746, 157, 4, 70, "Tutorials",
 CellID->271],
Cell[20559, 752, 480, 14, 70, "Tutorials",
 CellID->19418],
Cell[21042, 768, 395, 11, 70, "Tutorials",
 CellID->361474453],
Cell[21440, 781, 415, 12, 70, "Tutorials",
 CellID->65592066],
Cell[21858, 795, 207, 5, 70, "Tutorials",
 CellID->26516],
Cell[22068, 802, 185, 4, 70, "Tutorials",
 CellID->545737127]
}, Open  ]],
Cell[CellGroupData[{
Cell[22290, 811, 319, 9, 70, "MoreAboutSection",
 CellID->585923710],
Cell[22612, 822, 160, 3, 70, "MoreAbout",
 CellID->427136842],
Cell[22775, 827, 152, 3, 70, "MoreAbout",
 CellID->1520387],
Cell[22930, 832, 147, 3, 70, "MoreAbout",
 CellID->1080306],
Cell[23080, 837, 165, 3, 70, "MoreAbout",
 CellID->190058],
Cell[23248, 842, 134, 3, 70, "MoreAbout",
 CellID->38917378]
}, Open  ]],
Cell[23397, 848, 50, 0, 70, "History"],
Cell[23450, 850, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

