(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26118,        803]
NotebookOptionsPosition[     20768,        620]
NotebookOutlinePosition[     22946,        687]
CellTagsIndexPosition[     22809,        680]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Internet Connectivity" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InternetConnectivity"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathematica Internet Connectivity\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Import" :> Documentation`HelpLookup["paclet:ref/Import"], 
          "Install" :> Documentation`HelpLookup["paclet:ref/Install"], 
          "LoadJavaClass" :> 
          Documentation`HelpLookup["paclet:JLink/ref/LoadJavaClass"], 
          "LoadNetType" :> 
          Documentation`HelpLookup["paclet:NETLink/ref/LoadNETType"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Import\"\>", 
       2->"\<\"Install\"\>", 3->"\<\"LoadJavaClass\"\>", 
       4->"\<\"LoadNetType\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calling External Programs" :> 
          Documentation`HelpLookup["paclet:guide/CallingExternalPrograms"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Web Operations" :> 
          Documentation`HelpLookup["paclet:guide/WebOperations"], 
          "New in 6.0: System Interfaces & Deployment" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60SystemInterfacesAndDeployment"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Calling External Programs\"\>", 
       2->"\<\"External Operations\"\>", 3->"\<\"Web Operations\"\>", 
       4->"\<\"New in 6.0: System Interfaces & Deployment\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["InstallService", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InstallService",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InstallService"], "[", "\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]installs the web service operations in the WSDL \
description at the URL given."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InstallService",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InstallService"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"url\", \"TI\"]\)\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"context`\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     " \[LineSeparator]installs web service operations, creating functions in \
the specified context."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InstallService",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InstallService"]], "InlineFormula"],
 " defines ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions to call each of the operations in the WSDL description. The \
names of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions will usually be the same as the name specified for the \
operations."
}], "Notes",
 CellID->516264505],

Cell["Options that can be given include:", "Notes",
 CellID->163574834],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<UserName\>\"", Cell[
    "username for the web service requested", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Password\>\"", Cell[
    "password for the web service requested", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Timeout\>\"", Cell[
    "number of seconds to wait during installation", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->639102228]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->454609088],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->575135186],

Cell["Install a web service into a default context:", "ExampleText",
 CellID->20483070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Hello.m?wsdl\
\>\"", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.2.2",
 CellLabel->"In[1]:=",
 CellID->1869],

Cell[BoxData[
 RowBox[{"{", "HelloWorld", "}"}]], "Output", "ConversionLockdown",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.2",
 CellLabel->"Out[1]=",
 CellID->120134232]
}, Open  ]],

Cell["Evaluate the web service:", "ExampleText",
 CellID->30274267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HelloWorld", "[", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[2]:=",
 CellID->53524566],

Cell[BoxData["\<\"Hello! The current date is {2007, 4, 4, 14, 3, \
56.0554143}\"\>"], "Output", "ConversionLockdown",
 ImageSize->{410, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->352263654]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1133610049],

Cell["Install a web service into a custom context:", "ExampleText",
 CellID->355701255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  RowBox[{
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Echo.m?wsdl\>\
\"", ",", " ", "\"\<EchoService`\>\""}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.2.3",
 CellLabel->"In[1]:=",
 CellID->17035],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "EchoBase64Binary", ",", "EchoBoolean", ",", "EchoDate", ",", 
   "EchoDateTime", ",", "EchoDatum", ",", "EchoDatumArray", ",", 
   "EchoExpression", ",", "EchoInteger", ",", "EchoIntegerArray", ",", 
   "EchoMathML", ",", "EchoReal", ",", "EchoString", ",", "EchoTime"}], 
  "}"}]], "Output", "ConversionLockdown",
 ImageSize->{427, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.3",
 CellLabel->"Out[1]=",
 CellID->576037757]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "EchoString", "]"}]], "Input", "ConversionLockdown",
 CellTags->"b:1.2.3",
 CellLabel->"In[2]:=",
 CellID->28703],

Cell[BoxData["\<\"EchoService`\"\>"], "Output", "ConversionLockdown",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.3",
 CellLabel->"Out[2]=",
 CellID->70268943]
}, Open  ]],

Cell["Evaluate the web service:", "ExampleText",
 CellID->246192679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EchoString", "[", "\"\<Hello\>\"", "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[3]:=",
 CellID->240999126],

Cell[BoxData["\<\"Hello\"\>"], "Output", "ConversionLockdown",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->263009907]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->109177359],

Cell[TextData[{
 "Install a web service into a default context without placing the context on \
",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1602630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InstallService", "[", 
  RowBox[{
  "\"\<http://localhost:8080/webMathematica/Examples/WebServices/Plot.m?wsdl\>\
\"", ",", 
   RowBox[{"AllowShortContext", "\[Rule]", "False"}]}], "]"}]], "Input", \
"ConversionLockdown",
 CellTags->"b:1.2.3",
 CellLabel->"In[1]:=",
 CellID->30333],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "PlotServiceService`PlotServicePort`PlotExpression", ",", 
   "PlotServiceService`PlotServicePort`PlotString"}], "}"}]], "Output", \
"ConversionLockdown",
 ImageSize->{361, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:1.2.3",
 CellLabel->"Out[1]=",
 CellID->587135549]
}, Open  ]],

Cell["Evaluate the web service:", "ExampleText",
 CellID->89393617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
   RowBox[{"FromCharacterCode", "[", 
    RowBox[{
     RowBox[{"PlotServiceService`PlotServicePort`PlotString", "[", 
      RowBox[{"\"\<Sin[x]\>\"", ",", "10"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", " ", "\"\<GIF\>\""}], 
  "]"}]], "Input", "ConversionLockdown",
 CellLabel->"In[2]:=",
 CellID->454620743],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztXd162jgQjbslgEMIJSRNaEgwj7SP0Ku929fdx9kQwNjGskbzr13O9227
TYOjHo+OZkajUfX77z9/f7u5ufnn87+/ipub3RWWKKwH8D/BlWcZFEXxRW5x
JPjKsxCK069F449X8KH4MuVceK7Wq+Vy/WE9DDy6PB/p94X17I9ysVyWo/LZ
eihYZGDP72X5cvzf9Xy8Nh0LGv55fm5RuykXldlQ8Kj9DLf+xny+bX9hVW77
vzMneOO5urtU5F/lu8FIeOGM52r22vPVt/yJ9sVzdddH86dIT3OXDl88PzwF
/mJ9l+Ni2IArnp8egn/1815xHALwxPOvcsBoFyu9gQjAUTS4nQytdlX5S20k
AnDD8qfjPBxjv49zlmg/PEcV+HmuMg4ZuOH5Yxx13cpMUx17uOH5/mf0W3JW
Di88v94Bvmm5FB+HFJzwXI0hkXU12YiPRAhOeAZa6stMeBxi8MHzxy1QeQP5
D//wwTM42HubiI5DDi7iwQRHYvYS/x6PcMByEnm5GrQHnpO4yzSf5IHnJC0A
L5m+4IDnRCnI06Ad8Jy4tOWp0PY8J/OWpcthz3MybVkatDnPH6Pkj+Ro0OY8
I5a1HA3aOh5EuWkZGrS1PaNSyhmm7Yx5rm5RpeSTN+6BSMOY54HKmCGsFszj
EIcxz0jDRE4DQ9jy/GuK/GB2wbctz4BN7n6837KOQx6mPBNyb7m5dqY8P/5A
fzQ3186U5xFhNaN81gCW8SDJJjOrmbG0Z1KRQGb7KoY8E32GvFZCQ55/PJI+
DqrIcwNDnqkr2W1Oh90yXQX3IHiF+rDjmayvrlbCajI8GDOeGVjytBJ2T30c
e50U5ufoGWa9p5iw886LM7PGfSHG9JLxauTmNPJ2VM/Or8Yxbnhm2UsNHlNW
R3e/4pJno749ROf5gHXJ8BAWTDuHSBt9keovmIAnDeTFhb4IbS/69RjxzGSJ
XpJJl+OoRaIw1efIGWMoNmOWx5ARX9RteGbzFLq6aAPANqcNz2yer48CA4Df
Y8Mzev+1CxexN6TKwYTnhldPhYcDhZDZacIzY4cHD/18ILPThGfGBg/Vd3Ph
AM1Oi2gQUVoeBpOHSABodlrYM2uC3n77CjQ7LXjmdXqtCzlg28kGPDMHcSwZ
KQJgs9OAZ+akhPVpFVgi3YBn7iQbw44BAcDXrM8zuuY5BNukHVC29Hlm3wSx
TdoBZ6c6zwJHHiyFAzo71XkW8HcthQPq7ajHgwLxm6VwQBd1bXsWqQWwEw7w
oq7Ns0iYbCcc4CBJm2eRtI+dcIBjAWWehUqIrM4hw2MBZZ6FsmtWJbrw3Er+
3sYeVsc24SkEXZ7FKg9t6gsSUgi6PIsl5W2EI+GUuS7PYptMNsKRsMWgGg8K
FixbCEdKkaCqPQvu5VkIR0rmUZVnwb1pC+FI2ZnU5Fn0nIO+cCTVFmvyLFoC
oC8cSRsWmjyLlrToC0dSQcN/w9vYQ1s40o4kKPIsXDmknRxNqxtR5Fn4FJp2
cjStPILIc8qpuJCeUV/1aQT4XRVMrNbMbXyRMPwQajxYgGkK6hn1VZ+egBaO
AjOGlmwU0YeQdQP8gIBskM+J1v9AtHCgeG7JhgLP4CcE9Aw+IcI/nyociDfd
fqmOeA7maqmJrPN8wAoHxp7bP0ucZ/gQg24QOWFYfx5buYfhuT135O0ZzFLY
DaIvEacnYCtR0191RzaK6EO0/GeVKmW9kvNkidLiWSVaYy/5DSI5yNfiWac0
S6tPRHrSSolnpaBYq/12QhK2uEIEIbo7vckuvq/7Bdw3NPUs+QkJHzjmUHgG
Hfzz/qBp9Amdv+4c5pThuaVnkjwfg3thnvddp1J5jh1Ojgo4ROFbepb+j4Z/
4JisIjwB8oG+E7AxnsmNFSA8D7tBnLks5OnYpCH0nk+P8czYoyEI1oPzw9Bo
aYe5XKdg7DkSBPLWHww0jtVjJKDQ6MjC2G8jBoVemCjLLBSMTVE2NPpxoJS2
UGBBYwmoIS8cKAEoFGa1aq8oceHALWifkaK0cGistA1ICwdudhby8qkqG/Ld
t3Fd1LvJBwEot5gT7gCGfPyeZ9lSS2XZYGz22Atkw7w9z7KllsqyId06EPkW
v8JyUeFQ70wpKhzYh3/xLCkc6rIhKxzYyfLFs+SukrpsyAoH9h0e0nmCu6QG
DW0FpxA6CjrwLLfrbyAbku8WHdUfdg7lhMNANiR/KDrYpJZaxmDSB1tsEuGT
J0eepYTDRDbk3i4+GXjkWSpUMZENuR+Lz1Gdtg+FQhWj9vlC04iQcz3xLBOq
GMmG1Psl7CGceJYRDiPZkPrBhNR2XXYgIhxmt26ITCTKVk3Ns4RwmMmGzJ2m
lB2EmmcJ4TCTDZkcByU/da4kFdiONbysRyA5SnrkuSyMfztWtW6jC/7kKGmK
nHnmZ0Wx3OsS/MJBenONMkd24TC9HJC9joO2qDd45jY/q2aUR3DXcdAW9QbP
3MJh1Vz1CO4CMNqi3iyPZhYO23tNuIWDGAs0eeZ1d83vyOUtOSeqapNn3vDN
+t4p5lvUiZO9dayCNa6wv8Oc8yY36uLVOlnIKRx6Z62D4BQOqjPWsmfOYFXj
QE4EnK+aGgu0j2Mx+pzW1y/uwSdd5FigzTPf0mF/neiOcykmxwKd44VsFmB/
Pe6O07UkxwIdnrnqCxSOl0HAlWGhK32HZ66chIfry3d8DhR9Ue8eS2aKvWVr
6sFgcqAwjzn0pqr95i7PPBbwcWu2MdgGzzKBIKU4U1vUvzTAYwGrBcNDOMDj
QCEm+QXP3V4zLBZgda/XJTgcKMyiFbNnFgtwEHOfwOFAYZ5R8xzQZ5ZAzoXz
fADH5gWGkTPPu+ZvDdCDKMPymEvQc5C40LZW46JfNxiCKNN97i7onjyLj9rT
1occRPlZBXcMkSnP7OzhmWqOKi1b4aDGcjyzs4dn6gt0kHlugur88MzOvnZg
NEFykkI6g0YU0+zs45lmAYZFov2gBadMrWF7O4+SLMC02qsPpGRLdcuzL9Tb
RpBiAeZlG5eg1Jxzdafp5ZmSTNJqwZwAyh4aV6lFf1tMvMvANc9Ygd91YvNR
+3nGP97JRkobeB1km52BNq/olVCxxSUc6IiAL1MT4Bkr/85iwROwZsm3XxHg
GSuzzmLBE7Cvn6/QJtQeGvcm3ewLdoFzGxhbDoZ4xrl22neHgoFjjHGxCbY7
x0iaS6fuAIxrx7nYBG/8wEiAqwR/Gxgd5Nx+C7fvR2TtXCX420BMNdbFJsxz
etZOulMtCekGzZpBGLiOItk6HZszwqB5facBnlPN07U5p5snb0Js6HqVRPt0
bc7J9skcCgzxnGagzs051UCZ87tDPKdZqHNzTrRQ7sh2kOcUE3VvzmnRKvd2
xSDPKTs+7s05yeVgT9SEb4DcAx55uszvdwH3odl334btGRx6Os5sNFCNgXnO
9zF33jHCM3T+uCngHwZ0EeHvyhbhGUig27xzF7A8tMAh0xjP1RSyvjndRrnE
2xRgENWEv0NLjGfQu+XtdCEKSBW9xG5FlGfAUijx/qUAGOtmIiCCcZ6345gr
Yd45JgXxuSdSIBjnOaocTmsJQoi5xjJtygA8R1a57cS8QU8SIsoBWinTMRwP
HjDsc0h0ABbFoP5upzJrDcSed++TcIl+JhFKE0M5AimrAfG8e52FTMBF35hU
hCVarIckjOdgxcBb6ewwCgyhvXy5Mx9AngO++6bMaw08oZr1xt/haUsGlOfd
skeHN9M8ad4T3WPRz3I0w3nerWZdiXjJluZPou8vlHg5Zy0kKA5H6YP9CoJ4
mbbK+rbzC+KzwuNdK87d3DFnNWp+A+fow9iU97UjXa3Gfpo/4PB6+6Nm+mMx
4b6zAc/zp+c5mazWH7v183y0yGEDZRjV4+j+ab3drp9moxW7NHd47vbtieBt
UY6+lfPnrCXjjJ8P5ffv5YNEcEKx5yvguPKsgpNKpPsbVxBw5fmKK64I4l/h
IJiO
   "], {{0, 0}, {360, 216}},
   ColorFunction->(Apply[RGBColor, 
     Part[CompressedData["
1:eJzt00tKm3EUxuFQXEBBKLbiwB0IolIovG5BUZS2OhAcC6VKQXAPVq1JbE23
UKlUvO7AVk1MjJfmHnPxhqWlrRF73nz/c0ZShw7yQDiE3+T7zkmah0a6hx/4
fL7Of5863/+c42NIfEVoXmyildJwvYu2sPWNMD0lrO9sE7ppGz8uhfUeCiO8
Q3hNGe27EUIvRRAJC+t9FEV0l9BGWe17MULAL2J4NyOsP6c4nlAcjyin/WCf
8H5O7GOMrA/QIZro0HsO69+PyNvfEToor72FEnhICfhnhfWLc5Hw9ptAAx1r
X/gkkng7KZJ4Q9ZfUcrbf8rbh3V3z3pK4ykVtLt7Ve+TRjAgrC9+FhnMTIsM
/vwW1kcp690v6+27qL2dcrr3lWVh/ddPkdO9NlJJ+9IXkde9Ve9k3e2jn45x
9VdYd+/7mAp4SWXt7n3ie6KAtVVh3T3vXFAUvd/BifZxKuEFlTD/QVh/RmWd
1xVhvXIlyjoH6VT7+po40bmxLqxP0KnOqjPt7rub1f+79bvN29R6rdf6fe43
Zs/xJg==
      "], #]]& ),
   ColorFunctionScaling->False],
  Background->None,
  ImageSize->{360, 216},
  PlotRange->{{0, 360}, {0, 216}}]], "Output", "ConversionLockdown",
 ImageSize->{364, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25845517]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LoadJavaClass",
    BaseStyle->"Link",
    ButtonData->"paclet:JLink/ref/LoadJavaClass"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LoadNetType",
    BaseStyle->"Link",
    ButtonData->"paclet:NETLink/ref/LoadNETType"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"],
  FontSlant->"Italic"],
 ButtonBox[" Internet Connectivity",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InternetConnectivity"]
}], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->39153949],

Cell[TextData[ButtonBox["Calling External Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CallingExternalPrograms"]], "MoreAbout",
 CellID->242169330],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->84852245],

Cell[TextData[ButtonBox["Web Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebOperations"]], "MoreAbout",
 CellID->338796450],

Cell[TextData[ButtonBox["New in 6.0: System Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60SystemInterfacesAndDeployment"]], "MoreAbout",
 CellID->179128084]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InstallService - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 7.8528600}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InstallService[\"url\"] installs the web service operations in the WSDL \
description at the URL given. InstallService[\"url\", \" \
StyleBox[\\\"context`\\\", \\\"TI\\\"]\"] installs web service operations, \
creating functions in the specified context.", 
    "synonyms" -> {"install service"}, "title" -> "InstallService", "type" -> 
    "Symbol", "uri" -> "ref/InstallService"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7573, 215, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->454609088]},
 "b:1.2.2"->{
  Cell[8221, 241, 231, 6, 47, "Input",
   CellTags->"b:1.2.2",
   CellID->1869],
  Cell[8455, 249, 233, 7, 36, "Output",
   CellTags->"b:1.2.2",
   CellID->120134232]},
 "b:1.2.3"->{
  Cell[9424, 288, 280, 8, 70, "Input",
   CellTags->"b:1.2.3",
   CellID->17035],
  Cell[9707, 298, 510, 13, 71, "Output",
   CellTags->"b:1.2.3",
   CellID->576037757],
  Cell[10254, 316, 152, 4, 70, "Input",
   CellTags->"b:1.2.3",
   CellID->28703],
  Cell[10409, 322, 220, 6, 36, "Output",
   CellTags->"b:1.2.3",
   CellID->70268943],
  Cell[11493, 367, 306, 9, 70, "Input",
   CellTags->"b:1.2.3",
   CellID->30333],
  Cell[11802, 378, 349, 11, 54, "Output",
   CellTags->"b:1.2.3",
   CellID->587135549]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21956, 647},
 {"b:1.2.2", 22090, 651},
 {"b:1.2.3", 22273, 658}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2624, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3247, 88, 1579, 37, 70, "ObjectNameGrid"],
Cell[4829, 127, 1001, 28, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5867, 160, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6345, 177, 465, 15, 70, "Notes",
 CellID->516264505],
Cell[6813, 194, 71, 1, 70, "Notes",
 CellID->163574834],
Cell[6887, 197, 649, 13, 70, "2ColumnTableMod",
 CellID->639102228]
}, Closed]],
Cell[CellGroupData[{
Cell[7573, 215, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->454609088],
Cell[CellGroupData[{
Cell[7958, 229, 148, 5, 70, "ExampleSection",
 CellID->575135186],
Cell[8109, 236, 87, 1, 70, "ExampleText",
 CellID->20483070],
Cell[CellGroupData[{
Cell[8221, 241, 231, 6, 47, "Input",
 CellTags->"b:1.2.2",
 CellID->1869],
Cell[8455, 249, 233, 7, 36, "Output",
 CellTags->"b:1.2.2",
 CellID->120134232]
}, Open  ]],
Cell[8703, 259, 67, 1, 70, "ExampleText",
 CellID->30274267],
Cell[CellGroupData[{
Cell[8795, 264, 122, 3, 28, "Input",
 CellID->53524566],
Cell[8920, 269, 248, 6, 36, "Output",
 CellID->352263654]
}, Open  ]],
Cell[9183, 278, 126, 3, 70, "ExampleDelimiter",
 CellID->1133610049],
Cell[9312, 283, 87, 1, 70, "ExampleText",
 CellID->355701255],
Cell[CellGroupData[{
Cell[9424, 288, 280, 8, 70, "Input",
 CellTags->"b:1.2.3",
 CellID->17035],
Cell[9707, 298, 510, 13, 71, "Output",
 CellTags->"b:1.2.3",
 CellID->576037757]
}, Open  ]],
Cell[CellGroupData[{
Cell[10254, 316, 152, 4, 70, "Input",
 CellTags->"b:1.2.3",
 CellID->28703],
Cell[10409, 322, 220, 6, 36, "Output",
 CellTags->"b:1.2.3",
 CellID->70268943]
}, Open  ]],
Cell[10644, 331, 68, 1, 70, "ExampleText",
 CellID->246192679],
Cell[CellGroupData[{
Cell[10737, 336, 140, 3, 70, "Input",
 CellID->240999126],
Cell[10880, 341, 192, 5, 36, "Output",
 CellID->263009907]
}, Open  ]],
Cell[11087, 349, 125, 3, 70, "ExampleDelimiter",
 CellID->109177359],
Cell[11215, 354, 253, 9, 70, "ExampleText",
 CellID->1602630],
Cell[CellGroupData[{
Cell[11493, 367, 306, 9, 70, "Input",
 CellTags->"b:1.2.3",
 CellID->30333],
Cell[11802, 378, 349, 11, 54, "Output",
 CellTags->"b:1.2.3",
 CellID->587135549]
}, Open  ]],
Cell[12166, 392, 67, 1, 70, "ExampleText",
 CellID->89393617],
Cell[CellGroupData[{
Cell[12258, 397, 388, 10, 70, "Input",
 CellID->454620743],
Cell[12649, 409, 5034, 91, 237, "Output",
 CellID->25845517]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17744, 507, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[18063, 518, 969, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[19069, 558, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[19390, 569, 299, 9, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[19726, 583, 318, 9, 70, "MoreAboutSection",
 CellID->39153949],
Cell[20047, 594, 160, 3, 70, "MoreAbout",
 CellID->242169330],
Cell[20210, 599, 148, 3, 70, "MoreAbout",
 CellID->84852245],
Cell[20361, 604, 139, 3, 70, "MoreAbout",
 CellID->338796450],
Cell[20503, 609, 193, 4, 70, "MoreAbout",
 CellID->179128084]
}, Open  ]],
Cell[20711, 616, 27, 0, 70, "History"],
Cell[20741, 618, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

