(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45833,       1312]
NotebookOptionsPosition[     39295,       1083]
NotebookOutlinePosition[     40500,       1118]
CellTagsIndexPosition[     40414,       1113]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Types of Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/TypesOfNumbers"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Types of Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], "BaseForm" :> 
          Documentation`HelpLookup["paclet:ref/BaseForm"], "IntegerQ" :> 
          Documentation`HelpLookup["paclet:ref/IntegerQ"], "Integers" :> 
          Documentation`HelpLookup["paclet:ref/Integers"], "Rational" :> 
          Documentation`HelpLookup["paclet:ref/Rational"], "IntegerPart" :> 
          Documentation`HelpLookup["paclet:ref/IntegerPart"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IntegerDigits\"\>", 
       2->"\<\"BaseForm\"\>", 3->"\<\"IntegerQ\"\>", 4->"\<\"Integers\"\>", 
       5->"\<\"Rational\"\>", 6->"\<\"IntegerPart\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], 
          "Expression Structure" :> 
          Documentation`HelpLookup["paclet:guide/ExpressionStructure"], 
          "Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Atomic Elements of Expressions\"\>", 
       2->"\<\"Expression Structure\"\>", 3->"\<\"Patterns\"\>", 
       4->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Integer", "ObjectName",
 CellID->5595],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Integer",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
     "\[LineSeparator]is the head used for integers. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12822]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["_Integer"], "InlineFormula"],
 " can be used to stand for an integer in a pattern. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->162386861]
}], "Notes",
 CellID->5748],

Cell[TextData[{
 "Integers can be of any length. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->194631054]
}], "Notes",
 CellID->1503],

Cell[TextData[{
 "You can enter an integer in base ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  RowBox[{
   StyleBox["b", "TI"], "^", 
   RowBox[{"^", 
    StyleBox["digits", "TI"]}]}]], "InlineFormula"],
 ". The base must be less than 36. The letters are used in sequence to stand \
for digits 10 through 35. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->53161668]
}], "Notes",
 CellID->19196]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->368260108],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->102715811],

Cell["Enter an integer:", "ExampleText",
 CellID->385659000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"-", "12"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->351039343],

Cell[BoxData[
 RowBox[{"-", "12"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->282129360]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  ButtonBox["Head",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Head"]], "InlineFormula"],
 " used for integers:"
}], "ExampleText",
 CellID->41100439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->147319433],

Cell[BoxData["Integer"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->906441681]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->379180625],

Cell["Enter a very large integer:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->194631054],

Cell[CellGroupData[{

Cell[BoxData[\
"308301830183093810389108725092184914914891917449832749872947298472"], "Input",\

 CellLabel->"In[1]:=",
 CellID->389397080],

Cell[BoxData[\
"308301830183093810389108725092184914914891917449832749872947298472"], \
"Output",
 ImageSize->{511, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->308167353]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120146842],

Cell["Enter an integer in base 2:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->53161668],

Cell[CellGroupData[{

Cell[BoxData["2^^10110111011110111110111111011111110111111110111111111"], \
"Input",
 CellLabel->"In[1]:=",
 CellID->44090159],

Cell[BoxData["6455773865180671"], "Output",
 ImageSize->{127, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->627109335]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7950978],

Cell["Enter an integer in hexadecimal:", "ExampleText",
 CellID->620765149],

Cell[CellGroupData[{

Cell[BoxData["16^^fa0"], "Input",
 CellLabel->"In[1]:=",
 CellID->107476002],

Cell[BoxData["4000"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->345777639]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->627708762],

Cell["Format an integer using base 2: ", "ExampleText",
 CellID->23103648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"6455773865180671", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285375007],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   SubscriptBox["\<\"10110111011110111110111111011111110111111110111111111\"\>\
", "\<\"2\"\>"],
   6455773865180671,
   Editable->False],
  BaseForm[#, 2]& ]], "Output",
 ImageSize->{381, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//BaseForm=",
 CellID->317772334]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->415770610],

Cell[TextData[{
 Cell[BoxData["_Integer"], "InlineFormula"],
 " can be used to stand for an integer in a pattern:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->162386861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{"1234", ",", "_Integer"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->276389215],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->307064505]
}, Open  ]],

Cell["A rule that replaces integers with their reciprocals:", "ExampleText",
 CellID->30224436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"3", ",", 
    RowBox[{"g", "[", 
     RowBox[{"-", "4"}], "]"}]}], "]"}], " ", "/.", 
  RowBox[{"x_Integer", "\[Rule]", 
   RowBox[{"1", "/", "x"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->177979147],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   FractionBox["1", "3"], ",", 
   RowBox[{"g", "[", 
    RowBox[{"-", 
     FractionBox["1", "4"]}], "]"}]}], "]"}]], "Output",
 ImageSize->{88, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->274726630]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->151174203],

Cell["Define a function that only works for integers:", "ExampleText",
 CellID->278604771],

Cell[BoxData[
 RowBox[{
  RowBox[{"divisibleby3", "[", "x_Integer", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{"x", ",", "3"}], "]"}], "\[Equal]", "0"}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174257858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"divisibleby3", ",", 
   RowBox[{"{", 
    RowBox[{"123", ",", 
     RowBox[{"-", "40"}], ",", "3.14"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->647405544],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", 
   RowBox[{"divisibleby3", "[", "3.14`", "]"}]}], "}"}]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29571770]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->128205517],

Cell["Define a function that has a special case for integers:", "ExampleText",
 CellID->710893160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"fd", "[", 
   RowBox[{"x_", ",", "k_", ",", "d_Integer"}], "]"}], "=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"x", "^", "k"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53526529],

Cell[BoxData[
 RowBox[{"k", " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "k"}]]}]], "Output",
 ImageSize->{43, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->428805098]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"fd", "[", 
   RowBox[{"x_", ",", "k_", ",", "d_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{"k", "+", "1"}], "]"}], "/", 
     RowBox[{"Gamma", "[", 
      RowBox[{"k", "-", "d", "+", "1"}], "]"}]}], ")"}], 
   RowBox[{"x", "^", 
    RowBox[{"(", 
     RowBox[{"k", "-", "d"}], ")"}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99417225],

Cell[TextData[{
 "Make a surface plot of the fractional derivative of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "k"], TraditionalForm]], "InlineMath"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]], "InlineMath"],
 " as a function of ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " and order:"
}], "ExampleText",
 CellID->64101438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"fd", "[", 
    RowBox[{"1", ",", "k", ",", "d"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->148647311],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->91146313]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->82813826],

Cell["Integers are numbers:", "ExampleText",
 CellID->836499264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", "1234", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399624644],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->200219633]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->552803233],

Cell["Integers are atomic objects with no subexpressions:", "ExampleText",
 CellID->174251264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AtomQ", "[", "1234", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->867844838],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->703742291]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15140826],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Integers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
 " to represent assumptions and indicate domain conditions: "
}], "ExampleText",
 CellID->31580033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "1000"}], "-", 
     RowBox[{"2", 
      RowBox[{"x", "^", "777"}]}], "+", "1"}], "\[Equal]", "0"}], ",", "x", 
   ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->223656496],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", "1"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106709580]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19338],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaseForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rational",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rational"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPart"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30516]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18101],

Cell[TextData[ButtonBox["Types of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TypesOfNumbers"]], "Tutorials",
 CellID->8903]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->98753722],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->214589862],

Cell[TextData[ButtonBox["Expression Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExpressionStructure"]], "MoreAbout",
 CellID->45391997],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->407035174],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->78891312]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integer - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 9.9154128}", "context" -> "System`", 
    "keywords" -> {"integers", "natural numbers", "whole numbers"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Integer is the head used for integers. ", "synonyms" -> {}, "title" -> 
    "Integer", "type" -> "Symbol", "uri" -> "ref/Integer"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5207, 163, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->368260108]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40271, 1106}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2702, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3325, 87, 44, 1, 70, "ObjectName",
 CellID->5595],
Cell[3372, 90, 412, 13, 70, "Usage",
 CellID->12822]
}, Open  ]],
Cell[CellGroupData[{
Cell[3821, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4299, 125, 230, 7, 70, "Notes",
 CellID->5748],
Cell[4532, 134, 165, 6, 70, "Notes",
 CellID->1503],
Cell[4700, 142, 470, 16, 70, "Notes",
 CellID->19196]
}, Closed]],
Cell[CellGroupData[{
Cell[5207, 163, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->368260108],
Cell[CellGroupData[{
Cell[5592, 177, 148, 5, 70, "ExampleSection",
 CellID->102715811],
Cell[5743, 184, 60, 1, 70, "ExampleText",
 CellID->385659000],
Cell[CellGroupData[{
Cell[5828, 189, 88, 3, 28, "Input",
 CellID->351039343],
Cell[5919, 194, 176, 6, 36, "Output",
 CellID->282129360]
}, Open  ]],
Cell[6110, 203, 317, 12, 70, "ExampleText",
 CellID->41100439],
Cell[CellGroupData[{
Cell[6452, 219, 100, 3, 28, "Input",
 CellID->147319433],
Cell[6555, 224, 164, 5, 36, "Output",
 CellID->906441681]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6768, 235, 220, 7, 70, "ExampleSection",
 CellID->379180625],
Cell[6991, 244, 118, 2, 70, "ExampleText",
 CellID->194631054],
Cell[CellGroupData[{
Cell[7134, 250, 139, 4, 70, "Input",
 CellID->389397080],
Cell[7276, 256, 228, 7, 36, "Output",
 CellID->308167353]
}, Open  ]],
Cell[7519, 266, 125, 3, 70, "ExampleDelimiter",
 CellID->120146842],
Cell[7647, 271, 117, 2, 70, "ExampleText",
 CellID->53161668],
Cell[CellGroupData[{
Cell[7789, 277, 126, 3, 70, "Input",
 CellID->44090159],
Cell[7918, 282, 174, 5, 36, "Output",
 CellID->627109335]
}, Open  ]],
Cell[8107, 290, 123, 3, 70, "ExampleDelimiter",
 CellID->7950978],
Cell[8233, 295, 75, 1, 70, "ExampleText",
 CellID->620765149],
Cell[CellGroupData[{
Cell[8333, 300, 76, 2, 70, "Input",
 CellID->107476002],
Cell[8412, 304, 161, 5, 36, "Output",
 CellID->345777639]
}, Open  ]],
Cell[8588, 312, 125, 3, 70, "ExampleDelimiter",
 CellID->627708762],
Cell[8716, 317, 74, 1, 70, "ExampleText",
 CellID->23103648],
Cell[CellGroupData[{
Cell[8815, 322, 142, 4, 70, "Input",
 CellID->285375007],
Cell[8960, 328, 355, 12, 50, "Output",
 CellID->317772334]
}, Open  ]],
Cell[9330, 343, 125, 3, 70, "ExampleDelimiter",
 CellID->415770610],
Cell[9458, 348, 201, 5, 70, "ExampleText",
 CellID->162386861],
Cell[CellGroupData[{
Cell[9684, 357, 135, 4, 70, "Input",
 CellID->276389215],
Cell[9822, 363, 161, 5, 36, "Output",
 CellID->307064505]
}, Open  ]],
Cell[9998, 371, 95, 1, 70, "ExampleText",
 CellID->30224436],
Cell[CellGroupData[{
Cell[10118, 376, 262, 9, 70, "Input",
 CellID->177979147],
Cell[10383, 387, 303, 11, 51, "Output",
 CellID->274726630]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10735, 404, 227, 7, 70, "ExampleSection",
 CellID->151174203],
Cell[10965, 413, 90, 1, 70, "ExampleText",
 CellID->278604771],
Cell[11058, 416, 252, 8, 70, "Input",
 CellID->174257858],
Cell[CellGroupData[{
Cell[11335, 428, 219, 7, 70, "Input",
 CellID->647405544],
Cell[11557, 437, 264, 8, 36, "Output",
 CellID->29571770]
}, Open  ]],
Cell[11836, 448, 125, 3, 70, "ExampleDelimiter",
 CellID->128205517],
Cell[11964, 453, 98, 1, 70, "ExampleText",
 CellID->710893160],
Cell[CellGroupData[{
Cell[12087, 458, 241, 8, 70, "Input",
 CellID->53526529],
Cell[12331, 468, 248, 9, 36, "Output",
 CellID->428805098]
}, Open  ]],
Cell[12594, 480, 434, 15, 70, "Input",
 CellID->99417225],
Cell[13031, 497, 398, 14, 70, "ExampleText",
 CellID->64101438],
Cell[CellGroupData[{
Cell[13454, 515, 368, 11, 70, "Input",
 CellID->148647311],
Cell[13825, 528, 20041, 333, 70, "Output",
 Evaluatable->False,
 CellID->91146313]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33915, 867, 236, 7, 70, "ExampleSection",
 CellID->82813826],
Cell[34154, 876, 64, 1, 70, "ExampleText",
 CellID->836499264],
Cell[CellGroupData[{
Cell[34243, 881, 106, 3, 70, "Input",
 CellID->399624644],
Cell[34352, 886, 161, 5, 36, "Output",
 CellID->200219633]
}, Open  ]],
Cell[34528, 894, 125, 3, 70, "ExampleDelimiter",
 CellID->552803233],
Cell[34656, 899, 94, 1, 70, "ExampleText",
 CellID->174251264],
Cell[CellGroupData[{
Cell[34775, 904, 104, 3, 70, "Input",
 CellID->867844838],
Cell[34882, 909, 161, 5, 36, "Output",
 CellID->703742291]
}, Open  ]],
Cell[35058, 917, 124, 3, 70, "ExampleDelimiter",
 CellID->15140826],
Cell[35185, 922, 243, 8, 70, "ExampleText",
 CellID->31580033],
Cell[CellGroupData[{
Cell[35453, 934, 291, 10, 70, "Input",
 CellID->223656496],
Cell[35747, 946, 187, 6, 36, "Output",
 CellID->106709580]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35995, 959, 311, 9, 70, "SeeAlsoSection",
 CellID->19338],
Cell[36309, 970, 1447, 53, 70, "SeeAlso",
 CellID->30516]
}, Open  ]],
Cell[CellGroupData[{
Cell[37793, 1028, 314, 9, 70, "TutorialsSection",
 CellID->18101],
Cell[38110, 1039, 140, 3, 70, "Tutorials",
 CellID->8903]
}, Open  ]],
Cell[CellGroupData[{
Cell[38287, 1047, 318, 9, 70, "MoreAboutSection",
 CellID->98753722],
Cell[38608, 1058, 169, 3, 70, "MoreAbout",
 CellID->214589862],
Cell[38780, 1063, 150, 3, 70, "MoreAbout",
 CellID->45391997],
Cell[38933, 1068, 128, 3, 70, "MoreAbout",
 CellID->407035174],
Cell[39064, 1073, 159, 3, 70, "MoreAbout",
 CellID->78891312]
}, Open  ]],
Cell[39238, 1079, 27, 0, 70, "History"],
Cell[39268, 1081, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

