(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23080,        807]
NotebookOptionsPosition[     18290,        639]
NotebookOutlinePosition[     19594,        676]
CellTagsIndexPosition[     19509,        671]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Digits in Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/DigitsInNumbers"], 
          "Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Digits in Numbers\"\>", 
       2->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], 
          "FactorInteger" :> 
          Documentation`HelpLookup["paclet:ref/FactorInteger"], 
          "RealExponent" :> 
          Documentation`HelpLookup["paclet:ref/RealExponent"], 
          "MantissaExponent" :> 
          Documentation`HelpLookup["paclet:ref/MantissaExponent"], 
          "DigitCount" :> Documentation`HelpLookup["paclet:ref/DigitCount"], 
          "IntegerLength" :> 
          Documentation`HelpLookup["paclet:ref/IntegerLength"], "Exponent" :> 
          Documentation`HelpLookup["paclet:ref/Exponent"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IntegerDigits\"\>", 
       2->"\<\"FactorInteger\"\>", 3->"\<\"RealExponent\"\>", 
       4->"\<\"MantissaExponent\"\>", 5->"\<\"DigitCount\"\>", 
       6->"\<\"IntegerLength\"\>", 7->"\<\"Exponent\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Prime Numbers" :> 
          Documentation`HelpLookup["paclet:guide/PrimeNumbers"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Integer Functions\"\>", 
       2->"\<\"Number Digits\"\>", 3->"\<\"Number Theoretic Functions\"\>", 
       4->"\<\"Prime Numbers\"\>", 
       5->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IntegerExponent", "ObjectName",
 CellID->11681],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerExponent",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerExponent"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the highest power of ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " that divides ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31378]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerExponent"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula", "TemplateInclusion"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerExponent"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", "10"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14482],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerExponent"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " gives the number of trailing zeros in the digits of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " in base ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11207],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerExponent"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->592170451],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->15361745],

Cell["The number of trailing zeros:", "ExampleText",
 CellID->8208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerExponent", "[", "1230000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26126],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19239]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7376],

Cell["The highest power of 2:", "ExampleText",
 CellID->29287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerExponent", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "^", "10"}], "+", 
    RowBox[{"2", "^", "7"}]}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27037],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21757]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerExponent", "[", 
  RowBox[{"2^^10010000", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13570],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12020]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15580],

Cell["Number of trailing zeros in factorials:", "ExampleText",
 CellID->25132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"IntegerExponent", "[", 
    RowBox[{"n", "!"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11061],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "3", ",", 
   "3", ",", "3", ",", "3", ",", "3", ",", "4", ",", "4", ",", "4", ",", "4", 
   ",", "4", ",", "6", ",", "6", ",", "6", ",", "6", ",", "6", ",", "7", ",", 
   "7", ",", "7", ",", "7", ",", "7", ",", "8", ",", "8", ",", "8", ",", "8", 
   ",", "8", ",", "9", ",", "9", ",", "9", ",", "9", ",", "9", ",", "10", ",",
    "10", ",", "10", ",", "10", ",", "10", ",", "12"}], "}"}]], "Output",
 ImageSize->{486, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17560],

Cell["Powers of 2 in successive integers:", "ExampleText",
 CellID->1277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerExponent", "[", 
  RowBox[{
   RowBox[{"Range", "[", "50", "]"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21486],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "0", ",", "2", ",", "0", ",", "1", ",", "0", ",", "3", 
   ",", "0", ",", "1", ",", "0", ",", "2", ",", "0", ",", "1", ",", "0", ",", 
   "4", ",", "0", ",", "1", ",", "0", ",", "2", ",", "0", ",", "1", ",", "0", 
   ",", "3", ",", "0", ",", "1", ",", "0", ",", "2", ",", "0", ",", "1", ",", 
   "0", ",", "5", ",", "0", ",", "1", ",", "0", ",", "2", ",", "0", ",", "1", 
   ",", "0", ",", "3", ",", "0", ",", "1", ",", "0", ",", "2", ",", "0", ",", 
   "1", ",", "0", ",", "4", ",", "0", ",", "1"}], "}"}]], "Output",
 ImageSize->{480, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9749814]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"IntegerExponent", "[", 
   RowBox[{
    RowBox[{"Range", "[", "256", "]"}], ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5101],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdlkluVTEUBS+MGDJgwIABIIQQQoi+h5gAIfR935lAQuhZgpfCUrwUlsAS
6G5ZuN7k6fzycb0rv/+THStf765ujN/Xhoi/9z9XXS3x/9VG/nffLl7IPxf+
3n6Ix1rmzf/u38W7+vWt/COnX7yQ8YsH+29Kv3hXv76Tf+T0ixcyfvFYz7w1
/eJd/bo28zZy+sULGb94sD/zi3f162v5R06/eCHjF4+VzJy/eFe/VvlHTr94
IeMXD/ZnfvGufn0j/8jpFy9k/OLB+7Ul/eJd/boi/8jpFy9k/OLB/swv3tWv
n+UfOf3ihYxfPL5k5vzFu/r1k/wjp1+8kPGLB/szv3hXv36Vf+T0ixcyfvH4
lnl7+sW7+vXLzNvI6RcvZPziwf7ML97Vr+/lHzn94oWMXzw+ZOb8xbv6dX3m
beT0ixcyfvFgf+YX7+rXj/KPnH7xQsYvHrxffP/Fu/r1w8zbyOkXL2T84sH+
zC/e1W+X1F+a/e2iOOvpXxZfzpzn35bEWU//vPii/EWc9fQviPO8OX9bFGc9
/RviN+W/Ls56+rfEb2fOv//tpjjr6V8Rvyr/sjjr6V8T53mZ/6o467Mfu8X3
zP7YKb5L/f3iBzLn+cde8X3qbxKnF1o3Ln2+Tf383R37bhHfqv5p8TPynxQ/
pf6COO8r3rPi59Q/LH5E/oPih9Q/Ln4iM/MfFT829/tT8Wezv4g3Mv1nM4/n
mfMci3gj03+s/hP5xRuZ/pOZB8+X8xfxRqb/Uv1X8os3Mv1XMw/+v8z3sog3
Mv3nM48X8os3Mv0XMw+ej/nFG5n+XfXvyS/eyPTvzTzuZ+b8xRuZ/u2Zxx35
xRuZ/p2ZB8/H/OKNTP+h+o/kF29k+o9mHryf+f0v4o1M//7M44H84o1M/8HM
g+djfvFG/rnwC0BKUDk=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  PlotRange->{{0., 256.}, {0., 5.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->700502392]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4668],

Cell["\<\
Find the highest power of 2 that appears in the factors of a number:\
\>", "ExampleText",
 CellID->14376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", "2524", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20617],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"631", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30956]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerExponent", "[", 
  RowBox[{"2524", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15201],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20634]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4080],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorInteger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MantissaExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MantissaExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DigitCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DigitCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Exponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exponent"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10158]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14197],

Cell[TextData[ButtonBox["Digits in Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DigitsInNumbers"]], "Tutorials",
 CellID->23990],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->25476]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->79152077],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->3766097],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->931813356],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->832103166],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "MoreAbout",
 CellID->388349124],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->12744312]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
IntegerExponent"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IntegerExponent - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 9.0872666}", "context" -> "System`", 
    "keywords" -> {
     "greatest dividing exponent", "height", "ruler function", "zeros"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "IntegerExponent[n, b] gives the highest power of b that divides n. ", 
    "synonyms" -> {"integer exponent"}, "title" -> "IntegerExponent", "type" -> 
    "Symbol", "uri" -> "ref/IntegerExponent"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6530, 205, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->592170451]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19366, 664}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3284, 74, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3907, 101, 53, 1, 70, "ObjectName",
 CellID->11681],
Cell[3963, 104, 701, 23, 70, "Usage",
 CellID->31378]
}, Open  ]],
Cell[CellGroupData[{
Cell[4701, 132, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5179, 149, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[5314, 155, 488, 17, 70, "Notes",
 CellID->14482],
Cell[5805, 174, 466, 17, 70, "Notes",
 CellID->11207],
Cell[6274, 193, 219, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[6530, 205, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->592170451],
Cell[CellGroupData[{
Cell[6915, 219, 147, 5, 70, "ExampleSection",
 CellID->15361745],
Cell[7065, 226, 67, 1, 70, "ExampleText",
 CellID->8208],
Cell[CellGroupData[{
Cell[7157, 231, 113, 3, 28, "Input",
 CellID->26126],
Cell[7273, 236, 154, 5, 36, "Output",
 CellID->19239]
}, Open  ]],
Cell[7442, 244, 120, 3, 70, "ExampleDelimiter",
 CellID->7376],
Cell[7565, 249, 62, 1, 70, "ExampleText",
 CellID->29287],
Cell[CellGroupData[{
Cell[7652, 254, 205, 7, 70, "Input",
 CellID->27037],
Cell[7860, 263, 154, 5, 36, "Output",
 CellID->21757]
}, Open  ]],
Cell[CellGroupData[{
Cell[8051, 273, 140, 4, 70, "Input",
 CellID->13570],
Cell[8194, 279, 154, 5, 36, "Output",
 CellID->12020]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8397, 290, 223, 7, 70, "ExampleSection",
 CellID->15580],
Cell[8623, 299, 78, 1, 70, "ExampleText",
 CellID->25132],
Cell[CellGroupData[{
Cell[8726, 304, 233, 8, 70, "Input",
 CellID->11061],
Cell[8962, 314, 713, 14, 54, "Output",
 CellID->23452]
}, Open  ]],
Cell[9690, 331, 121, 3, 70, "ExampleDelimiter",
 CellID->17560],
Cell[9814, 336, 73, 1, 70, "ExampleText",
 CellID->1277],
Cell[CellGroupData[{
Cell[9912, 341, 164, 5, 70, "Input",
 CellID->21486],
Cell[10079, 348, 709, 14, 54, "Output",
 CellID->9749814]
}, Open  ]],
Cell[CellGroupData[{
Cell[10825, 367, 201, 6, 70, "Input",
 CellID->5101],
Cell[11029, 375, 1375, 31, 146, "Output",
 CellID->700502392]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12453, 412, 232, 7, 70, "ExampleSection",
 CellID->4668],
Cell[12688, 421, 115, 3, 70, "ExampleText",
 CellID->14376],
Cell[CellGroupData[{
Cell[12828, 428, 108, 3, 70, "Input",
 CellID->20617],
Cell[12939, 433, 300, 11, 36, "Output",
 CellID->30956]
}, Open  ]],
Cell[CellGroupData[{
Cell[13276, 449, 133, 4, 70, "Input",
 CellID->15201],
Cell[13412, 455, 154, 5, 36, "Output",
 CellID->20634]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13627, 467, 310, 9, 70, "SeeAlsoSection",
 CellID->4080],
Cell[13940, 478, 1734, 62, 70, "SeeAlso",
 CellID->10158]
}, Open  ]],
Cell[CellGroupData[{
Cell[15711, 545, 314, 9, 70, "TutorialsSection",
 CellID->14197],
Cell[16028, 556, 143, 3, 70, "Tutorials",
 CellID->23990],
Cell[16174, 561, 198, 4, 70, "Tutorials",
 CellID->25476]
}, Open  ]],
Cell[CellGroupData[{
Cell[16409, 570, 318, 9, 70, "MoreAboutSection",
 CellID->79152077],
Cell[16730, 581, 143, 3, 70, "MoreAbout",
 CellID->3766097],
Cell[16876, 586, 137, 3, 70, "MoreAbout",
 CellID->931813356],
Cell[17016, 591, 162, 3, 70, "MoreAbout",
 CellID->832103166],
Cell[17181, 596, 137, 3, 70, "MoreAbout",
 CellID->388349124],
Cell[17321, 601, 159, 3, 70, "MoreAbout",
 CellID->12744312]
}, Open  ]],
Cell[CellGroupData[{
Cell[17517, 609, 305, 8, 70, "RelatedLinksSection"],
Cell[17825, 619, 393, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[18233, 635, 27, 0, 70, "History"],
Cell[18263, 637, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

