(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     75721,       2563]
NotebookOptionsPosition[     62095,       2081]
NotebookOutlinePosition[     63344,       2117]
CellTagsIndexPosition[     63258,       2112]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FractionalPart" :> 
          Documentation`HelpLookup["paclet:ref/FractionalPart"], "Round" :> 
          Documentation`HelpLookup["paclet:ref/Round"], "Floor" :> 
          Documentation`HelpLookup["paclet:ref/Floor"], "Ceiling" :> 
          Documentation`HelpLookup["paclet:ref/Ceiling"], "Chop" :> 
          Documentation`HelpLookup["paclet:ref/Chop"], "Numerator" :> 
          Documentation`HelpLookup["paclet:ref/Numerator"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FractionalPart\"\>", 
       2->"\<\"Round\"\>", 3->"\<\"Floor\"\>", 4->"\<\"Ceiling\"\>", 
       5->"\<\"Chop\"\>", 6->"\<\"Numerator\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Number Digits\"\>", 
       2->"\<\"Numerical Functions\"\>", 
       3->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IntegerPart", "ObjectName",
 CellID->28081],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerPart",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerPart"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the integer part of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4949]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPart"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " in effect takes all digits to the left of the decimal point and drops the \
others. "
}], "Notes",
 CellID->22407],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"IntegerPart", "[", 
    StyleBox["x", "TI"], "]"}], "+", 
   RowBox[{
    ButtonBox["FractionalPart",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FractionalPart"], "[", 
    StyleBox["x", "TI"], "]"}]}]], "InlineFormula"],
 " is always exactly ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10322],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPart"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " returns an integer when ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is any numeric quantity, whether or not it is an explicit number. "
}], "Notes",
 CellID->959],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 " internally uses numerical approximations to establish its result. This \
process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15659],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 " applies separately to real and imaginary parts of complex numbers."
}], "Notes",
 CellID->124085891],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->168695732],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->413398126],

Cell["Find the integer part of a real number:", "ExampleText",
 CellID->37405575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPart", "[", "2.4", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28210220],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168026285]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27964],

Cell["Use exact numeric quantities:", "ExampleText",
 CellID->246468403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPart", "[", 
  RowBox[{"Pi", "^", "100"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38424829],

Cell[BoxData["51878483143196131920862615246303013562686760680405"], "Output",
 ImageSize->{388, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180256017]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->149140422],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->792177466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPart", "[", 
  RowBox[{"{", 
   RowBox[{"2.4", ",", "2.5", ",", "3.0"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->571308360],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41241436]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11591],

Cell[TextData[{
 "Manipulate ",
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 " symbolically:"
}], "ExampleText",
 CellID->23068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"IntegerPart", "[", "x", "]"}], "+", 
    RowBox[{"IntegerPart", "[", 
     RowBox[{"x", "+", 
      RowBox[{"1", "/", "2"}]}], "]"}]}], ",", " ", 
   RowBox[{
    RowBox[{"1", "/", "3"}], "<", "x", "<", 
    RowBox[{"1", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6908],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31329427]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"IntegerPart", "[", "x", "]"}], "+", 
      RowBox[{"IntegerPart", "[", 
       RowBox[{
        RowBox[{"2", "x"}], "-", "1"}], "]"}]}], "\[Equal]", "2"}], "&&", 
    RowBox[{"0", "<", "x", "<", "4"}]}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16709],

Cell[BoxData[
 RowBox[{"1", "\[LessEqual]", "x", "<", 
  FractionBox["3", "2"]}]], "Output",
 ImageSize->{58, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->580659075]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->735809551],

Cell["Evaluate an integral:", "ExampleText",
 CellID->46775205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"IntegerPart", "[", 
    RowBox[{"x", "^", "3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->284222782],

Cell[BoxData[
 RowBox[{"13", "-", 
  SuperscriptBox["2", 
   RowBox[{"1", "/", "3"}]], "-", 
  SuperscriptBox["2", 
   RowBox[{"2", "/", "3"}]], "-", 
  SuperscriptBox["3", 
   RowBox[{"1", "/", "3"}]], "-", 
  SuperscriptBox["5", 
   RowBox[{"1", "/", "3"}]], "-", 
  SuperscriptBox["6", 
   RowBox[{"1", "/", "3"}]], "-", 
  SuperscriptBox["7", 
   RowBox[{"1", "/", "3"}]]}]], "Output",
 ImageSize->{229, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->286369674]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16234],

Cell["Use with negative arguments:", "ExampleText",
 CellID->51465661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPart", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2.4"}], ",", 
    RowBox[{"-", "2.5"}], ",", 
    RowBox[{"-", "3.0"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->123891752],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5264308]
}, Open  ]],

Cell["\<\
Use with complex\[Hyphen]number arguments:\
\>", "ExampleText",
 CellID->145139025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPart", "[", 
  RowBox[{"3", " ", "+", " ", 
   RowBox[{
    RowBox[{"11", "/", "5"}], " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->196490464],

Cell[BoxData[
 RowBox[{"3", "+", 
  RowBox[{"2", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34610886]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120581419],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText",
 CellID->255097428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPart", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", " ", 
     RowBox[{"3", "/", "2"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120598341],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121736266]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->451729986],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->714081053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPart", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47473804],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132799585]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->322664213],

Cell["Series expansion:", "ExampleText",
 CellID->32431160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"IntegerPart", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", " ", "Reals"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->256781703],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9VM0KwjAMztr96aYHERG8DHwE9eAL6MmHGEPYDqLMvX9Nt1RHl4nisNAl
X5p+ab92PaVVfr6kVZGlybFMb3mR3ZPDtcSQdABgj321BPQVenXfK4W2/ZX4
lTjko/XQTghLwtoKIAeaJtB1ydKAnqLqBqGFpxa2820sDHMr5g5XyXti2tC/
a3k/KafVcfv3wUe/riSoEokBzYg5GQGveyM/4o9qYV+4q/qc5Qmomr6VAdoF
m7Wpo2Zluydq52zfRHm+X6IBqRNbqo2sPC1v/33w2RONO1qGPezfsE6Iwyge
DcA1GmBd3d2OuXksu3nXuqyRdS4zliNm567ZXPNurlXrH6U3FpwH5Pzd/w==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->401090826]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"IntegerPart", "[", 
    RowBox[{"x", "+", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1032184548],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWL1rFEEUn9u5O2OQgBG8TRSJYmMsNESb+JFCo/iRBGM+CqvzEJJCI/Gs
/EsEMYVgoTZiiL02CqJgJVoIgqQxjcHiQBjfm5lzZt/Nzu2euwkeu7P33vze
mzdvfvN27sar9fkbN6v1hVp14PxS9fb8Qu3OwLnFJVDxAmNsBe57IYPvAr7J
e0UIeLa2ZWg5APrgWdRPlIf1M9T6UMslabUdWxSF/LCKJUPL+kn/MJFDgt9D
+gOl57obPgHcRYLaqWPjRN8bo6dR9BGZRq2i2AYtjr7XMweXd+qtov2oDHa1
Qaf1TvHcuU67sSkauf1KVVos3GvV5FG/nmXzeYzITX6pLNhMvEb8znq0OLvn
khdl17xpdJ7+tPis/f3v+M0e37DNt5Pb7ex2eCqrUdMwFLXI97mOLFu1B6T2
w/vvyw/fwcW6sOEvVz9p1GFi1SPl16++xuBHLK9fPv+IoMDK65VGYfAjGc22
8+xNCVX7S87eq5aWxaLU6jcav69MPho9dZ+VseEggAq7jhArfC8136GM164/
A7yxg+xq3JD0PkOsKeNnU6Cm5PB2dY6fd+ColvlwtVdEWVWSLAHWaNRpYrVf
ymtrP2Pwg5ZXijLZdXvd2GjE4Aczmm3n2ZsmWnq+SYPaIbWLt15o7hUl9yBb
GnVSmH2Bxockfm7mscZz2Vy6sAwJw66D4i+/rP3i5o+fXf7eZLPLmqEqFqiG
mhuc1LHLxErteMNohX/65KPu35fYK87iaCJvW8lM/5olrTpuHMKOSzxMO8I+
s+PD1ONwL/9srdvHtLBO57nzj2rle9OqVZzUql2RKE4kRmcbZXpt3jwalfj1
9V9jZx4YHplM9OQexVa/a6n2rIhyIyA1qDsSxZhEm3dqQE6J3f8cT1baCb3i
gTe7ky1r1O73Rho7FC+iUIJarSqXOhTK/wjyHj07uwmdQ+7NZd5MHRd670LZ
h4sF2HB1xMauQiQKjJmV3775Bkccdd2trwJxeeo4WOEPAe6SwQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89421560]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240683469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"IntegerPart", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->535472944],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->213167140]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->910766703],

Cell["\<\
Iso-curves become full\[Hyphen]dimensional regions for piecewise constant \
functions:\
\>", "ExampleText",
 CellID->312496336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"IntegerPart", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", "+", 
      RowBox[{"y", "^", "2"}]}], "]"}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "50"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->133856071],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->333781598]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->973957186],

Cell["Fibonacci numbers:", "ExampleText",
 CellID->391237358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"IntegerPart", "[", 
     RowBox[{
      RowBox[{"GoldenRatio", "^", "k"}], "/", 
      RowBox[{"Sqrt", "[", "5", "]"}]}], "]"}], "+", 
    RowBox[{"Mod", "[", 
     RowBox[{"k", ",", "2"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102418207],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21",
    ",", "34", ",", "55", ",", "89", ",", "144", ",", "233", ",", "377", ",", 
   "610"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51136085]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Fibonacci", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->71428800],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21",
    ",", "34", ",", "55", ",", "89", ",", "144", ",", "233", ",", "377", ",", 
   "610"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->86185220]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->107465829],

Cell["\<\
Implement a divide-and-conquer\[Hyphen]type recursion relation:\
\>", "ExampleText",
 CellID->426553013],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"2", "/", "3"}], " ", 
     RowBox[{"f", "[", 
      RowBox[{"IntegerPart", "[", 
       RowBox[{"x", "/", "2"}], "]"}], "]"}]}], "+", "2"}]}], ";", 
  RowBox[{
   RowBox[{"f", "[", "0", "]"}], "=", "0"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25660557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "10", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->214174036],

Cell[BoxData[
 FractionBox["130", "27"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6765769]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41250463],

Cell[TextData[{
 "Find the ",
 Cell[BoxData["1000000"], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " digit of the fraction ",
 Cell[BoxData[
  RowBox[{"1", "/", 
   RowBox[{"99", "^", "2"}]}]], "InlineFormula"],
 " in base ",
 Cell[BoxData["10"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->156353032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p", " ", "=", " ", "1"}], ",", 
     RowBox[{"q", "=", 
      RowBox[{"99", "^", "2"}]}], ",", 
     RowBox[{"n", "=", 
      RowBox[{"10", "^", "6"}]}], ",", 
     RowBox[{"base", "=", "10"}]}], "}"}], ",", 
   RowBox[{"IntegerPart", "[", 
    RowBox[{"base", " ", 
     RowBox[{
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"PowerMod", "[", 
          RowBox[{"base", ",", " ", 
           RowBox[{"n", " ", "-", " ", "1"}], ",", " ", "q"}], "]"}]}], ",", 
        " ", "q"}], "]"}], "/", "q"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144551676],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165024658]
}, Open  ]],

Cell[TextData[{
 "Compare with ",
 Cell[BoxData[
  ButtonBox["RealDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RealDigits"]], "InlineFormula"],
 " functionality:"
}], "ExampleText",
 CellID->243734603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"99", "^", "2"}]}], ",", "10", ",", "1", ",", 
   RowBox[{"-", 
    RowBox[{"10", "^", "6"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149020611],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "9", "}"}], ",", 
   RowBox[{"-", "999999"}]}], "}"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->85825206]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->903845285],

Cell["Find the day of the week in the Gregorian calendar:", "ExampleText",
 CellID->656375396],

Cell[BoxData[
 RowBox[{
  RowBox[{"dow", "[", 
   RowBox[{"year_", ",", "month_", ",", "day_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<Sunday\>\"", ",", "\"\<Monday\>\"", ",", "\"\<Tuesday\>\"", ",", 
     "\"\<Wednesday\>\"", ",", "\"\<Thursday\>\"", ",", "\"\<Friday\>\"", 
     ",", "\"\<Saturday\>\""}], "}"}], "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"IntegerPart", "[", 
            RowBox[{"23", " ", 
             RowBox[{"month", "/", "9"}]}], "]"}], "+", "day", "+", "4", "+", 
           "year", "+", "\n", "                    ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"IntegerPart", "[", 
              RowBox[{"#", "/", "4"}], "]"}], "-", 
             RowBox[{"IntegerPart", "[", 
              RowBox[{"#", "/", "100"}], "]"}], "+", 
             RowBox[{"IntegerPart", "[", 
              RowBox[{"#", "/", "400"}], "]"}]}], ")"}]}], "&"}], "[", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"month", "<", "3"}], ",", 
           RowBox[{"year", "-", "1"}], ",", "year"}], "]"}], "]"}], "-", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"month", ">=", "3"}], ",", "2", ",", "0"}], "]"}]}], ",", 
       "7"}], "]"}], "+", "1"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->607017524],

Cell["Birthday of Leonard Euler:", "ExampleText",
 CellID->140228201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dow", "[", 
  RowBox[{"1707", ",", "4", ",", "15"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->135498563],

Cell[BoxData["\<\"Friday\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8471319]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->286825750],

Cell["\<\
Implement the Frisch continuous but nowhere differentiable function:\
\>", "ExampleText",
 CellID->596770194],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Boole", "[", 
      RowBox[{
       RowBox[{"IntegerPart", "[", 
        RowBox[{"k", " ", "x"}], "]"}], "==", 
       RowBox[{"IntegerPart", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"k", "+", "1"}], ")"}], " ", "x"}], "]"}]}], "]"}], "/", 
     RowBox[{"2", "^", "k"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", " ", "n"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61963517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"f", "[", 
       RowBox[{"#", ",", "100"}], "]"}]}], "}"}], "&"}], "/@", 
   RowBox[{"Union", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"i", "/", "j"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "50"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "j"}], "}"}]}], "]"}], "]"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20816195],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWV1oXUUQ3p5zby4UBLEafbBYMIKKQvXNqgjVKrWKiI2CRSWm0QRsomlE
SF5URBH1RV8siKVUBX8eKpaKUEEsiAWxIBZEBakg9cEiWHwICPGbmd0758zu
2XNvYvFys3f3zMy3M7Mzs7snd08sTE/tmViYmZzYdMf8xJPTM5N7N90+N49H
5Trn3GH8PXOJQ38FPf47vLKC37i9Cm0BhpJGJXHSU8fdi6q0rtDk4yy17FNd
0UIbRYceFQka87srqe0oxbmu0e7CiGPEoF0QcXSiJxsG4Bk1uGXEUTTobDVK
z9YZUI9zq2tvMO9lV2AQnWkdaZ0vPoeahjnSGpYD6r56X8ZY8XzNOnbNvP/l
uodcH/G/o/7X+nRD5XnQMiUXxpK11apyvkE8kHl6HtqDwa6Ix/rDjjtD8g87
/r/xeeW6Z88un/j2N3xBmJk+5Ipbbt7nui+9+MX+t7/59MgPQnA9+iVZz9sJ
4yp25OFLzXhjC92ORUPoMvnoR3Ozn4AAjXgHaJ97kccffvAdBEm2oKa8956D
MJhIl2WkwHXsy1/IxILtPH36L09XKYpO4T5z5m8IUPeKJOY8Lwa4xHefH/25
hG9dCbuWFj9rkwPXQ7veh/LPPXu0w3KqzVizXAkJTEbdazJcD4y/J3AVLrJs
L1MRCp47jfEUjwEAGOpem+GCMlCpmeuJ4MunF47wUlEckqOyGkzxGFzgJoEO
S2279S0futfXrHqMuTHB8a9/pe4NGUz1n3D5UsSf1InGZtuU8a9HyZ490hgI
LrilCcOeBey5aMqsZArDVmnKOxru5udImB3b91N3y4Cy1fFuEyMpjHjfsZ4Q
lJPf/44SVUGprEnYMWyVE0mNvi21iBDvIFiQZnVqjPHxoZOvvXosz1UgFG9M
Uh/h8U8//uErqFQWJDVKVDPmgzxeXv4HlUKrmJRD7nJz6tSftdUN1u0KXoNA
mHNrZh6o8sbrX1H3tiTX/dSMwAZYKV8sB5y3Lcm9g8copMLquHp14ULRHV8U
Nie1UJzQPLNgQUQ2Jo+FFRFv4osIc3fWrL8ryPg8vi+DDE3EiZ4ryvbojmLj
THA03z3OULkqGJrvKYxwsrcZIrKa502y1XpDNtBwENlwrrR2s88re+DOoWW1
NuyMfG+ri/WYIGDpsICKYNdYuLQGKFfRtz5FjTGweSNl27i0nuS4tJ40c1E9
GY+0rT+NkQEL8Lb5oSIUbeOCuTC6jUuzLOXbFDXG0ByM4yB1209Hk2ZgKhLb
dxpB0RwcHIVARFozaS06tKOUCS9sX6nn43hCtu2mIBial+PReoT7W1pS87Ee
uzYP0zG8NVhQu2vISb5Z6iY0wgml4TqY73q8O8phT/1oJXm/ppyFoO6xKvVw
RkozbbJmKe/DXey8YgO8gV1TzhER0nU81psKpUuBjVX0kEJSnyGWxgbvT7wl
N5jZ0x/PSGmu7Mlw4TSNA0idi2wUKkhgoO5sEmOziaXZKJYGyW1BgQ9haAVl
yLzabOJvLSha41Mo1R2PREVGK/7qZ6baP7cGvTVi45VoOkOLpO4XuZXWWq9c
hHk164fKIFGO9CzDXc1X/TTqWED1Nzx+P9Hp3/BQJhYycri4+Pv+YpLrch7r
DWeppvOYibqlDAbOuf42n+PSE3aai9+A6LsCfOV8DPv9PSEnBwX6VwORe/ed
Ez5365ZtNN55PonK71JHkLt9bXAUQC17oRJg4ZN6527jSN4mQiFfaeX2IkGl
Wlik+J2jjWx+k9mFerAZ5xXUTnjCvbxKtPXU9Po3NbEayPvePC57QxfqY4yn
oMGBQ81EDOsphnv9pZKXO0DEakVvnF5ZpRUH1iSXqgq8oSf+z+PW/QtyFS1d
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->255571694]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1300],

Cell[TextData[{
 "Simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->346476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"IntegerPart", "[", 
     RowBox[{"x", " ", "+", " ", "1"}], "]"}], "-", 
    RowBox[{"IntegerPart", "[", "x", "]"}]}], ",", 
   RowBox[{"0", "<", "x", "<", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146252306],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91246724]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"IntegerPart", "[", 
    RowBox[{"z", "-", 
     RowBox[{"IntegerPart", "[", "z", "]"}]}], "]"}], "-", 
   RowBox[{"2", 
    RowBox[{"IntegerPart", "[", 
     RowBox[{"Round", "[", "z", "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->177789879],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"Round", "[", "z", "]"}]}]], "Output",
 ImageSize->{78, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->680469660]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->464529583],

Cell["Symbolically expand for complex arguments:", "ExampleText",
 CellID->661659471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"IntegerPart", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219620423],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegerPart", "[", "x", "]"}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"IntegerPart", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->413083044]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->363012172],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 " is idempotent:"
}], "ExampleText",
 CellID->127007904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPart", "[", 
  RowBox[{"IntegerPart", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->588686],

Cell[BoxData[
 RowBox[{"IntegerPart", "[", "x", "]"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->759332597]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52687269],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 " to canonicalize:"
}], "ExampleText",
 CellID->200580503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"IntegerPart", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], " ", "+", " ", 
     RowBox[{"Sqrt", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"0", "<", "x", "<", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->750407743],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmb1vGjEUwA+OOyAFAonSZmmF2o6NorZTtw5VO1Vi6Q6KKiVDVUQzsDEy
MjIyZmRk7MjIn8DIyMjoPj/b4Dx85zvuSJCakzh/3PN7756ffzbwvXV7/fNX
6/bmqlX/1mm1r2+u/tS//u5Al5txHKcLn9a5A3UGNfx0GYNS3Ov87k4mk9Vq
xas/sNfl91y32/2L12Kx8KHHhcFVlG80GuPxmFc9uGWhPyvLZ/icW8HLyRme
e1Dmpb7zjT231+vJUT6qXmtBGcepcB1gV5f00MjGnuOUiAd2iYLR2gujZ0dk
rNDVbDahBCnUpb+nL9sVWVLbZ5GsYFS92Wwmog7TNZ1OMYZcZ5lIK5tVWVJt
ZptqRipoa90PedHv98WMxIxzWdovsrC5zhsjOhwOIf1wsom8y+5n1AlpZ6U1
n+gtknY0b0Rsl8ulbGexPRqN5vM5r74h8ieRrfBQ1bAfVMHr8upbMrom5cy5
+BLbECbZpr68CxkFcypX/GttFM/7i5BRkHVy3Uez9YpJWvTwco74zRWh44++
GEd1Drb3EtsbWn42Sql8r8iSM9CT6yAJO4/Jc0/qd41e0FVfIW2a6UiNFOiq
SIf6t6iaNfrKbfsyAr5GTRExO13LWsk3vQwvAy1te1Uy9qr5wUjGpu+x5mu4
T/mtGJa3epQ1sVelQeeqQSI4mwqatNqL9TalqxifnOKUp7t5J951d4qbrRbJ
TOO+GoHm5jXwAdvBNDfvAWJUMM3N+48YFUxzs62PjIXS/NI46hC4nYTm+rlI
nSv2QXNlJzm36FpMm+x2otn2HhWruHzn8n5gjGxWFXOS8TxsXxNcgeV/d3fH
DIQosIeg+H0J3bNNrGh22k4HafH8VNNL49ZutweDwdp6xGyPy3azB7ZV/xyf
B7P9VHvPJ7Y/fm80tiuWl2Tpscc4qR8S2+Oc2ikjKEMU7dI/xRcslh/q5E5n
g/qhNO6P98pCOt8B06L8mTVycXI+LuFrRi3pcL7GwlbyE+f/b86rX3rMuWaj
1iGx3earYmhctlMi2b/Pm6ynw3ca72SR2B/jKaV32xP39QuNnfU2z/bNd33O
kYqHy/cczIQgMyT1e5SzEf4TYxGIrv/n52T+AY/VkAs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{120, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55195251]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"IntegerPart", "[", 
    RowBox[{"x", "+", 
     RowBox[{"1", "/", "3"}], "+", 
     RowBox[{
      RowBox[{"IntegerPart", "[", 
       RowBox[{"1", "-", 
        RowBox[{"x", "/", "2"}]}], "]"}], "^", "3"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", "\[Element]", "Reals"}], "&&", 
    RowBox[{
     RowBox[{"-", "2"}], "<", "x", "<", "3"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->211111924],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWM1uEzEQ3sa7bRPaCISE2JSfSAl/LbQ98AIcgBMSUoFjpVWFlApKo9JD
xCWPkGNunCrlmEfgEfIYeQxje8fU++0UOz9FrLSeHe/8eTz+ZpN32Xnn80l2
fnyUNd+eZd3O8dH35pvTMzUlVqIoulD367uRepbqydwXUiqajy/VWFGT3wwn
9Bj3er1f5ppOp3t6Rmgtc0VfLuVEv9+nWZT6ykrtB9nadaTUGJ0s4PEnO7um
Bq26QWuvEE0UTRTtsVqrekj+eKToNkzGLuOIcjknsh+stRpI3aAY1olWzXu1
B1F+CTMonuQ7M1mtEeVXZn1ultayRm/C1lBl8onR+PeMz3PL0b26KuzOtoOk
w2ro+uvx386mtDs7RD+xUluwnm3gD1ithkfrwxJ9pbAv28B/XGKEeSYrZnY4
HI5GI0nVpgs1JZrIYv1XwfahY6VYs+V6vw+6scSzaU9t5ljtdruDwUDSmXb1
6/LveGJjt1btya959N6z+ULvqSzikEWKjNXGvDWcmIo5QAQ6ZO2h1CbwiEsC
9vE2vOdrhMetuqMbXqUWx26B56dB2jbbz4PiTkEqLMKUItwJ8vE/4l6b6D4r
7cOkFvAvWCs+tEEru9cYiw8vscPuzbUiPLsx8DeDVnzgsfKK1dIncBY8xnON
XhpkJwY71o+mgt77MTAc0e944noAvChZ4hCtjE0iKO4cLZffOfDrEFdpv8aF
x84q49fu0rxrvqpf+XamAfLrDp03li0Z2v189XzPzUzBUlUunjPd6eyvqlm6
qQ8xtN2EqekK2MVsLFLzdeARK9GXD+UezxCLrWPs/dhpMWZfDE9kCa3i8Xjc
N9dkMsHvgGcUxyOYzxH7IWQE+0Cb1WoyPjTbkm4vzv+ZiFZ+A/tdDhY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{164, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->519110261]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153826659],

Cell[TextData[{
 "Reduce equations containing ",
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->49661786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"IntegerPart", "[", 
      RowBox[{"x", "+", 
       RowBox[{"1", "/", "2"}]}], "]"}], "==", 
     RowBox[{"2", " ", 
      RowBox[{"IntegerPart", "[", "x", "]"}]}]}], "&&", 
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "1"}]}], ",", "x", ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1187233],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "<", "x", "<", 
  FractionBox["1", "2"]}]], "Output",
 ImageSize->{65, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3520595]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11121],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 " does not automatically resolve the value:"
}], "ExampleText",
 CellID->19962190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPart", "[", 
  RowBox[{
   RowBox[{"\[Pi]", "^", "2"}], "+", 
   RowBox[{"2", "\[Pi]"}], "+", "1", "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Pi]", "+", "1"}], ")"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->202007665],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegerPart", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(IntegerPart[\\(\\(1 + \\(\\(2\\\\ \[Pi]\\)\\) \
+ \[Pi]\\^2 - \\((1 + \[Pi])\\)\\^2\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"IntegerPart::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->268075798],

Cell[BoxData[
 RowBox[{"IntegerPart", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "\[Pi]"}], "+", 
   SuperscriptBox["\[Pi]", "2"], "-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Pi]"}], ")"}], "2"]}], "]"}]], "Output",
 ImageSize->{219, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->246581276]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " to resolve:"
}], "ExampleText",
 CellID->522416373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->393892758],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->850946097]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8303853],

Cell[TextData[{
 "Machine\[Hyphen]precision numericalization",
 " of ",
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 " can give wrong results:"
}], "ExampleText",
 CellID->693433276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPart", "[", 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"E", "+", "1"}], ")"}], "^", "2"}], "-", 
   RowBox[{"E", "^", "2"}], "-", 
   RowBox[{"2", "E"}], "-", "1", "+", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{
      RowBox[{"Exp", "[", "E", "]"}], "^", "2"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->664420],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegerPart", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(IntegerPart[\\(\\(\\(\\(\\(\\(-2\\)\\)\\\\ \
\[ExponentialE]\\)\\) - \[ExponentialE]\\^2 + \[ExponentialE]\\^\\(-\
\[ExponentialE]\\^\\(2\\\\ \[ExponentialE]\\)\\) + \\((1 + \
\[ExponentialE])\\)\\^2\\)\\)]\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"IntegerPart::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->264660965],

Cell[BoxData[
 RowBox[{"IntegerPart", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ExponentialE]"}], "-", 
   SuperscriptBox["\[ExponentialE]", "2"], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ExponentialE]"}]]}]], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[ExponentialE]"}], ")"}], "2"]}], "]"}]], "Output",
 ImageSize->{247, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154549648]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->367231153],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89858746]
}, Open  ]],

Cell["Use arbitrary-precision evaluation instead:", "ExampleText",
 CellID->47005562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%%", ",", " ", "20"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->238913214],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(IntegerPart[\\(\\(\\(\\(\\(\\(-2\\)\\)\\\\ \
\[ExponentialE]\\)\\) - \[ExponentialE]\\^2 + \[ExponentialE]\\^\\(-\
\[ExponentialE]\\^\\(2\\\\ \[ExponentialE]\\)\\) + \\((1 + \
\[ExponentialE])\\)\\^2\\)\\)]\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->359976023],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->502806751]
}, Open  ]],

Cell["\<\
Because the answer is exact, raising the internal precision does not remove \
the message:\
\>", "ExampleText",
 CellID->346840246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "10000"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{"%%%", ",", "100"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->291211715],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(10000.`\\) \
reached while evaluating \\!\\(IntegerPart[\\(\\(\\(\\(\\(\\(-2\\)\\)\\\\ \
\[ExponentialE]\\)\\) - \[ExponentialE]\\^2 + \[ExponentialE]\\^\\(-\
\[ExponentialE]\\^\\(2\\\\ \[ExponentialE]\\)\\) + \\((1 + \
\[ExponentialE])\\)\\^2\\)\\)]\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->410039003],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->340837440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->163736994],

Cell[TextData[{
 "Symbolic preprocessing of functions containing ",
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 " can be time\[Hyphen]consuming:"
}], "ExampleText",
 CellID->67471629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"IntegerPart", "[", 
     RowBox[{"x", " ", "+", 
      RowBox[{"x", "^", "2"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75488083],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.1409999999999991`", ",", "51.73543542045973`"}], "}"}]], "Output",\

 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178424042]
}, Open  ]],

Cell[TextData[{
 "As a discontinuous function, ",
 Cell[BoxData[
  ButtonBox["IntegerPart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPart"]], "InlineFormula"],
 " can cause numerical algorithms to converge slowly:"
}], "ExampleText",
 CellID->81374961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"IntegerPart", "[", 
     RowBox[{"x", " ", "+", 
      RowBox[{"x", "^", "2"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"\"\<SymbolicProcessing\>\"", "\[Rule]", "0"}]}], "}"}]}]}], 
   "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->88226494],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], ":", 
  " ", "\<\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->355089600],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], ":", 
  " ", "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(x\\) near \\!\\({x}\\) = \
\\!\\({4.619218333202662`}\\). NIntegrate obtained \
\\!\\(51.72927764615029`\\) and \\!\\(0.015691689516773515`\\) for the \
integral and error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->512509056],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.04999999999999986`", ",", "51.72927764615029`"}], 
  "}"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->103785321]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15307],

Cell[TextData[{
 "Build a nondecreasing sequence of integers where each number ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " "}]], "InlineFormula"],
 "occurs ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " times [",
 ButtonBox["more info",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/Self-CountingSequence.html"], None}],
 "]:"
}], "ExampleText",
 CellID->152187716],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "[", "n_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"IntegerPart", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"2", "k"}], "]"}], "+", 
      RowBox[{"1", "/", "2"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", 
      RowBox[{"n", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "n"}], ")"}], "/", "2"}]}]}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->129338723],

Cell["Generate the sequence up to 5:", "ExampleText",
 CellID->195100352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "[", "5", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22525949],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "2", ",", "3", ",", "3", ",", "3", ",", "4", ",", "4", 
   ",", "4", ",", "4", ",", "5", ",", "5", ",", "5", ",", "5", ",", "5"}], 
  "}"}]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->94506377]
}, Open  ]],

Cell["Group the same numbers:", "ExampleText",
 CellID->118225134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Split", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->678760241],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5", ",", "5", ",", "5", ",", "5"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->64955685]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10883],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FractionalPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FractionalPart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Round",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Round"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ceiling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ceiling"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Chop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Chop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Numerator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Numerator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28645]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4255],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->21289]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->17804],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/IntegerPart.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/IntegerPart/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->23887705],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->230105204],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->661395788],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->279726057]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IntegerPart - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 11.1654448}", "context" -> "System`", 
    "keywords" -> {"fix", "int", "intrz", "trunc", "truncate to integer"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "IntegerPart[x] gives the integer part of x. ", 
    "synonyms" -> {"integer part"}, "title" -> "IntegerPart", "type" -> 
    "Symbol", "uri" -> "ref/IntegerPart"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6462, 214, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->168695732]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 63115, 2105}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2513, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3136, 85, 49, 1, 70, "ObjectName",
 CellID->28081],
Cell[3188, 88, 549, 18, 70, "Usage",
 CellID->4949]
}, Open  ]],
Cell[CellGroupData[{
Cell[3774, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4252, 128, 124, 4, 70, "Notes",
 CellID->126685801],
Cell[4379, 134, 309, 10, 70, "Notes",
 CellID->22407],
Cell[4691, 146, 401, 15, 70, "Notes",
 CellID->10322],
Cell[5095, 163, 376, 12, 70, "Notes",
 CellID->959],
Cell[5474, 177, 490, 14, 70, "Notes",
 CellID->15659],
Cell[5967, 193, 244, 7, 70, "Notes",
 CellID->124085891],
Cell[6214, 202, 211, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[6462, 214, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->168695732],
Cell[CellGroupData[{
Cell[6847, 228, 148, 5, 70, "ExampleSection",
 CellID->413398126],
Cell[6998, 235, 81, 1, 70, "ExampleText",
 CellID->37405575],
Cell[CellGroupData[{
Cell[7104, 240, 108, 3, 28, "Input",
 CellID->28210220],
Cell[7215, 245, 158, 5, 36, "Output",
 CellID->168026285]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7422, 256, 216, 7, 70, "ExampleSection",
 CellID->27964],
Cell[7641, 265, 72, 1, 70, "ExampleText",
 CellID->246468403],
Cell[CellGroupData[{
Cell[7738, 270, 132, 4, 70, "Input",
 CellID->38424829],
Cell[7873, 276, 208, 5, 36, "Output",
 CellID->180256017]
}, Open  ]],
Cell[8096, 284, 125, 3, 70, "ExampleDelimiter",
 CellID->149140422],
Cell[8224, 289, 216, 7, 70, "ExampleText",
 CellID->792177466],
Cell[CellGroupData[{
Cell[8465, 300, 170, 5, 70, "Input",
 CellID->571308360],
Cell[8638, 307, 212, 7, 36, "Output",
 CellID->41241436]
}, Open  ]],
Cell[8865, 317, 121, 3, 70, "ExampleDelimiter",
 CellID->11591],
Cell[8989, 322, 209, 8, 70, "ExampleText",
 CellID->23068],
Cell[CellGroupData[{
Cell[9223, 334, 372, 12, 70, "Input",
 CellID->6908],
Cell[9598, 348, 157, 5, 36, "Output",
 CellID->31329427]
}, Open  ]],
Cell[CellGroupData[{
Cell[9792, 358, 392, 13, 70, "Input",
 CellID->16709],
Cell[10187, 373, 222, 7, 51, "Output",
 CellID->580659075]
}, Open  ]],
Cell[10424, 383, 125, 3, 70, "ExampleDelimiter",
 CellID->735809551],
Cell[10552, 388, 63, 1, 70, "ExampleText",
 CellID->46775205],
Cell[CellGroupData[{
Cell[10640, 393, 251, 8, 70, "Input",
 CellID->284222782],
Cell[10894, 403, 520, 18, 36, "Output",
 CellID->286369674]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11463, 427, 239, 7, 70, "ExampleSection",
 CellID->16234],
Cell[11705, 436, 70, 1, 70, "ExampleText",
 CellID->51465661],
Cell[CellGroupData[{
Cell[11800, 441, 230, 8, 70, "Input",
 CellID->123891752],
Cell[12033, 451, 268, 10, 36, "Output",
 CellID->5264308]
}, Open  ]],
Cell[12316, 464, 93, 3, 70, "ExampleText",
 CellID->145139025],
Cell[CellGroupData[{
Cell[12434, 471, 190, 6, 70, "Input",
 CellID->196490464],
Cell[12627, 479, 214, 7, 36, "Output",
 CellID->34610886]
}, Open  ]],
Cell[12856, 489, 125, 3, 70, "ExampleDelimiter",
 CellID->120581419],
Cell[12984, 494, 228, 7, 70, "ExampleText",
 CellID->255097428],
Cell[CellGroupData[{
Cell[13237, 505, 243, 8, 70, "Input",
 CellID->120598341],
Cell[13483, 515, 260, 9, 36, "Output",
 CellID->121736266]
}, Open  ]],
Cell[13758, 527, 125, 3, 70, "ExampleDelimiter",
 CellID->451729986],
Cell[13886, 532, 84, 1, 70, "ExampleText",
 CellID->714081053],
Cell[CellGroupData[{
Cell[13995, 537, 113, 3, 70, "Input",
 CellID->47473804],
Cell[14111, 542, 168, 5, 36, "Output",
 CellID->132799585]
}, Open  ]],
Cell[14294, 550, 125, 3, 70, "ExampleDelimiter",
 CellID->322664213],
Cell[14422, 555, 59, 1, 70, "ExampleText",
 CellID->32431160],
Cell[CellGroupData[{
Cell[14506, 560, 369, 11, 70, "Input",
 CellID->256781703],
Cell[14878, 573, 577, 14, 70, "Output",
 Evaluatable->False,
 CellID->401090826]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15504, 593, 223, 7, 70, "ExampleSection",
 CellID->20425],
Cell[CellGroupData[{
Cell[15752, 604, 294, 10, 70, "Input",
 CellID->1032184548],
Cell[16049, 616, 1240, 24, 70, "Output",
 Evaluatable->False,
 CellID->89421560]
}, Open  ]],
Cell[17304, 643, 125, 3, 70, "ExampleDelimiter",
 CellID->240683469],
Cell[CellGroupData[{
Cell[17454, 650, 470, 15, 70, "Input",
 CellID->535472944],
Cell[17927, 667, 4466, 77, 70, "Output",
 Evaluatable->False,
 CellID->213167140]
}, Open  ]],
Cell[22408, 747, 125, 3, 70, "ExampleDelimiter",
 CellID->910766703],
Cell[22536, 752, 137, 4, 70, "ExampleText",
 CellID->312496336],
Cell[CellGroupData[{
Cell[22698, 760, 505, 16, 70, "Input",
 CellID->133856071],
Cell[23206, 778, 4458, 77, 70, "Output",
 Evaluatable->False,
 CellID->333781598]
}, Open  ]],
Cell[27679, 858, 125, 3, 70, "ExampleDelimiter",
 CellID->973957186],
Cell[27807, 863, 61, 1, 70, "ExampleText",
 CellID->391237358],
Cell[CellGroupData[{
Cell[27893, 868, 394, 13, 70, "Input",
 CellID->102418207],
Cell[28290, 883, 357, 10, 36, "Output",
 CellID->51136085]
}, Open  ]],
Cell[CellGroupData[{
Cell[28684, 898, 210, 7, 70, "Input",
 CellID->71428800],
Cell[28897, 907, 357, 10, 36, "Output",
 CellID->86185220]
}, Open  ]],
Cell[29269, 920, 125, 3, 70, "ExampleDelimiter",
 CellID->107465829],
Cell[29397, 925, 114, 3, 70, "ExampleText",
 CellID->426553013],
Cell[29514, 930, 378, 13, 70, "Input",
 CellID->25660557],
Cell[CellGroupData[{
Cell[29917, 947, 98, 3, 70, "Input",
 CellID->214174036],
Cell[30018, 952, 179, 6, 51, "Output",
 CellID->6765769]
}, Open  ]],
Cell[30212, 961, 124, 3, 70, "ExampleDelimiter",
 CellID->41250463],
Cell[30339, 966, 366, 14, 70, "ExampleText",
 CellID->156353032],
Cell[CellGroupData[{
Cell[30730, 984, 702, 22, 70, "Input",
 CellID->144551676],
Cell[31435, 1008, 158, 5, 36, "Output",
 CellID->165024658]
}, Open  ]],
Cell[31608, 1016, 214, 8, 70, "ExampleText",
 CellID->243734603],
Cell[CellGroupData[{
Cell[31847, 1028, 245, 8, 70, "Input",
 CellID->149020611],
Cell[32095, 1038, 251, 9, 36, "Output",
 CellID->85825206]
}, Open  ]],
Cell[32361, 1050, 125, 3, 70, "ExampleDelimiter",
 CellID->903845285],
Cell[32489, 1055, 94, 1, 70, "ExampleText",
 CellID->656375396],
Cell[32586, 1058, 1436, 39, 70, "Input",
 CellID->607017524],
Cell[34025, 1099, 69, 1, 70, "ExampleText",
 CellID->140228201],
Cell[CellGroupData[{
Cell[34119, 1104, 136, 4, 70, "Input",
 CellID->135498563],
Cell[34258, 1110, 169, 5, 36, "Output",
 CellID->8471319]
}, Open  ]],
Cell[34442, 1118, 125, 3, 70, "ExampleDelimiter",
 CellID->286825750],
Cell[34570, 1123, 119, 3, 70, "ExampleText",
 CellID->596770194],
Cell[34692, 1128, 575, 19, 70, "Input",
 CellID->61963517],
Cell[CellGroupData[{
Cell[35292, 1151, 560, 19, 70, "Input",
 CellID->20816195],
Cell[35855, 1172, 2104, 39, 70, "Output",
 Evaluatable->False,
 CellID->255571694]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38008, 1217, 232, 7, 70, "ExampleSection",
 CellID->1300],
Cell[38243, 1226, 218, 8, 70, "ExampleText",
 CellID->346476],
Cell[CellGroupData[{
Cell[38486, 1238, 301, 9, 70, "Input",
 CellID->146252306],
Cell[38790, 1249, 157, 5, 36, "Output",
 CellID->91246724]
}, Open  ]],
Cell[CellGroupData[{
Cell[38984, 1259, 330, 10, 70, "Input",
 CellID->177789879],
Cell[39317, 1271, 230, 8, 36, "Output",
 CellID->680469660]
}, Open  ]],
Cell[39562, 1282, 125, 3, 70, "ExampleDelimiter",
 CellID->464529583],
Cell[39690, 1287, 85, 1, 70, "ExampleText",
 CellID->661659471],
Cell[CellGroupData[{
Cell[39800, 1292, 196, 6, 70, "Input",
 CellID->219620423],
Cell[39999, 1300, 293, 9, 36, "Output",
 CellID->413083044]
}, Open  ]],
Cell[40307, 1312, 125, 3, 70, "ExampleDelimiter",
 CellID->363012172],
Cell[40435, 1317, 198, 7, 70, "ExampleText",
 CellID->127007904],
Cell[CellGroupData[{
Cell[40658, 1328, 142, 4, 70, "Input",
 CellID->588686],
Cell[40803, 1334, 196, 6, 36, "Output",
 CellID->759332597]
}, Open  ]],
Cell[41014, 1343, 124, 3, 70, "ExampleDelimiter",
 CellID->52687269],
Cell[41141, 1348, 217, 8, 70, "ExampleText",
 CellID->200580503],
Cell[CellGroupData[{
Cell[41383, 1360, 302, 9, 70, "Input",
 CellID->750407743],
Cell[41688, 1371, 1353, 26, 70, "Output",
 Evaluatable->False,
 CellID->55195251]
}, Open  ]],
Cell[CellGroupData[{
Cell[43078, 1402, 478, 15, 70, "Input",
 CellID->211111924],
Cell[43559, 1419, 1122, 22, 70, "Output",
 Evaluatable->False,
 CellID->519110261]
}, Open  ]],
Cell[44696, 1444, 125, 3, 70, "ExampleDelimiter",
 CellID->153826659],
Cell[44824, 1449, 216, 8, 70, "ExampleText",
 CellID->49661786],
Cell[CellGroupData[{
Cell[45065, 1461, 411, 14, 70, "Input",
 CellID->1187233],
Cell[45479, 1477, 227, 8, 51, "Output",
 CellID->3520595]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45755, 1491, 226, 7, 70, "ExampleSection",
 CellID->11121],
Cell[45984, 1500, 224, 7, 70, "ExampleText",
 CellID->19962190],
Cell[CellGroupData[{
Cell[46233, 1511, 280, 9, 70, "Input",
 CellID->202007665],
Cell[46516, 1522, 525, 9, 70, "Message",
 CellID->268075798],
Cell[47044, 1533, 376, 12, 39, "Output",
 CellID->246581276]
}, Open  ]],
Cell[47435, 1548, 198, 8, 70, "ExampleText",
 CellID->522416373],
Cell[CellGroupData[{
Cell[47658, 1560, 104, 3, 70, "Input",
 CellID->393892758],
Cell[47765, 1565, 158, 5, 36, "Output",
 CellID->850946097]
}, Open  ]],
Cell[47938, 1573, 123, 3, 70, "ExampleDelimiter",
 CellID->8303853],
Cell[48064, 1578, 263, 9, 70, "ExampleText",
 CellID->693433276],
Cell[CellGroupData[{
Cell[48352, 1591, 396, 13, 70, "Input",
 CellID->664420],
Cell[48751, 1606, 641, 11, 70, "Message",
 CellID->264660965],
Cell[49395, 1619, 567, 17, 45, "Output",
 CellID->154549648]
}, Open  ]],
Cell[CellGroupData[{
Cell[49999, 1641, 97, 3, 70, "Input",
 CellID->367231153],
Cell[50099, 1646, 157, 5, 36, "Output",
 CellID->89858746]
}, Open  ]],
Cell[50271, 1654, 85, 1, 70, "ExampleText",
 CellID->47005562],
Cell[CellGroupData[{
Cell[50381, 1659, 127, 4, 70, "Input",
 CellID->238913214],
Cell[50511, 1665, 621, 11, 70, "Message",
 CellID->359976023],
Cell[51135, 1678, 158, 5, 36, "Output",
 CellID->502806751]
}, Open  ]],
Cell[51308, 1686, 141, 4, 70, "ExampleText",
 CellID->346840246],
Cell[CellGroupData[{
Cell[51474, 1694, 252, 8, 70, "Input",
 CellID->291211715],
Cell[51729, 1704, 624, 11, 70, "Message",
 CellID->410039003],
Cell[52356, 1717, 158, 5, 36, "Output",
 CellID->340837440]
}, Open  ]],
Cell[52529, 1725, 125, 3, 70, "ExampleDelimiter",
 CellID->163736994],
Cell[52657, 1730, 265, 8, 70, "ExampleText",
 CellID->67471629],
Cell[CellGroupData[{
Cell[52947, 1742, 320, 11, 70, "Input",
 CellID->75488083],
Cell[53270, 1755, 241, 8, 36, "Output",
 CellID->178424042]
}, Open  ]],
Cell[53526, 1766, 267, 8, 70, "ExampleText",
 CellID->81374961],
Cell[CellGroupData[{
Cell[53818, 1778, 487, 15, 70, "Input",
 CellID->88226494],
Cell[54308, 1795, 522, 9, 70, "Message",
 CellID->355089600],
Cell[54833, 1806, 617, 11, 70, "Message",
 CellID->512509056],
Cell[55453, 1819, 243, 8, 36, "Output",
 CellID->103785321]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55745, 1833, 224, 7, 70, "ExampleSection",
 CellID->15307],
Cell[55972, 1842, 426, 15, 70, "ExampleText",
 CellID->152187716],
Cell[56401, 1859, 498, 18, 70, "Input",
 CellID->129338723],
Cell[56902, 1879, 73, 1, 70, "ExampleText",
 CellID->195100352],
Cell[CellGroupData[{
Cell[57000, 1884, 96, 3, 70, "Input",
 CellID->22525949],
Cell[57099, 1889, 343, 10, 36, "Output",
 CellID->94506377]
}, Open  ]],
Cell[57457, 1902, 66, 1, 70, "ExampleText",
 CellID->118225134],
Cell[CellGroupData[{
Cell[57548, 1907, 101, 3, 70, "Input",
 CellID->678760241],
Cell[57652, 1912, 516, 17, 36, "Output",
 CellID->64955685]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58229, 1936, 311, 9, 70, "SeeAlsoSection",
 CellID->10883],
Cell[58543, 1947, 1423, 53, 70, "SeeAlso",
 CellID->28645]
}, Open  ]],
Cell[CellGroupData[{
Cell[60003, 2005, 313, 9, 70, "TutorialsSection",
 CellID->4255],
Cell[60319, 2016, 148, 3, 70, "Tutorials",
 CellID->21289]
}, Open  ]],
Cell[CellGroupData[{
Cell[60504, 2024, 321, 9, 70, "RelatedLinksSection",
 CellID->17804],
Cell[60828, 2035, 182, 4, 70, "RelatedLinks"],
Cell[61013, 2041, 200, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61250, 2050, 318, 9, 70, "MoreAboutSection",
 CellID->23887705],
Cell[61571, 2061, 137, 3, 70, "MoreAbout",
 CellID->230105204],
Cell[61711, 2066, 149, 3, 70, "MoreAbout",
 CellID->661395788],
Cell[61863, 2071, 160, 3, 70, "MoreAbout",
 CellID->279726057]
}, Open  ]],
Cell[62038, 2077, 27, 0, 70, "History"],
Cell[62068, 2079, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

