(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    255552,       8597]
NotebookOptionsPosition[    219012,       7272]
NotebookOutlinePosition[    221367,       7334]
CellTagsIndexPosition[    221253,       7328]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics: Basic Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematics-BasicOperations"], 
          "Simplifying Algebraic Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SimplifyingAlgebraicExpressions"], "Integration" :> 
          Documentation`HelpLookup["paclet:tutorial/Integration"], 
          "Indefinite Integrals" :> 
          Documentation`HelpLookup["paclet:tutorial/IndefiniteIntegrals"], 
          "Integrals over Regions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegralsOverRegions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Symbolic Mathematics: Basic Operations\"\>", 
       2->"\<\"Simplifying Algebraic Expressions\"\>", 
       3->"\<\"Integration\"\>", 4->"\<\"Indefinite Integrals\"\>", 
       5->"\<\"Integrals over Regions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NIntegrate" :> 
          Documentation`HelpLookup["paclet:ref/NIntegrate"], "DSolve" :> 
          Documentation`HelpLookup["paclet:ref/DSolve"], "Sum" :> 
          Documentation`HelpLookup["paclet:ref/Sum"], "LaplaceTransform" :> 
          Documentation`HelpLookup["paclet:ref/LaplaceTransform"], 
          "FourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierTransform"], "D" :> 
          Documentation`HelpLookup["paclet:ref/D"], "Derivative" :> 
          Documentation`HelpLookup["paclet:ref/Derivative"], "CDF" :> 
          Documentation`HelpLookup["paclet:ref/CDF"], "ExpectedValue" :> 
          Documentation`HelpLookup["paclet:ref/ExpectedValue"], "Normalize" :> 
          Documentation`HelpLookup["paclet:ref/Normalize"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NIntegrate\"\>", 
       2->"\<\"DSolve\"\>", 3->"\<\"Sum\"\>", 4->"\<\"LaplaceTransform\"\>", 
       5->"\<\"FourierTransform\"\>", 6->"\<\"D\"\>", 7->"\<\"Derivative\"\>",
        8->"\<\"CDF\"\>", 9->"\<\"ExpectedValue\"\>", 
       10->"\<\"Normalize\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> Documentation`HelpLookup["paclet:guide/Calculus"],
           "Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Generalized Functions" :> 
          Documentation`HelpLookup["paclet:guide/GeneralizedFunctions"], 
          "Inequalities" :> 
          Documentation`HelpLookup["paclet:guide/Inequalities"], 
          "Integral Transforms" :> 
          Documentation`HelpLookup["paclet:guide/IntegralTransforms"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "Rational Functions" :> 
          Documentation`HelpLookup["paclet:guide/RationalFunctions"], 
          "Series Expansions" :> 
          Documentation`HelpLookup["paclet:guide/SeriesExpansions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Calculus\"\>", 
       2->"\<\"Computational Geometry\"\>", 
       3->"\<\"Generalized Functions\"\>", 4->"\<\"Inequalities\"\>", 
       5->"\<\"Integral Transforms\"\>", 6->"\<\"Precollege Education\"\>", 
       7->"\<\"Rational Functions\"\>", 
       8->"\<\"Series Expansions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "Integrate ",
     StyleBox["(\[Integral])", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Integrate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Integrate"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the indefinite integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Integral]", "f", " ", "d", "x"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Integrate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Integrate"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the definite integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         SubscriptBox["x", 
          StyleBox["min", "TI"]], 
         SubscriptBox["x", 
          StyleBox["max", "TI"]]], " ", "f", " ", "d", "x"}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Integrate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Integrate"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the multiple integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         SubscriptBox["x", 
          StyleBox["min", "TI"]], 
         SubscriptBox["x", 
          StyleBox["max", "TI"]]], 
        RowBox[{"d", "x", 
         RowBox[{
          SubsuperscriptBox["\[Integral]", 
           SubscriptBox["y", 
            StyleBox["min", "TI"]], 
           SubscriptBox["y", 
            StyleBox["max", "TI"]]], 
          RowBox[{
          "d", "\[InvisibleSpace]", "y", " ", "\[Ellipsis]", " ", "f"}]}]}]}],
        TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->14481]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " can be entered as ",
 Cell[BoxData["\[Integral]"], "InlineFormula"],
 "\[ThinSpace]",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 "\[ThinSpace]",
 Cell[BoxData["\[DifferentialD]"], "InlineFormula"],
 "\[ThinSpace]",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14036],

Cell[TextData[{
 Cell[BoxData["\[Integral]"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]int\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Integral]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Integral"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->24837],

Cell[TextData[{
 Cell[BoxData["\[DifferentialD]"], "InlineFormula"],
 " is not an ordinary ",
 Cell[BoxData["d"], "InlineFormula"],
 "; it is entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]dd\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[DifferentialD]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DifferentialD"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->32118],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " can be entered with ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " as a subscript and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " as a superscript to ",
 Cell[BoxData["\[Integral]"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31049],

Cell[TextData[{
 "Multiple integrals use a variant of the standard iterator notation. The \
first variable given corresponds to the outermost integral, and is done last. \
",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->5853,
  ButtonNote->"5853"]
}], "Notes",
 CellID->27593],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " can evaluate integrals of rational functions. It can also evaluate \
integrals that involve exponential, logarithmic, trigonometric and inverse \
trigonometric functions, so long as the result comes out in terms of the same \
set of functions. "
}], "Notes",
 CellID->5645],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " can give results in terms of many special functions. "
}], "Notes",
 CellID->14053],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " carries out some simplifications on integrals it cannot explicitly do. "
}], "Notes",
 CellID->18086],

Cell[TextData[{
 "You can get a numerical result by applying ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to a definite integral. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->19981,
  ButtonNote->"19981"]
}], "Notes",
 CellID->3322],

Cell[TextData[{
 "You can assign values to patterns involving ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " to give results for new classes of integrals. "
}], "Notes",
 CellID->13287],

Cell[TextData[{
 "The integration variable can be a construct such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 ", or any expression whose head is not a mathematical function. "
}], "Notes",
 CellID->334],

Cell[TextData[{
 "For indefinite integrals, ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " tries to find results that are correct for almost all values of \
parameters. "
}], "Notes",
 CellID->703],

Cell["For definite integrals, the following options can be given: ", "Notes",
 CellID->28908],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Assumptions"], 
    ButtonBox["$Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Assumptions"], Cell[
    "assumptions to make about parameters ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["GenerateConditions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GenerateConditions"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
whether to generate answers that involve conditions on parameters \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PrincipalValue",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PrincipalValue"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to find Cauchy principal values ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->149],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " can evaluate essentially all indefinite integrals and most definite \
integrals listed in standard books of tables. "
}], "Notes",
 CellID->28160],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is output as ",
 Cell[BoxData["\[Integral]"], "InlineFormula"],
 "\[ThinSpace]",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 "\[ThinSpace]",
 Cell[BoxData["\[DifferentialD]"], "InlineFormula"],
 "\[ThinSpace]",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4028]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->283678441],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(6)", "ExampleCount"]
}], "ExampleSection",
 CellID->778583290],

Cell["Indefinite integral:", "ExampleText",
 CellID->31313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "+", "1"}], ")"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29742],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"2", " ", "x"}]}], 
     SqrtBox["3"]], "]"}], 
   SqrtBox["3"]], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 ImageSize->{298, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262938641]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10681],

Cell["Definite integral:", "ExampleText",
 CellID->11901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "+", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7671],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "18"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SqrtBox["3"], " ", "\[Pi]"}], "+", 
    RowBox[{"Log", "[", "64", "]"}]}], ")"}]}]], "Output",
 ImageSize->{146, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61363406]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13281],

Cell[TextData[{
 "Use ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]int\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " to enter ",
 Cell[BoxData["\[Integral]"], "InlineFormula"],
 " and ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]dd\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " to enter ",
 Cell[BoxData["\[DifferentialD]"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "+", 
     RowBox[{"Sqrt", "[", "x", "]"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9575],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "12"], " ", 
   SqrtBox[
    RowBox[{
     SqrtBox["x"], "+", "x"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", 
     RowBox[{"2", " ", 
      SqrtBox["x"]}], "+", 
     RowBox[{"8", " ", "x"}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", 
      SqrtBox["x"]}], "+", 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{
        SqrtBox["x"], "+", "x"}]]}]}], "]"}]}]}]], "Output",
 ImageSize->{396, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227605315]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21553],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "12"], " ", 
    SqrtBox[
     RowBox[{"x", "+", 
      SqrtBox["x"]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", "x"}], "+", 
      RowBox[{"2", " ", 
       SqrtBox["x"]}], "-", "3"}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"log", "(", 
     RowBox[{
      RowBox[{"2", " ", 
       SqrtBox["x"]}], "+", 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"x", "+", 
         SqrtBox["x"]}]]}], "+", "1"}], ")"}]}]}], TraditionalForm]], "Output",\

 ImageSize->{348, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->300119610]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27030],

Cell[TextData[{
 "Use ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 " to enter the lower limit, then ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " for the upper limit:"
}], "ExampleText",
 CellID->21935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], " ", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     SuperscriptBox["x", "2"]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1825],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "4"]}], " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{"(", 
   RowBox[{"EulerGamma", "+", 
    RowBox[{"Log", "[", "4", "]"}]}], ")"}]}]], "Output",
 ImageSize->{193, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63627750]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5205],

Cell[TextData[{
 "Multiple integral with ",
 Cell[BoxData["x"], "InlineFormula"],
 " integration outermost:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->5853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23449],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"EulerGamma", "-", 
    RowBox[{"CosIntegral", "[", "1", "]"}]}], ")"}]}]], "Output",
 ImageSize->{213, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262124086]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   SubsuperscriptBox["\[Integral]", "0", "x"], 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}], 
    RowBox[{"\[DifferentialD]", "y"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30573],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"EulerGamma", "-", 
    RowBox[{"CosIntegral", "[", "1", "]"}]}], ")"}]}]], "Output",
 ImageSize->{213, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2737135]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23126],

Cell["\<\
Integrals that may not converge are by default returned as conditionals:\
\>", "ExampleText",
 CellID->1513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "c"}], " ", 
     SuperscriptBox["x", "2"]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20264],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "c", "]"}], ">", "0"}], ",", 
   FractionBox[
    SqrtBox["\[Pi]"], 
    SqrtBox["c"]], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "c"}], " ", 
       SuperscriptBox["x", "2"]}]], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "c", "]"}], "\[LessEqual]", "0"}]}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{485, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->361791641]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(19)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6433],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Indefinite Integrals",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3603],

Cell["Rational functions can always be integrated in closed form:", \
"ExampleText",
 CellID->7681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", "1"}], ")"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30170],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", "x", "]"}], "2"]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}]}]], "Output",
 ImageSize->{264, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->795242670]
}, Open  ]],

Cell[TextData[{
 "Sometimes they involve sums of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->5633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "5"}], "+", 
      RowBox[{"2", "x"}], "+", "1"}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18835],

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "#1"}], "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"Log", "[", 
      RowBox[{"x", "-", "#1"}], "]"}], 
     RowBox[{"2", "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["#1", "4"]}]}]], "&"}]}], "]"}]], "Output",
 ImageSize->{248, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40900940]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21014],

Cell["Similar integrals can lead to functions of different kinds:", \
"ExampleText",
 CellID->595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "x", "]"}], 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10848],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SqrtBox["x"], " ", 
     SqrtBox[
      RowBox[{"1", "+", "x"}]], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], ")"}]}], "-", 
    RowBox[{"ArcSinh", "[", 
     SqrtBox["x"], "]"}]}], ")"}]}]], "Output",
 ImageSize->{256, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->292740078]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "x", "]"}], 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "+", "x"}], "]"}], 
    RowBox[{"Sqrt", "[", 
     RowBox[{"2", "+", "x"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24259],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "5"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SqrtBox["x"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], 
      RowBox[{"3", "/", "2"}]], " ", 
     SqrtBox[
      RowBox[{"2", "+", "x"}]]}], "-", 
    FractionBox[
     RowBox[{"4", " ", 
      SqrtBox[
       FractionBox[
        RowBox[{"1", "+", "x"}], 
        RowBox[{"2", "+", "x"}]]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox[
          RowBox[{"1", "+", 
           FractionBox["1", "x"]}]], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "x"}], ")"}]}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["x"], " ", 
         SqrtBox[
          FractionBox[
           RowBox[{"2", "+", "x"}], "x"]], " ", 
         RowBox[{"EllipticE", "[", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"ArcSinh", "[", 
             FractionBox["1", 
              SqrtBox["x"]], "]"}]}], ",", "2"}], "]"}]}]}], ")"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "+", 
        FractionBox["1", "x"]}]], " ", 
      SqrtBox["x"]}]]}], ")"}]}]], "Output",
 ImageSize->{482, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->94687706]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21164],

Cell["\<\
Many integrals can be done only in terms of special functions:\
\>", "ExampleText",
 CellID->22027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"Log", "[", "x", "]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15907],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"Log", "[", "x", "]"}], "]"}]}], "-", 
  RowBox[{"LogIntegral", "[", "x", "]"}]}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30597652]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15426],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{"Erf", "[", "x", "]"}]}]], "Output",
 ImageSize->{88, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66840874]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Tan", "[", "x", "]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6769],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", "\[ExponentialE]"}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", "2"]}], ")"}], " ", 
     RowBox[{"CosIntegral", "[", 
      RowBox[{"\[ImaginaryI]", "-", 
       RowBox[{"Tan", "[", "x", "]"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["\[ExponentialE]", "2"]}], ")"}], " ", 
     RowBox[{"CosIntegral", "[", 
      RowBox[{"\[ImaginaryI]", "+", 
       RowBox[{"Tan", "[", "x", "]"}]}], "]"}]}], "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"SinIntegral", "[", 
        RowBox[{"\[ImaginaryI]", "-", 
         RowBox[{"Tan", "[", "x", "]"}]}], "]"}], "+", 
       RowBox[{"SinIntegral", "[", 
        RowBox[{"\[ImaginaryI]", "+", 
         RowBox[{"Tan", "[", "x", "]"}]}], "]"}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 ImageSize->{479, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->539441456]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}], "^", "2"}], "/", "x"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->22118],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"-", "x"}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", "x"}], "]"}], "2"]}], "+", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"2", ",", 
       RowBox[{"1", "+", "x"}]}], "]"}]}], "-", 
    RowBox[{"PolyLog", "[", 
     RowBox[{"3", ",", 
      RowBox[{"1", "+", "x"}]}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{468, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->179951263]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", "x", "]"}], 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"x", "^", "2"}]}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->26935],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "x"}], " ", 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "2"], ",", 
       FractionBox["3", "2"]}], "}"}], ",", 
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"Erf", "[", "x", "]"}], " ", 
   RowBox[{"Log", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{434, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->55562468]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Tan", "[", "x", "]"}], "^", "n"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->12298],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", "n"}], "2"], ",", "1", ",", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"1", "+", "n"}], "2"]}], ",", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"Tan", "[", "x", "]"}], "2"]}]}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Tan", "[", "x", "]"}], 
    RowBox[{"1", "+", "n"}]]}], 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{356, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->210564165]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"x", "^", "n"}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1823],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["x", "n"], ")"}], 
     RowBox[{
      RowBox[{"-", "1"}], "/", "n"}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["1", "n"], ",", 
      SuperscriptBox["x", "n"]}], "]"}]}], "n"]}]], "Output",
 ImageSize->{159, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->55097019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4677],

Cell["Integrate special functions:", "ExampleText",
 CellID->32300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17925],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"HypergeometricPFQ", "[", 
   RowBox[{
    RowBox[{"{", 
     FractionBox["1", "2"], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      FractionBox["3", "2"]}], "}"}], ",", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["x", "2"], "4"]}]}], "]"}]}]], "Output",
 ImageSize->{263, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16528732]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "x", "]"}], 
    RowBox[{"PolyLog", "[", 
     RowBox[{"2", ",", "x"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7936],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["4", "27"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      RowBox[{"Log", "[", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["x"]}], "]"}]}], "+", 
     RowBox[{"3", " ", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        SqrtBox["x"]}], "]"}]}], "+", 
     RowBox[{
      SqrtBox["x"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "6"}], "-", 
        RowBox[{"2", " ", "x"}], "+", 
        RowBox[{"3", " ", "x", " ", 
         RowBox[{"Log", "[", 
          RowBox[{"1", "-", "x"}], "]"}]}]}], ")"}]}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["2", "3"], " ", 
   SuperscriptBox["x", 
    RowBox[{"3", "/", "2"}]], " ", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", "x"}], "]"}]}]}]], "Output",
 ImageSize->{577, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->531978575]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"AiryAi", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8528],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["1", "3"], "]"}], " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["5", "3"], "]"}], " ", 
        RowBox[{"HypergeometricPFQ", "[", 
         RowBox[{
          RowBox[{"{", 
           FractionBox["1", "3"], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            FractionBox["2", "3"], ",", 
            FractionBox["4", "3"]}], "}"}], ",", 
          FractionBox[
           SuperscriptBox["x", "3"], "9"]}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["3", 
         RowBox[{"1", "/", "3"}]], " ", "x", " ", 
        SuperscriptBox[
         RowBox[{"Gamma", "[", 
          FractionBox["2", "3"], "]"}], "2"], " ", 
        RowBox[{"HypergeometricPFQ", "[", 
         RowBox[{
          RowBox[{"{", 
           FractionBox["2", "3"], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            FractionBox["4", "3"], ",", 
            FractionBox["5", "3"]}], "}"}], ",", 
          FractionBox[
           SuperscriptBox["x", "3"], "9"]}], "]"}]}]}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"9", " ", 
     SuperscriptBox["3", 
      RowBox[{"2", "/", "3"}]], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["2", "3"], "]"}], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["4", "3"], "]"}], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["5", "3"], "]"}]}], ")"}]}]}]], "Output",
 ImageSize->{434, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->320853121]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"SinhIntegral", "[", 
    RowBox[{"2", "/", 
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->286494465],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", 
   RowBox[{"CoshIntegral", "[", 
    FractionBox["2", 
     RowBox[{"1", "+", "x"}]], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"Sinh", "[", 
    FractionBox["2", 
     RowBox[{"1", "+", "x"}]], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"SinhIntegral", "[", 
    FractionBox["2", 
     RowBox[{"1", "+", "x"}]], "]"}]}]}]], "Output",
 ImageSize->{465, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->188454025]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18419],

Cell["Integrate piecewise functions:", "ExampleText",
 CellID->29949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"2", "^", 
    RowBox[{"Max", "[", 
     RowBox[{"x", ",", 
      RowBox[{"1", "-", "x"}]}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3203],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["2", 
        RowBox[{"1", "-", "x"}]], 
       RowBox[{"Log", "[", "2", "]"}]]}], 
     RowBox[{"x", "\[LessEqual]", 
      FractionBox["1", "2"]}]},
    {
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", 
         SqrtBox["2"]}], 
        RowBox[{"Log", "[", "2", "]"}]]}], "+", 
      FractionBox[
       SuperscriptBox["2", "x"], 
       RowBox[{"Log", "[", "2", "]"}]]}], 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{147, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172840090]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"UnitStep", "[", "x", "]"}]}], ",", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->233617052],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["x", "2"], " ", 
  RowBox[{"UnitStep", "[", "x", "]"}]}]], "Output",
 ImageSize->{111, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34528428]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Clip", "[", "x", "]"}], "^", "2"}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->585337297],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV81uE0EMnmZ3k/5QmlIoAVEIF0gFHFoq7r20pcBDbEOl9oCISqXmUuUR
cswj5JhH4BHyGDnmEZbxjKedfOtth6yEGCnrtcf+bI/HXuVbenl2+iO9PG+n
zcOLtHN23v7VPPh5oUXRglLqWv/2G0q/Z/rN/K6zTFP/GdEz7na7v82aTCZr
WlLRyqe3+1Gv18vMUo8MT1iWPxG11kGrXQKr7mnpp/pewuOVKH0BtjGfQIXp
pqa0TXYJU5JbILtIN9b0lejhoeHH43HPLLNleN5PIALDx7e8Ug3QiO7hXfy+
7LUYW9XLSkXT6XQmRs17Hkivytk/C4koueH5qMJiwoqU95kU1gZ9hZ09RRMX
Z5iTyr7p1hKw6zl3456CRye3Ls0Ci4iRmqIf7LRWLkesy46IQ71IZtua1jT9
WKgV1rGVwt2w2SD387+V1r2aEf0alM8m8J8Lz+guq+MSvmzFB4PBcDhEX4qn
ns9/8azCfR17Vp1Op9/v02tXjBs78U1m+3YZ5O7OO+omWJJ5k6z0DK6Cfs3o
2wRo6wnoL3rRzPbWCmiiJzneeeayr2fjHY1GrPeA9WIhT4p7ieky08WgKLFm
rYJTqXmoFaGm86GLKDNn77IKy4Z6mZQ2cjhbYI8TGyMJq3EdtB4z2kuQvw1C
w2mxwWhbTFtMkyBr09mJfwb0JHt56uDUfw54h0Fe8Vt7JFp9CMJ+BxHJM/Z9
kMf/4UvzN1KqsX8/d4F3s3KVaUNEyc+yvZwEb/4q8DKymwefstnpU8vkKRWG
4nj8Ks2fnZtX2KkeYqxnrJ25+mOB/x3w3JeCTutElKaMYTqL/7+phT+UWJ2p
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{125, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->818793936]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Piecewise", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "^", "2"}], ",", " ", 
        RowBox[{"x", "<", "1"}]}], "}"}], ",", 
      RowBox[{"{", " ", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"x", "^", "2"}], "]"}], ",", " ", 
        RowBox[{"1", " ", "<", " ", "x", " ", "<", " ", "2"}]}], "}"}]}], 
     "}"}], "]"}], ",", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->18174327],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     FractionBox[
      SuperscriptBox["x", "3"], "3"], 
     RowBox[{"x", "\[LessEqual]", "1"}]},
    {
     RowBox[{
      FractionBox["1", "3"], "-", 
      RowBox[{
       SqrtBox[
        FractionBox["\[Pi]", "2"]], " ", 
       RowBox[{"FresnelS", "[", 
        SqrtBox[
         FractionBox["2", "\[Pi]"]], "]"}]}], "+", 
      RowBox[{
       SqrtBox[
        FractionBox["\[Pi]", "2"]], " ", 
       RowBox[{"FresnelS", "[", 
        RowBox[{
         SqrtBox[
          FractionBox["2", "\[Pi]"]], " ", "x"}], "]"}]}]}], 
     RowBox[{"1", "<", "x", "\[LessEqual]", "2"}]},
    {
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"3", " ", 
         SqrtBox[
          RowBox[{"2", " ", "\[Pi]"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"FresnelS", "[", 
            SqrtBox[
             FractionBox["2", "\[Pi]"]], "]"}], "-", 
           RowBox[{"FresnelS", "[", 
            RowBox[{"2", " ", 
             SqrtBox[
              FractionBox["2", "\[Pi]"]]}], "]"}]}], ")"}]}]}], ")"}]}], 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{407, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->210992142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12752],

Cell["Multiple indefinite integrals:", "ExampleText",
 CellID->28709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "4"}], ")"}]}], ",", "x", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109590014],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"ArcTan", "[", 
      FractionBox["x", "2"], "]"}]}], "-", 
    RowBox[{"Log", "[", 
     RowBox[{"4", "+", 
      SuperscriptBox["x", "2"]}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{189, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14559129]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"D", "[", 
   RowBox[{"%", ",", "x", ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->430573747],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"4", "+", 
   SuperscriptBox["x", "2"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->208561]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Erf", "[", "x", "]"}], ",", "x", ",", "x", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4111],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     SuperscriptBox["x", "2"]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["x", "2"]}], ")"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       SuperscriptBox["x", "2"]], " ", 
      SqrtBox["\[Pi]"], " ", "x", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], " ", 
      RowBox[{"Erf", "[", "x", "]"}]}]}], ")"}]}], 
  RowBox[{"12", " ", 
   SqrtBox["\[Pi]"]}]]], "Output",
 ImageSize->{277, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->411094279]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"D", "[", 
   RowBox[{"%", ",", "x", ",", "x", ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->22461],

Cell[BoxData[
 RowBox[{"Erf", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->3792901]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10348],

Cell["Integrate an interpolating function:", "ExampleText",
 CellID->21708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"{", 
    RowBox[{"10", ",", 
     RowBox[{"-", "5"}], ",", "10", ",", 
     RowBox[{"-", "10"}], ",", "20"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22060],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241589487]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18224],

Cell[BoxData[
 RowBox[{
  TagBox[
   RowBox[{"InterpolatingFunction", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
   False,
   Editable->False], "[", "x", "]"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6768754]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31891],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->122596938]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Definite Integrals",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->16845],

Cell["Rational functions:", "ExampleText",
 CellID->4509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "4"}], "+", 
      RowBox[{"x", "^", "2"}], "+", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13857],

Cell[BoxData[
 FractionBox["\[Pi]", 
  RowBox[{"2", " ", 
   SqrtBox["3"]}]]], "Output",
 ImageSize->{42, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1322641]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"x", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", "3"}], ")"}], "^", "7"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "11"}], "}"}]}], "]"}], "\n"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->59272502],

Cell[BoxData[
 FractionBox["4622415", "227200942336"]], "Output",
 ImageSize->{99, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->165974874]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "6"}], "+", 
      RowBox[{"x", "^", "2"}], "+", "2"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19202],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "56"], " ", 
  RowBox[{"(", 
   RowBox[{"7", "+", 
    SqrtBox[
     RowBox[{"7", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "5"}], "+", 
        RowBox[{"4", " ", 
         SqrtBox["2"]}]}], ")"}]}]]}], ")"}], " ", "\[Pi]"}]], "Output",
 ImageSize->{175, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->858683099]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->85192215],

Cell["Algebraic functions:", "ExampleText",
 CellID->131378107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "-", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->753879101],

Cell[BoxData[
 FractionBox["4", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118237163]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"x", "^", "4"}]}], ")"}], 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "-", 
        RowBox[{"x", "^", "4"}]}], "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->323193095],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "8"], "-", 
  FractionBox[
   RowBox[{"2", " ", 
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Gamma", "[", 
     FractionBox["5", "4"], "]"}]}], 
   RowBox[{"Gamma", "[", 
    RowBox[{"-", 
     FractionBox["1", "4"]}], "]"}]]}]], "Output",
 ImageSize->{130, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->147866736]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"x", "^", "2"}]}], ")"}], 
      RowBox[{"Sqrt", "[", 
       RowBox[{"4", "+", 
        RowBox[{"3", 
         RowBox[{"x", "^", "2"}]}]}], "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->433504700],

Cell[BoxData[
 RowBox[{"ArcCosh", "[", 
  SqrtBox[
   FractionBox["3", "2"]], "]"}]], "Output",
 ImageSize->{98, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->12327946]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14018],

Cell["Elementary functions:", "ExampleText",
 CellID->384340572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6460],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "12"]}], " ", "\[ImaginaryI]", " ", 
  RowBox[{"(", 
   RowBox[{"6", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "6"}], "+", "\[Pi]"}], ")"}], " ", "\[Pi]"}], "-", 
    RowBox[{"12", " ", "\[ImaginaryI]", " ", 
     RowBox[{"Log", "[", "2", "]"}]}], "-", 
    RowBox[{"6", " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"2", ",", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]"}]]}], "]"}]}]}], ")"}]}]], "Output",\

 ImageSize->{344, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95099859]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "x"}], "+", 
     RowBox[{"Exp", "[", 
      RowBox[{"-", "x"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17255],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", "\[ExponentialE]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44343488]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "I"}], " ", "x"}], "]"}], "/", 
     RowBox[{
      RowBox[{"Cosh", "[", "x", "]"}], "^", "3"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}], 
  "\n"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->143181692],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", 
  RowBox[{"Sech", "[", 
   FractionBox["\[Pi]", "2"], "]"}]}]], "Output",
 ImageSize->{70, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->589150307]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}], "\n"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->43142740],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[Pi]", " ", 
  RowBox[{"BesselJ", "[", 
   RowBox[{"0", ",", 
    FractionBox["1", "2"]}], "]"}], " ", 
  RowBox[{"Cos", "[", 
   FractionBox["1", "2"], "]"}]}]], "Output",
 ImageSize->{171, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->57952863]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1067],

Cell["Special functions:", "ExampleText",
 CellID->24123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BesselK", "[", 
     RowBox[{"0", ",", "x"}], "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7918],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "2"], "4"]], "Output",
 ImageSize->{22, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55730947]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"AiryAi", "[", "x", "]"}], "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2797],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SuperscriptBox["3", 
    RowBox[{"2", "/", "3"}]], " ", 
   SuperscriptBox[
    RowBox[{"Gamma", "[", 
     FractionBox["1", "3"], "]"}], "2"]}]]], "Output",
 ImageSize->{99, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29436968]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"PolyGamma", "[", "x", "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->422088865],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", 
  RowBox[{"Log", "[", 
   RowBox[{"2", " ", "\[Pi]"}], "]"}]}]], "Output",
 ImageSize->{79, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->344584358]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", "x"}], "]"}], " ", 
    RowBox[{"Sinc", "[", "x", "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->286339710],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->61942880]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "2"}], "]"}], 
     RowBox[{"Erfc", "[", "x", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}], 
  "\n"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->226509455],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Pi]", "-", 
   RowBox[{"2", " ", 
    RowBox[{"ArcCoth", "[", 
     SqrtBox["2"], "]"}]}]}], 
  RowBox[{"4", " ", 
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]]}]]], "Output",
 ImageSize->{126, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->592917535]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"KelvinKer", "[", "x", "]"}], 
    RowBox[{"BesselJ", "[", 
     RowBox[{"1", ",", "x"}], "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", " ", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->64851977],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", "2", "]"}], "4"]], "Output",
 ImageSize->{51, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->268078698]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30624],

Cell["Piecewise functions:", "ExampleText",
 CellID->23438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8516],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox["2"]}]], "Output",
 ImageSize->{38, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->639609570]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24196],

Cell[BoxData[
 RowBox[{"21", "-", 
  RowBox[{"3", " ", 
   SqrtBox["2"]}], "-", 
  SqrtBox["3"], "-", 
  SqrtBox["5"], "-", 
  SqrtBox["6"], "-", 
  SqrtBox["7"]}]], "Output",
 ImageSize->{211, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->412503021]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PrimePi", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22683],

Cell[BoxData["1440"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->193901078]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], " ", 
    RowBox[{"UnitStep", "[", 
     RowBox[{"x", "+", "Pi"}], "]"}], 
    RowBox[{"UnitStep", "[", 
     RowBox[{"Pi", "-", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->96097063],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->836076964]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10601],

Cell["When there are parameters, conditions are often needed:", "ExampleText",
 CellID->3828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14161],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "n", "]"}], ">", 
    RowBox[{"-", "1"}]}], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", "n"}]], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     SuperscriptBox["x", "n"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "n", "]"}], "\[LessEqual]", 
       RowBox[{"-", "1"}]}]}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{475, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163535089]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a", "x"}], "]"}], "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31875],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"a", "\[Element]", "Reals"}], ",", 
   FractionBox[
    RowBox[{"\[Pi]", " ", 
     RowBox[{"Abs", "[", "a", "]"}]}], 
    RowBox[{"2", " ", "a"}]], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"Sin", "[", 
       RowBox[{"a", " ", "x"}], "]"}], "x"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"Im", "[", "a", "]"}], "<", "0"}], "||", 
       RowBox[{
        RowBox[{"Im", "[", "a", "]"}], ">", "0"}]}]}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{457, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->650804743]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"a", " ", "x"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8773],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "\[Pi]", " ", 
       RowBox[{"Re", "[", "a", "]"}]}]}], "\[GreaterEqual]", "0"}], "||", 
    RowBox[{
     RowBox[{"Im", "[", "a", "]"}], "\[NotEqual]", "0"}]}], ",", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "a", " ", "\[Pi]"}]}], "]"}], "a"], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "+", 
       RowBox[{"a", " ", "x"}]}]], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"!", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "\[Pi]", " ", 
            RowBox[{"Re", "[", "a", "]"}]}]}], "\[GreaterEqual]", "0"}], "||",
          
         RowBox[{
          RowBox[{"Im", "[", "a", "]"}], "\[NotEqual]", "0"}]}], ")"}]}]}]}], 
    "]"}]}], "]"}]], "Output",
 ImageSize->{516, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->158356520]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21747],

Cell["Integrate generalized functions:", "ExampleText",
 CellID->26038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], " ", 
    RowBox[{"DiracDelta", "[", 
     RowBox[{"x", "-", "a"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"a", "\[Element]", "Reals"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13964],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "a", "]"}], " ", 
  RowBox[{"HeavisideTheta", "[", 
   RowBox[{"1", "-", "a"}], "]"}], " ", 
  RowBox[{"HeavisideTheta", "[", 
   RowBox[{"1", "+", "a"}], "]"}]}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->561582741]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"DiracDelta", "[", 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "1"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->749],

Cell[BoxData[
 SqrtBox[
  FractionBox["2", 
   RowBox[{"2", "+", "\[Pi]"}]]]], "Output",
 ImageSize->{56, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->176159408]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Integrals over Regions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15516],

Cell["Integrate a constant over a unit disk:", "ExampleText",
 CellID->20839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", "1", ",", "0"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16590],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13298948]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28782],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->239499576]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15995],

Cell["More general integral over a unit disk:", "ExampleText",
 CellID->110280238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Sqrt", "[", "x", "]"}], "]"}], 
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"S3.5.9",
 CellLabel->"In[1]:=",
 CellID->4119],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"Gamma", "[", 
    FractionBox["3", "4"], "]"}]}], 
  RowBox[{"Gamma", "[", 
   FractionBox["9", "4"], "]"}]]], "Output",
 ImageSize->{96, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S3.5.9",
 CellLabel->"Out[1]=",
 CellID->84572356]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1655280],

Cell["\<\
Regions can be given as logical combinations of inequalities:\
\>", "ExampleText",
 CellID->885557591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{"1", "<", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"y", "^", "2"}]}], "<", "4"}], "&&", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "<", "1"}], "&&", 
     RowBox[{"x", ">", "0"}], "&&", 
     RowBox[{"y", ">", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], " ", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1262780],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"4", " ", 
     RowBox[{"ArcCsch", "[", "2", "]"}]}], "+", 
    RowBox[{"ArcSinh", "[", "2", "]"}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", "4", "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox["5"]}], ")"}]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{393, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1432161]
}, Open  ]],

Cell[TextData[{
 "Visualize 2D regions using ",
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->102577523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "<", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "2"}]}], "<", "4"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y"}], "<", "1"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", 
     RowBox[{"5", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149382696],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->519358536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->566235086],

Cell["\<\
Regions can be in any dimension; in this case integrate over a cone:\
\>", "ExampleText",
 CellID->409460324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ")"}], " ", 
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{"0", "\[LessEqual]", "z", "\[LessEqual]", "1"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "\[LessEqual]", 
       RowBox[{"z", "^", "2"}]}]}], "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], " ", ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], " ", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->696959573],

Cell[BoxData[
 FractionBox["\[Pi]", "10"]], "Output",
 ImageSize->{23, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29248248]
}, Open  ]],

Cell[TextData[{
 "Visualize 3D regions using ",
 Cell[BoxData[
  ButtonBox["RegionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->516358466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"0", "\[LessEqual]", "z", "\[LessEqual]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[LessEqual]", 
     RowBox[{"z", "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->990731555],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->104250866]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29916],

Cell["\<\
Integrate a function with parameters, getting a piecewise result:\
\>", "ExampleText",
 CellID->24587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{"a", "x"}], "<", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"S3.5.9",
 CellLabel->"In[1]:=",
 CellID->15021],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9VktOAkEQHeYjID+NiSIrFioxJiYewMQ/0cSlK1YTYgIL4wRZsJsjsOQI
LDmCR+AYHKPt6i5gKIqhYQydTPdU9ZtXn+6unne/2/r88rvtpl+td/yg1W7+
VF++O1LlpCzLasjntmzJdyHf1NMQQo66L8rekUpXjq4cH5TWgd7t9Xq/qk0m
kzRoAChUU3gQH+d4JwxDnM0StEfke6OvwIa90kYmgpa99WbE+cqiPjbQnmPk
oPdwBC81UDcbs3nCMlwQn5w1so2MUd0py6xXSa4Y+pFVfkkZ5w9MLHszGQMy
s20UFcvtbZQpG3frCj+XtDxzDu0e01yjBW1CNdRMZ4AJPiizvAXCdwSdO5eX
s3lpzJOW4pUR+jkBKo9x1tnZTU5Kcm0Bc50kniJBPSmUXoXBYDAcDuG1FIPi
uayZXxoVBEG/31/N9R81Z58wQ131cLPCuIejzbKcCe58QM2wcVyepfVzj8i8
JVqH8qQO5VhbHnqSjfWTerRNrHB3uBGLuQSc3K2V1Hvwz8GvwM8iy3ko+F1h
tkYZBuUuVj7ZSqzlmpEFGiu1OP33qIlIVV/LMs3k3dqowNNd/RXsVjs95xWx
eP7TIu5uovlX9/iW+5m/Vc0sxFccM2aIPHqC+ZqxEy/d0WgUqjYej+l/ckXw
ZzQuq/TGuo7BFtDLGxFdef1vb6X+AC8LmIY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S3.5.9",
 CellLabel->"Out[1]=",
 CellID->27179733]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25533],

Cell["Infinite number of regions:", "ExampleText",
 CellID->24792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Boole", "[", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ">", 
      RowBox[{"1", "/", "2"}]}], "]"}], 
    RowBox[{"Exp", "[", 
     RowBox[{"-", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195932755],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"7", " ", "\[Pi]"}], "/", "6"}]], 
  RowBox[{"1", "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"2", " ", "\[Pi]"}], "/", "3"}]], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"4", " ", "\[Pi]"}], "/", "3"}]]}]]], "Output",
 ImageSize->{102, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->402824683]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Symbolic Features of Integrals",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->11478],

Cell["\<\
Integrals involving unknown functions are done when possible:\
\>", "ExampleText",
 CellID->13216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "''"}], "[", "x", "]"}], "+", 
    RowBox[{"2", " ", "a", " ", 
     RowBox[{
      RowBox[{"f", "'"}], "[", "x", "]"}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30608],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "a", " ", 
   RowBox[{"f", "[", "x", "]"}]}], "+", 
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "[", "x", "]"}]}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->376800506]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25636],

Cell["\<\
Symbolic integrals can be differentiated with respect to parameters:\
\>", "ExampleText",
 CellID->10343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "a"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36483299],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "a"], 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{68, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->389534136]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"%", ",", " ", "a"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->137603985],

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->61778513]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "a"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"p", "[", "a", "]"}], ",", 
     RowBox[{"q", "[", "a", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3690],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"p", "[", "a", "]"}], 
   RowBox[{"q", "[", "a", "]"}]], 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "a"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{102, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->826273779]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"%", ",", "a"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->15585],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    RowBox[{"p", "[", "a", "]"}], 
    RowBox[{"q", "[", "a", "]"}]], 
   RowBox[{
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", 
        RowBox[{"0", ",", "1"}], ")"}],
       Derivative],
      MultilineFunction->None], "[", 
     RowBox[{"x", ",", "a"}], "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}], "-", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"p", "[", "a", "]"}], ",", "a"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["p", "\[Prime]",
     MultilineFunction->None], "[", "a", "]"}]}], "+", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"q", "[", "a", "]"}], ",", "a"}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["q", "\[Prime]",
     MultilineFunction->None], "[", "a", "]"}]}]}]], "Output",
 ImageSize->{356, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->17741268]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13719],

Cell["The variable of integration need not be a single symbol:", "ExampleText",
 CellID->30203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"p", "[", "x", "]"}], 
    RowBox[{"Log", "[", 
     RowBox[{"p", "[", "x", "]"}], "]"}]}], ",", 
   RowBox[{"p", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14145],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "4"]}], " ", 
   SuperscriptBox[
    RowBox[{"p", "[", "x", "]"}], "2"]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"p", "[", "x", "]"}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"p", "[", "x", "]"}], "2"]}]}]], "Output",
 ImageSize->{186, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->683552429]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->386341661],

Cell["Combination of indefinite and definite integration:", "ExampleText",
 CellID->388255457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", " ", "x"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->698575728],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "x", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{69, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69996015]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->73344904],

Cell["Integrand with a removable singularity:", "ExampleText",
 CellID->661722613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "/", "x"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->840817358],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80651662]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8201],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12140],

Cell[TextData[{
 "With no ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 ", conditions are generated: "
}], "ExampleText",
 CellID->431762547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22496],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "n", "]"}], ">", 
    RowBox[{"-", "1"}]}], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", "n"}]], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     SuperscriptBox["x", "n"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "n", "]"}], "\[LessEqual]", 
       RowBox[{"-", "1"}]}]}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{475, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->896325504]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " a result valid under the given assumptions is given:"
}], "ExampleText",
 CellID->275914128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"n", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->602],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15314712]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"n", ">", "0"}], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"x", "^", "n"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23638],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->258140256]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2206],

Cell["\<\
Specify assumptions to evaluate a piecewise indefinite integral:\
\>", "ExampleText",
 CellID->456240898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"x", "+", 
     RowBox[{
      RowBox[{"Abs", "[", "x", "]"}], "^", "2"}]}], "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5965],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"x", "+", 
     SuperscriptBox[
      RowBox[{"Abs", "[", "x", "]"}], "2"]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{137, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->608136096]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"x", "+", 
     RowBox[{
      RowBox[{"Abs", "[", "x", "]"}], "^", "2"}]}], "]"}], ",", "x", ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"x", "\[Element]", "Reals"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1692],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWMtu00AUdW0ncVtaEOXhQlFT0UqwRDzWWfXBY8EOgaCECKldIKK2i+yy
Z5Pu8glZ5hP4hHxGPmOYx3U9Pr5xBmO6ykiZ63s9922fm+Rd++Lk+4/2xWmn
3Tw4a3dPTjvnzf2fZ1IULHmedyk/72NPXgt5pT+XQkhq9nW5+1J4X9JA0k3i
3+i7gdrDXq/3W6/pdLqsJOqg0Mu7A/xD4A9TO0G/3ycpWrkH/CbwR6yVFTh1
F/gHTrFE1im5Z2LxqCI2//o/ZvSLlWJeMfDb1DulVyOqemgMmeXLy1DS7VIe
msAHc3ifPNqyHdZzQ/Py2aI4A71J3rKscqrDuYY+12q1/vLcmksmtSueCuiW
SyVVZH3XKu2c6k44O8+clPfcoLg2FBOmHgyWZCUYpU9RmDD0IklyR3lTCk3W
N4dCvoVe+Ziwg89K21VP1HMnbZfKvHWyFFM1YoqDR4+I7iLuIb/Pau8xPm3+
wEkLcY73tWud8igvm+eRulyEPKZerzTpTMGULZhrixlbZUZ8hz4Ig2aYb4JH
Ca2LdM4EVwCG1j6ClcjSzr7/q3CSnwFmkBsMGw6Ho9Eorer1zc5VOhdCzHXK
bpnoip1tYS5pxT7NqFiDaGTRYpvdbncwGHA2sbdBrhtJBkWR/8sc3IIIbors
08VG6BjHvNn1CO7vVWh7i+gTUfRWLObjYj7yUoUsdv++zTxV1LdjVuvGnKp8
ddLCvvG+7Ai5vrUrjJCvJMb5QmQRpiYMWq0RjZ2svBT4XiJS4e8q3i7+2is7
iR6L7MRJMBgnk1t2r0R21twuZSVfowRvbjnZi3L6eTR8Ct1EHHTrQlK1BL2P
SmkdCgtNS2XTYTVVDjYW8E8/ZopY8JnVWucytfgvqVY4Ho/7ek0mE/SGvTfe
Niwp9/Yfa4rf5vkYzL9z3tIfXwal1Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{144, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->279461313]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GenerateConditions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->16031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "a"}], " ", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29188],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "a", "]"}], ">", "0"}], ",", 
   FractionBox[
    SqrtBox["\[Pi]"], 
    RowBox[{"2", " ", 
     SqrtBox["a"]}]], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "a"}], " ", 
       SuperscriptBox["x", "2"]}]], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "a", "]"}], "\[LessEqual]", "0"}]}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{486, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->218546328]
}, Open  ]],

Cell["\<\
Generate a result without conditions that is valid only for some values of \
parameters:\
\>", "ExampleText",
 CellID->12468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "a"}], " ", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"GenerateConditions", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11348],

Cell[BoxData[
 FractionBox[
  SqrtBox["\[Pi]"], 
  RowBox[{"2", " ", 
   SqrtBox["a"]}]]], "Output",
 ImageSize->{42, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->612548533]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PrincipalValue",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->26228],

Cell["The ordinary Riemann definite integral is divergent:", "ExampleText",
 CellID->20299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "1"}], ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15965],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], ":", 
  " ", "\<\"Integral of \\!\\(1\\/x\\) does not converge on \
\\!\\({\\(\\(-1\\)\\), 2}\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Integrate/idiv\\\", ButtonNote -> \
\\\"Integrate::idiv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->694226962],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"-", "1"}], "2"], 
  RowBox[{
   FractionBox["1", "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{52, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->383326695]
}, Open  ]],

Cell["The Cauchy principal value integral is finite:", "ExampleText",
 CellID->815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "1"}], ",", " ", "2"}], "}"}], ",", " ", 
   RowBox[{"PrincipalValue", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11872],

Cell[BoxData[
 RowBox[{"Log", "[", "2", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6451432]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21204],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], ":", 
  " ", "\<\"Integral of \\!\\(Tan[x]\\) does not converge on \\!\\({0, \[Pi]}\
\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Integrate/idiv\\\", \
ButtonNote -> \\\"Integrate::idiv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->12522084],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "\[Pi]"], 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{83, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->799906160]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"PrincipalValue", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16025],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->221111502]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32691],

Cell[TextData[{
 "Area of a disk with radius ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->878491540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", 
     RowBox[{"r", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"r", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66980954],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", 
  SuperscriptBox["r", "2"]}]], "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67724030]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->122557156],

Cell["Intersection of a disk intersected with a square region:", "ExampleText",
 CellID->13140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "a"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18917],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"1", 
     RowBox[{"a", "\[GreaterEqual]", "2"}]},
    {
     FractionBox[
      RowBox[{"a", " ", "\[Pi]"}], "4"], 
     RowBox[{"0", "<", "a", "\[LessEqual]", "1"}]},
    {
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", "a"}]]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"ArcCsc", "[", 
          SqrtBox["a"], "]"}]}], "-", 
        RowBox[{"a", " ", 
         RowBox[{"ArcTan", "[", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "1"}], "+", "a"}]], "]"}]}]}], ")"}]}], 
     RowBox[{"1", "<", "a", "<", "2"}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{396, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->842550972]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "a"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"3", "/", "2"}], ",", 
       RowBox[{"5", "/", "2"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->113960094],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm21oHEUYx+eyd5ekjRatxVhrja1t7fubfbG1tqbVWLXaVut7bUOqtB9E
qf0kSFAqxVICtsVwbUgIKddGjyREPTlNOTVyviQYjBgaDAYCASNIMHhIIFD/
z+zO7mWSS8+YfW4/GLi73Z1nnt//ZmfmeWYuu6v02OGXXik9dqSstKjkaOlr
h4+UvV704KtHccnwCeHbI4R4uVDg+CqO5Iv+9uIlRC7eD+HSdOuzAJ9l+Myz
S4WhalwVB7Xz/P9YHhxDiUQiojgUCgmjqqoqmUxS0a0TeI3H4+LFFHthfRdV
3tnZKQ7I8v7+fvOSyTPf/ealcDj81be/39/+09/CeOfd2qGhobRcq0Zzc/On
l3/dn1LDJlsW7e3tdfUJ0yJUHevu7haj2/V/tifY6BwWi5O9Tdp988OfNTU1
VDiHnX25tR+DLTvsTz7/JRqNZod9qaEtkUhkh1194QtMSNlhnw191Nvbmx12
+fFzw8PD3Oyt0u7rtj/q6uqo8DZ2dnPsSiwWyw67Ntza0dGRHXbFmQjCLTf7
Pmn3/Y9/YU4dGRkRc9nZzv3mZztzCz/7xKkLg4OD3Owt0u6zL/saGxup8HZ2
tjPG+NlOzsTJvlfawSUcU2ERO9u042ZvVrEEpzS33MHORgVUo0JO9iY1p8IZ
La/msbOdfI2TfY/2veezs53vzcneqNYlmNLpe9/JznbiGCd7gza+F7Cznfyc
k71ey1sWMrLXqTY/WXGR+toidrYTS9xj+/GeQ6cBeepIEHdL+6bozy0tLVR2
11Rp8NsaLLaJNug9z/avyVkrfccTvyGbwmJNLHahRQzNZ04GutaomRi9BEmm
WOIpXe9XRXt6eqjIK7pWSx/hD7/DHxUt9YiuVdpMsyyFYprmXVNZjsYNuqJ0
pVpXQATFguW6DzF6RkmvVbecOo0r1B4e4DRaV1B5QLPOQKXODkxSrX5nclL8
mIqXa4pXjr7/VmsFM1KsW46v1K9p8pmtYthNaVqMUrlMU7lK8zEVo4fa2IdP
0uPLsPWWpvRJ0rXaBV3jt9fE/XCJimGWrjUu6JrM+Fis1kyIrTSG13pE1yKV
XyPdg1exziO6Fqp+f+q9D5CGivUe0bVA+mj4uBNZCUX/DR7RNV/mWchdT1c2
xeNxdLGNHlE2T7UYVnB9fX1ik0d0FckWQ36JHoYWw2SxmU1Z+hx8rrqPWHbW
19cPDAxsmSpVabLwsWuROdIacwJqwitWv1tdaJl0K6HZZBew6ahM8+U2RgWF
UgF6BkzfPlGNyhRJihkVzCK7INYYGDYVZyLoCKiAZtjBqGGmbAXkx1hSlB8/
hyFC/7FQwqhgBtnl4uBSQxvC05tvVSJVx+qG+sNORh3TyC4fPRJeTSnoFShK
JBIITaTmUUY1BtkVIPOiTe/YFdQ8X9uCTgJNuE2gmbKSyeRud1UZtifhf6P8
rMhFSMQJ7hGqdnV1obvQLsq+a6p4Qc43zt7m5HTQ4cEMWc7etZus5+UIsn+b
MHEu8p6TftBFENGoHfUsPt818rNqTwT9ECFrTNRzm+zs0fKRn9F2y/TVinvk
p7X9gAAb+SmthwXZyPvUOgVkyrt1D+6Rn1R9G/M+5a95zGRnR4+P/IT0g7iC
ady2YCHvVetka36exkbeo5Gns5F3a+QCNvLjGvk6NvJj0k9tuNUiX89G3qX8
WP8pMYON/EjKTEKubmAjP6xmT8Rn2k25kY28U/2Kc7LiImUGM9nID0k/OEBa
SuntTWzkEukHKwVrD3IWG/kBdZ8RNLAMEDezkXeo+4z4jHAlCtnI21UeFolE
KDO4hYeM21sMuvRj7enOnpgMw/2yxunKpn9Pts7p+YHttOQyzB+KqWhcrnVO
o/2AtKe2kZdSnzfIkDqZcudZikMi3fMcZGg+9yF8/wDvQAUc\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->73833707]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->169598296],

Cell["Find the volume of a 5-dimensional unit sphere:", "ExampleText",
 CellID->494920001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", "i", "]"}], "^", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "5"}], "}"}]}], "]"}], "<", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "1", "]"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "2", "]"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "3", "]"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "4", "]"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "5", "]"}], ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->564123354],

Cell[BoxData[
 FractionBox[
  RowBox[{"8", " ", 
   SuperscriptBox["\[Pi]", "2"]}], "15"]], "Output",
 ImageSize->{32, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->215053725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->437442330],

Cell["Mean and variance of the normal distribution:", "ExampleText",
 CellID->179079438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}]}], ",", 
   " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", " ", "\[Rule]", 
    RowBox[{"\[Sigma]", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->204391732],

Cell[BoxData["\[Mu]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164116856]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "\[Mu]"}], ")"}], "^", "2"}], 
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}]}], ",", 
   " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"\[Sigma]", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->141500547],

Cell[BoxData[
 SuperscriptBox["\[Sigma]", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->288229222]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->48732478],

Cell["\<\
Average distance from the origin to a random point in the unit square:\
\>", "ExampleText",
 CellID->85303880],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "3"}], ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->155831190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "pts", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12851194],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36462361]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"Map", "[", 
   RowBox[{"Norm", ",", "pts"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->271885685],

Cell[BoxData["0.7517182801148896`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->216684278]
}, Open  ]],

Cell["Compare to the asymptotic result:", "ExampleText",
 CellID->945454037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->659515735],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], "+", 
    RowBox[{"ArcSinh", "[", "1", "]"}]}], ")"}]}]], "Output",
 ImageSize->{139, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->492958374]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->74318623],

Cell[BoxData["0.7651957164642127`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->225810674]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->337381576],

Cell["\<\
Construct Enneper's minimal surface using Weierstrassian integrals:\
\>", "ExampleText",
 CellID->736390212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Integrate", "[", 
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{"x", "^", "2"}]}], ",", " ", "x"}], "]"}], ",", " ", 
       RowBox[{"Integrate", "[", 
        RowBox[{
         RowBox[{"I", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}], ",", 
       RowBox[{"Integrate", "[", " ", 
        RowBox[{
         RowBox[{"2", " ", "x"}], ",", " ", "x"}], "]"}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", " ", 
       RowBox[{"r", " ", 
        RowBox[{"E", "^", 
         RowBox[{"(", 
          RowBox[{"I", " ", "\[Phi]"}], ")"}]}]}]}], "}"}]}], "]"}], ",", " ",
    
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "3"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", " ", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
   RowBox[{"Boxed", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Axes", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"PlotRange", " ", "\[Rule]", " ", "All"}], ",", " ", 
   RowBox[{"Mesh", " ", "\[Rule]", " ", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182388262],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->323702281]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10628],

Cell[TextData[{
 "Evaluate integrals numerically using ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->19981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12153],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{117, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->290928942]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21504],

Cell[BoxData["0.43060610312069103`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24607157]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->54363602],

Cell[BoxData["0.43060610312069103`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->16723865]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20813],

Cell["Assumptions about variables can yield different forms:", "ExampleText",
 CellID->516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"x", "^", "a"}]}], "]"}], ",", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21628],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"x", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["x", "a"], ")"}], 
     RowBox[{
      RowBox[{"-", "1"}], "/", "a"}]], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["1", "a"], ",", 
      SuperscriptBox["x", "a"]}], "]"}]}], "a"]}]], "Output",
 ImageSize->{159, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->476971334]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"%", ",", 
   RowBox[{"a", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16106],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"x", " ", 
    RowBox[{"ExpIntegralE", "[", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "a"}], "a"], ",", 
      SuperscriptBox["x", "a"]}], "]"}]}], "a"]}]], "Output",
 ImageSize->{172, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75924197]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70580569],

Cell["Solve a simple differential equation:", "ExampleText",
 CellID->689119942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27595663],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Cos", "[", "x", "]"}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35400196]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", "y", ",", " ", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->105143827],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "-", 
       RowBox[{"Cos", "[", "x", "]"}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{240, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195863157]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17254],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Derivative",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"]], "InlineFormula"],
 " with a negative integer order does integrals:"
}], "ExampleText",
 CellID->11251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Derivative", "[", 
   RowBox[{"-", "2"}], "]"}], "[", 
  RowBox[{"Function", "[", 
   RowBox[{"x", ",", 
    RowBox[{"x", "^", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17887],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"2", "+", "n"}]], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "n"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "n"}], ")"}]}]]}], "]"}]], "Output",
 ImageSize->{181, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62441421]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22897],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"2", "+", "n"}]], 
  RowBox[{"2", "+", 
   RowBox[{"3", " ", "n"}], "+", 
   SuperscriptBox["n", "2"]}]]], "Output",
 ImageSize->{70, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73671868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22536],

Cell["Laplace transform of an integral:", "ExampleText",
 CellID->27340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"f", "[", "u", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", "t"}], "}"}]}], "]"}], ",", "t", ",", "s"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10226],

Cell[BoxData[
 FractionBox[
  RowBox[{"LaplaceTransform", "[", 
   RowBox[{
    RowBox[{"f", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}], "s"]], "Output",\

 ImageSize->{199, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149406143]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10000],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Indefinite Integrals",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->16604],

Cell["\<\
Many simple integrals cannot be evaluated in terms of standard mathematical \
functions:\
\>", "ExampleText",
 CellID->12426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "/", 
    RowBox[{"Log", "[", "x", "]"}]}], ",", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15225],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Log", "[", "x", "]"}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{81, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->269517055]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7964],

Cell["Simple-looking integrals can give complicated results:", "ExampleText",
 CellID->8198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Cos", "[", 
     RowBox[{"x", "^", "2"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21916],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", "x"}], "]"}]}], "-", 
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}]}], "]"}]}], "+", 
    RowBox[{
     SqrtBox[
      RowBox[{"2", " ", "\[Pi]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Cos", "[", 
          FractionBox["1", "4"], "]"}]}], " ", 
        RowBox[{"FresnelS", "[", 
         FractionBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "x"}]}], 
          SqrtBox[
           RowBox[{"2", " ", "\[Pi]"}]]], "]"}]}], "+", 
       RowBox[{
        RowBox[{"FresnelC", "[", 
         FractionBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           RowBox[{"2", " ", "x"}]}], 
          SqrtBox[
           RowBox[{"2", " ", "\[Pi]"}]]], "]"}], " ", 
        RowBox[{"Sin", "[", 
         FractionBox["1", "4"], "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     SqrtBox[
      RowBox[{"2", " ", "\[Pi]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Cos", "[", 
          FractionBox["1", "4"], "]"}]}], " ", 
        RowBox[{"FresnelS", "[", 
         FractionBox[
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "x"}]}], 
          SqrtBox[
           RowBox[{"2", " ", "\[Pi]"}]]], "]"}]}], "+", 
       RowBox[{
        RowBox[{"FresnelC", "[", 
         FractionBox[
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "x"}]}], 
          SqrtBox[
           RowBox[{"2", " ", "\[Pi]"}]]], "]"}], " ", 
        RowBox[{"Sin", "[", 
         FractionBox["1", "4"], "]"}]}]}], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{443, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->440346232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5124],

Cell["\<\
The derivative of an integral may not come out in the same form as the \
original function:\
\>", "ExampleText",
 CellID->4056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"x", "^", "2"}]}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30422],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}]}]], "Output",
 ImageSize->{184, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->604288938]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31854],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}]}]]}], "+", 
  FractionBox["1", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]]}]], "Output",
 ImageSize->{142, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14233035]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7979],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "-", 
   SuperscriptBox["x", "2"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->173996764]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25021],

Cell["\<\
Different forms of the same integrand can give integrals that differ by \
constants of integration:\
\>", "ExampleText",
 CellID->31145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], "^", "3"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23787],

Cell[BoxData[
 RowBox[{"x", "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "4"]}]}]], "Output",
 ImageSize->{84, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233279471]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Expand", "[", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "1"}], ")"}], "^", "3"}]}], "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5195],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x"}], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["x", "2"]}], "2"], "+", 
  SuperscriptBox["x", "3"], "+", 
  FractionBox[
   SuperscriptBox["x", "4"], "4"]}]], "Output",
 ImageSize->{115, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->295415402]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%%", "-", "%"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4580],

Cell[BoxData[
 FractionBox["1", "4"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->140994168]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2013],

Cell["\<\
Results for integrals can depend on the way parameters appear in an \
integrand:\
\>", "ExampleText",
 CellID->9370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", " ", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "/", "a"}]}], ")"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28836],

Cell[BoxData[
 RowBox[{
  SqrtBox["a"], " ", 
  RowBox[{"ArcTan", "[", 
   FractionBox["x", 
    SqrtBox["a"]], "]"}]}]], "Output",
 ImageSize->{115, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139814892]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", " ", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "/", "b"}]}], ")"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10536],

Cell[BoxData[
 RowBox[{
  SqrtBox["b"], " ", 
  RowBox[{"ArcTanh", "[", 
   FractionBox["x", 
    SqrtBox["b"]], "]"}]}]], "Output",
 ImageSize->{122, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->288518799]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7717],

Cell["\<\
The indefinite integral of a continuous function can be discontinuous:\
\>", "ExampleText",
 CellID->10625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}], ",", "x"}], "]"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11412],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->330705038]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5808],

Cell[TextData[{
 "Parameters like ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " are assumed to be generic inside indefinite integrals:"
}], "ExampleText",
 CellID->29727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14911],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"1", "+", "n"}]], 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280157444]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"-", "1"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23035],

Cell[BoxData[
 RowBox[{"Log", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->318833784]
}, Open  ]],

Cell["In definite integration conditions are generated: ", "ExampleText",
 CellID->261008711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->466106225],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "n", "]"}], ">", 
    RowBox[{"-", "1"}]}], ",", 
   FractionBox["1", 
    RowBox[{"1", "+", "n"}]], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     SuperscriptBox["x", "n"], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "n", "]"}], "\[LessEqual]", 
       RowBox[{"-", "1"}]}]}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{475, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->265376368]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->549388233],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"idiv\"\>"}], ":", 
  " ", "\<\"Integral of \\!\\(1\\/x\\) does not converge on \\!\\({0, 1}\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Integrate/idiv\\\", \
ButtonNote -> \\\"Integrate::idiv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->579019971],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   FractionBox["1", "x"], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{51, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->458020194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6981],

Cell["\<\
The integration variable cannot itself be a mathematical function:\
\>", "ExampleText",
 CellID->30209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], ",", 
   RowBox[{"Sin", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8853],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"ivar\"\>"}], ":", 
  " ", "\<\"\\!\\(Sin[x]\\) is not a valid variable. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ivar\\\", ButtonNote -> \
\\\"Integrate::ivar\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->49238446],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"Sin", "[", "x", "]"}]}]}]}]], "Output",
 ImageSize->{112, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87964048]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19352],

Cell["\<\
When part of a sum cannot be integrated explicitly, the whole sum will stay \
unintegrated:\
\>", "ExampleText",
 CellID->11395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "x", "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21003],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "+", 
     RowBox[{
      SuperscriptBox["f", "\[Prime]",
       MultilineFunction->None], "[", "x", "]"}]}], ")"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{121, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->641965545]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Definite Integrals",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->11266],

Cell["\<\
Substituting limits into an indefinite integral may not give the correct \
result for a definite integral:\
\>", "ExampleText",
 CellID->20268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"2", "+", 
      RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21924],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Pi]"}], 
  SqrtBox["3"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253289812]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"Cos", "[", "x", "]"}]}], ")"}]}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12385],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"Tan", "[", 
      FractionBox["x", "2"], "]"}], 
     SqrtBox["3"]], "]"}]}], 
  SqrtBox["3"]]], "Output",
 ImageSize->{112, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->232997201]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"expr", "/.", 
    RowBox[{"x", "->", 
     RowBox[{"2", "Pi"}]}]}], ")"}], "-", 
  RowBox[{"(", 
   RowBox[{"expr", "/.", 
    RowBox[{"x", "->", "0"}]}], ")"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28127],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->176313130]
}, Open  ]],

Cell["\<\
The presence of a discontinuity in the expression for the indefinite integral \
leads to the anomaly:\
\>", "ExampleText",
 CellID->22329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1826],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWU1sVFUUvp2Z96aFUmxLy1QUChUQEUH8AUUoCrRCRURtXBgXtTFpYxSD
daMb3ehGN7qRjSxUEpUFxgRjggmRxEhiJDGSGDUxmBhcSEwkLpqYjN855943
b87c9+ZOnUQn/XnnvXu+c9655/fOwam5maeemZqbnZ4aHj869dzM7PTzw2NH
juJWscMYcxa/T1cMrqu44t/l1WrVFOmKP+YE/TFhdw8x/cbr585/9QtdPpqs
KmDRQ/z0yLOfPDZ54sI3v6aeNmCUsOrcFz/j748//P5II0qEJ4C4enVelpiH
s7FiWYtLLJ9+8uTly38ezl5dTlbjg6WzM6euXPlLpJoy/hJDIcVpiMZvrN9S
UOxa6IhbUECkmE4lO1Z00WvZGmpRoT4omhStQlYnjdKqlJKScjBYdyI1WqTQ
HvCilawdNapGixXaRCZamo6aoJYV6oFk30kn9z/K2OtOxb0/289SXF2OC74G
jzP3B3EtYvrSpT9wi7jGEy6fZouZxjobL2NBMrpTXBe/+83sy5WxhGmJSQSv
2Rsko4fp+fm/X3rxs49PXTR7griuIR2QaJjTrhlN9krHKF3mxWgv05D+wtxp
2rfdXl/iaCnVaNPUm/qYBoG0Q1YXDZtFaety+t0+wYM+P/OT2dWC/r5IXcYr
YdlXXj4DI+PinjZZZNBZGrfgu2ZHm3DFX+CjsMCnp783dye+kN73rP2vsDzs
/GuvnsUPLrYHeeG1TEPeE49/gJJntgVxrWBpqCrwNkjDxR0Jn0+761NSKEJu
D5Ky0r0TNhBGgWm25koZ5vViQbBAqy1Bcta4HYV2H334rdkcxDXitHvrzS/R
DiBdbKrbsXRMNKuwaxkL3o8MInc3Mlfc4EVln5/laLmeEUDgltzdUPVFsLhn
SlDLkjY0SFrfwjv4YnhjPSLcc20GoqtmzSruJocIv0VCg0OO5CDmVd0BqzNl
A2JcbumiktifwccikVARPXCe99+7AEfqs2/RXedHumJrvxxUfsYRHSXPRRXJ
hykuzhedCQ3XO/b2+cOH3oU+SGpLG+zB1TdXdjXJYTV6yKtLn7XZkFrN9S5G
qpZEIXkQZPcCtal4nhc8e9Trs6De+wh5BcaBiRDv1K0sytHKt09aG34eJ3Ri
nn7LX7H/WU4M90BqgqvAc1EfYRXXJXQH2WKgQVu/n6Slp/lZSoQQRD2FDZBe
qZvS8VZvgcFq/ZtUqmEx4vh73JsjNcMZpHYgq7v+2u8FOua5E4rg1NAZmkN/
6i+WBvFyJxdhfd1b1yzuy+XcYcZQU7TGlh1/52s4TFeQRO6cYywHE1gBABiY
IA7innCeCk0n9h9HNaF35QmCM8BJzveMUsYFjCLFCwggqW/0dnI6Rlug/2v+
gnvXqvtYR8dHT1b/93dpB39HzQO60laBSZDd4DM2PnoVr/a8rOw1EMKXomtR
4WqcizfoYuONJ72Ul/tPXThC6rIFqirCcE8QN+sRIyCkDCZZdncmN+nL82Jd
VqSJYFeQxHR2g7KS3SBxR65Ensdq2cxKvCtIIufZKJGI5bTT24J4uZ5EWCJv
KqaVPr6Bt7Oa3QG7LkY6A2AkbQdNl1u9eNwv5naQ2tNlPkH3gCZPRvktbULm
SYY6SORWgAP5ln+BTOQqXom3TxBvDkR0ttS96eoGxJtaQMw7exqpRwbajbke
4HpXV7HXOX4wIMRwsS7I+2SKQZxBqEx2NwTxyUwi7g6XRXStyeQj/WTiQITA
K+X9VgfJ4R0ryUmWTN+rcuXwhEnzMGovzforg6RsdtpBBKwHK1wXxHcr07Ae
rECnWisy9yzr1Ml52m1OA+y/nKoMebG6FEbjaYj2LMkk2CmYnTJapU24fC5B
Z4wy7lnbLAyXFtzJT/Di2AOxwECbNN3uLGDPUJe1CVdqA0INFqBq2p+5++kT
CrfjUo3kRJTs1xfkccIlVkIo2W6iGddOphGn4AKv9OiZMTRatTEEX6TOtSdI
hnAhFuz59pJcGfc629kT6u4gGZprcRDXfUzLSXUyXwZFqa6texVSV5An6VlO
5wGN2tkW1H0KtbxgVCLHFFochOaqk65+4wotCkbLo3nCo4yEOCcPLGXus6+C
Hkj5Vm1ea+ZbmqsQxMXTZCzf6sh3FMIxmawmjfgbNeqBEYdYZcerSS8iry2h
BiXnnPVYMs8ipkd3HstGkVUyF2drn/etr+n4B3lcO1I=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{192, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{192., Automatic}},
 CellLabel->"Out[4]=",
 CellID->357073566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23539],

Cell[TextData[{
 "Expanding ",
 Cell[BoxData[
  ButtonBox["RootSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootSum"]], "InlineFormula"],
 " objects from integrals may give large results:"
}], "ExampleText",
 CellID->26077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "+", "x", "+", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23182],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", "#1", "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"-", "#1"}], "]"}], 
      RowBox[{"1", "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}]}]], "&"}]}], "]"}]}]], "Output",
 ImageSize->{234, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83675827]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32120],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"Log", "[", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["2", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "9"}], "+", 
            SqrtBox["93"]}], ")"}]}]], ")"}], 
       RowBox[{"1", "/", "3"}]], "-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "9"}], "+", 
            SqrtBox["93"]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]], 
       SuperscriptBox["3", 
        RowBox[{"2", "/", "3"}]]]}], "]"}], 
    RowBox[{"1", "+", 
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox["2", 
             RowBox[{"3", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "9"}], "+", 
                SqrtBox["93"]}], ")"}]}]], ")"}], 
           RowBox[{"1", "/", "3"}]]}], "+", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               SqrtBox["93"]}], ")"}]}], ")"}], 
           RowBox[{"1", "/", "3"}]], 
          SuperscriptBox["3", 
           RowBox[{"2", "/", "3"}]]]}], ")"}], "2"]}]}]]}], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "9"}], "+", 
            SqrtBox["93"]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["3", 
        RowBox[{"2", "/", "3"}]]}]], "-", 
     FractionBox[
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"2", "/", "3"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "9"}], "+", 
            SqrtBox["93"]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}]]}], "]"}], 
   RowBox[{"1", "+", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              SqrtBox["3"]}]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "9"}], "+", 
                SqrtBox["93"]}], ")"}]}], ")"}], 
            RowBox[{"1", "/", "3"}]]}], 
          RowBox[{"2", " ", 
           SuperscriptBox["3", 
            RowBox[{"2", "/", "3"}]]}]]}], "+", 
        FractionBox[
         RowBox[{"1", "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], 
         RowBox[{
          SuperscriptBox["2", 
           RowBox[{"2", "/", "3"}]], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               SqrtBox["93"]}], ")"}]}], ")"}], 
           RowBox[{"1", "/", "3"}]]}]]}], ")"}], "2"]}]}]], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "9"}], "+", 
            SqrtBox["93"]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["3", 
        RowBox[{"2", "/", "3"}]]}]], "-", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"2", "/", "3"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "9"}], "+", 
            SqrtBox["93"]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}]]}], "]"}], 
   RowBox[{"1", "+", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"\[ImaginaryI]", " ", 
              SqrtBox["3"]}]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              FractionBox["1", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "9"}], "+", 
                SqrtBox["93"]}], ")"}]}], ")"}], 
            RowBox[{"1", "/", "3"}]]}], 
          RowBox[{"2", " ", 
           SuperscriptBox["3", 
            RowBox[{"2", "/", "3"}]]}]]}], "+", 
        FractionBox[
         RowBox[{"1", "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], 
         RowBox[{
          SuperscriptBox["2", 
           RowBox[{"2", "/", "3"}]], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "9"}], "+", 
               SqrtBox["93"]}], ")"}]}], ")"}], 
           RowBox[{"1", "/", "3"}]]}]]}], ")"}], "2"]}]}]]}]], "Output",
 ImageSize->{344, 316},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->91084184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->320842613],

Cell["\<\
A definite integral may have a closed form only over an infinite interval:\
\>", "ExampleText",
 CellID->172815536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BesselJ", "[", 
     RowBox[{"2", ",", "x"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"x", "^", "2"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->599128460],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   FractionBox[
    RowBox[{"BesselJ", "[", 
     RowBox[{"2", ",", "x"}], "]"}], 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}]], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{133, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16773136]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"BesselJ", "[", 
     RowBox[{"2", ",", "x"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"x", "^", "2"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->533620],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{"2", "-", 
    RowBox[{"3", " ", "\[Pi]", " ", 
     RowBox[{"BesselI", "[", 
      RowBox[{"2", ",", "1"}], "]"}]}], "+", 
    RowBox[{"3", " ", "\[Pi]", " ", 
     RowBox[{"StruveL", "[", 
      RowBox[{"2", ",", "1"}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{283, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->244012747]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5393],

Cell[TextData[{
 "With too many components in a piecewise integral, ",
 Cell[BoxData[
  ButtonBox["$MaxPiecewiseCases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPiecewiseCases"]], "InlineFormula"],
 " may have to be increased:"
}], "ExampleText",
 CellID->21556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2660],

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "::", "\<\"mpwc\"\>"}], ":", 
  " ", "\<\"\\!\\(Integrate\\) was unable to convert \
\\!\\(Floor[\\(\\(x\\^2\\)\\)]\\) to Piecewise, because the required number \
\\!\\(101\\) of piecewise cases sought exceeds the internal limit \
$MaxPiecewiseCases = \\!\\(100\\).\"\>"}]], "Message", "MSG",
 CellID->95904279],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "10"], 
  RowBox[{
   RowBox[{"Floor", "[", 
    SuperscriptBox["x", "2"], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{107, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191740649]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxPiecewiseCases", "=", "Infinity"}], "}"}], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Floor", "[", 
      RowBox[{"x", "^", "2"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3340],

Cell[BoxData[
 RowBox[{"945", "-", 
  RowBox[{"28", " ", 
   SqrtBox["2"]}], "-", 
  RowBox[{"15", " ", 
   SqrtBox["3"]}], "-", 
  RowBox[{"10", " ", 
   SqrtBox["5"]}], "-", 
  RowBox[{"10", " ", 
   SqrtBox["6"]}], "-", 
  RowBox[{"6", " ", 
   SqrtBox["7"]}], "-", 
  RowBox[{"6", " ", 
   SqrtBox["10"]}], "-", 
  RowBox[{"6", " ", 
   SqrtBox["11"]}], "-", 
  RowBox[{"3", " ", 
   SqrtBox["13"]}], "-", 
  RowBox[{"3", " ", 
   SqrtBox["14"]}], "-", 
  RowBox[{"3", " ", 
   SqrtBox["15"]}], "-", 
  RowBox[{"3", " ", 
   SqrtBox["17"]}], "-", 
  RowBox[{"3", " ", 
   SqrtBox["19"]}], "-", 
  RowBox[{"3", " ", 
   SqrtBox["21"]}], "-", 
  RowBox[{"3", " ", 
   SqrtBox["22"]}], "-", 
  RowBox[{"3", " ", 
   SqrtBox["23"]}], "-", 
  SqrtBox["26"], "-", 
  SqrtBox["29"], "-", 
  SqrtBox["30"], "-", 
  SqrtBox["31"], "-", 
  SqrtBox["33"], "-", 
  SqrtBox["34"], "-", 
  SqrtBox["35"], "-", 
  SqrtBox["37"], "-", 
  SqrtBox["38"], "-", 
  SqrtBox["39"], "-", 
  SqrtBox["41"], "-", 
  SqrtBox["42"], "-", 
  SqrtBox["43"], "-", 
  SqrtBox["46"], "-", 
  SqrtBox["47"], "-", 
  SqrtBox["51"], "-", 
  SqrtBox["53"], "-", 
  SqrtBox["55"], "-", 
  SqrtBox["57"], "-", 
  SqrtBox["58"], "-", 
  SqrtBox["59"], "-", 
  SqrtBox["61"], "-", 
  SqrtBox["62"], "-", 
  SqrtBox["65"], "-", 
  SqrtBox["66"], "-", 
  SqrtBox["67"], "-", 
  SqrtBox["69"], "-", 
  SqrtBox["70"], "-", 
  SqrtBox["71"], "-", 
  SqrtBox["73"], "-", 
  SqrtBox["74"], "-", 
  SqrtBox["77"], "-", 
  SqrtBox["78"], "-", 
  SqrtBox["79"], "-", 
  SqrtBox["82"], "-", 
  SqrtBox["83"], "-", 
  SqrtBox["85"], "-", 
  SqrtBox["86"], "-", 
  SqrtBox["87"], "-", 
  SqrtBox["89"], "-", 
  SqrtBox["91"], "-", 
  SqrtBox["93"], "-", 
  SqrtBox["94"], "-", 
  SqrtBox["95"], "-", 
  SqrtBox["97"]}]], "Output",
 ImageSize->{487, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->77064903]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->294],

Cell["Borwein-type integral:", "ExampleText",
 CellID->476934249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Product", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"x", "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "k"}], "+", "1"}], ")"}]}], "]"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "8"}], "}"}]}], "]"}], "/", 
    RowBox[{"x", "^", "9"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", "Infinity"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->524766775],

Cell[BoxData[
 FractionBox[
  RowBox[{"17708695183056190642497315530628422295569865119", " ", "\[Pi]"}], 
  "1220462921565155916674902677397230198502690752000000000"]], "Output",
 ImageSize->{432, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->498927851]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->732632213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "27"}], " ", 
    RowBox[{"ProductLog", "[", 
     RowBox[{"x", "^", "4"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->366309465],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["x", "28"], " ", 
    RowBox[{"(", 
     RowBox[{"720", "-", 
      RowBox[{"5040", " ", 
       RowBox[{"ProductLog", "[", 
        SuperscriptBox["x", "4"], "]"}]}], "+", 
      RowBox[{"17640", " ", 
       SuperscriptBox[
        RowBox[{"ProductLog", "[", 
         SuperscriptBox["x", "4"], "]"}], "2"]}], "-", 
      RowBox[{"41160", " ", 
       SuperscriptBox[
        RowBox[{"ProductLog", "[", 
         SuperscriptBox["x", "4"], "]"}], "3"]}], "+", 
      RowBox[{"72030", " ", 
       SuperscriptBox[
        RowBox[{"ProductLog", "[", 
         SuperscriptBox["x", "4"], "]"}], "4"]}], "-", 
      RowBox[{"100842", " ", 
       SuperscriptBox[
        RowBox[{"ProductLog", "[", 
         SuperscriptBox["x", "4"], "]"}], "5"]}], "+", 
      RowBox[{"117649", " ", 
       SuperscriptBox[
        RowBox[{"ProductLog", "[", 
         SuperscriptBox["x", "4"], "]"}], "6"]}], "-", 
      RowBox[{"117649", " ", 
       SuperscriptBox[
        RowBox[{"ProductLog", "[", 
         SuperscriptBox["x", "4"], "]"}], "7"]}], "+", 
      RowBox[{"823543", " ", 
       SuperscriptBox[
        RowBox[{"ProductLog", "[", 
         SuperscriptBox["x", "4"], "]"}], "8"]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"23059204", " ", 
    SuperscriptBox[
     RowBox[{"ProductLog", "[", 
      SuperscriptBox["x", "4"], "]"}], "7"]}], ")"}]}]], "Output",
 ImageSize->{558, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51711495]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34908262],

Cell["A logarithmic integral from Srinivasa Ramanujan's notebooks:", \
"ExampleText",
 CellID->117559170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"1", "+", 
          RowBox[{"4", "x"}]}], "]"}]}], ")"}], "/", "2"}], "]"}], "/", "x"}],
    ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->796220854],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "2"], "15"]], "Output",
 ImageSize->{23, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->511315002]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88974309],

Cell["Nested piecewise integrals:", "ExampleText",
 CellID->220590268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Ceiling", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"Floor", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187837411],

Cell[BoxData[
 RowBox[{"125", "-", 
  RowBox[{"6", " ", 
   SqrtBox["2"]}], "-", 
  RowBox[{"3", " ", 
   SqrtBox["3"]}], "-", 
  RowBox[{"3", " ", 
   SqrtBox["5"]}], "-", 
  RowBox[{"3", " ", 
   SqrtBox["6"]}], "-", 
  SqrtBox["7"], "-", 
  SqrtBox["10"], "-", 
  SqrtBox["11"], "-", 
  SqrtBox["13"], "-", 
  SqrtBox["14"], "-", 
  SqrtBox["15"], "-", 
  SqrtBox["17"], "-", 
  SqrtBox["19"], "-", 
  SqrtBox["21"], "-", 
  SqrtBox["22"], "-", 
  SqrtBox["23"]}]], "Output",
 ImageSize->{390, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266554654]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24742],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LaplaceTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LaplaceTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Derivative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Derivative"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpectedValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpectedValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Normalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normalize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26215]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28415],

Cell[TextData[ButtonBox["Symbolic Mathematics: Basic Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematics-BasicOperations"]], "Tutorials",
 CellID->82228336],

Cell[TextData[ButtonBox["Simplifying Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SimplifyingAlgebraicExpressions"]], "Tutorials",\

 CellID->15492],

Cell[TextData[ButtonBox["Integration",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Integration"]], "Tutorials",
 CellID->10238],

Cell[TextData[ButtonBox["Indefinite Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IndefiniteIntegrals"]], "Tutorials",
 CellID->26529],

Cell[TextData[ButtonBox["Integrals over Regions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntegralsOverRegions"]], "Tutorials",
 CellID->51756815]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->26610],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#11173"], None}]], "RelatedLinks",
 CellID->6405]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->429565224],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "MoreAbout",
 CellID->232532573],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "MoreAbout",
 CellID->491084449],

Cell[TextData[ButtonBox["Generalized Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeneralizedFunctions"]], "MoreAbout",
 CellID->131003489],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "MoreAbout",
 CellID->670045886],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "MoreAbout",
 CellID->79069591],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->334197213],

Cell[TextData[ButtonBox["Rational Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RationalFunctions"]], "MoreAbout",
 CellID->11898685],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "MoreAbout",
 CellID->694029225]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integrate (\[Integral]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 17.1655984}", "context" -> "System`", 
    "keywords" -> {
     "anti-derivative", "area", "areas", "calculus", "differential equations",
       "Dwight's tables", "Gradshteyn-Ryzhik", "integration", 
      "integration over regions", "Marichev-Adamchik methods", "measures", 
      "Mellin transform methods", "mensuration", "multiple integrals", 
      "region integrals", "Risch algorithm", "Slater's Theorem", 
      "surface integrals", "volume integrals", "volumes"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Integrate[f, x] gives the indefinite integral \\[Integral]f d x. \
Integrate[f, {x, x_min, x_max}] gives the definite integral \
SubsuperscriptBox[\\[Integral], x_min, x_max]\\ f\\ d x. Integrate[f, {x, \
x_min, x_max}, {y, y_min, y_max}, ...] gives the multiple integral \
SubsuperscriptBox[\\[Integral], x_min, x_max]d x \
SubsuperscriptBox[\\[Integral], y_min, y_max]dy\\ \\ ...\\ f. ", 
    "synonyms" -> {}, "title" -> "Integrate", "type" -> "Symbol", "uri" -> 
    "ref/Integrate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[19841, 578, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->283678441]},
 "S3.5.9"->{
  Cell[79262, 2938, 542, 19, 70, "Input",
   CellTags->"S3.5.9",
   CellID->4119],
  Cell[79807, 2959, 348, 13, 70, "Output",
   CellTags->"S3.5.9",
   CellID->84572356],
  Cell[96342, 3361, 352, 12, 70, "Input",
   CellTags->"S3.5.9",
   CellID->15021],
  Cell[96697, 3375, 938, 20, 70, "Output",
   Evaluatable->False,
   CellTags->"S3.5.9",
   CellID->27179733]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 220729, 7307},
 {"S3.5.9", 220863, 7311}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4335, 88, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4958, 115, 4270, 86, 70, "ObjectNameGrid"],
Cell[9231, 203, 3063, 99, 70, "Usage",
 CellID->14481]
}, Open  ]],
Cell[CellGroupData[{
Cell[12331, 307, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[12809, 324, 558, 21, 70, "Notes",
 CellID->14036],
Cell[13370, 347, 382, 12, 70, "Notes",
 CellID->24837],
Cell[13755, 361, 459, 14, 70, "Notes",
 CellID->32118],
Cell[14217, 377, 812, 31, 70, "Notes",
 CellID->31049],
Cell[15032, 410, 306, 9, 70, "Notes",
 CellID->27593],
Cell[15341, 421, 413, 10, 70, "Notes",
 CellID->5645],
Cell[15757, 433, 223, 7, 70, "Notes",
 CellID->14053],
Cell[15983, 442, 241, 7, 70, "Notes",
 CellID->18086],
Cell[16227, 451, 331, 12, 70, "Notes",
 CellID->3322],
Cell[16561, 465, 265, 8, 70, "Notes",
 CellID->13287],
Cell[16829, 475, 272, 8, 70, "Notes",
 CellID->334],
Cell[17104, 485, 277, 9, 70, "Notes",
 CellID->703],
Cell[17384, 496, 93, 1, 70, "Notes",
 CellID->28908],
Cell[17480, 499, 1338, 35, 70, "3ColumnTableMod",
 CellID->149],
Cell[18821, 536, 286, 8, 70, "Notes",
 CellID->28160],
Cell[19110, 546, 694, 27, 70, "Notes",
 CellID->4028]
}, Closed]],
Cell[CellGroupData[{
Cell[19841, 578, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->283678441],
Cell[CellGroupData[{
Cell[20226, 592, 148, 5, 70, "ExampleSection",
 CellID->778583290],
Cell[20377, 599, 59, 1, 70, "ExampleText",
 CellID->31313],
Cell[CellGroupData[{
Cell[20461, 604, 229, 9, 28, "Input",
 CellID->29742],
Cell[20693, 615, 611, 23, 72, "Output",
 CellID->262938641]
}, Open  ]],
Cell[21319, 641, 121, 3, 70, "ExampleDelimiter",
 CellID->10681],
Cell[21443, 646, 57, 1, 70, "ExampleText",
 CellID->11901],
Cell[CellGroupData[{
Cell[21525, 651, 284, 10, 70, "Input",
 CellID->7671],
Cell[21812, 663, 336, 12, 51, "Output",
 CellID->61363406]
}, Open  ]],
Cell[22163, 678, 121, 3, 70, "ExampleDelimiter",
 CellID->13281],
Cell[22287, 683, 436, 15, 70, "ExampleText",
 CellID->17338],
Cell[CellGroupData[{
Cell[22748, 702, 235, 8, 70, "Input",
 CellID->9575],
Cell[22986, 712, 679, 27, 53, "Output",
 CellID->227605315]
}, Open  ]],
Cell[CellGroupData[{
Cell[23702, 744, 107, 3, 70, "Input",
 CellID->21553],
Cell[23812, 749, 726, 28, 68, "Output",
 CellID->300119610]
}, Open  ]],
Cell[24553, 780, 121, 3, 70, "ExampleDelimiter",
 CellID->27030],
Cell[24677, 785, 313, 11, 70, "ExampleText",
 CellID->21935],
Cell[CellGroupData[{
Cell[25015, 800, 305, 10, 70, "Input",
 CellID->1825],
Cell[25323, 812, 334, 12, 51, "Output",
 CellID->63627750]
}, Open  ]],
Cell[25672, 827, 120, 3, 70, "ExampleDelimiter",
 CellID->5205],
Cell[25795, 832, 190, 6, 70, "ExampleText",
 CellID->5853],
Cell[CellGroupData[{
Cell[26010, 842, 308, 10, 70, "Input",
 CellID->23449],
Cell[26321, 854, 298, 10, 51, "Output",
 CellID->262124086]
}, Open  ]],
Cell[CellGroupData[{
Cell[26656, 869, 338, 11, 70, "Input",
 CellID->30573],
Cell[26997, 882, 296, 10, 51, "Output",
 CellID->2737135]
}, Open  ]],
Cell[27308, 895, 121, 3, 70, "ExampleDelimiter",
 CellID->23126],
Cell[27432, 900, 118, 3, 70, "ExampleText",
 CellID->1513],
Cell[CellGroupData[{
Cell[27575, 907, 331, 12, 70, "Input",
 CellID->20264],
Cell[27909, 921, 744, 25, 60, "Output",
 CellID->361791641]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28702, 952, 216, 7, 70, "ExampleSection",
 CellID->6433],
Cell[CellGroupData[{
Cell[28943, 963, 236, 7, 70, "ExampleSubsection",
 CellID->3603],
Cell[29182, 972, 99, 2, 70, "ExampleText",
 CellID->7681],
Cell[CellGroupData[{
Cell[29306, 978, 229, 9, 70, "Input",
 CellID->30170],
Cell[29538, 989, 489, 18, 51, "Output",
 CellID->795242670]
}, Open  ]],
Cell[30042, 1010, 209, 8, 70, "ExampleText",
 CellID->5633],
Cell[CellGroupData[{
Cell[30276, 1022, 258, 9, 70, "Input",
 CellID->18835],
Cell[30537, 1033, 509, 18, 53, "Output",
 CellID->40900940]
}, Open  ]],
Cell[31061, 1054, 121, 3, 70, "ExampleDelimiter",
 CellID->21014],
Cell[31185, 1059, 98, 2, 70, "ExampleText",
 CellID->595],
Cell[CellGroupData[{
Cell[31308, 1065, 235, 8, 70, "Input",
 CellID->10848],
Cell[31546, 1075, 473, 18, 51, "Output",
 CellID->292740078]
}, Open  ]],
Cell[CellGroupData[{
Cell[32056, 1098, 299, 10, 70, "Input",
 CellID->24259],
Cell[32358, 1110, 1335, 47, 190, "Output",
 CellID->94687706]
}, Open  ]],
Cell[33708, 1160, 121, 3, 70, "ExampleDelimiter",
 CellID->21164],
Cell[33832, 1165, 109, 3, 70, "ExampleText",
 CellID->22027],
Cell[CellGroupData[{
Cell[33966, 1172, 187, 6, 70, "Input",
 CellID->15907],
Cell[34156, 1180, 304, 10, 36, "Output",
 CellID->30597652]
}, Open  ]],
Cell[CellGroupData[{
Cell[34497, 1195, 201, 7, 70, "Input",
 CellID->15426],
Cell[34701, 1204, 256, 9, 51, "Output",
 CellID->66840874]
}, Open  ]],
Cell[CellGroupData[{
Cell[34994, 1218, 186, 6, 70, "Input",
 CellID->6769],
Cell[35183, 1226, 1252, 39, 71, "Output",
 CellID->539441456]
}, Open  ]],
Cell[CellGroupData[{
Cell[36472, 1270, 236, 9, 70, "Input",
 CellID->22118],
Cell[36711, 1281, 707, 24, 51, "Output",
 CellID->179951263]
}, Open  ]],
Cell[CellGroupData[{
Cell[37455, 1310, 255, 9, 70, "Input",
 CellID->26935],
Cell[37713, 1321, 705, 25, 51, "Output",
 CellID->55562468]
}, Open  ]],
Cell[CellGroupData[{
Cell[38455, 1351, 180, 6, 70, "Input",
 CellID->12298],
Cell[38638, 1359, 611, 21, 59, "Output",
 CellID->210564165]
}, Open  ]],
Cell[CellGroupData[{
Cell[39286, 1385, 200, 7, 70, "Input",
 CellID->1823],
Cell[39489, 1394, 471, 17, 59, "Output",
 CellID->55097019]
}, Open  ]],
Cell[39975, 1414, 120, 3, 70, "ExampleDelimiter",
 CellID->4677],
Cell[40098, 1419, 67, 1, 70, "ExampleText",
 CellID->32300],
Cell[CellGroupData[{
Cell[40190, 1424, 184, 6, 70, "Input",
 CellID->17925],
Cell[40377, 1432, 455, 16, 54, "Output",
 CellID->16528732]
}, Open  ]],
Cell[CellGroupData[{
Cell[40869, 1453, 237, 8, 70, "Input",
 CellID->7936],
Cell[41109, 1463, 976, 35, 51, "Output",
 CellID->531978575]
}, Open  ]],
Cell[CellGroupData[{
Cell[42122, 1503, 157, 5, 70, "Input",
 CellID->8528],
Cell[42282, 1510, 1700, 53, 117, "Output",
 CellID->320853121]
}, Open  ]],
Cell[CellGroupData[{
Cell[44019, 1568, 246, 8, 70, "Input",
 CellID->286494465],
Cell[44268, 1578, 636, 23, 51, "Output",
 CellID->188454025]
}, Open  ]],
Cell[44919, 1604, 121, 3, 70, "ExampleDelimiter",
 CellID->18419],
Cell[45043, 1609, 69, 1, 70, "ExampleText",
 CellID->29949],
Cell[CellGroupData[{
Cell[45137, 1614, 232, 8, 70, "Input",
 CellID->3203],
Cell[45372, 1624, 1286, 42, 84, "Output",
 CellID->172840090]
}, Open  ]],
Cell[CellGroupData[{
Cell[46695, 1671, 194, 6, 70, "Input",
 CellID->233617052],
Cell[46892, 1679, 270, 9, 51, "Output",
 CellID->34528428]
}, Open  ]],
Cell[CellGroupData[{
Cell[47199, 1693, 193, 7, 70, "Input",
 CellID->585337297],
Cell[47395, 1702, 1066, 22, 70, "Output",
 Evaluatable->False,
 CellID->818793936]
}, Open  ]],
Cell[CellGroupData[{
Cell[48498, 1729, 534, 17, 70, "Input",
 CellID->18174327],
Cell[49035, 1748, 1912, 62, 132, "Output",
 CellID->210992142]
}, Open  ]],
Cell[50962, 1813, 121, 3, 70, "ExampleDelimiter",
 CellID->12752],
Cell[51086, 1818, 69, 1, 70, "ExampleText",
 CellID->28709],
Cell[CellGroupData[{
Cell[51180, 1823, 243, 9, 70, "Input",
 CellID->109590014],
Cell[51426, 1834, 420, 15, 51, "Output",
 CellID->14559129]
}, Open  ]],
Cell[CellGroupData[{
Cell[51883, 1854, 170, 5, 70, "Input",
 CellID->430573747],
Cell[52056, 1861, 223, 8, 52, "Output",
 CellID->208561]
}, Open  ]],
Cell[CellGroupData[{
Cell[52316, 1874, 177, 6, 70, "Input",
 CellID->4111],
Cell[52496, 1882, 785, 27, 65, "Output",
 CellID->411094279]
}, Open  ]],
Cell[CellGroupData[{
Cell[53318, 1914, 176, 5, 70, "Input",
 CellID->22461],
Cell[53497, 1921, 185, 6, 36, "Output",
 CellID->3792901]
}, Open  ]],
Cell[53697, 1930, 121, 3, 70, "ExampleDelimiter",
 CellID->10348],
Cell[53821, 1935, 75, 1, 70, "ExampleText",
 CellID->21708],
Cell[CellGroupData[{
Cell[53921, 1940, 253, 8, 70, "Input",
 CellID->22060],
Cell[54177, 1950, 356, 13, 36, "Output",
 CellID->241589487]
}, Open  ]],
Cell[CellGroupData[{
Cell[54570, 1968, 153, 5, 70, "Input",
 CellID->18224],
Cell[54726, 1975, 389, 14, 36, "Output",
 CellID->6768754]
}, Open  ]],
Cell[CellGroupData[{
Cell[55152, 1994, 178, 6, 70, "Input",
 CellID->31891],
Cell[55333, 2002, 2815, 50, 70, "Output",
 Evaluatable->False,
 CellID->122596938]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58197, 2058, 235, 7, 70, "ExampleSubsection",
 CellID->16845],
Cell[58435, 2067, 57, 1, 70, "ExampleText",
 CellID->4509],
Cell[CellGroupData[{
Cell[58517, 2072, 329, 11, 70, "Input",
 CellID->13857],
Cell[58849, 2085, 216, 8, 53, "Output",
 CellID->1322641]
}, Open  ]],
Cell[CellGroupData[{
Cell[59102, 2098, 344, 12, 70, "Input",
 CellID->59272502],
Cell[59449, 2112, 195, 6, 51, "Output",
 CellID->165974874]
}, Open  ]],
Cell[CellGroupData[{
Cell[59681, 2123, 329, 11, 70, "Input",
 CellID->19202],
Cell[60013, 2136, 431, 16, 63, "Output",
 CellID->858683099]
}, Open  ]],
Cell[60459, 2155, 124, 3, 70, "ExampleDelimiter",
 CellID->85192215],
Cell[60586, 2160, 63, 1, 70, "ExampleText",
 CellID->131378107],
Cell[CellGroupData[{
Cell[60674, 2165, 270, 9, 70, "Input",
 CellID->753879101],
Cell[60947, 2176, 178, 6, 51, "Output",
 CellID->118237163]
}, Open  ]],
Cell[CellGroupData[{
Cell[61162, 2187, 433, 15, 70, "Input",
 CellID->323193095],
Cell[61598, 2204, 414, 15, 70, "Output",
 CellID->147866736]
}, Open  ]],
Cell[CellGroupData[{
Cell[62049, 2224, 493, 17, 70, "Input",
 CellID->433504700],
Cell[62545, 2243, 224, 8, 60, "Output",
 CellID->12327946]
}, Open  ]],
Cell[62784, 2254, 121, 3, 70, "ExampleDelimiter",
 CellID->14018],
Cell[62908, 2259, 64, 1, 70, "ExampleText",
 CellID->384340572],
Cell[CellGroupData[{
Cell[62997, 2264, 245, 8, 70, "Input",
 CellID->6460],
Cell[63245, 2274, 675, 22, 51, "Output",
 CellID->95099859]
}, Open  ]],
Cell[CellGroupData[{
Cell[63957, 2301, 322, 11, 70, "Input",
 CellID->17255],
Cell[64282, 2314, 211, 7, 36, "Output",
 CellID->44343488]
}, Open  ]],
Cell[CellGroupData[{
Cell[64530, 2326, 417, 15, 70, "Input",
 CellID->143181692],
Cell[64950, 2343, 241, 8, 49, "Output",
 CellID->589150307]
}, Open  ]],
Cell[CellGroupData[{
Cell[65228, 2356, 328, 11, 70, "Input",
 CellID->43142740],
Cell[65559, 2369, 358, 12, 51, "Output",
 CellID->57952863]
}, Open  ]],
Cell[65932, 2384, 120, 3, 70, "ExampleDelimiter",
 CellID->1067],
Cell[66055, 2389, 57, 1, 70, "ExampleText",
 CellID->24123],
Cell[CellGroupData[{
Cell[66137, 2394, 275, 9, 70, "Input",
 CellID->7918],
Cell[66415, 2405, 205, 7, 54, "Output",
 CellID->55730947]
}, Open  ]],
Cell[CellGroupData[{
Cell[66657, 2417, 248, 8, 70, "Input",
 CellID->2797],
Cell[66908, 2427, 333, 12, 61, "Output",
 CellID->29436968]
}, Open  ]],
Cell[CellGroupData[{
Cell[67278, 2444, 254, 8, 70, "Input",
 CellID->422088865],
Cell[67535, 2454, 278, 10, 51, "Output",
 CellID->344584358]
}, Open  ]],
Cell[CellGroupData[{
Cell[67850, 2469, 309, 10, 70, "Input",
 CellID->286339710],
Cell[68162, 2481, 181, 6, 49, "Output",
 CellID->61942880]
}, Open  ]],
Cell[CellGroupData[{
Cell[68380, 2492, 333, 12, 70, "Input",
 CellID->226509455],
Cell[68716, 2506, 346, 13, 64, "Output",
 CellID->592917535]
}, Open  ]],
Cell[CellGroupData[{
Cell[69099, 2524, 322, 10, 70, "Input",
 CellID->64851977],
Cell[69424, 2536, 208, 7, 51, "Output",
 CellID->268078698]
}, Open  ]],
Cell[69647, 2546, 121, 3, 70, "ExampleDelimiter",
 CellID->30624],
Cell[69771, 2551, 59, 1, 70, "ExampleText",
 CellID->23438],
Cell[CellGroupData[{
Cell[69855, 2556, 326, 11, 70, "Input",
 CellID->8516],
Cell[70184, 2569, 192, 7, 38, "Output",
 CellID->639609570]
}, Open  ]],
Cell[CellGroupData[{
Cell[70413, 2581, 241, 8, 70, "Input",
 CellID->24196],
Cell[70657, 2591, 306, 12, 38, "Output",
 CellID->412503021]
}, Open  ]],
Cell[CellGroupData[{
Cell[71000, 2608, 220, 7, 70, "Input",
 CellID->22683],
Cell[71223, 2617, 161, 5, 36, "Output",
 CellID->193901078]
}, Open  ]],
Cell[CellGroupData[{
Cell[71421, 2627, 436, 14, 70, "Input",
 CellID->96097063],
Cell[71860, 2643, 162, 5, 36, "Output",
 CellID->836076964]
}, Open  ]],
Cell[72037, 2651, 121, 3, 70, "ExampleDelimiter",
 CellID->10601],
Cell[72161, 2656, 93, 1, 70, "ExampleText",
 CellID->3828],
Cell[CellGroupData[{
Cell[72279, 2661, 207, 7, 70, "Input",
 CellID->14161],
Cell[72489, 2670, 641, 21, 51, "Output",
 CellID->163535089]
}, Open  ]],
Cell[CellGroupData[{
Cell[73167, 2696, 267, 9, 70, "Input",
 CellID->31875],
Cell[73437, 2707, 796, 26, 82, "Output",
 CellID->650804743]
}, Open  ]],
Cell[CellGroupData[{
Cell[74270, 2738, 306, 11, 70, "Input",
 CellID->8773],
Cell[74579, 2751, 1193, 38, 82, "Output",
 CellID->158356520]
}, Open  ]],
Cell[75787, 2792, 121, 3, 70, "ExampleDelimiter",
 CellID->21747],
Cell[75911, 2797, 71, 1, 70, "ExampleText",
 CellID->26038],
Cell[CellGroupData[{
Cell[76007, 2802, 411, 13, 70, "Input",
 CellID->13964],
Cell[76421, 2817, 349, 11, 36, "Output",
 CellID->561582741]
}, Open  ]],
Cell[CellGroupData[{
Cell[76807, 2833, 325, 11, 70, "Input",
 CellID->749],
Cell[77135, 2846, 218, 8, 60, "Output",
 CellID->176159408]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[77402, 2860, 239, 7, 70, "ExampleSubsection",
 CellID->15516],
Cell[77644, 2869, 77, 1, 70, "ExampleText",
 CellID->20839],
Cell[CellGroupData[{
Cell[77746, 2874, 472, 17, 70, "Input",
 CellID->16590],
Cell[78221, 2893, 161, 5, 36, "Output",
 CellID->13298948]
}, Open  ]],
Cell[CellGroupData[{
Cell[78419, 2903, 432, 15, 70, "Input",
 CellID->28782],
Cell[78854, 2920, 162, 5, 36, "Output",
 CellID->239499576]
}, Open  ]],
Cell[79031, 2928, 121, 3, 70, "ExampleDelimiter",
 CellID->15995],
Cell[79155, 2933, 82, 1, 70, "ExampleText",
 CellID->110280238],
Cell[CellGroupData[{
Cell[79262, 2938, 542, 19, 70, "Input",
 CellTags->"S3.5.9",
 CellID->4119],
Cell[79807, 2959, 348, 13, 70, "Output",
 CellTags->"S3.5.9",
 CellID->84572356]
}, Open  ]],
Cell[80170, 2975, 123, 3, 70, "ExampleDelimiter",
 CellID->1655280],
Cell[80296, 2980, 112, 3, 70, "ExampleText",
 CellID->885557591],
Cell[CellGroupData[{
Cell[80433, 2987, 654, 21, 70, "Input",
 CellID->1262780],
Cell[81090, 3010, 609, 21, 51, "Output",
 CellID->1432161]
}, Open  ]],
Cell[81714, 3034, 214, 8, 70, "ExampleText",
 CellID->102577523],
Cell[CellGroupData[{
Cell[81953, 3046, 546, 18, 70, "Input",
 CellID->149382696],
Cell[82502, 3066, 3234, 57, 70, "Output",
 Evaluatable->False,
 CellID->519358536]
}, Open  ]],
Cell[85751, 3126, 125, 3, 70, "ExampleDelimiter",
 CellID->566235086],
Cell[85879, 3131, 119, 3, 70, "ExampleText",
 CellID->409460324],
Cell[CellGroupData[{
Cell[86023, 3138, 877, 27, 70, "Input",
 CellID->696959573],
Cell[86903, 3167, 182, 6, 49, "Output",
 CellID->29248248]
}, Open  ]],
Cell[87100, 3176, 218, 8, 70, "ExampleText",
 CellID->516358466],
Cell[CellGroupData[{
Cell[87343, 3188, 594, 19, 70, "Input",
 CellID->990731555],
Cell[87940, 3209, 8126, 137, 70, "Output",
 Evaluatable->False,
 CellID->104250866]
}, Open  ]],
Cell[96081, 3349, 121, 3, 70, "ExampleDelimiter",
 CellID->29916],
Cell[96205, 3354, 112, 3, 70, "ExampleText",
 CellID->24587],
Cell[CellGroupData[{
Cell[96342, 3361, 352, 12, 70, "Input",
 CellTags->"S3.5.9",
 CellID->15021],
Cell[96697, 3375, 938, 20, 70, "Output",
 Evaluatable->False,
 CellTags->"S3.5.9",
 CellID->27179733]
}, Open  ]],
Cell[97650, 3398, 121, 3, 70, "ExampleDelimiter",
 CellID->25533],
Cell[97774, 3403, 66, 1, 70, "ExampleText",
 CellID->24792],
Cell[CellGroupData[{
Cell[97865, 3408, 387, 13, 70, "Input",
 CellID->195932755],
Cell[98255, 3423, 491, 16, 55, "Output",
 CellID->402824683]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[98795, 3445, 247, 7, 70, "ExampleSubsection",
 CellID->11478],
Cell[99045, 3454, 108, 3, 70, "ExampleText",
 CellID->13216],
Cell[CellGroupData[{
Cell[99178, 3461, 288, 10, 70, "Input",
 CellID->30608],
Cell[99469, 3473, 331, 11, 36, "Output",
 CellID->376800506]
}, Open  ]],
Cell[99815, 3487, 121, 3, 70, "ExampleDelimiter",
 CellID->25636],
Cell[99939, 3492, 115, 3, 70, "ExampleText",
 CellID->10343],
Cell[CellGroupData[{
Cell[100079, 3499, 220, 7, 70, "Input",
 CellID->36483299],
Cell[100302, 3508, 298, 10, 50, "Output",
 CellID->389534136]
}, Open  ]],
Cell[CellGroupData[{
Cell[100637, 3523, 125, 4, 70, "Input",
 CellID->137603985],
Cell[100765, 3529, 184, 6, 36, "Output",
 CellID->61778513]
}, Open  ]],
Cell[CellGroupData[{
Cell[100986, 3540, 298, 10, 70, "Input",
 CellID->3690],
Cell[101287, 3552, 382, 13, 53, "Output",
 CellID->826273779]
}, Open  ]],
Cell[CellGroupData[{
Cell[101706, 3570, 116, 4, 70, "Input",
 CellID->15585],
Cell[101825, 3576, 970, 34, 53, "Output",
 CellID->17741268]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[102856, 3617, 239, 7, 70, "ExampleSection",
 CellID->13719],
Cell[103098, 3626, 95, 1, 70, "ExampleText",
 CellID->30203],
Cell[CellGroupData[{
Cell[103218, 3631, 265, 9, 70, "Input",
 CellID->14145],
Cell[103486, 3642, 472, 17, 51, "Output",
 CellID->683552429]
}, Open  ]],
Cell[103973, 3662, 125, 3, 70, "ExampleDelimiter",
 CellID->386341661],
Cell[104101, 3667, 94, 1, 70, "ExampleText",
 CellID->388255457],
Cell[CellGroupData[{
Cell[104220, 3672, 258, 9, 70, "Input",
 CellID->698575728],
Cell[104481, 3683, 257, 9, 51, "Output",
 CellID->69996015]
}, Open  ]],
Cell[104753, 3695, 124, 3, 70, "ExampleDelimiter",
 CellID->73344904],
Cell[104880, 3700, 82, 1, 70, "ExampleText",
 CellID->661722613],
Cell[CellGroupData[{
Cell[104987, 3705, 255, 8, 70, "Input",
 CellID->840817358],
Cell[105245, 3715, 181, 6, 49, "Output",
 CellID->80651662]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[105475, 3727, 217, 7, 70, "ExampleSection",
 CellID->8201],
Cell[CellGroupData[{
Cell[105717, 3738, 228, 7, 70, "ExampleSubsection",
 CellID->12140],
Cell[105948, 3747, 224, 8, 70, "ExampleText",
 CellID->431762547],
Cell[CellGroupData[{
Cell[106197, 3759, 207, 7, 70, "Input",
 CellID->22496],
Cell[106407, 3768, 641, 21, 51, "Output",
 CellID->896325504]
}, Open  ]],
Cell[107063, 3792, 246, 8, 70, "ExampleText",
 CellID->275914128],
Cell[CellGroupData[{
Cell[107334, 3804, 275, 9, 70, "Input",
 CellID->602],
Cell[107612, 3815, 200, 7, 51, "Output",
 CellID->15314712]
}, Open  ]],
Cell[CellGroupData[{
Cell[107849, 3827, 298, 10, 70, "Input",
 CellID->23638],
Cell[108150, 3839, 201, 7, 51, "Output",
 CellID->258140256]
}, Open  ]],
Cell[108366, 3849, 120, 3, 70, "ExampleDelimiter",
 CellID->2206],
Cell[108489, 3854, 115, 3, 70, "ExampleText",
 CellID->456240898],
Cell[CellGroupData[{
Cell[108629, 3861, 242, 9, 70, "Input",
 CellID->5965],
Cell[108874, 3872, 355, 12, 50, "Output",
 CellID->608136096]
}, Open  ]],
Cell[CellGroupData[{
Cell[109266, 3889, 322, 10, 70, "Input",
 CellID->1692],
Cell[109591, 3901, 1159, 23, 70, "Output",
 Evaluatable->False,
 CellID->279461313]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[110799, 3930, 235, 7, 70, "ExampleSubsection",
 CellID->16031],
Cell[CellGroupData[{
Cell[111059, 3941, 293, 10, 70, "Input",
 CellID->29188],
Cell[111355, 3953, 737, 25, 60, "Output",
 CellID->218546328]
}, Open  ]],
Cell[112107, 3981, 135, 4, 70, "ExampleText",
 CellID->12468],
Cell[CellGroupData[{
Cell[112267, 3989, 349, 11, 70, "Input",
 CellID->11348],
Cell[112619, 4002, 230, 9, 60, "Output",
 CellID->612548533]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[112898, 4017, 231, 7, 70, "ExampleSubsection",
 CellID->26228],
Cell[113132, 4026, 91, 1, 70, "ExampleText",
 CellID->20299],
Cell[CellGroupData[{
Cell[113248, 4031, 243, 8, 70, "Input",
 CellID->15965],
Cell[113494, 4041, 409, 8, 70, "Message",
 CellID->694226962],
Cell[113906, 4051, 310, 11, 51, "Output",
 CellID->383326695]
}, Open  ]],
Cell[114231, 4065, 83, 1, 70, "ExampleText",
 CellID->815],
Cell[CellGroupData[{
Cell[114339, 4070, 299, 9, 70, "Input",
 CellID->11872],
Cell[114641, 4081, 185, 6, 36, "Output",
 CellID->6451432]
}, Open  ]],
Cell[114841, 4090, 121, 3, 70, "ExampleDelimiter",
 CellID->26388],
Cell[CellGroupData[{
Cell[114987, 4097, 215, 7, 70, "Input",
 CellID->21204],
Cell[115205, 4106, 398, 7, 70, "Message",
 CellID->12522084],
Cell[115606, 4115, 304, 10, 50, "Output",
 CellID->799906160]
}, Open  ]],
Cell[CellGroupData[{
Cell[115947, 4130, 271, 8, 70, "Input",
 CellID->16025],
Cell[116221, 4140, 158, 5, 36, "Output",
 CellID->221111502]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[116440, 4152, 223, 7, 70, "ExampleSection",
 CellID->32691],
Cell[116666, 4161, 148, 6, 70, "ExampleText",
 CellID->878491540],
Cell[CellGroupData[{
Cell[116839, 4171, 569, 18, 70, "Input",
 CellID->66980954],
Cell[117411, 4191, 207, 7, 36, "Output",
 CellID->67724030]
}, Open  ]],
Cell[117633, 4201, 125, 3, 70, "ExampleDelimiter",
 CellID->122557156],
Cell[117761, 4206, 95, 1, 70, "ExampleText",
 CellID->13140],
Cell[CellGroupData[{
Cell[117881, 4211, 390, 13, 70, "Input",
 CellID->18917],
Cell[118274, 4226, 1395, 44, 82, "Output",
 CellID->842550972]
}, Open  ]],
Cell[CellGroupData[{
Cell[119706, 4275, 682, 22, 70, "Input",
 CellID->113960094],
Cell[120391, 4299, 2203, 40, 70, "Output",
 Evaluatable->False,
 CellID->73833707]
}, Open  ]],
Cell[122609, 4342, 125, 3, 70, "ExampleDelimiter",
 CellID->169598296],
Cell[122737, 4347, 90, 1, 70, "ExampleText",
 CellID->494920001],
Cell[CellGroupData[{
Cell[122852, 4352, 960, 32, 70, "Input",
 CellID->564123354],
Cell[123815, 4386, 231, 8, 54, "Output",
 CellID->215053725]
}, Open  ]],
Cell[124061, 4397, 125, 3, 70, "ExampleDelimiter",
 CellID->437442330],
Cell[124189, 4402, 88, 1, 70, "ExampleText",
 CellID->179079438],
Cell[CellGroupData[{
Cell[124302, 4407, 488, 15, 70, "Input",
 CellID->204391732],
Cell[124793, 4424, 162, 5, 36, "Output",
 CellID->164116856]
}, Open  ]],
Cell[CellGroupData[{
Cell[124992, 4434, 560, 18, 70, "Input",
 CellID->141500547],
Cell[125555, 4454, 188, 6, 36, "Output",
 CellID->288229222]
}, Open  ]],
Cell[125758, 4463, 124, 3, 70, "ExampleDelimiter",
 CellID->48732478],
Cell[125885, 4468, 120, 3, 70, "ExampleText",
 CellID->85303880],
Cell[126008, 4473, 259, 10, 70, "Input",
 CellID->155831190],
Cell[CellGroupData[{
Cell[126292, 4487, 105, 3, 70, "Input",
 CellID->12851194],
Cell[126400, 4492, 9174, 154, 70, "Output",
 Evaluatable->False,
 CellID->36462361]
}, Open  ]],
Cell[CellGroupData[{
Cell[135611, 4651, 159, 5, 70, "Input",
 CellID->271885685],
Cell[135773, 4658, 176, 5, 36, "Output",
 CellID->216684278]
}, Open  ]],
Cell[135964, 4666, 76, 1, 70, "ExampleText",
 CellID->945454037],
Cell[CellGroupData[{
Cell[136065, 4671, 365, 12, 70, "Input",
 CellID->659515735],
Cell[136433, 4685, 299, 11, 51, "Output",
 CellID->492958374]
}, Open  ]],
Cell[CellGroupData[{
Cell[136769, 4701, 96, 3, 70, "Input",
 CellID->74318623],
Cell[136868, 4706, 176, 5, 36, "Output",
 CellID->225810674]
}, Open  ]],
Cell[137059, 4714, 125, 3, 70, "ExampleDelimiter",
 CellID->337381576],
Cell[137187, 4719, 118, 3, 70, "ExampleText",
 CellID->736390212],
Cell[CellGroupData[{
Cell[137330, 4726, 1299, 37, 70, "Input",
 CellID->182388262],
Cell[138632, 4765, 23722, 393, 70, "Output",
 Evaluatable->False,
 CellID->323702281]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[162403, 5164, 233, 7, 70, "ExampleSection",
 CellID->10628],
Cell[162639, 5173, 250, 9, 70, "ExampleText",
 CellID->19981],
Cell[CellGroupData[{
Cell[162914, 5186, 246, 8, 70, "Input",
 CellID->12153],
Cell[163163, 5196, 333, 11, 51, "Output",
 CellID->290928942]
}, Open  ]],
Cell[CellGroupData[{
Cell[163533, 5212, 93, 3, 70, "Input",
 CellID->21504],
Cell[163629, 5217, 176, 5, 36, "Output",
 CellID->24607157]
}, Open  ]],
Cell[CellGroupData[{
Cell[163842, 5227, 250, 8, 70, "Input",
 CellID->54363602],
Cell[164095, 5237, 176, 5, 36, "Output",
 CellID->16723865]
}, Open  ]],
Cell[164286, 5245, 121, 3, 70, "ExampleDelimiter",
 CellID->20813],
Cell[164410, 5250, 91, 1, 70, "ExampleText",
 CellID->516],
Cell[CellGroupData[{
Cell[164526, 5255, 206, 7, 70, "Input",
 CellID->21628],
Cell[164735, 5264, 472, 17, 59, "Output",
 CellID->476971334]
}, Open  ]],
Cell[CellGroupData[{
Cell[165244, 5286, 151, 5, 70, "Input",
 CellID->16106],
Cell[165398, 5293, 392, 14, 59, "Output",
 CellID->75924197]
}, Open  ]],
Cell[165805, 5310, 124, 3, 70, "ExampleDelimiter",
 CellID->70580569],
Cell[165932, 5315, 80, 1, 70, "ExampleText",
 CellID->689119942],
Cell[CellGroupData[{
Cell[166037, 5320, 163, 5, 70, "Input",
 CellID->27595663],
Cell[166203, 5327, 204, 7, 36, "Output",
 CellID->35400196]
}, Open  ]],
Cell[CellGroupData[{
Cell[166444, 5339, 257, 9, 70, "Input",
 CellID->105143827],
Cell[166704, 5350, 419, 14, 36, "Output",
 CellID->195863157]
}, Open  ]],
Cell[167138, 5367, 121, 3, 70, "ExampleDelimiter",
 CellID->17254],
Cell[167262, 5372, 223, 7, 70, "ExampleText",
 CellID->11251],
Cell[CellGroupData[{
Cell[167510, 5383, 233, 8, 70, "Input",
 CellID->17887],
Cell[167746, 5393, 420, 15, 56, "Output",
 CellID->62441421]
}, Open  ]],
Cell[CellGroupData[{
Cell[168203, 5413, 158, 5, 70, "Input",
 CellID->22897],
Cell[168364, 5420, 307, 11, 56, "Output",
 CellID->73671868]
}, Open  ]],
Cell[168686, 5434, 121, 3, 70, "ExampleDelimiter",
 CellID->22536],
Cell[168810, 5439, 72, 1, 70, "ExampleText",
 CellID->27340],
Cell[CellGroupData[{
Cell[168907, 5444, 300, 10, 70, "Input",
 CellID->10226],
Cell[169210, 5456, 288, 10, 51, "Output",
 CellID->149406143]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[169547, 5472, 227, 7, 70, "ExampleSection",
 CellID->10000],
Cell[CellGroupData[{
Cell[169799, 5483, 237, 7, 70, "ExampleSubsection",
 CellID->16604],
Cell[170039, 5492, 135, 4, 70, "ExampleText",
 CellID->12426],
Cell[CellGroupData[{
Cell[170199, 5500, 217, 7, 70, "Input",
 CellID->15225],
Cell[170419, 5509, 323, 11, 53, "Output",
 CellID->269517055]
}, Open  ]],
Cell[170757, 5523, 120, 3, 70, "ExampleDelimiter",
 CellID->7964],
Cell[170880, 5528, 92, 1, 70, "ExampleText",
 CellID->8198],
Cell[CellGroupData[{
Cell[170997, 5533, 243, 8, 70, "Input",
 CellID->21916],
Cell[171243, 5543, 2053, 70, 136, "Output",
 CellID->440346232]
}, Open  ]],
Cell[173311, 5616, 120, 3, 70, "ExampleDelimiter",
 CellID->5124],
Cell[173434, 5621, 137, 4, 70, "ExampleText",
 CellID->4056],
Cell[CellGroupData[{
Cell[173596, 5629, 226, 8, 70, "Input",
 CellID->30422],
Cell[173825, 5639, 424, 16, 51, "Output",
 CellID->604288938]
}, Open  ]],
Cell[CellGroupData[{
Cell[174286, 5660, 116, 4, 70, "Input",
 CellID->31854],
Cell[174405, 5666, 417, 16, 53, "Output",
 CellID->14233035]
}, Open  ]],
Cell[CellGroupData[{
Cell[174859, 5687, 99, 3, 70, "Input",
 CellID->7979],
Cell[174961, 5692, 226, 8, 52, "Output",
 CellID->173996764]
}, Open  ]],
Cell[175202, 5703, 121, 3, 70, "ExampleDelimiter",
 CellID->25021],
Cell[175326, 5708, 146, 4, 70, "ExampleText",
 CellID->31145],
Cell[CellGroupData[{
Cell[175497, 5716, 229, 9, 70, "Input",
 CellID->23787],
Cell[175729, 5727, 301, 11, 51, "Output",
 CellID->233279471]
}, Open  ]],
Cell[CellGroupData[{
Cell[176067, 5743, 266, 10, 70, "Input",
 CellID->5195],
Cell[176336, 5755, 365, 13, 54, "Output",
 CellID->295415402]
}, Open  ]],
Cell[CellGroupData[{
Cell[176738, 5773, 123, 4, 70, "Input",
 CellID->4580],
Cell[176864, 5779, 178, 6, 51, "Output",
 CellID->140994168]
}, Open  ]],
Cell[177057, 5788, 120, 3, 70, "ExampleDelimiter",
 CellID->2013],
Cell[177180, 5793, 126, 4, 70, "ExampleText",
 CellID->9370],
Cell[CellGroupData[{
Cell[177331, 5801, 262, 10, 70, "Input",
 CellID->28836],
Cell[177596, 5813, 262, 10, 53, "Output",
 CellID->139814892]
}, Open  ]],
Cell[CellGroupData[{
Cell[177895, 5828, 262, 10, 70, "Input",
 CellID->10536],
Cell[178160, 5840, 263, 10, 53, "Output",
 CellID->288518799]
}, Open  ]],
Cell[178438, 5853, 120, 3, 70, "ExampleDelimiter",
 CellID->7717],
Cell[178561, 5858, 117, 3, 70, "ExampleText",
 CellID->10625],
Cell[CellGroupData[{
Cell[178703, 5865, 758, 26, 70, "Input",
 CellID->11412],
Cell[179464, 5893, 4678, 81, 70, "Output",
 Evaluatable->False,
 CellID->330705038]
}, Open  ]],
Cell[184157, 5977, 120, 3, 70, "ExampleDelimiter",
 CellID->5808],
Cell[184280, 5982, 194, 6, 70, "ExampleText",
 CellID->29727],
Cell[CellGroupData[{
Cell[184499, 5992, 148, 5, 70, "Input",
 CellID->14911],
Cell[184650, 5999, 249, 9, 54, "Output",
 CellID->280157444]
}, Open  ]],
Cell[CellGroupData[{
Cell[184936, 6013, 168, 6, 70, "Input",
 CellID->23035],
Cell[185107, 6021, 187, 6, 36, "Output",
 CellID->318833784]
}, Open  ]],
Cell[185309, 6030, 93, 1, 70, "ExampleText",
 CellID->261008711],
Cell[CellGroupData[{
Cell[185427, 6035, 211, 7, 70, "Input",
 CellID->466106225],
Cell[185641, 6044, 641, 21, 51, "Output",
 CellID->265376368]
}, Open  ]],
Cell[CellGroupData[{
Cell[186319, 6070, 262, 9, 70, "Input",
 CellID->549388233],
Cell[186584, 6081, 394, 7, 70, "Message",
 CellID->579019971],
Cell[186981, 6090, 291, 10, 51, "Output",
 CellID->458020194]
}, Open  ]],
Cell[187287, 6103, 120, 3, 70, "ExampleDelimiter",
 CellID->6981],
Cell[187410, 6108, 113, 3, 70, "ExampleText",
 CellID->30209],
Cell[CellGroupData[{
Cell[187548, 6115, 185, 6, 70, "Input",
 CellID->8853],
Cell[187736, 6123, 367, 7, 70, "Message",
 CellID->49238446],
Cell[188106, 6132, 300, 10, 50, "Output",
 CellID->87964048]
}, Open  ]],
Cell[188421, 6145, 121, 3, 70, "ExampleDelimiter",
 CellID->19352],
Cell[188545, 6150, 138, 4, 70, "ExampleText",
 CellID->11395],
Cell[CellGroupData[{
Cell[188708, 6158, 229, 8, 70, "Input",
 CellID->21003],
Cell[188940, 6168, 416, 14, 50, "Output",
 CellID->641965545]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[189405, 6188, 235, 7, 70, "ExampleSubsection",
 CellID->11266],
Cell[189643, 6197, 153, 4, 70, "ExampleText",
 CellID->20268],
Cell[CellGroupData[{
Cell[189821, 6205, 314, 11, 70, "Input",
 CellID->21924],
Cell[190138, 6218, 217, 8, 55, "Output",
 CellID->253289812]
}, Open  ]],
Cell[CellGroupData[{
Cell[190392, 6231, 268, 10, 70, "Input",
 CellID->12385],
Cell[190663, 6243, 344, 13, 79, "Output",
 CellID->232997201]
}, Open  ]],
Cell[CellGroupData[{
Cell[191044, 6261, 264, 10, 70, "Input",
 CellID->28127],
Cell[191311, 6273, 158, 5, 36, "Output",
 CellID->176313130]
}, Open  ]],
Cell[191484, 6281, 148, 4, 70, "ExampleText",
 CellID->22329],
Cell[CellGroupData[{
Cell[191657, 6289, 202, 7, 70, "Input",
 CellID->1826],
Cell[191862, 6298, 2506, 45, 70, "Output",
 Evaluatable->False,
 CellID->357073566]
}, Open  ]],
Cell[194383, 6346, 121, 3, 70, "ExampleDelimiter",
 CellID->23539],
Cell[194507, 6351, 233, 8, 70, "ExampleText",
 CellID->26077],
Cell[CellGroupData[{
Cell[194765, 6363, 302, 10, 70, "Input",
 CellID->23182],
Cell[195070, 6375, 507, 18, 53, "Output",
 CellID->83675827]
}, Open  ]],
Cell[CellGroupData[{
Cell[195614, 6398, 102, 3, 70, "Input",
 CellID->32120],
Cell[195719, 6403, 6176, 208, 337, "Output",
 CellID->91084184]
}, Open  ]],
Cell[201910, 6614, 125, 3, 70, "ExampleDelimiter",
 CellID->320842613],
Cell[202038, 6619, 125, 3, 70, "ExampleText",
 CellID->172815536],
Cell[CellGroupData[{
Cell[202188, 6626, 351, 12, 70, "Input",
 CellID->599128460],
Cell[202542, 6640, 405, 14, 52, "Output",
 CellID->16773136]
}, Open  ]],
Cell[CellGroupData[{
Cell[202984, 6659, 355, 12, 70, "Input",
 CellID->533620],
Cell[203342, 6673, 465, 15, 51, "Output",
 CellID->244012747]
}, Open  ]],
Cell[203822, 6691, 120, 3, 70, "ExampleDelimiter",
 CellID->5393],
Cell[203945, 6696, 274, 8, 70, "ExampleText",
 CellID->21556],
Cell[CellGroupData[{
Cell[204244, 6708, 241, 8, 70, "Input",
 CellID->2660],
Cell[204488, 6718, 358, 7, 70, "Message",
 CellID->95904279],
Cell[204849, 6727, 330, 11, 51, "Output",
 CellID->191740649]
}, Open  ]],
Cell[CellGroupData[{
Cell[205216, 6743, 380, 12, 70, "Input",
 CellID->3340],
Cell[205599, 6757, 1912, 81, 124, "Output",
 CellID->77064903]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[207572, 6845, 222, 7, 70, "ExampleSection",
 CellID->294],
Cell[207797, 6854, 65, 1, 70, "ExampleText",
 CellID->476934249],
Cell[CellGroupData[{
Cell[207887, 6859, 540, 18, 70, "Input",
 CellID->524766775],
Cell[208430, 6879, 309, 8, 51, "Output",
 CellID->498927851]
}, Open  ]],
Cell[208754, 6890, 125, 3, 70, "ExampleDelimiter",
 CellID->732632213],
Cell[CellGroupData[{
Cell[208904, 6897, 243, 8, 70, "Input",
 CellID->366309465],
Cell[209150, 6907, 1569, 47, 82, "Output",
 CellID->51711495]
}, Open  ]],
Cell[210734, 6957, 124, 3, 70, "ExampleDelimiter",
 CellID->34908262],
Cell[210861, 6962, 105, 2, 70, "ExampleText",
 CellID->117559170],
Cell[CellGroupData[{
Cell[210991, 6968, 426, 15, 70, "Input",
 CellID->796220854],
Cell[211420, 6985, 207, 7, 54, "Output",
 CellID->511315002]
}, Open  ]],
Cell[211642, 6995, 124, 3, 70, "ExampleDelimiter",
 CellID->88974309],
Cell[211769, 7000, 70, 1, 70, "ExampleText",
 CellID->220590268],
Cell[CellGroupData[{
Cell[211864, 7005, 313, 10, 70, "Input",
 CellID->187837411],
Cell[212180, 7017, 609, 25, 56, "Output",
 CellID->266554654]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[212850, 7049, 311, 9, 70, "SeeAlsoSection",
 CellID->24742],
Cell[213164, 7060, 2425, 89, 70, "SeeAlso",
 CellID->26215]
}, Open  ]],
Cell[CellGroupData[{
Cell[215626, 7154, 314, 9, 70, "TutorialsSection",
 CellID->28415],
Cell[215943, 7165, 190, 4, 70, "Tutorials",
 CellID->82228336],
Cell[216136, 7171, 177, 4, 70, "Tutorials",
 CellID->15492],
Cell[216316, 7177, 133, 3, 70, "Tutorials",
 CellID->10238],
Cell[216452, 7182, 150, 3, 70, "Tutorials",
 CellID->26529],
Cell[216605, 7187, 156, 3, 70, "Tutorials",
 CellID->51756815]
}, Open  ]],
Cell[CellGroupData[{
Cell[216798, 7195, 321, 9, 70, "RelatedLinksSection",
 CellID->26610],
Cell[217122, 7206, 253, 5, 70, "RelatedLinks",
 CellID->6405]
}, Open  ]],
Cell[CellGroupData[{
Cell[217412, 7216, 319, 9, 70, "MoreAboutSection",
 CellID->429565224],
Cell[217734, 7227, 128, 3, 70, "MoreAbout",
 CellID->232532573],
Cell[217865, 7232, 155, 3, 70, "MoreAbout",
 CellID->491084449],
Cell[218023, 7237, 153, 3, 70, "MoreAbout",
 CellID->131003489],
Cell[218179, 7242, 136, 3, 70, "MoreAbout",
 CellID->670045886],
Cell[218318, 7247, 148, 3, 70, "MoreAbout",
 CellID->79069591],
Cell[218469, 7252, 151, 3, 70, "MoreAbout",
 CellID->334197213],
Cell[218623, 7257, 146, 3, 70, "MoreAbout",
 CellID->11898685],
Cell[218772, 7262, 145, 3, 70, "MoreAbout",
 CellID->694029225]
}, Open  ]],
Cell[218932, 7268, 50, 0, 70, "History"],
Cell[218985, 7270, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

